<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRequest_Customer_Activity_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ContactRequest_Customer_Activity_DataObjectType extends AbstractStructBase
{
    /**
     * The cca_key
     * Meta information extracted from the WSDL
     * - documentation: Activity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_key = null;
    /**
     * The cca_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_cst_key = null;
    /**
     * The cca_type
     * Meta information extracted from the WSDL
     * - documentation: Activity Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_type = null;
    /**
     * The cca_date
     * Meta information extracted from the WSDL
     * - documentation: Activity Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_date = null;
    /**
     * The cca_description
     * Meta information extracted from the WSDL
     * - documentation: Activity Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_description = null;
    /**
     * The cca_type_key
     * Meta information extracted from the WSDL
     * - documentation: Activity Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_type_key = null;
    /**
     * The cca_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_add_user = null;
    /**
     * The cca_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_add_date = null;
    /**
     * The cca_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_change_date = null;
    /**
     * The cca_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_change_user = null;
    /**
     * The cca_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_delete_flag = null;
    /**
     * The cca_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Communication Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_comm_meth = null;
    /**
     * The cca_acd_key
     * Meta information extracted from the WSDL
     * - documentation: Call Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_acd_key = null;
    /**
     * The cca_comm_value
     * Meta information extracted from the WSDL
     * - documentation: Destination. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_comm_value = null;
    /**
     * The cca_acd_obj_key_value
     * Meta information extracted from the WSDL
     * - documentation: Call Detail Object Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_acd_obj_key_value = null;
    /**
     * The cca_type_value
     * Meta information extracted from the WSDL
     * - documentation: Activity Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_type_value = null;
    /**
     * The cca_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_entity_key = null;
    /**
     * The cca_emr_key
     * Meta information extracted from the WSDL
     * - documentation: Resend After Error Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_emr_key = null;
    /**
     * The cca_comm_desc
     * Meta information extracted from the WSDL
     * - documentation: Comm Desc. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_comm_desc = null;
    /**
     * The cca_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_key_ext = null;
    /**
     * The cca_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_cct_key = null;
    /**
     * The cca_msj_key
     * Meta information extracted from the WSDL
     * - documentation: Messaging Job Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cca_msj_key = null;
    /**
     * The cca_subject
     * Meta information extracted from the WSDL
     * - documentation: subject. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_subject = null;
    /**
     * The cca_open_flag
     * Meta information extracted from the WSDL
     * - documentation: Opened. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cca_open_flag = null;
    /**
     * Constructor method for ContactRequest_Customer_Activity_DataObjectType
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_key()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_cst_key()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_type()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_date()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_description()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_type_key()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_add_user()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_add_date()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_change_date()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_change_user()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_delete_flag()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_comm_meth()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_acd_key()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_comm_value()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_acd_obj_key_value()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_type_value()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_entity_key()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_emr_key()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_comm_desc()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_key_ext()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_cct_key()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_msj_key()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_subject()
     * @uses ContactRequest_Customer_Activity_DataObjectType::setCca_open_flag()
     * @param string $cca_key
     * @param string $cca_cst_key
     * @param string $cca_type
     * @param string $cca_date
     * @param string $cca_description
     * @param string $cca_type_key
     * @param string $cca_add_user
     * @param string $cca_add_date
     * @param string $cca_change_date
     * @param string $cca_change_user
     * @param string $cca_delete_flag
     * @param string $cca_comm_meth
     * @param string $cca_acd_key
     * @param string $cca_comm_value
     * @param string $cca_acd_obj_key_value
     * @param string $cca_type_value
     * @param string $cca_entity_key
     * @param string $cca_emr_key
     * @param string $cca_comm_desc
     * @param string $cca_key_ext
     * @param string $cca_cct_key
     * @param string $cca_msj_key
     * @param string $cca_subject
     * @param string $cca_open_flag
     */
    public function __construct(?string $cca_key = null, ?string $cca_cst_key = null, ?string $cca_type = null, ?string $cca_date = null, ?string $cca_description = null, ?string $cca_type_key = null, ?string $cca_add_user = null, ?string $cca_add_date = null, ?string $cca_change_date = null, ?string $cca_change_user = null, ?string $cca_delete_flag = null, ?string $cca_comm_meth = null, ?string $cca_acd_key = null, ?string $cca_comm_value = null, ?string $cca_acd_obj_key_value = null, ?string $cca_type_value = null, ?string $cca_entity_key = null, ?string $cca_emr_key = null, ?string $cca_comm_desc = null, ?string $cca_key_ext = null, ?string $cca_cct_key = null, ?string $cca_msj_key = null, ?string $cca_subject = null, ?string $cca_open_flag = null)
    {
        $this
            ->setCca_key($cca_key)
            ->setCca_cst_key($cca_cst_key)
            ->setCca_type($cca_type)
            ->setCca_date($cca_date)
            ->setCca_description($cca_description)
            ->setCca_type_key($cca_type_key)
            ->setCca_add_user($cca_add_user)
            ->setCca_add_date($cca_add_date)
            ->setCca_change_date($cca_change_date)
            ->setCca_change_user($cca_change_user)
            ->setCca_delete_flag($cca_delete_flag)
            ->setCca_comm_meth($cca_comm_meth)
            ->setCca_acd_key($cca_acd_key)
            ->setCca_comm_value($cca_comm_value)
            ->setCca_acd_obj_key_value($cca_acd_obj_key_value)
            ->setCca_type_value($cca_type_value)
            ->setCca_entity_key($cca_entity_key)
            ->setCca_emr_key($cca_emr_key)
            ->setCca_comm_desc($cca_comm_desc)
            ->setCca_key_ext($cca_key_ext)
            ->setCca_cct_key($cca_cct_key)
            ->setCca_msj_key($cca_msj_key)
            ->setCca_subject($cca_subject)
            ->setCca_open_flag($cca_open_flag);
    }
    /**
     * Get cca_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_key(): ?string
    {
        return $this->cca_key ?? null;
    }
    /**
     * Set cca_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_key(?string $cca_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_key) && !is_string($cca_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_key, true), gettype($cca_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_key, true)), __LINE__);
        }
        if (is_null($cca_key) || (is_array($cca_key) && empty($cca_key))) {
            unset($this->cca_key);
        } else {
            $this->cca_key = $cca_key;
        }
        
        return $this;
    }
    /**
     * Get cca_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_cst_key(): ?string
    {
        return $this->cca_cst_key ?? null;
    }
    /**
     * Set cca_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_cst_key(?string $cca_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_cst_key) && !is_string($cca_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_cst_key, true), gettype($cca_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_cst_key, true)), __LINE__);
        }
        if (is_null($cca_cst_key) || (is_array($cca_cst_key) && empty($cca_cst_key))) {
            unset($this->cca_cst_key);
        } else {
            $this->cca_cst_key = $cca_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cca_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_type(): ?string
    {
        return $this->cca_type ?? null;
    }
    /**
     * Set cca_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_type(?string $cca_type = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_type) && !is_string($cca_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_type, true), gettype($cca_type)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cca_type) && mb_strlen((string) $cca_type) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cca_type)), __LINE__);
        }
        if (is_null($cca_type) || (is_array($cca_type) && empty($cca_type))) {
            unset($this->cca_type);
        } else {
            $this->cca_type = $cca_type;
        }
        
        return $this;
    }
    /**
     * Get cca_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_date(): ?string
    {
        return $this->cca_date ?? null;
    }
    /**
     * Set cca_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_date(?string $cca_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_date) && !is_string($cca_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_date, true), gettype($cca_date)), __LINE__);
        }
        if (is_null($cca_date) || (is_array($cca_date) && empty($cca_date))) {
            unset($this->cca_date);
        } else {
            $this->cca_date = $cca_date;
        }
        
        return $this;
    }
    /**
     * Get cca_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_description(): ?string
    {
        return $this->cca_description ?? null;
    }
    /**
     * Set cca_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_description(?string $cca_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_description) && !is_string($cca_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_description, true), gettype($cca_description)), __LINE__);
        }
        if (is_null($cca_description) || (is_array($cca_description) && empty($cca_description))) {
            unset($this->cca_description);
        } else {
            $this->cca_description = $cca_description;
        }
        
        return $this;
    }
    /**
     * Get cca_type_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_type_key(): ?string
    {
        return $this->cca_type_key ?? null;
    }
    /**
     * Set cca_type_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_type_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_type_key(?string $cca_type_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_type_key) && !is_string($cca_type_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_type_key, true), gettype($cca_type_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_type_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_type_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_type_key, true)), __LINE__);
        }
        if (is_null($cca_type_key) || (is_array($cca_type_key) && empty($cca_type_key))) {
            unset($this->cca_type_key);
        } else {
            $this->cca_type_key = $cca_type_key;
        }
        
        return $this;
    }
    /**
     * Get cca_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_add_user(): ?string
    {
        return $this->cca_add_user ?? null;
    }
    /**
     * Set cca_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_add_user(?string $cca_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_add_user) && !is_string($cca_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_add_user, true), gettype($cca_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cca_add_user) && mb_strlen((string) $cca_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cca_add_user)), __LINE__);
        }
        if (is_null($cca_add_user) || (is_array($cca_add_user) && empty($cca_add_user))) {
            unset($this->cca_add_user);
        } else {
            $this->cca_add_user = $cca_add_user;
        }
        
        return $this;
    }
    /**
     * Get cca_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_add_date(): ?string
    {
        return $this->cca_add_date ?? null;
    }
    /**
     * Set cca_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_add_date(?string $cca_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_add_date) && !is_string($cca_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_add_date, true), gettype($cca_add_date)), __LINE__);
        }
        if (is_null($cca_add_date) || (is_array($cca_add_date) && empty($cca_add_date))) {
            unset($this->cca_add_date);
        } else {
            $this->cca_add_date = $cca_add_date;
        }
        
        return $this;
    }
    /**
     * Get cca_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_change_date(): ?string
    {
        return $this->cca_change_date ?? null;
    }
    /**
     * Set cca_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_change_date(?string $cca_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_change_date) && !is_string($cca_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_change_date, true), gettype($cca_change_date)), __LINE__);
        }
        if (is_null($cca_change_date) || (is_array($cca_change_date) && empty($cca_change_date))) {
            unset($this->cca_change_date);
        } else {
            $this->cca_change_date = $cca_change_date;
        }
        
        return $this;
    }
    /**
     * Get cca_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_change_user(): ?string
    {
        return $this->cca_change_user ?? null;
    }
    /**
     * Set cca_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_change_user(?string $cca_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_change_user) && !is_string($cca_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_change_user, true), gettype($cca_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cca_change_user) && mb_strlen((string) $cca_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cca_change_user)), __LINE__);
        }
        if (is_null($cca_change_user) || (is_array($cca_change_user) && empty($cca_change_user))) {
            unset($this->cca_change_user);
        } else {
            $this->cca_change_user = $cca_change_user;
        }
        
        return $this;
    }
    /**
     * Get cca_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_delete_flag(): ?string
    {
        return $this->cca_delete_flag ?? null;
    }
    /**
     * Set cca_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_delete_flag(?string $cca_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_delete_flag) && !is_string($cca_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_delete_flag, true), gettype($cca_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cca_delete_flag) && $cca_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cca_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cca_delete_flag) && $cca_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cca_delete_flag, true)), __LINE__);
        }
        if (is_null($cca_delete_flag) || (is_array($cca_delete_flag) && empty($cca_delete_flag))) {
            unset($this->cca_delete_flag);
        } else {
            $this->cca_delete_flag = $cca_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cca_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_comm_meth(): ?string
    {
        return $this->cca_comm_meth ?? null;
    }
    /**
     * Set cca_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_comm_meth(?string $cca_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_comm_meth) && !is_string($cca_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_comm_meth, true), gettype($cca_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cca_comm_meth) && mb_strlen((string) $cca_comm_meth) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cca_comm_meth)), __LINE__);
        }
        if (is_null($cca_comm_meth) || (is_array($cca_comm_meth) && empty($cca_comm_meth))) {
            unset($this->cca_comm_meth);
        } else {
            $this->cca_comm_meth = $cca_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get cca_acd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_acd_key(): ?string
    {
        return $this->cca_acd_key ?? null;
    }
    /**
     * Set cca_acd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_acd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_acd_key(?string $cca_acd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_acd_key) && !is_string($cca_acd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_acd_key, true), gettype($cca_acd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_acd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_acd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_acd_key, true)), __LINE__);
        }
        if (is_null($cca_acd_key) || (is_array($cca_acd_key) && empty($cca_acd_key))) {
            unset($this->cca_acd_key);
        } else {
            $this->cca_acd_key = $cca_acd_key;
        }
        
        return $this;
    }
    /**
     * Get cca_comm_value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_comm_value(): ?string
    {
        return $this->cca_comm_value ?? null;
    }
    /**
     * Set cca_comm_value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_comm_value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_comm_value(?string $cca_comm_value = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_comm_value) && !is_string($cca_comm_value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_comm_value, true), gettype($cca_comm_value)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($cca_comm_value) && mb_strlen((string) $cca_comm_value) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $cca_comm_value)), __LINE__);
        }
        if (is_null($cca_comm_value) || (is_array($cca_comm_value) && empty($cca_comm_value))) {
            unset($this->cca_comm_value);
        } else {
            $this->cca_comm_value = $cca_comm_value;
        }
        
        return $this;
    }
    /**
     * Get cca_acd_obj_key_value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_acd_obj_key_value(): ?string
    {
        return $this->cca_acd_obj_key_value ?? null;
    }
    /**
     * Set cca_acd_obj_key_value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_acd_obj_key_value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_acd_obj_key_value(?string $cca_acd_obj_key_value = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_acd_obj_key_value) && !is_string($cca_acd_obj_key_value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_acd_obj_key_value, true), gettype($cca_acd_obj_key_value)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_acd_obj_key_value) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_acd_obj_key_value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_acd_obj_key_value, true)), __LINE__);
        }
        if (is_null($cca_acd_obj_key_value) || (is_array($cca_acd_obj_key_value) && empty($cca_acd_obj_key_value))) {
            unset($this->cca_acd_obj_key_value);
        } else {
            $this->cca_acd_obj_key_value = $cca_acd_obj_key_value;
        }
        
        return $this;
    }
    /**
     * Get cca_type_value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_type_value(): ?string
    {
        return $this->cca_type_value ?? null;
    }
    /**
     * Set cca_type_value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_type_value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_type_value(?string $cca_type_value = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_type_value) && !is_string($cca_type_value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_type_value, true), gettype($cca_type_value)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cca_type_value) && mb_strlen((string) $cca_type_value) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cca_type_value)), __LINE__);
        }
        if (is_null($cca_type_value) || (is_array($cca_type_value) && empty($cca_type_value))) {
            unset($this->cca_type_value);
        } else {
            $this->cca_type_value = $cca_type_value;
        }
        
        return $this;
    }
    /**
     * Get cca_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_entity_key(): ?string
    {
        return $this->cca_entity_key ?? null;
    }
    /**
     * Set cca_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_entity_key(?string $cca_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_entity_key) && !is_string($cca_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_entity_key, true), gettype($cca_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_entity_key, true)), __LINE__);
        }
        if (is_null($cca_entity_key) || (is_array($cca_entity_key) && empty($cca_entity_key))) {
            unset($this->cca_entity_key);
        } else {
            $this->cca_entity_key = $cca_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cca_emr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_emr_key(): ?string
    {
        return $this->cca_emr_key ?? null;
    }
    /**
     * Set cca_emr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_emr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_emr_key(?string $cca_emr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_emr_key) && !is_string($cca_emr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_emr_key, true), gettype($cca_emr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_emr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_emr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_emr_key, true)), __LINE__);
        }
        if (is_null($cca_emr_key) || (is_array($cca_emr_key) && empty($cca_emr_key))) {
            unset($this->cca_emr_key);
        } else {
            $this->cca_emr_key = $cca_emr_key;
        }
        
        return $this;
    }
    /**
     * Get cca_comm_desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_comm_desc(): ?string
    {
        return $this->cca_comm_desc ?? null;
    }
    /**
     * Set cca_comm_desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_comm_desc
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_comm_desc(?string $cca_comm_desc = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_comm_desc) && !is_string($cca_comm_desc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_comm_desc, true), gettype($cca_comm_desc)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($cca_comm_desc) && mb_strlen((string) $cca_comm_desc) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $cca_comm_desc)), __LINE__);
        }
        if (is_null($cca_comm_desc) || (is_array($cca_comm_desc) && empty($cca_comm_desc))) {
            unset($this->cca_comm_desc);
        } else {
            $this->cca_comm_desc = $cca_comm_desc;
        }
        
        return $this;
    }
    /**
     * Get cca_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_key_ext(): ?string
    {
        return $this->cca_key_ext ?? null;
    }
    /**
     * Set cca_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_key_ext(?string $cca_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_key_ext) && !is_string($cca_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_key_ext, true), gettype($cca_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_key_ext, true)), __LINE__);
        }
        if (is_null($cca_key_ext) || (is_array($cca_key_ext) && empty($cca_key_ext))) {
            unset($this->cca_key_ext);
        } else {
            $this->cca_key_ext = $cca_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cca_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_cct_key(): ?string
    {
        return $this->cca_cct_key ?? null;
    }
    /**
     * Set cca_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_cct_key(?string $cca_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_cct_key) && !is_string($cca_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_cct_key, true), gettype($cca_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_cct_key, true)), __LINE__);
        }
        if (is_null($cca_cct_key) || (is_array($cca_cct_key) && empty($cca_cct_key))) {
            unset($this->cca_cct_key);
        } else {
            $this->cca_cct_key = $cca_cct_key;
        }
        
        return $this;
    }
    /**
     * Get cca_msj_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_msj_key(): ?string
    {
        return $this->cca_msj_key ?? null;
    }
    /**
     * Set cca_msj_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_msj_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_msj_key(?string $cca_msj_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_msj_key) && !is_string($cca_msj_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_msj_key, true), gettype($cca_msj_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cca_msj_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cca_msj_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cca_msj_key, true)), __LINE__);
        }
        if (is_null($cca_msj_key) || (is_array($cca_msj_key) && empty($cca_msj_key))) {
            unset($this->cca_msj_key);
        } else {
            $this->cca_msj_key = $cca_msj_key;
        }
        
        return $this;
    }
    /**
     * Get cca_subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_subject(): ?string
    {
        return $this->cca_subject ?? null;
    }
    /**
     * Set cca_subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_subject
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_subject(?string $cca_subject = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_subject) && !is_string($cca_subject)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_subject, true), gettype($cca_subject)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($cca_subject) && mb_strlen((string) $cca_subject) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $cca_subject)), __LINE__);
        }
        if (is_null($cca_subject) || (is_array($cca_subject) && empty($cca_subject))) {
            unset($this->cca_subject);
        } else {
            $this->cca_subject = $cca_subject;
        }
        
        return $this;
    }
    /**
     * Get cca_open_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCca_open_flag(): ?string
    {
        return $this->cca_open_flag ?? null;
    }
    /**
     * Set cca_open_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cca_open_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
     */
    public function setCca_open_flag(?string $cca_open_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cca_open_flag) && !is_string($cca_open_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cca_open_flag, true), gettype($cca_open_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cca_open_flag) && $cca_open_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cca_open_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cca_open_flag) && $cca_open_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cca_open_flag, true)), __LINE__);
        }
        if (is_null($cca_open_flag) || (is_array($cca_open_flag) && empty($cca_open_flag))) {
            unset($this->cca_open_flag);
        } else {
            $this->cca_open_flag = $cca_open_flag;
        }
        
        return $this;
    }
}
