<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRequest_Document_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ContactRequest_Document_DataObjectType extends AbstractStructBase
{
    /**
     * The doc_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $doc_key = null;
    /**
     * The doc_number
     * Meta information extracted from the WSDL
     * - documentation: Document Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_number = null;
    /**
     * The doc_summary
     * Meta information extracted from the WSDL
     * - documentation: Document Summary. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_summary = null;
    /**
     * The doc_description
     * Meta information extracted from the WSDL
     * - documentation: Document Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_description = null;
    /**
     * The doc_url
     * Meta information extracted from the WSDL
     * - documentation: Url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_url = null;
    /**
     * The doc_file_name
     * Meta information extracted from the WSDL
     * - documentation: File Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_file_name = null;
    /**
     * The doc_display_name
     * Meta information extracted from the WSDL
     * - documentation: Display Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_display_name = null;
    /**
     * The doc_distrib_email_flag
     * Meta information extracted from the WSDL
     * - documentation: Send via e-mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_distrib_email_flag = null;
    /**
     * The doc_distrib_fax_flag
     * Meta information extracted from the WSDL
     * - documentation: Send via fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_distrib_fax_flag = null;
    /**
     * The doc_distrib_mail_flag
     * Meta information extracted from the WSDL
     * - documentation: Send via regular mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_distrib_mail_flag = null;
    /**
     * The doc_distrib_online_flag
     * Meta information extracted from the WSDL
     * - documentation: Send web link. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_distrib_online_flag = null;
    /**
     * The doc_send_always_flag
     * Meta information extracted from the WSDL
     * - documentation: Send Always. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_send_always_flag = null;
    /**
     * The doc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_add_date = null;
    /**
     * The doc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_add_user = null;
    /**
     * The doc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_change_date = null;
    /**
     * The doc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_change_user = null;
    /**
     * The doc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_delete_flag = null;
    /**
     * The doc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $doc_key_ext = null;
    /**
     * The doc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $doc_entity_key = null;
    /**
     * The doc_author
     * Meta information extracted from the WSDL
     * - documentation: Author. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_author = null;
    /**
     * The doc_source
     * Meta information extracted from the WSDL
     * - documentation: Document Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_source = null;
    /**
     * The doc_category
     * Meta information extracted from the WSDL
     * - documentation: Category. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_category = null;
    /**
     * The doc_allow_search
     * Meta information extracted from the WSDL
     * - documentation: Allow Search. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_allow_search = null;
    /**
     * The doc_text
     * Meta information extracted from the WSDL
     * - documentation: Document Text. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_text = null;
    /**
     * The doc_original_doc_key
     * Meta information extracted from the WSDL
     * - documentation: Original Version Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $doc_original_doc_key = null;
    /**
     * The doc_type
     * Meta information extracted from the WSDL
     * - documentation: Document Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_type = null;
    /**
     * The doc_security_level
     * Meta information extracted from the WSDL
     * - documentation: doc_security_level. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $doc_security_level = null;
    /**
     * Constructor method for ContactRequest_Document_DataObjectType
     * @uses ContactRequest_Document_DataObjectType::setDoc_key()
     * @uses ContactRequest_Document_DataObjectType::setDoc_number()
     * @uses ContactRequest_Document_DataObjectType::setDoc_summary()
     * @uses ContactRequest_Document_DataObjectType::setDoc_description()
     * @uses ContactRequest_Document_DataObjectType::setDoc_url()
     * @uses ContactRequest_Document_DataObjectType::setDoc_file_name()
     * @uses ContactRequest_Document_DataObjectType::setDoc_display_name()
     * @uses ContactRequest_Document_DataObjectType::setDoc_distrib_email_flag()
     * @uses ContactRequest_Document_DataObjectType::setDoc_distrib_fax_flag()
     * @uses ContactRequest_Document_DataObjectType::setDoc_distrib_mail_flag()
     * @uses ContactRequest_Document_DataObjectType::setDoc_distrib_online_flag()
     * @uses ContactRequest_Document_DataObjectType::setDoc_send_always_flag()
     * @uses ContactRequest_Document_DataObjectType::setDoc_add_date()
     * @uses ContactRequest_Document_DataObjectType::setDoc_add_user()
     * @uses ContactRequest_Document_DataObjectType::setDoc_change_date()
     * @uses ContactRequest_Document_DataObjectType::setDoc_change_user()
     * @uses ContactRequest_Document_DataObjectType::setDoc_delete_flag()
     * @uses ContactRequest_Document_DataObjectType::setDoc_key_ext()
     * @uses ContactRequest_Document_DataObjectType::setDoc_entity_key()
     * @uses ContactRequest_Document_DataObjectType::setDoc_author()
     * @uses ContactRequest_Document_DataObjectType::setDoc_source()
     * @uses ContactRequest_Document_DataObjectType::setDoc_category()
     * @uses ContactRequest_Document_DataObjectType::setDoc_allow_search()
     * @uses ContactRequest_Document_DataObjectType::setDoc_text()
     * @uses ContactRequest_Document_DataObjectType::setDoc_original_doc_key()
     * @uses ContactRequest_Document_DataObjectType::setDoc_type()
     * @uses ContactRequest_Document_DataObjectType::setDoc_security_level()
     * @param string $doc_key
     * @param string $doc_number
     * @param string $doc_summary
     * @param string $doc_description
     * @param string $doc_url
     * @param string $doc_file_name
     * @param string $doc_display_name
     * @param string $doc_distrib_email_flag
     * @param string $doc_distrib_fax_flag
     * @param string $doc_distrib_mail_flag
     * @param string $doc_distrib_online_flag
     * @param string $doc_send_always_flag
     * @param string $doc_add_date
     * @param string $doc_add_user
     * @param string $doc_change_date
     * @param string $doc_change_user
     * @param string $doc_delete_flag
     * @param string $doc_key_ext
     * @param string $doc_entity_key
     * @param string $doc_author
     * @param string $doc_source
     * @param string $doc_category
     * @param string $doc_allow_search
     * @param string $doc_text
     * @param string $doc_original_doc_key
     * @param string $doc_type
     * @param string $doc_security_level
     */
    public function __construct(?string $doc_key = null, ?string $doc_number = null, ?string $doc_summary = null, ?string $doc_description = null, ?string $doc_url = null, ?string $doc_file_name = null, ?string $doc_display_name = null, ?string $doc_distrib_email_flag = null, ?string $doc_distrib_fax_flag = null, ?string $doc_distrib_mail_flag = null, ?string $doc_distrib_online_flag = null, ?string $doc_send_always_flag = null, ?string $doc_add_date = null, ?string $doc_add_user = null, ?string $doc_change_date = null, ?string $doc_change_user = null, ?string $doc_delete_flag = null, ?string $doc_key_ext = null, ?string $doc_entity_key = null, ?string $doc_author = null, ?string $doc_source = null, ?string $doc_category = null, ?string $doc_allow_search = null, ?string $doc_text = null, ?string $doc_original_doc_key = null, ?string $doc_type = null, ?string $doc_security_level = null)
    {
        $this
            ->setDoc_key($doc_key)
            ->setDoc_number($doc_number)
            ->setDoc_summary($doc_summary)
            ->setDoc_description($doc_description)
            ->setDoc_url($doc_url)
            ->setDoc_file_name($doc_file_name)
            ->setDoc_display_name($doc_display_name)
            ->setDoc_distrib_email_flag($doc_distrib_email_flag)
            ->setDoc_distrib_fax_flag($doc_distrib_fax_flag)
            ->setDoc_distrib_mail_flag($doc_distrib_mail_flag)
            ->setDoc_distrib_online_flag($doc_distrib_online_flag)
            ->setDoc_send_always_flag($doc_send_always_flag)
            ->setDoc_add_date($doc_add_date)
            ->setDoc_add_user($doc_add_user)
            ->setDoc_change_date($doc_change_date)
            ->setDoc_change_user($doc_change_user)
            ->setDoc_delete_flag($doc_delete_flag)
            ->setDoc_key_ext($doc_key_ext)
            ->setDoc_entity_key($doc_entity_key)
            ->setDoc_author($doc_author)
            ->setDoc_source($doc_source)
            ->setDoc_category($doc_category)
            ->setDoc_allow_search($doc_allow_search)
            ->setDoc_text($doc_text)
            ->setDoc_original_doc_key($doc_original_doc_key)
            ->setDoc_type($doc_type)
            ->setDoc_security_level($doc_security_level);
    }
    /**
     * Get doc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_key(): ?string
    {
        return $this->doc_key ?? null;
    }
    /**
     * Set doc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_key(?string $doc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_key) && !is_string($doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_key, true), gettype($doc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($doc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($doc_key, true)), __LINE__);
        }
        if (is_null($doc_key) || (is_array($doc_key) && empty($doc_key))) {
            unset($this->doc_key);
        } else {
            $this->doc_key = $doc_key;
        }
        
        return $this;
    }
    /**
     * Get doc_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_number(): ?string
    {
        return $this->doc_number ?? null;
    }
    /**
     * Set doc_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_number(?string $doc_number = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_number) && !is_string($doc_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_number, true), gettype($doc_number)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($doc_number) && mb_strlen((string) $doc_number) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $doc_number)), __LINE__);
        }
        if (is_null($doc_number) || (is_array($doc_number) && empty($doc_number))) {
            unset($this->doc_number);
        } else {
            $this->doc_number = $doc_number;
        }
        
        return $this;
    }
    /**
     * Get doc_summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_summary(): ?string
    {
        return $this->doc_summary ?? null;
    }
    /**
     * Set doc_summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_summary
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_summary(?string $doc_summary = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_summary) && !is_string($doc_summary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_summary, true), gettype($doc_summary)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($doc_summary) && mb_strlen((string) $doc_summary) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $doc_summary)), __LINE__);
        }
        if (is_null($doc_summary) || (is_array($doc_summary) && empty($doc_summary))) {
            unset($this->doc_summary);
        } else {
            $this->doc_summary = $doc_summary;
        }
        
        return $this;
    }
    /**
     * Get doc_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_description(): ?string
    {
        return $this->doc_description ?? null;
    }
    /**
     * Set doc_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_description(?string $doc_description = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_description) && !is_string($doc_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_description, true), gettype($doc_description)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($doc_description) && mb_strlen((string) $doc_description) > 500) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen((string) $doc_description)), __LINE__);
        }
        if (is_null($doc_description) || (is_array($doc_description) && empty($doc_description))) {
            unset($this->doc_description);
        } else {
            $this->doc_description = $doc_description;
        }
        
        return $this;
    }
    /**
     * Get doc_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_url(): ?string
    {
        return $this->doc_url ?? null;
    }
    /**
     * Set doc_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_url
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_url(?string $doc_url = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_url) && !is_string($doc_url)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_url, true), gettype($doc_url)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($doc_url) && mb_strlen((string) $doc_url) > 1000) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen((string) $doc_url)), __LINE__);
        }
        if (is_null($doc_url) || (is_array($doc_url) && empty($doc_url))) {
            unset($this->doc_url);
        } else {
            $this->doc_url = $doc_url;
        }
        
        return $this;
    }
    /**
     * Get doc_file_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_file_name(): ?string
    {
        return $this->doc_file_name ?? null;
    }
    /**
     * Set doc_file_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_file_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_file_name(?string $doc_file_name = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_file_name) && !is_string($doc_file_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_file_name, true), gettype($doc_file_name)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($doc_file_name) && mb_strlen((string) $doc_file_name) > 1000) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen((string) $doc_file_name)), __LINE__);
        }
        if (is_null($doc_file_name) || (is_array($doc_file_name) && empty($doc_file_name))) {
            unset($this->doc_file_name);
        } else {
            $this->doc_file_name = $doc_file_name;
        }
        
        return $this;
    }
    /**
     * Get doc_display_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_display_name(): ?string
    {
        return $this->doc_display_name ?? null;
    }
    /**
     * Set doc_display_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_display_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_display_name(?string $doc_display_name = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_display_name) && !is_string($doc_display_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_display_name, true), gettype($doc_display_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($doc_display_name) && mb_strlen((string) $doc_display_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $doc_display_name)), __LINE__);
        }
        if (is_null($doc_display_name) || (is_array($doc_display_name) && empty($doc_display_name))) {
            unset($this->doc_display_name);
        } else {
            $this->doc_display_name = $doc_display_name;
        }
        
        return $this;
    }
    /**
     * Get doc_distrib_email_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_distrib_email_flag(): ?string
    {
        return $this->doc_distrib_email_flag ?? null;
    }
    /**
     * Set doc_distrib_email_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_distrib_email_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_distrib_email_flag(?string $doc_distrib_email_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_distrib_email_flag) && !is_string($doc_distrib_email_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_distrib_email_flag, true), gettype($doc_distrib_email_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($doc_distrib_email_flag) && $doc_distrib_email_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($doc_distrib_email_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($doc_distrib_email_flag) && $doc_distrib_email_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($doc_distrib_email_flag, true)), __LINE__);
        }
        if (is_null($doc_distrib_email_flag) || (is_array($doc_distrib_email_flag) && empty($doc_distrib_email_flag))) {
            unset($this->doc_distrib_email_flag);
        } else {
            $this->doc_distrib_email_flag = $doc_distrib_email_flag;
        }
        
        return $this;
    }
    /**
     * Get doc_distrib_fax_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_distrib_fax_flag(): ?string
    {
        return $this->doc_distrib_fax_flag ?? null;
    }
    /**
     * Set doc_distrib_fax_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_distrib_fax_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_distrib_fax_flag(?string $doc_distrib_fax_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_distrib_fax_flag) && !is_string($doc_distrib_fax_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_distrib_fax_flag, true), gettype($doc_distrib_fax_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($doc_distrib_fax_flag) && $doc_distrib_fax_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($doc_distrib_fax_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($doc_distrib_fax_flag) && $doc_distrib_fax_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($doc_distrib_fax_flag, true)), __LINE__);
        }
        if (is_null($doc_distrib_fax_flag) || (is_array($doc_distrib_fax_flag) && empty($doc_distrib_fax_flag))) {
            unset($this->doc_distrib_fax_flag);
        } else {
            $this->doc_distrib_fax_flag = $doc_distrib_fax_flag;
        }
        
        return $this;
    }
    /**
     * Get doc_distrib_mail_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_distrib_mail_flag(): ?string
    {
        return $this->doc_distrib_mail_flag ?? null;
    }
    /**
     * Set doc_distrib_mail_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_distrib_mail_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_distrib_mail_flag(?string $doc_distrib_mail_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_distrib_mail_flag) && !is_string($doc_distrib_mail_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_distrib_mail_flag, true), gettype($doc_distrib_mail_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($doc_distrib_mail_flag) && $doc_distrib_mail_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($doc_distrib_mail_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($doc_distrib_mail_flag) && $doc_distrib_mail_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($doc_distrib_mail_flag, true)), __LINE__);
        }
        if (is_null($doc_distrib_mail_flag) || (is_array($doc_distrib_mail_flag) && empty($doc_distrib_mail_flag))) {
            unset($this->doc_distrib_mail_flag);
        } else {
            $this->doc_distrib_mail_flag = $doc_distrib_mail_flag;
        }
        
        return $this;
    }
    /**
     * Get doc_distrib_online_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_distrib_online_flag(): ?string
    {
        return $this->doc_distrib_online_flag ?? null;
    }
    /**
     * Set doc_distrib_online_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_distrib_online_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_distrib_online_flag(?string $doc_distrib_online_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_distrib_online_flag) && !is_string($doc_distrib_online_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_distrib_online_flag, true), gettype($doc_distrib_online_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($doc_distrib_online_flag) && $doc_distrib_online_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($doc_distrib_online_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($doc_distrib_online_flag) && $doc_distrib_online_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($doc_distrib_online_flag, true)), __LINE__);
        }
        if (is_null($doc_distrib_online_flag) || (is_array($doc_distrib_online_flag) && empty($doc_distrib_online_flag))) {
            unset($this->doc_distrib_online_flag);
        } else {
            $this->doc_distrib_online_flag = $doc_distrib_online_flag;
        }
        
        return $this;
    }
    /**
     * Get doc_send_always_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_send_always_flag(): ?string
    {
        return $this->doc_send_always_flag ?? null;
    }
    /**
     * Set doc_send_always_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_send_always_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_send_always_flag(?string $doc_send_always_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_send_always_flag) && !is_string($doc_send_always_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_send_always_flag, true), gettype($doc_send_always_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($doc_send_always_flag) && $doc_send_always_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($doc_send_always_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($doc_send_always_flag) && $doc_send_always_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($doc_send_always_flag, true)), __LINE__);
        }
        if (is_null($doc_send_always_flag) || (is_array($doc_send_always_flag) && empty($doc_send_always_flag))) {
            unset($this->doc_send_always_flag);
        } else {
            $this->doc_send_always_flag = $doc_send_always_flag;
        }
        
        return $this;
    }
    /**
     * Get doc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_add_date(): ?string
    {
        return $this->doc_add_date ?? null;
    }
    /**
     * Set doc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_add_date(?string $doc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_add_date) && !is_string($doc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_add_date, true), gettype($doc_add_date)), __LINE__);
        }
        if (is_null($doc_add_date) || (is_array($doc_add_date) && empty($doc_add_date))) {
            unset($this->doc_add_date);
        } else {
            $this->doc_add_date = $doc_add_date;
        }
        
        return $this;
    }
    /**
     * Get doc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_add_user(): ?string
    {
        return $this->doc_add_user ?? null;
    }
    /**
     * Set doc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_add_user(?string $doc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_add_user) && !is_string($doc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_add_user, true), gettype($doc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($doc_add_user) && mb_strlen((string) $doc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $doc_add_user)), __LINE__);
        }
        if (is_null($doc_add_user) || (is_array($doc_add_user) && empty($doc_add_user))) {
            unset($this->doc_add_user);
        } else {
            $this->doc_add_user = $doc_add_user;
        }
        
        return $this;
    }
    /**
     * Get doc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_change_date(): ?string
    {
        return $this->doc_change_date ?? null;
    }
    /**
     * Set doc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_change_date(?string $doc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_change_date) && !is_string($doc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_change_date, true), gettype($doc_change_date)), __LINE__);
        }
        if (is_null($doc_change_date) || (is_array($doc_change_date) && empty($doc_change_date))) {
            unset($this->doc_change_date);
        } else {
            $this->doc_change_date = $doc_change_date;
        }
        
        return $this;
    }
    /**
     * Get doc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_change_user(): ?string
    {
        return $this->doc_change_user ?? null;
    }
    /**
     * Set doc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_change_user(?string $doc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_change_user) && !is_string($doc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_change_user, true), gettype($doc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($doc_change_user) && mb_strlen((string) $doc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $doc_change_user)), __LINE__);
        }
        if (is_null($doc_change_user) || (is_array($doc_change_user) && empty($doc_change_user))) {
            unset($this->doc_change_user);
        } else {
            $this->doc_change_user = $doc_change_user;
        }
        
        return $this;
    }
    /**
     * Get doc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_delete_flag(): ?string
    {
        return $this->doc_delete_flag ?? null;
    }
    /**
     * Set doc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_delete_flag(?string $doc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_delete_flag) && !is_string($doc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_delete_flag, true), gettype($doc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($doc_delete_flag) && $doc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($doc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($doc_delete_flag) && $doc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($doc_delete_flag, true)), __LINE__);
        }
        if (is_null($doc_delete_flag) || (is_array($doc_delete_flag) && empty($doc_delete_flag))) {
            unset($this->doc_delete_flag);
        } else {
            $this->doc_delete_flag = $doc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get doc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_key_ext(): ?string
    {
        return $this->doc_key_ext ?? null;
    }
    /**
     * Set doc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_key_ext(?string $doc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_key_ext) && !is_string($doc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_key_ext, true), gettype($doc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($doc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $doc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($doc_key_ext, true)), __LINE__);
        }
        if (is_null($doc_key_ext) || (is_array($doc_key_ext) && empty($doc_key_ext))) {
            unset($this->doc_key_ext);
        } else {
            $this->doc_key_ext = $doc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get doc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_entity_key(): ?string
    {
        return $this->doc_entity_key ?? null;
    }
    /**
     * Set doc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_entity_key(?string $doc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_entity_key) && !is_string($doc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_entity_key, true), gettype($doc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($doc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $doc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($doc_entity_key, true)), __LINE__);
        }
        if (is_null($doc_entity_key) || (is_array($doc_entity_key) && empty($doc_entity_key))) {
            unset($this->doc_entity_key);
        } else {
            $this->doc_entity_key = $doc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get doc_author value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_author(): ?string
    {
        return $this->doc_author ?? null;
    }
    /**
     * Set doc_author value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_author
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_author(?string $doc_author = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_author) && !is_string($doc_author)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_author, true), gettype($doc_author)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($doc_author) && mb_strlen((string) $doc_author) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $doc_author)), __LINE__);
        }
        if (is_null($doc_author) || (is_array($doc_author) && empty($doc_author))) {
            unset($this->doc_author);
        } else {
            $this->doc_author = $doc_author;
        }
        
        return $this;
    }
    /**
     * Get doc_source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_source(): ?string
    {
        return $this->doc_source ?? null;
    }
    /**
     * Set doc_source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_source
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_source(?string $doc_source = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_source) && !is_string($doc_source)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_source, true), gettype($doc_source)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($doc_source) && mb_strlen((string) $doc_source) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $doc_source)), __LINE__);
        }
        if (is_null($doc_source) || (is_array($doc_source) && empty($doc_source))) {
            unset($this->doc_source);
        } else {
            $this->doc_source = $doc_source;
        }
        
        return $this;
    }
    /**
     * Get doc_category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_category(): ?string
    {
        return $this->doc_category ?? null;
    }
    /**
     * Set doc_category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_category
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_category(?string $doc_category = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_category) && !is_string($doc_category)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_category, true), gettype($doc_category)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($doc_category) && mb_strlen((string) $doc_category) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $doc_category)), __LINE__);
        }
        if (is_null($doc_category) || (is_array($doc_category) && empty($doc_category))) {
            unset($this->doc_category);
        } else {
            $this->doc_category = $doc_category;
        }
        
        return $this;
    }
    /**
     * Get doc_allow_search value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_allow_search(): ?string
    {
        return $this->doc_allow_search ?? null;
    }
    /**
     * Set doc_allow_search value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_allow_search
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_allow_search(?string $doc_allow_search = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_allow_search) && !is_string($doc_allow_search)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_allow_search, true), gettype($doc_allow_search)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($doc_allow_search) && $doc_allow_search > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($doc_allow_search, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($doc_allow_search) && $doc_allow_search < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($doc_allow_search, true)), __LINE__);
        }
        if (is_null($doc_allow_search) || (is_array($doc_allow_search) && empty($doc_allow_search))) {
            unset($this->doc_allow_search);
        } else {
            $this->doc_allow_search = $doc_allow_search;
        }
        
        return $this;
    }
    /**
     * Get doc_text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_text(): ?string
    {
        return $this->doc_text ?? null;
    }
    /**
     * Set doc_text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_text
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_text(?string $doc_text = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_text) && !is_string($doc_text)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_text, true), gettype($doc_text)), __LINE__);
        }
        if (is_null($doc_text) || (is_array($doc_text) && empty($doc_text))) {
            unset($this->doc_text);
        } else {
            $this->doc_text = $doc_text;
        }
        
        return $this;
    }
    /**
     * Get doc_original_doc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_original_doc_key(): ?string
    {
        return $this->doc_original_doc_key ?? null;
    }
    /**
     * Set doc_original_doc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_original_doc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_original_doc_key(?string $doc_original_doc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_original_doc_key) && !is_string($doc_original_doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_original_doc_key, true), gettype($doc_original_doc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($doc_original_doc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $doc_original_doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($doc_original_doc_key, true)), __LINE__);
        }
        if (is_null($doc_original_doc_key) || (is_array($doc_original_doc_key) && empty($doc_original_doc_key))) {
            unset($this->doc_original_doc_key);
        } else {
            $this->doc_original_doc_key = $doc_original_doc_key;
        }
        
        return $this;
    }
    /**
     * Get doc_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_type(): ?string
    {
        return $this->doc_type ?? null;
    }
    /**
     * Set doc_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_type(?string $doc_type = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_type) && !is_string($doc_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_type, true), gettype($doc_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($doc_type) && mb_strlen((string) $doc_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $doc_type)), __LINE__);
        }
        if (is_null($doc_type) || (is_array($doc_type) && empty($doc_type))) {
            unset($this->doc_type);
        } else {
            $this->doc_type = $doc_type;
        }
        
        return $this;
    }
    /**
     * Get doc_security_level value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoc_security_level(): ?string
    {
        return $this->doc_security_level ?? null;
    }
    /**
     * Set doc_security_level value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doc_security_level
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
     */
    public function setDoc_security_level(?string $doc_security_level = null): self
    {
        // validation for constraint: string
        if (!is_null($doc_security_level) && !is_string($doc_security_level)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_security_level, true), gettype($doc_security_level)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($doc_security_level) && mb_strlen((string) $doc_security_level) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $doc_security_level)), __LINE__);
        }
        if (is_null($doc_security_level) || (is_array($doc_security_level) && empty($doc_security_level))) {
            unset($this->doc_security_level);
        } else {
            $this->doc_security_level = $doc_security_level;
        }
        
        return $this;
    }
}
