<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer extends AbstractStructBase
{
    /**
     * The OrgCstKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $OrgCstKey;
    /**
     * The actionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $actionDate = null;
    /**
     * The oIPAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $oIPAddress = null;
    /**
     * Constructor method for ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer
     * @uses ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer::setOrgCstKey()
     * @uses ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer::setActionDate()
     * @uses ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer::setOIPAddress()
     * @param string $orgCstKey
     * @param string $actionDate
     * @param string $oIPAddress
     */
    public function __construct(string $orgCstKey, ?string $actionDate = null, ?string $oIPAddress = null)
    {
        $this
            ->setOrgCstKey($orgCstKey)
            ->setActionDate($actionDate)
            ->setOIPAddress($oIPAddress);
    }
    /**
     * Get OrgCstKey value
     * @return string
     */
    public function getOrgCstKey(): string
    {
        return $this->OrgCstKey;
    }
    /**
     * Set OrgCstKey value
     * @param string $orgCstKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer
     */
    public function setOrgCstKey(string $orgCstKey): self
    {
        // validation for constraint: string
        if (!is_null($orgCstKey) && !is_string($orgCstKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgCstKey, true), gettype($orgCstKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($orgCstKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $orgCstKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($orgCstKey, true)), __LINE__);
        }
        $this->OrgCstKey = $orgCstKey;
        
        return $this;
    }
    /**
     * Get actionDate value
     * @return string|null
     */
    public function getActionDate(): ?string
    {
        return $this->actionDate;
    }
    /**
     * Set actionDate value
     * @param string $actionDate
     * @return \Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer
     */
    public function setActionDate(?string $actionDate = null): self
    {
        // validation for constraint: string
        if (!is_null($actionDate) && !is_string($actionDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDate, true), gettype($actionDate)), __LINE__);
        }
        $this->actionDate = $actionDate;
        
        return $this;
    }
    /**
     * Get oIPAddress value
     * @return string|null
     */
    public function getOIPAddress(): ?string
    {
        return $this->oIPAddress;
    }
    /**
     * Set oIPAddress value
     * @param string $oIPAddress
     * @return \Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer
     */
    public function setOIPAddress(?string $oIPAddress = null): self
    {
        // validation for constraint: string
        if (!is_null($oIPAddress) && !is_string($oIPAddress)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIPAddress, true), gettype($oIPAddress)), __LINE__);
        }
        $this->oIPAddress = $oIPAddress;
        
        return $this;
    }
}
