<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrantGroup_Invoice_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrantGroup_Invoice_DataObjectType extends AbstractStructBase
{
    /**
     * The inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_key = null;
    /**
     * The inv_proforma
     * Meta information extracted from the WSDL
     * - documentation: Proforma?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_proforma = null;
    /**
     * The inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_code = null;
    /**
     * The inv_trx_date
     * Meta information extracted from the WSDL
     * - documentation: Transaction Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_trx_date = null;
    /**
     * The inv_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cst_key = null;
    /**
     * The inv_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_add_user = null;
    /**
     * The inv_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_add_date = null;
    /**
     * The inv_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_change_user = null;
    /**
     * The inv_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_change_date = null;
    /**
     * The inv_code_count
     * Meta information extracted from the WSDL
     * - documentation: Invoice Counter. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $inv_code_count = null;
    /**
     * The inv_code_cp
     * Meta information extracted from the WSDL
     * - documentation: Invoice Number. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 54
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_code_cp = null;
    /**
     * The inv_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_delete_flag = null;
    /**
     * The inv_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_key_ext = null;
    /**
     * The inv_ait_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Terms. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_ait_key = null;
    /**
     * The inv_print_count
     * Meta information extracted from the WSDL
     * - documentation: Print Count.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $inv_print_count = null;
    /**
     * The inv_print_date
     * Meta information extracted from the WSDL
     * - documentation: Date Printed. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_print_date = null;
    /**
     * The inv_print_user
     * Meta information extracted from the WSDL
     * - documentation: Last Printed By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_print_user = null;
    /**
     * The inv_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_src_key = null;
    /**
     * The inv_med_key
     * Meta information extracted from the WSDL
     * - documentation: Media Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_med_key = null;
    /**
     * The inv_post_flag
     * Meta information extracted from the WSDL
     * - documentation: Posted?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_post_flag = null;
    /**
     * The inv_notes_internal
     * Meta information extracted from the WSDL
     * - documentation: Internal Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_notes_internal = null;
    /**
     * The inv_bat_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Batch. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_bat_key = null;
    /**
     * The inv_notes_external
     * Meta information extracted from the WSDL
     * - documentation: External Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_notes_external = null;
    /**
     * The inv_ship_on_date
     * Meta information extracted from the WSDL
     * - documentation: Expected Ship Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_ship_on_date = null;
    /**
     * The inv_ship_priority
     * Meta information extracted from the WSDL
     * - documentation: Shipping Priority.This element has a default value of '3'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $inv_ship_priority = null;
    /**
     * The inv_po_number
     * Meta information extracted from the WSDL
     * - documentation: PO Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_po_number = null;
    /**
     * The inv_orig_trans_type
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_orig_trans_type = null;
    /**
     * The inv_fax_confirm_sent_flag
     * Meta information extracted from the WSDL
     * - documentation: fax confirmation sent. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_fax_confirm_sent_flag = null;
    /**
     * The inv_email_confirm_sent_flag
     * Meta information extracted from the WSDL
     * - documentation: e-mail confirmation sent. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_email_confirm_sent_flag = null;
    /**
     * The inv_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cxa_key = null;
    /**
     * The inv_cph_key
     * Meta information extracted from the WSDL
     * - documentation: Phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cph_key = null;
    /**
     * The inv_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cfx_key = null;
    /**
     * The inv_eml_key
     * Meta information extracted from the WSDL
     * - documentation: Email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_eml_key = null;
    /**
     * The inv_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Preferred Communication Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_pref_comm_meth = null;
    /**
     * The inv_billing_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Billing Preferred Communication Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_billing_pref_comm_meth = null;
    /**
     * The inv_close_flag
     * Meta information extracted from the WSDL
     * - documentation: Closed?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_close_flag = null;
    /**
     * The inv_bat_close_flag
     * Meta information extracted from the WSDL
     * - documentation: Batch Closed?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_bat_close_flag = null;
    /**
     * The inv_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_entity_key = null;
    /**
     * The inv_col_key
     * Meta information extracted from the WSDL
     * - documentation: Collection Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_col_key = null;
    /**
     * The inv_cst_billing_key
     * Meta information extracted from the WSDL
     * - documentation: Bill To Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cst_billing_key = null;
    /**
     * The inv_ind_cst_billing_key
     * Meta information extracted from the WSDL
     * - documentation: Billing Contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_ind_cst_billing_key = null;
    /**
     * The inv_ord_key
     * Meta information extracted from the WSDL
     * - documentation: Order Id. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_ord_key = null;
    /**
     * The inv_tracking_number
     * Meta information extracted from the WSDL
     * - documentation: Tracking Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_tracking_number = null;
    /**
     * The inv_group_flag
     * Meta information extracted from the WSDL
     * - documentation: Group Items for Reporting. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_group_flag = null;
    /**
     * The inv_group_description
     * Meta information extracted from the WSDL
     * - documentation: Invoice Group Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_group_description = null;
    /**
     * The inv_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cur_key = null;
    /**
     * The inv_allow_installments
     * Meta information extracted from the WSDL
     * - documentation: Allow installments?. | Avectra netForum defined simpleType.
     * - base: s:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [0-1]
     * @var bool|null
     */
    protected ?bool $inv_allow_installments = null;
    /**
     * The inv_sfo_key
     * Meta information extracted from the WSDL
     * - documentation: opportunity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_sfo_key = null;
    /**
     * The inv_pbs_key
     * Meta information extracted from the WSDL
     * - documentation: Payment Batch Status Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_pbs_key = null;
    /**
     * The inv_AutoRefund
     * Meta information extracted from the WSDL
     * - documentation: Auto Refund.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_AutoRefund = null;
    /**
     * The inv_eweb_credit_available
     * Meta information extracted from the WSDL
     * - documentation: Total Credit Available.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data
     * Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_eweb_credit_available = null;
    /**
     * The inv_send_email_confirmation
     * Meta information extracted from the WSDL
     * - documentation: send email confirmation.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_send_email_confirmation = null;
    /**
     * The inv_eweb_apply_credit_amount
     * Meta information extracted from the WSDL
     * - documentation: Credit To Apply.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_eweb_apply_credit_amount = null;
    /**
     * The inv_send_fax_confirmation
     * Meta information extracted from the WSDL
     * - documentation: send fax confirmation.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_send_fax_confirmation = null;
    /**
     * The inv_adjustment_reason
     * Meta information extracted from the WSDL
     * - documentation: Adjustment Reason.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_adjustment_reason = null;
    /**
     * The inv_available_installment_milestone_schedules
     * Meta information extracted from the WSDL
     * - documentation: available milestone schedules.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_available_installment_milestone_schedules = null;
    /**
     * The inv_collection_status
     * Meta information extracted from the WSDL
     * - documentation: Collection Status.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_collection_status = null;
    /**
     * The inv_cty_code
     * Meta information extracted from the WSDL
     * - documentation: Currency Code.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_cty_code = null;
    /**
     * The inv_installment_milestone_schedule
     * Meta information extracted from the WSDL
     * - documentation: milestone schedule.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_installment_milestone_schedule = null;
    /**
     * The inv_NewBatch_key
     * Meta information extracted from the WSDL
     * - documentation: inv_NewBatch_key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_NewBatch_key = null;
    /**
     * The inv_cst_first_last_name
     * Meta information extracted from the WSDL
     * - documentation: customer first and last name.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_cst_first_last_name = null;
    /**
     * The inv_email_bcc
     * Meta information extracted from the WSDL
     * - documentation: Send Confirmation to (BCC):.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_email_bcc = null;
    /**
     * The inv_total
     * Meta information extracted from the WSDL
     * - documentation: Invoice Total.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and
     * is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_total = null;
    /**
     * The inv_amount
     * Meta information extracted from the WSDL
     * - documentation: Invoice Amount.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and
     * is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_amount = null;
    /**
     * The inv_balance
     * Meta information extracted from the WSDL
     * - documentation: Invoice Balance.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field
     * and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_balance = null;
    /**
     * The inv_payment_to_apply_distributed
     * Meta information extracted from the WSDL
     * - documentation: Distributed Payment Liabilty.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum
     * defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_payment_to_apply_distributed = null;
    /**
     * The inv_close_opportunity
     * Meta information extracted from the WSDL
     * - documentation: close opportunity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_close_opportunity = null;
    /**
     * The inv_credit_to_apply_distributed
     * Meta information extracted from the WSDL
     * - documentation: Distributed Credit Liabilty.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum
     * defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_credit_to_apply_distributed = null;
    /**
     * The inv_distributable_credit_total
     * Meta information extracted from the WSDL
     * - documentation: Distributable Credit Total.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum
     * defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_distributable_credit_total = null;
    /**
     * The inv_distributable_credit_balance
     * Meta information extracted from the WSDL
     * - documentation: Distributable Credit Balance.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum
     * defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_distributable_credit_balance = null;
    /**
     * The inv_paid_by_liability_balance
     * Meta information extracted from the WSDL
     * - documentation: Paid-By Customer Liability Balance.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra
     * netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_paid_by_liability_balance = null;
    /**
     * The inv_payment_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Payment to Apply. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_payment_to_apply = null;
    /**
     * The inv_convertedamount
     * Meta information extracted from the WSDL
     * - documentation: Converted Total. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_convertedamount = null;
    /**
     * The inv_nettotal
     * Meta information extracted from the WSDL
     * - documentation: Net-Total.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_nettotal = null;
    /**
     * The inv_netpayment
     * Meta information extracted from the WSDL
     * - documentation: Net Payment.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_netpayment = null;
    /**
     * The inv_credit_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Credit to apply.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field
     * and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_credit_to_apply = null;
    /**
     * The inv_netbalance
     * Meta information extracted from the WSDL
     * - documentation: Net-Balance.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_netbalance = null;
    /**
     * The inv_netcredit
     * Meta information extracted from the WSDL
     * - documentation: Net Credit.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_netcredit = null;
    /**
     * The inv_net_amount_due
     * Meta information extracted from the WSDL
     * - documentation: Net Amount due. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_net_amount_due = null;
    /**
     * The inv_netunpaidbalance
     * Meta information extracted from the WSDL
     * - documentation: Net Unpaid Balance.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field
     * and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_netunpaidbalance = null;
    /**
     * The inv_netwriteoff
     * Meta information extracted from the WSDL
     * - documentation: Net Write-Off.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and
     * is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_netwriteoff = null;
    /**
     * The inv_writeoff_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Write-Off to apply.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field
     * and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_writeoff_to_apply = null;
    /**
     * The inv_netreturn
     * Meta information extracted from the WSDL
     * - documentation: Net Return.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_netreturn = null;
    /**
     * The inv_return_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Return to apply.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field
     * and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_return_to_apply = null;
    /**
     * The inv_netapplied
     * Meta information extracted from the WSDL
     * - documentation: Net Applied.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_netapplied = null;
    /**
     * The inv_previous_netapplied
     * Meta information extracted from the WSDL
     * - documentation: Previous Net Applied.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data
     * Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_previous_netapplied = null;
    /**
     * The inv_previous_netpayment
     * Meta information extracted from the WSDL
     * - documentation: Previous Net Payment.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data
     * Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_previous_netpayment = null;
    /**
     * The inv_total_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Total to apply.This element has a default value of '0'. This field has this Input Mask: $$$,$$$,$$$.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and
     * is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_total_to_apply = null;
    /**
     * The inv_next_invoice_date
     * Meta information extracted from the WSDL
     * - documentation: Next invoice Date. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_next_invoice_date = null;
    /**
     * The inv_allow_payment_with_frozen_payment_method
     * Meta information extracted from the WSDL
     * - documentation: Allow Payment With Frozen Payment Method?.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. |
     * Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_allow_payment_with_frozen_payment_method = null;
    /**
     * The inv_reload_inv_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Reload Invoice.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_reload_inv_cxa_key = null;
    /**
     * The inv_reload_ivd_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Reload Invoice Detail.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_reload_ivd_cxa_key = null;
    /**
     * The inv_select_all
     * Meta information extracted from the WSDL
     * - documentation: select/unselect all - may be used for selecting invoice details in updategrid.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_select_all = null;
    /**
     * The inv_details_html
     * Meta information extracted from the WSDL
     * - documentation: Invoice Details (HTML).This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_details_html = null;
    /**
     * The inv_details_text
     * Meta information extracted from the WSDL
     * - documentation: Invoice Details (Plain Text).This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_details_text = null;
    /**
     * The inv_details_with_customer_html
     * Meta information extracted from the WSDL
     * - documentation: Invoice Details With Customer Name (HTML).This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_details_with_customer_html = null;
    /**
     * The inv_autoapply
     * Meta information extracted from the WSDL
     * - documentation: Auto Distribute Payment.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_autoapply = null;
    /**
     * The inv_autoapplypayment
     * Meta information extracted from the WSDL
     * - documentation: Auto Apply Payment.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_autoapplypayment = null;
    /**
     * The inv_installment_flag
     * Meta information extracted from the WSDL
     * - documentation: Installment.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_installment_flag = null;
    /**
     * The inv_coe_flag
     * Meta information extracted from the WSDL
     * - documentation: Agency Subscription.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_coe_flag = null;
    /**
     * The inv_shippable_total
     * Meta information extracted from the WSDL
     * - documentation: Invoice Total.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and
     * is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_shippable_total = null;
    /**
     * The inv_unapplied_shipping_total
     * Meta information extracted from the WSDL
     * - documentation: Unapplied shipping Total.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data
     * Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_unapplied_shipping_total = null;
    /**
     * The inv_shippable_items_flag
     * Meta information extracted from the WSDL
     * - documentation: Contains Shippable Items?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_shippable_items_flag = null;
    /**
     * The inv_create_mail_record
     * Meta information extracted from the WSDL
     * - documentation: create mail record for physical mailings.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_create_mail_record = null;
    /**
     * The inv_autoapplycredit
     * Meta information extracted from the WSDL
     * - documentation: Auto Distribute Credit.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_autoapplycredit = null;
    /**
     * The inv_invoice_detail_count
     * Meta information extracted from the WSDL
     * - documentation: Inovice Detail Count.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $inv_invoice_detail_count = null;
    /**
     * The inv_bill_me
     * Meta information extracted from the WSDL
     * - documentation: Bill me?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_bill_me = null;
    /**
     * The inv_HasNewLineItems
     * Meta information extracted from the WSDL
     * - documentation: Has New Line Items?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_HasNewLineItems = null;
    /**
     * The inv_HasOldLineItems
     * Meta information extracted from the WSDL
     * - documentation: Has Old Line Items?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_HasOldLineItems = null;
    /**
     * The inv_total_weight
     * Meta information extracted from the WSDL
     * - documentation: Invoice Weight.This element has a default value of '0'. This field has this Input Mask: 999,999,999.9999. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field
     * and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $inv_total_weight = null;
    /**
     * The inv_discount
     * Meta information extracted from the WSDL
     * - documentation: Discount.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_discount = null;
    /**
     * The inv_shipping
     * Meta information extracted from the WSDL
     * - documentation: Shipping.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_shipping = null;
    /**
     * The inv_tax
     * Meta information extracted from the WSDL
     * - documentation: Tax.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is
     * Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $inv_tax = null;
    /**
     * The inv_prd_keys
     * Meta information extracted from the WSDL
     * - documentation: Product Keys.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_prd_keys = null;
    /**
     * The inv_currency_readonly
     * Meta information extracted from the WSDL
     * - documentation: Currency Read-only Flag.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_currency_readonly = null;
    /**
     * The inv_cur_exchange_rate
     * Meta information extracted from the WSDL
     * - documentation: Exchange Rate.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and
     * is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_cur_exchange_rate = null;
    /**
     * The inv_use_payment_to_apply_field
     * Meta information extracted from the WSDL
     * - documentation: use payment to apply field.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_use_payment_to_apply_field = null;
    /**
     * The inv_allow_installment
     * Meta information extracted from the WSDL
     * - documentation: allow installment?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_allow_installment = null;
    /**
     * Constructor method for EventsRegistrantGroup_Invoice_DataObjectType
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_proforma()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_code()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_trx_date()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_cst_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_add_user()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_add_date()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_change_user()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_change_date()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_code_count()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_code_cp()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_delete_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_key_ext()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_ait_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_print_count()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_print_date()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_print_user()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_src_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_med_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_post_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_notes_internal()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_bat_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_notes_external()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_ship_on_date()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_ship_priority()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_po_number()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_orig_trans_type()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_fax_confirm_sent_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_email_confirm_sent_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_cxa_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_cph_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_cfx_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_eml_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_pref_comm_meth()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_billing_pref_comm_meth()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_close_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_bat_close_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_entity_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_col_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_cst_billing_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_ind_cst_billing_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_ord_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_tracking_number()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_group_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_group_description()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_cur_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_allow_installments()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_sfo_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_pbs_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_AutoRefund()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_eweb_credit_available()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_send_email_confirmation()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_eweb_apply_credit_amount()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_send_fax_confirmation()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_adjustment_reason()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_available_installment_milestone_schedules()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_collection_status()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_cty_code()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_installment_milestone_schedule()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_NewBatch_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_cst_first_last_name()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_email_bcc()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_total()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_amount()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_balance()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_payment_to_apply_distributed()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_close_opportunity()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_credit_to_apply_distributed()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_distributable_credit_total()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_distributable_credit_balance()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_paid_by_liability_balance()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_payment_to_apply()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_convertedamount()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_nettotal()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_netpayment()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_credit_to_apply()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_netbalance()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_netcredit()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_net_amount_due()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_netunpaidbalance()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_netwriteoff()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_writeoff_to_apply()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_netreturn()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_return_to_apply()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_netapplied()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_previous_netapplied()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_previous_netpayment()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_total_to_apply()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_next_invoice_date()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_allow_payment_with_frozen_payment_method()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_reload_inv_cxa_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_reload_ivd_cxa_key()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_select_all()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_details_html()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_details_text()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_details_with_customer_html()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_autoapply()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_autoapplypayment()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_installment_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_coe_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_shippable_total()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_unapplied_shipping_total()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_shippable_items_flag()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_create_mail_record()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_autoapplycredit()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_invoice_detail_count()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_bill_me()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_HasNewLineItems()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_HasOldLineItems()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_total_weight()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_discount()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_shipping()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_tax()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_prd_keys()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_currency_readonly()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_cur_exchange_rate()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_use_payment_to_apply_field()
     * @uses EventsRegistrantGroup_Invoice_DataObjectType::setInv_allow_installment()
     * @param string $inv_key
     * @param string $inv_proforma
     * @param string $inv_code
     * @param string $inv_trx_date
     * @param string $inv_cst_key
     * @param string $inv_add_user
     * @param string $inv_add_date
     * @param string $inv_change_user
     * @param string $inv_change_date
     * @param int $inv_code_count
     * @param string $inv_code_cp
     * @param string $inv_delete_flag
     * @param string $inv_key_ext
     * @param string $inv_ait_key
     * @param int $inv_print_count
     * @param string $inv_print_date
     * @param string $inv_print_user
     * @param string $inv_src_key
     * @param string $inv_med_key
     * @param string $inv_post_flag
     * @param string $inv_notes_internal
     * @param string $inv_bat_key
     * @param string $inv_notes_external
     * @param string $inv_ship_on_date
     * @param int $inv_ship_priority
     * @param string $inv_po_number
     * @param string $inv_orig_trans_type
     * @param string $inv_fax_confirm_sent_flag
     * @param string $inv_email_confirm_sent_flag
     * @param string $inv_cxa_key
     * @param string $inv_cph_key
     * @param string $inv_cfx_key
     * @param string $inv_eml_key
     * @param string $inv_pref_comm_meth
     * @param string $inv_billing_pref_comm_meth
     * @param string $inv_close_flag
     * @param string $inv_bat_close_flag
     * @param string $inv_entity_key
     * @param string $inv_col_key
     * @param string $inv_cst_billing_key
     * @param string $inv_ind_cst_billing_key
     * @param string $inv_ord_key
     * @param string $inv_tracking_number
     * @param string $inv_group_flag
     * @param string $inv_group_description
     * @param string $inv_cur_key
     * @param bool $inv_allow_installments
     * @param string $inv_sfo_key
     * @param string $inv_pbs_key
     * @param string $inv_AutoRefund
     * @param float $inv_eweb_credit_available
     * @param string $inv_send_email_confirmation
     * @param float $inv_eweb_apply_credit_amount
     * @param string $inv_send_fax_confirmation
     * @param string $inv_adjustment_reason
     * @param string $inv_available_installment_milestone_schedules
     * @param string $inv_collection_status
     * @param string $inv_cty_code
     * @param string $inv_installment_milestone_schedule
     * @param string $inv_NewBatch_key
     * @param string $inv_cst_first_last_name
     * @param string $inv_email_bcc
     * @param float $inv_total
     * @param float $inv_amount
     * @param float $inv_balance
     * @param float $inv_payment_to_apply_distributed
     * @param string $inv_close_opportunity
     * @param float $inv_credit_to_apply_distributed
     * @param float $inv_distributable_credit_total
     * @param float $inv_distributable_credit_balance
     * @param float $inv_paid_by_liability_balance
     * @param float $inv_payment_to_apply
     * @param string $inv_convertedamount
     * @param float $inv_nettotal
     * @param float $inv_netpayment
     * @param float $inv_credit_to_apply
     * @param float $inv_netbalance
     * @param float $inv_netcredit
     * @param float $inv_net_amount_due
     * @param float $inv_netunpaidbalance
     * @param float $inv_netwriteoff
     * @param float $inv_writeoff_to_apply
     * @param float $inv_netreturn
     * @param float $inv_return_to_apply
     * @param float $inv_netapplied
     * @param float $inv_previous_netapplied
     * @param float $inv_previous_netpayment
     * @param float $inv_total_to_apply
     * @param string $inv_next_invoice_date
     * @param string $inv_allow_payment_with_frozen_payment_method
     * @param string $inv_reload_inv_cxa_key
     * @param string $inv_reload_ivd_cxa_key
     * @param string $inv_select_all
     * @param string $inv_details_html
     * @param string $inv_details_text
     * @param string $inv_details_with_customer_html
     * @param string $inv_autoapply
     * @param string $inv_autoapplypayment
     * @param string $inv_installment_flag
     * @param string $inv_coe_flag
     * @param float $inv_shippable_total
     * @param float $inv_unapplied_shipping_total
     * @param string $inv_shippable_items_flag
     * @param string $inv_create_mail_record
     * @param string $inv_autoapplycredit
     * @param int $inv_invoice_detail_count
     * @param string $inv_bill_me
     * @param string $inv_HasNewLineItems
     * @param string $inv_HasOldLineItems
     * @param float $inv_total_weight
     * @param float $inv_discount
     * @param float $inv_shipping
     * @param float $inv_tax
     * @param string $inv_prd_keys
     * @param string $inv_currency_readonly
     * @param string $inv_cur_exchange_rate
     * @param string $inv_use_payment_to_apply_field
     * @param string $inv_allow_installment
     */
    public function __construct(?string $inv_key = null, ?string $inv_proforma = null, ?string $inv_code = null, ?string $inv_trx_date = null, ?string $inv_cst_key = null, ?string $inv_add_user = null, ?string $inv_add_date = null, ?string $inv_change_user = null, ?string $inv_change_date = null, ?int $inv_code_count = null, ?string $inv_code_cp = null, ?string $inv_delete_flag = null, ?string $inv_key_ext = null, ?string $inv_ait_key = null, ?int $inv_print_count = null, ?string $inv_print_date = null, ?string $inv_print_user = null, ?string $inv_src_key = null, ?string $inv_med_key = null, ?string $inv_post_flag = null, ?string $inv_notes_internal = null, ?string $inv_bat_key = null, ?string $inv_notes_external = null, ?string $inv_ship_on_date = null, ?int $inv_ship_priority = null, ?string $inv_po_number = null, ?string $inv_orig_trans_type = null, ?string $inv_fax_confirm_sent_flag = null, ?string $inv_email_confirm_sent_flag = null, ?string $inv_cxa_key = null, ?string $inv_cph_key = null, ?string $inv_cfx_key = null, ?string $inv_eml_key = null, ?string $inv_pref_comm_meth = null, ?string $inv_billing_pref_comm_meth = null, ?string $inv_close_flag = null, ?string $inv_bat_close_flag = null, ?string $inv_entity_key = null, ?string $inv_col_key = null, ?string $inv_cst_billing_key = null, ?string $inv_ind_cst_billing_key = null, ?string $inv_ord_key = null, ?string $inv_tracking_number = null, ?string $inv_group_flag = null, ?string $inv_group_description = null, ?string $inv_cur_key = null, ?bool $inv_allow_installments = null, ?string $inv_sfo_key = null, ?string $inv_pbs_key = null, ?string $inv_AutoRefund = null, ?float $inv_eweb_credit_available = null, ?string $inv_send_email_confirmation = null, ?float $inv_eweb_apply_credit_amount = null, ?string $inv_send_fax_confirmation = null, ?string $inv_adjustment_reason = null, ?string $inv_available_installment_milestone_schedules = null, ?string $inv_collection_status = null, ?string $inv_cty_code = null, ?string $inv_installment_milestone_schedule = null, ?string $inv_NewBatch_key = null, ?string $inv_cst_first_last_name = null, ?string $inv_email_bcc = null, ?float $inv_total = null, ?float $inv_amount = null, ?float $inv_balance = null, ?float $inv_payment_to_apply_distributed = null, ?string $inv_close_opportunity = null, ?float $inv_credit_to_apply_distributed = null, ?float $inv_distributable_credit_total = null, ?float $inv_distributable_credit_balance = null, ?float $inv_paid_by_liability_balance = null, ?float $inv_payment_to_apply = null, ?string $inv_convertedamount = null, ?float $inv_nettotal = null, ?float $inv_netpayment = null, ?float $inv_credit_to_apply = null, ?float $inv_netbalance = null, ?float $inv_netcredit = null, ?float $inv_net_amount_due = null, ?float $inv_netunpaidbalance = null, ?float $inv_netwriteoff = null, ?float $inv_writeoff_to_apply = null, ?float $inv_netreturn = null, ?float $inv_return_to_apply = null, ?float $inv_netapplied = null, ?float $inv_previous_netapplied = null, ?float $inv_previous_netpayment = null, ?float $inv_total_to_apply = null, ?string $inv_next_invoice_date = null, ?string $inv_allow_payment_with_frozen_payment_method = null, ?string $inv_reload_inv_cxa_key = null, ?string $inv_reload_ivd_cxa_key = null, ?string $inv_select_all = null, ?string $inv_details_html = null, ?string $inv_details_text = null, ?string $inv_details_with_customer_html = null, ?string $inv_autoapply = null, ?string $inv_autoapplypayment = null, ?string $inv_installment_flag = null, ?string $inv_coe_flag = null, ?float $inv_shippable_total = null, ?float $inv_unapplied_shipping_total = null, ?string $inv_shippable_items_flag = null, ?string $inv_create_mail_record = null, ?string $inv_autoapplycredit = null, ?int $inv_invoice_detail_count = null, ?string $inv_bill_me = null, ?string $inv_HasNewLineItems = null, ?string $inv_HasOldLineItems = null, ?float $inv_total_weight = null, ?float $inv_discount = null, ?float $inv_shipping = null, ?float $inv_tax = null, ?string $inv_prd_keys = null, ?string $inv_currency_readonly = null, ?string $inv_cur_exchange_rate = null, ?string $inv_use_payment_to_apply_field = null, ?string $inv_allow_installment = null)
    {
        $this
            ->setInv_key($inv_key)
            ->setInv_proforma($inv_proforma)
            ->setInv_code($inv_code)
            ->setInv_trx_date($inv_trx_date)
            ->setInv_cst_key($inv_cst_key)
            ->setInv_add_user($inv_add_user)
            ->setInv_add_date($inv_add_date)
            ->setInv_change_user($inv_change_user)
            ->setInv_change_date($inv_change_date)
            ->setInv_code_count($inv_code_count)
            ->setInv_code_cp($inv_code_cp)
            ->setInv_delete_flag($inv_delete_flag)
            ->setInv_key_ext($inv_key_ext)
            ->setInv_ait_key($inv_ait_key)
            ->setInv_print_count($inv_print_count)
            ->setInv_print_date($inv_print_date)
            ->setInv_print_user($inv_print_user)
            ->setInv_src_key($inv_src_key)
            ->setInv_med_key($inv_med_key)
            ->setInv_post_flag($inv_post_flag)
            ->setInv_notes_internal($inv_notes_internal)
            ->setInv_bat_key($inv_bat_key)
            ->setInv_notes_external($inv_notes_external)
            ->setInv_ship_on_date($inv_ship_on_date)
            ->setInv_ship_priority($inv_ship_priority)
            ->setInv_po_number($inv_po_number)
            ->setInv_orig_trans_type($inv_orig_trans_type)
            ->setInv_fax_confirm_sent_flag($inv_fax_confirm_sent_flag)
            ->setInv_email_confirm_sent_flag($inv_email_confirm_sent_flag)
            ->setInv_cxa_key($inv_cxa_key)
            ->setInv_cph_key($inv_cph_key)
            ->setInv_cfx_key($inv_cfx_key)
            ->setInv_eml_key($inv_eml_key)
            ->setInv_pref_comm_meth($inv_pref_comm_meth)
            ->setInv_billing_pref_comm_meth($inv_billing_pref_comm_meth)
            ->setInv_close_flag($inv_close_flag)
            ->setInv_bat_close_flag($inv_bat_close_flag)
            ->setInv_entity_key($inv_entity_key)
            ->setInv_col_key($inv_col_key)
            ->setInv_cst_billing_key($inv_cst_billing_key)
            ->setInv_ind_cst_billing_key($inv_ind_cst_billing_key)
            ->setInv_ord_key($inv_ord_key)
            ->setInv_tracking_number($inv_tracking_number)
            ->setInv_group_flag($inv_group_flag)
            ->setInv_group_description($inv_group_description)
            ->setInv_cur_key($inv_cur_key)
            ->setInv_allow_installments($inv_allow_installments)
            ->setInv_sfo_key($inv_sfo_key)
            ->setInv_pbs_key($inv_pbs_key)
            ->setInv_AutoRefund($inv_AutoRefund)
            ->setInv_eweb_credit_available($inv_eweb_credit_available)
            ->setInv_send_email_confirmation($inv_send_email_confirmation)
            ->setInv_eweb_apply_credit_amount($inv_eweb_apply_credit_amount)
            ->setInv_send_fax_confirmation($inv_send_fax_confirmation)
            ->setInv_adjustment_reason($inv_adjustment_reason)
            ->setInv_available_installment_milestone_schedules($inv_available_installment_milestone_schedules)
            ->setInv_collection_status($inv_collection_status)
            ->setInv_cty_code($inv_cty_code)
            ->setInv_installment_milestone_schedule($inv_installment_milestone_schedule)
            ->setInv_NewBatch_key($inv_NewBatch_key)
            ->setInv_cst_first_last_name($inv_cst_first_last_name)
            ->setInv_email_bcc($inv_email_bcc)
            ->setInv_total($inv_total)
            ->setInv_amount($inv_amount)
            ->setInv_balance($inv_balance)
            ->setInv_payment_to_apply_distributed($inv_payment_to_apply_distributed)
            ->setInv_close_opportunity($inv_close_opportunity)
            ->setInv_credit_to_apply_distributed($inv_credit_to_apply_distributed)
            ->setInv_distributable_credit_total($inv_distributable_credit_total)
            ->setInv_distributable_credit_balance($inv_distributable_credit_balance)
            ->setInv_paid_by_liability_balance($inv_paid_by_liability_balance)
            ->setInv_payment_to_apply($inv_payment_to_apply)
            ->setInv_convertedamount($inv_convertedamount)
            ->setInv_nettotal($inv_nettotal)
            ->setInv_netpayment($inv_netpayment)
            ->setInv_credit_to_apply($inv_credit_to_apply)
            ->setInv_netbalance($inv_netbalance)
            ->setInv_netcredit($inv_netcredit)
            ->setInv_net_amount_due($inv_net_amount_due)
            ->setInv_netunpaidbalance($inv_netunpaidbalance)
            ->setInv_netwriteoff($inv_netwriteoff)
            ->setInv_writeoff_to_apply($inv_writeoff_to_apply)
            ->setInv_netreturn($inv_netreturn)
            ->setInv_return_to_apply($inv_return_to_apply)
            ->setInv_netapplied($inv_netapplied)
            ->setInv_previous_netapplied($inv_previous_netapplied)
            ->setInv_previous_netpayment($inv_previous_netpayment)
            ->setInv_total_to_apply($inv_total_to_apply)
            ->setInv_next_invoice_date($inv_next_invoice_date)
            ->setInv_allow_payment_with_frozen_payment_method($inv_allow_payment_with_frozen_payment_method)
            ->setInv_reload_inv_cxa_key($inv_reload_inv_cxa_key)
            ->setInv_reload_ivd_cxa_key($inv_reload_ivd_cxa_key)
            ->setInv_select_all($inv_select_all)
            ->setInv_details_html($inv_details_html)
            ->setInv_details_text($inv_details_text)
            ->setInv_details_with_customer_html($inv_details_with_customer_html)
            ->setInv_autoapply($inv_autoapply)
            ->setInv_autoapplypayment($inv_autoapplypayment)
            ->setInv_installment_flag($inv_installment_flag)
            ->setInv_coe_flag($inv_coe_flag)
            ->setInv_shippable_total($inv_shippable_total)
            ->setInv_unapplied_shipping_total($inv_unapplied_shipping_total)
            ->setInv_shippable_items_flag($inv_shippable_items_flag)
            ->setInv_create_mail_record($inv_create_mail_record)
            ->setInv_autoapplycredit($inv_autoapplycredit)
            ->setInv_invoice_detail_count($inv_invoice_detail_count)
            ->setInv_bill_me($inv_bill_me)
            ->setInv_HasNewLineItems($inv_HasNewLineItems)
            ->setInv_HasOldLineItems($inv_HasOldLineItems)
            ->setInv_total_weight($inv_total_weight)
            ->setInv_discount($inv_discount)
            ->setInv_shipping($inv_shipping)
            ->setInv_tax($inv_tax)
            ->setInv_prd_keys($inv_prd_keys)
            ->setInv_currency_readonly($inv_currency_readonly)
            ->setInv_cur_exchange_rate($inv_cur_exchange_rate)
            ->setInv_use_payment_to_apply_field($inv_use_payment_to_apply_field)
            ->setInv_allow_installment($inv_allow_installment);
    }
    /**
     * Get inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_key(): ?string
    {
        return $this->inv_key ?? null;
    }
    /**
     * Set inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_key(?string $inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_key) && !is_string($inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_key, true), gettype($inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_key, true)), __LINE__);
        }
        if (is_null($inv_key) || (is_array($inv_key) && empty($inv_key))) {
            unset($this->inv_key);
        } else {
            $this->inv_key = $inv_key;
        }
        
        return $this;
    }
    /**
     * Get inv_proforma value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_proforma(): ?string
    {
        return $this->inv_proforma ?? null;
    }
    /**
     * Set inv_proforma value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_proforma
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_proforma(?string $inv_proforma = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_proforma) && !is_string($inv_proforma)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_proforma, true), gettype($inv_proforma)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_proforma) && $inv_proforma > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_proforma, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_proforma) && $inv_proforma < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_proforma, true)), __LINE__);
        }
        if (is_null($inv_proforma) || (is_array($inv_proforma) && empty($inv_proforma))) {
            unset($this->inv_proforma);
        } else {
            $this->inv_proforma = $inv_proforma;
        }
        
        return $this;
    }
    /**
     * Get inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_code(): ?string
    {
        return $this->inv_code ?? null;
    }
    /**
     * Set inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_code(?string $inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_code) && !is_string($inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_code, true), gettype($inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($inv_code) && mb_strlen((string) $inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $inv_code)), __LINE__);
        }
        if (is_null($inv_code) || (is_array($inv_code) && empty($inv_code))) {
            unset($this->inv_code);
        } else {
            $this->inv_code = $inv_code;
        }
        
        return $this;
    }
    /**
     * Get inv_trx_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_trx_date(): ?string
    {
        return $this->inv_trx_date ?? null;
    }
    /**
     * Set inv_trx_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_trx_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_trx_date(?string $inv_trx_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_trx_date) && !is_string($inv_trx_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_trx_date, true), gettype($inv_trx_date)), __LINE__);
        }
        if (is_null($inv_trx_date) || (is_array($inv_trx_date) && empty($inv_trx_date))) {
            unset($this->inv_trx_date);
        } else {
            $this->inv_trx_date = $inv_trx_date;
        }
        
        return $this;
    }
    /**
     * Get inv_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cst_key(): ?string
    {
        return $this->inv_cst_key ?? null;
    }
    /**
     * Set inv_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_cst_key(?string $inv_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cst_key) && !is_string($inv_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cst_key, true), gettype($inv_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cst_key, true)), __LINE__);
        }
        if (is_null($inv_cst_key) || (is_array($inv_cst_key) && empty($inv_cst_key))) {
            unset($this->inv_cst_key);
        } else {
            $this->inv_cst_key = $inv_cst_key;
        }
        
        return $this;
    }
    /**
     * Get inv_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_add_user(): ?string
    {
        return $this->inv_add_user ?? null;
    }
    /**
     * Set inv_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_add_user(?string $inv_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_add_user) && !is_string($inv_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_add_user, true), gettype($inv_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($inv_add_user) && mb_strlen((string) $inv_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $inv_add_user)), __LINE__);
        }
        if (is_null($inv_add_user) || (is_array($inv_add_user) && empty($inv_add_user))) {
            unset($this->inv_add_user);
        } else {
            $this->inv_add_user = $inv_add_user;
        }
        
        return $this;
    }
    /**
     * Get inv_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_add_date(): ?string
    {
        return $this->inv_add_date ?? null;
    }
    /**
     * Set inv_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_add_date(?string $inv_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_add_date) && !is_string($inv_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_add_date, true), gettype($inv_add_date)), __LINE__);
        }
        if (is_null($inv_add_date) || (is_array($inv_add_date) && empty($inv_add_date))) {
            unset($this->inv_add_date);
        } else {
            $this->inv_add_date = $inv_add_date;
        }
        
        return $this;
    }
    /**
     * Get inv_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_change_user(): ?string
    {
        return $this->inv_change_user ?? null;
    }
    /**
     * Set inv_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_change_user(?string $inv_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_change_user) && !is_string($inv_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_change_user, true), gettype($inv_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($inv_change_user) && mb_strlen((string) $inv_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $inv_change_user)), __LINE__);
        }
        if (is_null($inv_change_user) || (is_array($inv_change_user) && empty($inv_change_user))) {
            unset($this->inv_change_user);
        } else {
            $this->inv_change_user = $inv_change_user;
        }
        
        return $this;
    }
    /**
     * Get inv_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_change_date(): ?string
    {
        return $this->inv_change_date ?? null;
    }
    /**
     * Set inv_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_change_date(?string $inv_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_change_date) && !is_string($inv_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_change_date, true), gettype($inv_change_date)), __LINE__);
        }
        if (is_null($inv_change_date) || (is_array($inv_change_date) && empty($inv_change_date))) {
            unset($this->inv_change_date);
        } else {
            $this->inv_change_date = $inv_change_date;
        }
        
        return $this;
    }
    /**
     * Get inv_code_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInv_code_count(): ?int
    {
        return $this->inv_code_count ?? null;
    }
    /**
     * Set inv_code_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inv_code_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_code_count(?int $inv_code_count = null): self
    {
        // validation for constraint: int
        if (!is_null($inv_code_count) && !(is_int($inv_code_count) || ctype_digit($inv_code_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inv_code_count, true), gettype($inv_code_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($inv_code_count) && $inv_code_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($inv_code_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($inv_code_count) && $inv_code_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($inv_code_count, true)), __LINE__);
        }
        if (is_null($inv_code_count) || (is_array($inv_code_count) && empty($inv_code_count))) {
            unset($this->inv_code_count);
        } else {
            $this->inv_code_count = $inv_code_count;
        }
        
        return $this;
    }
    /**
     * Get inv_code_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_code_cp(): ?string
    {
        return $this->inv_code_cp ?? null;
    }
    /**
     * Set inv_code_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_code_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_code_cp(?string $inv_code_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_code_cp) && !is_string($inv_code_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_code_cp, true), gettype($inv_code_cp)), __LINE__);
        }
        // validation for constraint: maxLength(54)
        if (!is_null($inv_code_cp) && mb_strlen((string) $inv_code_cp) > 54) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 54', mb_strlen((string) $inv_code_cp)), __LINE__);
        }
        if (is_null($inv_code_cp) || (is_array($inv_code_cp) && empty($inv_code_cp))) {
            unset($this->inv_code_cp);
        } else {
            $this->inv_code_cp = $inv_code_cp;
        }
        
        return $this;
    }
    /**
     * Get inv_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_delete_flag(): ?string
    {
        return $this->inv_delete_flag ?? null;
    }
    /**
     * Set inv_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_delete_flag(?string $inv_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_delete_flag) && !is_string($inv_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_delete_flag, true), gettype($inv_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_delete_flag) && $inv_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_delete_flag) && $inv_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_delete_flag, true)), __LINE__);
        }
        if (is_null($inv_delete_flag) || (is_array($inv_delete_flag) && empty($inv_delete_flag))) {
            unset($this->inv_delete_flag);
        } else {
            $this->inv_delete_flag = $inv_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_key_ext(): ?string
    {
        return $this->inv_key_ext ?? null;
    }
    /**
     * Set inv_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_key_ext(?string $inv_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_key_ext) && !is_string($inv_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_key_ext, true), gettype($inv_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_key_ext, true)), __LINE__);
        }
        if (is_null($inv_key_ext) || (is_array($inv_key_ext) && empty($inv_key_ext))) {
            unset($this->inv_key_ext);
        } else {
            $this->inv_key_ext = $inv_key_ext;
        }
        
        return $this;
    }
    /**
     * Get inv_ait_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_ait_key(): ?string
    {
        return $this->inv_ait_key ?? null;
    }
    /**
     * Set inv_ait_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_ait_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_ait_key(?string $inv_ait_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_ait_key) && !is_string($inv_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_ait_key, true), gettype($inv_ait_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_ait_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_ait_key, true)), __LINE__);
        }
        if (is_null($inv_ait_key) || (is_array($inv_ait_key) && empty($inv_ait_key))) {
            unset($this->inv_ait_key);
        } else {
            $this->inv_ait_key = $inv_ait_key;
        }
        
        return $this;
    }
    /**
     * Get inv_print_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInv_print_count(): ?int
    {
        return $this->inv_print_count ?? null;
    }
    /**
     * Set inv_print_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inv_print_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_print_count(?int $inv_print_count = null): self
    {
        // validation for constraint: int
        if (!is_null($inv_print_count) && !(is_int($inv_print_count) || ctype_digit($inv_print_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inv_print_count, true), gettype($inv_print_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($inv_print_count) && $inv_print_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($inv_print_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($inv_print_count) && $inv_print_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($inv_print_count, true)), __LINE__);
        }
        if (is_null($inv_print_count) || (is_array($inv_print_count) && empty($inv_print_count))) {
            unset($this->inv_print_count);
        } else {
            $this->inv_print_count = $inv_print_count;
        }
        
        return $this;
    }
    /**
     * Get inv_print_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_print_date(): ?string
    {
        return $this->inv_print_date ?? null;
    }
    /**
     * Set inv_print_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_print_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_print_date(?string $inv_print_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_print_date) && !is_string($inv_print_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_print_date, true), gettype($inv_print_date)), __LINE__);
        }
        if (is_null($inv_print_date) || (is_array($inv_print_date) && empty($inv_print_date))) {
            unset($this->inv_print_date);
        } else {
            $this->inv_print_date = $inv_print_date;
        }
        
        return $this;
    }
    /**
     * Get inv_print_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_print_user(): ?string
    {
        return $this->inv_print_user ?? null;
    }
    /**
     * Set inv_print_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_print_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_print_user(?string $inv_print_user = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_print_user) && !is_string($inv_print_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_print_user, true), gettype($inv_print_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($inv_print_user) && mb_strlen((string) $inv_print_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $inv_print_user)), __LINE__);
        }
        if (is_null($inv_print_user) || (is_array($inv_print_user) && empty($inv_print_user))) {
            unset($this->inv_print_user);
        } else {
            $this->inv_print_user = $inv_print_user;
        }
        
        return $this;
    }
    /**
     * Get inv_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_src_key(): ?string
    {
        return $this->inv_src_key ?? null;
    }
    /**
     * Set inv_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_src_key(?string $inv_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_src_key) && !is_string($inv_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_src_key, true), gettype($inv_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_src_key, true)), __LINE__);
        }
        if (is_null($inv_src_key) || (is_array($inv_src_key) && empty($inv_src_key))) {
            unset($this->inv_src_key);
        } else {
            $this->inv_src_key = $inv_src_key;
        }
        
        return $this;
    }
    /**
     * Get inv_med_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_med_key(): ?string
    {
        return $this->inv_med_key ?? null;
    }
    /**
     * Set inv_med_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_med_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_med_key(?string $inv_med_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_med_key) && !is_string($inv_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_med_key, true), gettype($inv_med_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_med_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_med_key, true)), __LINE__);
        }
        if (is_null($inv_med_key) || (is_array($inv_med_key) && empty($inv_med_key))) {
            unset($this->inv_med_key);
        } else {
            $this->inv_med_key = $inv_med_key;
        }
        
        return $this;
    }
    /**
     * Get inv_post_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_post_flag(): ?string
    {
        return $this->inv_post_flag ?? null;
    }
    /**
     * Set inv_post_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_post_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_post_flag(?string $inv_post_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_post_flag) && !is_string($inv_post_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_post_flag, true), gettype($inv_post_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_post_flag) && $inv_post_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_post_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_post_flag) && $inv_post_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_post_flag, true)), __LINE__);
        }
        if (is_null($inv_post_flag) || (is_array($inv_post_flag) && empty($inv_post_flag))) {
            unset($this->inv_post_flag);
        } else {
            $this->inv_post_flag = $inv_post_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_notes_internal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_notes_internal(): ?string
    {
        return $this->inv_notes_internal ?? null;
    }
    /**
     * Set inv_notes_internal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_notes_internal
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_notes_internal(?string $inv_notes_internal = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_notes_internal) && !is_string($inv_notes_internal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_notes_internal, true), gettype($inv_notes_internal)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($inv_notes_internal) && mb_strlen((string) $inv_notes_internal) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $inv_notes_internal)), __LINE__);
        }
        if (is_null($inv_notes_internal) || (is_array($inv_notes_internal) && empty($inv_notes_internal))) {
            unset($this->inv_notes_internal);
        } else {
            $this->inv_notes_internal = $inv_notes_internal;
        }
        
        return $this;
    }
    /**
     * Get inv_bat_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_bat_key(): ?string
    {
        return $this->inv_bat_key ?? null;
    }
    /**
     * Set inv_bat_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_bat_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_bat_key(?string $inv_bat_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_bat_key) && !is_string($inv_bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_bat_key, true), gettype($inv_bat_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_bat_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_bat_key, true)), __LINE__);
        }
        if (is_null($inv_bat_key) || (is_array($inv_bat_key) && empty($inv_bat_key))) {
            unset($this->inv_bat_key);
        } else {
            $this->inv_bat_key = $inv_bat_key;
        }
        
        return $this;
    }
    /**
     * Get inv_notes_external value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_notes_external(): ?string
    {
        return $this->inv_notes_external ?? null;
    }
    /**
     * Set inv_notes_external value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_notes_external
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_notes_external(?string $inv_notes_external = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_notes_external) && !is_string($inv_notes_external)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_notes_external, true), gettype($inv_notes_external)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($inv_notes_external) && mb_strlen((string) $inv_notes_external) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $inv_notes_external)), __LINE__);
        }
        if (is_null($inv_notes_external) || (is_array($inv_notes_external) && empty($inv_notes_external))) {
            unset($this->inv_notes_external);
        } else {
            $this->inv_notes_external = $inv_notes_external;
        }
        
        return $this;
    }
    /**
     * Get inv_ship_on_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_ship_on_date(): ?string
    {
        return $this->inv_ship_on_date ?? null;
    }
    /**
     * Set inv_ship_on_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_ship_on_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_ship_on_date(?string $inv_ship_on_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_ship_on_date) && !is_string($inv_ship_on_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_ship_on_date, true), gettype($inv_ship_on_date)), __LINE__);
        }
        if (is_null($inv_ship_on_date) || (is_array($inv_ship_on_date) && empty($inv_ship_on_date))) {
            unset($this->inv_ship_on_date);
        } else {
            $this->inv_ship_on_date = $inv_ship_on_date;
        }
        
        return $this;
    }
    /**
     * Get inv_ship_priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInv_ship_priority(): ?int
    {
        return $this->inv_ship_priority ?? null;
    }
    /**
     * Set inv_ship_priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inv_ship_priority
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_ship_priority(?int $inv_ship_priority = null): self
    {
        // validation for constraint: int
        if (!is_null($inv_ship_priority) && !(is_int($inv_ship_priority) || ctype_digit($inv_ship_priority))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inv_ship_priority, true), gettype($inv_ship_priority)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($inv_ship_priority) && $inv_ship_priority > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($inv_ship_priority, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($inv_ship_priority) && $inv_ship_priority < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($inv_ship_priority, true)), __LINE__);
        }
        if (is_null($inv_ship_priority) || (is_array($inv_ship_priority) && empty($inv_ship_priority))) {
            unset($this->inv_ship_priority);
        } else {
            $this->inv_ship_priority = $inv_ship_priority;
        }
        
        return $this;
    }
    /**
     * Get inv_po_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_po_number(): ?string
    {
        return $this->inv_po_number ?? null;
    }
    /**
     * Set inv_po_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_po_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_po_number(?string $inv_po_number = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_po_number) && !is_string($inv_po_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_po_number, true), gettype($inv_po_number)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($inv_po_number) && mb_strlen((string) $inv_po_number) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $inv_po_number)), __LINE__);
        }
        if (is_null($inv_po_number) || (is_array($inv_po_number) && empty($inv_po_number))) {
            unset($this->inv_po_number);
        } else {
            $this->inv_po_number = $inv_po_number;
        }
        
        return $this;
    }
    /**
     * Get inv_orig_trans_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_orig_trans_type(): ?string
    {
        return $this->inv_orig_trans_type ?? null;
    }
    /**
     * Set inv_orig_trans_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_orig_trans_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_orig_trans_type(?string $inv_orig_trans_type = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_orig_trans_type) && !is_string($inv_orig_trans_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_orig_trans_type, true), gettype($inv_orig_trans_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($inv_orig_trans_type) && mb_strlen((string) $inv_orig_trans_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $inv_orig_trans_type)), __LINE__);
        }
        if (is_null($inv_orig_trans_type) || (is_array($inv_orig_trans_type) && empty($inv_orig_trans_type))) {
            unset($this->inv_orig_trans_type);
        } else {
            $this->inv_orig_trans_type = $inv_orig_trans_type;
        }
        
        return $this;
    }
    /**
     * Get inv_fax_confirm_sent_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_fax_confirm_sent_flag(): ?string
    {
        return $this->inv_fax_confirm_sent_flag ?? null;
    }
    /**
     * Set inv_fax_confirm_sent_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_fax_confirm_sent_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_fax_confirm_sent_flag(?string $inv_fax_confirm_sent_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_fax_confirm_sent_flag) && !is_string($inv_fax_confirm_sent_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_fax_confirm_sent_flag, true), gettype($inv_fax_confirm_sent_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_fax_confirm_sent_flag) && $inv_fax_confirm_sent_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_fax_confirm_sent_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_fax_confirm_sent_flag) && $inv_fax_confirm_sent_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_fax_confirm_sent_flag, true)), __LINE__);
        }
        if (is_null($inv_fax_confirm_sent_flag) || (is_array($inv_fax_confirm_sent_flag) && empty($inv_fax_confirm_sent_flag))) {
            unset($this->inv_fax_confirm_sent_flag);
        } else {
            $this->inv_fax_confirm_sent_flag = $inv_fax_confirm_sent_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_email_confirm_sent_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_email_confirm_sent_flag(): ?string
    {
        return $this->inv_email_confirm_sent_flag ?? null;
    }
    /**
     * Set inv_email_confirm_sent_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_email_confirm_sent_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_email_confirm_sent_flag(?string $inv_email_confirm_sent_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_email_confirm_sent_flag) && !is_string($inv_email_confirm_sent_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_email_confirm_sent_flag, true), gettype($inv_email_confirm_sent_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_email_confirm_sent_flag) && $inv_email_confirm_sent_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_email_confirm_sent_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_email_confirm_sent_flag) && $inv_email_confirm_sent_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_email_confirm_sent_flag, true)), __LINE__);
        }
        if (is_null($inv_email_confirm_sent_flag) || (is_array($inv_email_confirm_sent_flag) && empty($inv_email_confirm_sent_flag))) {
            unset($this->inv_email_confirm_sent_flag);
        } else {
            $this->inv_email_confirm_sent_flag = $inv_email_confirm_sent_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cxa_key(): ?string
    {
        return $this->inv_cxa_key ?? null;
    }
    /**
     * Set inv_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_cxa_key(?string $inv_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cxa_key) && !is_string($inv_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cxa_key, true), gettype($inv_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cxa_key, true)), __LINE__);
        }
        if (is_null($inv_cxa_key) || (is_array($inv_cxa_key) && empty($inv_cxa_key))) {
            unset($this->inv_cxa_key);
        } else {
            $this->inv_cxa_key = $inv_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get inv_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cph_key(): ?string
    {
        return $this->inv_cph_key ?? null;
    }
    /**
     * Set inv_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_cph_key(?string $inv_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cph_key) && !is_string($inv_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cph_key, true), gettype($inv_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cph_key, true)), __LINE__);
        }
        if (is_null($inv_cph_key) || (is_array($inv_cph_key) && empty($inv_cph_key))) {
            unset($this->inv_cph_key);
        } else {
            $this->inv_cph_key = $inv_cph_key;
        }
        
        return $this;
    }
    /**
     * Get inv_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cfx_key(): ?string
    {
        return $this->inv_cfx_key ?? null;
    }
    /**
     * Set inv_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_cfx_key(?string $inv_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cfx_key) && !is_string($inv_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cfx_key, true), gettype($inv_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cfx_key, true)), __LINE__);
        }
        if (is_null($inv_cfx_key) || (is_array($inv_cfx_key) && empty($inv_cfx_key))) {
            unset($this->inv_cfx_key);
        } else {
            $this->inv_cfx_key = $inv_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get inv_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_eml_key(): ?string
    {
        return $this->inv_eml_key ?? null;
    }
    /**
     * Set inv_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_eml_key(?string $inv_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_eml_key) && !is_string($inv_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_eml_key, true), gettype($inv_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_eml_key, true)), __LINE__);
        }
        if (is_null($inv_eml_key) || (is_array($inv_eml_key) && empty($inv_eml_key))) {
            unset($this->inv_eml_key);
        } else {
            $this->inv_eml_key = $inv_eml_key;
        }
        
        return $this;
    }
    /**
     * Get inv_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_pref_comm_meth(): ?string
    {
        return $this->inv_pref_comm_meth ?? null;
    }
    /**
     * Set inv_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_pref_comm_meth(?string $inv_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_pref_comm_meth) && !is_string($inv_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_pref_comm_meth, true), gettype($inv_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($inv_pref_comm_meth) && mb_strlen((string) $inv_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $inv_pref_comm_meth)), __LINE__);
        }
        if (is_null($inv_pref_comm_meth) || (is_array($inv_pref_comm_meth) && empty($inv_pref_comm_meth))) {
            unset($this->inv_pref_comm_meth);
        } else {
            $this->inv_pref_comm_meth = $inv_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get inv_billing_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_billing_pref_comm_meth(): ?string
    {
        return $this->inv_billing_pref_comm_meth ?? null;
    }
    /**
     * Set inv_billing_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_billing_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_billing_pref_comm_meth(?string $inv_billing_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_billing_pref_comm_meth) && !is_string($inv_billing_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_billing_pref_comm_meth, true), gettype($inv_billing_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($inv_billing_pref_comm_meth) && mb_strlen((string) $inv_billing_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $inv_billing_pref_comm_meth)), __LINE__);
        }
        if (is_null($inv_billing_pref_comm_meth) || (is_array($inv_billing_pref_comm_meth) && empty($inv_billing_pref_comm_meth))) {
            unset($this->inv_billing_pref_comm_meth);
        } else {
            $this->inv_billing_pref_comm_meth = $inv_billing_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get inv_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_close_flag(): ?string
    {
        return $this->inv_close_flag ?? null;
    }
    /**
     * Set inv_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_close_flag(?string $inv_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_close_flag) && !is_string($inv_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_close_flag, true), gettype($inv_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_close_flag) && $inv_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_close_flag) && $inv_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_close_flag, true)), __LINE__);
        }
        if (is_null($inv_close_flag) || (is_array($inv_close_flag) && empty($inv_close_flag))) {
            unset($this->inv_close_flag);
        } else {
            $this->inv_close_flag = $inv_close_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_bat_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_bat_close_flag(): ?string
    {
        return $this->inv_bat_close_flag ?? null;
    }
    /**
     * Set inv_bat_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_bat_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_bat_close_flag(?string $inv_bat_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_bat_close_flag) && !is_string($inv_bat_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_bat_close_flag, true), gettype($inv_bat_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_bat_close_flag) && $inv_bat_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_bat_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_bat_close_flag) && $inv_bat_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_bat_close_flag, true)), __LINE__);
        }
        if (is_null($inv_bat_close_flag) || (is_array($inv_bat_close_flag) && empty($inv_bat_close_flag))) {
            unset($this->inv_bat_close_flag);
        } else {
            $this->inv_bat_close_flag = $inv_bat_close_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_entity_key(): ?string
    {
        return $this->inv_entity_key ?? null;
    }
    /**
     * Set inv_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_entity_key(?string $inv_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_entity_key) && !is_string($inv_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_entity_key, true), gettype($inv_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_entity_key, true)), __LINE__);
        }
        if (is_null($inv_entity_key) || (is_array($inv_entity_key) && empty($inv_entity_key))) {
            unset($this->inv_entity_key);
        } else {
            $this->inv_entity_key = $inv_entity_key;
        }
        
        return $this;
    }
    /**
     * Get inv_col_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_col_key(): ?string
    {
        return $this->inv_col_key ?? null;
    }
    /**
     * Set inv_col_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_col_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_col_key(?string $inv_col_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_col_key) && !is_string($inv_col_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_col_key, true), gettype($inv_col_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_col_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_col_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_col_key, true)), __LINE__);
        }
        if (is_null($inv_col_key) || (is_array($inv_col_key) && empty($inv_col_key))) {
            unset($this->inv_col_key);
        } else {
            $this->inv_col_key = $inv_col_key;
        }
        
        return $this;
    }
    /**
     * Get inv_cst_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cst_billing_key(): ?string
    {
        return $this->inv_cst_billing_key ?? null;
    }
    /**
     * Set inv_cst_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cst_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_cst_billing_key(?string $inv_cst_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cst_billing_key) && !is_string($inv_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cst_billing_key, true), gettype($inv_cst_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cst_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cst_billing_key, true)), __LINE__);
        }
        if (is_null($inv_cst_billing_key) || (is_array($inv_cst_billing_key) && empty($inv_cst_billing_key))) {
            unset($this->inv_cst_billing_key);
        } else {
            $this->inv_cst_billing_key = $inv_cst_billing_key;
        }
        
        return $this;
    }
    /**
     * Get inv_ind_cst_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_ind_cst_billing_key(): ?string
    {
        return $this->inv_ind_cst_billing_key ?? null;
    }
    /**
     * Set inv_ind_cst_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_ind_cst_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_ind_cst_billing_key(?string $inv_ind_cst_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_ind_cst_billing_key) && !is_string($inv_ind_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_ind_cst_billing_key, true), gettype($inv_ind_cst_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_ind_cst_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_ind_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_ind_cst_billing_key, true)), __LINE__);
        }
        if (is_null($inv_ind_cst_billing_key) || (is_array($inv_ind_cst_billing_key) && empty($inv_ind_cst_billing_key))) {
            unset($this->inv_ind_cst_billing_key);
        } else {
            $this->inv_ind_cst_billing_key = $inv_ind_cst_billing_key;
        }
        
        return $this;
    }
    /**
     * Get inv_ord_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_ord_key(): ?string
    {
        return $this->inv_ord_key ?? null;
    }
    /**
     * Set inv_ord_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_ord_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_ord_key(?string $inv_ord_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_ord_key) && !is_string($inv_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_ord_key, true), gettype($inv_ord_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_ord_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_ord_key, true)), __LINE__);
        }
        if (is_null($inv_ord_key) || (is_array($inv_ord_key) && empty($inv_ord_key))) {
            unset($this->inv_ord_key);
        } else {
            $this->inv_ord_key = $inv_ord_key;
        }
        
        return $this;
    }
    /**
     * Get inv_tracking_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_tracking_number(): ?string
    {
        return $this->inv_tracking_number ?? null;
    }
    /**
     * Set inv_tracking_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_tracking_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_tracking_number(?string $inv_tracking_number = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_tracking_number) && !is_string($inv_tracking_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_tracking_number, true), gettype($inv_tracking_number)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($inv_tracking_number) && mb_strlen((string) $inv_tracking_number) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $inv_tracking_number)), __LINE__);
        }
        if (is_null($inv_tracking_number) || (is_array($inv_tracking_number) && empty($inv_tracking_number))) {
            unset($this->inv_tracking_number);
        } else {
            $this->inv_tracking_number = $inv_tracking_number;
        }
        
        return $this;
    }
    /**
     * Get inv_group_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_group_flag(): ?string
    {
        return $this->inv_group_flag ?? null;
    }
    /**
     * Set inv_group_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_group_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_group_flag(?string $inv_group_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_group_flag) && !is_string($inv_group_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_group_flag, true), gettype($inv_group_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_group_flag) && $inv_group_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_group_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_group_flag) && $inv_group_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_group_flag, true)), __LINE__);
        }
        if (is_null($inv_group_flag) || (is_array($inv_group_flag) && empty($inv_group_flag))) {
            unset($this->inv_group_flag);
        } else {
            $this->inv_group_flag = $inv_group_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_group_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_group_description(): ?string
    {
        return $this->inv_group_description ?? null;
    }
    /**
     * Set inv_group_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_group_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_group_description(?string $inv_group_description = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_group_description) && !is_string($inv_group_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_group_description, true), gettype($inv_group_description)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($inv_group_description) && mb_strlen((string) $inv_group_description) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $inv_group_description)), __LINE__);
        }
        if (is_null($inv_group_description) || (is_array($inv_group_description) && empty($inv_group_description))) {
            unset($this->inv_group_description);
        } else {
            $this->inv_group_description = $inv_group_description;
        }
        
        return $this;
    }
    /**
     * Get inv_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cur_key(): ?string
    {
        return $this->inv_cur_key ?? null;
    }
    /**
     * Set inv_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_cur_key(?string $inv_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cur_key) && !is_string($inv_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cur_key, true), gettype($inv_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cur_key, true)), __LINE__);
        }
        if (is_null($inv_cur_key) || (is_array($inv_cur_key) && empty($inv_cur_key))) {
            unset($this->inv_cur_key);
        } else {
            $this->inv_cur_key = $inv_cur_key;
        }
        
        return $this;
    }
    /**
     * Get inv_allow_installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInv_allow_installments(): ?bool
    {
        return $this->inv_allow_installments ?? null;
    }
    /**
     * Set inv_allow_installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inv_allow_installments
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_allow_installments(?bool $inv_allow_installments = null): self
    {
        // validation for constraint: boolean
        if (!is_null($inv_allow_installments) && !is_bool($inv_allow_installments)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inv_allow_installments, true), gettype($inv_allow_installments)), __LINE__);
        }
        // validation for constraint: pattern([0-1])
        if (!is_null($inv_allow_installments) && !preg_match('/[0-1]/', (string) $inv_allow_installments)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-1]/', var_export($inv_allow_installments, true)), __LINE__);
        }
        if (is_null($inv_allow_installments) || (is_array($inv_allow_installments) && empty($inv_allow_installments))) {
            unset($this->inv_allow_installments);
        } else {
            $this->inv_allow_installments = $inv_allow_installments;
        }
        
        return $this;
    }
    /**
     * Get inv_sfo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_sfo_key(): ?string
    {
        return $this->inv_sfo_key ?? null;
    }
    /**
     * Set inv_sfo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_sfo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_sfo_key(?string $inv_sfo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_sfo_key) && !is_string($inv_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_sfo_key, true), gettype($inv_sfo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_sfo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_sfo_key, true)), __LINE__);
        }
        if (is_null($inv_sfo_key) || (is_array($inv_sfo_key) && empty($inv_sfo_key))) {
            unset($this->inv_sfo_key);
        } else {
            $this->inv_sfo_key = $inv_sfo_key;
        }
        
        return $this;
    }
    /**
     * Get inv_pbs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_pbs_key(): ?string
    {
        return $this->inv_pbs_key ?? null;
    }
    /**
     * Set inv_pbs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_pbs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_pbs_key(?string $inv_pbs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_pbs_key) && !is_string($inv_pbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_pbs_key, true), gettype($inv_pbs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_pbs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_pbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_pbs_key, true)), __LINE__);
        }
        if (is_null($inv_pbs_key) || (is_array($inv_pbs_key) && empty($inv_pbs_key))) {
            unset($this->inv_pbs_key);
        } else {
            $this->inv_pbs_key = $inv_pbs_key;
        }
        
        return $this;
    }
    /**
     * Get inv_AutoRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_AutoRefund(): ?string
    {
        return $this->inv_AutoRefund ?? null;
    }
    /**
     * Set inv_AutoRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_AutoRefund
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_AutoRefund(?string $inv_AutoRefund = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_AutoRefund) && !is_string($inv_AutoRefund)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_AutoRefund, true), gettype($inv_AutoRefund)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_AutoRefund) && $inv_AutoRefund > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_AutoRefund, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_AutoRefund) && $inv_AutoRefund < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_AutoRefund, true)), __LINE__);
        }
        if (is_null($inv_AutoRefund) || (is_array($inv_AutoRefund) && empty($inv_AutoRefund))) {
            unset($this->inv_AutoRefund);
        } else {
            $this->inv_AutoRefund = $inv_AutoRefund;
        }
        
        return $this;
    }
    /**
     * Get inv_eweb_credit_available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_eweb_credit_available(): ?float
    {
        return $this->inv_eweb_credit_available ?? null;
    }
    /**
     * Set inv_eweb_credit_available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_eweb_credit_available
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_eweb_credit_available(?float $inv_eweb_credit_available = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_eweb_credit_available) && !(is_float($inv_eweb_credit_available) || is_numeric($inv_eweb_credit_available))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_eweb_credit_available, true), gettype($inv_eweb_credit_available)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_eweb_credit_available) && mb_strlen(mb_substr((string) $inv_eweb_credit_available, false !== mb_strpos((string) $inv_eweb_credit_available, '.') ? mb_strpos((string) $inv_eweb_credit_available, '.') + 1 : mb_strlen((string) $inv_eweb_credit_available))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_eweb_credit_available, true), mb_strlen(mb_substr((string) $inv_eweb_credit_available, mb_strpos((string) $inv_eweb_credit_available, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_eweb_credit_available) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_eweb_credit_available)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_eweb_credit_available, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_eweb_credit_available))), __LINE__);
        }
        if (is_null($inv_eweb_credit_available) || (is_array($inv_eweb_credit_available) && empty($inv_eweb_credit_available))) {
            unset($this->inv_eweb_credit_available);
        } else {
            $this->inv_eweb_credit_available = $inv_eweb_credit_available;
        }
        
        return $this;
    }
    /**
     * Get inv_send_email_confirmation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_send_email_confirmation(): ?string
    {
        return $this->inv_send_email_confirmation ?? null;
    }
    /**
     * Set inv_send_email_confirmation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_send_email_confirmation
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_send_email_confirmation(?string $inv_send_email_confirmation = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_send_email_confirmation) && !is_string($inv_send_email_confirmation)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_send_email_confirmation, true), gettype($inv_send_email_confirmation)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_send_email_confirmation) && $inv_send_email_confirmation > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_send_email_confirmation, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_send_email_confirmation) && $inv_send_email_confirmation < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_send_email_confirmation, true)), __LINE__);
        }
        if (is_null($inv_send_email_confirmation) || (is_array($inv_send_email_confirmation) && empty($inv_send_email_confirmation))) {
            unset($this->inv_send_email_confirmation);
        } else {
            $this->inv_send_email_confirmation = $inv_send_email_confirmation;
        }
        
        return $this;
    }
    /**
     * Get inv_eweb_apply_credit_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_eweb_apply_credit_amount(): ?float
    {
        return $this->inv_eweb_apply_credit_amount ?? null;
    }
    /**
     * Set inv_eweb_apply_credit_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_eweb_apply_credit_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_eweb_apply_credit_amount(?float $inv_eweb_apply_credit_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_eweb_apply_credit_amount) && !(is_float($inv_eweb_apply_credit_amount) || is_numeric($inv_eweb_apply_credit_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_eweb_apply_credit_amount, true), gettype($inv_eweb_apply_credit_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_eweb_apply_credit_amount) && mb_strlen(mb_substr((string) $inv_eweb_apply_credit_amount, false !== mb_strpos((string) $inv_eweb_apply_credit_amount, '.') ? mb_strpos((string) $inv_eweb_apply_credit_amount, '.') + 1 : mb_strlen((string) $inv_eweb_apply_credit_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_eweb_apply_credit_amount, true), mb_strlen(mb_substr((string) $inv_eweb_apply_credit_amount, mb_strpos((string) $inv_eweb_apply_credit_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_eweb_apply_credit_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_eweb_apply_credit_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_eweb_apply_credit_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_eweb_apply_credit_amount))), __LINE__);
        }
        if (is_null($inv_eweb_apply_credit_amount) || (is_array($inv_eweb_apply_credit_amount) && empty($inv_eweb_apply_credit_amount))) {
            unset($this->inv_eweb_apply_credit_amount);
        } else {
            $this->inv_eweb_apply_credit_amount = $inv_eweb_apply_credit_amount;
        }
        
        return $this;
    }
    /**
     * Get inv_send_fax_confirmation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_send_fax_confirmation(): ?string
    {
        return $this->inv_send_fax_confirmation ?? null;
    }
    /**
     * Set inv_send_fax_confirmation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_send_fax_confirmation
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_send_fax_confirmation(?string $inv_send_fax_confirmation = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_send_fax_confirmation) && !is_string($inv_send_fax_confirmation)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_send_fax_confirmation, true), gettype($inv_send_fax_confirmation)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_send_fax_confirmation) && $inv_send_fax_confirmation > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_send_fax_confirmation, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_send_fax_confirmation) && $inv_send_fax_confirmation < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_send_fax_confirmation, true)), __LINE__);
        }
        if (is_null($inv_send_fax_confirmation) || (is_array($inv_send_fax_confirmation) && empty($inv_send_fax_confirmation))) {
            unset($this->inv_send_fax_confirmation);
        } else {
            $this->inv_send_fax_confirmation = $inv_send_fax_confirmation;
        }
        
        return $this;
    }
    /**
     * Get inv_adjustment_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_adjustment_reason(): ?string
    {
        return $this->inv_adjustment_reason ?? null;
    }
    /**
     * Set inv_adjustment_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_adjustment_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_adjustment_reason(?string $inv_adjustment_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_adjustment_reason) && !is_string($inv_adjustment_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_adjustment_reason, true), gettype($inv_adjustment_reason)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_adjustment_reason) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_adjustment_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_adjustment_reason, true)), __LINE__);
        }
        if (is_null($inv_adjustment_reason) || (is_array($inv_adjustment_reason) && empty($inv_adjustment_reason))) {
            unset($this->inv_adjustment_reason);
        } else {
            $this->inv_adjustment_reason = $inv_adjustment_reason;
        }
        
        return $this;
    }
    /**
     * Get inv_available_installment_milestone_schedules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_available_installment_milestone_schedules(): ?string
    {
        return $this->inv_available_installment_milestone_schedules ?? null;
    }
    /**
     * Set inv_available_installment_milestone_schedules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_available_installment_milestone_schedules
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_available_installment_milestone_schedules(?string $inv_available_installment_milestone_schedules = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_available_installment_milestone_schedules) && !is_string($inv_available_installment_milestone_schedules)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_available_installment_milestone_schedules, true), gettype($inv_available_installment_milestone_schedules)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_available_installment_milestone_schedules) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_available_installment_milestone_schedules)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_available_installment_milestone_schedules, true)), __LINE__);
        }
        if (is_null($inv_available_installment_milestone_schedules) || (is_array($inv_available_installment_milestone_schedules) && empty($inv_available_installment_milestone_schedules))) {
            unset($this->inv_available_installment_milestone_schedules);
        } else {
            $this->inv_available_installment_milestone_schedules = $inv_available_installment_milestone_schedules;
        }
        
        return $this;
    }
    /**
     * Get inv_collection_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_collection_status(): ?string
    {
        return $this->inv_collection_status ?? null;
    }
    /**
     * Set inv_collection_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_collection_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_collection_status(?string $inv_collection_status = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_collection_status) && !is_string($inv_collection_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_collection_status, true), gettype($inv_collection_status)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_collection_status) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_collection_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_collection_status, true)), __LINE__);
        }
        if (is_null($inv_collection_status) || (is_array($inv_collection_status) && empty($inv_collection_status))) {
            unset($this->inv_collection_status);
        } else {
            $this->inv_collection_status = $inv_collection_status;
        }
        
        return $this;
    }
    /**
     * Get inv_cty_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cty_code(): ?string
    {
        return $this->inv_cty_code ?? null;
    }
    /**
     * Set inv_cty_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cty_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_cty_code(?string $inv_cty_code = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cty_code) && !is_string($inv_cty_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cty_code, true), gettype($inv_cty_code)), __LINE__);
        }
        if (is_null($inv_cty_code) || (is_array($inv_cty_code) && empty($inv_cty_code))) {
            unset($this->inv_cty_code);
        } else {
            $this->inv_cty_code = $inv_cty_code;
        }
        
        return $this;
    }
    /**
     * Get inv_installment_milestone_schedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_installment_milestone_schedule(): ?string
    {
        return $this->inv_installment_milestone_schedule ?? null;
    }
    /**
     * Set inv_installment_milestone_schedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_installment_milestone_schedule
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_installment_milestone_schedule(?string $inv_installment_milestone_schedule = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_installment_milestone_schedule) && !is_string($inv_installment_milestone_schedule)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_installment_milestone_schedule, true), gettype($inv_installment_milestone_schedule)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_installment_milestone_schedule) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_installment_milestone_schedule)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_installment_milestone_schedule, true)), __LINE__);
        }
        if (is_null($inv_installment_milestone_schedule) || (is_array($inv_installment_milestone_schedule) && empty($inv_installment_milestone_schedule))) {
            unset($this->inv_installment_milestone_schedule);
        } else {
            $this->inv_installment_milestone_schedule = $inv_installment_milestone_schedule;
        }
        
        return $this;
    }
    /**
     * Get inv_NewBatch_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_NewBatch_key(): ?string
    {
        return $this->inv_NewBatch_key ?? null;
    }
    /**
     * Set inv_NewBatch_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_NewBatch_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_NewBatch_key(?string $inv_NewBatch_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_NewBatch_key) && !is_string($inv_NewBatch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_NewBatch_key, true), gettype($inv_NewBatch_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_NewBatch_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_NewBatch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_NewBatch_key, true)), __LINE__);
        }
        if (is_null($inv_NewBatch_key) || (is_array($inv_NewBatch_key) && empty($inv_NewBatch_key))) {
            unset($this->inv_NewBatch_key);
        } else {
            $this->inv_NewBatch_key = $inv_NewBatch_key;
        }
        
        return $this;
    }
    /**
     * Get inv_cst_first_last_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cst_first_last_name(): ?string
    {
        return $this->inv_cst_first_last_name ?? null;
    }
    /**
     * Set inv_cst_first_last_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cst_first_last_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_cst_first_last_name(?string $inv_cst_first_last_name = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cst_first_last_name) && !is_string($inv_cst_first_last_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cst_first_last_name, true), gettype($inv_cst_first_last_name)), __LINE__);
        }
        if (is_null($inv_cst_first_last_name) || (is_array($inv_cst_first_last_name) && empty($inv_cst_first_last_name))) {
            unset($this->inv_cst_first_last_name);
        } else {
            $this->inv_cst_first_last_name = $inv_cst_first_last_name;
        }
        
        return $this;
    }
    /**
     * Get inv_email_bcc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_email_bcc(): ?string
    {
        return $this->inv_email_bcc ?? null;
    }
    /**
     * Set inv_email_bcc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_email_bcc
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_email_bcc(?string $inv_email_bcc = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_email_bcc) && !is_string($inv_email_bcc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_email_bcc, true), gettype($inv_email_bcc)), __LINE__);
        }
        if (is_null($inv_email_bcc) || (is_array($inv_email_bcc) && empty($inv_email_bcc))) {
            unset($this->inv_email_bcc);
        } else {
            $this->inv_email_bcc = $inv_email_bcc;
        }
        
        return $this;
    }
    /**
     * Get inv_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_total(): ?float
    {
        return $this->inv_total ?? null;
    }
    /**
     * Set inv_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_total(?float $inv_total = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_total) && !(is_float($inv_total) || is_numeric($inv_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_total, true), gettype($inv_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_total) && mb_strlen(mb_substr((string) $inv_total, false !== mb_strpos((string) $inv_total, '.') ? mb_strpos((string) $inv_total, '.') + 1 : mb_strlen((string) $inv_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_total, true), mb_strlen(mb_substr((string) $inv_total, mb_strpos((string) $inv_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_total))), __LINE__);
        }
        if (is_null($inv_total) || (is_array($inv_total) && empty($inv_total))) {
            unset($this->inv_total);
        } else {
            $this->inv_total = $inv_total;
        }
        
        return $this;
    }
    /**
     * Get inv_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_amount(): ?float
    {
        return $this->inv_amount ?? null;
    }
    /**
     * Set inv_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_amount(?float $inv_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_amount) && !(is_float($inv_amount) || is_numeric($inv_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_amount, true), gettype($inv_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_amount) && mb_strlen(mb_substr((string) $inv_amount, false !== mb_strpos((string) $inv_amount, '.') ? mb_strpos((string) $inv_amount, '.') + 1 : mb_strlen((string) $inv_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_amount, true), mb_strlen(mb_substr((string) $inv_amount, mb_strpos((string) $inv_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_amount))), __LINE__);
        }
        if (is_null($inv_amount) || (is_array($inv_amount) && empty($inv_amount))) {
            unset($this->inv_amount);
        } else {
            $this->inv_amount = $inv_amount;
        }
        
        return $this;
    }
    /**
     * Get inv_balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_balance(): ?float
    {
        return $this->inv_balance ?? null;
    }
    /**
     * Set inv_balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_balance
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_balance(?float $inv_balance = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_balance) && !(is_float($inv_balance) || is_numeric($inv_balance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_balance, true), gettype($inv_balance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_balance) && mb_strlen(mb_substr((string) $inv_balance, false !== mb_strpos((string) $inv_balance, '.') ? mb_strpos((string) $inv_balance, '.') + 1 : mb_strlen((string) $inv_balance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_balance, true), mb_strlen(mb_substr((string) $inv_balance, mb_strpos((string) $inv_balance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_balance) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_balance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_balance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_balance))), __LINE__);
        }
        if (is_null($inv_balance) || (is_array($inv_balance) && empty($inv_balance))) {
            unset($this->inv_balance);
        } else {
            $this->inv_balance = $inv_balance;
        }
        
        return $this;
    }
    /**
     * Get inv_payment_to_apply_distributed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_payment_to_apply_distributed(): ?float
    {
        return $this->inv_payment_to_apply_distributed ?? null;
    }
    /**
     * Set inv_payment_to_apply_distributed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_payment_to_apply_distributed
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_payment_to_apply_distributed(?float $inv_payment_to_apply_distributed = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_payment_to_apply_distributed) && !(is_float($inv_payment_to_apply_distributed) || is_numeric($inv_payment_to_apply_distributed))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_payment_to_apply_distributed, true), gettype($inv_payment_to_apply_distributed)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_payment_to_apply_distributed) && mb_strlen(mb_substr((string) $inv_payment_to_apply_distributed, false !== mb_strpos((string) $inv_payment_to_apply_distributed, '.') ? mb_strpos((string) $inv_payment_to_apply_distributed, '.') + 1 : mb_strlen((string) $inv_payment_to_apply_distributed))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_payment_to_apply_distributed, true), mb_strlen(mb_substr((string) $inv_payment_to_apply_distributed, mb_strpos((string) $inv_payment_to_apply_distributed, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_payment_to_apply_distributed) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_payment_to_apply_distributed)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_payment_to_apply_distributed, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_payment_to_apply_distributed))), __LINE__);
        }
        if (is_null($inv_payment_to_apply_distributed) || (is_array($inv_payment_to_apply_distributed) && empty($inv_payment_to_apply_distributed))) {
            unset($this->inv_payment_to_apply_distributed);
        } else {
            $this->inv_payment_to_apply_distributed = $inv_payment_to_apply_distributed;
        }
        
        return $this;
    }
    /**
     * Get inv_close_opportunity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_close_opportunity(): ?string
    {
        return $this->inv_close_opportunity ?? null;
    }
    /**
     * Set inv_close_opportunity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_close_opportunity
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_close_opportunity(?string $inv_close_opportunity = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_close_opportunity) && !is_string($inv_close_opportunity)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_close_opportunity, true), gettype($inv_close_opportunity)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_close_opportunity) && $inv_close_opportunity > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_close_opportunity, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_close_opportunity) && $inv_close_opportunity < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_close_opportunity, true)), __LINE__);
        }
        if (is_null($inv_close_opportunity) || (is_array($inv_close_opportunity) && empty($inv_close_opportunity))) {
            unset($this->inv_close_opportunity);
        } else {
            $this->inv_close_opportunity = $inv_close_opportunity;
        }
        
        return $this;
    }
    /**
     * Get inv_credit_to_apply_distributed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_credit_to_apply_distributed(): ?float
    {
        return $this->inv_credit_to_apply_distributed ?? null;
    }
    /**
     * Set inv_credit_to_apply_distributed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_credit_to_apply_distributed
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_credit_to_apply_distributed(?float $inv_credit_to_apply_distributed = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_credit_to_apply_distributed) && !(is_float($inv_credit_to_apply_distributed) || is_numeric($inv_credit_to_apply_distributed))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_credit_to_apply_distributed, true), gettype($inv_credit_to_apply_distributed)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_credit_to_apply_distributed) && mb_strlen(mb_substr((string) $inv_credit_to_apply_distributed, false !== mb_strpos((string) $inv_credit_to_apply_distributed, '.') ? mb_strpos((string) $inv_credit_to_apply_distributed, '.') + 1 : mb_strlen((string) $inv_credit_to_apply_distributed))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_credit_to_apply_distributed, true), mb_strlen(mb_substr((string) $inv_credit_to_apply_distributed, mb_strpos((string) $inv_credit_to_apply_distributed, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_credit_to_apply_distributed) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_credit_to_apply_distributed)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_credit_to_apply_distributed, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_credit_to_apply_distributed))), __LINE__);
        }
        if (is_null($inv_credit_to_apply_distributed) || (is_array($inv_credit_to_apply_distributed) && empty($inv_credit_to_apply_distributed))) {
            unset($this->inv_credit_to_apply_distributed);
        } else {
            $this->inv_credit_to_apply_distributed = $inv_credit_to_apply_distributed;
        }
        
        return $this;
    }
    /**
     * Get inv_distributable_credit_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_distributable_credit_total(): ?float
    {
        return $this->inv_distributable_credit_total ?? null;
    }
    /**
     * Set inv_distributable_credit_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_distributable_credit_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_distributable_credit_total(?float $inv_distributable_credit_total = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_distributable_credit_total) && !(is_float($inv_distributable_credit_total) || is_numeric($inv_distributable_credit_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_distributable_credit_total, true), gettype($inv_distributable_credit_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_distributable_credit_total) && mb_strlen(mb_substr((string) $inv_distributable_credit_total, false !== mb_strpos((string) $inv_distributable_credit_total, '.') ? mb_strpos((string) $inv_distributable_credit_total, '.') + 1 : mb_strlen((string) $inv_distributable_credit_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_distributable_credit_total, true), mb_strlen(mb_substr((string) $inv_distributable_credit_total, mb_strpos((string) $inv_distributable_credit_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_distributable_credit_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_distributable_credit_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_distributable_credit_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_distributable_credit_total))), __LINE__);
        }
        if (is_null($inv_distributable_credit_total) || (is_array($inv_distributable_credit_total) && empty($inv_distributable_credit_total))) {
            unset($this->inv_distributable_credit_total);
        } else {
            $this->inv_distributable_credit_total = $inv_distributable_credit_total;
        }
        
        return $this;
    }
    /**
     * Get inv_distributable_credit_balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_distributable_credit_balance(): ?float
    {
        return $this->inv_distributable_credit_balance ?? null;
    }
    /**
     * Set inv_distributable_credit_balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_distributable_credit_balance
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_distributable_credit_balance(?float $inv_distributable_credit_balance = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_distributable_credit_balance) && !(is_float($inv_distributable_credit_balance) || is_numeric($inv_distributable_credit_balance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_distributable_credit_balance, true), gettype($inv_distributable_credit_balance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_distributable_credit_balance) && mb_strlen(mb_substr((string) $inv_distributable_credit_balance, false !== mb_strpos((string) $inv_distributable_credit_balance, '.') ? mb_strpos((string) $inv_distributable_credit_balance, '.') + 1 : mb_strlen((string) $inv_distributable_credit_balance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_distributable_credit_balance, true), mb_strlen(mb_substr((string) $inv_distributable_credit_balance, mb_strpos((string) $inv_distributable_credit_balance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_distributable_credit_balance) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_distributable_credit_balance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_distributable_credit_balance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_distributable_credit_balance))), __LINE__);
        }
        if (is_null($inv_distributable_credit_balance) || (is_array($inv_distributable_credit_balance) && empty($inv_distributable_credit_balance))) {
            unset($this->inv_distributable_credit_balance);
        } else {
            $this->inv_distributable_credit_balance = $inv_distributable_credit_balance;
        }
        
        return $this;
    }
    /**
     * Get inv_paid_by_liability_balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_paid_by_liability_balance(): ?float
    {
        return $this->inv_paid_by_liability_balance ?? null;
    }
    /**
     * Set inv_paid_by_liability_balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_paid_by_liability_balance
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_paid_by_liability_balance(?float $inv_paid_by_liability_balance = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_paid_by_liability_balance) && !(is_float($inv_paid_by_liability_balance) || is_numeric($inv_paid_by_liability_balance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_paid_by_liability_balance, true), gettype($inv_paid_by_liability_balance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_paid_by_liability_balance) && mb_strlen(mb_substr((string) $inv_paid_by_liability_balance, false !== mb_strpos((string) $inv_paid_by_liability_balance, '.') ? mb_strpos((string) $inv_paid_by_liability_balance, '.') + 1 : mb_strlen((string) $inv_paid_by_liability_balance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_paid_by_liability_balance, true), mb_strlen(mb_substr((string) $inv_paid_by_liability_balance, mb_strpos((string) $inv_paid_by_liability_balance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_paid_by_liability_balance) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_paid_by_liability_balance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_paid_by_liability_balance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_paid_by_liability_balance))), __LINE__);
        }
        if (is_null($inv_paid_by_liability_balance) || (is_array($inv_paid_by_liability_balance) && empty($inv_paid_by_liability_balance))) {
            unset($this->inv_paid_by_liability_balance);
        } else {
            $this->inv_paid_by_liability_balance = $inv_paid_by_liability_balance;
        }
        
        return $this;
    }
    /**
     * Get inv_payment_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_payment_to_apply(): ?float
    {
        return $this->inv_payment_to_apply ?? null;
    }
    /**
     * Set inv_payment_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_payment_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_payment_to_apply(?float $inv_payment_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_payment_to_apply) && !(is_float($inv_payment_to_apply) || is_numeric($inv_payment_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_payment_to_apply, true), gettype($inv_payment_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_payment_to_apply) && mb_strlen(mb_substr((string) $inv_payment_to_apply, false !== mb_strpos((string) $inv_payment_to_apply, '.') ? mb_strpos((string) $inv_payment_to_apply, '.') + 1 : mb_strlen((string) $inv_payment_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_payment_to_apply, true), mb_strlen(mb_substr((string) $inv_payment_to_apply, mb_strpos((string) $inv_payment_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_payment_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_payment_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_payment_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_payment_to_apply))), __LINE__);
        }
        if (is_null($inv_payment_to_apply) || (is_array($inv_payment_to_apply) && empty($inv_payment_to_apply))) {
            unset($this->inv_payment_to_apply);
        } else {
            $this->inv_payment_to_apply = $inv_payment_to_apply;
        }
        
        return $this;
    }
    /**
     * Get inv_convertedamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_convertedamount(): ?string
    {
        return $this->inv_convertedamount ?? null;
    }
    /**
     * Set inv_convertedamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_convertedamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_convertedamount(?string $inv_convertedamount = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_convertedamount) && !is_string($inv_convertedamount)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_convertedamount, true), gettype($inv_convertedamount)), __LINE__);
        }
        if (is_null($inv_convertedamount) || (is_array($inv_convertedamount) && empty($inv_convertedamount))) {
            unset($this->inv_convertedamount);
        } else {
            $this->inv_convertedamount = $inv_convertedamount;
        }
        
        return $this;
    }
    /**
     * Get inv_nettotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_nettotal(): ?float
    {
        return $this->inv_nettotal ?? null;
    }
    /**
     * Set inv_nettotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_nettotal
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_nettotal(?float $inv_nettotal = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_nettotal) && !(is_float($inv_nettotal) || is_numeric($inv_nettotal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_nettotal, true), gettype($inv_nettotal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_nettotal) && mb_strlen(mb_substr((string) $inv_nettotal, false !== mb_strpos((string) $inv_nettotal, '.') ? mb_strpos((string) $inv_nettotal, '.') + 1 : mb_strlen((string) $inv_nettotal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_nettotal, true), mb_strlen(mb_substr((string) $inv_nettotal, mb_strpos((string) $inv_nettotal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_nettotal) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_nettotal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_nettotal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_nettotal))), __LINE__);
        }
        if (is_null($inv_nettotal) || (is_array($inv_nettotal) && empty($inv_nettotal))) {
            unset($this->inv_nettotal);
        } else {
            $this->inv_nettotal = $inv_nettotal;
        }
        
        return $this;
    }
    /**
     * Get inv_netpayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_netpayment(): ?float
    {
        return $this->inv_netpayment ?? null;
    }
    /**
     * Set inv_netpayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_netpayment
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_netpayment(?float $inv_netpayment = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_netpayment) && !(is_float($inv_netpayment) || is_numeric($inv_netpayment))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_netpayment, true), gettype($inv_netpayment)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_netpayment) && mb_strlen(mb_substr((string) $inv_netpayment, false !== mb_strpos((string) $inv_netpayment, '.') ? mb_strpos((string) $inv_netpayment, '.') + 1 : mb_strlen((string) $inv_netpayment))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_netpayment, true), mb_strlen(mb_substr((string) $inv_netpayment, mb_strpos((string) $inv_netpayment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_netpayment) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netpayment)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_netpayment, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netpayment))), __LINE__);
        }
        if (is_null($inv_netpayment) || (is_array($inv_netpayment) && empty($inv_netpayment))) {
            unset($this->inv_netpayment);
        } else {
            $this->inv_netpayment = $inv_netpayment;
        }
        
        return $this;
    }
    /**
     * Get inv_credit_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_credit_to_apply(): ?float
    {
        return $this->inv_credit_to_apply ?? null;
    }
    /**
     * Set inv_credit_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_credit_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_credit_to_apply(?float $inv_credit_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_credit_to_apply) && !(is_float($inv_credit_to_apply) || is_numeric($inv_credit_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_credit_to_apply, true), gettype($inv_credit_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_credit_to_apply) && mb_strlen(mb_substr((string) $inv_credit_to_apply, false !== mb_strpos((string) $inv_credit_to_apply, '.') ? mb_strpos((string) $inv_credit_to_apply, '.') + 1 : mb_strlen((string) $inv_credit_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_credit_to_apply, true), mb_strlen(mb_substr((string) $inv_credit_to_apply, mb_strpos((string) $inv_credit_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_credit_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_credit_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_credit_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_credit_to_apply))), __LINE__);
        }
        if (is_null($inv_credit_to_apply) || (is_array($inv_credit_to_apply) && empty($inv_credit_to_apply))) {
            unset($this->inv_credit_to_apply);
        } else {
            $this->inv_credit_to_apply = $inv_credit_to_apply;
        }
        
        return $this;
    }
    /**
     * Get inv_netbalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_netbalance(): ?float
    {
        return $this->inv_netbalance ?? null;
    }
    /**
     * Set inv_netbalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_netbalance
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_netbalance(?float $inv_netbalance = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_netbalance) && !(is_float($inv_netbalance) || is_numeric($inv_netbalance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_netbalance, true), gettype($inv_netbalance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_netbalance) && mb_strlen(mb_substr((string) $inv_netbalance, false !== mb_strpos((string) $inv_netbalance, '.') ? mb_strpos((string) $inv_netbalance, '.') + 1 : mb_strlen((string) $inv_netbalance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_netbalance, true), mb_strlen(mb_substr((string) $inv_netbalance, mb_strpos((string) $inv_netbalance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_netbalance) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netbalance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_netbalance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netbalance))), __LINE__);
        }
        if (is_null($inv_netbalance) || (is_array($inv_netbalance) && empty($inv_netbalance))) {
            unset($this->inv_netbalance);
        } else {
            $this->inv_netbalance = $inv_netbalance;
        }
        
        return $this;
    }
    /**
     * Get inv_netcredit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_netcredit(): ?float
    {
        return $this->inv_netcredit ?? null;
    }
    /**
     * Set inv_netcredit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_netcredit
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_netcredit(?float $inv_netcredit = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_netcredit) && !(is_float($inv_netcredit) || is_numeric($inv_netcredit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_netcredit, true), gettype($inv_netcredit)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_netcredit) && mb_strlen(mb_substr((string) $inv_netcredit, false !== mb_strpos((string) $inv_netcredit, '.') ? mb_strpos((string) $inv_netcredit, '.') + 1 : mb_strlen((string) $inv_netcredit))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_netcredit, true), mb_strlen(mb_substr((string) $inv_netcredit, mb_strpos((string) $inv_netcredit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_netcredit) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netcredit)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_netcredit, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netcredit))), __LINE__);
        }
        if (is_null($inv_netcredit) || (is_array($inv_netcredit) && empty($inv_netcredit))) {
            unset($this->inv_netcredit);
        } else {
            $this->inv_netcredit = $inv_netcredit;
        }
        
        return $this;
    }
    /**
     * Get inv_net_amount_due value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_net_amount_due(): ?float
    {
        return $this->inv_net_amount_due ?? null;
    }
    /**
     * Set inv_net_amount_due value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_net_amount_due
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_net_amount_due(?float $inv_net_amount_due = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_net_amount_due) && !(is_float($inv_net_amount_due) || is_numeric($inv_net_amount_due))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_net_amount_due, true), gettype($inv_net_amount_due)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_net_amount_due) && mb_strlen(mb_substr((string) $inv_net_amount_due, false !== mb_strpos((string) $inv_net_amount_due, '.') ? mb_strpos((string) $inv_net_amount_due, '.') + 1 : mb_strlen((string) $inv_net_amount_due))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_net_amount_due, true), mb_strlen(mb_substr((string) $inv_net_amount_due, mb_strpos((string) $inv_net_amount_due, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_net_amount_due) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_net_amount_due)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_net_amount_due, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_net_amount_due))), __LINE__);
        }
        if (is_null($inv_net_amount_due) || (is_array($inv_net_amount_due) && empty($inv_net_amount_due))) {
            unset($this->inv_net_amount_due);
        } else {
            $this->inv_net_amount_due = $inv_net_amount_due;
        }
        
        return $this;
    }
    /**
     * Get inv_netunpaidbalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_netunpaidbalance(): ?float
    {
        return $this->inv_netunpaidbalance ?? null;
    }
    /**
     * Set inv_netunpaidbalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_netunpaidbalance
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_netunpaidbalance(?float $inv_netunpaidbalance = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_netunpaidbalance) && !(is_float($inv_netunpaidbalance) || is_numeric($inv_netunpaidbalance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_netunpaidbalance, true), gettype($inv_netunpaidbalance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_netunpaidbalance) && mb_strlen(mb_substr((string) $inv_netunpaidbalance, false !== mb_strpos((string) $inv_netunpaidbalance, '.') ? mb_strpos((string) $inv_netunpaidbalance, '.') + 1 : mb_strlen((string) $inv_netunpaidbalance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_netunpaidbalance, true), mb_strlen(mb_substr((string) $inv_netunpaidbalance, mb_strpos((string) $inv_netunpaidbalance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_netunpaidbalance) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netunpaidbalance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_netunpaidbalance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netunpaidbalance))), __LINE__);
        }
        if (is_null($inv_netunpaidbalance) || (is_array($inv_netunpaidbalance) && empty($inv_netunpaidbalance))) {
            unset($this->inv_netunpaidbalance);
        } else {
            $this->inv_netunpaidbalance = $inv_netunpaidbalance;
        }
        
        return $this;
    }
    /**
     * Get inv_netwriteoff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_netwriteoff(): ?float
    {
        return $this->inv_netwriteoff ?? null;
    }
    /**
     * Set inv_netwriteoff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_netwriteoff
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_netwriteoff(?float $inv_netwriteoff = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_netwriteoff) && !(is_float($inv_netwriteoff) || is_numeric($inv_netwriteoff))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_netwriteoff, true), gettype($inv_netwriteoff)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_netwriteoff) && mb_strlen(mb_substr((string) $inv_netwriteoff, false !== mb_strpos((string) $inv_netwriteoff, '.') ? mb_strpos((string) $inv_netwriteoff, '.') + 1 : mb_strlen((string) $inv_netwriteoff))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_netwriteoff, true), mb_strlen(mb_substr((string) $inv_netwriteoff, mb_strpos((string) $inv_netwriteoff, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_netwriteoff) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netwriteoff)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_netwriteoff, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netwriteoff))), __LINE__);
        }
        if (is_null($inv_netwriteoff) || (is_array($inv_netwriteoff) && empty($inv_netwriteoff))) {
            unset($this->inv_netwriteoff);
        } else {
            $this->inv_netwriteoff = $inv_netwriteoff;
        }
        
        return $this;
    }
    /**
     * Get inv_writeoff_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_writeoff_to_apply(): ?float
    {
        return $this->inv_writeoff_to_apply ?? null;
    }
    /**
     * Set inv_writeoff_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_writeoff_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_writeoff_to_apply(?float $inv_writeoff_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_writeoff_to_apply) && !(is_float($inv_writeoff_to_apply) || is_numeric($inv_writeoff_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_writeoff_to_apply, true), gettype($inv_writeoff_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_writeoff_to_apply) && mb_strlen(mb_substr((string) $inv_writeoff_to_apply, false !== mb_strpos((string) $inv_writeoff_to_apply, '.') ? mb_strpos((string) $inv_writeoff_to_apply, '.') + 1 : mb_strlen((string) $inv_writeoff_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_writeoff_to_apply, true), mb_strlen(mb_substr((string) $inv_writeoff_to_apply, mb_strpos((string) $inv_writeoff_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_writeoff_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_writeoff_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_writeoff_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_writeoff_to_apply))), __LINE__);
        }
        if (is_null($inv_writeoff_to_apply) || (is_array($inv_writeoff_to_apply) && empty($inv_writeoff_to_apply))) {
            unset($this->inv_writeoff_to_apply);
        } else {
            $this->inv_writeoff_to_apply = $inv_writeoff_to_apply;
        }
        
        return $this;
    }
    /**
     * Get inv_netreturn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_netreturn(): ?float
    {
        return $this->inv_netreturn ?? null;
    }
    /**
     * Set inv_netreturn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_netreturn
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_netreturn(?float $inv_netreturn = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_netreturn) && !(is_float($inv_netreturn) || is_numeric($inv_netreturn))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_netreturn, true), gettype($inv_netreturn)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_netreturn) && mb_strlen(mb_substr((string) $inv_netreturn, false !== mb_strpos((string) $inv_netreturn, '.') ? mb_strpos((string) $inv_netreturn, '.') + 1 : mb_strlen((string) $inv_netreturn))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_netreturn, true), mb_strlen(mb_substr((string) $inv_netreturn, mb_strpos((string) $inv_netreturn, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_netreturn) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netreturn)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_netreturn, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netreturn))), __LINE__);
        }
        if (is_null($inv_netreturn) || (is_array($inv_netreturn) && empty($inv_netreturn))) {
            unset($this->inv_netreturn);
        } else {
            $this->inv_netreturn = $inv_netreturn;
        }
        
        return $this;
    }
    /**
     * Get inv_return_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_return_to_apply(): ?float
    {
        return $this->inv_return_to_apply ?? null;
    }
    /**
     * Set inv_return_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_return_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_return_to_apply(?float $inv_return_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_return_to_apply) && !(is_float($inv_return_to_apply) || is_numeric($inv_return_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_return_to_apply, true), gettype($inv_return_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_return_to_apply) && mb_strlen(mb_substr((string) $inv_return_to_apply, false !== mb_strpos((string) $inv_return_to_apply, '.') ? mb_strpos((string) $inv_return_to_apply, '.') + 1 : mb_strlen((string) $inv_return_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_return_to_apply, true), mb_strlen(mb_substr((string) $inv_return_to_apply, mb_strpos((string) $inv_return_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_return_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_return_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_return_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_return_to_apply))), __LINE__);
        }
        if (is_null($inv_return_to_apply) || (is_array($inv_return_to_apply) && empty($inv_return_to_apply))) {
            unset($this->inv_return_to_apply);
        } else {
            $this->inv_return_to_apply = $inv_return_to_apply;
        }
        
        return $this;
    }
    /**
     * Get inv_netapplied value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_netapplied(): ?float
    {
        return $this->inv_netapplied ?? null;
    }
    /**
     * Set inv_netapplied value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_netapplied
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_netapplied(?float $inv_netapplied = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_netapplied) && !(is_float($inv_netapplied) || is_numeric($inv_netapplied))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_netapplied, true), gettype($inv_netapplied)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_netapplied) && mb_strlen(mb_substr((string) $inv_netapplied, false !== mb_strpos((string) $inv_netapplied, '.') ? mb_strpos((string) $inv_netapplied, '.') + 1 : mb_strlen((string) $inv_netapplied))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_netapplied, true), mb_strlen(mb_substr((string) $inv_netapplied, mb_strpos((string) $inv_netapplied, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_netapplied) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netapplied)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_netapplied, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_netapplied))), __LINE__);
        }
        if (is_null($inv_netapplied) || (is_array($inv_netapplied) && empty($inv_netapplied))) {
            unset($this->inv_netapplied);
        } else {
            $this->inv_netapplied = $inv_netapplied;
        }
        
        return $this;
    }
    /**
     * Get inv_previous_netapplied value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_previous_netapplied(): ?float
    {
        return $this->inv_previous_netapplied ?? null;
    }
    /**
     * Set inv_previous_netapplied value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_previous_netapplied
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_previous_netapplied(?float $inv_previous_netapplied = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_previous_netapplied) && !(is_float($inv_previous_netapplied) || is_numeric($inv_previous_netapplied))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_previous_netapplied, true), gettype($inv_previous_netapplied)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_previous_netapplied) && mb_strlen(mb_substr((string) $inv_previous_netapplied, false !== mb_strpos((string) $inv_previous_netapplied, '.') ? mb_strpos((string) $inv_previous_netapplied, '.') + 1 : mb_strlen((string) $inv_previous_netapplied))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_previous_netapplied, true), mb_strlen(mb_substr((string) $inv_previous_netapplied, mb_strpos((string) $inv_previous_netapplied, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_previous_netapplied) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_previous_netapplied)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_previous_netapplied, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_previous_netapplied))), __LINE__);
        }
        if (is_null($inv_previous_netapplied) || (is_array($inv_previous_netapplied) && empty($inv_previous_netapplied))) {
            unset($this->inv_previous_netapplied);
        } else {
            $this->inv_previous_netapplied = $inv_previous_netapplied;
        }
        
        return $this;
    }
    /**
     * Get inv_previous_netpayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_previous_netpayment(): ?float
    {
        return $this->inv_previous_netpayment ?? null;
    }
    /**
     * Set inv_previous_netpayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_previous_netpayment
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_previous_netpayment(?float $inv_previous_netpayment = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_previous_netpayment) && !(is_float($inv_previous_netpayment) || is_numeric($inv_previous_netpayment))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_previous_netpayment, true), gettype($inv_previous_netpayment)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_previous_netpayment) && mb_strlen(mb_substr((string) $inv_previous_netpayment, false !== mb_strpos((string) $inv_previous_netpayment, '.') ? mb_strpos((string) $inv_previous_netpayment, '.') + 1 : mb_strlen((string) $inv_previous_netpayment))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_previous_netpayment, true), mb_strlen(mb_substr((string) $inv_previous_netpayment, mb_strpos((string) $inv_previous_netpayment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_previous_netpayment) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_previous_netpayment)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_previous_netpayment, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_previous_netpayment))), __LINE__);
        }
        if (is_null($inv_previous_netpayment) || (is_array($inv_previous_netpayment) && empty($inv_previous_netpayment))) {
            unset($this->inv_previous_netpayment);
        } else {
            $this->inv_previous_netpayment = $inv_previous_netpayment;
        }
        
        return $this;
    }
    /**
     * Get inv_total_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_total_to_apply(): ?float
    {
        return $this->inv_total_to_apply ?? null;
    }
    /**
     * Set inv_total_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_total_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_total_to_apply(?float $inv_total_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_total_to_apply) && !(is_float($inv_total_to_apply) || is_numeric($inv_total_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_total_to_apply, true), gettype($inv_total_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_total_to_apply) && mb_strlen(mb_substr((string) $inv_total_to_apply, false !== mb_strpos((string) $inv_total_to_apply, '.') ? mb_strpos((string) $inv_total_to_apply, '.') + 1 : mb_strlen((string) $inv_total_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_total_to_apply, true), mb_strlen(mb_substr((string) $inv_total_to_apply, mb_strpos((string) $inv_total_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_total_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_total_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_total_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_total_to_apply))), __LINE__);
        }
        if (is_null($inv_total_to_apply) || (is_array($inv_total_to_apply) && empty($inv_total_to_apply))) {
            unset($this->inv_total_to_apply);
        } else {
            $this->inv_total_to_apply = $inv_total_to_apply;
        }
        
        return $this;
    }
    /**
     * Get inv_next_invoice_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_next_invoice_date(): ?string
    {
        return $this->inv_next_invoice_date ?? null;
    }
    /**
     * Set inv_next_invoice_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_next_invoice_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_next_invoice_date(?string $inv_next_invoice_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_next_invoice_date) && !is_string($inv_next_invoice_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_next_invoice_date, true), gettype($inv_next_invoice_date)), __LINE__);
        }
        if (is_null($inv_next_invoice_date) || (is_array($inv_next_invoice_date) && empty($inv_next_invoice_date))) {
            unset($this->inv_next_invoice_date);
        } else {
            $this->inv_next_invoice_date = $inv_next_invoice_date;
        }
        
        return $this;
    }
    /**
     * Get inv_allow_payment_with_frozen_payment_method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_allow_payment_with_frozen_payment_method(): ?string
    {
        return $this->inv_allow_payment_with_frozen_payment_method ?? null;
    }
    /**
     * Set inv_allow_payment_with_frozen_payment_method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_allow_payment_with_frozen_payment_method
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_allow_payment_with_frozen_payment_method(?string $inv_allow_payment_with_frozen_payment_method = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_allow_payment_with_frozen_payment_method) && !is_string($inv_allow_payment_with_frozen_payment_method)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_allow_payment_with_frozen_payment_method, true), gettype($inv_allow_payment_with_frozen_payment_method)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_allow_payment_with_frozen_payment_method) && $inv_allow_payment_with_frozen_payment_method > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_allow_payment_with_frozen_payment_method, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_allow_payment_with_frozen_payment_method) && $inv_allow_payment_with_frozen_payment_method < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_allow_payment_with_frozen_payment_method, true)), __LINE__);
        }
        if (is_null($inv_allow_payment_with_frozen_payment_method) || (is_array($inv_allow_payment_with_frozen_payment_method) && empty($inv_allow_payment_with_frozen_payment_method))) {
            unset($this->inv_allow_payment_with_frozen_payment_method);
        } else {
            $this->inv_allow_payment_with_frozen_payment_method = $inv_allow_payment_with_frozen_payment_method;
        }
        
        return $this;
    }
    /**
     * Get inv_reload_inv_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_reload_inv_cxa_key(): ?string
    {
        return $this->inv_reload_inv_cxa_key ?? null;
    }
    /**
     * Set inv_reload_inv_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_reload_inv_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_reload_inv_cxa_key(?string $inv_reload_inv_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_reload_inv_cxa_key) && !is_string($inv_reload_inv_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_reload_inv_cxa_key, true), gettype($inv_reload_inv_cxa_key)), __LINE__);
        }
        if (is_null($inv_reload_inv_cxa_key) || (is_array($inv_reload_inv_cxa_key) && empty($inv_reload_inv_cxa_key))) {
            unset($this->inv_reload_inv_cxa_key);
        } else {
            $this->inv_reload_inv_cxa_key = $inv_reload_inv_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get inv_reload_ivd_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_reload_ivd_cxa_key(): ?string
    {
        return $this->inv_reload_ivd_cxa_key ?? null;
    }
    /**
     * Set inv_reload_ivd_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_reload_ivd_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_reload_ivd_cxa_key(?string $inv_reload_ivd_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_reload_ivd_cxa_key) && !is_string($inv_reload_ivd_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_reload_ivd_cxa_key, true), gettype($inv_reload_ivd_cxa_key)), __LINE__);
        }
        if (is_null($inv_reload_ivd_cxa_key) || (is_array($inv_reload_ivd_cxa_key) && empty($inv_reload_ivd_cxa_key))) {
            unset($this->inv_reload_ivd_cxa_key);
        } else {
            $this->inv_reload_ivd_cxa_key = $inv_reload_ivd_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get inv_select_all value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_select_all(): ?string
    {
        return $this->inv_select_all ?? null;
    }
    /**
     * Set inv_select_all value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_select_all
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_select_all(?string $inv_select_all = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_select_all) && !is_string($inv_select_all)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_select_all, true), gettype($inv_select_all)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_select_all) && $inv_select_all > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_select_all, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_select_all) && $inv_select_all < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_select_all, true)), __LINE__);
        }
        if (is_null($inv_select_all) || (is_array($inv_select_all) && empty($inv_select_all))) {
            unset($this->inv_select_all);
        } else {
            $this->inv_select_all = $inv_select_all;
        }
        
        return $this;
    }
    /**
     * Get inv_details_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_details_html(): ?string
    {
        return $this->inv_details_html ?? null;
    }
    /**
     * Set inv_details_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_details_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_details_html(?string $inv_details_html = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_details_html) && !is_string($inv_details_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_details_html, true), gettype($inv_details_html)), __LINE__);
        }
        if (is_null($inv_details_html) || (is_array($inv_details_html) && empty($inv_details_html))) {
            unset($this->inv_details_html);
        } else {
            $this->inv_details_html = $inv_details_html;
        }
        
        return $this;
    }
    /**
     * Get inv_details_text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_details_text(): ?string
    {
        return $this->inv_details_text ?? null;
    }
    /**
     * Set inv_details_text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_details_text
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_details_text(?string $inv_details_text = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_details_text) && !is_string($inv_details_text)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_details_text, true), gettype($inv_details_text)), __LINE__);
        }
        if (is_null($inv_details_text) || (is_array($inv_details_text) && empty($inv_details_text))) {
            unset($this->inv_details_text);
        } else {
            $this->inv_details_text = $inv_details_text;
        }
        
        return $this;
    }
    /**
     * Get inv_details_with_customer_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_details_with_customer_html(): ?string
    {
        return $this->inv_details_with_customer_html ?? null;
    }
    /**
     * Set inv_details_with_customer_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_details_with_customer_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_details_with_customer_html(?string $inv_details_with_customer_html = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_details_with_customer_html) && !is_string($inv_details_with_customer_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_details_with_customer_html, true), gettype($inv_details_with_customer_html)), __LINE__);
        }
        if (is_null($inv_details_with_customer_html) || (is_array($inv_details_with_customer_html) && empty($inv_details_with_customer_html))) {
            unset($this->inv_details_with_customer_html);
        } else {
            $this->inv_details_with_customer_html = $inv_details_with_customer_html;
        }
        
        return $this;
    }
    /**
     * Get inv_autoapply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_autoapply(): ?string
    {
        return $this->inv_autoapply ?? null;
    }
    /**
     * Set inv_autoapply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_autoapply
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_autoapply(?string $inv_autoapply = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_autoapply) && !is_string($inv_autoapply)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_autoapply, true), gettype($inv_autoapply)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_autoapply) && $inv_autoapply > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_autoapply, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_autoapply) && $inv_autoapply < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_autoapply, true)), __LINE__);
        }
        if (is_null($inv_autoapply) || (is_array($inv_autoapply) && empty($inv_autoapply))) {
            unset($this->inv_autoapply);
        } else {
            $this->inv_autoapply = $inv_autoapply;
        }
        
        return $this;
    }
    /**
     * Get inv_autoapplypayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_autoapplypayment(): ?string
    {
        return $this->inv_autoapplypayment ?? null;
    }
    /**
     * Set inv_autoapplypayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_autoapplypayment
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_autoapplypayment(?string $inv_autoapplypayment = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_autoapplypayment) && !is_string($inv_autoapplypayment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_autoapplypayment, true), gettype($inv_autoapplypayment)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_autoapplypayment) && $inv_autoapplypayment > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_autoapplypayment, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_autoapplypayment) && $inv_autoapplypayment < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_autoapplypayment, true)), __LINE__);
        }
        if (is_null($inv_autoapplypayment) || (is_array($inv_autoapplypayment) && empty($inv_autoapplypayment))) {
            unset($this->inv_autoapplypayment);
        } else {
            $this->inv_autoapplypayment = $inv_autoapplypayment;
        }
        
        return $this;
    }
    /**
     * Get inv_installment_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_installment_flag(): ?string
    {
        return $this->inv_installment_flag ?? null;
    }
    /**
     * Set inv_installment_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_installment_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_installment_flag(?string $inv_installment_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_installment_flag) && !is_string($inv_installment_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_installment_flag, true), gettype($inv_installment_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_installment_flag) && $inv_installment_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_installment_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_installment_flag) && $inv_installment_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_installment_flag, true)), __LINE__);
        }
        if (is_null($inv_installment_flag) || (is_array($inv_installment_flag) && empty($inv_installment_flag))) {
            unset($this->inv_installment_flag);
        } else {
            $this->inv_installment_flag = $inv_installment_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_coe_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_coe_flag(): ?string
    {
        return $this->inv_coe_flag ?? null;
    }
    /**
     * Set inv_coe_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_coe_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_coe_flag(?string $inv_coe_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_coe_flag) && !is_string($inv_coe_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_coe_flag, true), gettype($inv_coe_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_coe_flag) && $inv_coe_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_coe_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_coe_flag) && $inv_coe_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_coe_flag, true)), __LINE__);
        }
        if (is_null($inv_coe_flag) || (is_array($inv_coe_flag) && empty($inv_coe_flag))) {
            unset($this->inv_coe_flag);
        } else {
            $this->inv_coe_flag = $inv_coe_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_shippable_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_shippable_total(): ?float
    {
        return $this->inv_shippable_total ?? null;
    }
    /**
     * Set inv_shippable_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_shippable_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_shippable_total(?float $inv_shippable_total = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_shippable_total) && !(is_float($inv_shippable_total) || is_numeric($inv_shippable_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_shippable_total, true), gettype($inv_shippable_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_shippable_total) && mb_strlen(mb_substr((string) $inv_shippable_total, false !== mb_strpos((string) $inv_shippable_total, '.') ? mb_strpos((string) $inv_shippable_total, '.') + 1 : mb_strlen((string) $inv_shippable_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_shippable_total, true), mb_strlen(mb_substr((string) $inv_shippable_total, mb_strpos((string) $inv_shippable_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_shippable_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_shippable_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_shippable_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_shippable_total))), __LINE__);
        }
        if (is_null($inv_shippable_total) || (is_array($inv_shippable_total) && empty($inv_shippable_total))) {
            unset($this->inv_shippable_total);
        } else {
            $this->inv_shippable_total = $inv_shippable_total;
        }
        
        return $this;
    }
    /**
     * Get inv_unapplied_shipping_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_unapplied_shipping_total(): ?float
    {
        return $this->inv_unapplied_shipping_total ?? null;
    }
    /**
     * Set inv_unapplied_shipping_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_unapplied_shipping_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_unapplied_shipping_total(?float $inv_unapplied_shipping_total = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_unapplied_shipping_total) && !(is_float($inv_unapplied_shipping_total) || is_numeric($inv_unapplied_shipping_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_unapplied_shipping_total, true), gettype($inv_unapplied_shipping_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_unapplied_shipping_total) && mb_strlen(mb_substr((string) $inv_unapplied_shipping_total, false !== mb_strpos((string) $inv_unapplied_shipping_total, '.') ? mb_strpos((string) $inv_unapplied_shipping_total, '.') + 1 : mb_strlen((string) $inv_unapplied_shipping_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_unapplied_shipping_total, true), mb_strlen(mb_substr((string) $inv_unapplied_shipping_total, mb_strpos((string) $inv_unapplied_shipping_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_unapplied_shipping_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_unapplied_shipping_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_unapplied_shipping_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_unapplied_shipping_total))), __LINE__);
        }
        if (is_null($inv_unapplied_shipping_total) || (is_array($inv_unapplied_shipping_total) && empty($inv_unapplied_shipping_total))) {
            unset($this->inv_unapplied_shipping_total);
        } else {
            $this->inv_unapplied_shipping_total = $inv_unapplied_shipping_total;
        }
        
        return $this;
    }
    /**
     * Get inv_shippable_items_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_shippable_items_flag(): ?string
    {
        return $this->inv_shippable_items_flag ?? null;
    }
    /**
     * Set inv_shippable_items_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_shippable_items_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_shippable_items_flag(?string $inv_shippable_items_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_shippable_items_flag) && !is_string($inv_shippable_items_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_shippable_items_flag, true), gettype($inv_shippable_items_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_shippable_items_flag) && $inv_shippable_items_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_shippable_items_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_shippable_items_flag) && $inv_shippable_items_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_shippable_items_flag, true)), __LINE__);
        }
        if (is_null($inv_shippable_items_flag) || (is_array($inv_shippable_items_flag) && empty($inv_shippable_items_flag))) {
            unset($this->inv_shippable_items_flag);
        } else {
            $this->inv_shippable_items_flag = $inv_shippable_items_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_create_mail_record value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_create_mail_record(): ?string
    {
        return $this->inv_create_mail_record ?? null;
    }
    /**
     * Set inv_create_mail_record value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_create_mail_record
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_create_mail_record(?string $inv_create_mail_record = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_create_mail_record) && !is_string($inv_create_mail_record)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_create_mail_record, true), gettype($inv_create_mail_record)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_create_mail_record) && $inv_create_mail_record > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_create_mail_record, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_create_mail_record) && $inv_create_mail_record < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_create_mail_record, true)), __LINE__);
        }
        if (is_null($inv_create_mail_record) || (is_array($inv_create_mail_record) && empty($inv_create_mail_record))) {
            unset($this->inv_create_mail_record);
        } else {
            $this->inv_create_mail_record = $inv_create_mail_record;
        }
        
        return $this;
    }
    /**
     * Get inv_autoapplycredit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_autoapplycredit(): ?string
    {
        return $this->inv_autoapplycredit ?? null;
    }
    /**
     * Set inv_autoapplycredit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_autoapplycredit
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_autoapplycredit(?string $inv_autoapplycredit = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_autoapplycredit) && !is_string($inv_autoapplycredit)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_autoapplycredit, true), gettype($inv_autoapplycredit)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_autoapplycredit) && $inv_autoapplycredit > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_autoapplycredit, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_autoapplycredit) && $inv_autoapplycredit < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_autoapplycredit, true)), __LINE__);
        }
        if (is_null($inv_autoapplycredit) || (is_array($inv_autoapplycredit) && empty($inv_autoapplycredit))) {
            unset($this->inv_autoapplycredit);
        } else {
            $this->inv_autoapplycredit = $inv_autoapplycredit;
        }
        
        return $this;
    }
    /**
     * Get inv_invoice_detail_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInv_invoice_detail_count(): ?int
    {
        return $this->inv_invoice_detail_count ?? null;
    }
    /**
     * Set inv_invoice_detail_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inv_invoice_detail_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_invoice_detail_count(?int $inv_invoice_detail_count = null): self
    {
        // validation for constraint: int
        if (!is_null($inv_invoice_detail_count) && !(is_int($inv_invoice_detail_count) || ctype_digit($inv_invoice_detail_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inv_invoice_detail_count, true), gettype($inv_invoice_detail_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($inv_invoice_detail_count) && $inv_invoice_detail_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($inv_invoice_detail_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($inv_invoice_detail_count) && $inv_invoice_detail_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($inv_invoice_detail_count, true)), __LINE__);
        }
        if (is_null($inv_invoice_detail_count) || (is_array($inv_invoice_detail_count) && empty($inv_invoice_detail_count))) {
            unset($this->inv_invoice_detail_count);
        } else {
            $this->inv_invoice_detail_count = $inv_invoice_detail_count;
        }
        
        return $this;
    }
    /**
     * Get inv_bill_me value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_bill_me(): ?string
    {
        return $this->inv_bill_me ?? null;
    }
    /**
     * Set inv_bill_me value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_bill_me
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_bill_me(?string $inv_bill_me = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_bill_me) && !is_string($inv_bill_me)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_bill_me, true), gettype($inv_bill_me)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_bill_me) && $inv_bill_me > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_bill_me, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_bill_me) && $inv_bill_me < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_bill_me, true)), __LINE__);
        }
        if (is_null($inv_bill_me) || (is_array($inv_bill_me) && empty($inv_bill_me))) {
            unset($this->inv_bill_me);
        } else {
            $this->inv_bill_me = $inv_bill_me;
        }
        
        return $this;
    }
    /**
     * Get inv_HasNewLineItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_HasNewLineItems(): ?string
    {
        return $this->inv_HasNewLineItems ?? null;
    }
    /**
     * Set inv_HasNewLineItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_HasNewLineItems
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_HasNewLineItems(?string $inv_HasNewLineItems = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_HasNewLineItems) && !is_string($inv_HasNewLineItems)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_HasNewLineItems, true), gettype($inv_HasNewLineItems)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_HasNewLineItems) && $inv_HasNewLineItems > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_HasNewLineItems, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_HasNewLineItems) && $inv_HasNewLineItems < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_HasNewLineItems, true)), __LINE__);
        }
        if (is_null($inv_HasNewLineItems) || (is_array($inv_HasNewLineItems) && empty($inv_HasNewLineItems))) {
            unset($this->inv_HasNewLineItems);
        } else {
            $this->inv_HasNewLineItems = $inv_HasNewLineItems;
        }
        
        return $this;
    }
    /**
     * Get inv_HasOldLineItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_HasOldLineItems(): ?string
    {
        return $this->inv_HasOldLineItems ?? null;
    }
    /**
     * Set inv_HasOldLineItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_HasOldLineItems
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_HasOldLineItems(?string $inv_HasOldLineItems = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_HasOldLineItems) && !is_string($inv_HasOldLineItems)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_HasOldLineItems, true), gettype($inv_HasOldLineItems)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_HasOldLineItems) && $inv_HasOldLineItems > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_HasOldLineItems, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_HasOldLineItems) && $inv_HasOldLineItems < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_HasOldLineItems, true)), __LINE__);
        }
        if (is_null($inv_HasOldLineItems) || (is_array($inv_HasOldLineItems) && empty($inv_HasOldLineItems))) {
            unset($this->inv_HasOldLineItems);
        } else {
            $this->inv_HasOldLineItems = $inv_HasOldLineItems;
        }
        
        return $this;
    }
    /**
     * Get inv_total_weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_total_weight(): ?float
    {
        return $this->inv_total_weight ?? null;
    }
    /**
     * Set inv_total_weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_total_weight
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_total_weight(?float $inv_total_weight = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_total_weight) && !(is_float($inv_total_weight) || is_numeric($inv_total_weight))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_total_weight, true), gettype($inv_total_weight)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_total_weight) && mb_strlen(mb_substr((string) $inv_total_weight, false !== mb_strpos((string) $inv_total_weight, '.') ? mb_strpos((string) $inv_total_weight, '.') + 1 : mb_strlen((string) $inv_total_weight))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_total_weight, true), mb_strlen(mb_substr((string) $inv_total_weight, mb_strpos((string) $inv_total_weight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($inv_total_weight) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_total_weight)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($inv_total_weight, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_total_weight))), __LINE__);
        }
        if (is_null($inv_total_weight) || (is_array($inv_total_weight) && empty($inv_total_weight))) {
            unset($this->inv_total_weight);
        } else {
            $this->inv_total_weight = $inv_total_weight;
        }
        
        return $this;
    }
    /**
     * Get inv_discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_discount(): ?float
    {
        return $this->inv_discount ?? null;
    }
    /**
     * Set inv_discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_discount
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_discount(?float $inv_discount = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_discount) && !(is_float($inv_discount) || is_numeric($inv_discount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_discount, true), gettype($inv_discount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_discount) && mb_strlen(mb_substr((string) $inv_discount, false !== mb_strpos((string) $inv_discount, '.') ? mb_strpos((string) $inv_discount, '.') + 1 : mb_strlen((string) $inv_discount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_discount, true), mb_strlen(mb_substr((string) $inv_discount, mb_strpos((string) $inv_discount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_discount) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_discount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_discount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_discount))), __LINE__);
        }
        if (is_null($inv_discount) || (is_array($inv_discount) && empty($inv_discount))) {
            unset($this->inv_discount);
        } else {
            $this->inv_discount = $inv_discount;
        }
        
        return $this;
    }
    /**
     * Get inv_shipping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_shipping(): ?float
    {
        return $this->inv_shipping ?? null;
    }
    /**
     * Set inv_shipping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_shipping
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_shipping(?float $inv_shipping = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_shipping) && !(is_float($inv_shipping) || is_numeric($inv_shipping))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_shipping, true), gettype($inv_shipping)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_shipping) && mb_strlen(mb_substr((string) $inv_shipping, false !== mb_strpos((string) $inv_shipping, '.') ? mb_strpos((string) $inv_shipping, '.') + 1 : mb_strlen((string) $inv_shipping))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_shipping, true), mb_strlen(mb_substr((string) $inv_shipping, mb_strpos((string) $inv_shipping, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_shipping) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_shipping)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_shipping, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_shipping))), __LINE__);
        }
        if (is_null($inv_shipping) || (is_array($inv_shipping) && empty($inv_shipping))) {
            unset($this->inv_shipping);
        } else {
            $this->inv_shipping = $inv_shipping;
        }
        
        return $this;
    }
    /**
     * Get inv_tax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInv_tax(): ?float
    {
        return $this->inv_tax ?? null;
    }
    /**
     * Set inv_tax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inv_tax
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_tax(?float $inv_tax = null): self
    {
        // validation for constraint: float
        if (!is_null($inv_tax) && !(is_float($inv_tax) || is_numeric($inv_tax))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inv_tax, true), gettype($inv_tax)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($inv_tax) && mb_strlen(mb_substr((string) $inv_tax, false !== mb_strpos((string) $inv_tax, '.') ? mb_strpos((string) $inv_tax, '.') + 1 : mb_strlen((string) $inv_tax))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($inv_tax, true), mb_strlen(mb_substr((string) $inv_tax, mb_strpos((string) $inv_tax, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($inv_tax) && mb_strlen(preg_replace('/(\D)/', '', (string) $inv_tax)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($inv_tax, true), mb_strlen(preg_replace('/(\D)/', '', (string) $inv_tax))), __LINE__);
        }
        if (is_null($inv_tax) || (is_array($inv_tax) && empty($inv_tax))) {
            unset($this->inv_tax);
        } else {
            $this->inv_tax = $inv_tax;
        }
        
        return $this;
    }
    /**
     * Get inv_prd_keys value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_prd_keys(): ?string
    {
        return $this->inv_prd_keys ?? null;
    }
    /**
     * Set inv_prd_keys value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_prd_keys
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_prd_keys(?string $inv_prd_keys = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_prd_keys) && !is_string($inv_prd_keys)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_prd_keys, true), gettype($inv_prd_keys)), __LINE__);
        }
        if (is_null($inv_prd_keys) || (is_array($inv_prd_keys) && empty($inv_prd_keys))) {
            unset($this->inv_prd_keys);
        } else {
            $this->inv_prd_keys = $inv_prd_keys;
        }
        
        return $this;
    }
    /**
     * Get inv_currency_readonly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_currency_readonly(): ?string
    {
        return $this->inv_currency_readonly ?? null;
    }
    /**
     * Set inv_currency_readonly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_currency_readonly
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_currency_readonly(?string $inv_currency_readonly = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_currency_readonly) && !is_string($inv_currency_readonly)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_currency_readonly, true), gettype($inv_currency_readonly)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inv_currency_readonly) && mb_strlen((string) $inv_currency_readonly) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen((string) $inv_currency_readonly)), __LINE__);
        }
        if (is_null($inv_currency_readonly) || (is_array($inv_currency_readonly) && empty($inv_currency_readonly))) {
            unset($this->inv_currency_readonly);
        } else {
            $this->inv_currency_readonly = $inv_currency_readonly;
        }
        
        return $this;
    }
    /**
     * Get inv_cur_exchange_rate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cur_exchange_rate(): ?string
    {
        return $this->inv_cur_exchange_rate ?? null;
    }
    /**
     * Set inv_cur_exchange_rate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cur_exchange_rate
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_cur_exchange_rate(?string $inv_cur_exchange_rate = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cur_exchange_rate) && !is_string($inv_cur_exchange_rate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cur_exchange_rate, true), gettype($inv_cur_exchange_rate)), __LINE__);
        }
        if (is_null($inv_cur_exchange_rate) || (is_array($inv_cur_exchange_rate) && empty($inv_cur_exchange_rate))) {
            unset($this->inv_cur_exchange_rate);
        } else {
            $this->inv_cur_exchange_rate = $inv_cur_exchange_rate;
        }
        
        return $this;
    }
    /**
     * Get inv_use_payment_to_apply_field value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_use_payment_to_apply_field(): ?string
    {
        return $this->inv_use_payment_to_apply_field ?? null;
    }
    /**
     * Set inv_use_payment_to_apply_field value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_use_payment_to_apply_field
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_use_payment_to_apply_field(?string $inv_use_payment_to_apply_field = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_use_payment_to_apply_field) && !is_string($inv_use_payment_to_apply_field)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_use_payment_to_apply_field, true), gettype($inv_use_payment_to_apply_field)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_use_payment_to_apply_field) && $inv_use_payment_to_apply_field > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_use_payment_to_apply_field, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_use_payment_to_apply_field) && $inv_use_payment_to_apply_field < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_use_payment_to_apply_field, true)), __LINE__);
        }
        if (is_null($inv_use_payment_to_apply_field) || (is_array($inv_use_payment_to_apply_field) && empty($inv_use_payment_to_apply_field))) {
            unset($this->inv_use_payment_to_apply_field);
        } else {
            $this->inv_use_payment_to_apply_field = $inv_use_payment_to_apply_field;
        }
        
        return $this;
    }
    /**
     * Get inv_allow_installment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_allow_installment(): ?string
    {
        return $this->inv_allow_installment ?? null;
    }
    /**
     * Set inv_allow_installment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_allow_installment
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroup_Invoice_DataObjectType
     */
    public function setInv_allow_installment(?string $inv_allow_installment = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_allow_installment) && !is_string($inv_allow_installment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_allow_installment, true), gettype($inv_allow_installment)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_allow_installment) && $inv_allow_installment > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_allow_installment, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_allow_installment) && $inv_allow_installment < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_allow_installment, true)), __LINE__);
        }
        if (is_null($inv_allow_installment) || (is_array($inv_allow_installment) && empty($inv_allow_installment))) {
            unset($this->inv_allow_installment);
        } else {
            $this->inv_allow_installment = $inv_allow_installment;
        }
        
        return $this;
    }
}
