<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrantSession_ev_registration_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrantSession_ev_registration_DataObjectType extends AbstractStructBase
{
    /**
     * The reg_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_key = null;
    /**
     * The reg_cst_key
     * Meta information extracted from the WSDL
     * - documentation: registrant. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_cst_key = null;
    /**
     * The reg_egp_key
     * Meta information extracted from the WSDL
     * - documentation: group registration key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_egp_key = null;
    /**
     * The reg_evt_key
     * Meta information extracted from the WSDL
     * - documentation: Event. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_evt_key = null;
    /**
     * The reg_badge_name
     * Meta information extracted from the WSDL
     * - documentation: badge name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_badge_name = null;
    /**
     * The reg_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_cxa_key = null;
    /**
     * The reg_cph_key
     * Meta information extracted from the WSDL
     * - documentation: phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_cph_key = null;
    /**
     * The reg_eml_key
     * Meta information extracted from the WSDL
     * - documentation: email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_eml_key = null;
    /**
     * The reg_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_cfx_key = null;
    /**
     * The reg_url_key
     * Meta information extracted from the WSDL
     * - documentation: url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_url_key = null;
    /**
     * The reg_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: pref comm method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_pref_comm_meth = null;
    /**
     * The reg_rgt_key
     * Meta information extracted from the WSDL
     * - documentation: registrant type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_rgt_key = null;
    /**
     * The reg_on_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: on wait list?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_on_wait_list_flag = null;
    /**
     * The reg_confirm_date
     * Meta information extracted from the WSDL
     * - documentation: date confirmation sent. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_confirm_date = null;
    /**
     * The reg_attendance_flag
     * Meta information extracted from the WSDL
     * - documentation: attended?.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_attendance_flag = null;
    /**
     * The reg_ada_requirements
     * Meta information extracted from the WSDL
     * - documentation: Disability Requirements. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_ada_requirements = null;
    /**
     * The reg_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_add_user = null;
    /**
     * The reg_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_add_date = null;
    /**
     * The reg_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_change_user = null;
    /**
     * The reg_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_ivd_key = null;
    /**
     * The reg_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_change_date = null;
    /**
     * The reg_inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_inv_code = null;
    /**
     * The reg_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_delete_flag = null;
    /**
     * The reg_org_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Organization Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_org_name_dn = null;
    /**
     * The reg_adr_city
     * Meta information extracted from the WSDL
     * - documentation: City. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_adr_city = null;
    /**
     * The reg_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_key_ext = null;
    /**
     * The reg_adr_state
     * Meta information extracted from the WSDL
     * - documentation: State.This element has a default value of 'NULL'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_adr_state = null;
    /**
     * The reg_adr_country
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'UNITED STATES'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_adr_country = null;
    /**
     * The reg_adr_intl_province
     * Meta information extracted from the WSDL
     * - documentation: Province. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_adr_intl_province = null;
    /**
     * The reg_ixo_title_dn
     * Meta information extracted from the WSDL
     * - documentation: Title. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_ixo_title_dn = null;
    /**
     * The reg_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_src_key = null;
    /**
     * The reg_ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Organization. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_ixo_key = null;
    /**
     * The reg_registration_date
     * Meta information extracted from the WSDL
     * - documentation: Registration Date.This element has a default value of '7/1/2025'. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_registration_date = null;
    /**
     * The reg_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: Cancel Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_cancel_date = null;
    /**
     * The reg_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_entity_key = null;
    /**
     * The reg_cancel_reason
     * Meta information extracted from the WSDL
     * - documentation: Cancellation Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_cancel_reason = null;
    /**
     * The reg_exam_result
     * Meta information extracted from the WSDL
     * - documentation: Exam Result. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_exam_result = null;
    /**
     * The reg_examinee_no
     * Meta information extracted from the WSDL
     * - documentation: Exam ID. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $reg_examinee_no = null;
    /**
     * The reg_badge_print_date
     * Meta information extracted from the WSDL
     * - documentation: Badge Print Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_badge_print_date = null;
    /**
     * The reg_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Registrant. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_reg_key = null;
    /**
     * The reg_id
     * Meta information extracted from the WSDL
     * - documentation: id. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_id = null;
    /**
     * The reg_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_odd_key = null;
    /**
     * The reg_ord_code
     * Meta information extracted from the WSDL
     * - documentation: Order Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_ord_code = null;
    /**
     * The reg_complimentary_event_registered_flag
     * Meta information extracted from the WSDL
     * - documentation: Complimentary Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_complimentary_event_registered_flag = null;
    /**
     * The reg_gft_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $reg_gft_key = null;
    /**
     * The reg_fundraising_goal
     * Meta information extracted from the WSDL
     * - documentation: Fundraising Goal. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $reg_fundraising_goal = null;
    /**
     * The reg_guest_flag
     * Meta information extracted from the WSDL
     * - documentation: Is Guest?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_guest_flag = null;
    /**
     * The reg_time_in
     * Meta information extracted from the WSDL
     * - documentation: Time in. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_time_in = null;
    /**
     * The reg_time_out
     * Meta information extracted from the WSDL
     * - documentation: Time Out. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_time_out = null;
    /**
     * The reg_narrative
     * Meta information extracted from the WSDL
     * - documentation: Narrative. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_narrative = null;
    /**
     * The reg_leaderboard_suppress_flag
     * Meta information extracted from the WSDL
     * - documentation: Suppress Donation Leaderboard. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_leaderboard_suppress_flag = null;
    /**
     * The reg_leaderboard_suppress_amount
     * Meta information extracted from the WSDL
     * - documentation: Suppress Donation Amount on Leaderboard. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_leaderboard_suppress_amount = null;
    /**
     * The reg_video_url
     * Meta information extracted from the WSDL
     * - documentation: Video URL. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_video_url = null;
    /**
     * The reg_waiver_signed_name
     * Meta information extracted from the WSDL
     * - documentation: Waiver Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_waiver_signed_name = null;
    /**
     * The reg_waiver_signed_date
     * Meta information extracted from the WSDL
     * - documentation: Waiver Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_waiver_signed_date = null;
    /**
     * The reg_attestation_complete_flag
     * Meta information extracted from the WSDL
     * - documentation: Attestation Complete. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_attestation_complete_flag = null;
    /**
     * The reg_attestation_type
     * Meta information extracted from the WSDL
     * - documentation: Attestation Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_attestation_type = null;
    /**
     * The reg_attestation_entered_name
     * Meta information extracted from the WSDL
     * - documentation: Attestation Entered By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $reg_attestation_entered_name = null;
    /**
     * Constructor method for EventsRegistrantSession_ev_registration_DataObjectType
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_cst_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_egp_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_evt_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_badge_name()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_cxa_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_cph_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_eml_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_cfx_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_url_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_pref_comm_meth()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_rgt_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_on_wait_list_flag()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_confirm_date()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_attendance_flag()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_ada_requirements()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_add_user()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_add_date()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_change_user()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_ivd_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_change_date()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_inv_code()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_delete_flag()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_org_name_dn()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_adr_city()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_key_ext()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_adr_state()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_adr_country()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_adr_intl_province()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_ixo_title_dn()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_src_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_ixo_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_registration_date()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_cancel_date()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_entity_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_cancel_reason()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_exam_result()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_examinee_no()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_badge_print_date()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_reg_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_id()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_odd_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_ord_code()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_complimentary_event_registered_flag()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_gft_key()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_fundraising_goal()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_guest_flag()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_time_in()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_time_out()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_narrative()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_leaderboard_suppress_flag()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_leaderboard_suppress_amount()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_video_url()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_waiver_signed_name()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_waiver_signed_date()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_attestation_complete_flag()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_attestation_type()
     * @uses EventsRegistrantSession_ev_registration_DataObjectType::setReg_attestation_entered_name()
     * @param string $reg_key
     * @param string $reg_cst_key
     * @param string $reg_egp_key
     * @param string $reg_evt_key
     * @param string $reg_badge_name
     * @param string $reg_cxa_key
     * @param string $reg_cph_key
     * @param string $reg_eml_key
     * @param string $reg_cfx_key
     * @param string $reg_url_key
     * @param string $reg_pref_comm_meth
     * @param string $reg_rgt_key
     * @param string $reg_on_wait_list_flag
     * @param string $reg_confirm_date
     * @param string $reg_attendance_flag
     * @param string $reg_ada_requirements
     * @param string $reg_add_user
     * @param string $reg_add_date
     * @param string $reg_change_user
     * @param string $reg_ivd_key
     * @param string $reg_change_date
     * @param string $reg_inv_code
     * @param string $reg_delete_flag
     * @param string $reg_org_name_dn
     * @param string $reg_adr_city
     * @param string $reg_key_ext
     * @param string $reg_adr_state
     * @param string $reg_adr_country
     * @param string $reg_adr_intl_province
     * @param string $reg_ixo_title_dn
     * @param string $reg_src_key
     * @param string $reg_ixo_key
     * @param string $reg_registration_date
     * @param string $reg_cancel_date
     * @param string $reg_entity_key
     * @param string $reg_cancel_reason
     * @param string $reg_exam_result
     * @param int $reg_examinee_no
     * @param string $reg_badge_print_date
     * @param string $reg_reg_key
     * @param string $reg_id
     * @param string $reg_odd_key
     * @param string $reg_ord_code
     * @param string $reg_complimentary_event_registered_flag
     * @param string $reg_gft_key
     * @param float $reg_fundraising_goal
     * @param string $reg_guest_flag
     * @param string $reg_time_in
     * @param string $reg_time_out
     * @param string $reg_narrative
     * @param string $reg_leaderboard_suppress_flag
     * @param string $reg_leaderboard_suppress_amount
     * @param string $reg_video_url
     * @param string $reg_waiver_signed_name
     * @param string $reg_waiver_signed_date
     * @param string $reg_attestation_complete_flag
     * @param string $reg_attestation_type
     * @param string $reg_attestation_entered_name
     */
    public function __construct(?string $reg_key = null, ?string $reg_cst_key = null, ?string $reg_egp_key = null, ?string $reg_evt_key = null, ?string $reg_badge_name = null, ?string $reg_cxa_key = null, ?string $reg_cph_key = null, ?string $reg_eml_key = null, ?string $reg_cfx_key = null, ?string $reg_url_key = null, ?string $reg_pref_comm_meth = null, ?string $reg_rgt_key = null, ?string $reg_on_wait_list_flag = null, ?string $reg_confirm_date = null, ?string $reg_attendance_flag = null, ?string $reg_ada_requirements = null, ?string $reg_add_user = null, ?string $reg_add_date = null, ?string $reg_change_user = null, ?string $reg_ivd_key = null, ?string $reg_change_date = null, ?string $reg_inv_code = null, ?string $reg_delete_flag = null, ?string $reg_org_name_dn = null, ?string $reg_adr_city = null, ?string $reg_key_ext = null, ?string $reg_adr_state = null, ?string $reg_adr_country = null, ?string $reg_adr_intl_province = null, ?string $reg_ixo_title_dn = null, ?string $reg_src_key = null, ?string $reg_ixo_key = null, ?string $reg_registration_date = null, ?string $reg_cancel_date = null, ?string $reg_entity_key = null, ?string $reg_cancel_reason = null, ?string $reg_exam_result = null, ?int $reg_examinee_no = null, ?string $reg_badge_print_date = null, ?string $reg_reg_key = null, ?string $reg_id = null, ?string $reg_odd_key = null, ?string $reg_ord_code = null, ?string $reg_complimentary_event_registered_flag = null, ?string $reg_gft_key = null, ?float $reg_fundraising_goal = null, ?string $reg_guest_flag = null, ?string $reg_time_in = null, ?string $reg_time_out = null, ?string $reg_narrative = null, ?string $reg_leaderboard_suppress_flag = null, ?string $reg_leaderboard_suppress_amount = null, ?string $reg_video_url = null, ?string $reg_waiver_signed_name = null, ?string $reg_waiver_signed_date = null, ?string $reg_attestation_complete_flag = null, ?string $reg_attestation_type = null, ?string $reg_attestation_entered_name = null)
    {
        $this
            ->setReg_key($reg_key)
            ->setReg_cst_key($reg_cst_key)
            ->setReg_egp_key($reg_egp_key)
            ->setReg_evt_key($reg_evt_key)
            ->setReg_badge_name($reg_badge_name)
            ->setReg_cxa_key($reg_cxa_key)
            ->setReg_cph_key($reg_cph_key)
            ->setReg_eml_key($reg_eml_key)
            ->setReg_cfx_key($reg_cfx_key)
            ->setReg_url_key($reg_url_key)
            ->setReg_pref_comm_meth($reg_pref_comm_meth)
            ->setReg_rgt_key($reg_rgt_key)
            ->setReg_on_wait_list_flag($reg_on_wait_list_flag)
            ->setReg_confirm_date($reg_confirm_date)
            ->setReg_attendance_flag($reg_attendance_flag)
            ->setReg_ada_requirements($reg_ada_requirements)
            ->setReg_add_user($reg_add_user)
            ->setReg_add_date($reg_add_date)
            ->setReg_change_user($reg_change_user)
            ->setReg_ivd_key($reg_ivd_key)
            ->setReg_change_date($reg_change_date)
            ->setReg_inv_code($reg_inv_code)
            ->setReg_delete_flag($reg_delete_flag)
            ->setReg_org_name_dn($reg_org_name_dn)
            ->setReg_adr_city($reg_adr_city)
            ->setReg_key_ext($reg_key_ext)
            ->setReg_adr_state($reg_adr_state)
            ->setReg_adr_country($reg_adr_country)
            ->setReg_adr_intl_province($reg_adr_intl_province)
            ->setReg_ixo_title_dn($reg_ixo_title_dn)
            ->setReg_src_key($reg_src_key)
            ->setReg_ixo_key($reg_ixo_key)
            ->setReg_registration_date($reg_registration_date)
            ->setReg_cancel_date($reg_cancel_date)
            ->setReg_entity_key($reg_entity_key)
            ->setReg_cancel_reason($reg_cancel_reason)
            ->setReg_exam_result($reg_exam_result)
            ->setReg_examinee_no($reg_examinee_no)
            ->setReg_badge_print_date($reg_badge_print_date)
            ->setReg_reg_key($reg_reg_key)
            ->setReg_id($reg_id)
            ->setReg_odd_key($reg_odd_key)
            ->setReg_ord_code($reg_ord_code)
            ->setReg_complimentary_event_registered_flag($reg_complimentary_event_registered_flag)
            ->setReg_gft_key($reg_gft_key)
            ->setReg_fundraising_goal($reg_fundraising_goal)
            ->setReg_guest_flag($reg_guest_flag)
            ->setReg_time_in($reg_time_in)
            ->setReg_time_out($reg_time_out)
            ->setReg_narrative($reg_narrative)
            ->setReg_leaderboard_suppress_flag($reg_leaderboard_suppress_flag)
            ->setReg_leaderboard_suppress_amount($reg_leaderboard_suppress_amount)
            ->setReg_video_url($reg_video_url)
            ->setReg_waiver_signed_name($reg_waiver_signed_name)
            ->setReg_waiver_signed_date($reg_waiver_signed_date)
            ->setReg_attestation_complete_flag($reg_attestation_complete_flag)
            ->setReg_attestation_type($reg_attestation_type)
            ->setReg_attestation_entered_name($reg_attestation_entered_name);
    }
    /**
     * Get reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_key(): ?string
    {
        return $this->reg_key ?? null;
    }
    /**
     * Set reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_key(?string $reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_key) && !is_string($reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_key, true), gettype($reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_key, true)), __LINE__);
        }
        if (is_null($reg_key) || (is_array($reg_key) && empty($reg_key))) {
            unset($this->reg_key);
        } else {
            $this->reg_key = $reg_key;
        }
        
        return $this;
    }
    /**
     * Get reg_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_cst_key(): ?string
    {
        return $this->reg_cst_key ?? null;
    }
    /**
     * Set reg_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_cst_key(?string $reg_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_cst_key) && !is_string($reg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_cst_key, true), gettype($reg_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_cst_key, true)), __LINE__);
        }
        if (is_null($reg_cst_key) || (is_array($reg_cst_key) && empty($reg_cst_key))) {
            unset($this->reg_cst_key);
        } else {
            $this->reg_cst_key = $reg_cst_key;
        }
        
        return $this;
    }
    /**
     * Get reg_egp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_egp_key(): ?string
    {
        return $this->reg_egp_key ?? null;
    }
    /**
     * Set reg_egp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_egp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_egp_key(?string $reg_egp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_egp_key) && !is_string($reg_egp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_egp_key, true), gettype($reg_egp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_egp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_egp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_egp_key, true)), __LINE__);
        }
        if (is_null($reg_egp_key) || (is_array($reg_egp_key) && empty($reg_egp_key))) {
            unset($this->reg_egp_key);
        } else {
            $this->reg_egp_key = $reg_egp_key;
        }
        
        return $this;
    }
    /**
     * Get reg_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_evt_key(): ?string
    {
        return $this->reg_evt_key ?? null;
    }
    /**
     * Set reg_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_evt_key(?string $reg_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_evt_key) && !is_string($reg_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_evt_key, true), gettype($reg_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_evt_key, true)), __LINE__);
        }
        if (is_null($reg_evt_key) || (is_array($reg_evt_key) && empty($reg_evt_key))) {
            unset($this->reg_evt_key);
        } else {
            $this->reg_evt_key = $reg_evt_key;
        }
        
        return $this;
    }
    /**
     * Get reg_badge_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_badge_name(): ?string
    {
        return $this->reg_badge_name ?? null;
    }
    /**
     * Set reg_badge_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_badge_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_badge_name(?string $reg_badge_name = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_badge_name) && !is_string($reg_badge_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_badge_name, true), gettype($reg_badge_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($reg_badge_name) && mb_strlen((string) $reg_badge_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $reg_badge_name)), __LINE__);
        }
        if (is_null($reg_badge_name) || (is_array($reg_badge_name) && empty($reg_badge_name))) {
            unset($this->reg_badge_name);
        } else {
            $this->reg_badge_name = $reg_badge_name;
        }
        
        return $this;
    }
    /**
     * Get reg_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_cxa_key(): ?string
    {
        return $this->reg_cxa_key ?? null;
    }
    /**
     * Set reg_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_cxa_key(?string $reg_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_cxa_key) && !is_string($reg_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_cxa_key, true), gettype($reg_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_cxa_key, true)), __LINE__);
        }
        if (is_null($reg_cxa_key) || (is_array($reg_cxa_key) && empty($reg_cxa_key))) {
            unset($this->reg_cxa_key);
        } else {
            $this->reg_cxa_key = $reg_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get reg_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_cph_key(): ?string
    {
        return $this->reg_cph_key ?? null;
    }
    /**
     * Set reg_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_cph_key(?string $reg_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_cph_key) && !is_string($reg_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_cph_key, true), gettype($reg_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_cph_key, true)), __LINE__);
        }
        if (is_null($reg_cph_key) || (is_array($reg_cph_key) && empty($reg_cph_key))) {
            unset($this->reg_cph_key);
        } else {
            $this->reg_cph_key = $reg_cph_key;
        }
        
        return $this;
    }
    /**
     * Get reg_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_eml_key(): ?string
    {
        return $this->reg_eml_key ?? null;
    }
    /**
     * Set reg_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_eml_key(?string $reg_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_eml_key) && !is_string($reg_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_eml_key, true), gettype($reg_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_eml_key, true)), __LINE__);
        }
        if (is_null($reg_eml_key) || (is_array($reg_eml_key) && empty($reg_eml_key))) {
            unset($this->reg_eml_key);
        } else {
            $this->reg_eml_key = $reg_eml_key;
        }
        
        return $this;
    }
    /**
     * Get reg_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_cfx_key(): ?string
    {
        return $this->reg_cfx_key ?? null;
    }
    /**
     * Set reg_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_cfx_key(?string $reg_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_cfx_key) && !is_string($reg_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_cfx_key, true), gettype($reg_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_cfx_key, true)), __LINE__);
        }
        if (is_null($reg_cfx_key) || (is_array($reg_cfx_key) && empty($reg_cfx_key))) {
            unset($this->reg_cfx_key);
        } else {
            $this->reg_cfx_key = $reg_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get reg_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_url_key(): ?string
    {
        return $this->reg_url_key ?? null;
    }
    /**
     * Set reg_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_url_key(?string $reg_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_url_key) && !is_string($reg_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_url_key, true), gettype($reg_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_url_key, true)), __LINE__);
        }
        if (is_null($reg_url_key) || (is_array($reg_url_key) && empty($reg_url_key))) {
            unset($this->reg_url_key);
        } else {
            $this->reg_url_key = $reg_url_key;
        }
        
        return $this;
    }
    /**
     * Get reg_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_pref_comm_meth(): ?string
    {
        return $this->reg_pref_comm_meth ?? null;
    }
    /**
     * Set reg_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_pref_comm_meth(?string $reg_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_pref_comm_meth) && !is_string($reg_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_pref_comm_meth, true), gettype($reg_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($reg_pref_comm_meth) && mb_strlen((string) $reg_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $reg_pref_comm_meth)), __LINE__);
        }
        if (is_null($reg_pref_comm_meth) || (is_array($reg_pref_comm_meth) && empty($reg_pref_comm_meth))) {
            unset($this->reg_pref_comm_meth);
        } else {
            $this->reg_pref_comm_meth = $reg_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get reg_rgt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_rgt_key(): ?string
    {
        return $this->reg_rgt_key ?? null;
    }
    /**
     * Set reg_rgt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_rgt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_rgt_key(?string $reg_rgt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_rgt_key) && !is_string($reg_rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_rgt_key, true), gettype($reg_rgt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_rgt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_rgt_key, true)), __LINE__);
        }
        if (is_null($reg_rgt_key) || (is_array($reg_rgt_key) && empty($reg_rgt_key))) {
            unset($this->reg_rgt_key);
        } else {
            $this->reg_rgt_key = $reg_rgt_key;
        }
        
        return $this;
    }
    /**
     * Get reg_on_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_on_wait_list_flag(): ?string
    {
        return $this->reg_on_wait_list_flag ?? null;
    }
    /**
     * Set reg_on_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_on_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_on_wait_list_flag(?string $reg_on_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_on_wait_list_flag) && !is_string($reg_on_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_on_wait_list_flag, true), gettype($reg_on_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($reg_on_wait_list_flag) && $reg_on_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($reg_on_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reg_on_wait_list_flag) && $reg_on_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reg_on_wait_list_flag, true)), __LINE__);
        }
        if (is_null($reg_on_wait_list_flag) || (is_array($reg_on_wait_list_flag) && empty($reg_on_wait_list_flag))) {
            unset($this->reg_on_wait_list_flag);
        } else {
            $this->reg_on_wait_list_flag = $reg_on_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get reg_confirm_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_confirm_date(): ?string
    {
        return $this->reg_confirm_date ?? null;
    }
    /**
     * Set reg_confirm_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_confirm_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_confirm_date(?string $reg_confirm_date = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_confirm_date) && !is_string($reg_confirm_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_confirm_date, true), gettype($reg_confirm_date)), __LINE__);
        }
        if (is_null($reg_confirm_date) || (is_array($reg_confirm_date) && empty($reg_confirm_date))) {
            unset($this->reg_confirm_date);
        } else {
            $this->reg_confirm_date = $reg_confirm_date;
        }
        
        return $this;
    }
    /**
     * Get reg_attendance_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_attendance_flag(): ?string
    {
        return $this->reg_attendance_flag ?? null;
    }
    /**
     * Set reg_attendance_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_attendance_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_attendance_flag(?string $reg_attendance_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_attendance_flag) && !is_string($reg_attendance_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_attendance_flag, true), gettype($reg_attendance_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($reg_attendance_flag) && $reg_attendance_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($reg_attendance_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reg_attendance_flag) && $reg_attendance_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reg_attendance_flag, true)), __LINE__);
        }
        if (is_null($reg_attendance_flag) || (is_array($reg_attendance_flag) && empty($reg_attendance_flag))) {
            unset($this->reg_attendance_flag);
        } else {
            $this->reg_attendance_flag = $reg_attendance_flag;
        }
        
        return $this;
    }
    /**
     * Get reg_ada_requirements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_ada_requirements(): ?string
    {
        return $this->reg_ada_requirements ?? null;
    }
    /**
     * Set reg_ada_requirements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_ada_requirements
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_ada_requirements(?string $reg_ada_requirements = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_ada_requirements) && !is_string($reg_ada_requirements)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_ada_requirements, true), gettype($reg_ada_requirements)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($reg_ada_requirements) && mb_strlen((string) $reg_ada_requirements) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $reg_ada_requirements)), __LINE__);
        }
        if (is_null($reg_ada_requirements) || (is_array($reg_ada_requirements) && empty($reg_ada_requirements))) {
            unset($this->reg_ada_requirements);
        } else {
            $this->reg_ada_requirements = $reg_ada_requirements;
        }
        
        return $this;
    }
    /**
     * Get reg_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_add_user(): ?string
    {
        return $this->reg_add_user ?? null;
    }
    /**
     * Set reg_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_add_user(?string $reg_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_add_user) && !is_string($reg_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_add_user, true), gettype($reg_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($reg_add_user) && mb_strlen((string) $reg_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $reg_add_user)), __LINE__);
        }
        if (is_null($reg_add_user) || (is_array($reg_add_user) && empty($reg_add_user))) {
            unset($this->reg_add_user);
        } else {
            $this->reg_add_user = $reg_add_user;
        }
        
        return $this;
    }
    /**
     * Get reg_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_add_date(): ?string
    {
        return $this->reg_add_date ?? null;
    }
    /**
     * Set reg_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_add_date(?string $reg_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_add_date) && !is_string($reg_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_add_date, true), gettype($reg_add_date)), __LINE__);
        }
        if (is_null($reg_add_date) || (is_array($reg_add_date) && empty($reg_add_date))) {
            unset($this->reg_add_date);
        } else {
            $this->reg_add_date = $reg_add_date;
        }
        
        return $this;
    }
    /**
     * Get reg_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_change_user(): ?string
    {
        return $this->reg_change_user ?? null;
    }
    /**
     * Set reg_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_change_user(?string $reg_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_change_user) && !is_string($reg_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_change_user, true), gettype($reg_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($reg_change_user) && mb_strlen((string) $reg_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $reg_change_user)), __LINE__);
        }
        if (is_null($reg_change_user) || (is_array($reg_change_user) && empty($reg_change_user))) {
            unset($this->reg_change_user);
        } else {
            $this->reg_change_user = $reg_change_user;
        }
        
        return $this;
    }
    /**
     * Get reg_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_ivd_key(): ?string
    {
        return $this->reg_ivd_key ?? null;
    }
    /**
     * Set reg_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_ivd_key(?string $reg_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_ivd_key) && !is_string($reg_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_ivd_key, true), gettype($reg_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_ivd_key, true)), __LINE__);
        }
        if (is_null($reg_ivd_key) || (is_array($reg_ivd_key) && empty($reg_ivd_key))) {
            unset($this->reg_ivd_key);
        } else {
            $this->reg_ivd_key = $reg_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get reg_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_change_date(): ?string
    {
        return $this->reg_change_date ?? null;
    }
    /**
     * Set reg_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_change_date(?string $reg_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_change_date) && !is_string($reg_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_change_date, true), gettype($reg_change_date)), __LINE__);
        }
        if (is_null($reg_change_date) || (is_array($reg_change_date) && empty($reg_change_date))) {
            unset($this->reg_change_date);
        } else {
            $this->reg_change_date = $reg_change_date;
        }
        
        return $this;
    }
    /**
     * Get reg_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_inv_code(): ?string
    {
        return $this->reg_inv_code ?? null;
    }
    /**
     * Set reg_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_inv_code(?string $reg_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_inv_code) && !is_string($reg_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_inv_code, true), gettype($reg_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($reg_inv_code) && mb_strlen((string) $reg_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $reg_inv_code)), __LINE__);
        }
        if (is_null($reg_inv_code) || (is_array($reg_inv_code) && empty($reg_inv_code))) {
            unset($this->reg_inv_code);
        } else {
            $this->reg_inv_code = $reg_inv_code;
        }
        
        return $this;
    }
    /**
     * Get reg_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_delete_flag(): ?string
    {
        return $this->reg_delete_flag ?? null;
    }
    /**
     * Set reg_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_delete_flag(?string $reg_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_delete_flag) && !is_string($reg_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_delete_flag, true), gettype($reg_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($reg_delete_flag) && $reg_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($reg_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reg_delete_flag) && $reg_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reg_delete_flag, true)), __LINE__);
        }
        if (is_null($reg_delete_flag) || (is_array($reg_delete_flag) && empty($reg_delete_flag))) {
            unset($this->reg_delete_flag);
        } else {
            $this->reg_delete_flag = $reg_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get reg_org_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_org_name_dn(): ?string
    {
        return $this->reg_org_name_dn ?? null;
    }
    /**
     * Set reg_org_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_org_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_org_name_dn(?string $reg_org_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_org_name_dn) && !is_string($reg_org_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_org_name_dn, true), gettype($reg_org_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($reg_org_name_dn) && mb_strlen((string) $reg_org_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $reg_org_name_dn)), __LINE__);
        }
        if (is_null($reg_org_name_dn) || (is_array($reg_org_name_dn) && empty($reg_org_name_dn))) {
            unset($this->reg_org_name_dn);
        } else {
            $this->reg_org_name_dn = $reg_org_name_dn;
        }
        
        return $this;
    }
    /**
     * Get reg_adr_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_adr_city(): ?string
    {
        return $this->reg_adr_city ?? null;
    }
    /**
     * Set reg_adr_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_adr_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_adr_city(?string $reg_adr_city = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_adr_city) && !is_string($reg_adr_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_adr_city, true), gettype($reg_adr_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($reg_adr_city) && mb_strlen((string) $reg_adr_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $reg_adr_city)), __LINE__);
        }
        if (is_null($reg_adr_city) || (is_array($reg_adr_city) && empty($reg_adr_city))) {
            unset($this->reg_adr_city);
        } else {
            $this->reg_adr_city = $reg_adr_city;
        }
        
        return $this;
    }
    /**
     * Get reg_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_key_ext(): ?string
    {
        return $this->reg_key_ext ?? null;
    }
    /**
     * Set reg_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_key_ext(?string $reg_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_key_ext) && !is_string($reg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_key_ext, true), gettype($reg_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_key_ext, true)), __LINE__);
        }
        if (is_null($reg_key_ext) || (is_array($reg_key_ext) && empty($reg_key_ext))) {
            unset($this->reg_key_ext);
        } else {
            $this->reg_key_ext = $reg_key_ext;
        }
        
        return $this;
    }
    /**
     * Get reg_adr_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_adr_state(): ?string
    {
        return $this->reg_adr_state ?? null;
    }
    /**
     * Set reg_adr_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_adr_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_adr_state(?string $reg_adr_state = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_adr_state) && !is_string($reg_adr_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_adr_state, true), gettype($reg_adr_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($reg_adr_state) && mb_strlen((string) $reg_adr_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $reg_adr_state)), __LINE__);
        }
        if (is_null($reg_adr_state) || (is_array($reg_adr_state) && empty($reg_adr_state))) {
            unset($this->reg_adr_state);
        } else {
            $this->reg_adr_state = $reg_adr_state;
        }
        
        return $this;
    }
    /**
     * Get reg_adr_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_adr_country(): ?string
    {
        return $this->reg_adr_country ?? null;
    }
    /**
     * Set reg_adr_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_adr_country
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_adr_country(?string $reg_adr_country = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_adr_country) && !is_string($reg_adr_country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_adr_country, true), gettype($reg_adr_country)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($reg_adr_country) && mb_strlen((string) $reg_adr_country) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $reg_adr_country)), __LINE__);
        }
        if (is_null($reg_adr_country) || (is_array($reg_adr_country) && empty($reg_adr_country))) {
            unset($this->reg_adr_country);
        } else {
            $this->reg_adr_country = $reg_adr_country;
        }
        
        return $this;
    }
    /**
     * Get reg_adr_intl_province value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_adr_intl_province(): ?string
    {
        return $this->reg_adr_intl_province ?? null;
    }
    /**
     * Set reg_adr_intl_province value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_adr_intl_province
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_adr_intl_province(?string $reg_adr_intl_province = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_adr_intl_province) && !is_string($reg_adr_intl_province)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_adr_intl_province, true), gettype($reg_adr_intl_province)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($reg_adr_intl_province) && mb_strlen((string) $reg_adr_intl_province) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $reg_adr_intl_province)), __LINE__);
        }
        if (is_null($reg_adr_intl_province) || (is_array($reg_adr_intl_province) && empty($reg_adr_intl_province))) {
            unset($this->reg_adr_intl_province);
        } else {
            $this->reg_adr_intl_province = $reg_adr_intl_province;
        }
        
        return $this;
    }
    /**
     * Get reg_ixo_title_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_ixo_title_dn(): ?string
    {
        return $this->reg_ixo_title_dn ?? null;
    }
    /**
     * Set reg_ixo_title_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_ixo_title_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_ixo_title_dn(?string $reg_ixo_title_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_ixo_title_dn) && !is_string($reg_ixo_title_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_ixo_title_dn, true), gettype($reg_ixo_title_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($reg_ixo_title_dn) && mb_strlen((string) $reg_ixo_title_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $reg_ixo_title_dn)), __LINE__);
        }
        if (is_null($reg_ixo_title_dn) || (is_array($reg_ixo_title_dn) && empty($reg_ixo_title_dn))) {
            unset($this->reg_ixo_title_dn);
        } else {
            $this->reg_ixo_title_dn = $reg_ixo_title_dn;
        }
        
        return $this;
    }
    /**
     * Get reg_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_src_key(): ?string
    {
        return $this->reg_src_key ?? null;
    }
    /**
     * Set reg_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_src_key(?string $reg_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_src_key) && !is_string($reg_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_src_key, true), gettype($reg_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_src_key, true)), __LINE__);
        }
        if (is_null($reg_src_key) || (is_array($reg_src_key) && empty($reg_src_key))) {
            unset($this->reg_src_key);
        } else {
            $this->reg_src_key = $reg_src_key;
        }
        
        return $this;
    }
    /**
     * Get reg_ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_ixo_key(): ?string
    {
        return $this->reg_ixo_key ?? null;
    }
    /**
     * Set reg_ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_ixo_key(?string $reg_ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_ixo_key) && !is_string($reg_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_ixo_key, true), gettype($reg_ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_ixo_key, true)), __LINE__);
        }
        if (is_null($reg_ixo_key) || (is_array($reg_ixo_key) && empty($reg_ixo_key))) {
            unset($this->reg_ixo_key);
        } else {
            $this->reg_ixo_key = $reg_ixo_key;
        }
        
        return $this;
    }
    /**
     * Get reg_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_registration_date(): ?string
    {
        return $this->reg_registration_date ?? null;
    }
    /**
     * Set reg_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_registration_date(?string $reg_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_registration_date) && !is_string($reg_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_registration_date, true), gettype($reg_registration_date)), __LINE__);
        }
        if (is_null($reg_registration_date) || (is_array($reg_registration_date) && empty($reg_registration_date))) {
            unset($this->reg_registration_date);
        } else {
            $this->reg_registration_date = $reg_registration_date;
        }
        
        return $this;
    }
    /**
     * Get reg_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_cancel_date(): ?string
    {
        return $this->reg_cancel_date ?? null;
    }
    /**
     * Set reg_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_cancel_date(?string $reg_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_cancel_date) && !is_string($reg_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_cancel_date, true), gettype($reg_cancel_date)), __LINE__);
        }
        if (is_null($reg_cancel_date) || (is_array($reg_cancel_date) && empty($reg_cancel_date))) {
            unset($this->reg_cancel_date);
        } else {
            $this->reg_cancel_date = $reg_cancel_date;
        }
        
        return $this;
    }
    /**
     * Get reg_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_entity_key(): ?string
    {
        return $this->reg_entity_key ?? null;
    }
    /**
     * Set reg_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_entity_key(?string $reg_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_entity_key) && !is_string($reg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_entity_key, true), gettype($reg_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_entity_key, true)), __LINE__);
        }
        if (is_null($reg_entity_key) || (is_array($reg_entity_key) && empty($reg_entity_key))) {
            unset($this->reg_entity_key);
        } else {
            $this->reg_entity_key = $reg_entity_key;
        }
        
        return $this;
    }
    /**
     * Get reg_cancel_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_cancel_reason(): ?string
    {
        return $this->reg_cancel_reason ?? null;
    }
    /**
     * Set reg_cancel_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_cancel_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_cancel_reason(?string $reg_cancel_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_cancel_reason) && !is_string($reg_cancel_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_cancel_reason, true), gettype($reg_cancel_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($reg_cancel_reason) && mb_strlen((string) $reg_cancel_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $reg_cancel_reason)), __LINE__);
        }
        if (is_null($reg_cancel_reason) || (is_array($reg_cancel_reason) && empty($reg_cancel_reason))) {
            unset($this->reg_cancel_reason);
        } else {
            $this->reg_cancel_reason = $reg_cancel_reason;
        }
        
        return $this;
    }
    /**
     * Get reg_exam_result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_exam_result(): ?string
    {
        return $this->reg_exam_result ?? null;
    }
    /**
     * Set reg_exam_result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_exam_result
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_exam_result(?string $reg_exam_result = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_exam_result) && !is_string($reg_exam_result)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_exam_result, true), gettype($reg_exam_result)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($reg_exam_result) && mb_strlen((string) $reg_exam_result) > 7) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen((string) $reg_exam_result)), __LINE__);
        }
        if (is_null($reg_exam_result) || (is_array($reg_exam_result) && empty($reg_exam_result))) {
            unset($this->reg_exam_result);
        } else {
            $this->reg_exam_result = $reg_exam_result;
        }
        
        return $this;
    }
    /**
     * Get reg_examinee_no value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReg_examinee_no(): ?int
    {
        return $this->reg_examinee_no ?? null;
    }
    /**
     * Set reg_examinee_no value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reg_examinee_no
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_examinee_no(?int $reg_examinee_no = null): self
    {
        // validation for constraint: int
        if (!is_null($reg_examinee_no) && !(is_int($reg_examinee_no) || ctype_digit($reg_examinee_no))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reg_examinee_no, true), gettype($reg_examinee_no)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($reg_examinee_no) && $reg_examinee_no > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($reg_examinee_no, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($reg_examinee_no) && $reg_examinee_no < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($reg_examinee_no, true)), __LINE__);
        }
        if (is_null($reg_examinee_no) || (is_array($reg_examinee_no) && empty($reg_examinee_no))) {
            unset($this->reg_examinee_no);
        } else {
            $this->reg_examinee_no = $reg_examinee_no;
        }
        
        return $this;
    }
    /**
     * Get reg_badge_print_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_badge_print_date(): ?string
    {
        return $this->reg_badge_print_date ?? null;
    }
    /**
     * Set reg_badge_print_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_badge_print_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_badge_print_date(?string $reg_badge_print_date = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_badge_print_date) && !is_string($reg_badge_print_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_badge_print_date, true), gettype($reg_badge_print_date)), __LINE__);
        }
        if (is_null($reg_badge_print_date) || (is_array($reg_badge_print_date) && empty($reg_badge_print_date))) {
            unset($this->reg_badge_print_date);
        } else {
            $this->reg_badge_print_date = $reg_badge_print_date;
        }
        
        return $this;
    }
    /**
     * Get reg_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_reg_key(): ?string
    {
        return $this->reg_reg_key ?? null;
    }
    /**
     * Set reg_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_reg_key(?string $reg_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_reg_key) && !is_string($reg_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_reg_key, true), gettype($reg_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_reg_key, true)), __LINE__);
        }
        if (is_null($reg_reg_key) || (is_array($reg_reg_key) && empty($reg_reg_key))) {
            unset($this->reg_reg_key);
        } else {
            $this->reg_reg_key = $reg_reg_key;
        }
        
        return $this;
    }
    /**
     * Get reg_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_id(): ?string
    {
        return $this->reg_id ?? null;
    }
    /**
     * Set reg_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_id(?string $reg_id = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_id) && !is_string($reg_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_id, true), gettype($reg_id)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($reg_id) && mb_strlen((string) $reg_id) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $reg_id)), __LINE__);
        }
        if (is_null($reg_id) || (is_array($reg_id) && empty($reg_id))) {
            unset($this->reg_id);
        } else {
            $this->reg_id = $reg_id;
        }
        
        return $this;
    }
    /**
     * Get reg_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_odd_key(): ?string
    {
        return $this->reg_odd_key ?? null;
    }
    /**
     * Set reg_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_odd_key(?string $reg_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_odd_key) && !is_string($reg_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_odd_key, true), gettype($reg_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_odd_key, true)), __LINE__);
        }
        if (is_null($reg_odd_key) || (is_array($reg_odd_key) && empty($reg_odd_key))) {
            unset($this->reg_odd_key);
        } else {
            $this->reg_odd_key = $reg_odd_key;
        }
        
        return $this;
    }
    /**
     * Get reg_ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_ord_code(): ?string
    {
        return $this->reg_ord_code ?? null;
    }
    /**
     * Set reg_ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_ord_code(?string $reg_ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_ord_code) && !is_string($reg_ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_ord_code, true), gettype($reg_ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($reg_ord_code) && mb_strlen((string) $reg_ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $reg_ord_code)), __LINE__);
        }
        if (is_null($reg_ord_code) || (is_array($reg_ord_code) && empty($reg_ord_code))) {
            unset($this->reg_ord_code);
        } else {
            $this->reg_ord_code = $reg_ord_code;
        }
        
        return $this;
    }
    /**
     * Get reg_complimentary_event_registered_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_complimentary_event_registered_flag(): ?string
    {
        return $this->reg_complimentary_event_registered_flag ?? null;
    }
    /**
     * Set reg_complimentary_event_registered_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_complimentary_event_registered_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_complimentary_event_registered_flag(?string $reg_complimentary_event_registered_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_complimentary_event_registered_flag) && !is_string($reg_complimentary_event_registered_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_complimentary_event_registered_flag, true), gettype($reg_complimentary_event_registered_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($reg_complimentary_event_registered_flag) && $reg_complimentary_event_registered_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($reg_complimentary_event_registered_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reg_complimentary_event_registered_flag) && $reg_complimentary_event_registered_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reg_complimentary_event_registered_flag, true)), __LINE__);
        }
        if (is_null($reg_complimentary_event_registered_flag) || (is_array($reg_complimentary_event_registered_flag) && empty($reg_complimentary_event_registered_flag))) {
            unset($this->reg_complimentary_event_registered_flag);
        } else {
            $this->reg_complimentary_event_registered_flag = $reg_complimentary_event_registered_flag;
        }
        
        return $this;
    }
    /**
     * Get reg_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_gft_key(): ?string
    {
        return $this->reg_gft_key ?? null;
    }
    /**
     * Set reg_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_gft_key(?string $reg_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_gft_key) && !is_string($reg_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_gft_key, true), gettype($reg_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($reg_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $reg_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($reg_gft_key, true)), __LINE__);
        }
        if (is_null($reg_gft_key) || (is_array($reg_gft_key) && empty($reg_gft_key))) {
            unset($this->reg_gft_key);
        } else {
            $this->reg_gft_key = $reg_gft_key;
        }
        
        return $this;
    }
    /**
     * Get reg_fundraising_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReg_fundraising_goal(): ?float
    {
        return $this->reg_fundraising_goal ?? null;
    }
    /**
     * Set reg_fundraising_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reg_fundraising_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_fundraising_goal(?float $reg_fundraising_goal = null): self
    {
        // validation for constraint: float
        if (!is_null($reg_fundraising_goal) && !(is_float($reg_fundraising_goal) || is_numeric($reg_fundraising_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reg_fundraising_goal, true), gettype($reg_fundraising_goal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($reg_fundraising_goal) && mb_strlen(mb_substr((string) $reg_fundraising_goal, false !== mb_strpos((string) $reg_fundraising_goal, '.') ? mb_strpos((string) $reg_fundraising_goal, '.') + 1 : mb_strlen((string) $reg_fundraising_goal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($reg_fundraising_goal, true), mb_strlen(mb_substr((string) $reg_fundraising_goal, mb_strpos((string) $reg_fundraising_goal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($reg_fundraising_goal) && mb_strlen(preg_replace('/(\D)/', '', (string) $reg_fundraising_goal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($reg_fundraising_goal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $reg_fundraising_goal))), __LINE__);
        }
        if (is_null($reg_fundraising_goal) || (is_array($reg_fundraising_goal) && empty($reg_fundraising_goal))) {
            unset($this->reg_fundraising_goal);
        } else {
            $this->reg_fundraising_goal = $reg_fundraising_goal;
        }
        
        return $this;
    }
    /**
     * Get reg_guest_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_guest_flag(): ?string
    {
        return $this->reg_guest_flag ?? null;
    }
    /**
     * Set reg_guest_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_guest_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_guest_flag(?string $reg_guest_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_guest_flag) && !is_string($reg_guest_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_guest_flag, true), gettype($reg_guest_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($reg_guest_flag) && $reg_guest_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($reg_guest_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reg_guest_flag) && $reg_guest_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reg_guest_flag, true)), __LINE__);
        }
        if (is_null($reg_guest_flag) || (is_array($reg_guest_flag) && empty($reg_guest_flag))) {
            unset($this->reg_guest_flag);
        } else {
            $this->reg_guest_flag = $reg_guest_flag;
        }
        
        return $this;
    }
    /**
     * Get reg_time_in value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_time_in(): ?string
    {
        return $this->reg_time_in ?? null;
    }
    /**
     * Set reg_time_in value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_time_in
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_time_in(?string $reg_time_in = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_time_in) && !is_string($reg_time_in)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_time_in, true), gettype($reg_time_in)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($reg_time_in) && mb_strlen((string) $reg_time_in) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $reg_time_in)), __LINE__);
        }
        if (is_null($reg_time_in) || (is_array($reg_time_in) && empty($reg_time_in))) {
            unset($this->reg_time_in);
        } else {
            $this->reg_time_in = $reg_time_in;
        }
        
        return $this;
    }
    /**
     * Get reg_time_out value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_time_out(): ?string
    {
        return $this->reg_time_out ?? null;
    }
    /**
     * Set reg_time_out value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_time_out
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_time_out(?string $reg_time_out = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_time_out) && !is_string($reg_time_out)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_time_out, true), gettype($reg_time_out)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($reg_time_out) && mb_strlen((string) $reg_time_out) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $reg_time_out)), __LINE__);
        }
        if (is_null($reg_time_out) || (is_array($reg_time_out) && empty($reg_time_out))) {
            unset($this->reg_time_out);
        } else {
            $this->reg_time_out = $reg_time_out;
        }
        
        return $this;
    }
    /**
     * Get reg_narrative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_narrative(): ?string
    {
        return $this->reg_narrative ?? null;
    }
    /**
     * Set reg_narrative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_narrative
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_narrative(?string $reg_narrative = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_narrative) && !is_string($reg_narrative)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_narrative, true), gettype($reg_narrative)), __LINE__);
        }
        if (is_null($reg_narrative) || (is_array($reg_narrative) && empty($reg_narrative))) {
            unset($this->reg_narrative);
        } else {
            $this->reg_narrative = $reg_narrative;
        }
        
        return $this;
    }
    /**
     * Get reg_leaderboard_suppress_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_leaderboard_suppress_flag(): ?string
    {
        return $this->reg_leaderboard_suppress_flag ?? null;
    }
    /**
     * Set reg_leaderboard_suppress_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_leaderboard_suppress_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_leaderboard_suppress_flag(?string $reg_leaderboard_suppress_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_leaderboard_suppress_flag) && !is_string($reg_leaderboard_suppress_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_leaderboard_suppress_flag, true), gettype($reg_leaderboard_suppress_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($reg_leaderboard_suppress_flag) && $reg_leaderboard_suppress_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($reg_leaderboard_suppress_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reg_leaderboard_suppress_flag) && $reg_leaderboard_suppress_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reg_leaderboard_suppress_flag, true)), __LINE__);
        }
        if (is_null($reg_leaderboard_suppress_flag) || (is_array($reg_leaderboard_suppress_flag) && empty($reg_leaderboard_suppress_flag))) {
            unset($this->reg_leaderboard_suppress_flag);
        } else {
            $this->reg_leaderboard_suppress_flag = $reg_leaderboard_suppress_flag;
        }
        
        return $this;
    }
    /**
     * Get reg_leaderboard_suppress_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_leaderboard_suppress_amount(): ?string
    {
        return $this->reg_leaderboard_suppress_amount ?? null;
    }
    /**
     * Set reg_leaderboard_suppress_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_leaderboard_suppress_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_leaderboard_suppress_amount(?string $reg_leaderboard_suppress_amount = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_leaderboard_suppress_amount) && !is_string($reg_leaderboard_suppress_amount)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_leaderboard_suppress_amount, true), gettype($reg_leaderboard_suppress_amount)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($reg_leaderboard_suppress_amount) && $reg_leaderboard_suppress_amount > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($reg_leaderboard_suppress_amount, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reg_leaderboard_suppress_amount) && $reg_leaderboard_suppress_amount < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reg_leaderboard_suppress_amount, true)), __LINE__);
        }
        if (is_null($reg_leaderboard_suppress_amount) || (is_array($reg_leaderboard_suppress_amount) && empty($reg_leaderboard_suppress_amount))) {
            unset($this->reg_leaderboard_suppress_amount);
        } else {
            $this->reg_leaderboard_suppress_amount = $reg_leaderboard_suppress_amount;
        }
        
        return $this;
    }
    /**
     * Get reg_video_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_video_url(): ?string
    {
        return $this->reg_video_url ?? null;
    }
    /**
     * Set reg_video_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_video_url
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_video_url(?string $reg_video_url = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_video_url) && !is_string($reg_video_url)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_video_url, true), gettype($reg_video_url)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($reg_video_url) && mb_strlen((string) $reg_video_url) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $reg_video_url)), __LINE__);
        }
        if (is_null($reg_video_url) || (is_array($reg_video_url) && empty($reg_video_url))) {
            unset($this->reg_video_url);
        } else {
            $this->reg_video_url = $reg_video_url;
        }
        
        return $this;
    }
    /**
     * Get reg_waiver_signed_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_waiver_signed_name(): ?string
    {
        return $this->reg_waiver_signed_name ?? null;
    }
    /**
     * Set reg_waiver_signed_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_waiver_signed_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_waiver_signed_name(?string $reg_waiver_signed_name = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_waiver_signed_name) && !is_string($reg_waiver_signed_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_waiver_signed_name, true), gettype($reg_waiver_signed_name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($reg_waiver_signed_name) && mb_strlen((string) $reg_waiver_signed_name) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $reg_waiver_signed_name)), __LINE__);
        }
        if (is_null($reg_waiver_signed_name) || (is_array($reg_waiver_signed_name) && empty($reg_waiver_signed_name))) {
            unset($this->reg_waiver_signed_name);
        } else {
            $this->reg_waiver_signed_name = $reg_waiver_signed_name;
        }
        
        return $this;
    }
    /**
     * Get reg_waiver_signed_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_waiver_signed_date(): ?string
    {
        return $this->reg_waiver_signed_date ?? null;
    }
    /**
     * Set reg_waiver_signed_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_waiver_signed_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_waiver_signed_date(?string $reg_waiver_signed_date = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_waiver_signed_date) && !is_string($reg_waiver_signed_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_waiver_signed_date, true), gettype($reg_waiver_signed_date)), __LINE__);
        }
        if (is_null($reg_waiver_signed_date) || (is_array($reg_waiver_signed_date) && empty($reg_waiver_signed_date))) {
            unset($this->reg_waiver_signed_date);
        } else {
            $this->reg_waiver_signed_date = $reg_waiver_signed_date;
        }
        
        return $this;
    }
    /**
     * Get reg_attestation_complete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_attestation_complete_flag(): ?string
    {
        return $this->reg_attestation_complete_flag ?? null;
    }
    /**
     * Set reg_attestation_complete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_attestation_complete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_attestation_complete_flag(?string $reg_attestation_complete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_attestation_complete_flag) && !is_string($reg_attestation_complete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_attestation_complete_flag, true), gettype($reg_attestation_complete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($reg_attestation_complete_flag) && $reg_attestation_complete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($reg_attestation_complete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reg_attestation_complete_flag) && $reg_attestation_complete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reg_attestation_complete_flag, true)), __LINE__);
        }
        if (is_null($reg_attestation_complete_flag) || (is_array($reg_attestation_complete_flag) && empty($reg_attestation_complete_flag))) {
            unset($this->reg_attestation_complete_flag);
        } else {
            $this->reg_attestation_complete_flag = $reg_attestation_complete_flag;
        }
        
        return $this;
    }
    /**
     * Get reg_attestation_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_attestation_type(): ?string
    {
        return $this->reg_attestation_type ?? null;
    }
    /**
     * Set reg_attestation_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_attestation_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_attestation_type(?string $reg_attestation_type = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_attestation_type) && !is_string($reg_attestation_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_attestation_type, true), gettype($reg_attestation_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($reg_attestation_type) && mb_strlen((string) $reg_attestation_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $reg_attestation_type)), __LINE__);
        }
        if (is_null($reg_attestation_type) || (is_array($reg_attestation_type) && empty($reg_attestation_type))) {
            unset($this->reg_attestation_type);
        } else {
            $this->reg_attestation_type = $reg_attestation_type;
        }
        
        return $this;
    }
    /**
     * Get reg_attestation_entered_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReg_attestation_entered_name(): ?string
    {
        return $this->reg_attestation_entered_name ?? null;
    }
    /**
     * Set reg_attestation_entered_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reg_attestation_entered_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_registration_DataObjectType
     */
    public function setReg_attestation_entered_name(?string $reg_attestation_entered_name = null): self
    {
        // validation for constraint: string
        if (!is_null($reg_attestation_entered_name) && !is_string($reg_attestation_entered_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_attestation_entered_name, true), gettype($reg_attestation_entered_name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($reg_attestation_entered_name) && mb_strlen((string) $reg_attestation_entered_name) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $reg_attestation_entered_name)), __LINE__);
        }
        if (is_null($reg_attestation_entered_name) || (is_array($reg_attestation_entered_name) && empty($reg_attestation_entered_name))) {
            unset($this->reg_attestation_entered_name);
        } else {
            $this->reg_attestation_entered_name = $reg_attestation_entered_name;
        }
        
        return $this;
    }
}
