<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrantSession_ev_session_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrantSession_ev_session_DataObjectType extends AbstractStructBase
{
    /**
     * The ses_key
     * Meta information extracted from the WSDL
     * - documentation: Session Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ses_key = null;
    /**
     * The ses_code
     * Meta information extracted from the WSDL
     * - documentation: Session Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_code = null;
    /**
     * The ses_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_add_user = null;
    /**
     * The ses_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_add_date = null;
    /**
     * The ses_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_change_user = null;
    /**
     * The ses_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_change_date = null;
    /**
     * The ses_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_delete_flag = null;
    /**
     * The ses_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ses_key_ext = null;
    /**
     * The ses_evt_key
     * Meta information extracted from the WSDL
     * - documentation: Event. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ses_evt_key = null;
    /**
     * The ses_title
     * Meta information extracted from the WSDL
     * - documentation: Session Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_title = null;
    /**
     * The ses_set_key
     * Meta information extracted from the WSDL
     * - documentation: session type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ses_set_key = null;
    /**
     * The ses_capacity
     * Meta information extracted from the WSDL
     * - documentation: capacity. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ses_capacity = null;
    /**
     * The ses_registrant_goal
     * Meta information extracted from the WSDL
     * - documentation: registrant goal. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ses_registrant_goal = null;
    /**
     * The ses_revenue_goal
     * Meta information extracted from the WSDL
     * - documentation: revenue goal. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ses_revenue_goal = null;
    /**
     * The ses_display_order
     * Meta information extracted from the WSDL
     * - documentation: display order. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ses_display_order = null;
    /**
     * The ses_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: wait list?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_wait_list_flag = null;
    /**
     * The ses_auto_register_wait_list
     * Meta information extracted from the WSDL
     * - documentation: auto register wait list?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_auto_register_wait_list = null;
    /**
     * The ses_check_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: check wait list before register?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_check_wait_list_flag = null;
    /**
     * The ses_registration_required
     * Meta information extracted from the WSDL
     * - documentation: Main Event Registration Required. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_registration_required = null;
    /**
     * The ses_estimated_attendance
     * Meta information extracted from the WSDL
     * - documentation: estimated attendance. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ses_estimated_attendance = null;
    /**
     * The ses_guaranteed_attendance
     * Meta information extracted from the WSDL
     * - documentation: guaranteed attendance. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ses_guaranteed_attendance = null;
    /**
     * The ses_restricted
     * Meta information extracted from the WSDL
     * - documentation: restricted?.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_restricted = null;
    /**
     * The ses_short_description
     * Meta information extracted from the WSDL
     * - documentation: short description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_short_description = null;
    /**
     * The ses_description
     * Meta information extracted from the WSDL
     * - documentation: description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_description = null;
    /**
     * The ses_description_html
     * Meta information extracted from the WSDL
     * - documentation: html description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_description_html = null;
    /**
     * The ses_start_date
     * Meta information extracted from the WSDL
     * - documentation: start date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_start_date = null;
    /**
     * The ses_start_time
     * Meta information extracted from the WSDL
     * - documentation: start time. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_start_time = null;
    /**
     * The ses_end_date
     * Meta information extracted from the WSDL
     * - documentation: end date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_end_date = null;
    /**
     * The ses_end_time
     * Meta information extracted from the WSDL
     * - documentation: end time. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_end_time = null;
    /**
     * The ses_early_registration_date
     * Meta information extracted from the WSDL
     * - documentation: early registration date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_early_registration_date = null;
    /**
     * The ses_late_registration
     * Meta information extracted from the WSDL
     * - documentation: late registration date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_late_registration = null;
    /**
     * The ses_cutoff_date
     * Meta information extracted from the WSDL
     * - documentation: cutoff date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_cutoff_date = null;
    /**
     * The ses_post_to_web_date
     * Meta information extracted from the WSDL
     * - documentation: post to web date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_post_to_web_date = null;
    /**
     * The ses_sponsor_limit
     * Meta information extracted from the WSDL
     * - documentation: Maximum Sponsors. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ses_sponsor_limit = null;
    /**
     * The ses_pre_registration_date
     * Meta information extracted from the WSDL
     * - documentation: pre-registration date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_pre_registration_date = null;
    /**
     * The ses_remove_from_web_date
     * Meta information extracted from the WSDL
     * - documentation: remove from web date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_remove_from_web_date = null;
    /**
     * The ses_ceu_type
     * Meta information extracted from the WSDL
     * - documentation: CEU Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_ceu_type = null;
    /**
     * The ses_session_url
     * Meta information extracted from the WSDL
     * - documentation: url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_session_url = null;
    /**
     * The ses_ceu
     * Meta information extracted from the WSDL
     * - documentation: CEU#. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ses_ceu = null;
    /**
     * The ses_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ses_entity_key = null;
    /**
     * The ses_ticketed
     * Meta information extracted from the WSDL
     * - documentation: Ticketed?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_ticketed = null;
    /**
     * The ses_cec_key
     * Meta information extracted from the WSDL
     * - documentation: Course. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ses_cec_key = null;
    /**
     * The ses_abstract_flag
     * Meta information extracted from the WSDL
     * - documentation: Abstract. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_abstract_flag = null;
    /**
     * The ses_abstract_member_option
     * Meta information extracted from the WSDL
     * - documentation: Abstract Member Option. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_abstract_member_option = null;
    /**
     * The ses_abstract_deadline
     * Meta information extracted from the WSDL
     * - documentation: Abstract Deadline. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_abstract_deadline = null;
    /**
     * The ses_free_session_flag
     * Meta information extracted from the WSDL
     * - documentation: Free Session. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_free_session_flag = null;
    /**
     * The ses_free_guest_flag
     * Meta information extracted from the WSDL
     * - documentation: free guest. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ses_free_guest_flag = null;
    /**
     * The ses_wait_list_limit
     * Meta information extracted from the WSDL
     * - documentation: wait list limit. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ses_wait_list_limit = null;
    /**
     * The ses_fpc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: fundraising product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ses_fpc_prd_key = null;
    /**
     * Constructor method for EventsRegistrantSession_ev_session_DataObjectType
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_key()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_code()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_add_user()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_add_date()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_change_user()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_change_date()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_delete_flag()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_key_ext()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_evt_key()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_title()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_set_key()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_capacity()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_registrant_goal()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_revenue_goal()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_display_order()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_wait_list_flag()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_auto_register_wait_list()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_check_wait_list_flag()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_registration_required()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_estimated_attendance()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_guaranteed_attendance()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_restricted()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_short_description()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_description()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_description_html()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_start_date()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_start_time()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_end_date()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_end_time()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_early_registration_date()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_late_registration()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_cutoff_date()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_post_to_web_date()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_sponsor_limit()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_pre_registration_date()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_remove_from_web_date()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_ceu_type()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_session_url()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_ceu()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_entity_key()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_ticketed()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_cec_key()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_abstract_flag()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_abstract_member_option()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_abstract_deadline()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_free_session_flag()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_free_guest_flag()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_wait_list_limit()
     * @uses EventsRegistrantSession_ev_session_DataObjectType::setSes_fpc_prd_key()
     * @param string $ses_key
     * @param string $ses_code
     * @param string $ses_add_user
     * @param string $ses_add_date
     * @param string $ses_change_user
     * @param string $ses_change_date
     * @param string $ses_delete_flag
     * @param string $ses_key_ext
     * @param string $ses_evt_key
     * @param string $ses_title
     * @param string $ses_set_key
     * @param int $ses_capacity
     * @param int $ses_registrant_goal
     * @param int $ses_revenue_goal
     * @param int $ses_display_order
     * @param string $ses_wait_list_flag
     * @param string $ses_auto_register_wait_list
     * @param string $ses_check_wait_list_flag
     * @param string $ses_registration_required
     * @param int $ses_estimated_attendance
     * @param int $ses_guaranteed_attendance
     * @param string $ses_restricted
     * @param string $ses_short_description
     * @param string $ses_description
     * @param string $ses_description_html
     * @param string $ses_start_date
     * @param string $ses_start_time
     * @param string $ses_end_date
     * @param string $ses_end_time
     * @param string $ses_early_registration_date
     * @param string $ses_late_registration
     * @param string $ses_cutoff_date
     * @param string $ses_post_to_web_date
     * @param int $ses_sponsor_limit
     * @param string $ses_pre_registration_date
     * @param string $ses_remove_from_web_date
     * @param string $ses_ceu_type
     * @param string $ses_session_url
     * @param float $ses_ceu
     * @param string $ses_entity_key
     * @param string $ses_ticketed
     * @param string $ses_cec_key
     * @param string $ses_abstract_flag
     * @param string $ses_abstract_member_option
     * @param string $ses_abstract_deadline
     * @param string $ses_free_session_flag
     * @param string $ses_free_guest_flag
     * @param int $ses_wait_list_limit
     * @param string $ses_fpc_prd_key
     */
    public function __construct(?string $ses_key = null, ?string $ses_code = null, ?string $ses_add_user = null, ?string $ses_add_date = null, ?string $ses_change_user = null, ?string $ses_change_date = null, ?string $ses_delete_flag = null, ?string $ses_key_ext = null, ?string $ses_evt_key = null, ?string $ses_title = null, ?string $ses_set_key = null, ?int $ses_capacity = null, ?int $ses_registrant_goal = null, ?int $ses_revenue_goal = null, ?int $ses_display_order = null, ?string $ses_wait_list_flag = null, ?string $ses_auto_register_wait_list = null, ?string $ses_check_wait_list_flag = null, ?string $ses_registration_required = null, ?int $ses_estimated_attendance = null, ?int $ses_guaranteed_attendance = null, ?string $ses_restricted = null, ?string $ses_short_description = null, ?string $ses_description = null, ?string $ses_description_html = null, ?string $ses_start_date = null, ?string $ses_start_time = null, ?string $ses_end_date = null, ?string $ses_end_time = null, ?string $ses_early_registration_date = null, ?string $ses_late_registration = null, ?string $ses_cutoff_date = null, ?string $ses_post_to_web_date = null, ?int $ses_sponsor_limit = null, ?string $ses_pre_registration_date = null, ?string $ses_remove_from_web_date = null, ?string $ses_ceu_type = null, ?string $ses_session_url = null, ?float $ses_ceu = null, ?string $ses_entity_key = null, ?string $ses_ticketed = null, ?string $ses_cec_key = null, ?string $ses_abstract_flag = null, ?string $ses_abstract_member_option = null, ?string $ses_abstract_deadline = null, ?string $ses_free_session_flag = null, ?string $ses_free_guest_flag = null, ?int $ses_wait_list_limit = null, ?string $ses_fpc_prd_key = null)
    {
        $this
            ->setSes_key($ses_key)
            ->setSes_code($ses_code)
            ->setSes_add_user($ses_add_user)
            ->setSes_add_date($ses_add_date)
            ->setSes_change_user($ses_change_user)
            ->setSes_change_date($ses_change_date)
            ->setSes_delete_flag($ses_delete_flag)
            ->setSes_key_ext($ses_key_ext)
            ->setSes_evt_key($ses_evt_key)
            ->setSes_title($ses_title)
            ->setSes_set_key($ses_set_key)
            ->setSes_capacity($ses_capacity)
            ->setSes_registrant_goal($ses_registrant_goal)
            ->setSes_revenue_goal($ses_revenue_goal)
            ->setSes_display_order($ses_display_order)
            ->setSes_wait_list_flag($ses_wait_list_flag)
            ->setSes_auto_register_wait_list($ses_auto_register_wait_list)
            ->setSes_check_wait_list_flag($ses_check_wait_list_flag)
            ->setSes_registration_required($ses_registration_required)
            ->setSes_estimated_attendance($ses_estimated_attendance)
            ->setSes_guaranteed_attendance($ses_guaranteed_attendance)
            ->setSes_restricted($ses_restricted)
            ->setSes_short_description($ses_short_description)
            ->setSes_description($ses_description)
            ->setSes_description_html($ses_description_html)
            ->setSes_start_date($ses_start_date)
            ->setSes_start_time($ses_start_time)
            ->setSes_end_date($ses_end_date)
            ->setSes_end_time($ses_end_time)
            ->setSes_early_registration_date($ses_early_registration_date)
            ->setSes_late_registration($ses_late_registration)
            ->setSes_cutoff_date($ses_cutoff_date)
            ->setSes_post_to_web_date($ses_post_to_web_date)
            ->setSes_sponsor_limit($ses_sponsor_limit)
            ->setSes_pre_registration_date($ses_pre_registration_date)
            ->setSes_remove_from_web_date($ses_remove_from_web_date)
            ->setSes_ceu_type($ses_ceu_type)
            ->setSes_session_url($ses_session_url)
            ->setSes_ceu($ses_ceu)
            ->setSes_entity_key($ses_entity_key)
            ->setSes_ticketed($ses_ticketed)
            ->setSes_cec_key($ses_cec_key)
            ->setSes_abstract_flag($ses_abstract_flag)
            ->setSes_abstract_member_option($ses_abstract_member_option)
            ->setSes_abstract_deadline($ses_abstract_deadline)
            ->setSes_free_session_flag($ses_free_session_flag)
            ->setSes_free_guest_flag($ses_free_guest_flag)
            ->setSes_wait_list_limit($ses_wait_list_limit)
            ->setSes_fpc_prd_key($ses_fpc_prd_key);
    }
    /**
     * Get ses_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_key(): ?string
    {
        return $this->ses_key ?? null;
    }
    /**
     * Set ses_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_key(?string $ses_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_key) && !is_string($ses_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_key, true), gettype($ses_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ses_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ses_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ses_key, true)), __LINE__);
        }
        if (is_null($ses_key) || (is_array($ses_key) && empty($ses_key))) {
            unset($this->ses_key);
        } else {
            $this->ses_key = $ses_key;
        }
        
        return $this;
    }
    /**
     * Get ses_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_code(): ?string
    {
        return $this->ses_code ?? null;
    }
    /**
     * Set ses_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_code(?string $ses_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_code) && !is_string($ses_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_code, true), gettype($ses_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($ses_code) && mb_strlen((string) $ses_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $ses_code)), __LINE__);
        }
        if (is_null($ses_code) || (is_array($ses_code) && empty($ses_code))) {
            unset($this->ses_code);
        } else {
            $this->ses_code = $ses_code;
        }
        
        return $this;
    }
    /**
     * Get ses_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_add_user(): ?string
    {
        return $this->ses_add_user ?? null;
    }
    /**
     * Set ses_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_add_user(?string $ses_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_add_user) && !is_string($ses_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_add_user, true), gettype($ses_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ses_add_user) && mb_strlen((string) $ses_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ses_add_user)), __LINE__);
        }
        if (is_null($ses_add_user) || (is_array($ses_add_user) && empty($ses_add_user))) {
            unset($this->ses_add_user);
        } else {
            $this->ses_add_user = $ses_add_user;
        }
        
        return $this;
    }
    /**
     * Get ses_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_add_date(): ?string
    {
        return $this->ses_add_date ?? null;
    }
    /**
     * Set ses_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_add_date(?string $ses_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_add_date) && !is_string($ses_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_add_date, true), gettype($ses_add_date)), __LINE__);
        }
        if (is_null($ses_add_date) || (is_array($ses_add_date) && empty($ses_add_date))) {
            unset($this->ses_add_date);
        } else {
            $this->ses_add_date = $ses_add_date;
        }
        
        return $this;
    }
    /**
     * Get ses_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_change_user(): ?string
    {
        return $this->ses_change_user ?? null;
    }
    /**
     * Set ses_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_change_user(?string $ses_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_change_user) && !is_string($ses_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_change_user, true), gettype($ses_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ses_change_user) && mb_strlen((string) $ses_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ses_change_user)), __LINE__);
        }
        if (is_null($ses_change_user) || (is_array($ses_change_user) && empty($ses_change_user))) {
            unset($this->ses_change_user);
        } else {
            $this->ses_change_user = $ses_change_user;
        }
        
        return $this;
    }
    /**
     * Get ses_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_change_date(): ?string
    {
        return $this->ses_change_date ?? null;
    }
    /**
     * Set ses_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_change_date(?string $ses_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_change_date) && !is_string($ses_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_change_date, true), gettype($ses_change_date)), __LINE__);
        }
        if (is_null($ses_change_date) || (is_array($ses_change_date) && empty($ses_change_date))) {
            unset($this->ses_change_date);
        } else {
            $this->ses_change_date = $ses_change_date;
        }
        
        return $this;
    }
    /**
     * Get ses_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_delete_flag(): ?string
    {
        return $this->ses_delete_flag ?? null;
    }
    /**
     * Set ses_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_delete_flag(?string $ses_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_delete_flag) && !is_string($ses_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_delete_flag, true), gettype($ses_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_delete_flag) && $ses_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_delete_flag) && $ses_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_delete_flag, true)), __LINE__);
        }
        if (is_null($ses_delete_flag) || (is_array($ses_delete_flag) && empty($ses_delete_flag))) {
            unset($this->ses_delete_flag);
        } else {
            $this->ses_delete_flag = $ses_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ses_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_key_ext(): ?string
    {
        return $this->ses_key_ext ?? null;
    }
    /**
     * Set ses_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_key_ext(?string $ses_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_key_ext) && !is_string($ses_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_key_ext, true), gettype($ses_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ses_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ses_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ses_key_ext, true)), __LINE__);
        }
        if (is_null($ses_key_ext) || (is_array($ses_key_ext) && empty($ses_key_ext))) {
            unset($this->ses_key_ext);
        } else {
            $this->ses_key_ext = $ses_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ses_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_evt_key(): ?string
    {
        return $this->ses_evt_key ?? null;
    }
    /**
     * Set ses_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_evt_key(?string $ses_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_evt_key) && !is_string($ses_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_evt_key, true), gettype($ses_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ses_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ses_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ses_evt_key, true)), __LINE__);
        }
        if (is_null($ses_evt_key) || (is_array($ses_evt_key) && empty($ses_evt_key))) {
            unset($this->ses_evt_key);
        } else {
            $this->ses_evt_key = $ses_evt_key;
        }
        
        return $this;
    }
    /**
     * Get ses_title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_title(): ?string
    {
        return $this->ses_title ?? null;
    }
    /**
     * Set ses_title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_title
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_title(?string $ses_title = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_title) && !is_string($ses_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_title, true), gettype($ses_title)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($ses_title) && mb_strlen((string) $ses_title) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $ses_title)), __LINE__);
        }
        if (is_null($ses_title) || (is_array($ses_title) && empty($ses_title))) {
            unset($this->ses_title);
        } else {
            $this->ses_title = $ses_title;
        }
        
        return $this;
    }
    /**
     * Get ses_set_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_set_key(): ?string
    {
        return $this->ses_set_key ?? null;
    }
    /**
     * Set ses_set_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_set_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_set_key(?string $ses_set_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_set_key) && !is_string($ses_set_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_set_key, true), gettype($ses_set_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ses_set_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ses_set_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ses_set_key, true)), __LINE__);
        }
        if (is_null($ses_set_key) || (is_array($ses_set_key) && empty($ses_set_key))) {
            unset($this->ses_set_key);
        } else {
            $this->ses_set_key = $ses_set_key;
        }
        
        return $this;
    }
    /**
     * Get ses_capacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSes_capacity(): ?int
    {
        return $this->ses_capacity ?? null;
    }
    /**
     * Set ses_capacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ses_capacity
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_capacity(?int $ses_capacity = null): self
    {
        // validation for constraint: int
        if (!is_null($ses_capacity) && !(is_int($ses_capacity) || ctype_digit($ses_capacity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ses_capacity, true), gettype($ses_capacity)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ses_capacity) && $ses_capacity > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ses_capacity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ses_capacity) && $ses_capacity < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ses_capacity, true)), __LINE__);
        }
        if (is_null($ses_capacity) || (is_array($ses_capacity) && empty($ses_capacity))) {
            unset($this->ses_capacity);
        } else {
            $this->ses_capacity = $ses_capacity;
        }
        
        return $this;
    }
    /**
     * Get ses_registrant_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSes_registrant_goal(): ?int
    {
        return $this->ses_registrant_goal ?? null;
    }
    /**
     * Set ses_registrant_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ses_registrant_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_registrant_goal(?int $ses_registrant_goal = null): self
    {
        // validation for constraint: int
        if (!is_null($ses_registrant_goal) && !(is_int($ses_registrant_goal) || ctype_digit($ses_registrant_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ses_registrant_goal, true), gettype($ses_registrant_goal)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ses_registrant_goal) && $ses_registrant_goal > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ses_registrant_goal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ses_registrant_goal) && $ses_registrant_goal < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ses_registrant_goal, true)), __LINE__);
        }
        if (is_null($ses_registrant_goal) || (is_array($ses_registrant_goal) && empty($ses_registrant_goal))) {
            unset($this->ses_registrant_goal);
        } else {
            $this->ses_registrant_goal = $ses_registrant_goal;
        }
        
        return $this;
    }
    /**
     * Get ses_revenue_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSes_revenue_goal(): ?int
    {
        return $this->ses_revenue_goal ?? null;
    }
    /**
     * Set ses_revenue_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ses_revenue_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_revenue_goal(?int $ses_revenue_goal = null): self
    {
        // validation for constraint: int
        if (!is_null($ses_revenue_goal) && !(is_int($ses_revenue_goal) || ctype_digit($ses_revenue_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ses_revenue_goal, true), gettype($ses_revenue_goal)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ses_revenue_goal) && $ses_revenue_goal > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ses_revenue_goal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ses_revenue_goal) && $ses_revenue_goal < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ses_revenue_goal, true)), __LINE__);
        }
        if (is_null($ses_revenue_goal) || (is_array($ses_revenue_goal) && empty($ses_revenue_goal))) {
            unset($this->ses_revenue_goal);
        } else {
            $this->ses_revenue_goal = $ses_revenue_goal;
        }
        
        return $this;
    }
    /**
     * Get ses_display_order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSes_display_order(): ?int
    {
        return $this->ses_display_order ?? null;
    }
    /**
     * Set ses_display_order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ses_display_order
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_display_order(?int $ses_display_order = null): self
    {
        // validation for constraint: int
        if (!is_null($ses_display_order) && !(is_int($ses_display_order) || ctype_digit($ses_display_order))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ses_display_order, true), gettype($ses_display_order)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ses_display_order) && $ses_display_order > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ses_display_order, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ses_display_order) && $ses_display_order < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ses_display_order, true)), __LINE__);
        }
        if (is_null($ses_display_order) || (is_array($ses_display_order) && empty($ses_display_order))) {
            unset($this->ses_display_order);
        } else {
            $this->ses_display_order = $ses_display_order;
        }
        
        return $this;
    }
    /**
     * Get ses_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_wait_list_flag(): ?string
    {
        return $this->ses_wait_list_flag ?? null;
    }
    /**
     * Set ses_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_wait_list_flag(?string $ses_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_wait_list_flag) && !is_string($ses_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_wait_list_flag, true), gettype($ses_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_wait_list_flag) && $ses_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_wait_list_flag) && $ses_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_wait_list_flag, true)), __LINE__);
        }
        if (is_null($ses_wait_list_flag) || (is_array($ses_wait_list_flag) && empty($ses_wait_list_flag))) {
            unset($this->ses_wait_list_flag);
        } else {
            $this->ses_wait_list_flag = $ses_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get ses_auto_register_wait_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_auto_register_wait_list(): ?string
    {
        return $this->ses_auto_register_wait_list ?? null;
    }
    /**
     * Set ses_auto_register_wait_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_auto_register_wait_list
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_auto_register_wait_list(?string $ses_auto_register_wait_list = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_auto_register_wait_list) && !is_string($ses_auto_register_wait_list)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_auto_register_wait_list, true), gettype($ses_auto_register_wait_list)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_auto_register_wait_list) && $ses_auto_register_wait_list > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_auto_register_wait_list, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_auto_register_wait_list) && $ses_auto_register_wait_list < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_auto_register_wait_list, true)), __LINE__);
        }
        if (is_null($ses_auto_register_wait_list) || (is_array($ses_auto_register_wait_list) && empty($ses_auto_register_wait_list))) {
            unset($this->ses_auto_register_wait_list);
        } else {
            $this->ses_auto_register_wait_list = $ses_auto_register_wait_list;
        }
        
        return $this;
    }
    /**
     * Get ses_check_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_check_wait_list_flag(): ?string
    {
        return $this->ses_check_wait_list_flag ?? null;
    }
    /**
     * Set ses_check_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_check_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_check_wait_list_flag(?string $ses_check_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_check_wait_list_flag) && !is_string($ses_check_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_check_wait_list_flag, true), gettype($ses_check_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_check_wait_list_flag) && $ses_check_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_check_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_check_wait_list_flag) && $ses_check_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_check_wait_list_flag, true)), __LINE__);
        }
        if (is_null($ses_check_wait_list_flag) || (is_array($ses_check_wait_list_flag) && empty($ses_check_wait_list_flag))) {
            unset($this->ses_check_wait_list_flag);
        } else {
            $this->ses_check_wait_list_flag = $ses_check_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get ses_registration_required value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_registration_required(): ?string
    {
        return $this->ses_registration_required ?? null;
    }
    /**
     * Set ses_registration_required value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_registration_required
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_registration_required(?string $ses_registration_required = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_registration_required) && !is_string($ses_registration_required)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_registration_required, true), gettype($ses_registration_required)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_registration_required) && $ses_registration_required > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_registration_required, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_registration_required) && $ses_registration_required < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_registration_required, true)), __LINE__);
        }
        if (is_null($ses_registration_required) || (is_array($ses_registration_required) && empty($ses_registration_required))) {
            unset($this->ses_registration_required);
        } else {
            $this->ses_registration_required = $ses_registration_required;
        }
        
        return $this;
    }
    /**
     * Get ses_estimated_attendance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSes_estimated_attendance(): ?int
    {
        return $this->ses_estimated_attendance ?? null;
    }
    /**
     * Set ses_estimated_attendance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ses_estimated_attendance
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_estimated_attendance(?int $ses_estimated_attendance = null): self
    {
        // validation for constraint: int
        if (!is_null($ses_estimated_attendance) && !(is_int($ses_estimated_attendance) || ctype_digit($ses_estimated_attendance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ses_estimated_attendance, true), gettype($ses_estimated_attendance)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ses_estimated_attendance) && $ses_estimated_attendance > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ses_estimated_attendance, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ses_estimated_attendance) && $ses_estimated_attendance < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ses_estimated_attendance, true)), __LINE__);
        }
        if (is_null($ses_estimated_attendance) || (is_array($ses_estimated_attendance) && empty($ses_estimated_attendance))) {
            unset($this->ses_estimated_attendance);
        } else {
            $this->ses_estimated_attendance = $ses_estimated_attendance;
        }
        
        return $this;
    }
    /**
     * Get ses_guaranteed_attendance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSes_guaranteed_attendance(): ?int
    {
        return $this->ses_guaranteed_attendance ?? null;
    }
    /**
     * Set ses_guaranteed_attendance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ses_guaranteed_attendance
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_guaranteed_attendance(?int $ses_guaranteed_attendance = null): self
    {
        // validation for constraint: int
        if (!is_null($ses_guaranteed_attendance) && !(is_int($ses_guaranteed_attendance) || ctype_digit($ses_guaranteed_attendance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ses_guaranteed_attendance, true), gettype($ses_guaranteed_attendance)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ses_guaranteed_attendance) && $ses_guaranteed_attendance > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ses_guaranteed_attendance, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ses_guaranteed_attendance) && $ses_guaranteed_attendance < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ses_guaranteed_attendance, true)), __LINE__);
        }
        if (is_null($ses_guaranteed_attendance) || (is_array($ses_guaranteed_attendance) && empty($ses_guaranteed_attendance))) {
            unset($this->ses_guaranteed_attendance);
        } else {
            $this->ses_guaranteed_attendance = $ses_guaranteed_attendance;
        }
        
        return $this;
    }
    /**
     * Get ses_restricted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_restricted(): ?string
    {
        return $this->ses_restricted ?? null;
    }
    /**
     * Set ses_restricted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_restricted
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_restricted(?string $ses_restricted = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_restricted) && !is_string($ses_restricted)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_restricted, true), gettype($ses_restricted)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_restricted) && $ses_restricted > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_restricted, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_restricted) && $ses_restricted < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_restricted, true)), __LINE__);
        }
        if (is_null($ses_restricted) || (is_array($ses_restricted) && empty($ses_restricted))) {
            unset($this->ses_restricted);
        } else {
            $this->ses_restricted = $ses_restricted;
        }
        
        return $this;
    }
    /**
     * Get ses_short_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_short_description(): ?string
    {
        return $this->ses_short_description ?? null;
    }
    /**
     * Set ses_short_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_short_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_short_description(?string $ses_short_description = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_short_description) && !is_string($ses_short_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_short_description, true), gettype($ses_short_description)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($ses_short_description) && mb_strlen((string) $ses_short_description) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $ses_short_description)), __LINE__);
        }
        if (is_null($ses_short_description) || (is_array($ses_short_description) && empty($ses_short_description))) {
            unset($this->ses_short_description);
        } else {
            $this->ses_short_description = $ses_short_description;
        }
        
        return $this;
    }
    /**
     * Get ses_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_description(): ?string
    {
        return $this->ses_description ?? null;
    }
    /**
     * Set ses_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_description(?string $ses_description = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_description) && !is_string($ses_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_description, true), gettype($ses_description)), __LINE__);
        }
        // validation for constraint: maxLength(1600)
        if (!is_null($ses_description) && mb_strlen((string) $ses_description) > 1600) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1600', mb_strlen((string) $ses_description)), __LINE__);
        }
        if (is_null($ses_description) || (is_array($ses_description) && empty($ses_description))) {
            unset($this->ses_description);
        } else {
            $this->ses_description = $ses_description;
        }
        
        return $this;
    }
    /**
     * Get ses_description_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_description_html(): ?string
    {
        return $this->ses_description_html ?? null;
    }
    /**
     * Set ses_description_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_description_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_description_html(?string $ses_description_html = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_description_html) && !is_string($ses_description_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_description_html, true), gettype($ses_description_html)), __LINE__);
        }
        if (is_null($ses_description_html) || (is_array($ses_description_html) && empty($ses_description_html))) {
            unset($this->ses_description_html);
        } else {
            $this->ses_description_html = $ses_description_html;
        }
        
        return $this;
    }
    /**
     * Get ses_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_start_date(): ?string
    {
        return $this->ses_start_date ?? null;
    }
    /**
     * Set ses_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_start_date(?string $ses_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_start_date) && !is_string($ses_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_start_date, true), gettype($ses_start_date)), __LINE__);
        }
        if (is_null($ses_start_date) || (is_array($ses_start_date) && empty($ses_start_date))) {
            unset($this->ses_start_date);
        } else {
            $this->ses_start_date = $ses_start_date;
        }
        
        return $this;
    }
    /**
     * Get ses_start_time value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_start_time(): ?string
    {
        return $this->ses_start_time ?? null;
    }
    /**
     * Set ses_start_time value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_start_time
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_start_time(?string $ses_start_time = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_start_time) && !is_string($ses_start_time)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_start_time, true), gettype($ses_start_time)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($ses_start_time) && mb_strlen((string) $ses_start_time) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $ses_start_time)), __LINE__);
        }
        if (is_null($ses_start_time) || (is_array($ses_start_time) && empty($ses_start_time))) {
            unset($this->ses_start_time);
        } else {
            $this->ses_start_time = $ses_start_time;
        }
        
        return $this;
    }
    /**
     * Get ses_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_end_date(): ?string
    {
        return $this->ses_end_date ?? null;
    }
    /**
     * Set ses_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_end_date(?string $ses_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_end_date) && !is_string($ses_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_end_date, true), gettype($ses_end_date)), __LINE__);
        }
        if (is_null($ses_end_date) || (is_array($ses_end_date) && empty($ses_end_date))) {
            unset($this->ses_end_date);
        } else {
            $this->ses_end_date = $ses_end_date;
        }
        
        return $this;
    }
    /**
     * Get ses_end_time value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_end_time(): ?string
    {
        return $this->ses_end_time ?? null;
    }
    /**
     * Set ses_end_time value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_end_time
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_end_time(?string $ses_end_time = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_end_time) && !is_string($ses_end_time)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_end_time, true), gettype($ses_end_time)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($ses_end_time) && mb_strlen((string) $ses_end_time) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $ses_end_time)), __LINE__);
        }
        if (is_null($ses_end_time) || (is_array($ses_end_time) && empty($ses_end_time))) {
            unset($this->ses_end_time);
        } else {
            $this->ses_end_time = $ses_end_time;
        }
        
        return $this;
    }
    /**
     * Get ses_early_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_early_registration_date(): ?string
    {
        return $this->ses_early_registration_date ?? null;
    }
    /**
     * Set ses_early_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_early_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_early_registration_date(?string $ses_early_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_early_registration_date) && !is_string($ses_early_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_early_registration_date, true), gettype($ses_early_registration_date)), __LINE__);
        }
        if (is_null($ses_early_registration_date) || (is_array($ses_early_registration_date) && empty($ses_early_registration_date))) {
            unset($this->ses_early_registration_date);
        } else {
            $this->ses_early_registration_date = $ses_early_registration_date;
        }
        
        return $this;
    }
    /**
     * Get ses_late_registration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_late_registration(): ?string
    {
        return $this->ses_late_registration ?? null;
    }
    /**
     * Set ses_late_registration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_late_registration
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_late_registration(?string $ses_late_registration = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_late_registration) && !is_string($ses_late_registration)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_late_registration, true), gettype($ses_late_registration)), __LINE__);
        }
        if (is_null($ses_late_registration) || (is_array($ses_late_registration) && empty($ses_late_registration))) {
            unset($this->ses_late_registration);
        } else {
            $this->ses_late_registration = $ses_late_registration;
        }
        
        return $this;
    }
    /**
     * Get ses_cutoff_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_cutoff_date(): ?string
    {
        return $this->ses_cutoff_date ?? null;
    }
    /**
     * Set ses_cutoff_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_cutoff_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_cutoff_date(?string $ses_cutoff_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_cutoff_date) && !is_string($ses_cutoff_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_cutoff_date, true), gettype($ses_cutoff_date)), __LINE__);
        }
        if (is_null($ses_cutoff_date) || (is_array($ses_cutoff_date) && empty($ses_cutoff_date))) {
            unset($this->ses_cutoff_date);
        } else {
            $this->ses_cutoff_date = $ses_cutoff_date;
        }
        
        return $this;
    }
    /**
     * Get ses_post_to_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_post_to_web_date(): ?string
    {
        return $this->ses_post_to_web_date ?? null;
    }
    /**
     * Set ses_post_to_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_post_to_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_post_to_web_date(?string $ses_post_to_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_post_to_web_date) && !is_string($ses_post_to_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_post_to_web_date, true), gettype($ses_post_to_web_date)), __LINE__);
        }
        if (is_null($ses_post_to_web_date) || (is_array($ses_post_to_web_date) && empty($ses_post_to_web_date))) {
            unset($this->ses_post_to_web_date);
        } else {
            $this->ses_post_to_web_date = $ses_post_to_web_date;
        }
        
        return $this;
    }
    /**
     * Get ses_sponsor_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSes_sponsor_limit(): ?int
    {
        return $this->ses_sponsor_limit ?? null;
    }
    /**
     * Set ses_sponsor_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ses_sponsor_limit
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_sponsor_limit(?int $ses_sponsor_limit = null): self
    {
        // validation for constraint: int
        if (!is_null($ses_sponsor_limit) && !(is_int($ses_sponsor_limit) || ctype_digit($ses_sponsor_limit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ses_sponsor_limit, true), gettype($ses_sponsor_limit)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ses_sponsor_limit) && $ses_sponsor_limit > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ses_sponsor_limit, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ses_sponsor_limit) && $ses_sponsor_limit < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ses_sponsor_limit, true)), __LINE__);
        }
        if (is_null($ses_sponsor_limit) || (is_array($ses_sponsor_limit) && empty($ses_sponsor_limit))) {
            unset($this->ses_sponsor_limit);
        } else {
            $this->ses_sponsor_limit = $ses_sponsor_limit;
        }
        
        return $this;
    }
    /**
     * Get ses_pre_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_pre_registration_date(): ?string
    {
        return $this->ses_pre_registration_date ?? null;
    }
    /**
     * Set ses_pre_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_pre_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_pre_registration_date(?string $ses_pre_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_pre_registration_date) && !is_string($ses_pre_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_pre_registration_date, true), gettype($ses_pre_registration_date)), __LINE__);
        }
        if (is_null($ses_pre_registration_date) || (is_array($ses_pre_registration_date) && empty($ses_pre_registration_date))) {
            unset($this->ses_pre_registration_date);
        } else {
            $this->ses_pre_registration_date = $ses_pre_registration_date;
        }
        
        return $this;
    }
    /**
     * Get ses_remove_from_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_remove_from_web_date(): ?string
    {
        return $this->ses_remove_from_web_date ?? null;
    }
    /**
     * Set ses_remove_from_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_remove_from_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_remove_from_web_date(?string $ses_remove_from_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_remove_from_web_date) && !is_string($ses_remove_from_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_remove_from_web_date, true), gettype($ses_remove_from_web_date)), __LINE__);
        }
        if (is_null($ses_remove_from_web_date) || (is_array($ses_remove_from_web_date) && empty($ses_remove_from_web_date))) {
            unset($this->ses_remove_from_web_date);
        } else {
            $this->ses_remove_from_web_date = $ses_remove_from_web_date;
        }
        
        return $this;
    }
    /**
     * Get ses_ceu_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_ceu_type(): ?string
    {
        return $this->ses_ceu_type ?? null;
    }
    /**
     * Set ses_ceu_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_ceu_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_ceu_type(?string $ses_ceu_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_ceu_type) && !is_string($ses_ceu_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_ceu_type, true), gettype($ses_ceu_type)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($ses_ceu_type) && mb_strlen((string) $ses_ceu_type) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $ses_ceu_type)), __LINE__);
        }
        if (is_null($ses_ceu_type) || (is_array($ses_ceu_type) && empty($ses_ceu_type))) {
            unset($this->ses_ceu_type);
        } else {
            $this->ses_ceu_type = $ses_ceu_type;
        }
        
        return $this;
    }
    /**
     * Get ses_session_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_session_url(): ?string
    {
        return $this->ses_session_url ?? null;
    }
    /**
     * Set ses_session_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_session_url
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_session_url(?string $ses_session_url = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_session_url) && !is_string($ses_session_url)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_session_url, true), gettype($ses_session_url)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($ses_session_url) && mb_strlen((string) $ses_session_url) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $ses_session_url)), __LINE__);
        }
        if (is_null($ses_session_url) || (is_array($ses_session_url) && empty($ses_session_url))) {
            unset($this->ses_session_url);
        } else {
            $this->ses_session_url = $ses_session_url;
        }
        
        return $this;
    }
    /**
     * Get ses_ceu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSes_ceu(): ?float
    {
        return $this->ses_ceu ?? null;
    }
    /**
     * Set ses_ceu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ses_ceu
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_ceu(?float $ses_ceu = null): self
    {
        // validation for constraint: float
        if (!is_null($ses_ceu) && !(is_float($ses_ceu) || is_numeric($ses_ceu))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ses_ceu, true), gettype($ses_ceu)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($ses_ceu) && mb_strlen(mb_substr((string) $ses_ceu, false !== mb_strpos((string) $ses_ceu, '.') ? mb_strpos((string) $ses_ceu, '.') + 1 : mb_strlen((string) $ses_ceu))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($ses_ceu, true), mb_strlen(mb_substr((string) $ses_ceu, mb_strpos((string) $ses_ceu, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ses_ceu) && mb_strlen(preg_replace('/(\D)/', '', (string) $ses_ceu)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ses_ceu, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ses_ceu))), __LINE__);
        }
        if (is_null($ses_ceu) || (is_array($ses_ceu) && empty($ses_ceu))) {
            unset($this->ses_ceu);
        } else {
            $this->ses_ceu = $ses_ceu;
        }
        
        return $this;
    }
    /**
     * Get ses_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_entity_key(): ?string
    {
        return $this->ses_entity_key ?? null;
    }
    /**
     * Set ses_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_entity_key(?string $ses_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_entity_key) && !is_string($ses_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_entity_key, true), gettype($ses_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ses_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ses_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ses_entity_key, true)), __LINE__);
        }
        if (is_null($ses_entity_key) || (is_array($ses_entity_key) && empty($ses_entity_key))) {
            unset($this->ses_entity_key);
        } else {
            $this->ses_entity_key = $ses_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ses_ticketed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_ticketed(): ?string
    {
        return $this->ses_ticketed ?? null;
    }
    /**
     * Set ses_ticketed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_ticketed
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_ticketed(?string $ses_ticketed = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_ticketed) && !is_string($ses_ticketed)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_ticketed, true), gettype($ses_ticketed)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_ticketed) && $ses_ticketed > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_ticketed, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_ticketed) && $ses_ticketed < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_ticketed, true)), __LINE__);
        }
        if (is_null($ses_ticketed) || (is_array($ses_ticketed) && empty($ses_ticketed))) {
            unset($this->ses_ticketed);
        } else {
            $this->ses_ticketed = $ses_ticketed;
        }
        
        return $this;
    }
    /**
     * Get ses_cec_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_cec_key(): ?string
    {
        return $this->ses_cec_key ?? null;
    }
    /**
     * Set ses_cec_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_cec_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_cec_key(?string $ses_cec_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_cec_key) && !is_string($ses_cec_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_cec_key, true), gettype($ses_cec_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ses_cec_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ses_cec_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ses_cec_key, true)), __LINE__);
        }
        if (is_null($ses_cec_key) || (is_array($ses_cec_key) && empty($ses_cec_key))) {
            unset($this->ses_cec_key);
        } else {
            $this->ses_cec_key = $ses_cec_key;
        }
        
        return $this;
    }
    /**
     * Get ses_abstract_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_abstract_flag(): ?string
    {
        return $this->ses_abstract_flag ?? null;
    }
    /**
     * Set ses_abstract_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_abstract_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_abstract_flag(?string $ses_abstract_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_abstract_flag) && !is_string($ses_abstract_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_abstract_flag, true), gettype($ses_abstract_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_abstract_flag) && $ses_abstract_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_abstract_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_abstract_flag) && $ses_abstract_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_abstract_flag, true)), __LINE__);
        }
        if (is_null($ses_abstract_flag) || (is_array($ses_abstract_flag) && empty($ses_abstract_flag))) {
            unset($this->ses_abstract_flag);
        } else {
            $this->ses_abstract_flag = $ses_abstract_flag;
        }
        
        return $this;
    }
    /**
     * Get ses_abstract_member_option value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_abstract_member_option(): ?string
    {
        return $this->ses_abstract_member_option ?? null;
    }
    /**
     * Set ses_abstract_member_option value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_abstract_member_option
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_abstract_member_option(?string $ses_abstract_member_option = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_abstract_member_option) && !is_string($ses_abstract_member_option)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_abstract_member_option, true), gettype($ses_abstract_member_option)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ses_abstract_member_option) && mb_strlen((string) $ses_abstract_member_option) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ses_abstract_member_option)), __LINE__);
        }
        if (is_null($ses_abstract_member_option) || (is_array($ses_abstract_member_option) && empty($ses_abstract_member_option))) {
            unset($this->ses_abstract_member_option);
        } else {
            $this->ses_abstract_member_option = $ses_abstract_member_option;
        }
        
        return $this;
    }
    /**
     * Get ses_abstract_deadline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_abstract_deadline(): ?string
    {
        return $this->ses_abstract_deadline ?? null;
    }
    /**
     * Set ses_abstract_deadline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_abstract_deadline
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_abstract_deadline(?string $ses_abstract_deadline = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_abstract_deadline) && !is_string($ses_abstract_deadline)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_abstract_deadline, true), gettype($ses_abstract_deadline)), __LINE__);
        }
        if (is_null($ses_abstract_deadline) || (is_array($ses_abstract_deadline) && empty($ses_abstract_deadline))) {
            unset($this->ses_abstract_deadline);
        } else {
            $this->ses_abstract_deadline = $ses_abstract_deadline;
        }
        
        return $this;
    }
    /**
     * Get ses_free_session_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_free_session_flag(): ?string
    {
        return $this->ses_free_session_flag ?? null;
    }
    /**
     * Set ses_free_session_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_free_session_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_free_session_flag(?string $ses_free_session_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_free_session_flag) && !is_string($ses_free_session_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_free_session_flag, true), gettype($ses_free_session_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_free_session_flag) && $ses_free_session_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_free_session_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_free_session_flag) && $ses_free_session_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_free_session_flag, true)), __LINE__);
        }
        if (is_null($ses_free_session_flag) || (is_array($ses_free_session_flag) && empty($ses_free_session_flag))) {
            unset($this->ses_free_session_flag);
        } else {
            $this->ses_free_session_flag = $ses_free_session_flag;
        }
        
        return $this;
    }
    /**
     * Get ses_free_guest_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_free_guest_flag(): ?string
    {
        return $this->ses_free_guest_flag ?? null;
    }
    /**
     * Set ses_free_guest_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_free_guest_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_free_guest_flag(?string $ses_free_guest_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_free_guest_flag) && !is_string($ses_free_guest_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_free_guest_flag, true), gettype($ses_free_guest_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ses_free_guest_flag) && $ses_free_guest_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ses_free_guest_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ses_free_guest_flag) && $ses_free_guest_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ses_free_guest_flag, true)), __LINE__);
        }
        if (is_null($ses_free_guest_flag) || (is_array($ses_free_guest_flag) && empty($ses_free_guest_flag))) {
            unset($this->ses_free_guest_flag);
        } else {
            $this->ses_free_guest_flag = $ses_free_guest_flag;
        }
        
        return $this;
    }
    /**
     * Get ses_wait_list_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSes_wait_list_limit(): ?int
    {
        return $this->ses_wait_list_limit ?? null;
    }
    /**
     * Set ses_wait_list_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ses_wait_list_limit
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_wait_list_limit(?int $ses_wait_list_limit = null): self
    {
        // validation for constraint: int
        if (!is_null($ses_wait_list_limit) && !(is_int($ses_wait_list_limit) || ctype_digit($ses_wait_list_limit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ses_wait_list_limit, true), gettype($ses_wait_list_limit)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ses_wait_list_limit) && $ses_wait_list_limit > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ses_wait_list_limit, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ses_wait_list_limit) && $ses_wait_list_limit < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ses_wait_list_limit, true)), __LINE__);
        }
        if (is_null($ses_wait_list_limit) || (is_array($ses_wait_list_limit) && empty($ses_wait_list_limit))) {
            unset($this->ses_wait_list_limit);
        } else {
            $this->ses_wait_list_limit = $ses_wait_list_limit;
        }
        
        return $this;
    }
    /**
     * Get ses_fpc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSes_fpc_prd_key(): ?string
    {
        return $this->ses_fpc_prd_key ?? null;
    }
    /**
     * Set ses_fpc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ses_fpc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantSession_ev_session_DataObjectType
     */
    public function setSes_fpc_prd_key(?string $ses_fpc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ses_fpc_prd_key) && !is_string($ses_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ses_fpc_prd_key, true), gettype($ses_fpc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ses_fpc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ses_fpc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ses_fpc_prd_key, true)), __LINE__);
        }
        if (is_null($ses_fpc_prd_key) || (is_array($ses_fpc_prd_key) && empty($ses_fpc_prd_key))) {
            unset($this->ses_fpc_prd_key);
        } else {
            $this->ses_fpc_prd_key = $ses_fpc_prd_key;
        }
        
        return $this;
    }
}
