<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Fax_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Fax_DataObjectType extends AbstractStructBase
{
    /**
     * The fax_key
     * Meta information extracted from the WSDL
     * - documentation: Fax Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fax_key = null;
    /**
     * The fax_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Fax Owner. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fax_cst_key_owner = null;
    /**
     * The fax_number
     * Meta information extracted from the WSDL
     * - documentation: Fax Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fax_number = null;
    /**
     * The fax_number_display
     * Meta information extracted from the WSDL
     * - documentation: Formatted Fax Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fax_number_display = null;
    /**
     * The fax_cty_key
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'bc4b70f8-280e-4bb0-b935-9f728c50e183'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fax_cty_key = null;
    /**
     * The fax_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fax_add_user = null;
    /**
     * The fax_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fax_add_date = null;
    /**
     * The fax_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fax_change_user = null;
    /**
     * The fax_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fax_change_date = null;
    /**
     * The fax_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fax_delete_flag = null;
    /**
     * The fax_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fax_entity_key = null;
    /**
     * The fax_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fax_key_ext = null;
    /**
     * Constructor method for EventsRegistrant_Fax_DataObjectType
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_key()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_cst_key_owner()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_number()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_number_display()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_cty_key()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_add_user()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_add_date()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_change_user()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_change_date()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_delete_flag()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_entity_key()
     * @uses EventsRegistrant_Fax_DataObjectType::setFax_key_ext()
     * @param string $fax_key
     * @param string $fax_cst_key_owner
     * @param string $fax_number
     * @param string $fax_number_display
     * @param string $fax_cty_key
     * @param string $fax_add_user
     * @param string $fax_add_date
     * @param string $fax_change_user
     * @param string $fax_change_date
     * @param string $fax_delete_flag
     * @param string $fax_entity_key
     * @param string $fax_key_ext
     */
    public function __construct(?string $fax_key = null, ?string $fax_cst_key_owner = null, ?string $fax_number = null, ?string $fax_number_display = null, ?string $fax_cty_key = null, ?string $fax_add_user = null, ?string $fax_add_date = null, ?string $fax_change_user = null, ?string $fax_change_date = null, ?string $fax_delete_flag = null, ?string $fax_entity_key = null, ?string $fax_key_ext = null)
    {
        $this
            ->setFax_key($fax_key)
            ->setFax_cst_key_owner($fax_cst_key_owner)
            ->setFax_number($fax_number)
            ->setFax_number_display($fax_number_display)
            ->setFax_cty_key($fax_cty_key)
            ->setFax_add_user($fax_add_user)
            ->setFax_add_date($fax_add_date)
            ->setFax_change_user($fax_change_user)
            ->setFax_change_date($fax_change_date)
            ->setFax_delete_flag($fax_delete_flag)
            ->setFax_entity_key($fax_entity_key)
            ->setFax_key_ext($fax_key_ext);
    }
    /**
     * Get fax_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_key(): ?string
    {
        return $this->fax_key ?? null;
    }
    /**
     * Set fax_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_key(?string $fax_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_key) && !is_string($fax_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_key, true), gettype($fax_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fax_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fax_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fax_key, true)), __LINE__);
        }
        if (is_null($fax_key) || (is_array($fax_key) && empty($fax_key))) {
            unset($this->fax_key);
        } else {
            $this->fax_key = $fax_key;
        }
        
        return $this;
    }
    /**
     * Get fax_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_cst_key_owner(): ?string
    {
        return $this->fax_cst_key_owner ?? null;
    }
    /**
     * Set fax_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_cst_key_owner(?string $fax_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_cst_key_owner) && !is_string($fax_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_cst_key_owner, true), gettype($fax_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fax_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fax_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fax_cst_key_owner, true)), __LINE__);
        }
        if (is_null($fax_cst_key_owner) || (is_array($fax_cst_key_owner) && empty($fax_cst_key_owner))) {
            unset($this->fax_cst_key_owner);
        } else {
            $this->fax_cst_key_owner = $fax_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get fax_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_number(): ?string
    {
        return $this->fax_number ?? null;
    }
    /**
     * Set fax_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_number(?string $fax_number = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_number) && !is_string($fax_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_number, true), gettype($fax_number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fax_number) && mb_strlen((string) $fax_number) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $fax_number)), __LINE__);
        }
        if (is_null($fax_number) || (is_array($fax_number) && empty($fax_number))) {
            unset($this->fax_number);
        } else {
            $this->fax_number = $fax_number;
        }
        
        return $this;
    }
    /**
     * Get fax_number_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_number_display(): ?string
    {
        return $this->fax_number_display ?? null;
    }
    /**
     * Set fax_number_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_number_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_number_display(?string $fax_number_display = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_number_display) && !is_string($fax_number_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_number_display, true), gettype($fax_number_display)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($fax_number_display) && mb_strlen((string) $fax_number_display) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $fax_number_display)), __LINE__);
        }
        if (is_null($fax_number_display) || (is_array($fax_number_display) && empty($fax_number_display))) {
            unset($this->fax_number_display);
        } else {
            $this->fax_number_display = $fax_number_display;
        }
        
        return $this;
    }
    /**
     * Get fax_cty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_cty_key(): ?string
    {
        return $this->fax_cty_key ?? null;
    }
    /**
     * Set fax_cty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_cty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_cty_key(?string $fax_cty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_cty_key) && !is_string($fax_cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_cty_key, true), gettype($fax_cty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fax_cty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fax_cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fax_cty_key, true)), __LINE__);
        }
        if (is_null($fax_cty_key) || (is_array($fax_cty_key) && empty($fax_cty_key))) {
            unset($this->fax_cty_key);
        } else {
            $this->fax_cty_key = $fax_cty_key;
        }
        
        return $this;
    }
    /**
     * Get fax_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_add_user(): ?string
    {
        return $this->fax_add_user ?? null;
    }
    /**
     * Set fax_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_add_user(?string $fax_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_add_user) && !is_string($fax_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_add_user, true), gettype($fax_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fax_add_user) && mb_strlen((string) $fax_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $fax_add_user)), __LINE__);
        }
        if (is_null($fax_add_user) || (is_array($fax_add_user) && empty($fax_add_user))) {
            unset($this->fax_add_user);
        } else {
            $this->fax_add_user = $fax_add_user;
        }
        
        return $this;
    }
    /**
     * Get fax_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_add_date(): ?string
    {
        return $this->fax_add_date ?? null;
    }
    /**
     * Set fax_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_add_date(?string $fax_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_add_date) && !is_string($fax_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_add_date, true), gettype($fax_add_date)), __LINE__);
        }
        if (is_null($fax_add_date) || (is_array($fax_add_date) && empty($fax_add_date))) {
            unset($this->fax_add_date);
        } else {
            $this->fax_add_date = $fax_add_date;
        }
        
        return $this;
    }
    /**
     * Get fax_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_change_user(): ?string
    {
        return $this->fax_change_user ?? null;
    }
    /**
     * Set fax_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_change_user(?string $fax_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_change_user) && !is_string($fax_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_change_user, true), gettype($fax_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fax_change_user) && mb_strlen((string) $fax_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $fax_change_user)), __LINE__);
        }
        if (is_null($fax_change_user) || (is_array($fax_change_user) && empty($fax_change_user))) {
            unset($this->fax_change_user);
        } else {
            $this->fax_change_user = $fax_change_user;
        }
        
        return $this;
    }
    /**
     * Get fax_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_change_date(): ?string
    {
        return $this->fax_change_date ?? null;
    }
    /**
     * Set fax_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_change_date(?string $fax_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_change_date) && !is_string($fax_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_change_date, true), gettype($fax_change_date)), __LINE__);
        }
        if (is_null($fax_change_date) || (is_array($fax_change_date) && empty($fax_change_date))) {
            unset($this->fax_change_date);
        } else {
            $this->fax_change_date = $fax_change_date;
        }
        
        return $this;
    }
    /**
     * Get fax_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_delete_flag(): ?string
    {
        return $this->fax_delete_flag ?? null;
    }
    /**
     * Set fax_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_delete_flag(?string $fax_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_delete_flag) && !is_string($fax_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_delete_flag, true), gettype($fax_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($fax_delete_flag) && $fax_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($fax_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fax_delete_flag) && $fax_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fax_delete_flag, true)), __LINE__);
        }
        if (is_null($fax_delete_flag) || (is_array($fax_delete_flag) && empty($fax_delete_flag))) {
            unset($this->fax_delete_flag);
        } else {
            $this->fax_delete_flag = $fax_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get fax_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_entity_key(): ?string
    {
        return $this->fax_entity_key ?? null;
    }
    /**
     * Set fax_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_entity_key(?string $fax_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_entity_key) && !is_string($fax_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_entity_key, true), gettype($fax_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fax_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fax_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fax_entity_key, true)), __LINE__);
        }
        if (is_null($fax_entity_key) || (is_array($fax_entity_key) && empty($fax_entity_key))) {
            unset($this->fax_entity_key);
        } else {
            $this->fax_entity_key = $fax_entity_key;
        }
        
        return $this;
    }
    /**
     * Get fax_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_key_ext(): ?string
    {
        return $this->fax_key_ext ?? null;
    }
    /**
     * Set fax_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Fax_DataObjectType
     */
    public function setFax_key_ext(?string $fax_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_key_ext) && !is_string($fax_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_key_ext, true), gettype($fax_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fax_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fax_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fax_key_ext, true)), __LINE__);
        }
        if (is_null($fax_key_ext) || (is_array($fax_key_ext) && empty($fax_key_ext))) {
            unset($this->fax_key_ext);
        } else {
            $this->fax_key_ext = $fax_key_ext;
        }
        
        return $this;
    }
}
