<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Location_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Location_DataObjectType extends AbstractStructBase
{
    /**
     * The loc_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_key = null;
    /**
     * The loc_org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: organization. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_org_cst_key = null;
    /**
     * The loc_lct_key
     * Meta information extracted from the WSDL
     * - documentation: location type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_lct_key = null;
    /**
     * The loc_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_cxa_key = null;
    /**
     * The loc_cph_key
     * Meta information extracted from the WSDL
     * - documentation: phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_cph_key = null;
    /**
     * The loc_name
     * Meta information extracted from the WSDL
     * - documentation: location name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_name = null;
    /**
     * The loc_code
     * Meta information extracted from the WSDL
     * - documentation: location code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_code = null;
    /**
     * The loc_description
     * Meta information extracted from the WSDL
     * - documentation: description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_description = null;
    /**
     * The loc_housing_flag
     * Meta information extracted from the WSDL
     * - documentation: housing?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_housing_flag = null;
    /**
     * The loc_url_key
     * Meta information extracted from the WSDL
     * - documentation: url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_url_key = null;
    /**
     * The loc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_add_user = null;
    /**
     * The loc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_add_date = null;
    /**
     * The loc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_change_user = null;
    /**
     * The loc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_change_date = null;
    /**
     * The loc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_delete_flag = null;
    /**
     * The loc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_key_ext = null;
    /**
     * The loc_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_cfx_key = null;
    /**
     * The loc_eml_key
     * Meta information extracted from the WSDL
     * - documentation: email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_eml_key = null;
    /**
     * The loc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $loc_entity_key = null;
    /**
     * The loc_description_html
     * Meta information extracted from the WSDL
     * - documentation: description html. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $loc_description_html = null;
    /**
     * Constructor method for EventsRegistrant_Location_DataObjectType
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_key()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_org_cst_key()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_lct_key()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_cxa_key()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_cph_key()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_name()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_code()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_description()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_housing_flag()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_url_key()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_add_user()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_add_date()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_change_user()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_change_date()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_delete_flag()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_key_ext()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_cfx_key()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_eml_key()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_entity_key()
     * @uses EventsRegistrant_Location_DataObjectType::setLoc_description_html()
     * @param string $loc_key
     * @param string $loc_org_cst_key
     * @param string $loc_lct_key
     * @param string $loc_cxa_key
     * @param string $loc_cph_key
     * @param string $loc_name
     * @param string $loc_code
     * @param string $loc_description
     * @param string $loc_housing_flag
     * @param string $loc_url_key
     * @param string $loc_add_user
     * @param string $loc_add_date
     * @param string $loc_change_user
     * @param string $loc_change_date
     * @param string $loc_delete_flag
     * @param string $loc_key_ext
     * @param string $loc_cfx_key
     * @param string $loc_eml_key
     * @param string $loc_entity_key
     * @param string $loc_description_html
     */
    public function __construct(?string $loc_key = null, ?string $loc_org_cst_key = null, ?string $loc_lct_key = null, ?string $loc_cxa_key = null, ?string $loc_cph_key = null, ?string $loc_name = null, ?string $loc_code = null, ?string $loc_description = null, ?string $loc_housing_flag = null, ?string $loc_url_key = null, ?string $loc_add_user = null, ?string $loc_add_date = null, ?string $loc_change_user = null, ?string $loc_change_date = null, ?string $loc_delete_flag = null, ?string $loc_key_ext = null, ?string $loc_cfx_key = null, ?string $loc_eml_key = null, ?string $loc_entity_key = null, ?string $loc_description_html = null)
    {
        $this
            ->setLoc_key($loc_key)
            ->setLoc_org_cst_key($loc_org_cst_key)
            ->setLoc_lct_key($loc_lct_key)
            ->setLoc_cxa_key($loc_cxa_key)
            ->setLoc_cph_key($loc_cph_key)
            ->setLoc_name($loc_name)
            ->setLoc_code($loc_code)
            ->setLoc_description($loc_description)
            ->setLoc_housing_flag($loc_housing_flag)
            ->setLoc_url_key($loc_url_key)
            ->setLoc_add_user($loc_add_user)
            ->setLoc_add_date($loc_add_date)
            ->setLoc_change_user($loc_change_user)
            ->setLoc_change_date($loc_change_date)
            ->setLoc_delete_flag($loc_delete_flag)
            ->setLoc_key_ext($loc_key_ext)
            ->setLoc_cfx_key($loc_cfx_key)
            ->setLoc_eml_key($loc_eml_key)
            ->setLoc_entity_key($loc_entity_key)
            ->setLoc_description_html($loc_description_html);
    }
    /**
     * Get loc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_key(): ?string
    {
        return $this->loc_key ?? null;
    }
    /**
     * Set loc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_key(?string $loc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_key) && !is_string($loc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_key, true), gettype($loc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_key, true)), __LINE__);
        }
        if (is_null($loc_key) || (is_array($loc_key) && empty($loc_key))) {
            unset($this->loc_key);
        } else {
            $this->loc_key = $loc_key;
        }
        
        return $this;
    }
    /**
     * Get loc_org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_org_cst_key(): ?string
    {
        return $this->loc_org_cst_key ?? null;
    }
    /**
     * Set loc_org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_org_cst_key(?string $loc_org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_org_cst_key) && !is_string($loc_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_org_cst_key, true), gettype($loc_org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_org_cst_key, true)), __LINE__);
        }
        if (is_null($loc_org_cst_key) || (is_array($loc_org_cst_key) && empty($loc_org_cst_key))) {
            unset($this->loc_org_cst_key);
        } else {
            $this->loc_org_cst_key = $loc_org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get loc_lct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_lct_key(): ?string
    {
        return $this->loc_lct_key ?? null;
    }
    /**
     * Set loc_lct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_lct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_lct_key(?string $loc_lct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_lct_key) && !is_string($loc_lct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_lct_key, true), gettype($loc_lct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_lct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_lct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_lct_key, true)), __LINE__);
        }
        if (is_null($loc_lct_key) || (is_array($loc_lct_key) && empty($loc_lct_key))) {
            unset($this->loc_lct_key);
        } else {
            $this->loc_lct_key = $loc_lct_key;
        }
        
        return $this;
    }
    /**
     * Get loc_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_cxa_key(): ?string
    {
        return $this->loc_cxa_key ?? null;
    }
    /**
     * Set loc_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_cxa_key(?string $loc_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_cxa_key) && !is_string($loc_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_cxa_key, true), gettype($loc_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_cxa_key, true)), __LINE__);
        }
        if (is_null($loc_cxa_key) || (is_array($loc_cxa_key) && empty($loc_cxa_key))) {
            unset($this->loc_cxa_key);
        } else {
            $this->loc_cxa_key = $loc_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get loc_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_cph_key(): ?string
    {
        return $this->loc_cph_key ?? null;
    }
    /**
     * Set loc_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_cph_key(?string $loc_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_cph_key) && !is_string($loc_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_cph_key, true), gettype($loc_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_cph_key, true)), __LINE__);
        }
        if (is_null($loc_cph_key) || (is_array($loc_cph_key) && empty($loc_cph_key))) {
            unset($this->loc_cph_key);
        } else {
            $this->loc_cph_key = $loc_cph_key;
        }
        
        return $this;
    }
    /**
     * Get loc_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_name(): ?string
    {
        return $this->loc_name ?? null;
    }
    /**
     * Set loc_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_name(?string $loc_name = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_name) && !is_string($loc_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_name, true), gettype($loc_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($loc_name) && mb_strlen((string) $loc_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $loc_name)), __LINE__);
        }
        if (is_null($loc_name) || (is_array($loc_name) && empty($loc_name))) {
            unset($this->loc_name);
        } else {
            $this->loc_name = $loc_name;
        }
        
        return $this;
    }
    /**
     * Get loc_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_code(): ?string
    {
        return $this->loc_code ?? null;
    }
    /**
     * Set loc_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_code(?string $loc_code = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_code) && !is_string($loc_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_code, true), gettype($loc_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($loc_code) && mb_strlen((string) $loc_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $loc_code)), __LINE__);
        }
        if (is_null($loc_code) || (is_array($loc_code) && empty($loc_code))) {
            unset($this->loc_code);
        } else {
            $this->loc_code = $loc_code;
        }
        
        return $this;
    }
    /**
     * Get loc_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_description(): ?string
    {
        return $this->loc_description ?? null;
    }
    /**
     * Set loc_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_description(?string $loc_description = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_description) && !is_string($loc_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_description, true), gettype($loc_description)), __LINE__);
        }
        if (is_null($loc_description) || (is_array($loc_description) && empty($loc_description))) {
            unset($this->loc_description);
        } else {
            $this->loc_description = $loc_description;
        }
        
        return $this;
    }
    /**
     * Get loc_housing_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_housing_flag(): ?string
    {
        return $this->loc_housing_flag ?? null;
    }
    /**
     * Set loc_housing_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_housing_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_housing_flag(?string $loc_housing_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_housing_flag) && !is_string($loc_housing_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_housing_flag, true), gettype($loc_housing_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($loc_housing_flag) && $loc_housing_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($loc_housing_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($loc_housing_flag) && $loc_housing_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($loc_housing_flag, true)), __LINE__);
        }
        if (is_null($loc_housing_flag) || (is_array($loc_housing_flag) && empty($loc_housing_flag))) {
            unset($this->loc_housing_flag);
        } else {
            $this->loc_housing_flag = $loc_housing_flag;
        }
        
        return $this;
    }
    /**
     * Get loc_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_url_key(): ?string
    {
        return $this->loc_url_key ?? null;
    }
    /**
     * Set loc_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_url_key(?string $loc_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_url_key) && !is_string($loc_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_url_key, true), gettype($loc_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_url_key, true)), __LINE__);
        }
        if (is_null($loc_url_key) || (is_array($loc_url_key) && empty($loc_url_key))) {
            unset($this->loc_url_key);
        } else {
            $this->loc_url_key = $loc_url_key;
        }
        
        return $this;
    }
    /**
     * Get loc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_add_user(): ?string
    {
        return $this->loc_add_user ?? null;
    }
    /**
     * Set loc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_add_user(?string $loc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_add_user) && !is_string($loc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_add_user, true), gettype($loc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($loc_add_user) && mb_strlen((string) $loc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $loc_add_user)), __LINE__);
        }
        if (is_null($loc_add_user) || (is_array($loc_add_user) && empty($loc_add_user))) {
            unset($this->loc_add_user);
        } else {
            $this->loc_add_user = $loc_add_user;
        }
        
        return $this;
    }
    /**
     * Get loc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_add_date(): ?string
    {
        return $this->loc_add_date ?? null;
    }
    /**
     * Set loc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_add_date(?string $loc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_add_date) && !is_string($loc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_add_date, true), gettype($loc_add_date)), __LINE__);
        }
        if (is_null($loc_add_date) || (is_array($loc_add_date) && empty($loc_add_date))) {
            unset($this->loc_add_date);
        } else {
            $this->loc_add_date = $loc_add_date;
        }
        
        return $this;
    }
    /**
     * Get loc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_change_user(): ?string
    {
        return $this->loc_change_user ?? null;
    }
    /**
     * Set loc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_change_user(?string $loc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_change_user) && !is_string($loc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_change_user, true), gettype($loc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($loc_change_user) && mb_strlen((string) $loc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $loc_change_user)), __LINE__);
        }
        if (is_null($loc_change_user) || (is_array($loc_change_user) && empty($loc_change_user))) {
            unset($this->loc_change_user);
        } else {
            $this->loc_change_user = $loc_change_user;
        }
        
        return $this;
    }
    /**
     * Get loc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_change_date(): ?string
    {
        return $this->loc_change_date ?? null;
    }
    /**
     * Set loc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_change_date(?string $loc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_change_date) && !is_string($loc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_change_date, true), gettype($loc_change_date)), __LINE__);
        }
        if (is_null($loc_change_date) || (is_array($loc_change_date) && empty($loc_change_date))) {
            unset($this->loc_change_date);
        } else {
            $this->loc_change_date = $loc_change_date;
        }
        
        return $this;
    }
    /**
     * Get loc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_delete_flag(): ?string
    {
        return $this->loc_delete_flag ?? null;
    }
    /**
     * Set loc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_delete_flag(?string $loc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_delete_flag) && !is_string($loc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_delete_flag, true), gettype($loc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($loc_delete_flag) && $loc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($loc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($loc_delete_flag) && $loc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($loc_delete_flag, true)), __LINE__);
        }
        if (is_null($loc_delete_flag) || (is_array($loc_delete_flag) && empty($loc_delete_flag))) {
            unset($this->loc_delete_flag);
        } else {
            $this->loc_delete_flag = $loc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get loc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_key_ext(): ?string
    {
        return $this->loc_key_ext ?? null;
    }
    /**
     * Set loc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_key_ext(?string $loc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_key_ext) && !is_string($loc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_key_ext, true), gettype($loc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_key_ext, true)), __LINE__);
        }
        if (is_null($loc_key_ext) || (is_array($loc_key_ext) && empty($loc_key_ext))) {
            unset($this->loc_key_ext);
        } else {
            $this->loc_key_ext = $loc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get loc_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_cfx_key(): ?string
    {
        return $this->loc_cfx_key ?? null;
    }
    /**
     * Set loc_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_cfx_key(?string $loc_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_cfx_key) && !is_string($loc_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_cfx_key, true), gettype($loc_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_cfx_key, true)), __LINE__);
        }
        if (is_null($loc_cfx_key) || (is_array($loc_cfx_key) && empty($loc_cfx_key))) {
            unset($this->loc_cfx_key);
        } else {
            $this->loc_cfx_key = $loc_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get loc_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_eml_key(): ?string
    {
        return $this->loc_eml_key ?? null;
    }
    /**
     * Set loc_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_eml_key(?string $loc_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_eml_key) && !is_string($loc_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_eml_key, true), gettype($loc_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_eml_key, true)), __LINE__);
        }
        if (is_null($loc_eml_key) || (is_array($loc_eml_key) && empty($loc_eml_key))) {
            unset($this->loc_eml_key);
        } else {
            $this->loc_eml_key = $loc_eml_key;
        }
        
        return $this;
    }
    /**
     * Get loc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_entity_key(): ?string
    {
        return $this->loc_entity_key ?? null;
    }
    /**
     * Set loc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_entity_key(?string $loc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_entity_key) && !is_string($loc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_entity_key, true), gettype($loc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($loc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $loc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($loc_entity_key, true)), __LINE__);
        }
        if (is_null($loc_entity_key) || (is_array($loc_entity_key) && empty($loc_entity_key))) {
            unset($this->loc_entity_key);
        } else {
            $this->loc_entity_key = $loc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get loc_description_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoc_description_html(): ?string
    {
        return $this->loc_description_html ?? null;
    }
    /**
     * Set loc_description_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loc_description_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_DataObjectType
     */
    public function setLoc_description_html(?string $loc_description_html = null): self
    {
        // validation for constraint: string
        if (!is_null($loc_description_html) && !is_string($loc_description_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loc_description_html, true), gettype($loc_description_html)), __LINE__);
        }
        if (is_null($loc_description_html) || (is_array($loc_description_html) && empty($loc_description_html))) {
            unset($this->loc_description_html);
        } else {
            $this->loc_description_html = $loc_description_html;
        }
        
        return $this;
    }
}
