<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Location_Phone_XRef_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Location_Phone_XRef_DataObjectType extends AbstractStructBase
{
    /**
     * The cp2__cph_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cp2__cph_key = null;
    /**
     * The cp2__cph_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cp2__cph_cst_key = null;
    /**
     * The cp2__cph_phn_key
     * Meta information extracted from the WSDL
     * - documentation: Phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cp2__cph_phn_key = null;
    /**
     * The cp2__cph_pht_key
     * Meta information extracted from the WSDL
     * - documentation: Phone Type.This element has a default value of 'f2110a0a-9c30-40a3-8842-54dc0d05d415'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cp2__cph_pht_key = null;
    /**
     * The cp2__cph_cst_link_key
     * Meta information extracted from the WSDL
     * - documentation: Linked Phone Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cp2__cph_cst_link_key = null;
    /**
     * The cp2__cph_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cp2__cph_add_user = null;
    /**
     * The cp2__cph_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cp2__cph_add_date = null;
    /**
     * The cp2__cph_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cp2__cph_change_user = null;
    /**
     * The cp2__cph_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cp2__cph_change_date = null;
    /**
     * The cp2__cph_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cp2__cph_delete_flag = null;
    /**
     * The cp2__cph_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cp2__cph_key_ext = null;
    /**
     * The cp2__cph_unlisted_flag
     * Meta information extracted from the WSDL
     * - documentation: Unlisted Phone. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cp2__cph_unlisted_flag = null;
    /**
     * The cp2__cph_phn_number_complete
     * Meta information extracted from the WSDL
     * - documentation: Phone Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cp2__cph_phn_number_complete = null;
    /**
     * The cp2__cph_extension
     * Meta information extracted from the WSDL
     * - documentation: ph. ext.. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cp2__cph_extension = null;
    /**
     * The cp2__cph_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cp2__cph_entity_key = null;
    /**
     * Constructor method for EventsRegistrant_Location_Phone_XRef_DataObjectType
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_key()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_cst_key()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_phn_key()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_pht_key()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_cst_link_key()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_add_user()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_add_date()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_change_user()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_change_date()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_delete_flag()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_key_ext()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_unlisted_flag()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_phn_number_complete()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_extension()
     * @uses EventsRegistrant_Location_Phone_XRef_DataObjectType::setCp2__cph_entity_key()
     * @param string $cp2__cph_key
     * @param string $cp2__cph_cst_key
     * @param string $cp2__cph_phn_key
     * @param string $cp2__cph_pht_key
     * @param string $cp2__cph_cst_link_key
     * @param string $cp2__cph_add_user
     * @param string $cp2__cph_add_date
     * @param string $cp2__cph_change_user
     * @param string $cp2__cph_change_date
     * @param string $cp2__cph_delete_flag
     * @param string $cp2__cph_key_ext
     * @param string $cp2__cph_unlisted_flag
     * @param string $cp2__cph_phn_number_complete
     * @param string $cp2__cph_extension
     * @param string $cp2__cph_entity_key
     */
    public function __construct(?string $cp2__cph_key = null, ?string $cp2__cph_cst_key = null, ?string $cp2__cph_phn_key = null, ?string $cp2__cph_pht_key = null, ?string $cp2__cph_cst_link_key = null, ?string $cp2__cph_add_user = null, ?string $cp2__cph_add_date = null, ?string $cp2__cph_change_user = null, ?string $cp2__cph_change_date = null, ?string $cp2__cph_delete_flag = null, ?string $cp2__cph_key_ext = null, ?string $cp2__cph_unlisted_flag = null, ?string $cp2__cph_phn_number_complete = null, ?string $cp2__cph_extension = null, ?string $cp2__cph_entity_key = null)
    {
        $this
            ->setCp2__cph_key($cp2__cph_key)
            ->setCp2__cph_cst_key($cp2__cph_cst_key)
            ->setCp2__cph_phn_key($cp2__cph_phn_key)
            ->setCp2__cph_pht_key($cp2__cph_pht_key)
            ->setCp2__cph_cst_link_key($cp2__cph_cst_link_key)
            ->setCp2__cph_add_user($cp2__cph_add_user)
            ->setCp2__cph_add_date($cp2__cph_add_date)
            ->setCp2__cph_change_user($cp2__cph_change_user)
            ->setCp2__cph_change_date($cp2__cph_change_date)
            ->setCp2__cph_delete_flag($cp2__cph_delete_flag)
            ->setCp2__cph_key_ext($cp2__cph_key_ext)
            ->setCp2__cph_unlisted_flag($cp2__cph_unlisted_flag)
            ->setCp2__cph_phn_number_complete($cp2__cph_phn_number_complete)
            ->setCp2__cph_extension($cp2__cph_extension)
            ->setCp2__cph_entity_key($cp2__cph_entity_key);
    }
    /**
     * Get cp2__cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_key(): ?string
    {
        return $this->cp2__cph_key ?? null;
    }
    /**
     * Set cp2__cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_key(?string $cp2__cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_key) && !is_string($cp2__cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_key, true), gettype($cp2__cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cp2__cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cp2__cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cp2__cph_key, true)), __LINE__);
        }
        if (is_null($cp2__cph_key) || (is_array($cp2__cph_key) && empty($cp2__cph_key))) {
            unset($this->cp2__cph_key);
        } else {
            $this->cp2__cph_key = $cp2__cph_key;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_cst_key(): ?string
    {
        return $this->cp2__cph_cst_key ?? null;
    }
    /**
     * Set cp2__cph_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_cst_key(?string $cp2__cph_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_cst_key) && !is_string($cp2__cph_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_cst_key, true), gettype($cp2__cph_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cp2__cph_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cp2__cph_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cp2__cph_cst_key, true)), __LINE__);
        }
        if (is_null($cp2__cph_cst_key) || (is_array($cp2__cph_cst_key) && empty($cp2__cph_cst_key))) {
            unset($this->cp2__cph_cst_key);
        } else {
            $this->cp2__cph_cst_key = $cp2__cph_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_phn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_phn_key(): ?string
    {
        return $this->cp2__cph_phn_key ?? null;
    }
    /**
     * Set cp2__cph_phn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_phn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_phn_key(?string $cp2__cph_phn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_phn_key) && !is_string($cp2__cph_phn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_phn_key, true), gettype($cp2__cph_phn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cp2__cph_phn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cp2__cph_phn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cp2__cph_phn_key, true)), __LINE__);
        }
        if (is_null($cp2__cph_phn_key) || (is_array($cp2__cph_phn_key) && empty($cp2__cph_phn_key))) {
            unset($this->cp2__cph_phn_key);
        } else {
            $this->cp2__cph_phn_key = $cp2__cph_phn_key;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_pht_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_pht_key(): ?string
    {
        return $this->cp2__cph_pht_key ?? null;
    }
    /**
     * Set cp2__cph_pht_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_pht_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_pht_key(?string $cp2__cph_pht_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_pht_key) && !is_string($cp2__cph_pht_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_pht_key, true), gettype($cp2__cph_pht_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cp2__cph_pht_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cp2__cph_pht_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cp2__cph_pht_key, true)), __LINE__);
        }
        if (is_null($cp2__cph_pht_key) || (is_array($cp2__cph_pht_key) && empty($cp2__cph_pht_key))) {
            unset($this->cp2__cph_pht_key);
        } else {
            $this->cp2__cph_pht_key = $cp2__cph_pht_key;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_cst_link_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_cst_link_key(): ?string
    {
        return $this->cp2__cph_cst_link_key ?? null;
    }
    /**
     * Set cp2__cph_cst_link_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_cst_link_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_cst_link_key(?string $cp2__cph_cst_link_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_cst_link_key) && !is_string($cp2__cph_cst_link_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_cst_link_key, true), gettype($cp2__cph_cst_link_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cp2__cph_cst_link_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cp2__cph_cst_link_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cp2__cph_cst_link_key, true)), __LINE__);
        }
        if (is_null($cp2__cph_cst_link_key) || (is_array($cp2__cph_cst_link_key) && empty($cp2__cph_cst_link_key))) {
            unset($this->cp2__cph_cst_link_key);
        } else {
            $this->cp2__cph_cst_link_key = $cp2__cph_cst_link_key;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_add_user(): ?string
    {
        return $this->cp2__cph_add_user ?? null;
    }
    /**
     * Set cp2__cph_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_add_user(?string $cp2__cph_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_add_user) && !is_string($cp2__cph_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_add_user, true), gettype($cp2__cph_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cp2__cph_add_user) && mb_strlen((string) $cp2__cph_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cp2__cph_add_user)), __LINE__);
        }
        if (is_null($cp2__cph_add_user) || (is_array($cp2__cph_add_user) && empty($cp2__cph_add_user))) {
            unset($this->cp2__cph_add_user);
        } else {
            $this->cp2__cph_add_user = $cp2__cph_add_user;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_add_date(): ?string
    {
        return $this->cp2__cph_add_date ?? null;
    }
    /**
     * Set cp2__cph_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_add_date(?string $cp2__cph_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_add_date) && !is_string($cp2__cph_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_add_date, true), gettype($cp2__cph_add_date)), __LINE__);
        }
        if (is_null($cp2__cph_add_date) || (is_array($cp2__cph_add_date) && empty($cp2__cph_add_date))) {
            unset($this->cp2__cph_add_date);
        } else {
            $this->cp2__cph_add_date = $cp2__cph_add_date;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_change_user(): ?string
    {
        return $this->cp2__cph_change_user ?? null;
    }
    /**
     * Set cp2__cph_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_change_user(?string $cp2__cph_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_change_user) && !is_string($cp2__cph_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_change_user, true), gettype($cp2__cph_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cp2__cph_change_user) && mb_strlen((string) $cp2__cph_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cp2__cph_change_user)), __LINE__);
        }
        if (is_null($cp2__cph_change_user) || (is_array($cp2__cph_change_user) && empty($cp2__cph_change_user))) {
            unset($this->cp2__cph_change_user);
        } else {
            $this->cp2__cph_change_user = $cp2__cph_change_user;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_change_date(): ?string
    {
        return $this->cp2__cph_change_date ?? null;
    }
    /**
     * Set cp2__cph_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_change_date(?string $cp2__cph_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_change_date) && !is_string($cp2__cph_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_change_date, true), gettype($cp2__cph_change_date)), __LINE__);
        }
        if (is_null($cp2__cph_change_date) || (is_array($cp2__cph_change_date) && empty($cp2__cph_change_date))) {
            unset($this->cp2__cph_change_date);
        } else {
            $this->cp2__cph_change_date = $cp2__cph_change_date;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_delete_flag(): ?string
    {
        return $this->cp2__cph_delete_flag ?? null;
    }
    /**
     * Set cp2__cph_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_delete_flag(?string $cp2__cph_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_delete_flag) && !is_string($cp2__cph_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_delete_flag, true), gettype($cp2__cph_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cp2__cph_delete_flag) && $cp2__cph_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cp2__cph_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cp2__cph_delete_flag) && $cp2__cph_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cp2__cph_delete_flag, true)), __LINE__);
        }
        if (is_null($cp2__cph_delete_flag) || (is_array($cp2__cph_delete_flag) && empty($cp2__cph_delete_flag))) {
            unset($this->cp2__cph_delete_flag);
        } else {
            $this->cp2__cph_delete_flag = $cp2__cph_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_key_ext(): ?string
    {
        return $this->cp2__cph_key_ext ?? null;
    }
    /**
     * Set cp2__cph_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_key_ext(?string $cp2__cph_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_key_ext) && !is_string($cp2__cph_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_key_ext, true), gettype($cp2__cph_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cp2__cph_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cp2__cph_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cp2__cph_key_ext, true)), __LINE__);
        }
        if (is_null($cp2__cph_key_ext) || (is_array($cp2__cph_key_ext) && empty($cp2__cph_key_ext))) {
            unset($this->cp2__cph_key_ext);
        } else {
            $this->cp2__cph_key_ext = $cp2__cph_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_unlisted_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_unlisted_flag(): ?string
    {
        return $this->cp2__cph_unlisted_flag ?? null;
    }
    /**
     * Set cp2__cph_unlisted_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_unlisted_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_unlisted_flag(?string $cp2__cph_unlisted_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_unlisted_flag) && !is_string($cp2__cph_unlisted_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_unlisted_flag, true), gettype($cp2__cph_unlisted_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cp2__cph_unlisted_flag) && $cp2__cph_unlisted_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cp2__cph_unlisted_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cp2__cph_unlisted_flag) && $cp2__cph_unlisted_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cp2__cph_unlisted_flag, true)), __LINE__);
        }
        if (is_null($cp2__cph_unlisted_flag) || (is_array($cp2__cph_unlisted_flag) && empty($cp2__cph_unlisted_flag))) {
            unset($this->cp2__cph_unlisted_flag);
        } else {
            $this->cp2__cph_unlisted_flag = $cp2__cph_unlisted_flag;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_phn_number_complete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_phn_number_complete(): ?string
    {
        return $this->cp2__cph_phn_number_complete ?? null;
    }
    /**
     * Set cp2__cph_phn_number_complete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_phn_number_complete
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_phn_number_complete(?string $cp2__cph_phn_number_complete = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_phn_number_complete) && !is_string($cp2__cph_phn_number_complete)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_phn_number_complete, true), gettype($cp2__cph_phn_number_complete)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($cp2__cph_phn_number_complete) && mb_strlen((string) $cp2__cph_phn_number_complete) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $cp2__cph_phn_number_complete)), __LINE__);
        }
        if (is_null($cp2__cph_phn_number_complete) || (is_array($cp2__cph_phn_number_complete) && empty($cp2__cph_phn_number_complete))) {
            unset($this->cp2__cph_phn_number_complete);
        } else {
            $this->cp2__cph_phn_number_complete = $cp2__cph_phn_number_complete;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_extension(): ?string
    {
        return $this->cp2__cph_extension ?? null;
    }
    /**
     * Set cp2__cph_extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_extension
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_extension(?string $cp2__cph_extension = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_extension) && !is_string($cp2__cph_extension)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_extension, true), gettype($cp2__cph_extension)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cp2__cph_extension) && mb_strlen((string) $cp2__cph_extension) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cp2__cph_extension)), __LINE__);
        }
        if (is_null($cp2__cph_extension) || (is_array($cp2__cph_extension) && empty($cp2__cph_extension))) {
            unset($this->cp2__cph_extension);
        } else {
            $this->cp2__cph_extension = $cp2__cph_extension;
        }
        
        return $this;
    }
    /**
     * Get cp2__cph_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCp2__cph_entity_key(): ?string
    {
        return $this->cp2__cph_entity_key ?? null;
    }
    /**
     * Set cp2__cph_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cp2__cph_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Location_Phone_XRef_DataObjectType
     */
    public function setCp2__cph_entity_key(?string $cp2__cph_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cp2__cph_entity_key) && !is_string($cp2__cph_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cp2__cph_entity_key, true), gettype($cp2__cph_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cp2__cph_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cp2__cph_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cp2__cph_entity_key, true)), __LINE__);
        }
        if (is_null($cp2__cph_entity_key) || (is_array($cp2__cph_entity_key) && empty($cp2__cph_entity_key))) {
            unset($this->cp2__cph_entity_key);
        } else {
            $this->cp2__cph_entity_key = $cp2__cph_entity_key;
        }
        
        return $this;
    }
}
