<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_RegistrantGuest_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_RegistrantGuest_DataObjectType extends AbstractStructBase
{
    /**
     * The rg2__reg_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_key = null;
    /**
     * The rg2__reg_cst_key
     * Meta information extracted from the WSDL
     * - documentation: registrant. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_cst_key = null;
    /**
     * The rg2__reg_egp_key
     * Meta information extracted from the WSDL
     * - documentation: group registration key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_egp_key = null;
    /**
     * The rg2__reg_evt_key
     * Meta information extracted from the WSDL
     * - documentation: Event. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_evt_key = null;
    /**
     * The rg2__reg_badge_name
     * Meta information extracted from the WSDL
     * - documentation: badge name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_badge_name = null;
    /**
     * The rg2__reg_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_cxa_key = null;
    /**
     * The rg2__reg_cph_key
     * Meta information extracted from the WSDL
     * - documentation: phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_cph_key = null;
    /**
     * The rg2__reg_eml_key
     * Meta information extracted from the WSDL
     * - documentation: email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_eml_key = null;
    /**
     * The rg2__reg_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_cfx_key = null;
    /**
     * The rg2__reg_url_key
     * Meta information extracted from the WSDL
     * - documentation: url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_url_key = null;
    /**
     * The rg2__reg_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: pref comm method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_pref_comm_meth = null;
    /**
     * The rg2__reg_rgt_key
     * Meta information extracted from the WSDL
     * - documentation: registrant type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_rgt_key = null;
    /**
     * The rg2__reg_on_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: on wait list?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_on_wait_list_flag = null;
    /**
     * The rg2__reg_confirm_date
     * Meta information extracted from the WSDL
     * - documentation: date confirmation sent. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_confirm_date = null;
    /**
     * The rg2__reg_attendance_flag
     * Meta information extracted from the WSDL
     * - documentation: attended?.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_attendance_flag = null;
    /**
     * The rg2__reg_ada_requirements
     * Meta information extracted from the WSDL
     * - documentation: Disability Requirements. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_ada_requirements = null;
    /**
     * The rg2__reg_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_add_user = null;
    /**
     * The rg2__reg_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_add_date = null;
    /**
     * The rg2__reg_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_change_user = null;
    /**
     * The rg2__reg_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_ivd_key = null;
    /**
     * The rg2__reg_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_change_date = null;
    /**
     * The rg2__reg_inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_inv_code = null;
    /**
     * The rg2__reg_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_delete_flag = null;
    /**
     * The rg2__reg_org_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Organization Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_org_name_dn = null;
    /**
     * The rg2__reg_adr_city
     * Meta information extracted from the WSDL
     * - documentation: City. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_adr_city = null;
    /**
     * The rg2__reg_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_key_ext = null;
    /**
     * The rg2__reg_adr_state
     * Meta information extracted from the WSDL
     * - documentation: State.This element has a default value of 'NULL'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_adr_state = null;
    /**
     * The rg2__reg_adr_country
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'UNITED STATES'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_adr_country = null;
    /**
     * The rg2__reg_adr_intl_province
     * Meta information extracted from the WSDL
     * - documentation: Province. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_adr_intl_province = null;
    /**
     * The rg2__reg_ixo_title_dn
     * Meta information extracted from the WSDL
     * - documentation: Title. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_ixo_title_dn = null;
    /**
     * The rg2__reg_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_src_key = null;
    /**
     * The rg2__reg_ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Organization. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_ixo_key = null;
    /**
     * The rg2__reg_registration_date
     * Meta information extracted from the WSDL
     * - documentation: Registration Date.This element has a default value of '7/1/2025'. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_registration_date = null;
    /**
     * The rg2__reg_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: Cancel Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_cancel_date = null;
    /**
     * The rg2__reg_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_entity_key = null;
    /**
     * The rg2__reg_cancel_reason
     * Meta information extracted from the WSDL
     * - documentation: Cancellation Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_cancel_reason = null;
    /**
     * The rg2__reg_exam_result
     * Meta information extracted from the WSDL
     * - documentation: Exam Result. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_exam_result = null;
    /**
     * The rg2__reg_examinee_no
     * Meta information extracted from the WSDL
     * - documentation: Exam ID. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $rg2__reg_examinee_no = null;
    /**
     * The rg2__reg_badge_print_date
     * Meta information extracted from the WSDL
     * - documentation: Badge Print Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_badge_print_date = null;
    /**
     * The rg2__reg_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Registrant. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_reg_key = null;
    /**
     * The rg2__reg_id
     * Meta information extracted from the WSDL
     * - documentation: id. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_id = null;
    /**
     * The rg2__reg_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_odd_key = null;
    /**
     * The rg2__reg_ord_code
     * Meta information extracted from the WSDL
     * - documentation: Order Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_ord_code = null;
    /**
     * The rg2__reg_complimentary_event_registered_flag
     * Meta information extracted from the WSDL
     * - documentation: Complimentary Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_complimentary_event_registered_flag = null;
    /**
     * The rg2__reg_gft_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rg2__reg_gft_key = null;
    /**
     * The rg2__reg_fundraising_goal
     * Meta information extracted from the WSDL
     * - documentation: Fundraising Goal. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $rg2__reg_fundraising_goal = null;
    /**
     * The rg2__reg_guest_flag
     * Meta information extracted from the WSDL
     * - documentation: Is Guest?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_guest_flag = null;
    /**
     * The rg2__reg_time_in
     * Meta information extracted from the WSDL
     * - documentation: Time in. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_time_in = null;
    /**
     * The rg2__reg_time_out
     * Meta information extracted from the WSDL
     * - documentation: Time Out. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_time_out = null;
    /**
     * The rg2__reg_narrative
     * Meta information extracted from the WSDL
     * - documentation: Narrative. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_narrative = null;
    /**
     * The rg2__reg_leaderboard_suppress_flag
     * Meta information extracted from the WSDL
     * - documentation: Suppress Donation Leaderboard. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_leaderboard_suppress_flag = null;
    /**
     * The rg2__reg_leaderboard_suppress_amount
     * Meta information extracted from the WSDL
     * - documentation: Suppress Donation Amount on Leaderboard. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_leaderboard_suppress_amount = null;
    /**
     * The rg2__reg_video_url
     * Meta information extracted from the WSDL
     * - documentation: Video URL. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_video_url = null;
    /**
     * The rg2__reg_waiver_signed_name
     * Meta information extracted from the WSDL
     * - documentation: Waiver Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_waiver_signed_name = null;
    /**
     * The rg2__reg_waiver_signed_date
     * Meta information extracted from the WSDL
     * - documentation: Waiver Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_waiver_signed_date = null;
    /**
     * The rg2__reg_attestation_complete_flag
     * Meta information extracted from the WSDL
     * - documentation: Attestation Complete. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_attestation_complete_flag = null;
    /**
     * The rg2__reg_attestation_type
     * Meta information extracted from the WSDL
     * - documentation: Attestation Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_attestation_type = null;
    /**
     * The rg2__reg_attestation_entered_name
     * Meta information extracted from the WSDL
     * - documentation: Attestation Entered By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rg2__reg_attestation_entered_name = null;
    /**
     * Constructor method for EventsRegistrant_RegistrantGuest_DataObjectType
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_cst_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_egp_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_evt_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_badge_name()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_cxa_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_cph_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_eml_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_cfx_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_url_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_pref_comm_meth()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_rgt_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_on_wait_list_flag()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_confirm_date()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_attendance_flag()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_ada_requirements()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_add_user()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_add_date()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_change_user()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_ivd_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_change_date()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_inv_code()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_delete_flag()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_org_name_dn()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_adr_city()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_key_ext()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_adr_state()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_adr_country()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_adr_intl_province()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_ixo_title_dn()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_src_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_ixo_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_registration_date()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_cancel_date()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_entity_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_cancel_reason()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_exam_result()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_examinee_no()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_badge_print_date()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_reg_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_id()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_odd_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_ord_code()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_complimentary_event_registered_flag()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_gft_key()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_fundraising_goal()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_guest_flag()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_time_in()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_time_out()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_narrative()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_leaderboard_suppress_flag()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_leaderboard_suppress_amount()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_video_url()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_waiver_signed_name()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_waiver_signed_date()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_attestation_complete_flag()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_attestation_type()
     * @uses EventsRegistrant_RegistrantGuest_DataObjectType::setRg2__reg_attestation_entered_name()
     * @param string $rg2__reg_key
     * @param string $rg2__reg_cst_key
     * @param string $rg2__reg_egp_key
     * @param string $rg2__reg_evt_key
     * @param string $rg2__reg_badge_name
     * @param string $rg2__reg_cxa_key
     * @param string $rg2__reg_cph_key
     * @param string $rg2__reg_eml_key
     * @param string $rg2__reg_cfx_key
     * @param string $rg2__reg_url_key
     * @param string $rg2__reg_pref_comm_meth
     * @param string $rg2__reg_rgt_key
     * @param string $rg2__reg_on_wait_list_flag
     * @param string $rg2__reg_confirm_date
     * @param string $rg2__reg_attendance_flag
     * @param string $rg2__reg_ada_requirements
     * @param string $rg2__reg_add_user
     * @param string $rg2__reg_add_date
     * @param string $rg2__reg_change_user
     * @param string $rg2__reg_ivd_key
     * @param string $rg2__reg_change_date
     * @param string $rg2__reg_inv_code
     * @param string $rg2__reg_delete_flag
     * @param string $rg2__reg_org_name_dn
     * @param string $rg2__reg_adr_city
     * @param string $rg2__reg_key_ext
     * @param string $rg2__reg_adr_state
     * @param string $rg2__reg_adr_country
     * @param string $rg2__reg_adr_intl_province
     * @param string $rg2__reg_ixo_title_dn
     * @param string $rg2__reg_src_key
     * @param string $rg2__reg_ixo_key
     * @param string $rg2__reg_registration_date
     * @param string $rg2__reg_cancel_date
     * @param string $rg2__reg_entity_key
     * @param string $rg2__reg_cancel_reason
     * @param string $rg2__reg_exam_result
     * @param int $rg2__reg_examinee_no
     * @param string $rg2__reg_badge_print_date
     * @param string $rg2__reg_reg_key
     * @param string $rg2__reg_id
     * @param string $rg2__reg_odd_key
     * @param string $rg2__reg_ord_code
     * @param string $rg2__reg_complimentary_event_registered_flag
     * @param string $rg2__reg_gft_key
     * @param float $rg2__reg_fundraising_goal
     * @param string $rg2__reg_guest_flag
     * @param string $rg2__reg_time_in
     * @param string $rg2__reg_time_out
     * @param string $rg2__reg_narrative
     * @param string $rg2__reg_leaderboard_suppress_flag
     * @param string $rg2__reg_leaderboard_suppress_amount
     * @param string $rg2__reg_video_url
     * @param string $rg2__reg_waiver_signed_name
     * @param string $rg2__reg_waiver_signed_date
     * @param string $rg2__reg_attestation_complete_flag
     * @param string $rg2__reg_attestation_type
     * @param string $rg2__reg_attestation_entered_name
     */
    public function __construct(?string $rg2__reg_key = null, ?string $rg2__reg_cst_key = null, ?string $rg2__reg_egp_key = null, ?string $rg2__reg_evt_key = null, ?string $rg2__reg_badge_name = null, ?string $rg2__reg_cxa_key = null, ?string $rg2__reg_cph_key = null, ?string $rg2__reg_eml_key = null, ?string $rg2__reg_cfx_key = null, ?string $rg2__reg_url_key = null, ?string $rg2__reg_pref_comm_meth = null, ?string $rg2__reg_rgt_key = null, ?string $rg2__reg_on_wait_list_flag = null, ?string $rg2__reg_confirm_date = null, ?string $rg2__reg_attendance_flag = null, ?string $rg2__reg_ada_requirements = null, ?string $rg2__reg_add_user = null, ?string $rg2__reg_add_date = null, ?string $rg2__reg_change_user = null, ?string $rg2__reg_ivd_key = null, ?string $rg2__reg_change_date = null, ?string $rg2__reg_inv_code = null, ?string $rg2__reg_delete_flag = null, ?string $rg2__reg_org_name_dn = null, ?string $rg2__reg_adr_city = null, ?string $rg2__reg_key_ext = null, ?string $rg2__reg_adr_state = null, ?string $rg2__reg_adr_country = null, ?string $rg2__reg_adr_intl_province = null, ?string $rg2__reg_ixo_title_dn = null, ?string $rg2__reg_src_key = null, ?string $rg2__reg_ixo_key = null, ?string $rg2__reg_registration_date = null, ?string $rg2__reg_cancel_date = null, ?string $rg2__reg_entity_key = null, ?string $rg2__reg_cancel_reason = null, ?string $rg2__reg_exam_result = null, ?int $rg2__reg_examinee_no = null, ?string $rg2__reg_badge_print_date = null, ?string $rg2__reg_reg_key = null, ?string $rg2__reg_id = null, ?string $rg2__reg_odd_key = null, ?string $rg2__reg_ord_code = null, ?string $rg2__reg_complimentary_event_registered_flag = null, ?string $rg2__reg_gft_key = null, ?float $rg2__reg_fundraising_goal = null, ?string $rg2__reg_guest_flag = null, ?string $rg2__reg_time_in = null, ?string $rg2__reg_time_out = null, ?string $rg2__reg_narrative = null, ?string $rg2__reg_leaderboard_suppress_flag = null, ?string $rg2__reg_leaderboard_suppress_amount = null, ?string $rg2__reg_video_url = null, ?string $rg2__reg_waiver_signed_name = null, ?string $rg2__reg_waiver_signed_date = null, ?string $rg2__reg_attestation_complete_flag = null, ?string $rg2__reg_attestation_type = null, ?string $rg2__reg_attestation_entered_name = null)
    {
        $this
            ->setRg2__reg_key($rg2__reg_key)
            ->setRg2__reg_cst_key($rg2__reg_cst_key)
            ->setRg2__reg_egp_key($rg2__reg_egp_key)
            ->setRg2__reg_evt_key($rg2__reg_evt_key)
            ->setRg2__reg_badge_name($rg2__reg_badge_name)
            ->setRg2__reg_cxa_key($rg2__reg_cxa_key)
            ->setRg2__reg_cph_key($rg2__reg_cph_key)
            ->setRg2__reg_eml_key($rg2__reg_eml_key)
            ->setRg2__reg_cfx_key($rg2__reg_cfx_key)
            ->setRg2__reg_url_key($rg2__reg_url_key)
            ->setRg2__reg_pref_comm_meth($rg2__reg_pref_comm_meth)
            ->setRg2__reg_rgt_key($rg2__reg_rgt_key)
            ->setRg2__reg_on_wait_list_flag($rg2__reg_on_wait_list_flag)
            ->setRg2__reg_confirm_date($rg2__reg_confirm_date)
            ->setRg2__reg_attendance_flag($rg2__reg_attendance_flag)
            ->setRg2__reg_ada_requirements($rg2__reg_ada_requirements)
            ->setRg2__reg_add_user($rg2__reg_add_user)
            ->setRg2__reg_add_date($rg2__reg_add_date)
            ->setRg2__reg_change_user($rg2__reg_change_user)
            ->setRg2__reg_ivd_key($rg2__reg_ivd_key)
            ->setRg2__reg_change_date($rg2__reg_change_date)
            ->setRg2__reg_inv_code($rg2__reg_inv_code)
            ->setRg2__reg_delete_flag($rg2__reg_delete_flag)
            ->setRg2__reg_org_name_dn($rg2__reg_org_name_dn)
            ->setRg2__reg_adr_city($rg2__reg_adr_city)
            ->setRg2__reg_key_ext($rg2__reg_key_ext)
            ->setRg2__reg_adr_state($rg2__reg_adr_state)
            ->setRg2__reg_adr_country($rg2__reg_adr_country)
            ->setRg2__reg_adr_intl_province($rg2__reg_adr_intl_province)
            ->setRg2__reg_ixo_title_dn($rg2__reg_ixo_title_dn)
            ->setRg2__reg_src_key($rg2__reg_src_key)
            ->setRg2__reg_ixo_key($rg2__reg_ixo_key)
            ->setRg2__reg_registration_date($rg2__reg_registration_date)
            ->setRg2__reg_cancel_date($rg2__reg_cancel_date)
            ->setRg2__reg_entity_key($rg2__reg_entity_key)
            ->setRg2__reg_cancel_reason($rg2__reg_cancel_reason)
            ->setRg2__reg_exam_result($rg2__reg_exam_result)
            ->setRg2__reg_examinee_no($rg2__reg_examinee_no)
            ->setRg2__reg_badge_print_date($rg2__reg_badge_print_date)
            ->setRg2__reg_reg_key($rg2__reg_reg_key)
            ->setRg2__reg_id($rg2__reg_id)
            ->setRg2__reg_odd_key($rg2__reg_odd_key)
            ->setRg2__reg_ord_code($rg2__reg_ord_code)
            ->setRg2__reg_complimentary_event_registered_flag($rg2__reg_complimentary_event_registered_flag)
            ->setRg2__reg_gft_key($rg2__reg_gft_key)
            ->setRg2__reg_fundraising_goal($rg2__reg_fundraising_goal)
            ->setRg2__reg_guest_flag($rg2__reg_guest_flag)
            ->setRg2__reg_time_in($rg2__reg_time_in)
            ->setRg2__reg_time_out($rg2__reg_time_out)
            ->setRg2__reg_narrative($rg2__reg_narrative)
            ->setRg2__reg_leaderboard_suppress_flag($rg2__reg_leaderboard_suppress_flag)
            ->setRg2__reg_leaderboard_suppress_amount($rg2__reg_leaderboard_suppress_amount)
            ->setRg2__reg_video_url($rg2__reg_video_url)
            ->setRg2__reg_waiver_signed_name($rg2__reg_waiver_signed_name)
            ->setRg2__reg_waiver_signed_date($rg2__reg_waiver_signed_date)
            ->setRg2__reg_attestation_complete_flag($rg2__reg_attestation_complete_flag)
            ->setRg2__reg_attestation_type($rg2__reg_attestation_type)
            ->setRg2__reg_attestation_entered_name($rg2__reg_attestation_entered_name);
    }
    /**
     * Get rg2__reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_key(): ?string
    {
        return $this->rg2__reg_key ?? null;
    }
    /**
     * Set rg2__reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_key(?string $rg2__reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_key) && !is_string($rg2__reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_key, true), gettype($rg2__reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_key) || (is_array($rg2__reg_key) && empty($rg2__reg_key))) {
            unset($this->rg2__reg_key);
        } else {
            $this->rg2__reg_key = $rg2__reg_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_cst_key(): ?string
    {
        return $this->rg2__reg_cst_key ?? null;
    }
    /**
     * Set rg2__reg_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_cst_key(?string $rg2__reg_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_cst_key) && !is_string($rg2__reg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_cst_key, true), gettype($rg2__reg_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_cst_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_cst_key) || (is_array($rg2__reg_cst_key) && empty($rg2__reg_cst_key))) {
            unset($this->rg2__reg_cst_key);
        } else {
            $this->rg2__reg_cst_key = $rg2__reg_cst_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_egp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_egp_key(): ?string
    {
        return $this->rg2__reg_egp_key ?? null;
    }
    /**
     * Set rg2__reg_egp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_egp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_egp_key(?string $rg2__reg_egp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_egp_key) && !is_string($rg2__reg_egp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_egp_key, true), gettype($rg2__reg_egp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_egp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_egp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_egp_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_egp_key) || (is_array($rg2__reg_egp_key) && empty($rg2__reg_egp_key))) {
            unset($this->rg2__reg_egp_key);
        } else {
            $this->rg2__reg_egp_key = $rg2__reg_egp_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_evt_key(): ?string
    {
        return $this->rg2__reg_evt_key ?? null;
    }
    /**
     * Set rg2__reg_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_evt_key(?string $rg2__reg_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_evt_key) && !is_string($rg2__reg_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_evt_key, true), gettype($rg2__reg_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_evt_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_evt_key) || (is_array($rg2__reg_evt_key) && empty($rg2__reg_evt_key))) {
            unset($this->rg2__reg_evt_key);
        } else {
            $this->rg2__reg_evt_key = $rg2__reg_evt_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_badge_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_badge_name(): ?string
    {
        return $this->rg2__reg_badge_name ?? null;
    }
    /**
     * Set rg2__reg_badge_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_badge_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_badge_name(?string $rg2__reg_badge_name = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_badge_name) && !is_string($rg2__reg_badge_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_badge_name, true), gettype($rg2__reg_badge_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($rg2__reg_badge_name) && mb_strlen((string) $rg2__reg_badge_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $rg2__reg_badge_name)), __LINE__);
        }
        if (is_null($rg2__reg_badge_name) || (is_array($rg2__reg_badge_name) && empty($rg2__reg_badge_name))) {
            unset($this->rg2__reg_badge_name);
        } else {
            $this->rg2__reg_badge_name = $rg2__reg_badge_name;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_cxa_key(): ?string
    {
        return $this->rg2__reg_cxa_key ?? null;
    }
    /**
     * Set rg2__reg_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_cxa_key(?string $rg2__reg_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_cxa_key) && !is_string($rg2__reg_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_cxa_key, true), gettype($rg2__reg_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_cxa_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_cxa_key) || (is_array($rg2__reg_cxa_key) && empty($rg2__reg_cxa_key))) {
            unset($this->rg2__reg_cxa_key);
        } else {
            $this->rg2__reg_cxa_key = $rg2__reg_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_cph_key(): ?string
    {
        return $this->rg2__reg_cph_key ?? null;
    }
    /**
     * Set rg2__reg_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_cph_key(?string $rg2__reg_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_cph_key) && !is_string($rg2__reg_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_cph_key, true), gettype($rg2__reg_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_cph_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_cph_key) || (is_array($rg2__reg_cph_key) && empty($rg2__reg_cph_key))) {
            unset($this->rg2__reg_cph_key);
        } else {
            $this->rg2__reg_cph_key = $rg2__reg_cph_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_eml_key(): ?string
    {
        return $this->rg2__reg_eml_key ?? null;
    }
    /**
     * Set rg2__reg_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_eml_key(?string $rg2__reg_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_eml_key) && !is_string($rg2__reg_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_eml_key, true), gettype($rg2__reg_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_eml_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_eml_key) || (is_array($rg2__reg_eml_key) && empty($rg2__reg_eml_key))) {
            unset($this->rg2__reg_eml_key);
        } else {
            $this->rg2__reg_eml_key = $rg2__reg_eml_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_cfx_key(): ?string
    {
        return $this->rg2__reg_cfx_key ?? null;
    }
    /**
     * Set rg2__reg_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_cfx_key(?string $rg2__reg_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_cfx_key) && !is_string($rg2__reg_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_cfx_key, true), gettype($rg2__reg_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_cfx_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_cfx_key) || (is_array($rg2__reg_cfx_key) && empty($rg2__reg_cfx_key))) {
            unset($this->rg2__reg_cfx_key);
        } else {
            $this->rg2__reg_cfx_key = $rg2__reg_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_url_key(): ?string
    {
        return $this->rg2__reg_url_key ?? null;
    }
    /**
     * Set rg2__reg_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_url_key(?string $rg2__reg_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_url_key) && !is_string($rg2__reg_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_url_key, true), gettype($rg2__reg_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_url_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_url_key) || (is_array($rg2__reg_url_key) && empty($rg2__reg_url_key))) {
            unset($this->rg2__reg_url_key);
        } else {
            $this->rg2__reg_url_key = $rg2__reg_url_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_pref_comm_meth(): ?string
    {
        return $this->rg2__reg_pref_comm_meth ?? null;
    }
    /**
     * Set rg2__reg_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_pref_comm_meth(?string $rg2__reg_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_pref_comm_meth) && !is_string($rg2__reg_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_pref_comm_meth, true), gettype($rg2__reg_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($rg2__reg_pref_comm_meth) && mb_strlen((string) $rg2__reg_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $rg2__reg_pref_comm_meth)), __LINE__);
        }
        if (is_null($rg2__reg_pref_comm_meth) || (is_array($rg2__reg_pref_comm_meth) && empty($rg2__reg_pref_comm_meth))) {
            unset($this->rg2__reg_pref_comm_meth);
        } else {
            $this->rg2__reg_pref_comm_meth = $rg2__reg_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_rgt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_rgt_key(): ?string
    {
        return $this->rg2__reg_rgt_key ?? null;
    }
    /**
     * Set rg2__reg_rgt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_rgt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_rgt_key(?string $rg2__reg_rgt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_rgt_key) && !is_string($rg2__reg_rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_rgt_key, true), gettype($rg2__reg_rgt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_rgt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_rgt_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_rgt_key) || (is_array($rg2__reg_rgt_key) && empty($rg2__reg_rgt_key))) {
            unset($this->rg2__reg_rgt_key);
        } else {
            $this->rg2__reg_rgt_key = $rg2__reg_rgt_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_on_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_on_wait_list_flag(): ?string
    {
        return $this->rg2__reg_on_wait_list_flag ?? null;
    }
    /**
     * Set rg2__reg_on_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_on_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_on_wait_list_flag(?string $rg2__reg_on_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_on_wait_list_flag) && !is_string($rg2__reg_on_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_on_wait_list_flag, true), gettype($rg2__reg_on_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rg2__reg_on_wait_list_flag) && $rg2__reg_on_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rg2__reg_on_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rg2__reg_on_wait_list_flag) && $rg2__reg_on_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rg2__reg_on_wait_list_flag, true)), __LINE__);
        }
        if (is_null($rg2__reg_on_wait_list_flag) || (is_array($rg2__reg_on_wait_list_flag) && empty($rg2__reg_on_wait_list_flag))) {
            unset($this->rg2__reg_on_wait_list_flag);
        } else {
            $this->rg2__reg_on_wait_list_flag = $rg2__reg_on_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_confirm_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_confirm_date(): ?string
    {
        return $this->rg2__reg_confirm_date ?? null;
    }
    /**
     * Set rg2__reg_confirm_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_confirm_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_confirm_date(?string $rg2__reg_confirm_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_confirm_date) && !is_string($rg2__reg_confirm_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_confirm_date, true), gettype($rg2__reg_confirm_date)), __LINE__);
        }
        if (is_null($rg2__reg_confirm_date) || (is_array($rg2__reg_confirm_date) && empty($rg2__reg_confirm_date))) {
            unset($this->rg2__reg_confirm_date);
        } else {
            $this->rg2__reg_confirm_date = $rg2__reg_confirm_date;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_attendance_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_attendance_flag(): ?string
    {
        return $this->rg2__reg_attendance_flag ?? null;
    }
    /**
     * Set rg2__reg_attendance_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_attendance_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_attendance_flag(?string $rg2__reg_attendance_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_attendance_flag) && !is_string($rg2__reg_attendance_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_attendance_flag, true), gettype($rg2__reg_attendance_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rg2__reg_attendance_flag) && $rg2__reg_attendance_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rg2__reg_attendance_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rg2__reg_attendance_flag) && $rg2__reg_attendance_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rg2__reg_attendance_flag, true)), __LINE__);
        }
        if (is_null($rg2__reg_attendance_flag) || (is_array($rg2__reg_attendance_flag) && empty($rg2__reg_attendance_flag))) {
            unset($this->rg2__reg_attendance_flag);
        } else {
            $this->rg2__reg_attendance_flag = $rg2__reg_attendance_flag;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_ada_requirements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_ada_requirements(): ?string
    {
        return $this->rg2__reg_ada_requirements ?? null;
    }
    /**
     * Set rg2__reg_ada_requirements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_ada_requirements
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_ada_requirements(?string $rg2__reg_ada_requirements = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_ada_requirements) && !is_string($rg2__reg_ada_requirements)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_ada_requirements, true), gettype($rg2__reg_ada_requirements)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($rg2__reg_ada_requirements) && mb_strlen((string) $rg2__reg_ada_requirements) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $rg2__reg_ada_requirements)), __LINE__);
        }
        if (is_null($rg2__reg_ada_requirements) || (is_array($rg2__reg_ada_requirements) && empty($rg2__reg_ada_requirements))) {
            unset($this->rg2__reg_ada_requirements);
        } else {
            $this->rg2__reg_ada_requirements = $rg2__reg_ada_requirements;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_add_user(): ?string
    {
        return $this->rg2__reg_add_user ?? null;
    }
    /**
     * Set rg2__reg_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_add_user(?string $rg2__reg_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_add_user) && !is_string($rg2__reg_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_add_user, true), gettype($rg2__reg_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rg2__reg_add_user) && mb_strlen((string) $rg2__reg_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $rg2__reg_add_user)), __LINE__);
        }
        if (is_null($rg2__reg_add_user) || (is_array($rg2__reg_add_user) && empty($rg2__reg_add_user))) {
            unset($this->rg2__reg_add_user);
        } else {
            $this->rg2__reg_add_user = $rg2__reg_add_user;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_add_date(): ?string
    {
        return $this->rg2__reg_add_date ?? null;
    }
    /**
     * Set rg2__reg_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_add_date(?string $rg2__reg_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_add_date) && !is_string($rg2__reg_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_add_date, true), gettype($rg2__reg_add_date)), __LINE__);
        }
        if (is_null($rg2__reg_add_date) || (is_array($rg2__reg_add_date) && empty($rg2__reg_add_date))) {
            unset($this->rg2__reg_add_date);
        } else {
            $this->rg2__reg_add_date = $rg2__reg_add_date;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_change_user(): ?string
    {
        return $this->rg2__reg_change_user ?? null;
    }
    /**
     * Set rg2__reg_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_change_user(?string $rg2__reg_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_change_user) && !is_string($rg2__reg_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_change_user, true), gettype($rg2__reg_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rg2__reg_change_user) && mb_strlen((string) $rg2__reg_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $rg2__reg_change_user)), __LINE__);
        }
        if (is_null($rg2__reg_change_user) || (is_array($rg2__reg_change_user) && empty($rg2__reg_change_user))) {
            unset($this->rg2__reg_change_user);
        } else {
            $this->rg2__reg_change_user = $rg2__reg_change_user;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_ivd_key(): ?string
    {
        return $this->rg2__reg_ivd_key ?? null;
    }
    /**
     * Set rg2__reg_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_ivd_key(?string $rg2__reg_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_ivd_key) && !is_string($rg2__reg_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_ivd_key, true), gettype($rg2__reg_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_ivd_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_ivd_key) || (is_array($rg2__reg_ivd_key) && empty($rg2__reg_ivd_key))) {
            unset($this->rg2__reg_ivd_key);
        } else {
            $this->rg2__reg_ivd_key = $rg2__reg_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_change_date(): ?string
    {
        return $this->rg2__reg_change_date ?? null;
    }
    /**
     * Set rg2__reg_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_change_date(?string $rg2__reg_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_change_date) && !is_string($rg2__reg_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_change_date, true), gettype($rg2__reg_change_date)), __LINE__);
        }
        if (is_null($rg2__reg_change_date) || (is_array($rg2__reg_change_date) && empty($rg2__reg_change_date))) {
            unset($this->rg2__reg_change_date);
        } else {
            $this->rg2__reg_change_date = $rg2__reg_change_date;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_inv_code(): ?string
    {
        return $this->rg2__reg_inv_code ?? null;
    }
    /**
     * Set rg2__reg_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_inv_code(?string $rg2__reg_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_inv_code) && !is_string($rg2__reg_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_inv_code, true), gettype($rg2__reg_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($rg2__reg_inv_code) && mb_strlen((string) $rg2__reg_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $rg2__reg_inv_code)), __LINE__);
        }
        if (is_null($rg2__reg_inv_code) || (is_array($rg2__reg_inv_code) && empty($rg2__reg_inv_code))) {
            unset($this->rg2__reg_inv_code);
        } else {
            $this->rg2__reg_inv_code = $rg2__reg_inv_code;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_delete_flag(): ?string
    {
        return $this->rg2__reg_delete_flag ?? null;
    }
    /**
     * Set rg2__reg_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_delete_flag(?string $rg2__reg_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_delete_flag) && !is_string($rg2__reg_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_delete_flag, true), gettype($rg2__reg_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rg2__reg_delete_flag) && $rg2__reg_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rg2__reg_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rg2__reg_delete_flag) && $rg2__reg_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rg2__reg_delete_flag, true)), __LINE__);
        }
        if (is_null($rg2__reg_delete_flag) || (is_array($rg2__reg_delete_flag) && empty($rg2__reg_delete_flag))) {
            unset($this->rg2__reg_delete_flag);
        } else {
            $this->rg2__reg_delete_flag = $rg2__reg_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_org_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_org_name_dn(): ?string
    {
        return $this->rg2__reg_org_name_dn ?? null;
    }
    /**
     * Set rg2__reg_org_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_org_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_org_name_dn(?string $rg2__reg_org_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_org_name_dn) && !is_string($rg2__reg_org_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_org_name_dn, true), gettype($rg2__reg_org_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($rg2__reg_org_name_dn) && mb_strlen((string) $rg2__reg_org_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $rg2__reg_org_name_dn)), __LINE__);
        }
        if (is_null($rg2__reg_org_name_dn) || (is_array($rg2__reg_org_name_dn) && empty($rg2__reg_org_name_dn))) {
            unset($this->rg2__reg_org_name_dn);
        } else {
            $this->rg2__reg_org_name_dn = $rg2__reg_org_name_dn;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_adr_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_adr_city(): ?string
    {
        return $this->rg2__reg_adr_city ?? null;
    }
    /**
     * Set rg2__reg_adr_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_adr_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_adr_city(?string $rg2__reg_adr_city = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_adr_city) && !is_string($rg2__reg_adr_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_adr_city, true), gettype($rg2__reg_adr_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($rg2__reg_adr_city) && mb_strlen((string) $rg2__reg_adr_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $rg2__reg_adr_city)), __LINE__);
        }
        if (is_null($rg2__reg_adr_city) || (is_array($rg2__reg_adr_city) && empty($rg2__reg_adr_city))) {
            unset($this->rg2__reg_adr_city);
        } else {
            $this->rg2__reg_adr_city = $rg2__reg_adr_city;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_key_ext(): ?string
    {
        return $this->rg2__reg_key_ext ?? null;
    }
    /**
     * Set rg2__reg_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_key_ext(?string $rg2__reg_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_key_ext) && !is_string($rg2__reg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_key_ext, true), gettype($rg2__reg_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_key_ext, true)), __LINE__);
        }
        if (is_null($rg2__reg_key_ext) || (is_array($rg2__reg_key_ext) && empty($rg2__reg_key_ext))) {
            unset($this->rg2__reg_key_ext);
        } else {
            $this->rg2__reg_key_ext = $rg2__reg_key_ext;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_adr_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_adr_state(): ?string
    {
        return $this->rg2__reg_adr_state ?? null;
    }
    /**
     * Set rg2__reg_adr_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_adr_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_adr_state(?string $rg2__reg_adr_state = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_adr_state) && !is_string($rg2__reg_adr_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_adr_state, true), gettype($rg2__reg_adr_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($rg2__reg_adr_state) && mb_strlen((string) $rg2__reg_adr_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $rg2__reg_adr_state)), __LINE__);
        }
        if (is_null($rg2__reg_adr_state) || (is_array($rg2__reg_adr_state) && empty($rg2__reg_adr_state))) {
            unset($this->rg2__reg_adr_state);
        } else {
            $this->rg2__reg_adr_state = $rg2__reg_adr_state;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_adr_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_adr_country(): ?string
    {
        return $this->rg2__reg_adr_country ?? null;
    }
    /**
     * Set rg2__reg_adr_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_adr_country
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_adr_country(?string $rg2__reg_adr_country = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_adr_country) && !is_string($rg2__reg_adr_country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_adr_country, true), gettype($rg2__reg_adr_country)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($rg2__reg_adr_country) && mb_strlen((string) $rg2__reg_adr_country) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $rg2__reg_adr_country)), __LINE__);
        }
        if (is_null($rg2__reg_adr_country) || (is_array($rg2__reg_adr_country) && empty($rg2__reg_adr_country))) {
            unset($this->rg2__reg_adr_country);
        } else {
            $this->rg2__reg_adr_country = $rg2__reg_adr_country;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_adr_intl_province value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_adr_intl_province(): ?string
    {
        return $this->rg2__reg_adr_intl_province ?? null;
    }
    /**
     * Set rg2__reg_adr_intl_province value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_adr_intl_province
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_adr_intl_province(?string $rg2__reg_adr_intl_province = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_adr_intl_province) && !is_string($rg2__reg_adr_intl_province)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_adr_intl_province, true), gettype($rg2__reg_adr_intl_province)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($rg2__reg_adr_intl_province) && mb_strlen((string) $rg2__reg_adr_intl_province) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $rg2__reg_adr_intl_province)), __LINE__);
        }
        if (is_null($rg2__reg_adr_intl_province) || (is_array($rg2__reg_adr_intl_province) && empty($rg2__reg_adr_intl_province))) {
            unset($this->rg2__reg_adr_intl_province);
        } else {
            $this->rg2__reg_adr_intl_province = $rg2__reg_adr_intl_province;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_ixo_title_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_ixo_title_dn(): ?string
    {
        return $this->rg2__reg_ixo_title_dn ?? null;
    }
    /**
     * Set rg2__reg_ixo_title_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_ixo_title_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_ixo_title_dn(?string $rg2__reg_ixo_title_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_ixo_title_dn) && !is_string($rg2__reg_ixo_title_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_ixo_title_dn, true), gettype($rg2__reg_ixo_title_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($rg2__reg_ixo_title_dn) && mb_strlen((string) $rg2__reg_ixo_title_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $rg2__reg_ixo_title_dn)), __LINE__);
        }
        if (is_null($rg2__reg_ixo_title_dn) || (is_array($rg2__reg_ixo_title_dn) && empty($rg2__reg_ixo_title_dn))) {
            unset($this->rg2__reg_ixo_title_dn);
        } else {
            $this->rg2__reg_ixo_title_dn = $rg2__reg_ixo_title_dn;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_src_key(): ?string
    {
        return $this->rg2__reg_src_key ?? null;
    }
    /**
     * Set rg2__reg_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_src_key(?string $rg2__reg_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_src_key) && !is_string($rg2__reg_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_src_key, true), gettype($rg2__reg_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_src_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_src_key) || (is_array($rg2__reg_src_key) && empty($rg2__reg_src_key))) {
            unset($this->rg2__reg_src_key);
        } else {
            $this->rg2__reg_src_key = $rg2__reg_src_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_ixo_key(): ?string
    {
        return $this->rg2__reg_ixo_key ?? null;
    }
    /**
     * Set rg2__reg_ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_ixo_key(?string $rg2__reg_ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_ixo_key) && !is_string($rg2__reg_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_ixo_key, true), gettype($rg2__reg_ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_ixo_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_ixo_key) || (is_array($rg2__reg_ixo_key) && empty($rg2__reg_ixo_key))) {
            unset($this->rg2__reg_ixo_key);
        } else {
            $this->rg2__reg_ixo_key = $rg2__reg_ixo_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_registration_date(): ?string
    {
        return $this->rg2__reg_registration_date ?? null;
    }
    /**
     * Set rg2__reg_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_registration_date(?string $rg2__reg_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_registration_date) && !is_string($rg2__reg_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_registration_date, true), gettype($rg2__reg_registration_date)), __LINE__);
        }
        if (is_null($rg2__reg_registration_date) || (is_array($rg2__reg_registration_date) && empty($rg2__reg_registration_date))) {
            unset($this->rg2__reg_registration_date);
        } else {
            $this->rg2__reg_registration_date = $rg2__reg_registration_date;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_cancel_date(): ?string
    {
        return $this->rg2__reg_cancel_date ?? null;
    }
    /**
     * Set rg2__reg_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_cancel_date(?string $rg2__reg_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_cancel_date) && !is_string($rg2__reg_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_cancel_date, true), gettype($rg2__reg_cancel_date)), __LINE__);
        }
        if (is_null($rg2__reg_cancel_date) || (is_array($rg2__reg_cancel_date) && empty($rg2__reg_cancel_date))) {
            unset($this->rg2__reg_cancel_date);
        } else {
            $this->rg2__reg_cancel_date = $rg2__reg_cancel_date;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_entity_key(): ?string
    {
        return $this->rg2__reg_entity_key ?? null;
    }
    /**
     * Set rg2__reg_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_entity_key(?string $rg2__reg_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_entity_key) && !is_string($rg2__reg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_entity_key, true), gettype($rg2__reg_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_entity_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_entity_key) || (is_array($rg2__reg_entity_key) && empty($rg2__reg_entity_key))) {
            unset($this->rg2__reg_entity_key);
        } else {
            $this->rg2__reg_entity_key = $rg2__reg_entity_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_cancel_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_cancel_reason(): ?string
    {
        return $this->rg2__reg_cancel_reason ?? null;
    }
    /**
     * Set rg2__reg_cancel_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_cancel_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_cancel_reason(?string $rg2__reg_cancel_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_cancel_reason) && !is_string($rg2__reg_cancel_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_cancel_reason, true), gettype($rg2__reg_cancel_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($rg2__reg_cancel_reason) && mb_strlen((string) $rg2__reg_cancel_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $rg2__reg_cancel_reason)), __LINE__);
        }
        if (is_null($rg2__reg_cancel_reason) || (is_array($rg2__reg_cancel_reason) && empty($rg2__reg_cancel_reason))) {
            unset($this->rg2__reg_cancel_reason);
        } else {
            $this->rg2__reg_cancel_reason = $rg2__reg_cancel_reason;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_exam_result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_exam_result(): ?string
    {
        return $this->rg2__reg_exam_result ?? null;
    }
    /**
     * Set rg2__reg_exam_result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_exam_result
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_exam_result(?string $rg2__reg_exam_result = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_exam_result) && !is_string($rg2__reg_exam_result)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_exam_result, true), gettype($rg2__reg_exam_result)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($rg2__reg_exam_result) && mb_strlen((string) $rg2__reg_exam_result) > 7) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen((string) $rg2__reg_exam_result)), __LINE__);
        }
        if (is_null($rg2__reg_exam_result) || (is_array($rg2__reg_exam_result) && empty($rg2__reg_exam_result))) {
            unset($this->rg2__reg_exam_result);
        } else {
            $this->rg2__reg_exam_result = $rg2__reg_exam_result;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_examinee_no value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRg2__reg_examinee_no(): ?int
    {
        return $this->rg2__reg_examinee_no ?? null;
    }
    /**
     * Set rg2__reg_examinee_no value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rg2__reg_examinee_no
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_examinee_no(?int $rg2__reg_examinee_no = null): self
    {
        // validation for constraint: int
        if (!is_null($rg2__reg_examinee_no) && !(is_int($rg2__reg_examinee_no) || ctype_digit($rg2__reg_examinee_no))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rg2__reg_examinee_no, true), gettype($rg2__reg_examinee_no)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($rg2__reg_examinee_no) && $rg2__reg_examinee_no > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($rg2__reg_examinee_no, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($rg2__reg_examinee_no) && $rg2__reg_examinee_no < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($rg2__reg_examinee_no, true)), __LINE__);
        }
        if (is_null($rg2__reg_examinee_no) || (is_array($rg2__reg_examinee_no) && empty($rg2__reg_examinee_no))) {
            unset($this->rg2__reg_examinee_no);
        } else {
            $this->rg2__reg_examinee_no = $rg2__reg_examinee_no;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_badge_print_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_badge_print_date(): ?string
    {
        return $this->rg2__reg_badge_print_date ?? null;
    }
    /**
     * Set rg2__reg_badge_print_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_badge_print_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_badge_print_date(?string $rg2__reg_badge_print_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_badge_print_date) && !is_string($rg2__reg_badge_print_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_badge_print_date, true), gettype($rg2__reg_badge_print_date)), __LINE__);
        }
        if (is_null($rg2__reg_badge_print_date) || (is_array($rg2__reg_badge_print_date) && empty($rg2__reg_badge_print_date))) {
            unset($this->rg2__reg_badge_print_date);
        } else {
            $this->rg2__reg_badge_print_date = $rg2__reg_badge_print_date;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_reg_key(): ?string
    {
        return $this->rg2__reg_reg_key ?? null;
    }
    /**
     * Set rg2__reg_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_reg_key(?string $rg2__reg_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_reg_key) && !is_string($rg2__reg_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_reg_key, true), gettype($rg2__reg_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_reg_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_reg_key) || (is_array($rg2__reg_reg_key) && empty($rg2__reg_reg_key))) {
            unset($this->rg2__reg_reg_key);
        } else {
            $this->rg2__reg_reg_key = $rg2__reg_reg_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_id(): ?string
    {
        return $this->rg2__reg_id ?? null;
    }
    /**
     * Set rg2__reg_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_id(?string $rg2__reg_id = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_id) && !is_string($rg2__reg_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_id, true), gettype($rg2__reg_id)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($rg2__reg_id) && mb_strlen((string) $rg2__reg_id) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $rg2__reg_id)), __LINE__);
        }
        if (is_null($rg2__reg_id) || (is_array($rg2__reg_id) && empty($rg2__reg_id))) {
            unset($this->rg2__reg_id);
        } else {
            $this->rg2__reg_id = $rg2__reg_id;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_odd_key(): ?string
    {
        return $this->rg2__reg_odd_key ?? null;
    }
    /**
     * Set rg2__reg_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_odd_key(?string $rg2__reg_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_odd_key) && !is_string($rg2__reg_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_odd_key, true), gettype($rg2__reg_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_odd_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_odd_key) || (is_array($rg2__reg_odd_key) && empty($rg2__reg_odd_key))) {
            unset($this->rg2__reg_odd_key);
        } else {
            $this->rg2__reg_odd_key = $rg2__reg_odd_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_ord_code(): ?string
    {
        return $this->rg2__reg_ord_code ?? null;
    }
    /**
     * Set rg2__reg_ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_ord_code(?string $rg2__reg_ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_ord_code) && !is_string($rg2__reg_ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_ord_code, true), gettype($rg2__reg_ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($rg2__reg_ord_code) && mb_strlen((string) $rg2__reg_ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $rg2__reg_ord_code)), __LINE__);
        }
        if (is_null($rg2__reg_ord_code) || (is_array($rg2__reg_ord_code) && empty($rg2__reg_ord_code))) {
            unset($this->rg2__reg_ord_code);
        } else {
            $this->rg2__reg_ord_code = $rg2__reg_ord_code;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_complimentary_event_registered_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_complimentary_event_registered_flag(): ?string
    {
        return $this->rg2__reg_complimentary_event_registered_flag ?? null;
    }
    /**
     * Set rg2__reg_complimentary_event_registered_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_complimentary_event_registered_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_complimentary_event_registered_flag(?string $rg2__reg_complimentary_event_registered_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_complimentary_event_registered_flag) && !is_string($rg2__reg_complimentary_event_registered_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_complimentary_event_registered_flag, true), gettype($rg2__reg_complimentary_event_registered_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rg2__reg_complimentary_event_registered_flag) && $rg2__reg_complimentary_event_registered_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rg2__reg_complimentary_event_registered_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rg2__reg_complimentary_event_registered_flag) && $rg2__reg_complimentary_event_registered_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rg2__reg_complimentary_event_registered_flag, true)), __LINE__);
        }
        if (is_null($rg2__reg_complimentary_event_registered_flag) || (is_array($rg2__reg_complimentary_event_registered_flag) && empty($rg2__reg_complimentary_event_registered_flag))) {
            unset($this->rg2__reg_complimentary_event_registered_flag);
        } else {
            $this->rg2__reg_complimentary_event_registered_flag = $rg2__reg_complimentary_event_registered_flag;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_gft_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_gft_key(): ?string
    {
        return $this->rg2__reg_gft_key ?? null;
    }
    /**
     * Set rg2__reg_gft_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_gft_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_gft_key(?string $rg2__reg_gft_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_gft_key) && !is_string($rg2__reg_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_gft_key, true), gettype($rg2__reg_gft_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rg2__reg_gft_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rg2__reg_gft_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rg2__reg_gft_key, true)), __LINE__);
        }
        if (is_null($rg2__reg_gft_key) || (is_array($rg2__reg_gft_key) && empty($rg2__reg_gft_key))) {
            unset($this->rg2__reg_gft_key);
        } else {
            $this->rg2__reg_gft_key = $rg2__reg_gft_key;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_fundraising_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRg2__reg_fundraising_goal(): ?float
    {
        return $this->rg2__reg_fundraising_goal ?? null;
    }
    /**
     * Set rg2__reg_fundraising_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $rg2__reg_fundraising_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_fundraising_goal(?float $rg2__reg_fundraising_goal = null): self
    {
        // validation for constraint: float
        if (!is_null($rg2__reg_fundraising_goal) && !(is_float($rg2__reg_fundraising_goal) || is_numeric($rg2__reg_fundraising_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rg2__reg_fundraising_goal, true), gettype($rg2__reg_fundraising_goal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($rg2__reg_fundraising_goal) && mb_strlen(mb_substr((string) $rg2__reg_fundraising_goal, false !== mb_strpos((string) $rg2__reg_fundraising_goal, '.') ? mb_strpos((string) $rg2__reg_fundraising_goal, '.') + 1 : mb_strlen((string) $rg2__reg_fundraising_goal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($rg2__reg_fundraising_goal, true), mb_strlen(mb_substr((string) $rg2__reg_fundraising_goal, mb_strpos((string) $rg2__reg_fundraising_goal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($rg2__reg_fundraising_goal) && mb_strlen(preg_replace('/(\D)/', '', (string) $rg2__reg_fundraising_goal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($rg2__reg_fundraising_goal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $rg2__reg_fundraising_goal))), __LINE__);
        }
        if (is_null($rg2__reg_fundraising_goal) || (is_array($rg2__reg_fundraising_goal) && empty($rg2__reg_fundraising_goal))) {
            unset($this->rg2__reg_fundraising_goal);
        } else {
            $this->rg2__reg_fundraising_goal = $rg2__reg_fundraising_goal;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_guest_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_guest_flag(): ?string
    {
        return $this->rg2__reg_guest_flag ?? null;
    }
    /**
     * Set rg2__reg_guest_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_guest_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_guest_flag(?string $rg2__reg_guest_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_guest_flag) && !is_string($rg2__reg_guest_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_guest_flag, true), gettype($rg2__reg_guest_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rg2__reg_guest_flag) && $rg2__reg_guest_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rg2__reg_guest_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rg2__reg_guest_flag) && $rg2__reg_guest_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rg2__reg_guest_flag, true)), __LINE__);
        }
        if (is_null($rg2__reg_guest_flag) || (is_array($rg2__reg_guest_flag) && empty($rg2__reg_guest_flag))) {
            unset($this->rg2__reg_guest_flag);
        } else {
            $this->rg2__reg_guest_flag = $rg2__reg_guest_flag;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_time_in value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_time_in(): ?string
    {
        return $this->rg2__reg_time_in ?? null;
    }
    /**
     * Set rg2__reg_time_in value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_time_in
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_time_in(?string $rg2__reg_time_in = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_time_in) && !is_string($rg2__reg_time_in)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_time_in, true), gettype($rg2__reg_time_in)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($rg2__reg_time_in) && mb_strlen((string) $rg2__reg_time_in) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $rg2__reg_time_in)), __LINE__);
        }
        if (is_null($rg2__reg_time_in) || (is_array($rg2__reg_time_in) && empty($rg2__reg_time_in))) {
            unset($this->rg2__reg_time_in);
        } else {
            $this->rg2__reg_time_in = $rg2__reg_time_in;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_time_out value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_time_out(): ?string
    {
        return $this->rg2__reg_time_out ?? null;
    }
    /**
     * Set rg2__reg_time_out value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_time_out
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_time_out(?string $rg2__reg_time_out = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_time_out) && !is_string($rg2__reg_time_out)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_time_out, true), gettype($rg2__reg_time_out)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($rg2__reg_time_out) && mb_strlen((string) $rg2__reg_time_out) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $rg2__reg_time_out)), __LINE__);
        }
        if (is_null($rg2__reg_time_out) || (is_array($rg2__reg_time_out) && empty($rg2__reg_time_out))) {
            unset($this->rg2__reg_time_out);
        } else {
            $this->rg2__reg_time_out = $rg2__reg_time_out;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_narrative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_narrative(): ?string
    {
        return $this->rg2__reg_narrative ?? null;
    }
    /**
     * Set rg2__reg_narrative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_narrative
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_narrative(?string $rg2__reg_narrative = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_narrative) && !is_string($rg2__reg_narrative)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_narrative, true), gettype($rg2__reg_narrative)), __LINE__);
        }
        if (is_null($rg2__reg_narrative) || (is_array($rg2__reg_narrative) && empty($rg2__reg_narrative))) {
            unset($this->rg2__reg_narrative);
        } else {
            $this->rg2__reg_narrative = $rg2__reg_narrative;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_leaderboard_suppress_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_leaderboard_suppress_flag(): ?string
    {
        return $this->rg2__reg_leaderboard_suppress_flag ?? null;
    }
    /**
     * Set rg2__reg_leaderboard_suppress_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_leaderboard_suppress_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_leaderboard_suppress_flag(?string $rg2__reg_leaderboard_suppress_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_leaderboard_suppress_flag) && !is_string($rg2__reg_leaderboard_suppress_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_leaderboard_suppress_flag, true), gettype($rg2__reg_leaderboard_suppress_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rg2__reg_leaderboard_suppress_flag) && $rg2__reg_leaderboard_suppress_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rg2__reg_leaderboard_suppress_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rg2__reg_leaderboard_suppress_flag) && $rg2__reg_leaderboard_suppress_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rg2__reg_leaderboard_suppress_flag, true)), __LINE__);
        }
        if (is_null($rg2__reg_leaderboard_suppress_flag) || (is_array($rg2__reg_leaderboard_suppress_flag) && empty($rg2__reg_leaderboard_suppress_flag))) {
            unset($this->rg2__reg_leaderboard_suppress_flag);
        } else {
            $this->rg2__reg_leaderboard_suppress_flag = $rg2__reg_leaderboard_suppress_flag;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_leaderboard_suppress_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_leaderboard_suppress_amount(): ?string
    {
        return $this->rg2__reg_leaderboard_suppress_amount ?? null;
    }
    /**
     * Set rg2__reg_leaderboard_suppress_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_leaderboard_suppress_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_leaderboard_suppress_amount(?string $rg2__reg_leaderboard_suppress_amount = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_leaderboard_suppress_amount) && !is_string($rg2__reg_leaderboard_suppress_amount)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_leaderboard_suppress_amount, true), gettype($rg2__reg_leaderboard_suppress_amount)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rg2__reg_leaderboard_suppress_amount) && $rg2__reg_leaderboard_suppress_amount > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rg2__reg_leaderboard_suppress_amount, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rg2__reg_leaderboard_suppress_amount) && $rg2__reg_leaderboard_suppress_amount < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rg2__reg_leaderboard_suppress_amount, true)), __LINE__);
        }
        if (is_null($rg2__reg_leaderboard_suppress_amount) || (is_array($rg2__reg_leaderboard_suppress_amount) && empty($rg2__reg_leaderboard_suppress_amount))) {
            unset($this->rg2__reg_leaderboard_suppress_amount);
        } else {
            $this->rg2__reg_leaderboard_suppress_amount = $rg2__reg_leaderboard_suppress_amount;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_video_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_video_url(): ?string
    {
        return $this->rg2__reg_video_url ?? null;
    }
    /**
     * Set rg2__reg_video_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_video_url
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_video_url(?string $rg2__reg_video_url = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_video_url) && !is_string($rg2__reg_video_url)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_video_url, true), gettype($rg2__reg_video_url)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($rg2__reg_video_url) && mb_strlen((string) $rg2__reg_video_url) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $rg2__reg_video_url)), __LINE__);
        }
        if (is_null($rg2__reg_video_url) || (is_array($rg2__reg_video_url) && empty($rg2__reg_video_url))) {
            unset($this->rg2__reg_video_url);
        } else {
            $this->rg2__reg_video_url = $rg2__reg_video_url;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_waiver_signed_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_waiver_signed_name(): ?string
    {
        return $this->rg2__reg_waiver_signed_name ?? null;
    }
    /**
     * Set rg2__reg_waiver_signed_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_waiver_signed_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_waiver_signed_name(?string $rg2__reg_waiver_signed_name = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_waiver_signed_name) && !is_string($rg2__reg_waiver_signed_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_waiver_signed_name, true), gettype($rg2__reg_waiver_signed_name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($rg2__reg_waiver_signed_name) && mb_strlen((string) $rg2__reg_waiver_signed_name) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $rg2__reg_waiver_signed_name)), __LINE__);
        }
        if (is_null($rg2__reg_waiver_signed_name) || (is_array($rg2__reg_waiver_signed_name) && empty($rg2__reg_waiver_signed_name))) {
            unset($this->rg2__reg_waiver_signed_name);
        } else {
            $this->rg2__reg_waiver_signed_name = $rg2__reg_waiver_signed_name;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_waiver_signed_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_waiver_signed_date(): ?string
    {
        return $this->rg2__reg_waiver_signed_date ?? null;
    }
    /**
     * Set rg2__reg_waiver_signed_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_waiver_signed_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_waiver_signed_date(?string $rg2__reg_waiver_signed_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_waiver_signed_date) && !is_string($rg2__reg_waiver_signed_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_waiver_signed_date, true), gettype($rg2__reg_waiver_signed_date)), __LINE__);
        }
        if (is_null($rg2__reg_waiver_signed_date) || (is_array($rg2__reg_waiver_signed_date) && empty($rg2__reg_waiver_signed_date))) {
            unset($this->rg2__reg_waiver_signed_date);
        } else {
            $this->rg2__reg_waiver_signed_date = $rg2__reg_waiver_signed_date;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_attestation_complete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_attestation_complete_flag(): ?string
    {
        return $this->rg2__reg_attestation_complete_flag ?? null;
    }
    /**
     * Set rg2__reg_attestation_complete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_attestation_complete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_attestation_complete_flag(?string $rg2__reg_attestation_complete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_attestation_complete_flag) && !is_string($rg2__reg_attestation_complete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_attestation_complete_flag, true), gettype($rg2__reg_attestation_complete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rg2__reg_attestation_complete_flag) && $rg2__reg_attestation_complete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rg2__reg_attestation_complete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rg2__reg_attestation_complete_flag) && $rg2__reg_attestation_complete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rg2__reg_attestation_complete_flag, true)), __LINE__);
        }
        if (is_null($rg2__reg_attestation_complete_flag) || (is_array($rg2__reg_attestation_complete_flag) && empty($rg2__reg_attestation_complete_flag))) {
            unset($this->rg2__reg_attestation_complete_flag);
        } else {
            $this->rg2__reg_attestation_complete_flag = $rg2__reg_attestation_complete_flag;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_attestation_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_attestation_type(): ?string
    {
        return $this->rg2__reg_attestation_type ?? null;
    }
    /**
     * Set rg2__reg_attestation_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_attestation_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_attestation_type(?string $rg2__reg_attestation_type = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_attestation_type) && !is_string($rg2__reg_attestation_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_attestation_type, true), gettype($rg2__reg_attestation_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($rg2__reg_attestation_type) && mb_strlen((string) $rg2__reg_attestation_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $rg2__reg_attestation_type)), __LINE__);
        }
        if (is_null($rg2__reg_attestation_type) || (is_array($rg2__reg_attestation_type) && empty($rg2__reg_attestation_type))) {
            unset($this->rg2__reg_attestation_type);
        } else {
            $this->rg2__reg_attestation_type = $rg2__reg_attestation_type;
        }
        
        return $this;
    }
    /**
     * Get rg2__reg_attestation_entered_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRg2__reg_attestation_entered_name(): ?string
    {
        return $this->rg2__reg_attestation_entered_name ?? null;
    }
    /**
     * Set rg2__reg_attestation_entered_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rg2__reg_attestation_entered_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_RegistrantGuest_DataObjectType
     */
    public function setRg2__reg_attestation_entered_name(?string $rg2__reg_attestation_entered_name = null): self
    {
        // validation for constraint: string
        if (!is_null($rg2__reg_attestation_entered_name) && !is_string($rg2__reg_attestation_entered_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg2__reg_attestation_entered_name, true), gettype($rg2__reg_attestation_entered_name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($rg2__reg_attestation_entered_name) && mb_strlen((string) $rg2__reg_attestation_entered_name) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $rg2__reg_attestation_entered_name)), __LINE__);
        }
        if (is_null($rg2__reg_attestation_entered_name) || (is_array($rg2__reg_attestation_entered_name) && empty($rg2__reg_attestation_entered_name))) {
            unset($this->rg2__reg_attestation_entered_name);
        } else {
            $this->rg2__reg_attestation_entered_name = $rg2__reg_attestation_entered_name;
        }
        
        return $this;
    }
}
