<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Registrant_Housing_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Registrant_Housing_DataObjectType extends AbstractStructBase
{
    /**
     * The evh_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evh_key = null;
    /**
     * The evh_hotel_name
     * Meta information extracted from the WSDL
     * - documentation: Hotel Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_hotel_name = null;
    /**
     * The evh_hotel_phone
     * Meta information extracted from the WSDL
     * - documentation: Hotel Phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_hotel_phone = null;
    /**
     * The evh_hotel_fax
     * Meta information extracted from the WSDL
     * - documentation: Hotel Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_hotel_fax = null;
    /**
     * The evh_arrival_date
     * Meta information extracted from the WSDL
     * - documentation: Arrival Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_arrival_date = null;
    /**
     * The evh_departure_date
     * Meta information extracted from the WSDL
     * - documentation: Departure Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_departure_date = null;
    /**
     * The evh_rmt_key
     * Meta information extracted from the WSDL
     * - documentation: Room Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evh_rmt_key = null;
    /**
     * The evh_room_rate
     * Meta information extracted from the WSDL
     * - documentation: Room Rate. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $evh_room_rate = null;
    /**
     * The evh_smoking
     * Meta information extracted from the WSDL
     * - documentation: Smoking?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_smoking = null;
    /**
     * The evh_special_request
     * Meta information extracted from the WSDL
     * - documentation: Special Request. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_special_request = null;
    /**
     * The evh_budget_code
     * Meta information extracted from the WSDL
     * - documentation: Budget Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_budget_code = null;
    /**
     * The evh_budget_type
     * Meta information extracted from the WSDL
     * - documentation: Budget Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_budget_type = null;
    /**
     * The evh_billing_information
     * Meta information extracted from the WSDL
     * - documentation: Billing Information. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_billing_information = null;
    /**
     * The evh_check_in_date
     * Meta information extracted from the WSDL
     * - documentation: Check In Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_check_in_date = null;
    /**
     * The evh_check_out_date
     * Meta information extracted from the WSDL
     * - documentation: Check Out Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_check_out_date = null;
    /**
     * The evh_airport
     * Meta information extracted from the WSDL
     * - documentation: Airport. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_airport = null;
    /**
     * The evh_arrival_airline
     * Meta information extracted from the WSDL
     * - documentation: Arrival Airline. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_arrival_airline = null;
    /**
     * The evh_departure_airline
     * Meta information extracted from the WSDL
     * - documentation: Departure Airline. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_departure_airline = null;
    /**
     * The evh_arrival_flight
     * Meta information extracted from the WSDL
     * - documentation: Arrival Flight. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_arrival_flight = null;
    /**
     * The evh_departure_flight
     * Meta information extracted from the WSDL
     * - documentation: Departure Flight. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_departure_flight = null;
    /**
     * The evh_car_service
     * Meta information extracted from the WSDL
     * - documentation: Car Service. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_car_service = null;
    /**
     * The evh_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_add_user = null;
    /**
     * The evh_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_add_date = null;
    /**
     * The evh_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_change_user = null;
    /**
     * The evh_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_change_date = null;
    /**
     * The evh_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_delete_flag = null;
    /**
     * The evh_loc_key
     * Meta information extracted from the WSDL
     * - documentation: Hotel. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evh_loc_key = null;
    /**
     * The evh_ticket_cost
     * Meta information extracted from the WSDL
     * - documentation: Airline Ticket Cost. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $evh_ticket_cost = null;
    /**
     * The evh_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evh_key_ext = null;
    /**
     * The evh_car_cost
     * Meta information extracted from the WSDL
     * - documentation: Car Service Cost. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $evh_car_cost = null;
    /**
     * The evh_parent_key
     * Meta information extracted from the WSDL
     * - documentation: Parent Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evh_parent_key = null;
    /**
     * The evh_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evh_entity_key = null;
    /**
     * The evh_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Event Registrant. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $evh_reg_key = null;
    /**
     * The evh_hotel_name2
     * Meta information extracted from the WSDL
     * - documentation: Hotel 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_hotel_name2 = null;
    /**
     * The evh_hotel_name3
     * Meta information extracted from the WSDL
     * - documentation: Hotel 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_hotel_name3 = null;
    /**
     * The evh_cc_number
     * Meta information extracted from the WSDL
     * - documentation: credit card number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_cc_number = null;
    /**
     * The evh_cc_number_display
     * Meta information extracted from the WSDL
     * - documentation: credit card number display. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $evh_cc_number_display = null;
    /**
     * Constructor method for EventsRegistrant_Registrant_Housing_DataObjectType
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_key()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_hotel_name()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_hotel_phone()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_hotel_fax()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_arrival_date()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_departure_date()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_rmt_key()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_room_rate()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_smoking()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_special_request()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_budget_code()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_budget_type()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_billing_information()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_check_in_date()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_check_out_date()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_airport()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_arrival_airline()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_departure_airline()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_arrival_flight()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_departure_flight()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_car_service()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_add_user()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_add_date()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_change_user()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_change_date()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_delete_flag()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_loc_key()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_ticket_cost()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_key_ext()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_car_cost()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_parent_key()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_entity_key()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_reg_key()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_hotel_name2()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_hotel_name3()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_cc_number()
     * @uses EventsRegistrant_Registrant_Housing_DataObjectType::setEvh_cc_number_display()
     * @param string $evh_key
     * @param string $evh_hotel_name
     * @param string $evh_hotel_phone
     * @param string $evh_hotel_fax
     * @param string $evh_arrival_date
     * @param string $evh_departure_date
     * @param string $evh_rmt_key
     * @param float $evh_room_rate
     * @param string $evh_smoking
     * @param string $evh_special_request
     * @param string $evh_budget_code
     * @param string $evh_budget_type
     * @param string $evh_billing_information
     * @param string $evh_check_in_date
     * @param string $evh_check_out_date
     * @param string $evh_airport
     * @param string $evh_arrival_airline
     * @param string $evh_departure_airline
     * @param string $evh_arrival_flight
     * @param string $evh_departure_flight
     * @param string $evh_car_service
     * @param string $evh_add_user
     * @param string $evh_add_date
     * @param string $evh_change_user
     * @param string $evh_change_date
     * @param string $evh_delete_flag
     * @param string $evh_loc_key
     * @param float $evh_ticket_cost
     * @param string $evh_key_ext
     * @param float $evh_car_cost
     * @param string $evh_parent_key
     * @param string $evh_entity_key
     * @param string $evh_reg_key
     * @param string $evh_hotel_name2
     * @param string $evh_hotel_name3
     * @param string $evh_cc_number
     * @param string $evh_cc_number_display
     */
    public function __construct(?string $evh_key = null, ?string $evh_hotel_name = null, ?string $evh_hotel_phone = null, ?string $evh_hotel_fax = null, ?string $evh_arrival_date = null, ?string $evh_departure_date = null, ?string $evh_rmt_key = null, ?float $evh_room_rate = null, ?string $evh_smoking = null, ?string $evh_special_request = null, ?string $evh_budget_code = null, ?string $evh_budget_type = null, ?string $evh_billing_information = null, ?string $evh_check_in_date = null, ?string $evh_check_out_date = null, ?string $evh_airport = null, ?string $evh_arrival_airline = null, ?string $evh_departure_airline = null, ?string $evh_arrival_flight = null, ?string $evh_departure_flight = null, ?string $evh_car_service = null, ?string $evh_add_user = null, ?string $evh_add_date = null, ?string $evh_change_user = null, ?string $evh_change_date = null, ?string $evh_delete_flag = null, ?string $evh_loc_key = null, ?float $evh_ticket_cost = null, ?string $evh_key_ext = null, ?float $evh_car_cost = null, ?string $evh_parent_key = null, ?string $evh_entity_key = null, ?string $evh_reg_key = null, ?string $evh_hotel_name2 = null, ?string $evh_hotel_name3 = null, ?string $evh_cc_number = null, ?string $evh_cc_number_display = null)
    {
        $this
            ->setEvh_key($evh_key)
            ->setEvh_hotel_name($evh_hotel_name)
            ->setEvh_hotel_phone($evh_hotel_phone)
            ->setEvh_hotel_fax($evh_hotel_fax)
            ->setEvh_arrival_date($evh_arrival_date)
            ->setEvh_departure_date($evh_departure_date)
            ->setEvh_rmt_key($evh_rmt_key)
            ->setEvh_room_rate($evh_room_rate)
            ->setEvh_smoking($evh_smoking)
            ->setEvh_special_request($evh_special_request)
            ->setEvh_budget_code($evh_budget_code)
            ->setEvh_budget_type($evh_budget_type)
            ->setEvh_billing_information($evh_billing_information)
            ->setEvh_check_in_date($evh_check_in_date)
            ->setEvh_check_out_date($evh_check_out_date)
            ->setEvh_airport($evh_airport)
            ->setEvh_arrival_airline($evh_arrival_airline)
            ->setEvh_departure_airline($evh_departure_airline)
            ->setEvh_arrival_flight($evh_arrival_flight)
            ->setEvh_departure_flight($evh_departure_flight)
            ->setEvh_car_service($evh_car_service)
            ->setEvh_add_user($evh_add_user)
            ->setEvh_add_date($evh_add_date)
            ->setEvh_change_user($evh_change_user)
            ->setEvh_change_date($evh_change_date)
            ->setEvh_delete_flag($evh_delete_flag)
            ->setEvh_loc_key($evh_loc_key)
            ->setEvh_ticket_cost($evh_ticket_cost)
            ->setEvh_key_ext($evh_key_ext)
            ->setEvh_car_cost($evh_car_cost)
            ->setEvh_parent_key($evh_parent_key)
            ->setEvh_entity_key($evh_entity_key)
            ->setEvh_reg_key($evh_reg_key)
            ->setEvh_hotel_name2($evh_hotel_name2)
            ->setEvh_hotel_name3($evh_hotel_name3)
            ->setEvh_cc_number($evh_cc_number)
            ->setEvh_cc_number_display($evh_cc_number_display);
    }
    /**
     * Get evh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_key(): ?string
    {
        return $this->evh_key ?? null;
    }
    /**
     * Set evh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_key(?string $evh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_key) && !is_string($evh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_key, true), gettype($evh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evh_key, true)), __LINE__);
        }
        if (is_null($evh_key) || (is_array($evh_key) && empty($evh_key))) {
            unset($this->evh_key);
        } else {
            $this->evh_key = $evh_key;
        }
        
        return $this;
    }
    /**
     * Get evh_hotel_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_hotel_name(): ?string
    {
        return $this->evh_hotel_name ?? null;
    }
    /**
     * Set evh_hotel_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_hotel_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_hotel_name(?string $evh_hotel_name = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_hotel_name) && !is_string($evh_hotel_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_hotel_name, true), gettype($evh_hotel_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($evh_hotel_name) && mb_strlen((string) $evh_hotel_name) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $evh_hotel_name)), __LINE__);
        }
        if (is_null($evh_hotel_name) || (is_array($evh_hotel_name) && empty($evh_hotel_name))) {
            unset($this->evh_hotel_name);
        } else {
            $this->evh_hotel_name = $evh_hotel_name;
        }
        
        return $this;
    }
    /**
     * Get evh_hotel_phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_hotel_phone(): ?string
    {
        return $this->evh_hotel_phone ?? null;
    }
    /**
     * Set evh_hotel_phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_hotel_phone
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_hotel_phone(?string $evh_hotel_phone = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_hotel_phone) && !is_string($evh_hotel_phone)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_hotel_phone, true), gettype($evh_hotel_phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($evh_hotel_phone) && mb_strlen((string) $evh_hotel_phone) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $evh_hotel_phone)), __LINE__);
        }
        if (is_null($evh_hotel_phone) || (is_array($evh_hotel_phone) && empty($evh_hotel_phone))) {
            unset($this->evh_hotel_phone);
        } else {
            $this->evh_hotel_phone = $evh_hotel_phone;
        }
        
        return $this;
    }
    /**
     * Get evh_hotel_fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_hotel_fax(): ?string
    {
        return $this->evh_hotel_fax ?? null;
    }
    /**
     * Set evh_hotel_fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_hotel_fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_hotel_fax(?string $evh_hotel_fax = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_hotel_fax) && !is_string($evh_hotel_fax)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_hotel_fax, true), gettype($evh_hotel_fax)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($evh_hotel_fax) && mb_strlen((string) $evh_hotel_fax) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $evh_hotel_fax)), __LINE__);
        }
        if (is_null($evh_hotel_fax) || (is_array($evh_hotel_fax) && empty($evh_hotel_fax))) {
            unset($this->evh_hotel_fax);
        } else {
            $this->evh_hotel_fax = $evh_hotel_fax;
        }
        
        return $this;
    }
    /**
     * Get evh_arrival_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_arrival_date(): ?string
    {
        return $this->evh_arrival_date ?? null;
    }
    /**
     * Set evh_arrival_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_arrival_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_arrival_date(?string $evh_arrival_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_arrival_date) && !is_string($evh_arrival_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_arrival_date, true), gettype($evh_arrival_date)), __LINE__);
        }
        if (is_null($evh_arrival_date) || (is_array($evh_arrival_date) && empty($evh_arrival_date))) {
            unset($this->evh_arrival_date);
        } else {
            $this->evh_arrival_date = $evh_arrival_date;
        }
        
        return $this;
    }
    /**
     * Get evh_departure_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_departure_date(): ?string
    {
        return $this->evh_departure_date ?? null;
    }
    /**
     * Set evh_departure_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_departure_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_departure_date(?string $evh_departure_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_departure_date) && !is_string($evh_departure_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_departure_date, true), gettype($evh_departure_date)), __LINE__);
        }
        if (is_null($evh_departure_date) || (is_array($evh_departure_date) && empty($evh_departure_date))) {
            unset($this->evh_departure_date);
        } else {
            $this->evh_departure_date = $evh_departure_date;
        }
        
        return $this;
    }
    /**
     * Get evh_rmt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_rmt_key(): ?string
    {
        return $this->evh_rmt_key ?? null;
    }
    /**
     * Set evh_rmt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_rmt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_rmt_key(?string $evh_rmt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_rmt_key) && !is_string($evh_rmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_rmt_key, true), gettype($evh_rmt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evh_rmt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evh_rmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evh_rmt_key, true)), __LINE__);
        }
        if (is_null($evh_rmt_key) || (is_array($evh_rmt_key) && empty($evh_rmt_key))) {
            unset($this->evh_rmt_key);
        } else {
            $this->evh_rmt_key = $evh_rmt_key;
        }
        
        return $this;
    }
    /**
     * Get evh_room_rate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEvh_room_rate(): ?float
    {
        return $this->evh_room_rate ?? null;
    }
    /**
     * Set evh_room_rate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $evh_room_rate
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_room_rate(?float $evh_room_rate = null): self
    {
        // validation for constraint: float
        if (!is_null($evh_room_rate) && !(is_float($evh_room_rate) || is_numeric($evh_room_rate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($evh_room_rate, true), gettype($evh_room_rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($evh_room_rate) && mb_strlen(mb_substr((string) $evh_room_rate, false !== mb_strpos((string) $evh_room_rate, '.') ? mb_strpos((string) $evh_room_rate, '.') + 1 : mb_strlen((string) $evh_room_rate))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($evh_room_rate, true), mb_strlen(mb_substr((string) $evh_room_rate, mb_strpos((string) $evh_room_rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($evh_room_rate) && mb_strlen(preg_replace('/(\D)/', '', (string) $evh_room_rate)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($evh_room_rate, true), mb_strlen(preg_replace('/(\D)/', '', (string) $evh_room_rate))), __LINE__);
        }
        if (is_null($evh_room_rate) || (is_array($evh_room_rate) && empty($evh_room_rate))) {
            unset($this->evh_room_rate);
        } else {
            $this->evh_room_rate = $evh_room_rate;
        }
        
        return $this;
    }
    /**
     * Get evh_smoking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_smoking(): ?string
    {
        return $this->evh_smoking ?? null;
    }
    /**
     * Set evh_smoking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_smoking
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_smoking(?string $evh_smoking = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_smoking) && !is_string($evh_smoking)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_smoking, true), gettype($evh_smoking)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evh_smoking) && $evh_smoking > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evh_smoking, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evh_smoking) && $evh_smoking < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evh_smoking, true)), __LINE__);
        }
        if (is_null($evh_smoking) || (is_array($evh_smoking) && empty($evh_smoking))) {
            unset($this->evh_smoking);
        } else {
            $this->evh_smoking = $evh_smoking;
        }
        
        return $this;
    }
    /**
     * Get evh_special_request value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_special_request(): ?string
    {
        return $this->evh_special_request ?? null;
    }
    /**
     * Set evh_special_request value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_special_request
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_special_request(?string $evh_special_request = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_special_request) && !is_string($evh_special_request)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_special_request, true), gettype($evh_special_request)), __LINE__);
        }
        if (is_null($evh_special_request) || (is_array($evh_special_request) && empty($evh_special_request))) {
            unset($this->evh_special_request);
        } else {
            $this->evh_special_request = $evh_special_request;
        }
        
        return $this;
    }
    /**
     * Get evh_budget_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_budget_code(): ?string
    {
        return $this->evh_budget_code ?? null;
    }
    /**
     * Set evh_budget_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_budget_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_budget_code(?string $evh_budget_code = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_budget_code) && !is_string($evh_budget_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_budget_code, true), gettype($evh_budget_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($evh_budget_code) && mb_strlen((string) $evh_budget_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $evh_budget_code)), __LINE__);
        }
        if (is_null($evh_budget_code) || (is_array($evh_budget_code) && empty($evh_budget_code))) {
            unset($this->evh_budget_code);
        } else {
            $this->evh_budget_code = $evh_budget_code;
        }
        
        return $this;
    }
    /**
     * Get evh_budget_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_budget_type(): ?string
    {
        return $this->evh_budget_type ?? null;
    }
    /**
     * Set evh_budget_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_budget_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_budget_type(?string $evh_budget_type = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_budget_type) && !is_string($evh_budget_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_budget_type, true), gettype($evh_budget_type)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($evh_budget_type) && mb_strlen((string) $evh_budget_type) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $evh_budget_type)), __LINE__);
        }
        if (is_null($evh_budget_type) || (is_array($evh_budget_type) && empty($evh_budget_type))) {
            unset($this->evh_budget_type);
        } else {
            $this->evh_budget_type = $evh_budget_type;
        }
        
        return $this;
    }
    /**
     * Get evh_billing_information value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_billing_information(): ?string
    {
        return $this->evh_billing_information ?? null;
    }
    /**
     * Set evh_billing_information value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_billing_information
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_billing_information(?string $evh_billing_information = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_billing_information) && !is_string($evh_billing_information)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_billing_information, true), gettype($evh_billing_information)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($evh_billing_information) && mb_strlen((string) $evh_billing_information) > 500) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen((string) $evh_billing_information)), __LINE__);
        }
        if (is_null($evh_billing_information) || (is_array($evh_billing_information) && empty($evh_billing_information))) {
            unset($this->evh_billing_information);
        } else {
            $this->evh_billing_information = $evh_billing_information;
        }
        
        return $this;
    }
    /**
     * Get evh_check_in_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_check_in_date(): ?string
    {
        return $this->evh_check_in_date ?? null;
    }
    /**
     * Set evh_check_in_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_check_in_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_check_in_date(?string $evh_check_in_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_check_in_date) && !is_string($evh_check_in_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_check_in_date, true), gettype($evh_check_in_date)), __LINE__);
        }
        if (is_null($evh_check_in_date) || (is_array($evh_check_in_date) && empty($evh_check_in_date))) {
            unset($this->evh_check_in_date);
        } else {
            $this->evh_check_in_date = $evh_check_in_date;
        }
        
        return $this;
    }
    /**
     * Get evh_check_out_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_check_out_date(): ?string
    {
        return $this->evh_check_out_date ?? null;
    }
    /**
     * Set evh_check_out_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_check_out_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_check_out_date(?string $evh_check_out_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_check_out_date) && !is_string($evh_check_out_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_check_out_date, true), gettype($evh_check_out_date)), __LINE__);
        }
        if (is_null($evh_check_out_date) || (is_array($evh_check_out_date) && empty($evh_check_out_date))) {
            unset($this->evh_check_out_date);
        } else {
            $this->evh_check_out_date = $evh_check_out_date;
        }
        
        return $this;
    }
    /**
     * Get evh_airport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_airport(): ?string
    {
        return $this->evh_airport ?? null;
    }
    /**
     * Set evh_airport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_airport
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_airport(?string $evh_airport = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_airport) && !is_string($evh_airport)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_airport, true), gettype($evh_airport)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($evh_airport) && mb_strlen((string) $evh_airport) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $evh_airport)), __LINE__);
        }
        if (is_null($evh_airport) || (is_array($evh_airport) && empty($evh_airport))) {
            unset($this->evh_airport);
        } else {
            $this->evh_airport = $evh_airport;
        }
        
        return $this;
    }
    /**
     * Get evh_arrival_airline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_arrival_airline(): ?string
    {
        return $this->evh_arrival_airline ?? null;
    }
    /**
     * Set evh_arrival_airline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_arrival_airline
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_arrival_airline(?string $evh_arrival_airline = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_arrival_airline) && !is_string($evh_arrival_airline)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_arrival_airline, true), gettype($evh_arrival_airline)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($evh_arrival_airline) && mb_strlen((string) $evh_arrival_airline) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $evh_arrival_airline)), __LINE__);
        }
        if (is_null($evh_arrival_airline) || (is_array($evh_arrival_airline) && empty($evh_arrival_airline))) {
            unset($this->evh_arrival_airline);
        } else {
            $this->evh_arrival_airline = $evh_arrival_airline;
        }
        
        return $this;
    }
    /**
     * Get evh_departure_airline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_departure_airline(): ?string
    {
        return $this->evh_departure_airline ?? null;
    }
    /**
     * Set evh_departure_airline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_departure_airline
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_departure_airline(?string $evh_departure_airline = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_departure_airline) && !is_string($evh_departure_airline)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_departure_airline, true), gettype($evh_departure_airline)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($evh_departure_airline) && mb_strlen((string) $evh_departure_airline) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $evh_departure_airline)), __LINE__);
        }
        if (is_null($evh_departure_airline) || (is_array($evh_departure_airline) && empty($evh_departure_airline))) {
            unset($this->evh_departure_airline);
        } else {
            $this->evh_departure_airline = $evh_departure_airline;
        }
        
        return $this;
    }
    /**
     * Get evh_arrival_flight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_arrival_flight(): ?string
    {
        return $this->evh_arrival_flight ?? null;
    }
    /**
     * Set evh_arrival_flight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_arrival_flight
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_arrival_flight(?string $evh_arrival_flight = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_arrival_flight) && !is_string($evh_arrival_flight)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_arrival_flight, true), gettype($evh_arrival_flight)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($evh_arrival_flight) && mb_strlen((string) $evh_arrival_flight) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $evh_arrival_flight)), __LINE__);
        }
        if (is_null($evh_arrival_flight) || (is_array($evh_arrival_flight) && empty($evh_arrival_flight))) {
            unset($this->evh_arrival_flight);
        } else {
            $this->evh_arrival_flight = $evh_arrival_flight;
        }
        
        return $this;
    }
    /**
     * Get evh_departure_flight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_departure_flight(): ?string
    {
        return $this->evh_departure_flight ?? null;
    }
    /**
     * Set evh_departure_flight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_departure_flight
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_departure_flight(?string $evh_departure_flight = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_departure_flight) && !is_string($evh_departure_flight)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_departure_flight, true), gettype($evh_departure_flight)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($evh_departure_flight) && mb_strlen((string) $evh_departure_flight) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $evh_departure_flight)), __LINE__);
        }
        if (is_null($evh_departure_flight) || (is_array($evh_departure_flight) && empty($evh_departure_flight))) {
            unset($this->evh_departure_flight);
        } else {
            $this->evh_departure_flight = $evh_departure_flight;
        }
        
        return $this;
    }
    /**
     * Get evh_car_service value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_car_service(): ?string
    {
        return $this->evh_car_service ?? null;
    }
    /**
     * Set evh_car_service value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_car_service
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_car_service(?string $evh_car_service = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_car_service) && !is_string($evh_car_service)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_car_service, true), gettype($evh_car_service)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($evh_car_service) && mb_strlen((string) $evh_car_service) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $evh_car_service)), __LINE__);
        }
        if (is_null($evh_car_service) || (is_array($evh_car_service) && empty($evh_car_service))) {
            unset($this->evh_car_service);
        } else {
            $this->evh_car_service = $evh_car_service;
        }
        
        return $this;
    }
    /**
     * Get evh_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_add_user(): ?string
    {
        return $this->evh_add_user ?? null;
    }
    /**
     * Set evh_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_add_user(?string $evh_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_add_user) && !is_string($evh_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_add_user, true), gettype($evh_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($evh_add_user) && mb_strlen((string) $evh_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $evh_add_user)), __LINE__);
        }
        if (is_null($evh_add_user) || (is_array($evh_add_user) && empty($evh_add_user))) {
            unset($this->evh_add_user);
        } else {
            $this->evh_add_user = $evh_add_user;
        }
        
        return $this;
    }
    /**
     * Get evh_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_add_date(): ?string
    {
        return $this->evh_add_date ?? null;
    }
    /**
     * Set evh_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_add_date(?string $evh_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_add_date) && !is_string($evh_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_add_date, true), gettype($evh_add_date)), __LINE__);
        }
        if (is_null($evh_add_date) || (is_array($evh_add_date) && empty($evh_add_date))) {
            unset($this->evh_add_date);
        } else {
            $this->evh_add_date = $evh_add_date;
        }
        
        return $this;
    }
    /**
     * Get evh_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_change_user(): ?string
    {
        return $this->evh_change_user ?? null;
    }
    /**
     * Set evh_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_change_user(?string $evh_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_change_user) && !is_string($evh_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_change_user, true), gettype($evh_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($evh_change_user) && mb_strlen((string) $evh_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $evh_change_user)), __LINE__);
        }
        if (is_null($evh_change_user) || (is_array($evh_change_user) && empty($evh_change_user))) {
            unset($this->evh_change_user);
        } else {
            $this->evh_change_user = $evh_change_user;
        }
        
        return $this;
    }
    /**
     * Get evh_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_change_date(): ?string
    {
        return $this->evh_change_date ?? null;
    }
    /**
     * Set evh_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_change_date(?string $evh_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_change_date) && !is_string($evh_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_change_date, true), gettype($evh_change_date)), __LINE__);
        }
        if (is_null($evh_change_date) || (is_array($evh_change_date) && empty($evh_change_date))) {
            unset($this->evh_change_date);
        } else {
            $this->evh_change_date = $evh_change_date;
        }
        
        return $this;
    }
    /**
     * Get evh_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_delete_flag(): ?string
    {
        return $this->evh_delete_flag ?? null;
    }
    /**
     * Set evh_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_delete_flag(?string $evh_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_delete_flag) && !is_string($evh_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_delete_flag, true), gettype($evh_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($evh_delete_flag) && $evh_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($evh_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($evh_delete_flag) && $evh_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($evh_delete_flag, true)), __LINE__);
        }
        if (is_null($evh_delete_flag) || (is_array($evh_delete_flag) && empty($evh_delete_flag))) {
            unset($this->evh_delete_flag);
        } else {
            $this->evh_delete_flag = $evh_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get evh_loc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_loc_key(): ?string
    {
        return $this->evh_loc_key ?? null;
    }
    /**
     * Set evh_loc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_loc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_loc_key(?string $evh_loc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_loc_key) && !is_string($evh_loc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_loc_key, true), gettype($evh_loc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evh_loc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evh_loc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evh_loc_key, true)), __LINE__);
        }
        if (is_null($evh_loc_key) || (is_array($evh_loc_key) && empty($evh_loc_key))) {
            unset($this->evh_loc_key);
        } else {
            $this->evh_loc_key = $evh_loc_key;
        }
        
        return $this;
    }
    /**
     * Get evh_ticket_cost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEvh_ticket_cost(): ?float
    {
        return $this->evh_ticket_cost ?? null;
    }
    /**
     * Set evh_ticket_cost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $evh_ticket_cost
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_ticket_cost(?float $evh_ticket_cost = null): self
    {
        // validation for constraint: float
        if (!is_null($evh_ticket_cost) && !(is_float($evh_ticket_cost) || is_numeric($evh_ticket_cost))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($evh_ticket_cost, true), gettype($evh_ticket_cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($evh_ticket_cost) && mb_strlen(mb_substr((string) $evh_ticket_cost, false !== mb_strpos((string) $evh_ticket_cost, '.') ? mb_strpos((string) $evh_ticket_cost, '.') + 1 : mb_strlen((string) $evh_ticket_cost))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($evh_ticket_cost, true), mb_strlen(mb_substr((string) $evh_ticket_cost, mb_strpos((string) $evh_ticket_cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($evh_ticket_cost) && mb_strlen(preg_replace('/(\D)/', '', (string) $evh_ticket_cost)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($evh_ticket_cost, true), mb_strlen(preg_replace('/(\D)/', '', (string) $evh_ticket_cost))), __LINE__);
        }
        if (is_null($evh_ticket_cost) || (is_array($evh_ticket_cost) && empty($evh_ticket_cost))) {
            unset($this->evh_ticket_cost);
        } else {
            $this->evh_ticket_cost = $evh_ticket_cost;
        }
        
        return $this;
    }
    /**
     * Get evh_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_key_ext(): ?string
    {
        return $this->evh_key_ext ?? null;
    }
    /**
     * Set evh_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_key_ext(?string $evh_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_key_ext) && !is_string($evh_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_key_ext, true), gettype($evh_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evh_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evh_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evh_key_ext, true)), __LINE__);
        }
        if (is_null($evh_key_ext) || (is_array($evh_key_ext) && empty($evh_key_ext))) {
            unset($this->evh_key_ext);
        } else {
            $this->evh_key_ext = $evh_key_ext;
        }
        
        return $this;
    }
    /**
     * Get evh_car_cost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEvh_car_cost(): ?float
    {
        return $this->evh_car_cost ?? null;
    }
    /**
     * Set evh_car_cost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $evh_car_cost
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_car_cost(?float $evh_car_cost = null): self
    {
        // validation for constraint: float
        if (!is_null($evh_car_cost) && !(is_float($evh_car_cost) || is_numeric($evh_car_cost))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($evh_car_cost, true), gettype($evh_car_cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($evh_car_cost) && mb_strlen(mb_substr((string) $evh_car_cost, false !== mb_strpos((string) $evh_car_cost, '.') ? mb_strpos((string) $evh_car_cost, '.') + 1 : mb_strlen((string) $evh_car_cost))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($evh_car_cost, true), mb_strlen(mb_substr((string) $evh_car_cost, mb_strpos((string) $evh_car_cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($evh_car_cost) && mb_strlen(preg_replace('/(\D)/', '', (string) $evh_car_cost)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($evh_car_cost, true), mb_strlen(preg_replace('/(\D)/', '', (string) $evh_car_cost))), __LINE__);
        }
        if (is_null($evh_car_cost) || (is_array($evh_car_cost) && empty($evh_car_cost))) {
            unset($this->evh_car_cost);
        } else {
            $this->evh_car_cost = $evh_car_cost;
        }
        
        return $this;
    }
    /**
     * Get evh_parent_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_parent_key(): ?string
    {
        return $this->evh_parent_key ?? null;
    }
    /**
     * Set evh_parent_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_parent_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_parent_key(?string $evh_parent_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_parent_key) && !is_string($evh_parent_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_parent_key, true), gettype($evh_parent_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evh_parent_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evh_parent_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evh_parent_key, true)), __LINE__);
        }
        if (is_null($evh_parent_key) || (is_array($evh_parent_key) && empty($evh_parent_key))) {
            unset($this->evh_parent_key);
        } else {
            $this->evh_parent_key = $evh_parent_key;
        }
        
        return $this;
    }
    /**
     * Get evh_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_entity_key(): ?string
    {
        return $this->evh_entity_key ?? null;
    }
    /**
     * Set evh_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_entity_key(?string $evh_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_entity_key) && !is_string($evh_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_entity_key, true), gettype($evh_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evh_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evh_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evh_entity_key, true)), __LINE__);
        }
        if (is_null($evh_entity_key) || (is_array($evh_entity_key) && empty($evh_entity_key))) {
            unset($this->evh_entity_key);
        } else {
            $this->evh_entity_key = $evh_entity_key;
        }
        
        return $this;
    }
    /**
     * Get evh_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_reg_key(): ?string
    {
        return $this->evh_reg_key ?? null;
    }
    /**
     * Set evh_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_reg_key(?string $evh_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_reg_key) && !is_string($evh_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_reg_key, true), gettype($evh_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($evh_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $evh_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($evh_reg_key, true)), __LINE__);
        }
        if (is_null($evh_reg_key) || (is_array($evh_reg_key) && empty($evh_reg_key))) {
            unset($this->evh_reg_key);
        } else {
            $this->evh_reg_key = $evh_reg_key;
        }
        
        return $this;
    }
    /**
     * Get evh_hotel_name2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_hotel_name2(): ?string
    {
        return $this->evh_hotel_name2 ?? null;
    }
    /**
     * Set evh_hotel_name2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_hotel_name2
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_hotel_name2(?string $evh_hotel_name2 = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_hotel_name2) && !is_string($evh_hotel_name2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_hotel_name2, true), gettype($evh_hotel_name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($evh_hotel_name2) && mb_strlen((string) $evh_hotel_name2) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $evh_hotel_name2)), __LINE__);
        }
        if (is_null($evh_hotel_name2) || (is_array($evh_hotel_name2) && empty($evh_hotel_name2))) {
            unset($this->evh_hotel_name2);
        } else {
            $this->evh_hotel_name2 = $evh_hotel_name2;
        }
        
        return $this;
    }
    /**
     * Get evh_hotel_name3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_hotel_name3(): ?string
    {
        return $this->evh_hotel_name3 ?? null;
    }
    /**
     * Set evh_hotel_name3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_hotel_name3
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_hotel_name3(?string $evh_hotel_name3 = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_hotel_name3) && !is_string($evh_hotel_name3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_hotel_name3, true), gettype($evh_hotel_name3)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($evh_hotel_name3) && mb_strlen((string) $evh_hotel_name3) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $evh_hotel_name3)), __LINE__);
        }
        if (is_null($evh_hotel_name3) || (is_array($evh_hotel_name3) && empty($evh_hotel_name3))) {
            unset($this->evh_hotel_name3);
        } else {
            $this->evh_hotel_name3 = $evh_hotel_name3;
        }
        
        return $this;
    }
    /**
     * Get evh_cc_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_cc_number(): ?string
    {
        return $this->evh_cc_number ?? null;
    }
    /**
     * Set evh_cc_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_cc_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_cc_number(?string $evh_cc_number = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_cc_number) && !is_string($evh_cc_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_cc_number, true), gettype($evh_cc_number)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($evh_cc_number) && mb_strlen((string) $evh_cc_number) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $evh_cc_number)), __LINE__);
        }
        if (is_null($evh_cc_number) || (is_array($evh_cc_number) && empty($evh_cc_number))) {
            unset($this->evh_cc_number);
        } else {
            $this->evh_cc_number = $evh_cc_number;
        }
        
        return $this;
    }
    /**
     * Get evh_cc_number_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvh_cc_number_display(): ?string
    {
        return $this->evh_cc_number_display ?? null;
    }
    /**
     * Set evh_cc_number_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $evh_cc_number_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Housing_DataObjectType
     */
    public function setEvh_cc_number_display(?string $evh_cc_number_display = null): self
    {
        // validation for constraint: string
        if (!is_null($evh_cc_number_display) && !is_string($evh_cc_number_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evh_cc_number_display, true), gettype($evh_cc_number_display)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($evh_cc_number_display) && mb_strlen((string) $evh_cc_number_display) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $evh_cc_number_display)), __LINE__);
        }
        if (is_null($evh_cc_number_display) || (is_array($evh_cc_number_display) && empty($evh_cc_number_display))) {
            unset($this->evh_cc_number_display);
        } else {
            $this->evh_cc_number_display = $evh_cc_number_display;
        }
        
        return $this;
    }
}
