<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Registrant_Type_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Registrant_Type_DataObjectType extends AbstractStructBase
{
    /**
     * The rgt_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgt_key = null;
    /**
     * The rgt_code
     * Meta information extracted from the WSDL
     * - documentation: registrant type code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgt_code = null;
    /**
     * The rgt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgt_add_user = null;
    /**
     * The rgt_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgt_add_date = null;
    /**
     * The rgt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgt_change_user = null;
    /**
     * The rgt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgt_change_date = null;
    /**
     * The rgt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgt_delete_flag = null;
    /**
     * The rgt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgt_key_ext = null;
    /**
     * The rgt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rgt_entity_key = null;
    /**
     * The rgt_guest_flag
     * Meta information extracted from the WSDL
     * - documentation: guest flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rgt_guest_flag = null;
    /**
     * Constructor method for EventsRegistrant_Registrant_Type_DataObjectType
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_key()
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_code()
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_add_user()
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_add_date()
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_change_user()
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_change_date()
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_delete_flag()
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_key_ext()
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_entity_key()
     * @uses EventsRegistrant_Registrant_Type_DataObjectType::setRgt_guest_flag()
     * @param string $rgt_key
     * @param string $rgt_code
     * @param string $rgt_add_user
     * @param string $rgt_add_date
     * @param string $rgt_change_user
     * @param string $rgt_change_date
     * @param string $rgt_delete_flag
     * @param string $rgt_key_ext
     * @param string $rgt_entity_key
     * @param string $rgt_guest_flag
     */
    public function __construct(?string $rgt_key = null, ?string $rgt_code = null, ?string $rgt_add_user = null, ?string $rgt_add_date = null, ?string $rgt_change_user = null, ?string $rgt_change_date = null, ?string $rgt_delete_flag = null, ?string $rgt_key_ext = null, ?string $rgt_entity_key = null, ?string $rgt_guest_flag = null)
    {
        $this
            ->setRgt_key($rgt_key)
            ->setRgt_code($rgt_code)
            ->setRgt_add_user($rgt_add_user)
            ->setRgt_add_date($rgt_add_date)
            ->setRgt_change_user($rgt_change_user)
            ->setRgt_change_date($rgt_change_date)
            ->setRgt_delete_flag($rgt_delete_flag)
            ->setRgt_key_ext($rgt_key_ext)
            ->setRgt_entity_key($rgt_entity_key)
            ->setRgt_guest_flag($rgt_guest_flag);
    }
    /**
     * Get rgt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_key(): ?string
    {
        return $this->rgt_key ?? null;
    }
    /**
     * Set rgt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_key(?string $rgt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_key) && !is_string($rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_key, true), gettype($rgt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgt_key, true)), __LINE__);
        }
        if (is_null($rgt_key) || (is_array($rgt_key) && empty($rgt_key))) {
            unset($this->rgt_key);
        } else {
            $this->rgt_key = $rgt_key;
        }
        
        return $this;
    }
    /**
     * Get rgt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_code(): ?string
    {
        return $this->rgt_code ?? null;
    }
    /**
     * Set rgt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_code(?string $rgt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_code) && !is_string($rgt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_code, true), gettype($rgt_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($rgt_code) && mb_strlen((string) $rgt_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $rgt_code)), __LINE__);
        }
        if (is_null($rgt_code) || (is_array($rgt_code) && empty($rgt_code))) {
            unset($this->rgt_code);
        } else {
            $this->rgt_code = $rgt_code;
        }
        
        return $this;
    }
    /**
     * Get rgt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_add_user(): ?string
    {
        return $this->rgt_add_user ?? null;
    }
    /**
     * Set rgt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_add_user(?string $rgt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_add_user) && !is_string($rgt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_add_user, true), gettype($rgt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rgt_add_user) && mb_strlen((string) $rgt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $rgt_add_user)), __LINE__);
        }
        if (is_null($rgt_add_user) || (is_array($rgt_add_user) && empty($rgt_add_user))) {
            unset($this->rgt_add_user);
        } else {
            $this->rgt_add_user = $rgt_add_user;
        }
        
        return $this;
    }
    /**
     * Get rgt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_add_date(): ?string
    {
        return $this->rgt_add_date ?? null;
    }
    /**
     * Set rgt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_add_date(?string $rgt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_add_date) && !is_string($rgt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_add_date, true), gettype($rgt_add_date)), __LINE__);
        }
        if (is_null($rgt_add_date) || (is_array($rgt_add_date) && empty($rgt_add_date))) {
            unset($this->rgt_add_date);
        } else {
            $this->rgt_add_date = $rgt_add_date;
        }
        
        return $this;
    }
    /**
     * Get rgt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_change_user(): ?string
    {
        return $this->rgt_change_user ?? null;
    }
    /**
     * Set rgt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_change_user(?string $rgt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_change_user) && !is_string($rgt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_change_user, true), gettype($rgt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rgt_change_user) && mb_strlen((string) $rgt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $rgt_change_user)), __LINE__);
        }
        if (is_null($rgt_change_user) || (is_array($rgt_change_user) && empty($rgt_change_user))) {
            unset($this->rgt_change_user);
        } else {
            $this->rgt_change_user = $rgt_change_user;
        }
        
        return $this;
    }
    /**
     * Get rgt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_change_date(): ?string
    {
        return $this->rgt_change_date ?? null;
    }
    /**
     * Set rgt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_change_date(?string $rgt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_change_date) && !is_string($rgt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_change_date, true), gettype($rgt_change_date)), __LINE__);
        }
        if (is_null($rgt_change_date) || (is_array($rgt_change_date) && empty($rgt_change_date))) {
            unset($this->rgt_change_date);
        } else {
            $this->rgt_change_date = $rgt_change_date;
        }
        
        return $this;
    }
    /**
     * Get rgt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_delete_flag(): ?string
    {
        return $this->rgt_delete_flag ?? null;
    }
    /**
     * Set rgt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_delete_flag(?string $rgt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_delete_flag) && !is_string($rgt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_delete_flag, true), gettype($rgt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rgt_delete_flag) && $rgt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rgt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rgt_delete_flag) && $rgt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rgt_delete_flag, true)), __LINE__);
        }
        if (is_null($rgt_delete_flag) || (is_array($rgt_delete_flag) && empty($rgt_delete_flag))) {
            unset($this->rgt_delete_flag);
        } else {
            $this->rgt_delete_flag = $rgt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get rgt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_key_ext(): ?string
    {
        return $this->rgt_key_ext ?? null;
    }
    /**
     * Set rgt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_key_ext(?string $rgt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_key_ext) && !is_string($rgt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_key_ext, true), gettype($rgt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgt_key_ext, true)), __LINE__);
        }
        if (is_null($rgt_key_ext) || (is_array($rgt_key_ext) && empty($rgt_key_ext))) {
            unset($this->rgt_key_ext);
        } else {
            $this->rgt_key_ext = $rgt_key_ext;
        }
        
        return $this;
    }
    /**
     * Get rgt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_entity_key(): ?string
    {
        return $this->rgt_entity_key ?? null;
    }
    /**
     * Set rgt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_entity_key(?string $rgt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_entity_key) && !is_string($rgt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_entity_key, true), gettype($rgt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rgt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rgt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rgt_entity_key, true)), __LINE__);
        }
        if (is_null($rgt_entity_key) || (is_array($rgt_entity_key) && empty($rgt_entity_key))) {
            unset($this->rgt_entity_key);
        } else {
            $this->rgt_entity_key = $rgt_entity_key;
        }
        
        return $this;
    }
    /**
     * Get rgt_guest_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRgt_guest_flag(): ?string
    {
        return $this->rgt_guest_flag ?? null;
    }
    /**
     * Set rgt_guest_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rgt_guest_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Registrant_Type_DataObjectType
     */
    public function setRgt_guest_flag(?string $rgt_guest_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rgt_guest_flag) && !is_string($rgt_guest_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgt_guest_flag, true), gettype($rgt_guest_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rgt_guest_flag) && $rgt_guest_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rgt_guest_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rgt_guest_flag) && $rgt_guest_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rgt_guest_flag, true)), __LINE__);
        }
        if (is_null($rgt_guest_flag) || (is_array($rgt_guest_flag) && empty($rgt_guest_flag))) {
            unset($this->rgt_guest_flag);
        } else {
            $this->rgt_guest_flag = $rgt_guest_flag;
        }
        
        return $this;
    }
}
