<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsRegistrant_Room_Request_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class EventsRegistrant_Room_Request_DataObjectType extends AbstractStructBase
{
    /**
     * The rrr_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rrr_key = null;
    /**
     * The rrr_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_add_user = null;
    /**
     * The rrr_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_add_date = null;
    /**
     * The rrr_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_change_user = null;
    /**
     * The rrr_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_change_date = null;
    /**
     * The rrr_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_delete_flag = null;
    /**
     * The rrr_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rrr_key_ext = null;
    /**
     * The rrr_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Registrant. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rrr_reg_key = null;
    /**
     * The rrr_rmt_key
     * Meta information extracted from the WSDL
     * - documentation: Room Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rrr_rmt_key = null;
    /**
     * The rrr_non_smoking_flag
     * Meta information extracted from the WSDL
     * - documentation: Non Smoking. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_non_smoking_flag = null;
    /**
     * The rrr_cc_number
     * Meta information extracted from the WSDL
     * - documentation: cc number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_cc_number = null;
    /**
     * The rrr_cc_number_display
     * Meta information extracted from the WSDL
     * - documentation: cc display. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_cc_number_display = null;
    /**
     * The rrr_notes
     * Meta information extracted from the WSDL
     * - documentation: notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 400
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_notes = null;
    /**
     * The rrr_ert_evl_key
     * Meta information extracted from the WSDL
     * - documentation: Location. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rrr_ert_evl_key = null;
    /**
     * The rrr_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rrr_entity_key = null;
    /**
     * The rrr_date
     * Meta information extracted from the WSDL
     * - documentation: Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $rrr_date = null;
    /**
     * The rrr_erb_key
     * Meta information extracted from the WSDL
     * - documentation: Room Assigned. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rrr_erb_key = null;
    /**
     * The rrr_evh_key
     * Meta information extracted from the WSDL
     * - documentation: Registrant Housing/Travel. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $rrr_evh_key = null;
    /**
     * Constructor method for EventsRegistrant_Room_Request_DataObjectType
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_key()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_add_user()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_add_date()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_change_user()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_change_date()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_delete_flag()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_key_ext()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_reg_key()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_rmt_key()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_non_smoking_flag()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_cc_number()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_cc_number_display()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_notes()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_ert_evl_key()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_entity_key()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_date()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_erb_key()
     * @uses EventsRegistrant_Room_Request_DataObjectType::setRrr_evh_key()
     * @param string $rrr_key
     * @param string $rrr_add_user
     * @param string $rrr_add_date
     * @param string $rrr_change_user
     * @param string $rrr_change_date
     * @param string $rrr_delete_flag
     * @param string $rrr_key_ext
     * @param string $rrr_reg_key
     * @param string $rrr_rmt_key
     * @param string $rrr_non_smoking_flag
     * @param string $rrr_cc_number
     * @param string $rrr_cc_number_display
     * @param string $rrr_notes
     * @param string $rrr_ert_evl_key
     * @param string $rrr_entity_key
     * @param string $rrr_date
     * @param string $rrr_erb_key
     * @param string $rrr_evh_key
     */
    public function __construct(?string $rrr_key = null, ?string $rrr_add_user = null, ?string $rrr_add_date = null, ?string $rrr_change_user = null, ?string $rrr_change_date = null, ?string $rrr_delete_flag = null, ?string $rrr_key_ext = null, ?string $rrr_reg_key = null, ?string $rrr_rmt_key = null, ?string $rrr_non_smoking_flag = null, ?string $rrr_cc_number = null, ?string $rrr_cc_number_display = null, ?string $rrr_notes = null, ?string $rrr_ert_evl_key = null, ?string $rrr_entity_key = null, ?string $rrr_date = null, ?string $rrr_erb_key = null, ?string $rrr_evh_key = null)
    {
        $this
            ->setRrr_key($rrr_key)
            ->setRrr_add_user($rrr_add_user)
            ->setRrr_add_date($rrr_add_date)
            ->setRrr_change_user($rrr_change_user)
            ->setRrr_change_date($rrr_change_date)
            ->setRrr_delete_flag($rrr_delete_flag)
            ->setRrr_key_ext($rrr_key_ext)
            ->setRrr_reg_key($rrr_reg_key)
            ->setRrr_rmt_key($rrr_rmt_key)
            ->setRrr_non_smoking_flag($rrr_non_smoking_flag)
            ->setRrr_cc_number($rrr_cc_number)
            ->setRrr_cc_number_display($rrr_cc_number_display)
            ->setRrr_notes($rrr_notes)
            ->setRrr_ert_evl_key($rrr_ert_evl_key)
            ->setRrr_entity_key($rrr_entity_key)
            ->setRrr_date($rrr_date)
            ->setRrr_erb_key($rrr_erb_key)
            ->setRrr_evh_key($rrr_evh_key);
    }
    /**
     * Get rrr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_key(): ?string
    {
        return $this->rrr_key ?? null;
    }
    /**
     * Set rrr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_key(?string $rrr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_key) && !is_string($rrr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_key, true), gettype($rrr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rrr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rrr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rrr_key, true)), __LINE__);
        }
        if (is_null($rrr_key) || (is_array($rrr_key) && empty($rrr_key))) {
            unset($this->rrr_key);
        } else {
            $this->rrr_key = $rrr_key;
        }
        
        return $this;
    }
    /**
     * Get rrr_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_add_user(): ?string
    {
        return $this->rrr_add_user ?? null;
    }
    /**
     * Set rrr_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_add_user(?string $rrr_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_add_user) && !is_string($rrr_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_add_user, true), gettype($rrr_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rrr_add_user) && mb_strlen((string) $rrr_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $rrr_add_user)), __LINE__);
        }
        if (is_null($rrr_add_user) || (is_array($rrr_add_user) && empty($rrr_add_user))) {
            unset($this->rrr_add_user);
        } else {
            $this->rrr_add_user = $rrr_add_user;
        }
        
        return $this;
    }
    /**
     * Get rrr_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_add_date(): ?string
    {
        return $this->rrr_add_date ?? null;
    }
    /**
     * Set rrr_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_add_date(?string $rrr_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_add_date) && !is_string($rrr_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_add_date, true), gettype($rrr_add_date)), __LINE__);
        }
        if (is_null($rrr_add_date) || (is_array($rrr_add_date) && empty($rrr_add_date))) {
            unset($this->rrr_add_date);
        } else {
            $this->rrr_add_date = $rrr_add_date;
        }
        
        return $this;
    }
    /**
     * Get rrr_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_change_user(): ?string
    {
        return $this->rrr_change_user ?? null;
    }
    /**
     * Set rrr_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_change_user(?string $rrr_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_change_user) && !is_string($rrr_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_change_user, true), gettype($rrr_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($rrr_change_user) && mb_strlen((string) $rrr_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $rrr_change_user)), __LINE__);
        }
        if (is_null($rrr_change_user) || (is_array($rrr_change_user) && empty($rrr_change_user))) {
            unset($this->rrr_change_user);
        } else {
            $this->rrr_change_user = $rrr_change_user;
        }
        
        return $this;
    }
    /**
     * Get rrr_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_change_date(): ?string
    {
        return $this->rrr_change_date ?? null;
    }
    /**
     * Set rrr_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_change_date(?string $rrr_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_change_date) && !is_string($rrr_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_change_date, true), gettype($rrr_change_date)), __LINE__);
        }
        if (is_null($rrr_change_date) || (is_array($rrr_change_date) && empty($rrr_change_date))) {
            unset($this->rrr_change_date);
        } else {
            $this->rrr_change_date = $rrr_change_date;
        }
        
        return $this;
    }
    /**
     * Get rrr_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_delete_flag(): ?string
    {
        return $this->rrr_delete_flag ?? null;
    }
    /**
     * Set rrr_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_delete_flag(?string $rrr_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_delete_flag) && !is_string($rrr_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_delete_flag, true), gettype($rrr_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rrr_delete_flag) && $rrr_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rrr_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rrr_delete_flag) && $rrr_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rrr_delete_flag, true)), __LINE__);
        }
        if (is_null($rrr_delete_flag) || (is_array($rrr_delete_flag) && empty($rrr_delete_flag))) {
            unset($this->rrr_delete_flag);
        } else {
            $this->rrr_delete_flag = $rrr_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get rrr_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_key_ext(): ?string
    {
        return $this->rrr_key_ext ?? null;
    }
    /**
     * Set rrr_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_key_ext(?string $rrr_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_key_ext) && !is_string($rrr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_key_ext, true), gettype($rrr_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rrr_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rrr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rrr_key_ext, true)), __LINE__);
        }
        if (is_null($rrr_key_ext) || (is_array($rrr_key_ext) && empty($rrr_key_ext))) {
            unset($this->rrr_key_ext);
        } else {
            $this->rrr_key_ext = $rrr_key_ext;
        }
        
        return $this;
    }
    /**
     * Get rrr_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_reg_key(): ?string
    {
        return $this->rrr_reg_key ?? null;
    }
    /**
     * Set rrr_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_reg_key(?string $rrr_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_reg_key) && !is_string($rrr_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_reg_key, true), gettype($rrr_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rrr_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rrr_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rrr_reg_key, true)), __LINE__);
        }
        if (is_null($rrr_reg_key) || (is_array($rrr_reg_key) && empty($rrr_reg_key))) {
            unset($this->rrr_reg_key);
        } else {
            $this->rrr_reg_key = $rrr_reg_key;
        }
        
        return $this;
    }
    /**
     * Get rrr_rmt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_rmt_key(): ?string
    {
        return $this->rrr_rmt_key ?? null;
    }
    /**
     * Set rrr_rmt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_rmt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_rmt_key(?string $rrr_rmt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_rmt_key) && !is_string($rrr_rmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_rmt_key, true), gettype($rrr_rmt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rrr_rmt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rrr_rmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rrr_rmt_key, true)), __LINE__);
        }
        if (is_null($rrr_rmt_key) || (is_array($rrr_rmt_key) && empty($rrr_rmt_key))) {
            unset($this->rrr_rmt_key);
        } else {
            $this->rrr_rmt_key = $rrr_rmt_key;
        }
        
        return $this;
    }
    /**
     * Get rrr_non_smoking_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_non_smoking_flag(): ?string
    {
        return $this->rrr_non_smoking_flag ?? null;
    }
    /**
     * Set rrr_non_smoking_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_non_smoking_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_non_smoking_flag(?string $rrr_non_smoking_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_non_smoking_flag) && !is_string($rrr_non_smoking_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_non_smoking_flag, true), gettype($rrr_non_smoking_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($rrr_non_smoking_flag) && $rrr_non_smoking_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($rrr_non_smoking_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rrr_non_smoking_flag) && $rrr_non_smoking_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rrr_non_smoking_flag, true)), __LINE__);
        }
        if (is_null($rrr_non_smoking_flag) || (is_array($rrr_non_smoking_flag) && empty($rrr_non_smoking_flag))) {
            unset($this->rrr_non_smoking_flag);
        } else {
            $this->rrr_non_smoking_flag = $rrr_non_smoking_flag;
        }
        
        return $this;
    }
    /**
     * Get rrr_cc_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_cc_number(): ?string
    {
        return $this->rrr_cc_number ?? null;
    }
    /**
     * Set rrr_cc_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_cc_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_cc_number(?string $rrr_cc_number = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_cc_number) && !is_string($rrr_cc_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_cc_number, true), gettype($rrr_cc_number)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($rrr_cc_number) && mb_strlen((string) $rrr_cc_number) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $rrr_cc_number)), __LINE__);
        }
        if (is_null($rrr_cc_number) || (is_array($rrr_cc_number) && empty($rrr_cc_number))) {
            unset($this->rrr_cc_number);
        } else {
            $this->rrr_cc_number = $rrr_cc_number;
        }
        
        return $this;
    }
    /**
     * Get rrr_cc_number_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_cc_number_display(): ?string
    {
        return $this->rrr_cc_number_display ?? null;
    }
    /**
     * Set rrr_cc_number_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_cc_number_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_cc_number_display(?string $rrr_cc_number_display = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_cc_number_display) && !is_string($rrr_cc_number_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_cc_number_display, true), gettype($rrr_cc_number_display)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($rrr_cc_number_display) && mb_strlen((string) $rrr_cc_number_display) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $rrr_cc_number_display)), __LINE__);
        }
        if (is_null($rrr_cc_number_display) || (is_array($rrr_cc_number_display) && empty($rrr_cc_number_display))) {
            unset($this->rrr_cc_number_display);
        } else {
            $this->rrr_cc_number_display = $rrr_cc_number_display;
        }
        
        return $this;
    }
    /**
     * Get rrr_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_notes(): ?string
    {
        return $this->rrr_notes ?? null;
    }
    /**
     * Set rrr_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_notes(?string $rrr_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_notes) && !is_string($rrr_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_notes, true), gettype($rrr_notes)), __LINE__);
        }
        // validation for constraint: maxLength(400)
        if (!is_null($rrr_notes) && mb_strlen((string) $rrr_notes) > 400) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 400', mb_strlen((string) $rrr_notes)), __LINE__);
        }
        if (is_null($rrr_notes) || (is_array($rrr_notes) && empty($rrr_notes))) {
            unset($this->rrr_notes);
        } else {
            $this->rrr_notes = $rrr_notes;
        }
        
        return $this;
    }
    /**
     * Get rrr_ert_evl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_ert_evl_key(): ?string
    {
        return $this->rrr_ert_evl_key ?? null;
    }
    /**
     * Set rrr_ert_evl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_ert_evl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_ert_evl_key(?string $rrr_ert_evl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_ert_evl_key) && !is_string($rrr_ert_evl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_ert_evl_key, true), gettype($rrr_ert_evl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rrr_ert_evl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rrr_ert_evl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rrr_ert_evl_key, true)), __LINE__);
        }
        if (is_null($rrr_ert_evl_key) || (is_array($rrr_ert_evl_key) && empty($rrr_ert_evl_key))) {
            unset($this->rrr_ert_evl_key);
        } else {
            $this->rrr_ert_evl_key = $rrr_ert_evl_key;
        }
        
        return $this;
    }
    /**
     * Get rrr_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_entity_key(): ?string
    {
        return $this->rrr_entity_key ?? null;
    }
    /**
     * Set rrr_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_entity_key(?string $rrr_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_entity_key) && !is_string($rrr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_entity_key, true), gettype($rrr_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rrr_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rrr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rrr_entity_key, true)), __LINE__);
        }
        if (is_null($rrr_entity_key) || (is_array($rrr_entity_key) && empty($rrr_entity_key))) {
            unset($this->rrr_entity_key);
        } else {
            $this->rrr_entity_key = $rrr_entity_key;
        }
        
        return $this;
    }
    /**
     * Get rrr_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_date(): ?string
    {
        return $this->rrr_date ?? null;
    }
    /**
     * Set rrr_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_date(?string $rrr_date = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_date) && !is_string($rrr_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_date, true), gettype($rrr_date)), __LINE__);
        }
        if (is_null($rrr_date) || (is_array($rrr_date) && empty($rrr_date))) {
            unset($this->rrr_date);
        } else {
            $this->rrr_date = $rrr_date;
        }
        
        return $this;
    }
    /**
     * Get rrr_erb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_erb_key(): ?string
    {
        return $this->rrr_erb_key ?? null;
    }
    /**
     * Set rrr_erb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_erb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_erb_key(?string $rrr_erb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_erb_key) && !is_string($rrr_erb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_erb_key, true), gettype($rrr_erb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rrr_erb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rrr_erb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rrr_erb_key, true)), __LINE__);
        }
        if (is_null($rrr_erb_key) || (is_array($rrr_erb_key) && empty($rrr_erb_key))) {
            unset($this->rrr_erb_key);
        } else {
            $this->rrr_erb_key = $rrr_erb_key;
        }
        
        return $this;
    }
    /**
     * Get rrr_evh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRrr_evh_key(): ?string
    {
        return $this->rrr_evh_key ?? null;
    }
    /**
     * Set rrr_evh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rrr_evh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrant_Room_Request_DataObjectType
     */
    public function setRrr_evh_key(?string $rrr_evh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($rrr_evh_key) && !is_string($rrr_evh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rrr_evh_key, true), gettype($rrr_evh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($rrr_evh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $rrr_evh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($rrr_evh_key, true)), __LINE__);
        }
        if (is_null($rrr_evh_key) || (is_array($rrr_evh_key) && empty($rrr_evh_key))) {
            unset($this->rrr_evh_key);
        } else {
            $this->rrr_evh_key = $rrr_evh_key;
        }
        
        return $this;
    }
}
