<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorBoothNew_Exhibit_Show_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorBoothNew_Exhibit_Show_DataObjectType extends AbstractStructBase
{
    /**
     * The exb_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exb_key = null;
    /**
     * The exb_evt_key
     * Meta information extracted from the WSDL
     * - documentation: Event. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exb_evt_key = null;
    /**
     * The exb_code
     * Meta information extracted from the WSDL
     * - documentation: Exhibit Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_code = null;
    /**
     * The exb_name
     * Meta information extracted from the WSDL
     * - documentation: Exhibit Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_name = null;
    /**
     * The exb_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_start_date = null;
    /**
     * The exb_start_time
     * Meta information extracted from the WSDL
     * - documentation: Start Time. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_start_time = null;
    /**
     * The exb_end_date
     * Meta information extracted from the WSDL
     * - documentation: End date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_end_date = null;
    /**
     * The exb_end_time
     * Meta information extracted from the WSDL
     * - documentation: End time. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_end_time = null;
    /**
     * The exb_short_description
     * Meta information extracted from the WSDL
     * - documentation: Short description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 400
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_short_description = null;
    /**
     * The exb_description_html
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_description_html = null;
    /**
     * The exb_cutoff_date
     * Meta information extracted from the WSDL
     * - documentation: Cut-Off Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_cutoff_date = null;
    /**
     * The exb_post_to_web_date
     * Meta information extracted from the WSDL
     * - documentation: Post to web date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_post_to_web_date = null;
    /**
     * The exb_remove_from_web_date
     * Meta information extracted from the WSDL
     * - documentation: remove from web date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_remove_from_web_date = null;
    /**
     * The exb_exhibit_url
     * Meta information extracted from the WSDL
     * - documentation: Exhibit URL. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_exhibit_url = null;
    /**
     * The exb_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_add_user = null;
    /**
     * The exb_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_add_date = null;
    /**
     * The exb_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_change_user = null;
    /**
     * The exb_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_change_date = null;
    /**
     * The exb_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_delete_flag = null;
    /**
     * The exb_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exb_key_ext = null;
    /**
     * The exb_ppg_key
     * Meta information extracted from the WSDL
     * - documentation: priority point group. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exb_ppg_key = null;
    /**
     * The exb_years_priority_point
     * Meta information extracted from the WSDL
     * - documentation: priority points calculation du. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $exb_years_priority_point = null;
    /**
     * The exb_comp_registrations
     * Meta information extracted from the WSDL
     * - documentation: comp registrations. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $exb_comp_registrations = null;
    /**
     * The exb_total_square_footage
     * Meta information extracted from the WSDL
     * - documentation: total square footage. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $exb_total_square_footage = null;
    /**
     * The exb_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exb_entity_key = null;
    /**
     * The exb_date_format
     * Meta information extracted from the WSDL
     * - documentation: date format. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_date_format = null;
    /**
     * The exb_pre_registration_date
     * Meta information extracted from the WSDL
     * - documentation: pre-registration cutoff date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_pre_registration_date = null;
    /**
     * The exb_early_registration_date
     * Meta information extracted from the WSDL
     * - documentation: early registration date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_early_registration_date = null;
    /**
     * The exb_late_registration_date
     * Meta information extracted from the WSDL
     * - documentation: late registration date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_late_registration_date = null;
    /**
     * The exb_tzn_key
     * Meta information extracted from the WSDL
     * - documentation: time zone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exb_tzn_key = null;
    /**
     * The exb_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: wait list?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_wait_list_flag = null;
    /**
     * The exb_allow_installment
     * Meta information extracted from the WSDL
     * - documentation: allows installment. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_allow_installment = null;
    /**
     * The exb_booth_fee_type
     * Meta information extracted from the WSDL
     * - documentation: Booth Fee Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_booth_fee_type = null;
    /**
     * The exb_company_file
     * Meta information extracted from the WSDL
     * - documentation: Expocad Company File. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_company_file = null;
    /**
     * The exb_booth_file
     * Meta information extracted from the WSDL
     * - documentation: Expocad Booth File. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exb_booth_file = null;
    /**
     * Constructor method for ExhibitorBoothNew_Exhibit_Show_DataObjectType
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_key()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_evt_key()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_code()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_name()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_start_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_start_time()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_end_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_end_time()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_short_description()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_description_html()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_cutoff_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_post_to_web_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_remove_from_web_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_exhibit_url()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_add_user()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_add_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_change_user()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_change_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_delete_flag()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_key_ext()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_ppg_key()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_years_priority_point()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_comp_registrations()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_total_square_footage()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_entity_key()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_date_format()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_pre_registration_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_early_registration_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_late_registration_date()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_tzn_key()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_wait_list_flag()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_allow_installment()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_booth_fee_type()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_company_file()
     * @uses ExhibitorBoothNew_Exhibit_Show_DataObjectType::setExb_booth_file()
     * @param string $exb_key
     * @param string $exb_evt_key
     * @param string $exb_code
     * @param string $exb_name
     * @param string $exb_start_date
     * @param string $exb_start_time
     * @param string $exb_end_date
     * @param string $exb_end_time
     * @param string $exb_short_description
     * @param string $exb_description_html
     * @param string $exb_cutoff_date
     * @param string $exb_post_to_web_date
     * @param string $exb_remove_from_web_date
     * @param string $exb_exhibit_url
     * @param string $exb_add_user
     * @param string $exb_add_date
     * @param string $exb_change_user
     * @param string $exb_change_date
     * @param string $exb_delete_flag
     * @param string $exb_key_ext
     * @param string $exb_ppg_key
     * @param int $exb_years_priority_point
     * @param int $exb_comp_registrations
     * @param int $exb_total_square_footage
     * @param string $exb_entity_key
     * @param string $exb_date_format
     * @param string $exb_pre_registration_date
     * @param string $exb_early_registration_date
     * @param string $exb_late_registration_date
     * @param string $exb_tzn_key
     * @param string $exb_wait_list_flag
     * @param string $exb_allow_installment
     * @param string $exb_booth_fee_type
     * @param string $exb_company_file
     * @param string $exb_booth_file
     */
    public function __construct(?string $exb_key = null, ?string $exb_evt_key = null, ?string $exb_code = null, ?string $exb_name = null, ?string $exb_start_date = null, ?string $exb_start_time = null, ?string $exb_end_date = null, ?string $exb_end_time = null, ?string $exb_short_description = null, ?string $exb_description_html = null, ?string $exb_cutoff_date = null, ?string $exb_post_to_web_date = null, ?string $exb_remove_from_web_date = null, ?string $exb_exhibit_url = null, ?string $exb_add_user = null, ?string $exb_add_date = null, ?string $exb_change_user = null, ?string $exb_change_date = null, ?string $exb_delete_flag = null, ?string $exb_key_ext = null, ?string $exb_ppg_key = null, ?int $exb_years_priority_point = null, ?int $exb_comp_registrations = null, ?int $exb_total_square_footage = null, ?string $exb_entity_key = null, ?string $exb_date_format = null, ?string $exb_pre_registration_date = null, ?string $exb_early_registration_date = null, ?string $exb_late_registration_date = null, ?string $exb_tzn_key = null, ?string $exb_wait_list_flag = null, ?string $exb_allow_installment = null, ?string $exb_booth_fee_type = null, ?string $exb_company_file = null, ?string $exb_booth_file = null)
    {
        $this
            ->setExb_key($exb_key)
            ->setExb_evt_key($exb_evt_key)
            ->setExb_code($exb_code)
            ->setExb_name($exb_name)
            ->setExb_start_date($exb_start_date)
            ->setExb_start_time($exb_start_time)
            ->setExb_end_date($exb_end_date)
            ->setExb_end_time($exb_end_time)
            ->setExb_short_description($exb_short_description)
            ->setExb_description_html($exb_description_html)
            ->setExb_cutoff_date($exb_cutoff_date)
            ->setExb_post_to_web_date($exb_post_to_web_date)
            ->setExb_remove_from_web_date($exb_remove_from_web_date)
            ->setExb_exhibit_url($exb_exhibit_url)
            ->setExb_add_user($exb_add_user)
            ->setExb_add_date($exb_add_date)
            ->setExb_change_user($exb_change_user)
            ->setExb_change_date($exb_change_date)
            ->setExb_delete_flag($exb_delete_flag)
            ->setExb_key_ext($exb_key_ext)
            ->setExb_ppg_key($exb_ppg_key)
            ->setExb_years_priority_point($exb_years_priority_point)
            ->setExb_comp_registrations($exb_comp_registrations)
            ->setExb_total_square_footage($exb_total_square_footage)
            ->setExb_entity_key($exb_entity_key)
            ->setExb_date_format($exb_date_format)
            ->setExb_pre_registration_date($exb_pre_registration_date)
            ->setExb_early_registration_date($exb_early_registration_date)
            ->setExb_late_registration_date($exb_late_registration_date)
            ->setExb_tzn_key($exb_tzn_key)
            ->setExb_wait_list_flag($exb_wait_list_flag)
            ->setExb_allow_installment($exb_allow_installment)
            ->setExb_booth_fee_type($exb_booth_fee_type)
            ->setExb_company_file($exb_company_file)
            ->setExb_booth_file($exb_booth_file);
    }
    /**
     * Get exb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_key(): ?string
    {
        return $this->exb_key ?? null;
    }
    /**
     * Set exb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_key(?string $exb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_key) && !is_string($exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_key, true), gettype($exb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exb_key, true)), __LINE__);
        }
        if (is_null($exb_key) || (is_array($exb_key) && empty($exb_key))) {
            unset($this->exb_key);
        } else {
            $this->exb_key = $exb_key;
        }
        
        return $this;
    }
    /**
     * Get exb_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_evt_key(): ?string
    {
        return $this->exb_evt_key ?? null;
    }
    /**
     * Set exb_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_evt_key(?string $exb_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_evt_key) && !is_string($exb_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_evt_key, true), gettype($exb_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exb_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exb_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exb_evt_key, true)), __LINE__);
        }
        if (is_null($exb_evt_key) || (is_array($exb_evt_key) && empty($exb_evt_key))) {
            unset($this->exb_evt_key);
        } else {
            $this->exb_evt_key = $exb_evt_key;
        }
        
        return $this;
    }
    /**
     * Get exb_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_code(): ?string
    {
        return $this->exb_code ?? null;
    }
    /**
     * Set exb_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_code(?string $exb_code = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_code) && !is_string($exb_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_code, true), gettype($exb_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($exb_code) && mb_strlen((string) $exb_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $exb_code)), __LINE__);
        }
        if (is_null($exb_code) || (is_array($exb_code) && empty($exb_code))) {
            unset($this->exb_code);
        } else {
            $this->exb_code = $exb_code;
        }
        
        return $this;
    }
    /**
     * Get exb_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_name(): ?string
    {
        return $this->exb_name ?? null;
    }
    /**
     * Set exb_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_name(?string $exb_name = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_name) && !is_string($exb_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_name, true), gettype($exb_name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($exb_name) && mb_strlen((string) $exb_name) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $exb_name)), __LINE__);
        }
        if (is_null($exb_name) || (is_array($exb_name) && empty($exb_name))) {
            unset($this->exb_name);
        } else {
            $this->exb_name = $exb_name;
        }
        
        return $this;
    }
    /**
     * Get exb_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_start_date(): ?string
    {
        return $this->exb_start_date ?? null;
    }
    /**
     * Set exb_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_start_date(?string $exb_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_start_date) && !is_string($exb_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_start_date, true), gettype($exb_start_date)), __LINE__);
        }
        if (is_null($exb_start_date) || (is_array($exb_start_date) && empty($exb_start_date))) {
            unset($this->exb_start_date);
        } else {
            $this->exb_start_date = $exb_start_date;
        }
        
        return $this;
    }
    /**
     * Get exb_start_time value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_start_time(): ?string
    {
        return $this->exb_start_time ?? null;
    }
    /**
     * Set exb_start_time value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_start_time
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_start_time(?string $exb_start_time = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_start_time) && !is_string($exb_start_time)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_start_time, true), gettype($exb_start_time)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($exb_start_time) && mb_strlen((string) $exb_start_time) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $exb_start_time)), __LINE__);
        }
        if (is_null($exb_start_time) || (is_array($exb_start_time) && empty($exb_start_time))) {
            unset($this->exb_start_time);
        } else {
            $this->exb_start_time = $exb_start_time;
        }
        
        return $this;
    }
    /**
     * Get exb_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_end_date(): ?string
    {
        return $this->exb_end_date ?? null;
    }
    /**
     * Set exb_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_end_date(?string $exb_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_end_date) && !is_string($exb_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_end_date, true), gettype($exb_end_date)), __LINE__);
        }
        if (is_null($exb_end_date) || (is_array($exb_end_date) && empty($exb_end_date))) {
            unset($this->exb_end_date);
        } else {
            $this->exb_end_date = $exb_end_date;
        }
        
        return $this;
    }
    /**
     * Get exb_end_time value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_end_time(): ?string
    {
        return $this->exb_end_time ?? null;
    }
    /**
     * Set exb_end_time value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_end_time
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_end_time(?string $exb_end_time = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_end_time) && !is_string($exb_end_time)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_end_time, true), gettype($exb_end_time)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($exb_end_time) && mb_strlen((string) $exb_end_time) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $exb_end_time)), __LINE__);
        }
        if (is_null($exb_end_time) || (is_array($exb_end_time) && empty($exb_end_time))) {
            unset($this->exb_end_time);
        } else {
            $this->exb_end_time = $exb_end_time;
        }
        
        return $this;
    }
    /**
     * Get exb_short_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_short_description(): ?string
    {
        return $this->exb_short_description ?? null;
    }
    /**
     * Set exb_short_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_short_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_short_description(?string $exb_short_description = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_short_description) && !is_string($exb_short_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_short_description, true), gettype($exb_short_description)), __LINE__);
        }
        // validation for constraint: maxLength(400)
        if (!is_null($exb_short_description) && mb_strlen((string) $exb_short_description) > 400) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 400', mb_strlen((string) $exb_short_description)), __LINE__);
        }
        if (is_null($exb_short_description) || (is_array($exb_short_description) && empty($exb_short_description))) {
            unset($this->exb_short_description);
        } else {
            $this->exb_short_description = $exb_short_description;
        }
        
        return $this;
    }
    /**
     * Get exb_description_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_description_html(): ?string
    {
        return $this->exb_description_html ?? null;
    }
    /**
     * Set exb_description_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_description_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_description_html(?string $exb_description_html = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_description_html) && !is_string($exb_description_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_description_html, true), gettype($exb_description_html)), __LINE__);
        }
        if (is_null($exb_description_html) || (is_array($exb_description_html) && empty($exb_description_html))) {
            unset($this->exb_description_html);
        } else {
            $this->exb_description_html = $exb_description_html;
        }
        
        return $this;
    }
    /**
     * Get exb_cutoff_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_cutoff_date(): ?string
    {
        return $this->exb_cutoff_date ?? null;
    }
    /**
     * Set exb_cutoff_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_cutoff_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_cutoff_date(?string $exb_cutoff_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_cutoff_date) && !is_string($exb_cutoff_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_cutoff_date, true), gettype($exb_cutoff_date)), __LINE__);
        }
        if (is_null($exb_cutoff_date) || (is_array($exb_cutoff_date) && empty($exb_cutoff_date))) {
            unset($this->exb_cutoff_date);
        } else {
            $this->exb_cutoff_date = $exb_cutoff_date;
        }
        
        return $this;
    }
    /**
     * Get exb_post_to_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_post_to_web_date(): ?string
    {
        return $this->exb_post_to_web_date ?? null;
    }
    /**
     * Set exb_post_to_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_post_to_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_post_to_web_date(?string $exb_post_to_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_post_to_web_date) && !is_string($exb_post_to_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_post_to_web_date, true), gettype($exb_post_to_web_date)), __LINE__);
        }
        if (is_null($exb_post_to_web_date) || (is_array($exb_post_to_web_date) && empty($exb_post_to_web_date))) {
            unset($this->exb_post_to_web_date);
        } else {
            $this->exb_post_to_web_date = $exb_post_to_web_date;
        }
        
        return $this;
    }
    /**
     * Get exb_remove_from_web_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_remove_from_web_date(): ?string
    {
        return $this->exb_remove_from_web_date ?? null;
    }
    /**
     * Set exb_remove_from_web_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_remove_from_web_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_remove_from_web_date(?string $exb_remove_from_web_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_remove_from_web_date) && !is_string($exb_remove_from_web_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_remove_from_web_date, true), gettype($exb_remove_from_web_date)), __LINE__);
        }
        if (is_null($exb_remove_from_web_date) || (is_array($exb_remove_from_web_date) && empty($exb_remove_from_web_date))) {
            unset($this->exb_remove_from_web_date);
        } else {
            $this->exb_remove_from_web_date = $exb_remove_from_web_date;
        }
        
        return $this;
    }
    /**
     * Get exb_exhibit_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_exhibit_url(): ?string
    {
        return $this->exb_exhibit_url ?? null;
    }
    /**
     * Set exb_exhibit_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_exhibit_url
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_exhibit_url(?string $exb_exhibit_url = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_exhibit_url) && !is_string($exb_exhibit_url)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_exhibit_url, true), gettype($exb_exhibit_url)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($exb_exhibit_url) && mb_strlen((string) $exb_exhibit_url) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $exb_exhibit_url)), __LINE__);
        }
        if (is_null($exb_exhibit_url) || (is_array($exb_exhibit_url) && empty($exb_exhibit_url))) {
            unset($this->exb_exhibit_url);
        } else {
            $this->exb_exhibit_url = $exb_exhibit_url;
        }
        
        return $this;
    }
    /**
     * Get exb_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_add_user(): ?string
    {
        return $this->exb_add_user ?? null;
    }
    /**
     * Set exb_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_add_user(?string $exb_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_add_user) && !is_string($exb_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_add_user, true), gettype($exb_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($exb_add_user) && mb_strlen((string) $exb_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $exb_add_user)), __LINE__);
        }
        if (is_null($exb_add_user) || (is_array($exb_add_user) && empty($exb_add_user))) {
            unset($this->exb_add_user);
        } else {
            $this->exb_add_user = $exb_add_user;
        }
        
        return $this;
    }
    /**
     * Get exb_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_add_date(): ?string
    {
        return $this->exb_add_date ?? null;
    }
    /**
     * Set exb_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_add_date(?string $exb_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_add_date) && !is_string($exb_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_add_date, true), gettype($exb_add_date)), __LINE__);
        }
        if (is_null($exb_add_date) || (is_array($exb_add_date) && empty($exb_add_date))) {
            unset($this->exb_add_date);
        } else {
            $this->exb_add_date = $exb_add_date;
        }
        
        return $this;
    }
    /**
     * Get exb_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_change_user(): ?string
    {
        return $this->exb_change_user ?? null;
    }
    /**
     * Set exb_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_change_user(?string $exb_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_change_user) && !is_string($exb_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_change_user, true), gettype($exb_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($exb_change_user) && mb_strlen((string) $exb_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $exb_change_user)), __LINE__);
        }
        if (is_null($exb_change_user) || (is_array($exb_change_user) && empty($exb_change_user))) {
            unset($this->exb_change_user);
        } else {
            $this->exb_change_user = $exb_change_user;
        }
        
        return $this;
    }
    /**
     * Get exb_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_change_date(): ?string
    {
        return $this->exb_change_date ?? null;
    }
    /**
     * Set exb_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_change_date(?string $exb_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_change_date) && !is_string($exb_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_change_date, true), gettype($exb_change_date)), __LINE__);
        }
        if (is_null($exb_change_date) || (is_array($exb_change_date) && empty($exb_change_date))) {
            unset($this->exb_change_date);
        } else {
            $this->exb_change_date = $exb_change_date;
        }
        
        return $this;
    }
    /**
     * Get exb_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_delete_flag(): ?string
    {
        return $this->exb_delete_flag ?? null;
    }
    /**
     * Set exb_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_delete_flag(?string $exb_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_delete_flag) && !is_string($exb_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_delete_flag, true), gettype($exb_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exb_delete_flag) && $exb_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exb_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exb_delete_flag) && $exb_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exb_delete_flag, true)), __LINE__);
        }
        if (is_null($exb_delete_flag) || (is_array($exb_delete_flag) && empty($exb_delete_flag))) {
            unset($this->exb_delete_flag);
        } else {
            $this->exb_delete_flag = $exb_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get exb_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_key_ext(): ?string
    {
        return $this->exb_key_ext ?? null;
    }
    /**
     * Set exb_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_key_ext(?string $exb_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_key_ext) && !is_string($exb_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_key_ext, true), gettype($exb_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exb_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exb_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exb_key_ext, true)), __LINE__);
        }
        if (is_null($exb_key_ext) || (is_array($exb_key_ext) && empty($exb_key_ext))) {
            unset($this->exb_key_ext);
        } else {
            $this->exb_key_ext = $exb_key_ext;
        }
        
        return $this;
    }
    /**
     * Get exb_ppg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_ppg_key(): ?string
    {
        return $this->exb_ppg_key ?? null;
    }
    /**
     * Set exb_ppg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_ppg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_ppg_key(?string $exb_ppg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_ppg_key) && !is_string($exb_ppg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_ppg_key, true), gettype($exb_ppg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exb_ppg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exb_ppg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exb_ppg_key, true)), __LINE__);
        }
        if (is_null($exb_ppg_key) || (is_array($exb_ppg_key) && empty($exb_ppg_key))) {
            unset($this->exb_ppg_key);
        } else {
            $this->exb_ppg_key = $exb_ppg_key;
        }
        
        return $this;
    }
    /**
     * Get exb_years_priority_point value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExb_years_priority_point(): ?int
    {
        return $this->exb_years_priority_point ?? null;
    }
    /**
     * Set exb_years_priority_point value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $exb_years_priority_point
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_years_priority_point(?int $exb_years_priority_point = null): self
    {
        // validation for constraint: int
        if (!is_null($exb_years_priority_point) && !(is_int($exb_years_priority_point) || ctype_digit($exb_years_priority_point))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exb_years_priority_point, true), gettype($exb_years_priority_point)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($exb_years_priority_point) && $exb_years_priority_point > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($exb_years_priority_point, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($exb_years_priority_point) && $exb_years_priority_point < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($exb_years_priority_point, true)), __LINE__);
        }
        if (is_null($exb_years_priority_point) || (is_array($exb_years_priority_point) && empty($exb_years_priority_point))) {
            unset($this->exb_years_priority_point);
        } else {
            $this->exb_years_priority_point = $exb_years_priority_point;
        }
        
        return $this;
    }
    /**
     * Get exb_comp_registrations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExb_comp_registrations(): ?int
    {
        return $this->exb_comp_registrations ?? null;
    }
    /**
     * Set exb_comp_registrations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $exb_comp_registrations
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_comp_registrations(?int $exb_comp_registrations = null): self
    {
        // validation for constraint: int
        if (!is_null($exb_comp_registrations) && !(is_int($exb_comp_registrations) || ctype_digit($exb_comp_registrations))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exb_comp_registrations, true), gettype($exb_comp_registrations)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($exb_comp_registrations) && $exb_comp_registrations > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($exb_comp_registrations, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($exb_comp_registrations) && $exb_comp_registrations < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($exb_comp_registrations, true)), __LINE__);
        }
        if (is_null($exb_comp_registrations) || (is_array($exb_comp_registrations) && empty($exb_comp_registrations))) {
            unset($this->exb_comp_registrations);
        } else {
            $this->exb_comp_registrations = $exb_comp_registrations;
        }
        
        return $this;
    }
    /**
     * Get exb_total_square_footage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExb_total_square_footage(): ?int
    {
        return $this->exb_total_square_footage ?? null;
    }
    /**
     * Set exb_total_square_footage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $exb_total_square_footage
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_total_square_footage(?int $exb_total_square_footage = null): self
    {
        // validation for constraint: int
        if (!is_null($exb_total_square_footage) && !(is_int($exb_total_square_footage) || ctype_digit($exb_total_square_footage))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exb_total_square_footage, true), gettype($exb_total_square_footage)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($exb_total_square_footage) && $exb_total_square_footage > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($exb_total_square_footage, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($exb_total_square_footage) && $exb_total_square_footage < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($exb_total_square_footage, true)), __LINE__);
        }
        if (is_null($exb_total_square_footage) || (is_array($exb_total_square_footage) && empty($exb_total_square_footage))) {
            unset($this->exb_total_square_footage);
        } else {
            $this->exb_total_square_footage = $exb_total_square_footage;
        }
        
        return $this;
    }
    /**
     * Get exb_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_entity_key(): ?string
    {
        return $this->exb_entity_key ?? null;
    }
    /**
     * Set exb_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_entity_key(?string $exb_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_entity_key) && !is_string($exb_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_entity_key, true), gettype($exb_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exb_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exb_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exb_entity_key, true)), __LINE__);
        }
        if (is_null($exb_entity_key) || (is_array($exb_entity_key) && empty($exb_entity_key))) {
            unset($this->exb_entity_key);
        } else {
            $this->exb_entity_key = $exb_entity_key;
        }
        
        return $this;
    }
    /**
     * Get exb_date_format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_date_format(): ?string
    {
        return $this->exb_date_format ?? null;
    }
    /**
     * Set exb_date_format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_date_format
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_date_format(?string $exb_date_format = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_date_format) && !is_string($exb_date_format)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_date_format, true), gettype($exb_date_format)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($exb_date_format) && mb_strlen((string) $exb_date_format) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen((string) $exb_date_format)), __LINE__);
        }
        if (is_null($exb_date_format) || (is_array($exb_date_format) && empty($exb_date_format))) {
            unset($this->exb_date_format);
        } else {
            $this->exb_date_format = $exb_date_format;
        }
        
        return $this;
    }
    /**
     * Get exb_pre_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_pre_registration_date(): ?string
    {
        return $this->exb_pre_registration_date ?? null;
    }
    /**
     * Set exb_pre_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_pre_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_pre_registration_date(?string $exb_pre_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_pre_registration_date) && !is_string($exb_pre_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_pre_registration_date, true), gettype($exb_pre_registration_date)), __LINE__);
        }
        if (is_null($exb_pre_registration_date) || (is_array($exb_pre_registration_date) && empty($exb_pre_registration_date))) {
            unset($this->exb_pre_registration_date);
        } else {
            $this->exb_pre_registration_date = $exb_pre_registration_date;
        }
        
        return $this;
    }
    /**
     * Get exb_early_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_early_registration_date(): ?string
    {
        return $this->exb_early_registration_date ?? null;
    }
    /**
     * Set exb_early_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_early_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_early_registration_date(?string $exb_early_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_early_registration_date) && !is_string($exb_early_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_early_registration_date, true), gettype($exb_early_registration_date)), __LINE__);
        }
        if (is_null($exb_early_registration_date) || (is_array($exb_early_registration_date) && empty($exb_early_registration_date))) {
            unset($this->exb_early_registration_date);
        } else {
            $this->exb_early_registration_date = $exb_early_registration_date;
        }
        
        return $this;
    }
    /**
     * Get exb_late_registration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_late_registration_date(): ?string
    {
        return $this->exb_late_registration_date ?? null;
    }
    /**
     * Set exb_late_registration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_late_registration_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_late_registration_date(?string $exb_late_registration_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_late_registration_date) && !is_string($exb_late_registration_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_late_registration_date, true), gettype($exb_late_registration_date)), __LINE__);
        }
        if (is_null($exb_late_registration_date) || (is_array($exb_late_registration_date) && empty($exb_late_registration_date))) {
            unset($this->exb_late_registration_date);
        } else {
            $this->exb_late_registration_date = $exb_late_registration_date;
        }
        
        return $this;
    }
    /**
     * Get exb_tzn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_tzn_key(): ?string
    {
        return $this->exb_tzn_key ?? null;
    }
    /**
     * Set exb_tzn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_tzn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_tzn_key(?string $exb_tzn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_tzn_key) && !is_string($exb_tzn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_tzn_key, true), gettype($exb_tzn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exb_tzn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exb_tzn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exb_tzn_key, true)), __LINE__);
        }
        if (is_null($exb_tzn_key) || (is_array($exb_tzn_key) && empty($exb_tzn_key))) {
            unset($this->exb_tzn_key);
        } else {
            $this->exb_tzn_key = $exb_tzn_key;
        }
        
        return $this;
    }
    /**
     * Get exb_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_wait_list_flag(): ?string
    {
        return $this->exb_wait_list_flag ?? null;
    }
    /**
     * Set exb_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_wait_list_flag(?string $exb_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_wait_list_flag) && !is_string($exb_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_wait_list_flag, true), gettype($exb_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exb_wait_list_flag) && $exb_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exb_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exb_wait_list_flag) && $exb_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exb_wait_list_flag, true)), __LINE__);
        }
        if (is_null($exb_wait_list_flag) || (is_array($exb_wait_list_flag) && empty($exb_wait_list_flag))) {
            unset($this->exb_wait_list_flag);
        } else {
            $this->exb_wait_list_flag = $exb_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get exb_allow_installment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_allow_installment(): ?string
    {
        return $this->exb_allow_installment ?? null;
    }
    /**
     * Set exb_allow_installment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_allow_installment
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_allow_installment(?string $exb_allow_installment = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_allow_installment) && !is_string($exb_allow_installment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_allow_installment, true), gettype($exb_allow_installment)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exb_allow_installment) && $exb_allow_installment > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exb_allow_installment, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exb_allow_installment) && $exb_allow_installment < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exb_allow_installment, true)), __LINE__);
        }
        if (is_null($exb_allow_installment) || (is_array($exb_allow_installment) && empty($exb_allow_installment))) {
            unset($this->exb_allow_installment);
        } else {
            $this->exb_allow_installment = $exb_allow_installment;
        }
        
        return $this;
    }
    /**
     * Get exb_booth_fee_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_booth_fee_type(): ?string
    {
        return $this->exb_booth_fee_type ?? null;
    }
    /**
     * Set exb_booth_fee_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_booth_fee_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_booth_fee_type(?string $exb_booth_fee_type = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_booth_fee_type) && !is_string($exb_booth_fee_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_booth_fee_type, true), gettype($exb_booth_fee_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($exb_booth_fee_type) && mb_strlen((string) $exb_booth_fee_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $exb_booth_fee_type)), __LINE__);
        }
        if (is_null($exb_booth_fee_type) || (is_array($exb_booth_fee_type) && empty($exb_booth_fee_type))) {
            unset($this->exb_booth_fee_type);
        } else {
            $this->exb_booth_fee_type = $exb_booth_fee_type;
        }
        
        return $this;
    }
    /**
     * Get exb_company_file value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_company_file(): ?string
    {
        return $this->exb_company_file ?? null;
    }
    /**
     * Set exb_company_file value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_company_file
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_company_file(?string $exb_company_file = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_company_file) && !is_string($exb_company_file)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_company_file, true), gettype($exb_company_file)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($exb_company_file) && mb_strlen((string) $exb_company_file) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $exb_company_file)), __LINE__);
        }
        if (is_null($exb_company_file) || (is_array($exb_company_file) && empty($exb_company_file))) {
            unset($this->exb_company_file);
        } else {
            $this->exb_company_file = $exb_company_file;
        }
        
        return $this;
    }
    /**
     * Get exb_booth_file value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExb_booth_file(): ?string
    {
        return $this->exb_booth_file ?? null;
    }
    /**
     * Set exb_booth_file value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exb_booth_file
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibit_Show_DataObjectType
     */
    public function setExb_booth_file(?string $exb_booth_file = null): self
    {
        // validation for constraint: string
        if (!is_null($exb_booth_file) && !is_string($exb_booth_file)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exb_booth_file, true), gettype($exb_booth_file)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($exb_booth_file) && mb_strlen((string) $exb_booth_file) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $exb_booth_file)), __LINE__);
        }
        if (is_null($exb_booth_file) || (is_array($exb_booth_file) && empty($exb_booth_file))) {
            unset($this->exb_booth_file);
        } else {
            $this->exb_booth_file = $exb_booth_file;
        }
        
        return $this;
    }
}
