<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorBoothNew_Exhibitor_Booth_DataObjectType extends AbstractStructBase
{
    /**
     * The hxb_key
     * Meta information extracted from the WSDL
     * - documentation: Booth. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_key = null;
    /**
     * The hxb_exh_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_exh_key = null;
    /**
     * The hxb_inv_code_cp
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 53
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_inv_code_cp = null;
    /**
     * The hxb_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_add_user = null;
    /**
     * The hxb_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_add_date = null;
    /**
     * The hxb_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_change_user = null;
    /**
     * The hxb_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_change_date = null;
    /**
     * The hxb_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_delete_flag = null;
    /**
     * The hxb_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_key_ext = null;
    /**
     * The hxb_received_comp
     * Meta information extracted from the WSDL
     * - documentation: received comp registration. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_received_comp = null;
    /**
     * The hxb_bct_key
     * Meta information extracted from the WSDL
     * - documentation: booth category. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_bct_key = null;
    /**
     * The hxb_bty_key
     * Meta information extracted from the WSDL
     * - documentation: Booth type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_bty_key = null;
    /**
     * The hxb_booth_number
     * Meta information extracted from the WSDL
     * - documentation: booth number. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $hxb_booth_number = null;
    /**
     * The hxb_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_entity_key = null;
    /**
     * The hxb_priority_points_override
     * Meta information extracted from the WSDL
     * - documentation: priority points override. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $hxb_priority_points_override = null;
    /**
     * The hxb_notes
     * Meta information extracted from the WSDL
     * - documentation: notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_notes = null;
    /**
     * The hxb_shared_flag
     * Meta information extracted from the WSDL
     * - documentation: shared?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_shared_flag = null;
    /**
     * The hxb_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: cancel date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_cancel_date = null;
    /**
     * The hxb_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: on wait list?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_wait_list_flag = null;
    /**
     * The hxb_booth_status
     * Meta information extracted from the WSDL
     * - documentation: booth status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_booth_status = null;
    /**
     * The hxb_ebn_key
     * Meta information extracted from the WSDL
     * - documentation: booth number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_ebn_key = null;
    /**
     * The hxb_bfe_prd_key
     * Meta information extracted from the WSDL
     * - documentation: booth product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_bfe_prd_key = null;
    /**
     * The hxb_sbt_key
     * Meta information extracted from the WSDL
     * - documentation: square footage booth. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_sbt_key = null;
    /**
     * The hxb_comp_booth_personnel_override
     * Meta information extracted from the WSDL
     * - documentation: comp booth personnel override. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $hxb_comp_booth_personnel_override = null;
    /**
     * The hxb_inv_code
     * Meta information extracted from the WSDL
     * - documentation: invoice code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_inv_code = null;
    /**
     * The hxb_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: invoice detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_ivd_key = null;
    /**
     * The hxb_width
     * Meta information extracted from the WSDL
     * - documentation: width. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $hxb_width = null;
    /**
     * The hxb_depth
     * Meta information extracted from the WSDL
     * - documentation: depth. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $hxb_depth = null;
    /**
     * The hxb_square_footage
     * Meta information extracted from the WSDL
     * - documentation: requested square footage. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $hxb_square_footage = null;
    /**
     * The hxb_square_footage_cp
     * Meta information extracted from the WSDL
     * - documentation: computed square footage. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $hxb_square_footage_cp = null;
    /**
     * The hxb_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $hxb_odd_key = null;
    /**
     * The hxb_total_booths_to_sell
     * Meta information extracted from the WSDL
     * - documentation: total booths to sell.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $hxb_total_booths_to_sell = null;
    /**
     * The hxb_comp_registrations
     * Meta information extracted from the WSDL
     * - documentation: hxb_comp_registrations.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $hxb_comp_registrations = null;
    /**
     * The hxb__bty_available
     * Meta information extracted from the WSDL
     * - documentation: available booth products.This element has a default value of 'n/a'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb__bty_available = null;
    /**
     * The hxb__bty_sold
     * Meta information extracted from the WSDL
     * - documentation: sold booth products.This element has a default value of 'n/a'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb__bty_sold = null;
    /**
     * The hxb__bty_inventory_qty
     * Meta information extracted from the WSDL
     * - documentation: inventory qty..This element has a default value of 'n/a'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb__bty_inventory_qty = null;
    /**
     * The hxb__bct_available
     * Meta information extracted from the WSDL
     * - documentation: available category products.This element has a default value of 'n/a'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb__bct_available = null;
    /**
     * The hxb__bct_sold
     * Meta information extracted from the WSDL
     * - documentation: sold category products.This element has a default value of 'n/a'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb__bct_sold = null;
    /**
     * The hxb__bct_inventory_qty
     * Meta information extracted from the WSDL
     * - documentation: category inventory quantity.This element has a default value of 'n/a'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb__bct_inventory_qty = null;
    /**
     * The hxb_shared_responsibility
     * Meta information extracted from the WSDL
     * - documentation: Booth Owner.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_shared_responsibility = null;
    /**
     * The hxb_display_wait_list
     * Meta information extracted from the WSDL
     * - documentation: Display wait list flag.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_display_wait_list = null;
    /**
     * The hxb_search_by_booth_type
     * Meta information extracted from the WSDL
     * - documentation: Booth Type.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_search_by_booth_type = null;
    /**
     * The hxb_search_by_booth_category
     * Meta information extracted from the WSDL
     * - documentation: Booth Category.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_search_by_booth_category = null;
    /**
     * The hxb_search_by_booth_product
     * Meta information extracted from the WSDL
     * - documentation: booth product.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_search_by_booth_product = null;
    /**
     * The hxb_cancel_flag
     * Meta information extracted from the WSDL
     * - documentation: cancel.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_cancel_flag = null;
    /**
     * The hxb_sell_space
     * Meta information extracted from the WSDL
     * - documentation: Do you want to buy space.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $hxb_sell_space = null;
    /**
     * Constructor method for ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_exh_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_inv_code_cp()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_add_user()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_add_date()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_change_user()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_change_date()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_delete_flag()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_key_ext()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_received_comp()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_bct_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_bty_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_booth_number()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_entity_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_priority_points_override()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_notes()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_shared_flag()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_cancel_date()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_wait_list_flag()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_booth_status()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_ebn_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_bfe_prd_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_sbt_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_comp_booth_personnel_override()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_inv_code()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_ivd_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_width()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_depth()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_square_footage()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_square_footage_cp()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_odd_key()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_total_booths_to_sell()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_comp_registrations()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb__bty_available()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb__bty_sold()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb__bty_inventory_qty()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb__bct_available()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb__bct_sold()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb__bct_inventory_qty()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_shared_responsibility()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_display_wait_list()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_search_by_booth_type()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_search_by_booth_category()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_search_by_booth_product()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_cancel_flag()
     * @uses ExhibitorBoothNew_Exhibitor_Booth_DataObjectType::setHxb_sell_space()
     * @param string $hxb_key
     * @param string $hxb_exh_key
     * @param string $hxb_inv_code_cp
     * @param string $hxb_add_user
     * @param string $hxb_add_date
     * @param string $hxb_change_user
     * @param string $hxb_change_date
     * @param string $hxb_delete_flag
     * @param string $hxb_key_ext
     * @param string $hxb_received_comp
     * @param string $hxb_bct_key
     * @param string $hxb_bty_key
     * @param int $hxb_booth_number
     * @param string $hxb_entity_key
     * @param float $hxb_priority_points_override
     * @param string $hxb_notes
     * @param string $hxb_shared_flag
     * @param string $hxb_cancel_date
     * @param string $hxb_wait_list_flag
     * @param string $hxb_booth_status
     * @param string $hxb_ebn_key
     * @param string $hxb_bfe_prd_key
     * @param string $hxb_sbt_key
     * @param int $hxb_comp_booth_personnel_override
     * @param string $hxb_inv_code
     * @param string $hxb_ivd_key
     * @param float $hxb_width
     * @param float $hxb_depth
     * @param float $hxb_square_footage
     * @param float $hxb_square_footage_cp
     * @param string $hxb_odd_key
     * @param int $hxb_total_booths_to_sell
     * @param int $hxb_comp_registrations
     * @param string $hxb__bty_available
     * @param string $hxb__bty_sold
     * @param string $hxb__bty_inventory_qty
     * @param string $hxb__bct_available
     * @param string $hxb__bct_sold
     * @param string $hxb__bct_inventory_qty
     * @param string $hxb_shared_responsibility
     * @param string $hxb_display_wait_list
     * @param string $hxb_search_by_booth_type
     * @param string $hxb_search_by_booth_category
     * @param string $hxb_search_by_booth_product
     * @param string $hxb_cancel_flag
     * @param string $hxb_sell_space
     */
    public function __construct(?string $hxb_key = null, ?string $hxb_exh_key = null, ?string $hxb_inv_code_cp = null, ?string $hxb_add_user = null, ?string $hxb_add_date = null, ?string $hxb_change_user = null, ?string $hxb_change_date = null, ?string $hxb_delete_flag = null, ?string $hxb_key_ext = null, ?string $hxb_received_comp = null, ?string $hxb_bct_key = null, ?string $hxb_bty_key = null, ?int $hxb_booth_number = null, ?string $hxb_entity_key = null, ?float $hxb_priority_points_override = null, ?string $hxb_notes = null, ?string $hxb_shared_flag = null, ?string $hxb_cancel_date = null, ?string $hxb_wait_list_flag = null, ?string $hxb_booth_status = null, ?string $hxb_ebn_key = null, ?string $hxb_bfe_prd_key = null, ?string $hxb_sbt_key = null, ?int $hxb_comp_booth_personnel_override = null, ?string $hxb_inv_code = null, ?string $hxb_ivd_key = null, ?float $hxb_width = null, ?float $hxb_depth = null, ?float $hxb_square_footage = null, ?float $hxb_square_footage_cp = null, ?string $hxb_odd_key = null, ?int $hxb_total_booths_to_sell = null, ?int $hxb_comp_registrations = null, ?string $hxb__bty_available = null, ?string $hxb__bty_sold = null, ?string $hxb__bty_inventory_qty = null, ?string $hxb__bct_available = null, ?string $hxb__bct_sold = null, ?string $hxb__bct_inventory_qty = null, ?string $hxb_shared_responsibility = null, ?string $hxb_display_wait_list = null, ?string $hxb_search_by_booth_type = null, ?string $hxb_search_by_booth_category = null, ?string $hxb_search_by_booth_product = null, ?string $hxb_cancel_flag = null, ?string $hxb_sell_space = null)
    {
        $this
            ->setHxb_key($hxb_key)
            ->setHxb_exh_key($hxb_exh_key)
            ->setHxb_inv_code_cp($hxb_inv_code_cp)
            ->setHxb_add_user($hxb_add_user)
            ->setHxb_add_date($hxb_add_date)
            ->setHxb_change_user($hxb_change_user)
            ->setHxb_change_date($hxb_change_date)
            ->setHxb_delete_flag($hxb_delete_flag)
            ->setHxb_key_ext($hxb_key_ext)
            ->setHxb_received_comp($hxb_received_comp)
            ->setHxb_bct_key($hxb_bct_key)
            ->setHxb_bty_key($hxb_bty_key)
            ->setHxb_booth_number($hxb_booth_number)
            ->setHxb_entity_key($hxb_entity_key)
            ->setHxb_priority_points_override($hxb_priority_points_override)
            ->setHxb_notes($hxb_notes)
            ->setHxb_shared_flag($hxb_shared_flag)
            ->setHxb_cancel_date($hxb_cancel_date)
            ->setHxb_wait_list_flag($hxb_wait_list_flag)
            ->setHxb_booth_status($hxb_booth_status)
            ->setHxb_ebn_key($hxb_ebn_key)
            ->setHxb_bfe_prd_key($hxb_bfe_prd_key)
            ->setHxb_sbt_key($hxb_sbt_key)
            ->setHxb_comp_booth_personnel_override($hxb_comp_booth_personnel_override)
            ->setHxb_inv_code($hxb_inv_code)
            ->setHxb_ivd_key($hxb_ivd_key)
            ->setHxb_width($hxb_width)
            ->setHxb_depth($hxb_depth)
            ->setHxb_square_footage($hxb_square_footage)
            ->setHxb_square_footage_cp($hxb_square_footage_cp)
            ->setHxb_odd_key($hxb_odd_key)
            ->setHxb_total_booths_to_sell($hxb_total_booths_to_sell)
            ->setHxb_comp_registrations($hxb_comp_registrations)
            ->setHxb__bty_available($hxb__bty_available)
            ->setHxb__bty_sold($hxb__bty_sold)
            ->setHxb__bty_inventory_qty($hxb__bty_inventory_qty)
            ->setHxb__bct_available($hxb__bct_available)
            ->setHxb__bct_sold($hxb__bct_sold)
            ->setHxb__bct_inventory_qty($hxb__bct_inventory_qty)
            ->setHxb_shared_responsibility($hxb_shared_responsibility)
            ->setHxb_display_wait_list($hxb_display_wait_list)
            ->setHxb_search_by_booth_type($hxb_search_by_booth_type)
            ->setHxb_search_by_booth_category($hxb_search_by_booth_category)
            ->setHxb_search_by_booth_product($hxb_search_by_booth_product)
            ->setHxb_cancel_flag($hxb_cancel_flag)
            ->setHxb_sell_space($hxb_sell_space);
    }
    /**
     * Get hxb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_key(): ?string
    {
        return $this->hxb_key ?? null;
    }
    /**
     * Set hxb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_key(?string $hxb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_key) && !is_string($hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_key, true), gettype($hxb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_key, true)), __LINE__);
        }
        if (is_null($hxb_key) || (is_array($hxb_key) && empty($hxb_key))) {
            unset($this->hxb_key);
        } else {
            $this->hxb_key = $hxb_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_exh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_exh_key(): ?string
    {
        return $this->hxb_exh_key ?? null;
    }
    /**
     * Set hxb_exh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_exh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_exh_key(?string $hxb_exh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_exh_key) && !is_string($hxb_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_exh_key, true), gettype($hxb_exh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_exh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_exh_key, true)), __LINE__);
        }
        if (is_null($hxb_exh_key) || (is_array($hxb_exh_key) && empty($hxb_exh_key))) {
            unset($this->hxb_exh_key);
        } else {
            $this->hxb_exh_key = $hxb_exh_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_inv_code_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_inv_code_cp(): ?string
    {
        return $this->hxb_inv_code_cp ?? null;
    }
    /**
     * Set hxb_inv_code_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_inv_code_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_inv_code_cp(?string $hxb_inv_code_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_inv_code_cp) && !is_string($hxb_inv_code_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_inv_code_cp, true), gettype($hxb_inv_code_cp)), __LINE__);
        }
        // validation for constraint: maxLength(53)
        if (!is_null($hxb_inv_code_cp) && mb_strlen((string) $hxb_inv_code_cp) > 53) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 53', mb_strlen((string) $hxb_inv_code_cp)), __LINE__);
        }
        if (is_null($hxb_inv_code_cp) || (is_array($hxb_inv_code_cp) && empty($hxb_inv_code_cp))) {
            unset($this->hxb_inv_code_cp);
        } else {
            $this->hxb_inv_code_cp = $hxb_inv_code_cp;
        }
        
        return $this;
    }
    /**
     * Get hxb_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_add_user(): ?string
    {
        return $this->hxb_add_user ?? null;
    }
    /**
     * Set hxb_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_add_user(?string $hxb_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_add_user) && !is_string($hxb_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_add_user, true), gettype($hxb_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($hxb_add_user) && mb_strlen((string) $hxb_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $hxb_add_user)), __LINE__);
        }
        if (is_null($hxb_add_user) || (is_array($hxb_add_user) && empty($hxb_add_user))) {
            unset($this->hxb_add_user);
        } else {
            $this->hxb_add_user = $hxb_add_user;
        }
        
        return $this;
    }
    /**
     * Get hxb_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_add_date(): ?string
    {
        return $this->hxb_add_date ?? null;
    }
    /**
     * Set hxb_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_add_date(?string $hxb_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_add_date) && !is_string($hxb_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_add_date, true), gettype($hxb_add_date)), __LINE__);
        }
        if (is_null($hxb_add_date) || (is_array($hxb_add_date) && empty($hxb_add_date))) {
            unset($this->hxb_add_date);
        } else {
            $this->hxb_add_date = $hxb_add_date;
        }
        
        return $this;
    }
    /**
     * Get hxb_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_change_user(): ?string
    {
        return $this->hxb_change_user ?? null;
    }
    /**
     * Set hxb_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_change_user(?string $hxb_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_change_user) && !is_string($hxb_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_change_user, true), gettype($hxb_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($hxb_change_user) && mb_strlen((string) $hxb_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $hxb_change_user)), __LINE__);
        }
        if (is_null($hxb_change_user) || (is_array($hxb_change_user) && empty($hxb_change_user))) {
            unset($this->hxb_change_user);
        } else {
            $this->hxb_change_user = $hxb_change_user;
        }
        
        return $this;
    }
    /**
     * Get hxb_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_change_date(): ?string
    {
        return $this->hxb_change_date ?? null;
    }
    /**
     * Set hxb_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_change_date(?string $hxb_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_change_date) && !is_string($hxb_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_change_date, true), gettype($hxb_change_date)), __LINE__);
        }
        if (is_null($hxb_change_date) || (is_array($hxb_change_date) && empty($hxb_change_date))) {
            unset($this->hxb_change_date);
        } else {
            $this->hxb_change_date = $hxb_change_date;
        }
        
        return $this;
    }
    /**
     * Get hxb_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_delete_flag(): ?string
    {
        return $this->hxb_delete_flag ?? null;
    }
    /**
     * Set hxb_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_delete_flag(?string $hxb_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_delete_flag) && !is_string($hxb_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_delete_flag, true), gettype($hxb_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($hxb_delete_flag) && $hxb_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($hxb_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hxb_delete_flag) && $hxb_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hxb_delete_flag, true)), __LINE__);
        }
        if (is_null($hxb_delete_flag) || (is_array($hxb_delete_flag) && empty($hxb_delete_flag))) {
            unset($this->hxb_delete_flag);
        } else {
            $this->hxb_delete_flag = $hxb_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get hxb_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_key_ext(): ?string
    {
        return $this->hxb_key_ext ?? null;
    }
    /**
     * Set hxb_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_key_ext(?string $hxb_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_key_ext) && !is_string($hxb_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_key_ext, true), gettype($hxb_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_key_ext, true)), __LINE__);
        }
        if (is_null($hxb_key_ext) || (is_array($hxb_key_ext) && empty($hxb_key_ext))) {
            unset($this->hxb_key_ext);
        } else {
            $this->hxb_key_ext = $hxb_key_ext;
        }
        
        return $this;
    }
    /**
     * Get hxb_received_comp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_received_comp(): ?string
    {
        return $this->hxb_received_comp ?? null;
    }
    /**
     * Set hxb_received_comp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_received_comp
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_received_comp(?string $hxb_received_comp = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_received_comp) && !is_string($hxb_received_comp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_received_comp, true), gettype($hxb_received_comp)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($hxb_received_comp) && $hxb_received_comp > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($hxb_received_comp, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hxb_received_comp) && $hxb_received_comp < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hxb_received_comp, true)), __LINE__);
        }
        if (is_null($hxb_received_comp) || (is_array($hxb_received_comp) && empty($hxb_received_comp))) {
            unset($this->hxb_received_comp);
        } else {
            $this->hxb_received_comp = $hxb_received_comp;
        }
        
        return $this;
    }
    /**
     * Get hxb_bct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_bct_key(): ?string
    {
        return $this->hxb_bct_key ?? null;
    }
    /**
     * Set hxb_bct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_bct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_bct_key(?string $hxb_bct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_bct_key) && !is_string($hxb_bct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_bct_key, true), gettype($hxb_bct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_bct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_bct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_bct_key, true)), __LINE__);
        }
        if (is_null($hxb_bct_key) || (is_array($hxb_bct_key) && empty($hxb_bct_key))) {
            unset($this->hxb_bct_key);
        } else {
            $this->hxb_bct_key = $hxb_bct_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_bty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_bty_key(): ?string
    {
        return $this->hxb_bty_key ?? null;
    }
    /**
     * Set hxb_bty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_bty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_bty_key(?string $hxb_bty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_bty_key) && !is_string($hxb_bty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_bty_key, true), gettype($hxb_bty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_bty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_bty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_bty_key, true)), __LINE__);
        }
        if (is_null($hxb_bty_key) || (is_array($hxb_bty_key) && empty($hxb_bty_key))) {
            unset($this->hxb_bty_key);
        } else {
            $this->hxb_bty_key = $hxb_bty_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_booth_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHxb_booth_number(): ?int
    {
        return $this->hxb_booth_number ?? null;
    }
    /**
     * Set hxb_booth_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hxb_booth_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_booth_number(?int $hxb_booth_number = null): self
    {
        // validation for constraint: int
        if (!is_null($hxb_booth_number) && !(is_int($hxb_booth_number) || ctype_digit($hxb_booth_number))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hxb_booth_number, true), gettype($hxb_booth_number)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($hxb_booth_number) && $hxb_booth_number > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($hxb_booth_number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($hxb_booth_number) && $hxb_booth_number < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($hxb_booth_number, true)), __LINE__);
        }
        if (is_null($hxb_booth_number) || (is_array($hxb_booth_number) && empty($hxb_booth_number))) {
            unset($this->hxb_booth_number);
        } else {
            $this->hxb_booth_number = $hxb_booth_number;
        }
        
        return $this;
    }
    /**
     * Get hxb_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_entity_key(): ?string
    {
        return $this->hxb_entity_key ?? null;
    }
    /**
     * Set hxb_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_entity_key(?string $hxb_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_entity_key) && !is_string($hxb_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_entity_key, true), gettype($hxb_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_entity_key, true)), __LINE__);
        }
        if (is_null($hxb_entity_key) || (is_array($hxb_entity_key) && empty($hxb_entity_key))) {
            unset($this->hxb_entity_key);
        } else {
            $this->hxb_entity_key = $hxb_entity_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_priority_points_override value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHxb_priority_points_override(): ?float
    {
        return $this->hxb_priority_points_override ?? null;
    }
    /**
     * Set hxb_priority_points_override value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $hxb_priority_points_override
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_priority_points_override(?float $hxb_priority_points_override = null): self
    {
        // validation for constraint: float
        if (!is_null($hxb_priority_points_override) && !(is_float($hxb_priority_points_override) || is_numeric($hxb_priority_points_override))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hxb_priority_points_override, true), gettype($hxb_priority_points_override)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($hxb_priority_points_override) && mb_strlen(mb_substr((string) $hxb_priority_points_override, false !== mb_strpos((string) $hxb_priority_points_override, '.') ? mb_strpos((string) $hxb_priority_points_override, '.') + 1 : mb_strlen((string) $hxb_priority_points_override))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($hxb_priority_points_override, true), mb_strlen(mb_substr((string) $hxb_priority_points_override, mb_strpos((string) $hxb_priority_points_override, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($hxb_priority_points_override) && mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_priority_points_override)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($hxb_priority_points_override, true), mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_priority_points_override))), __LINE__);
        }
        if (is_null($hxb_priority_points_override) || (is_array($hxb_priority_points_override) && empty($hxb_priority_points_override))) {
            unset($this->hxb_priority_points_override);
        } else {
            $this->hxb_priority_points_override = $hxb_priority_points_override;
        }
        
        return $this;
    }
    /**
     * Get hxb_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_notes(): ?string
    {
        return $this->hxb_notes ?? null;
    }
    /**
     * Set hxb_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_notes(?string $hxb_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_notes) && !is_string($hxb_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_notes, true), gettype($hxb_notes)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($hxb_notes) && mb_strlen((string) $hxb_notes) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $hxb_notes)), __LINE__);
        }
        if (is_null($hxb_notes) || (is_array($hxb_notes) && empty($hxb_notes))) {
            unset($this->hxb_notes);
        } else {
            $this->hxb_notes = $hxb_notes;
        }
        
        return $this;
    }
    /**
     * Get hxb_shared_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_shared_flag(): ?string
    {
        return $this->hxb_shared_flag ?? null;
    }
    /**
     * Set hxb_shared_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_shared_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_shared_flag(?string $hxb_shared_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_shared_flag) && !is_string($hxb_shared_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_shared_flag, true), gettype($hxb_shared_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($hxb_shared_flag) && $hxb_shared_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($hxb_shared_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hxb_shared_flag) && $hxb_shared_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hxb_shared_flag, true)), __LINE__);
        }
        if (is_null($hxb_shared_flag) || (is_array($hxb_shared_flag) && empty($hxb_shared_flag))) {
            unset($this->hxb_shared_flag);
        } else {
            $this->hxb_shared_flag = $hxb_shared_flag;
        }
        
        return $this;
    }
    /**
     * Get hxb_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_cancel_date(): ?string
    {
        return $this->hxb_cancel_date ?? null;
    }
    /**
     * Set hxb_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_cancel_date(?string $hxb_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_cancel_date) && !is_string($hxb_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_cancel_date, true), gettype($hxb_cancel_date)), __LINE__);
        }
        if (is_null($hxb_cancel_date) || (is_array($hxb_cancel_date) && empty($hxb_cancel_date))) {
            unset($this->hxb_cancel_date);
        } else {
            $this->hxb_cancel_date = $hxb_cancel_date;
        }
        
        return $this;
    }
    /**
     * Get hxb_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_wait_list_flag(): ?string
    {
        return $this->hxb_wait_list_flag ?? null;
    }
    /**
     * Set hxb_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_wait_list_flag(?string $hxb_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_wait_list_flag) && !is_string($hxb_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_wait_list_flag, true), gettype($hxb_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($hxb_wait_list_flag) && $hxb_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($hxb_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hxb_wait_list_flag) && $hxb_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hxb_wait_list_flag, true)), __LINE__);
        }
        if (is_null($hxb_wait_list_flag) || (is_array($hxb_wait_list_flag) && empty($hxb_wait_list_flag))) {
            unset($this->hxb_wait_list_flag);
        } else {
            $this->hxb_wait_list_flag = $hxb_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get hxb_booth_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_booth_status(): ?string
    {
        return $this->hxb_booth_status ?? null;
    }
    /**
     * Set hxb_booth_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_booth_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_booth_status(?string $hxb_booth_status = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_booth_status) && !is_string($hxb_booth_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_booth_status, true), gettype($hxb_booth_status)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($hxb_booth_status) && mb_strlen((string) $hxb_booth_status) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $hxb_booth_status)), __LINE__);
        }
        if (is_null($hxb_booth_status) || (is_array($hxb_booth_status) && empty($hxb_booth_status))) {
            unset($this->hxb_booth_status);
        } else {
            $this->hxb_booth_status = $hxb_booth_status;
        }
        
        return $this;
    }
    /**
     * Get hxb_ebn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_ebn_key(): ?string
    {
        return $this->hxb_ebn_key ?? null;
    }
    /**
     * Set hxb_ebn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_ebn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_ebn_key(?string $hxb_ebn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_ebn_key) && !is_string($hxb_ebn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_ebn_key, true), gettype($hxb_ebn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_ebn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_ebn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_ebn_key, true)), __LINE__);
        }
        if (is_null($hxb_ebn_key) || (is_array($hxb_ebn_key) && empty($hxb_ebn_key))) {
            unset($this->hxb_ebn_key);
        } else {
            $this->hxb_ebn_key = $hxb_ebn_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_bfe_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_bfe_prd_key(): ?string
    {
        return $this->hxb_bfe_prd_key ?? null;
    }
    /**
     * Set hxb_bfe_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_bfe_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_bfe_prd_key(?string $hxb_bfe_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_bfe_prd_key) && !is_string($hxb_bfe_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_bfe_prd_key, true), gettype($hxb_bfe_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_bfe_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_bfe_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_bfe_prd_key, true)), __LINE__);
        }
        if (is_null($hxb_bfe_prd_key) || (is_array($hxb_bfe_prd_key) && empty($hxb_bfe_prd_key))) {
            unset($this->hxb_bfe_prd_key);
        } else {
            $this->hxb_bfe_prd_key = $hxb_bfe_prd_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_sbt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_sbt_key(): ?string
    {
        return $this->hxb_sbt_key ?? null;
    }
    /**
     * Set hxb_sbt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_sbt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_sbt_key(?string $hxb_sbt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_sbt_key) && !is_string($hxb_sbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_sbt_key, true), gettype($hxb_sbt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_sbt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_sbt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_sbt_key, true)), __LINE__);
        }
        if (is_null($hxb_sbt_key) || (is_array($hxb_sbt_key) && empty($hxb_sbt_key))) {
            unset($this->hxb_sbt_key);
        } else {
            $this->hxb_sbt_key = $hxb_sbt_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_comp_booth_personnel_override value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHxb_comp_booth_personnel_override(): ?int
    {
        return $this->hxb_comp_booth_personnel_override ?? null;
    }
    /**
     * Set hxb_comp_booth_personnel_override value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hxb_comp_booth_personnel_override
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_comp_booth_personnel_override(?int $hxb_comp_booth_personnel_override = null): self
    {
        // validation for constraint: int
        if (!is_null($hxb_comp_booth_personnel_override) && !(is_int($hxb_comp_booth_personnel_override) || ctype_digit($hxb_comp_booth_personnel_override))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hxb_comp_booth_personnel_override, true), gettype($hxb_comp_booth_personnel_override)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($hxb_comp_booth_personnel_override) && $hxb_comp_booth_personnel_override > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($hxb_comp_booth_personnel_override, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($hxb_comp_booth_personnel_override) && $hxb_comp_booth_personnel_override < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($hxb_comp_booth_personnel_override, true)), __LINE__);
        }
        if (is_null($hxb_comp_booth_personnel_override) || (is_array($hxb_comp_booth_personnel_override) && empty($hxb_comp_booth_personnel_override))) {
            unset($this->hxb_comp_booth_personnel_override);
        } else {
            $this->hxb_comp_booth_personnel_override = $hxb_comp_booth_personnel_override;
        }
        
        return $this;
    }
    /**
     * Get hxb_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_inv_code(): ?string
    {
        return $this->hxb_inv_code ?? null;
    }
    /**
     * Set hxb_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_inv_code(?string $hxb_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_inv_code) && !is_string($hxb_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_inv_code, true), gettype($hxb_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($hxb_inv_code) && mb_strlen((string) $hxb_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $hxb_inv_code)), __LINE__);
        }
        if (is_null($hxb_inv_code) || (is_array($hxb_inv_code) && empty($hxb_inv_code))) {
            unset($this->hxb_inv_code);
        } else {
            $this->hxb_inv_code = $hxb_inv_code;
        }
        
        return $this;
    }
    /**
     * Get hxb_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_ivd_key(): ?string
    {
        return $this->hxb_ivd_key ?? null;
    }
    /**
     * Set hxb_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_ivd_key(?string $hxb_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_ivd_key) && !is_string($hxb_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_ivd_key, true), gettype($hxb_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_ivd_key, true)), __LINE__);
        }
        if (is_null($hxb_ivd_key) || (is_array($hxb_ivd_key) && empty($hxb_ivd_key))) {
            unset($this->hxb_ivd_key);
        } else {
            $this->hxb_ivd_key = $hxb_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHxb_width(): ?float
    {
        return $this->hxb_width ?? null;
    }
    /**
     * Set hxb_width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $hxb_width
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_width(?float $hxb_width = null): self
    {
        // validation for constraint: float
        if (!is_null($hxb_width) && !(is_float($hxb_width) || is_numeric($hxb_width))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hxb_width, true), gettype($hxb_width)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($hxb_width) && mb_strlen(mb_substr((string) $hxb_width, false !== mb_strpos((string) $hxb_width, '.') ? mb_strpos((string) $hxb_width, '.') + 1 : mb_strlen((string) $hxb_width))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($hxb_width, true), mb_strlen(mb_substr((string) $hxb_width, mb_strpos((string) $hxb_width, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($hxb_width) && mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_width)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($hxb_width, true), mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_width))), __LINE__);
        }
        if (is_null($hxb_width) || (is_array($hxb_width) && empty($hxb_width))) {
            unset($this->hxb_width);
        } else {
            $this->hxb_width = $hxb_width;
        }
        
        return $this;
    }
    /**
     * Get hxb_depth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHxb_depth(): ?float
    {
        return $this->hxb_depth ?? null;
    }
    /**
     * Set hxb_depth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $hxb_depth
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_depth(?float $hxb_depth = null): self
    {
        // validation for constraint: float
        if (!is_null($hxb_depth) && !(is_float($hxb_depth) || is_numeric($hxb_depth))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hxb_depth, true), gettype($hxb_depth)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($hxb_depth) && mb_strlen(mb_substr((string) $hxb_depth, false !== mb_strpos((string) $hxb_depth, '.') ? mb_strpos((string) $hxb_depth, '.') + 1 : mb_strlen((string) $hxb_depth))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($hxb_depth, true), mb_strlen(mb_substr((string) $hxb_depth, mb_strpos((string) $hxb_depth, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($hxb_depth) && mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_depth)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($hxb_depth, true), mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_depth))), __LINE__);
        }
        if (is_null($hxb_depth) || (is_array($hxb_depth) && empty($hxb_depth))) {
            unset($this->hxb_depth);
        } else {
            $this->hxb_depth = $hxb_depth;
        }
        
        return $this;
    }
    /**
     * Get hxb_square_footage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHxb_square_footage(): ?float
    {
        return $this->hxb_square_footage ?? null;
    }
    /**
     * Set hxb_square_footage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $hxb_square_footage
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_square_footage(?float $hxb_square_footage = null): self
    {
        // validation for constraint: float
        if (!is_null($hxb_square_footage) && !(is_float($hxb_square_footage) || is_numeric($hxb_square_footage))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hxb_square_footage, true), gettype($hxb_square_footage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($hxb_square_footage) && mb_strlen(mb_substr((string) $hxb_square_footage, false !== mb_strpos((string) $hxb_square_footage, '.') ? mb_strpos((string) $hxb_square_footage, '.') + 1 : mb_strlen((string) $hxb_square_footage))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($hxb_square_footage, true), mb_strlen(mb_substr((string) $hxb_square_footage, mb_strpos((string) $hxb_square_footage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($hxb_square_footage) && mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_square_footage)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($hxb_square_footage, true), mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_square_footage))), __LINE__);
        }
        if (is_null($hxb_square_footage) || (is_array($hxb_square_footage) && empty($hxb_square_footage))) {
            unset($this->hxb_square_footage);
        } else {
            $this->hxb_square_footage = $hxb_square_footage;
        }
        
        return $this;
    }
    /**
     * Get hxb_square_footage_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHxb_square_footage_cp(): ?float
    {
        return $this->hxb_square_footage_cp ?? null;
    }
    /**
     * Set hxb_square_footage_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $hxb_square_footage_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_square_footage_cp(?float $hxb_square_footage_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($hxb_square_footage_cp) && !(is_float($hxb_square_footage_cp) || is_numeric($hxb_square_footage_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hxb_square_footage_cp, true), gettype($hxb_square_footage_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($hxb_square_footage_cp) && mb_strlen(mb_substr((string) $hxb_square_footage_cp, false !== mb_strpos((string) $hxb_square_footage_cp, '.') ? mb_strpos((string) $hxb_square_footage_cp, '.') + 1 : mb_strlen((string) $hxb_square_footage_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($hxb_square_footage_cp, true), mb_strlen(mb_substr((string) $hxb_square_footage_cp, mb_strpos((string) $hxb_square_footage_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($hxb_square_footage_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_square_footage_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($hxb_square_footage_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $hxb_square_footage_cp))), __LINE__);
        }
        if (is_null($hxb_square_footage_cp) || (is_array($hxb_square_footage_cp) && empty($hxb_square_footage_cp))) {
            unset($this->hxb_square_footage_cp);
        } else {
            $this->hxb_square_footage_cp = $hxb_square_footage_cp;
        }
        
        return $this;
    }
    /**
     * Get hxb_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_odd_key(): ?string
    {
        return $this->hxb_odd_key ?? null;
    }
    /**
     * Set hxb_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_odd_key(?string $hxb_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_odd_key) && !is_string($hxb_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_odd_key, true), gettype($hxb_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($hxb_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $hxb_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($hxb_odd_key, true)), __LINE__);
        }
        if (is_null($hxb_odd_key) || (is_array($hxb_odd_key) && empty($hxb_odd_key))) {
            unset($this->hxb_odd_key);
        } else {
            $this->hxb_odd_key = $hxb_odd_key;
        }
        
        return $this;
    }
    /**
     * Get hxb_total_booths_to_sell value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHxb_total_booths_to_sell(): ?int
    {
        return $this->hxb_total_booths_to_sell ?? null;
    }
    /**
     * Set hxb_total_booths_to_sell value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hxb_total_booths_to_sell
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_total_booths_to_sell(?int $hxb_total_booths_to_sell = null): self
    {
        // validation for constraint: int
        if (!is_null($hxb_total_booths_to_sell) && !(is_int($hxb_total_booths_to_sell) || ctype_digit($hxb_total_booths_to_sell))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hxb_total_booths_to_sell, true), gettype($hxb_total_booths_to_sell)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($hxb_total_booths_to_sell) && $hxb_total_booths_to_sell > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($hxb_total_booths_to_sell, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($hxb_total_booths_to_sell) && $hxb_total_booths_to_sell < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($hxb_total_booths_to_sell, true)), __LINE__);
        }
        if (is_null($hxb_total_booths_to_sell) || (is_array($hxb_total_booths_to_sell) && empty($hxb_total_booths_to_sell))) {
            unset($this->hxb_total_booths_to_sell);
        } else {
            $this->hxb_total_booths_to_sell = $hxb_total_booths_to_sell;
        }
        
        return $this;
    }
    /**
     * Get hxb_comp_registrations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHxb_comp_registrations(): ?int
    {
        return $this->hxb_comp_registrations ?? null;
    }
    /**
     * Set hxb_comp_registrations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hxb_comp_registrations
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_comp_registrations(?int $hxb_comp_registrations = null): self
    {
        // validation for constraint: int
        if (!is_null($hxb_comp_registrations) && !(is_int($hxb_comp_registrations) || ctype_digit($hxb_comp_registrations))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hxb_comp_registrations, true), gettype($hxb_comp_registrations)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($hxb_comp_registrations) && $hxb_comp_registrations > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($hxb_comp_registrations, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($hxb_comp_registrations) && $hxb_comp_registrations < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($hxb_comp_registrations, true)), __LINE__);
        }
        if (is_null($hxb_comp_registrations) || (is_array($hxb_comp_registrations) && empty($hxb_comp_registrations))) {
            unset($this->hxb_comp_registrations);
        } else {
            $this->hxb_comp_registrations = $hxb_comp_registrations;
        }
        
        return $this;
    }
    /**
     * Get hxb__bty_available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb__bty_available(): ?string
    {
        return $this->hxb__bty_available ?? null;
    }
    /**
     * Set hxb__bty_available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb__bty_available
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb__bty_available(?string $hxb__bty_available = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb__bty_available) && !is_string($hxb__bty_available)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb__bty_available, true), gettype($hxb__bty_available)), __LINE__);
        }
        if (is_null($hxb__bty_available) || (is_array($hxb__bty_available) && empty($hxb__bty_available))) {
            unset($this->hxb__bty_available);
        } else {
            $this->hxb__bty_available = $hxb__bty_available;
        }
        
        return $this;
    }
    /**
     * Get hxb__bty_sold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb__bty_sold(): ?string
    {
        return $this->hxb__bty_sold ?? null;
    }
    /**
     * Set hxb__bty_sold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb__bty_sold
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb__bty_sold(?string $hxb__bty_sold = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb__bty_sold) && !is_string($hxb__bty_sold)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb__bty_sold, true), gettype($hxb__bty_sold)), __LINE__);
        }
        if (is_null($hxb__bty_sold) || (is_array($hxb__bty_sold) && empty($hxb__bty_sold))) {
            unset($this->hxb__bty_sold);
        } else {
            $this->hxb__bty_sold = $hxb__bty_sold;
        }
        
        return $this;
    }
    /**
     * Get hxb__bty_inventory_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb__bty_inventory_qty(): ?string
    {
        return $this->hxb__bty_inventory_qty ?? null;
    }
    /**
     * Set hxb__bty_inventory_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb__bty_inventory_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb__bty_inventory_qty(?string $hxb__bty_inventory_qty = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb__bty_inventory_qty) && !is_string($hxb__bty_inventory_qty)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb__bty_inventory_qty, true), gettype($hxb__bty_inventory_qty)), __LINE__);
        }
        if (is_null($hxb__bty_inventory_qty) || (is_array($hxb__bty_inventory_qty) && empty($hxb__bty_inventory_qty))) {
            unset($this->hxb__bty_inventory_qty);
        } else {
            $this->hxb__bty_inventory_qty = $hxb__bty_inventory_qty;
        }
        
        return $this;
    }
    /**
     * Get hxb__bct_available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb__bct_available(): ?string
    {
        return $this->hxb__bct_available ?? null;
    }
    /**
     * Set hxb__bct_available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb__bct_available
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb__bct_available(?string $hxb__bct_available = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb__bct_available) && !is_string($hxb__bct_available)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb__bct_available, true), gettype($hxb__bct_available)), __LINE__);
        }
        if (is_null($hxb__bct_available) || (is_array($hxb__bct_available) && empty($hxb__bct_available))) {
            unset($this->hxb__bct_available);
        } else {
            $this->hxb__bct_available = $hxb__bct_available;
        }
        
        return $this;
    }
    /**
     * Get hxb__bct_sold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb__bct_sold(): ?string
    {
        return $this->hxb__bct_sold ?? null;
    }
    /**
     * Set hxb__bct_sold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb__bct_sold
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb__bct_sold(?string $hxb__bct_sold = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb__bct_sold) && !is_string($hxb__bct_sold)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb__bct_sold, true), gettype($hxb__bct_sold)), __LINE__);
        }
        if (is_null($hxb__bct_sold) || (is_array($hxb__bct_sold) && empty($hxb__bct_sold))) {
            unset($this->hxb__bct_sold);
        } else {
            $this->hxb__bct_sold = $hxb__bct_sold;
        }
        
        return $this;
    }
    /**
     * Get hxb__bct_inventory_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb__bct_inventory_qty(): ?string
    {
        return $this->hxb__bct_inventory_qty ?? null;
    }
    /**
     * Set hxb__bct_inventory_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb__bct_inventory_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb__bct_inventory_qty(?string $hxb__bct_inventory_qty = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb__bct_inventory_qty) && !is_string($hxb__bct_inventory_qty)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb__bct_inventory_qty, true), gettype($hxb__bct_inventory_qty)), __LINE__);
        }
        if (is_null($hxb__bct_inventory_qty) || (is_array($hxb__bct_inventory_qty) && empty($hxb__bct_inventory_qty))) {
            unset($this->hxb__bct_inventory_qty);
        } else {
            $this->hxb__bct_inventory_qty = $hxb__bct_inventory_qty;
        }
        
        return $this;
    }
    /**
     * Get hxb_shared_responsibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_shared_responsibility(): ?string
    {
        return $this->hxb_shared_responsibility ?? null;
    }
    /**
     * Set hxb_shared_responsibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_shared_responsibility
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_shared_responsibility(?string $hxb_shared_responsibility = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_shared_responsibility) && !is_string($hxb_shared_responsibility)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_shared_responsibility, true), gettype($hxb_shared_responsibility)), __LINE__);
        }
        if (is_null($hxb_shared_responsibility) || (is_array($hxb_shared_responsibility) && empty($hxb_shared_responsibility))) {
            unset($this->hxb_shared_responsibility);
        } else {
            $this->hxb_shared_responsibility = $hxb_shared_responsibility;
        }
        
        return $this;
    }
    /**
     * Get hxb_display_wait_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_display_wait_list(): ?string
    {
        return $this->hxb_display_wait_list ?? null;
    }
    /**
     * Set hxb_display_wait_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_display_wait_list
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_display_wait_list(?string $hxb_display_wait_list = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_display_wait_list) && !is_string($hxb_display_wait_list)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_display_wait_list, true), gettype($hxb_display_wait_list)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($hxb_display_wait_list) && $hxb_display_wait_list > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($hxb_display_wait_list, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hxb_display_wait_list) && $hxb_display_wait_list < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hxb_display_wait_list, true)), __LINE__);
        }
        if (is_null($hxb_display_wait_list) || (is_array($hxb_display_wait_list) && empty($hxb_display_wait_list))) {
            unset($this->hxb_display_wait_list);
        } else {
            $this->hxb_display_wait_list = $hxb_display_wait_list;
        }
        
        return $this;
    }
    /**
     * Get hxb_search_by_booth_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_search_by_booth_type(): ?string
    {
        return $this->hxb_search_by_booth_type ?? null;
    }
    /**
     * Set hxb_search_by_booth_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_search_by_booth_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_search_by_booth_type(?string $hxb_search_by_booth_type = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_search_by_booth_type) && !is_string($hxb_search_by_booth_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_search_by_booth_type, true), gettype($hxb_search_by_booth_type)), __LINE__);
        }
        if (is_null($hxb_search_by_booth_type) || (is_array($hxb_search_by_booth_type) && empty($hxb_search_by_booth_type))) {
            unset($this->hxb_search_by_booth_type);
        } else {
            $this->hxb_search_by_booth_type = $hxb_search_by_booth_type;
        }
        
        return $this;
    }
    /**
     * Get hxb_search_by_booth_category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_search_by_booth_category(): ?string
    {
        return $this->hxb_search_by_booth_category ?? null;
    }
    /**
     * Set hxb_search_by_booth_category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_search_by_booth_category
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_search_by_booth_category(?string $hxb_search_by_booth_category = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_search_by_booth_category) && !is_string($hxb_search_by_booth_category)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_search_by_booth_category, true), gettype($hxb_search_by_booth_category)), __LINE__);
        }
        if (is_null($hxb_search_by_booth_category) || (is_array($hxb_search_by_booth_category) && empty($hxb_search_by_booth_category))) {
            unset($this->hxb_search_by_booth_category);
        } else {
            $this->hxb_search_by_booth_category = $hxb_search_by_booth_category;
        }
        
        return $this;
    }
    /**
     * Get hxb_search_by_booth_product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_search_by_booth_product(): ?string
    {
        return $this->hxb_search_by_booth_product ?? null;
    }
    /**
     * Set hxb_search_by_booth_product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_search_by_booth_product
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_search_by_booth_product(?string $hxb_search_by_booth_product = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_search_by_booth_product) && !is_string($hxb_search_by_booth_product)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_search_by_booth_product, true), gettype($hxb_search_by_booth_product)), __LINE__);
        }
        if (is_null($hxb_search_by_booth_product) || (is_array($hxb_search_by_booth_product) && empty($hxb_search_by_booth_product))) {
            unset($this->hxb_search_by_booth_product);
        } else {
            $this->hxb_search_by_booth_product = $hxb_search_by_booth_product;
        }
        
        return $this;
    }
    /**
     * Get hxb_cancel_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_cancel_flag(): ?string
    {
        return $this->hxb_cancel_flag ?? null;
    }
    /**
     * Set hxb_cancel_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_cancel_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_cancel_flag(?string $hxb_cancel_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_cancel_flag) && !is_string($hxb_cancel_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_cancel_flag, true), gettype($hxb_cancel_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($hxb_cancel_flag) && $hxb_cancel_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($hxb_cancel_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hxb_cancel_flag) && $hxb_cancel_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hxb_cancel_flag, true)), __LINE__);
        }
        if (is_null($hxb_cancel_flag) || (is_array($hxb_cancel_flag) && empty($hxb_cancel_flag))) {
            unset($this->hxb_cancel_flag);
        } else {
            $this->hxb_cancel_flag = $hxb_cancel_flag;
        }
        
        return $this;
    }
    /**
     * Get hxb_sell_space value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHxb_sell_space(): ?string
    {
        return $this->hxb_sell_space ?? null;
    }
    /**
     * Set hxb_sell_space value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hxb_sell_space
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorBoothNew_Exhibitor_Booth_DataObjectType
     */
    public function setHxb_sell_space(?string $hxb_sell_space = null): self
    {
        // validation for constraint: string
        if (!is_null($hxb_sell_space) && !is_string($hxb_sell_space)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hxb_sell_space, true), gettype($hxb_sell_space)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($hxb_sell_space) && $hxb_sell_space > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($hxb_sell_space, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hxb_sell_space) && $hxb_sell_space < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hxb_sell_space, true)), __LINE__);
        }
        if (is_null($hxb_sell_space) || (is_array($hxb_sell_space) && empty($hxb_sell_space))) {
            unset($this->hxb_sell_space);
        } else {
            $this->hxb_sell_space = $hxb_sell_space;
        }
        
        return $this;
    }
}
