<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNewType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNewType extends AbstractStructBase
{
    /**
     * The Exhibitor
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType $Exhibitor = null;
    /**
     * The Exhibit_Show
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibit_Show_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibit_Show_DataObjectType $Exhibit_Show = null;
    /**
     * The Booth_Person
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType $Booth_Person = null;
    /**
     * The Exhibitor_Booth
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Booth_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Booth_DataObjectType $Exhibitor_Booth = null;
    /**
     * The booth_complement
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType $booth_complement = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Customer_DataObjectType $Customer = null;
    /**
     * The Contact_Person
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType $Contact_Person = null;
    /**
     * The priority_points
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType $priority_points = null;
    /**
     * The Invoice
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Invoice_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Invoice_DataObjectType $Invoice = null;
    /**
     * The Payment
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_DataObjectType $Payment = null;
    /**
     * The Payment_Info
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Info_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Info_DataObjectType $Payment_Info = null;
    /**
     * The Payment_Method
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Method_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Method_DataObjectType $Payment_Method = null;
    /**
     * The Billing_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Billing_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Billing_Address_DataObjectType $Billing_Address = null;
    /**
     * The BillToCustomer
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_BillToCustomer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_BillToCustomer_DataObjectType $BillToCustomer = null;
    /**
     * The Installment_Billing
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Installment_Billing_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Installment_Billing_DataObjectType $Installment_Billing = null;
    /**
     * The Exhibitor_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Address_DataObjectType $Exhibitor_Address = null;
    /**
     * The Primary_Contact_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Address_DataObjectType $Primary_Contact_Address = null;
    /**
     * The Exhibitor_X_Contact
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType $Exhibitor_X_Contact = null;
    /**
     * The Shared_Booth
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType $Shared_Booth = null;
    /**
     * The Sponsor
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType $Sponsor = null;
    /**
     * The Primary_Contact_Email
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Email_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Email_DataObjectType $Primary_Contact_Email = null;
    /**
     * The Primary_Contact_Website
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType $Primary_Contact_Website = null;
    /**
     * The Exhibitor_Email
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType $Exhibitor_Email = null;
    /**
     * The Exhibitor_Website
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Website_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Website_DataObjectType $Exhibitor_Website = null;
    /**
     * The Exhibitor_BoothCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Exhibitor_BoothCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Exhibitor_BoothCollectionType $Exhibitor_BoothCollection = null;
    /**
     * The Invoice_DetailCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $Invoice_DetailCollection = null;
    /**
     * The Additional_Invoice_DetailCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $Additional_Invoice_DetailCollection = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Unique Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for ExhibitorNewType
     * @uses ExhibitorNewType::setExhibitor()
     * @uses ExhibitorNewType::setExhibit_Show()
     * @uses ExhibitorNewType::setBooth_Person()
     * @uses ExhibitorNewType::setExhibitor_Booth()
     * @uses ExhibitorNewType::setBooth_complement()
     * @uses ExhibitorNewType::setCustomer()
     * @uses ExhibitorNewType::setContact_Person()
     * @uses ExhibitorNewType::setPriority_points()
     * @uses ExhibitorNewType::setInvoice()
     * @uses ExhibitorNewType::setPayment()
     * @uses ExhibitorNewType::setPayment_Info()
     * @uses ExhibitorNewType::setPayment_Method()
     * @uses ExhibitorNewType::setBilling_Address()
     * @uses ExhibitorNewType::setBillToCustomer()
     * @uses ExhibitorNewType::setInstallment_Billing()
     * @uses ExhibitorNewType::setExhibitor_Address()
     * @uses ExhibitorNewType::setPrimary_Contact_Address()
     * @uses ExhibitorNewType::setExhibitor_X_Contact()
     * @uses ExhibitorNewType::setShared_Booth()
     * @uses ExhibitorNewType::setSponsor()
     * @uses ExhibitorNewType::setPrimary_Contact_Email()
     * @uses ExhibitorNewType::setPrimary_Contact_Website()
     * @uses ExhibitorNewType::setExhibitor_Email()
     * @uses ExhibitorNewType::setExhibitor_Website()
     * @uses ExhibitorNewType::setExhibitor_BoothCollection()
     * @uses ExhibitorNewType::setInvoice_DetailCollection()
     * @uses ExhibitorNewType::setAdditional_Invoice_DetailCollection()
     * @uses ExhibitorNewType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType $exhibitor
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibit_Show_DataObjectType $exhibit_Show
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType $booth_Person
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Booth_DataObjectType $exhibitor_Booth
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType $booth_complement
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType $contact_Person
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType $priority_points
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Invoice_DataObjectType $invoice
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_DataObjectType $payment
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Info_DataObjectType $payment_Info
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Method_DataObjectType $payment_Method
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Billing_Address_DataObjectType $billing_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_BillToCustomer_DataObjectType $billToCustomer
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Installment_Billing_DataObjectType $installment_Billing
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Address_DataObjectType $exhibitor_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Address_DataObjectType $primary_Contact_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType $exhibitor_X_Contact
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType $shared_Booth
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType $sponsor
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Email_DataObjectType $primary_Contact_Email
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType $primary_Contact_Website
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType $exhibitor_Email
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Website_DataObjectType $exhibitor_Website
     * @param \Drupal\netforum\xWeb\Generated\StructType\Exhibitor_BoothCollectionType $exhibitor_BoothCollection
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @param \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType $exhibitor = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibit_Show_DataObjectType $exhibit_Show = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType $booth_Person = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Booth_DataObjectType $exhibitor_Booth = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType $booth_complement = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType $contact_Person = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType $priority_points = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Invoice_DataObjectType $invoice = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_DataObjectType $payment = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Info_DataObjectType $payment_Info = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Method_DataObjectType $payment_Method = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Billing_Address_DataObjectType $billing_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_BillToCustomer_DataObjectType $billToCustomer = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Installment_Billing_DataObjectType $installment_Billing = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Address_DataObjectType $exhibitor_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Address_DataObjectType $primary_Contact_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType $exhibitor_X_Contact = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType $shared_Booth = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType $sponsor = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Email_DataObjectType $primary_Contact_Email = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType $primary_Contact_Website = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType $exhibitor_Email = null, ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Website_DataObjectType $exhibitor_Website = null, ?\Drupal\netforum\xWeb\Generated\StructType\Exhibitor_BoothCollectionType $exhibitor_BoothCollection = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null, ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection = null, ?string $currentKey = null)
    {
        $this
            ->setExhibitor($exhibitor)
            ->setExhibit_Show($exhibit_Show)
            ->setBooth_Person($booth_Person)
            ->setExhibitor_Booth($exhibitor_Booth)
            ->setBooth_complement($booth_complement)
            ->setCustomer($customer)
            ->setContact_Person($contact_Person)
            ->setPriority_points($priority_points)
            ->setInvoice($invoice)
            ->setPayment($payment)
            ->setPayment_Info($payment_Info)
            ->setPayment_Method($payment_Method)
            ->setBilling_Address($billing_Address)
            ->setBillToCustomer($billToCustomer)
            ->setInstallment_Billing($installment_Billing)
            ->setExhibitor_Address($exhibitor_Address)
            ->setPrimary_Contact_Address($primary_Contact_Address)
            ->setExhibitor_X_Contact($exhibitor_X_Contact)
            ->setShared_Booth($shared_Booth)
            ->setSponsor($sponsor)
            ->setPrimary_Contact_Email($primary_Contact_Email)
            ->setPrimary_Contact_Website($primary_Contact_Website)
            ->setExhibitor_Email($exhibitor_Email)
            ->setExhibitor_Website($exhibitor_Website)
            ->setExhibitor_BoothCollection($exhibitor_BoothCollection)
            ->setInvoice_DetailCollection($invoice_DetailCollection)
            ->setAdditional_Invoice_DetailCollection($additional_Invoice_DetailCollection)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Exhibitor value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType|null
     */
    public function getExhibitor(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
    {
        return $this->Exhibitor;
    }
    /**
     * Set Exhibitor value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType $exhibitor
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setExhibitor(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType $exhibitor = null): self
    {
        $this->Exhibitor = $exhibitor;
        
        return $this;
    }
    /**
     * Get Exhibit_Show value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibit_Show_DataObjectType|null
     */
    public function getExhibit_Show(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibit_Show_DataObjectType
    {
        return $this->Exhibit_Show;
    }
    /**
     * Set Exhibit_Show value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibit_Show_DataObjectType $exhibit_Show
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setExhibit_Show(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibit_Show_DataObjectType $exhibit_Show = null): self
    {
        $this->Exhibit_Show = $exhibit_Show;
        
        return $this;
    }
    /**
     * Get Booth_Person value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType|null
     */
    public function getBooth_Person(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType
    {
        return $this->Booth_Person;
    }
    /**
     * Set Booth_Person value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType $booth_Person
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setBooth_Person(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Booth_Person_DataObjectType $booth_Person = null): self
    {
        $this->Booth_Person = $booth_Person;
        
        return $this;
    }
    /**
     * Get Exhibitor_Booth value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Booth_DataObjectType|null
     */
    public function getExhibitor_Booth(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Booth_DataObjectType
    {
        return $this->Exhibitor_Booth;
    }
    /**
     * Set Exhibitor_Booth value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Booth_DataObjectType $exhibitor_Booth
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setExhibitor_Booth(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Booth_DataObjectType $exhibitor_Booth = null): self
    {
        $this->Exhibitor_Booth = $exhibitor_Booth;
        
        return $this;
    }
    /**
     * Get booth_complement value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType|null
     */
    public function getBooth_complement(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType
    {
        return $this->booth_complement;
    }
    /**
     * Set booth_complement value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType $booth_complement
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setBooth_complement(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_booth_complement_DataObjectType $booth_complement = null): self
    {
        $this->booth_complement = $booth_complement;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Contact_Person value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType|null
     */
    public function getContact_Person(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
    {
        return $this->Contact_Person;
    }
    /**
     * Set Contact_Person value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType $contact_Person
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setContact_Person(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType $contact_Person = null): self
    {
        $this->Contact_Person = $contact_Person;
        
        return $this;
    }
    /**
     * Get priority_points value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType|null
     */
    public function getPriority_points(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType
    {
        return $this->priority_points;
    }
    /**
     * Set priority_points value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType $priority_points
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setPriority_points(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_priority_points_DataObjectType $priority_points = null): self
    {
        $this->priority_points = $priority_points;
        
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Invoice_DataObjectType|null
     */
    public function getInvoice(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Invoice_DataObjectType
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Invoice_DataObjectType $invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setInvoice(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Invoice_DataObjectType $invoice = null): self
    {
        $this->Invoice = $invoice;
        
        return $this;
    }
    /**
     * Get Payment value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_DataObjectType|null
     */
    public function getPayment(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_DataObjectType
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_DataObjectType $payment
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setPayment(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_DataObjectType $payment = null): self
    {
        $this->Payment = $payment;
        
        return $this;
    }
    /**
     * Get Payment_Info value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Info_DataObjectType|null
     */
    public function getPayment_Info(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Info_DataObjectType
    {
        return $this->Payment_Info;
    }
    /**
     * Set Payment_Info value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Info_DataObjectType $payment_Info
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setPayment_Info(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Info_DataObjectType $payment_Info = null): self
    {
        $this->Payment_Info = $payment_Info;
        
        return $this;
    }
    /**
     * Get Payment_Method value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Method_DataObjectType|null
     */
    public function getPayment_Method(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Method_DataObjectType
    {
        return $this->Payment_Method;
    }
    /**
     * Set Payment_Method value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Method_DataObjectType $payment_Method
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setPayment_Method(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Payment_Method_DataObjectType $payment_Method = null): self
    {
        $this->Payment_Method = $payment_Method;
        
        return $this;
    }
    /**
     * Get Billing_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Billing_Address_DataObjectType|null
     */
    public function getBilling_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Billing_Address_DataObjectType
    {
        return $this->Billing_Address;
    }
    /**
     * Set Billing_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Billing_Address_DataObjectType $billing_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setBilling_Address(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Billing_Address_DataObjectType $billing_Address = null): self
    {
        $this->Billing_Address = $billing_Address;
        
        return $this;
    }
    /**
     * Get BillToCustomer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_BillToCustomer_DataObjectType|null
     */
    public function getBillToCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_BillToCustomer_DataObjectType
    {
        return $this->BillToCustomer;
    }
    /**
     * Set BillToCustomer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_BillToCustomer_DataObjectType $billToCustomer
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setBillToCustomer(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_BillToCustomer_DataObjectType $billToCustomer = null): self
    {
        $this->BillToCustomer = $billToCustomer;
        
        return $this;
    }
    /**
     * Get Installment_Billing value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Installment_Billing_DataObjectType|null
     */
    public function getInstallment_Billing(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Installment_Billing_DataObjectType
    {
        return $this->Installment_Billing;
    }
    /**
     * Set Installment_Billing value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Installment_Billing_DataObjectType $installment_Billing
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setInstallment_Billing(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Installment_Billing_DataObjectType $installment_Billing = null): self
    {
        $this->Installment_Billing = $installment_Billing;
        
        return $this;
    }
    /**
     * Get Exhibitor_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Address_DataObjectType|null
     */
    public function getExhibitor_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Address_DataObjectType
    {
        return $this->Exhibitor_Address;
    }
    /**
     * Set Exhibitor_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Address_DataObjectType $exhibitor_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setExhibitor_Address(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Address_DataObjectType $exhibitor_Address = null): self
    {
        $this->Exhibitor_Address = $exhibitor_Address;
        
        return $this;
    }
    /**
     * Get Primary_Contact_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Address_DataObjectType|null
     */
    public function getPrimary_Contact_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Address_DataObjectType
    {
        return $this->Primary_Contact_Address;
    }
    /**
     * Set Primary_Contact_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Address_DataObjectType $primary_Contact_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setPrimary_Contact_Address(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Address_DataObjectType $primary_Contact_Address = null): self
    {
        $this->Primary_Contact_Address = $primary_Contact_Address;
        
        return $this;
    }
    /**
     * Get Exhibitor_X_Contact value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType|null
     */
    public function getExhibitor_X_Contact(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
    {
        return $this->Exhibitor_X_Contact;
    }
    /**
     * Set Exhibitor_X_Contact value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType $exhibitor_X_Contact
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setExhibitor_X_Contact(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType $exhibitor_X_Contact = null): self
    {
        $this->Exhibitor_X_Contact = $exhibitor_X_Contact;
        
        return $this;
    }
    /**
     * Get Shared_Booth value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType|null
     */
    public function getShared_Booth(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
    {
        return $this->Shared_Booth;
    }
    /**
     * Set Shared_Booth value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType $shared_Booth
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setShared_Booth(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType $shared_Booth = null): self
    {
        $this->Shared_Booth = $shared_Booth;
        
        return $this;
    }
    /**
     * Get Sponsor value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType|null
     */
    public function getSponsor(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
    {
        return $this->Sponsor;
    }
    /**
     * Set Sponsor value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType $sponsor
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setSponsor(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType $sponsor = null): self
    {
        $this->Sponsor = $sponsor;
        
        return $this;
    }
    /**
     * Get Primary_Contact_Email value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Email_DataObjectType|null
     */
    public function getPrimary_Contact_Email(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Email_DataObjectType
    {
        return $this->Primary_Contact_Email;
    }
    /**
     * Set Primary_Contact_Email value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Email_DataObjectType $primary_Contact_Email
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setPrimary_Contact_Email(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Email_DataObjectType $primary_Contact_Email = null): self
    {
        $this->Primary_Contact_Email = $primary_Contact_Email;
        
        return $this;
    }
    /**
     * Get Primary_Contact_Website value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType|null
     */
    public function getPrimary_Contact_Website(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType
    {
        return $this->Primary_Contact_Website;
    }
    /**
     * Set Primary_Contact_Website value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType $primary_Contact_Website
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setPrimary_Contact_Website(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Primary_Contact_Website_DataObjectType $primary_Contact_Website = null): self
    {
        $this->Primary_Contact_Website = $primary_Contact_Website;
        
        return $this;
    }
    /**
     * Get Exhibitor_Email value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType|null
     */
    public function getExhibitor_Email(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
    {
        return $this->Exhibitor_Email;
    }
    /**
     * Set Exhibitor_Email value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType $exhibitor_Email
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setExhibitor_Email(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType $exhibitor_Email = null): self
    {
        $this->Exhibitor_Email = $exhibitor_Email;
        
        return $this;
    }
    /**
     * Get Exhibitor_Website value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Website_DataObjectType|null
     */
    public function getExhibitor_Website(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Website_DataObjectType
    {
        return $this->Exhibitor_Website;
    }
    /**
     * Set Exhibitor_Website value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Website_DataObjectType $exhibitor_Website
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setExhibitor_Website(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Website_DataObjectType $exhibitor_Website = null): self
    {
        $this->Exhibitor_Website = $exhibitor_Website;
        
        return $this;
    }
    /**
     * Get Exhibitor_BoothCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Exhibitor_BoothCollectionType|null
     */
    public function getExhibitor_BoothCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Exhibitor_BoothCollectionType
    {
        return $this->Exhibitor_BoothCollection;
    }
    /**
     * Set Exhibitor_BoothCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Exhibitor_BoothCollectionType $exhibitor_BoothCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setExhibitor_BoothCollection(?\Drupal\netforum\xWeb\Generated\StructType\Exhibitor_BoothCollectionType $exhibitor_BoothCollection = null): self
    {
        $this->Exhibitor_BoothCollection = $exhibitor_BoothCollection;
        
        return $this;
    }
    /**
     * Get Invoice_DetailCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    public function getInvoice_DetailCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType
    {
        return $this->Invoice_DetailCollection;
    }
    /**
     * Set Invoice_DetailCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setInvoice_DetailCollection(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null): self
    {
        $this->Invoice_DetailCollection = $invoice_DetailCollection;
        
        return $this;
    }
    /**
     * Get Additional_Invoice_DetailCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType|null
     */
    public function getAdditional_Invoice_DetailCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType
    {
        return $this->Additional_Invoice_DetailCollection;
    }
    /**
     * Set Additional_Invoice_DetailCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setAdditional_Invoice_DetailCollection(?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection = null): self
    {
        $this->Additional_Invoice_DetailCollection = $additional_Invoice_DetailCollection;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
