<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_Contact_Person_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_Contact_Person_DataObjectType extends AbstractStructBase
{
    /**
     * The per__cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_key = null;
    /**
     * The per__cst_type
     * Meta information extracted from the WSDL
     * - documentation: Customer Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_type = null;
    /**
     * The per__cst_name_cp
     * Meta information extracted from the WSDL
     * - documentation: Name . This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_name_cp = null;
    /**
     * The per__cst_sort_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Customer Sort Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_sort_name_dn = null;
    /**
     * The per__cst_ind_full_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Full Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_ind_full_name_dn = null;
    /**
     * The per__cst_org_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Organization Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_org_name_dn = null;
    /**
     * The per__cst_ixo_title_dn
     * Meta information extracted from the WSDL
     * - documentation: Title. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_ixo_title_dn = null;
    /**
     * The per__cst_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Comm Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_pref_comm_meth = null;
    /**
     * The per__cst_bio
     * Meta information extracted from the WSDL
     * - documentation: Biographical Information. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_bio = null;
    /**
     * The per__cst_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_add_date = null;
    /**
     * The per__cst_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_add_user = null;
    /**
     * The per__cst_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_change_date = null;
    /**
     * The per__cst_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_change_user = null;
    /**
     * The per__cst_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_delete_flag = null;
    /**
     * The per__cst_recno
     * Meta information extracted from the WSDL
     * - documentation: Record Number. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 9223372036854775807
     * - maxOccurs: 1
     * - minInclusive: -9223372036854775808
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $per__cst_recno = null;
    /**
     * The per__cst_id
     * Meta information extracted from the WSDL
     * - documentation: Customer ID. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_id = null;
    /**
     * The per__cst_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_key_ext = null;
    /**
     * The per__cst_email_text_only
     * Meta information extracted from the WSDL
     * - documentation: Send Only Plain Text E-mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_email_text_only = null;
    /**
     * The per__cst_credit_limit
     * Meta information extracted from the WSDL
     * - documentation: credit limit. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $per__cst_credit_limit = null;
    /**
     * The per__cst_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_src_key = null;
    /**
     * The per__cst_src_code
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_src_code = null;
    /**
     * The per__cst_tax_exempt_flag
     * Meta information extracted from the WSDL
     * - documentation: Tax Exempt. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_tax_exempt_flag = null;
    /**
     * The per__cst_tax_id
     * Meta information extracted from the WSDL
     * - documentation: Tax Id. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_tax_id = null;
    /**
     * The per__cst_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Preferred Mailing Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_cxa_key = null;
    /**
     * The per__cst_no_email_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact by Email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_no_email_flag = null;
    /**
     * The per__cst_cxa_billing_key
     * Meta information extracted from the WSDL
     * - documentation: Billing Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_cxa_billing_key = null;
    /**
     * The per__cst_eml_address_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary E-Mail. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_eml_address_dn = null;
    /**
     * The per__cst_eml_key
     * Meta information extracted from the WSDL
     * - documentation: Primary E-Mail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_eml_key = null;
    /**
     * The per__cst_no_phone_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Phone. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_no_phone_flag = null;
    /**
     * The per__cst_phn_number_complete_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Phone. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_phn_number_complete_dn = null;
    /**
     * The per__cst_cph_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Phone Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_cph_key = null;
    /**
     * The per__cst_no_fax_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_no_fax_flag = null;
    /**
     * The per__cst_fax_number_complete_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Fax. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_fax_number_complete_dn = null;
    /**
     * The per__cst_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Fax Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_cfx_key = null;
    /**
     * The per__cst_ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Organization Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_ixo_key = null;
    /**
     * The per__cst_no_web_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Make Available Online. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_no_web_flag = null;
    /**
     * The per__cst_oldid
     * Meta information extracted from the WSDL
     * - documentation: oldid. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_oldid = null;
    /**
     * The per__cst_member_flag
     * Meta information extracted from the WSDL
     * - documentation: Member Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_member_flag = null;
    /**
     * The per__cst_url_code_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Website. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_url_code_dn = null;
    /**
     * The per__cst_parent_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_parent_cst_key = null;
    /**
     * The per__cst_url_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Website Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_url_key = null;
    /**
     * The per__cst_no_msg_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Instant Mess. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_no_msg_flag = null;
    /**
     * The per__cst_msg_handle_dn
     * Meta information extracted from the WSDL
     * - documentation: Primary Instant Messaging Hand. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_msg_handle_dn = null;
    /**
     * The per__cst_web_login
     * Meta information extracted from the WSDL
     * - documentation: Web Login. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_login = null;
    /**
     * The per__cst_web_password
     * Meta information extracted from the WSDL
     * - documentation: Web Password. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_password = null;
    /**
     * The per__cst_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_entity_key = null;
    /**
     * The per__cst_msg_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Instant Messaging Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_msg_key = null;
    /**
     * The per__cst_no_mail_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Contact By Mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_no_mail_flag = null;
    /**
     * The per__cst_web_start_date
     * Meta information extracted from the WSDL
     * - documentation: Web Login Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_start_date = null;
    /**
     * The per__cst_web_end_date
     * Meta information extracted from the WSDL
     * - documentation: Web Login End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_end_date = null;
    /**
     * The per__cst_web_force_password_change
     * Meta information extracted from the WSDL
     * - documentation: Force User to Change Password. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_force_password_change = null;
    /**
     * The per__cst_web_login_disabled_flag
     * Meta information extracted from the WSDL
     * - documentation: Web Login Disabled. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_login_disabled_flag = null;
    /**
     * The per__cst_comment
     * Meta information extracted from the WSDL
     * - documentation: Comments. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_comment = null;
    /**
     * The per__cst_credit_hold_flag
     * Meta information extracted from the WSDL
     * - documentation: Credit Hold Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_credit_hold_flag = null;
    /**
     * The per__cst_credit_hold_reason
     * Meta information extracted from the WSDL
     * - documentation: Credit Hold Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_credit_hold_reason = null;
    /**
     * The per__cst_web_forgot_password_status
     * Meta information extracted from the WSDL
     * - documentation: Forgot Password Status. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_forgot_password_status = null;
    /**
     * The per__cst_old_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Old Primary Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_old_cxa_key = null;
    /**
     * The per__cst_last_email_date
     * Meta information extracted from the WSDL
     * - documentation: last email date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_last_email_date = null;
    /**
     * The per__cst_no_publish_flag
     * Meta information extracted from the WSDL
     * - documentation: Do not publish to other systems?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_no_publish_flag = null;
    /**
     * The per__cst_sin_key
     * Meta information extracted from the WSDL
     * - documentation: industry. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_sin_key = null;
    /**
     * The per__cst_ttl_key
     * Meta information extracted from the WSDL
     * - documentation: title. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_ttl_key = null;
    /**
     * The per__cst_jfn_key
     * Meta information extracted from the WSDL
     * - documentation: job function. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_jfn_key = null;
    /**
     * The per__cst_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_cur_key = null;
    /**
     * The per__cst_attribute_1
     * Meta information extracted from the WSDL
     * - documentation: price attribute 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 510
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_attribute_1 = null;
    /**
     * The per__cst_attribute_2
     * Meta information extracted from the WSDL
     * - documentation: price attribute 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 510
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_attribute_2 = null;
    /**
     * The per__cst_salutation_1
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_salutation_1 = null;
    /**
     * The per__cst_salutation_2
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_salutation_2 = null;
    /**
     * The per__cst_merge_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Merged Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_merge_cst_key = null;
    /**
     * The per__cst_salutation_3
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_salutation_3 = null;
    /**
     * The per__cst_salutation_4
     * Meta information extracted from the WSDL
     * - documentation: customer Salutation 4. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_salutation_4 = null;
    /**
     * The per__cst_default_recognize_as
     * Meta information extracted from the WSDL
     * - documentation: default recognize as. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_default_recognize_as = null;
    /**
     * The per__cst_score
     * Meta information extracted from the WSDL
     * - documentation: Score. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $per__cst_score = null;
    /**
     * The per__cst_score_normalized
     * Meta information extracted from the WSDL
     * - documentation: Normalized Score. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $per__cst_score_normalized = null;
    /**
     * The per__cst_score_trend
     * Meta information extracted from the WSDL
     * - documentation: Scoring Trend. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $per__cst_score_trend = null;
    /**
     * The per__cst_vault_account
     * Meta information extracted from the WSDL
     * - documentation: Vault Customer Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_vault_account = null;
    /**
     * The per__cst_exclude_from_social_flag
     * Meta information extracted from the WSDL
     * - documentation: Exclude from Social. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_exclude_from_social_flag = null;
    /**
     * The per__cst_social_score
     * Meta information extracted from the WSDL
     * - documentation: Social Score. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $per__cst_social_score = null;
    /**
     * The per__cst_ptin
     * Meta information extracted from the WSDL
     * - documentation: PTIN. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_ptin = null;
    /**
     * The per__cst_aicpa_member_id
     * Meta information extracted from the WSDL
     * - documentation: AICPA Member ID. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 9223372036854775807
     * - maxOccurs: 1
     * - minInclusive: -9223372036854775808
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $per__cst_aicpa_member_id = null;
    /**
     * The per__cst_vendor_code
     * Meta information extracted from the WSDL
     * - documentation: Vendor Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_vendor_code = null;
    /**
     * The per__cst_salt
     * Meta information extracted from the WSDL
     * - documentation: Salt. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_salt = null;
    /**
     * The per__cst_sca_key
     * Meta information extracted from the WSDL
     * - documentation: Primary A-Score Scale. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_sca_key = null;
    /**
     * The per__cst_iterations
     * Meta information extracted from the WSDL
     * - documentation: Iterations. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $per__cst_iterations = null;
    /**
     * The per__cst_web_password_change_date
     * Meta information extracted from the WSDL
     * - documentation: Web Password Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_password_change_date = null;
    /**
     * The per__cst_web_failed_login_count
     * Meta information extracted from the WSDL
     * - documentation: Web Failed Login Count. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_failed_login_count = null;
    /**
     * The per__cst_web_last_failed_login_date
     * Meta information extracted from the WSDL
     * - documentation: Web Last Failed Login Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_last_failed_login_date = null;
    /**
     * The per__cst_web_login_locked_flag
     * Meta information extracted from the WSDL
     * - documentation: Web Login Locked. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_web_login_locked_flag = null;
    /**
     * The per__cst_cph_sms_key
     * Meta information extracted from the WSDL
     * - documentation: Preferred Phone SMS. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $per__cst_cph_sms_key = null;
    /**
     * The per__cst_sms_opt
     * Meta information extracted from the WSDL
     * - documentation: SMS OptIn OptOut. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_sms_opt = null;
    /**
     * The per__cst_sms_consent_type
     * Meta information extracted from the WSDL
     * - documentation: Consent Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_sms_consent_type = null;
    /**
     * The per__cst_failed_payment_attempts
     * Meta information extracted from the WSDL
     * - documentation: per__cst_failed_payment_attempts. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $per__cst_failed_payment_attempts = null;
    /**
     * Constructor method for ExhibitorNew_Contact_Person_DataObjectType
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_type()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_name_cp()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_sort_name_dn()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_ind_full_name_dn()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_org_name_dn()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_ixo_title_dn()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_pref_comm_meth()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_bio()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_add_date()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_add_user()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_change_date()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_change_user()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_delete_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_recno()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_id()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_key_ext()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_email_text_only()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_credit_limit()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_src_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_src_code()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_tax_exempt_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_tax_id()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_cxa_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_no_email_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_cxa_billing_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_eml_address_dn()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_eml_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_no_phone_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_phn_number_complete_dn()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_cph_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_no_fax_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_fax_number_complete_dn()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_cfx_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_ixo_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_no_web_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_oldid()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_member_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_url_code_dn()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_parent_cst_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_url_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_no_msg_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_msg_handle_dn()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_login()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_password()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_entity_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_msg_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_no_mail_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_start_date()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_end_date()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_force_password_change()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_login_disabled_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_comment()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_credit_hold_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_credit_hold_reason()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_forgot_password_status()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_old_cxa_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_last_email_date()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_no_publish_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_sin_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_ttl_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_jfn_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_cur_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_attribute_1()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_attribute_2()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_salutation_1()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_salutation_2()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_merge_cst_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_salutation_3()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_salutation_4()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_default_recognize_as()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_score()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_score_normalized()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_score_trend()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_vault_account()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_exclude_from_social_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_social_score()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_ptin()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_aicpa_member_id()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_vendor_code()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_salt()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_sca_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_iterations()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_password_change_date()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_failed_login_count()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_last_failed_login_date()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_web_login_locked_flag()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_cph_sms_key()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_sms_opt()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_sms_consent_type()
     * @uses ExhibitorNew_Contact_Person_DataObjectType::setPer__cst_failed_payment_attempts()
     * @param string $per__cst_key
     * @param string $per__cst_type
     * @param string $per__cst_name_cp
     * @param string $per__cst_sort_name_dn
     * @param string $per__cst_ind_full_name_dn
     * @param string $per__cst_org_name_dn
     * @param string $per__cst_ixo_title_dn
     * @param string $per__cst_pref_comm_meth
     * @param string $per__cst_bio
     * @param string $per__cst_add_date
     * @param string $per__cst_add_user
     * @param string $per__cst_change_date
     * @param string $per__cst_change_user
     * @param string $per__cst_delete_flag
     * @param int $per__cst_recno
     * @param string $per__cst_id
     * @param string $per__cst_key_ext
     * @param string $per__cst_email_text_only
     * @param float $per__cst_credit_limit
     * @param string $per__cst_src_key
     * @param string $per__cst_src_code
     * @param string $per__cst_tax_exempt_flag
     * @param string $per__cst_tax_id
     * @param string $per__cst_cxa_key
     * @param string $per__cst_no_email_flag
     * @param string $per__cst_cxa_billing_key
     * @param string $per__cst_eml_address_dn
     * @param string $per__cst_eml_key
     * @param string $per__cst_no_phone_flag
     * @param string $per__cst_phn_number_complete_dn
     * @param string $per__cst_cph_key
     * @param string $per__cst_no_fax_flag
     * @param string $per__cst_fax_number_complete_dn
     * @param string $per__cst_cfx_key
     * @param string $per__cst_ixo_key
     * @param string $per__cst_no_web_flag
     * @param string $per__cst_oldid
     * @param string $per__cst_member_flag
     * @param string $per__cst_url_code_dn
     * @param string $per__cst_parent_cst_key
     * @param string $per__cst_url_key
     * @param string $per__cst_no_msg_flag
     * @param string $per__cst_msg_handle_dn
     * @param string $per__cst_web_login
     * @param string $per__cst_web_password
     * @param string $per__cst_entity_key
     * @param string $per__cst_msg_key
     * @param string $per__cst_no_mail_flag
     * @param string $per__cst_web_start_date
     * @param string $per__cst_web_end_date
     * @param string $per__cst_web_force_password_change
     * @param string $per__cst_web_login_disabled_flag
     * @param string $per__cst_comment
     * @param string $per__cst_credit_hold_flag
     * @param string $per__cst_credit_hold_reason
     * @param string $per__cst_web_forgot_password_status
     * @param string $per__cst_old_cxa_key
     * @param string $per__cst_last_email_date
     * @param string $per__cst_no_publish_flag
     * @param string $per__cst_sin_key
     * @param string $per__cst_ttl_key
     * @param string $per__cst_jfn_key
     * @param string $per__cst_cur_key
     * @param string $per__cst_attribute_1
     * @param string $per__cst_attribute_2
     * @param string $per__cst_salutation_1
     * @param string $per__cst_salutation_2
     * @param string $per__cst_merge_cst_key
     * @param string $per__cst_salutation_3
     * @param string $per__cst_salutation_4
     * @param string $per__cst_default_recognize_as
     * @param float $per__cst_score
     * @param int $per__cst_score_normalized
     * @param int $per__cst_score_trend
     * @param string $per__cst_vault_account
     * @param string $per__cst_exclude_from_social_flag
     * @param int $per__cst_social_score
     * @param string $per__cst_ptin
     * @param int $per__cst_aicpa_member_id
     * @param string $per__cst_vendor_code
     * @param string $per__cst_salt
     * @param string $per__cst_sca_key
     * @param int $per__cst_iterations
     * @param string $per__cst_web_password_change_date
     * @param string $per__cst_web_failed_login_count
     * @param string $per__cst_web_last_failed_login_date
     * @param string $per__cst_web_login_locked_flag
     * @param string $per__cst_cph_sms_key
     * @param string $per__cst_sms_opt
     * @param string $per__cst_sms_consent_type
     * @param string $per__cst_failed_payment_attempts
     */
    public function __construct(?string $per__cst_key = null, ?string $per__cst_type = null, ?string $per__cst_name_cp = null, ?string $per__cst_sort_name_dn = null, ?string $per__cst_ind_full_name_dn = null, ?string $per__cst_org_name_dn = null, ?string $per__cst_ixo_title_dn = null, ?string $per__cst_pref_comm_meth = null, ?string $per__cst_bio = null, ?string $per__cst_add_date = null, ?string $per__cst_add_user = null, ?string $per__cst_change_date = null, ?string $per__cst_change_user = null, ?string $per__cst_delete_flag = null, ?int $per__cst_recno = null, ?string $per__cst_id = null, ?string $per__cst_key_ext = null, ?string $per__cst_email_text_only = null, ?float $per__cst_credit_limit = null, ?string $per__cst_src_key = null, ?string $per__cst_src_code = null, ?string $per__cst_tax_exempt_flag = null, ?string $per__cst_tax_id = null, ?string $per__cst_cxa_key = null, ?string $per__cst_no_email_flag = null, ?string $per__cst_cxa_billing_key = null, ?string $per__cst_eml_address_dn = null, ?string $per__cst_eml_key = null, ?string $per__cst_no_phone_flag = null, ?string $per__cst_phn_number_complete_dn = null, ?string $per__cst_cph_key = null, ?string $per__cst_no_fax_flag = null, ?string $per__cst_fax_number_complete_dn = null, ?string $per__cst_cfx_key = null, ?string $per__cst_ixo_key = null, ?string $per__cst_no_web_flag = null, ?string $per__cst_oldid = null, ?string $per__cst_member_flag = null, ?string $per__cst_url_code_dn = null, ?string $per__cst_parent_cst_key = null, ?string $per__cst_url_key = null, ?string $per__cst_no_msg_flag = null, ?string $per__cst_msg_handle_dn = null, ?string $per__cst_web_login = null, ?string $per__cst_web_password = null, ?string $per__cst_entity_key = null, ?string $per__cst_msg_key = null, ?string $per__cst_no_mail_flag = null, ?string $per__cst_web_start_date = null, ?string $per__cst_web_end_date = null, ?string $per__cst_web_force_password_change = null, ?string $per__cst_web_login_disabled_flag = null, ?string $per__cst_comment = null, ?string $per__cst_credit_hold_flag = null, ?string $per__cst_credit_hold_reason = null, ?string $per__cst_web_forgot_password_status = null, ?string $per__cst_old_cxa_key = null, ?string $per__cst_last_email_date = null, ?string $per__cst_no_publish_flag = null, ?string $per__cst_sin_key = null, ?string $per__cst_ttl_key = null, ?string $per__cst_jfn_key = null, ?string $per__cst_cur_key = null, ?string $per__cst_attribute_1 = null, ?string $per__cst_attribute_2 = null, ?string $per__cst_salutation_1 = null, ?string $per__cst_salutation_2 = null, ?string $per__cst_merge_cst_key = null, ?string $per__cst_salutation_3 = null, ?string $per__cst_salutation_4 = null, ?string $per__cst_default_recognize_as = null, ?float $per__cst_score = null, ?int $per__cst_score_normalized = null, ?int $per__cst_score_trend = null, ?string $per__cst_vault_account = null, ?string $per__cst_exclude_from_social_flag = null, ?int $per__cst_social_score = null, ?string $per__cst_ptin = null, ?int $per__cst_aicpa_member_id = null, ?string $per__cst_vendor_code = null, ?string $per__cst_salt = null, ?string $per__cst_sca_key = null, ?int $per__cst_iterations = null, ?string $per__cst_web_password_change_date = null, ?string $per__cst_web_failed_login_count = null, ?string $per__cst_web_last_failed_login_date = null, ?string $per__cst_web_login_locked_flag = null, ?string $per__cst_cph_sms_key = null, ?string $per__cst_sms_opt = null, ?string $per__cst_sms_consent_type = null, ?string $per__cst_failed_payment_attempts = null)
    {
        $this
            ->setPer__cst_key($per__cst_key)
            ->setPer__cst_type($per__cst_type)
            ->setPer__cst_name_cp($per__cst_name_cp)
            ->setPer__cst_sort_name_dn($per__cst_sort_name_dn)
            ->setPer__cst_ind_full_name_dn($per__cst_ind_full_name_dn)
            ->setPer__cst_org_name_dn($per__cst_org_name_dn)
            ->setPer__cst_ixo_title_dn($per__cst_ixo_title_dn)
            ->setPer__cst_pref_comm_meth($per__cst_pref_comm_meth)
            ->setPer__cst_bio($per__cst_bio)
            ->setPer__cst_add_date($per__cst_add_date)
            ->setPer__cst_add_user($per__cst_add_user)
            ->setPer__cst_change_date($per__cst_change_date)
            ->setPer__cst_change_user($per__cst_change_user)
            ->setPer__cst_delete_flag($per__cst_delete_flag)
            ->setPer__cst_recno($per__cst_recno)
            ->setPer__cst_id($per__cst_id)
            ->setPer__cst_key_ext($per__cst_key_ext)
            ->setPer__cst_email_text_only($per__cst_email_text_only)
            ->setPer__cst_credit_limit($per__cst_credit_limit)
            ->setPer__cst_src_key($per__cst_src_key)
            ->setPer__cst_src_code($per__cst_src_code)
            ->setPer__cst_tax_exempt_flag($per__cst_tax_exempt_flag)
            ->setPer__cst_tax_id($per__cst_tax_id)
            ->setPer__cst_cxa_key($per__cst_cxa_key)
            ->setPer__cst_no_email_flag($per__cst_no_email_flag)
            ->setPer__cst_cxa_billing_key($per__cst_cxa_billing_key)
            ->setPer__cst_eml_address_dn($per__cst_eml_address_dn)
            ->setPer__cst_eml_key($per__cst_eml_key)
            ->setPer__cst_no_phone_flag($per__cst_no_phone_flag)
            ->setPer__cst_phn_number_complete_dn($per__cst_phn_number_complete_dn)
            ->setPer__cst_cph_key($per__cst_cph_key)
            ->setPer__cst_no_fax_flag($per__cst_no_fax_flag)
            ->setPer__cst_fax_number_complete_dn($per__cst_fax_number_complete_dn)
            ->setPer__cst_cfx_key($per__cst_cfx_key)
            ->setPer__cst_ixo_key($per__cst_ixo_key)
            ->setPer__cst_no_web_flag($per__cst_no_web_flag)
            ->setPer__cst_oldid($per__cst_oldid)
            ->setPer__cst_member_flag($per__cst_member_flag)
            ->setPer__cst_url_code_dn($per__cst_url_code_dn)
            ->setPer__cst_parent_cst_key($per__cst_parent_cst_key)
            ->setPer__cst_url_key($per__cst_url_key)
            ->setPer__cst_no_msg_flag($per__cst_no_msg_flag)
            ->setPer__cst_msg_handle_dn($per__cst_msg_handle_dn)
            ->setPer__cst_web_login($per__cst_web_login)
            ->setPer__cst_web_password($per__cst_web_password)
            ->setPer__cst_entity_key($per__cst_entity_key)
            ->setPer__cst_msg_key($per__cst_msg_key)
            ->setPer__cst_no_mail_flag($per__cst_no_mail_flag)
            ->setPer__cst_web_start_date($per__cst_web_start_date)
            ->setPer__cst_web_end_date($per__cst_web_end_date)
            ->setPer__cst_web_force_password_change($per__cst_web_force_password_change)
            ->setPer__cst_web_login_disabled_flag($per__cst_web_login_disabled_flag)
            ->setPer__cst_comment($per__cst_comment)
            ->setPer__cst_credit_hold_flag($per__cst_credit_hold_flag)
            ->setPer__cst_credit_hold_reason($per__cst_credit_hold_reason)
            ->setPer__cst_web_forgot_password_status($per__cst_web_forgot_password_status)
            ->setPer__cst_old_cxa_key($per__cst_old_cxa_key)
            ->setPer__cst_last_email_date($per__cst_last_email_date)
            ->setPer__cst_no_publish_flag($per__cst_no_publish_flag)
            ->setPer__cst_sin_key($per__cst_sin_key)
            ->setPer__cst_ttl_key($per__cst_ttl_key)
            ->setPer__cst_jfn_key($per__cst_jfn_key)
            ->setPer__cst_cur_key($per__cst_cur_key)
            ->setPer__cst_attribute_1($per__cst_attribute_1)
            ->setPer__cst_attribute_2($per__cst_attribute_2)
            ->setPer__cst_salutation_1($per__cst_salutation_1)
            ->setPer__cst_salutation_2($per__cst_salutation_2)
            ->setPer__cst_merge_cst_key($per__cst_merge_cst_key)
            ->setPer__cst_salutation_3($per__cst_salutation_3)
            ->setPer__cst_salutation_4($per__cst_salutation_4)
            ->setPer__cst_default_recognize_as($per__cst_default_recognize_as)
            ->setPer__cst_score($per__cst_score)
            ->setPer__cst_score_normalized($per__cst_score_normalized)
            ->setPer__cst_score_trend($per__cst_score_trend)
            ->setPer__cst_vault_account($per__cst_vault_account)
            ->setPer__cst_exclude_from_social_flag($per__cst_exclude_from_social_flag)
            ->setPer__cst_social_score($per__cst_social_score)
            ->setPer__cst_ptin($per__cst_ptin)
            ->setPer__cst_aicpa_member_id($per__cst_aicpa_member_id)
            ->setPer__cst_vendor_code($per__cst_vendor_code)
            ->setPer__cst_salt($per__cst_salt)
            ->setPer__cst_sca_key($per__cst_sca_key)
            ->setPer__cst_iterations($per__cst_iterations)
            ->setPer__cst_web_password_change_date($per__cst_web_password_change_date)
            ->setPer__cst_web_failed_login_count($per__cst_web_failed_login_count)
            ->setPer__cst_web_last_failed_login_date($per__cst_web_last_failed_login_date)
            ->setPer__cst_web_login_locked_flag($per__cst_web_login_locked_flag)
            ->setPer__cst_cph_sms_key($per__cst_cph_sms_key)
            ->setPer__cst_sms_opt($per__cst_sms_opt)
            ->setPer__cst_sms_consent_type($per__cst_sms_consent_type)
            ->setPer__cst_failed_payment_attempts($per__cst_failed_payment_attempts);
    }
    /**
     * Get per__cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_key(): ?string
    {
        return $this->per__cst_key ?? null;
    }
    /**
     * Set per__cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_key(?string $per__cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_key) && !is_string($per__cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_key, true), gettype($per__cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_key, true)), __LINE__);
        }
        if (is_null($per__cst_key) || (is_array($per__cst_key) && empty($per__cst_key))) {
            unset($this->per__cst_key);
        } else {
            $this->per__cst_key = $per__cst_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_type(): ?string
    {
        return $this->per__cst_type ?? null;
    }
    /**
     * Set per__cst_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_type(?string $per__cst_type = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_type) && !is_string($per__cst_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_type, true), gettype($per__cst_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($per__cst_type) && mb_strlen((string) $per__cst_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $per__cst_type)), __LINE__);
        }
        if (is_null($per__cst_type) || (is_array($per__cst_type) && empty($per__cst_type))) {
            unset($this->per__cst_type);
        } else {
            $this->per__cst_type = $per__cst_type;
        }
        
        return $this;
    }
    /**
     * Get per__cst_name_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_name_cp(): ?string
    {
        return $this->per__cst_name_cp ?? null;
    }
    /**
     * Set per__cst_name_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_name_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_name_cp(?string $per__cst_name_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_name_cp) && !is_string($per__cst_name_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_name_cp, true), gettype($per__cst_name_cp)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($per__cst_name_cp) && mb_strlen((string) $per__cst_name_cp) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $per__cst_name_cp)), __LINE__);
        }
        if (is_null($per__cst_name_cp) || (is_array($per__cst_name_cp) && empty($per__cst_name_cp))) {
            unset($this->per__cst_name_cp);
        } else {
            $this->per__cst_name_cp = $per__cst_name_cp;
        }
        
        return $this;
    }
    /**
     * Get per__cst_sort_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_sort_name_dn(): ?string
    {
        return $this->per__cst_sort_name_dn ?? null;
    }
    /**
     * Set per__cst_sort_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_sort_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_sort_name_dn(?string $per__cst_sort_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_sort_name_dn) && !is_string($per__cst_sort_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_sort_name_dn, true), gettype($per__cst_sort_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($per__cst_sort_name_dn) && mb_strlen((string) $per__cst_sort_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $per__cst_sort_name_dn)), __LINE__);
        }
        if (is_null($per__cst_sort_name_dn) || (is_array($per__cst_sort_name_dn) && empty($per__cst_sort_name_dn))) {
            unset($this->per__cst_sort_name_dn);
        } else {
            $this->per__cst_sort_name_dn = $per__cst_sort_name_dn;
        }
        
        return $this;
    }
    /**
     * Get per__cst_ind_full_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_ind_full_name_dn(): ?string
    {
        return $this->per__cst_ind_full_name_dn ?? null;
    }
    /**
     * Set per__cst_ind_full_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_ind_full_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_ind_full_name_dn(?string $per__cst_ind_full_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_ind_full_name_dn) && !is_string($per__cst_ind_full_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_ind_full_name_dn, true), gettype($per__cst_ind_full_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($per__cst_ind_full_name_dn) && mb_strlen((string) $per__cst_ind_full_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $per__cst_ind_full_name_dn)), __LINE__);
        }
        if (is_null($per__cst_ind_full_name_dn) || (is_array($per__cst_ind_full_name_dn) && empty($per__cst_ind_full_name_dn))) {
            unset($this->per__cst_ind_full_name_dn);
        } else {
            $this->per__cst_ind_full_name_dn = $per__cst_ind_full_name_dn;
        }
        
        return $this;
    }
    /**
     * Get per__cst_org_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_org_name_dn(): ?string
    {
        return $this->per__cst_org_name_dn ?? null;
    }
    /**
     * Set per__cst_org_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_org_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_org_name_dn(?string $per__cst_org_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_org_name_dn) && !is_string($per__cst_org_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_org_name_dn, true), gettype($per__cst_org_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($per__cst_org_name_dn) && mb_strlen((string) $per__cst_org_name_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $per__cst_org_name_dn)), __LINE__);
        }
        if (is_null($per__cst_org_name_dn) || (is_array($per__cst_org_name_dn) && empty($per__cst_org_name_dn))) {
            unset($this->per__cst_org_name_dn);
        } else {
            $this->per__cst_org_name_dn = $per__cst_org_name_dn;
        }
        
        return $this;
    }
    /**
     * Get per__cst_ixo_title_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_ixo_title_dn(): ?string
    {
        return $this->per__cst_ixo_title_dn ?? null;
    }
    /**
     * Set per__cst_ixo_title_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_ixo_title_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_ixo_title_dn(?string $per__cst_ixo_title_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_ixo_title_dn) && !is_string($per__cst_ixo_title_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_ixo_title_dn, true), gettype($per__cst_ixo_title_dn)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($per__cst_ixo_title_dn) && mb_strlen((string) $per__cst_ixo_title_dn) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $per__cst_ixo_title_dn)), __LINE__);
        }
        if (is_null($per__cst_ixo_title_dn) || (is_array($per__cst_ixo_title_dn) && empty($per__cst_ixo_title_dn))) {
            unset($this->per__cst_ixo_title_dn);
        } else {
            $this->per__cst_ixo_title_dn = $per__cst_ixo_title_dn;
        }
        
        return $this;
    }
    /**
     * Get per__cst_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_pref_comm_meth(): ?string
    {
        return $this->per__cst_pref_comm_meth ?? null;
    }
    /**
     * Set per__cst_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_pref_comm_meth(?string $per__cst_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_pref_comm_meth) && !is_string($per__cst_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_pref_comm_meth, true), gettype($per__cst_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($per__cst_pref_comm_meth) && mb_strlen((string) $per__cst_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $per__cst_pref_comm_meth)), __LINE__);
        }
        if (is_null($per__cst_pref_comm_meth) || (is_array($per__cst_pref_comm_meth) && empty($per__cst_pref_comm_meth))) {
            unset($this->per__cst_pref_comm_meth);
        } else {
            $this->per__cst_pref_comm_meth = $per__cst_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get per__cst_bio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_bio(): ?string
    {
        return $this->per__cst_bio ?? null;
    }
    /**
     * Set per__cst_bio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_bio
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_bio(?string $per__cst_bio = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_bio) && !is_string($per__cst_bio)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_bio, true), gettype($per__cst_bio)), __LINE__);
        }
        if (is_null($per__cst_bio) || (is_array($per__cst_bio) && empty($per__cst_bio))) {
            unset($this->per__cst_bio);
        } else {
            $this->per__cst_bio = $per__cst_bio;
        }
        
        return $this;
    }
    /**
     * Get per__cst_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_add_date(): ?string
    {
        return $this->per__cst_add_date ?? null;
    }
    /**
     * Set per__cst_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_add_date(?string $per__cst_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_add_date) && !is_string($per__cst_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_add_date, true), gettype($per__cst_add_date)), __LINE__);
        }
        if (is_null($per__cst_add_date) || (is_array($per__cst_add_date) && empty($per__cst_add_date))) {
            unset($this->per__cst_add_date);
        } else {
            $this->per__cst_add_date = $per__cst_add_date;
        }
        
        return $this;
    }
    /**
     * Get per__cst_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_add_user(): ?string
    {
        return $this->per__cst_add_user ?? null;
    }
    /**
     * Set per__cst_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_add_user(?string $per__cst_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_add_user) && !is_string($per__cst_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_add_user, true), gettype($per__cst_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($per__cst_add_user) && mb_strlen((string) $per__cst_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $per__cst_add_user)), __LINE__);
        }
        if (is_null($per__cst_add_user) || (is_array($per__cst_add_user) && empty($per__cst_add_user))) {
            unset($this->per__cst_add_user);
        } else {
            $this->per__cst_add_user = $per__cst_add_user;
        }
        
        return $this;
    }
    /**
     * Get per__cst_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_change_date(): ?string
    {
        return $this->per__cst_change_date ?? null;
    }
    /**
     * Set per__cst_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_change_date(?string $per__cst_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_change_date) && !is_string($per__cst_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_change_date, true), gettype($per__cst_change_date)), __LINE__);
        }
        if (is_null($per__cst_change_date) || (is_array($per__cst_change_date) && empty($per__cst_change_date))) {
            unset($this->per__cst_change_date);
        } else {
            $this->per__cst_change_date = $per__cst_change_date;
        }
        
        return $this;
    }
    /**
     * Get per__cst_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_change_user(): ?string
    {
        return $this->per__cst_change_user ?? null;
    }
    /**
     * Set per__cst_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_change_user(?string $per__cst_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_change_user) && !is_string($per__cst_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_change_user, true), gettype($per__cst_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($per__cst_change_user) && mb_strlen((string) $per__cst_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $per__cst_change_user)), __LINE__);
        }
        if (is_null($per__cst_change_user) || (is_array($per__cst_change_user) && empty($per__cst_change_user))) {
            unset($this->per__cst_change_user);
        } else {
            $this->per__cst_change_user = $per__cst_change_user;
        }
        
        return $this;
    }
    /**
     * Get per__cst_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_delete_flag(): ?string
    {
        return $this->per__cst_delete_flag ?? null;
    }
    /**
     * Set per__cst_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_delete_flag(?string $per__cst_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_delete_flag) && !is_string($per__cst_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_delete_flag, true), gettype($per__cst_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_delete_flag) && $per__cst_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_delete_flag) && $per__cst_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_delete_flag, true)), __LINE__);
        }
        if (is_null($per__cst_delete_flag) || (is_array($per__cst_delete_flag) && empty($per__cst_delete_flag))) {
            unset($this->per__cst_delete_flag);
        } else {
            $this->per__cst_delete_flag = $per__cst_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_recno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPer__cst_recno(): ?int
    {
        return $this->per__cst_recno ?? null;
    }
    /**
     * Set per__cst_recno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $per__cst_recno
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_recno(?int $per__cst_recno = null): self
    {
        // validation for constraint: int
        if (!is_null($per__cst_recno) && !(is_int($per__cst_recno) || ctype_digit($per__cst_recno))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($per__cst_recno, true), gettype($per__cst_recno)), __LINE__);
        }
        // validation for constraint: maxInclusive(9223372036854775807)
        if (!is_null($per__cst_recno) && $per__cst_recno > 9223372036854775807) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9223372036854775807', var_export($per__cst_recno, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9223372036854775808)
        if (!is_null($per__cst_recno) && $per__cst_recno < -9223372036854775808) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9223372036854775808', var_export($per__cst_recno, true)), __LINE__);
        }
        if (is_null($per__cst_recno) || (is_array($per__cst_recno) && empty($per__cst_recno))) {
            unset($this->per__cst_recno);
        } else {
            $this->per__cst_recno = $per__cst_recno;
        }
        
        return $this;
    }
    /**
     * Get per__cst_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_id(): ?string
    {
        return $this->per__cst_id ?? null;
    }
    /**
     * Set per__cst_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_id(?string $per__cst_id = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_id) && !is_string($per__cst_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_id, true), gettype($per__cst_id)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($per__cst_id) && mb_strlen((string) $per__cst_id) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $per__cst_id)), __LINE__);
        }
        if (is_null($per__cst_id) || (is_array($per__cst_id) && empty($per__cst_id))) {
            unset($this->per__cst_id);
        } else {
            $this->per__cst_id = $per__cst_id;
        }
        
        return $this;
    }
    /**
     * Get per__cst_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_key_ext(): ?string
    {
        return $this->per__cst_key_ext ?? null;
    }
    /**
     * Set per__cst_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_key_ext(?string $per__cst_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_key_ext) && !is_string($per__cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_key_ext, true), gettype($per__cst_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_key_ext, true)), __LINE__);
        }
        if (is_null($per__cst_key_ext) || (is_array($per__cst_key_ext) && empty($per__cst_key_ext))) {
            unset($this->per__cst_key_ext);
        } else {
            $this->per__cst_key_ext = $per__cst_key_ext;
        }
        
        return $this;
    }
    /**
     * Get per__cst_email_text_only value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_email_text_only(): ?string
    {
        return $this->per__cst_email_text_only ?? null;
    }
    /**
     * Set per__cst_email_text_only value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_email_text_only
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_email_text_only(?string $per__cst_email_text_only = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_email_text_only) && !is_string($per__cst_email_text_only)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_email_text_only, true), gettype($per__cst_email_text_only)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_email_text_only) && $per__cst_email_text_only > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_email_text_only, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_email_text_only) && $per__cst_email_text_only < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_email_text_only, true)), __LINE__);
        }
        if (is_null($per__cst_email_text_only) || (is_array($per__cst_email_text_only) && empty($per__cst_email_text_only))) {
            unset($this->per__cst_email_text_only);
        } else {
            $this->per__cst_email_text_only = $per__cst_email_text_only;
        }
        
        return $this;
    }
    /**
     * Get per__cst_credit_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPer__cst_credit_limit(): ?float
    {
        return $this->per__cst_credit_limit ?? null;
    }
    /**
     * Set per__cst_credit_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $per__cst_credit_limit
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_credit_limit(?float $per__cst_credit_limit = null): self
    {
        // validation for constraint: float
        if (!is_null($per__cst_credit_limit) && !(is_float($per__cst_credit_limit) || is_numeric($per__cst_credit_limit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($per__cst_credit_limit, true), gettype($per__cst_credit_limit)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($per__cst_credit_limit) && mb_strlen(mb_substr((string) $per__cst_credit_limit, false !== mb_strpos((string) $per__cst_credit_limit, '.') ? mb_strpos((string) $per__cst_credit_limit, '.') + 1 : mb_strlen((string) $per__cst_credit_limit))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($per__cst_credit_limit, true), mb_strlen(mb_substr((string) $per__cst_credit_limit, mb_strpos((string) $per__cst_credit_limit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($per__cst_credit_limit) && mb_strlen(preg_replace('/(\D)/', '', (string) $per__cst_credit_limit)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($per__cst_credit_limit, true), mb_strlen(preg_replace('/(\D)/', '', (string) $per__cst_credit_limit))), __LINE__);
        }
        if (is_null($per__cst_credit_limit) || (is_array($per__cst_credit_limit) && empty($per__cst_credit_limit))) {
            unset($this->per__cst_credit_limit);
        } else {
            $this->per__cst_credit_limit = $per__cst_credit_limit;
        }
        
        return $this;
    }
    /**
     * Get per__cst_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_src_key(): ?string
    {
        return $this->per__cst_src_key ?? null;
    }
    /**
     * Set per__cst_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_src_key(?string $per__cst_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_src_key) && !is_string($per__cst_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_src_key, true), gettype($per__cst_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_src_key, true)), __LINE__);
        }
        if (is_null($per__cst_src_key) || (is_array($per__cst_src_key) && empty($per__cst_src_key))) {
            unset($this->per__cst_src_key);
        } else {
            $this->per__cst_src_key = $per__cst_src_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_src_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_src_code(): ?string
    {
        return $this->per__cst_src_code ?? null;
    }
    /**
     * Set per__cst_src_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_src_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_src_code(?string $per__cst_src_code = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_src_code) && !is_string($per__cst_src_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_src_code, true), gettype($per__cst_src_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($per__cst_src_code) && mb_strlen((string) $per__cst_src_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $per__cst_src_code)), __LINE__);
        }
        if (is_null($per__cst_src_code) || (is_array($per__cst_src_code) && empty($per__cst_src_code))) {
            unset($this->per__cst_src_code);
        } else {
            $this->per__cst_src_code = $per__cst_src_code;
        }
        
        return $this;
    }
    /**
     * Get per__cst_tax_exempt_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_tax_exempt_flag(): ?string
    {
        return $this->per__cst_tax_exempt_flag ?? null;
    }
    /**
     * Set per__cst_tax_exempt_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_tax_exempt_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_tax_exempt_flag(?string $per__cst_tax_exempt_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_tax_exempt_flag) && !is_string($per__cst_tax_exempt_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_tax_exempt_flag, true), gettype($per__cst_tax_exempt_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_tax_exempt_flag) && $per__cst_tax_exempt_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_tax_exempt_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_tax_exempt_flag) && $per__cst_tax_exempt_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_tax_exempt_flag, true)), __LINE__);
        }
        if (is_null($per__cst_tax_exempt_flag) || (is_array($per__cst_tax_exempt_flag) && empty($per__cst_tax_exempt_flag))) {
            unset($this->per__cst_tax_exempt_flag);
        } else {
            $this->per__cst_tax_exempt_flag = $per__cst_tax_exempt_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_tax_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_tax_id(): ?string
    {
        return $this->per__cst_tax_id ?? null;
    }
    /**
     * Set per__cst_tax_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_tax_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_tax_id(?string $per__cst_tax_id = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_tax_id) && !is_string($per__cst_tax_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_tax_id, true), gettype($per__cst_tax_id)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($per__cst_tax_id) && mb_strlen((string) $per__cst_tax_id) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $per__cst_tax_id)), __LINE__);
        }
        if (is_null($per__cst_tax_id) || (is_array($per__cst_tax_id) && empty($per__cst_tax_id))) {
            unset($this->per__cst_tax_id);
        } else {
            $this->per__cst_tax_id = $per__cst_tax_id;
        }
        
        return $this;
    }
    /**
     * Get per__cst_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_cxa_key(): ?string
    {
        return $this->per__cst_cxa_key ?? null;
    }
    /**
     * Set per__cst_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_cxa_key(?string $per__cst_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_cxa_key) && !is_string($per__cst_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_cxa_key, true), gettype($per__cst_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_cxa_key, true)), __LINE__);
        }
        if (is_null($per__cst_cxa_key) || (is_array($per__cst_cxa_key) && empty($per__cst_cxa_key))) {
            unset($this->per__cst_cxa_key);
        } else {
            $this->per__cst_cxa_key = $per__cst_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_no_email_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_no_email_flag(): ?string
    {
        return $this->per__cst_no_email_flag ?? null;
    }
    /**
     * Set per__cst_no_email_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_no_email_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_no_email_flag(?string $per__cst_no_email_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_no_email_flag) && !is_string($per__cst_no_email_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_no_email_flag, true), gettype($per__cst_no_email_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_no_email_flag) && $per__cst_no_email_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_no_email_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_no_email_flag) && $per__cst_no_email_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_no_email_flag, true)), __LINE__);
        }
        if (is_null($per__cst_no_email_flag) || (is_array($per__cst_no_email_flag) && empty($per__cst_no_email_flag))) {
            unset($this->per__cst_no_email_flag);
        } else {
            $this->per__cst_no_email_flag = $per__cst_no_email_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_cxa_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_cxa_billing_key(): ?string
    {
        return $this->per__cst_cxa_billing_key ?? null;
    }
    /**
     * Set per__cst_cxa_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_cxa_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_cxa_billing_key(?string $per__cst_cxa_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_cxa_billing_key) && !is_string($per__cst_cxa_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_cxa_billing_key, true), gettype($per__cst_cxa_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_cxa_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_cxa_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_cxa_billing_key, true)), __LINE__);
        }
        if (is_null($per__cst_cxa_billing_key) || (is_array($per__cst_cxa_billing_key) && empty($per__cst_cxa_billing_key))) {
            unset($this->per__cst_cxa_billing_key);
        } else {
            $this->per__cst_cxa_billing_key = $per__cst_cxa_billing_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_eml_address_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_eml_address_dn(): ?string
    {
        return $this->per__cst_eml_address_dn ?? null;
    }
    /**
     * Set per__cst_eml_address_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_eml_address_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_eml_address_dn(?string $per__cst_eml_address_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_eml_address_dn) && !is_string($per__cst_eml_address_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_eml_address_dn, true), gettype($per__cst_eml_address_dn)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($per__cst_eml_address_dn) && mb_strlen((string) $per__cst_eml_address_dn) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $per__cst_eml_address_dn)), __LINE__);
        }
        if (is_null($per__cst_eml_address_dn) || (is_array($per__cst_eml_address_dn) && empty($per__cst_eml_address_dn))) {
            unset($this->per__cst_eml_address_dn);
        } else {
            $this->per__cst_eml_address_dn = $per__cst_eml_address_dn;
        }
        
        return $this;
    }
    /**
     * Get per__cst_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_eml_key(): ?string
    {
        return $this->per__cst_eml_key ?? null;
    }
    /**
     * Set per__cst_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_eml_key(?string $per__cst_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_eml_key) && !is_string($per__cst_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_eml_key, true), gettype($per__cst_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_eml_key, true)), __LINE__);
        }
        if (is_null($per__cst_eml_key) || (is_array($per__cst_eml_key) && empty($per__cst_eml_key))) {
            unset($this->per__cst_eml_key);
        } else {
            $this->per__cst_eml_key = $per__cst_eml_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_no_phone_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_no_phone_flag(): ?string
    {
        return $this->per__cst_no_phone_flag ?? null;
    }
    /**
     * Set per__cst_no_phone_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_no_phone_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_no_phone_flag(?string $per__cst_no_phone_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_no_phone_flag) && !is_string($per__cst_no_phone_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_no_phone_flag, true), gettype($per__cst_no_phone_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_no_phone_flag) && $per__cst_no_phone_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_no_phone_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_no_phone_flag) && $per__cst_no_phone_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_no_phone_flag, true)), __LINE__);
        }
        if (is_null($per__cst_no_phone_flag) || (is_array($per__cst_no_phone_flag) && empty($per__cst_no_phone_flag))) {
            unset($this->per__cst_no_phone_flag);
        } else {
            $this->per__cst_no_phone_flag = $per__cst_no_phone_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_phn_number_complete_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_phn_number_complete_dn(): ?string
    {
        return $this->per__cst_phn_number_complete_dn ?? null;
    }
    /**
     * Set per__cst_phn_number_complete_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_phn_number_complete_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_phn_number_complete_dn(?string $per__cst_phn_number_complete_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_phn_number_complete_dn) && !is_string($per__cst_phn_number_complete_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_phn_number_complete_dn, true), gettype($per__cst_phn_number_complete_dn)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($per__cst_phn_number_complete_dn) && mb_strlen((string) $per__cst_phn_number_complete_dn) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $per__cst_phn_number_complete_dn)), __LINE__);
        }
        if (is_null($per__cst_phn_number_complete_dn) || (is_array($per__cst_phn_number_complete_dn) && empty($per__cst_phn_number_complete_dn))) {
            unset($this->per__cst_phn_number_complete_dn);
        } else {
            $this->per__cst_phn_number_complete_dn = $per__cst_phn_number_complete_dn;
        }
        
        return $this;
    }
    /**
     * Get per__cst_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_cph_key(): ?string
    {
        return $this->per__cst_cph_key ?? null;
    }
    /**
     * Set per__cst_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_cph_key(?string $per__cst_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_cph_key) && !is_string($per__cst_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_cph_key, true), gettype($per__cst_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_cph_key, true)), __LINE__);
        }
        if (is_null($per__cst_cph_key) || (is_array($per__cst_cph_key) && empty($per__cst_cph_key))) {
            unset($this->per__cst_cph_key);
        } else {
            $this->per__cst_cph_key = $per__cst_cph_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_no_fax_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_no_fax_flag(): ?string
    {
        return $this->per__cst_no_fax_flag ?? null;
    }
    /**
     * Set per__cst_no_fax_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_no_fax_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_no_fax_flag(?string $per__cst_no_fax_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_no_fax_flag) && !is_string($per__cst_no_fax_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_no_fax_flag, true), gettype($per__cst_no_fax_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_no_fax_flag) && $per__cst_no_fax_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_no_fax_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_no_fax_flag) && $per__cst_no_fax_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_no_fax_flag, true)), __LINE__);
        }
        if (is_null($per__cst_no_fax_flag) || (is_array($per__cst_no_fax_flag) && empty($per__cst_no_fax_flag))) {
            unset($this->per__cst_no_fax_flag);
        } else {
            $this->per__cst_no_fax_flag = $per__cst_no_fax_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_fax_number_complete_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_fax_number_complete_dn(): ?string
    {
        return $this->per__cst_fax_number_complete_dn ?? null;
    }
    /**
     * Set per__cst_fax_number_complete_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_fax_number_complete_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_fax_number_complete_dn(?string $per__cst_fax_number_complete_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_fax_number_complete_dn) && !is_string($per__cst_fax_number_complete_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_fax_number_complete_dn, true), gettype($per__cst_fax_number_complete_dn)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($per__cst_fax_number_complete_dn) && mb_strlen((string) $per__cst_fax_number_complete_dn) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $per__cst_fax_number_complete_dn)), __LINE__);
        }
        if (is_null($per__cst_fax_number_complete_dn) || (is_array($per__cst_fax_number_complete_dn) && empty($per__cst_fax_number_complete_dn))) {
            unset($this->per__cst_fax_number_complete_dn);
        } else {
            $this->per__cst_fax_number_complete_dn = $per__cst_fax_number_complete_dn;
        }
        
        return $this;
    }
    /**
     * Get per__cst_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_cfx_key(): ?string
    {
        return $this->per__cst_cfx_key ?? null;
    }
    /**
     * Set per__cst_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_cfx_key(?string $per__cst_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_cfx_key) && !is_string($per__cst_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_cfx_key, true), gettype($per__cst_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_cfx_key, true)), __LINE__);
        }
        if (is_null($per__cst_cfx_key) || (is_array($per__cst_cfx_key) && empty($per__cst_cfx_key))) {
            unset($this->per__cst_cfx_key);
        } else {
            $this->per__cst_cfx_key = $per__cst_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_ixo_key(): ?string
    {
        return $this->per__cst_ixo_key ?? null;
    }
    /**
     * Set per__cst_ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_ixo_key(?string $per__cst_ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_ixo_key) && !is_string($per__cst_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_ixo_key, true), gettype($per__cst_ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_ixo_key, true)), __LINE__);
        }
        if (is_null($per__cst_ixo_key) || (is_array($per__cst_ixo_key) && empty($per__cst_ixo_key))) {
            unset($this->per__cst_ixo_key);
        } else {
            $this->per__cst_ixo_key = $per__cst_ixo_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_no_web_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_no_web_flag(): ?string
    {
        return $this->per__cst_no_web_flag ?? null;
    }
    /**
     * Set per__cst_no_web_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_no_web_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_no_web_flag(?string $per__cst_no_web_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_no_web_flag) && !is_string($per__cst_no_web_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_no_web_flag, true), gettype($per__cst_no_web_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_no_web_flag) && $per__cst_no_web_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_no_web_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_no_web_flag) && $per__cst_no_web_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_no_web_flag, true)), __LINE__);
        }
        if (is_null($per__cst_no_web_flag) || (is_array($per__cst_no_web_flag) && empty($per__cst_no_web_flag))) {
            unset($this->per__cst_no_web_flag);
        } else {
            $this->per__cst_no_web_flag = $per__cst_no_web_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_oldid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_oldid(): ?string
    {
        return $this->per__cst_oldid ?? null;
    }
    /**
     * Set per__cst_oldid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_oldid
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_oldid(?string $per__cst_oldid = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_oldid) && !is_string($per__cst_oldid)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_oldid, true), gettype($per__cst_oldid)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($per__cst_oldid) && mb_strlen((string) $per__cst_oldid) > 15) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen((string) $per__cst_oldid)), __LINE__);
        }
        if (is_null($per__cst_oldid) || (is_array($per__cst_oldid) && empty($per__cst_oldid))) {
            unset($this->per__cst_oldid);
        } else {
            $this->per__cst_oldid = $per__cst_oldid;
        }
        
        return $this;
    }
    /**
     * Get per__cst_member_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_member_flag(): ?string
    {
        return $this->per__cst_member_flag ?? null;
    }
    /**
     * Set per__cst_member_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_member_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_member_flag(?string $per__cst_member_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_member_flag) && !is_string($per__cst_member_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_member_flag, true), gettype($per__cst_member_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_member_flag) && $per__cst_member_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_member_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_member_flag) && $per__cst_member_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_member_flag, true)), __LINE__);
        }
        if (is_null($per__cst_member_flag) || (is_array($per__cst_member_flag) && empty($per__cst_member_flag))) {
            unset($this->per__cst_member_flag);
        } else {
            $this->per__cst_member_flag = $per__cst_member_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_url_code_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_url_code_dn(): ?string
    {
        return $this->per__cst_url_code_dn ?? null;
    }
    /**
     * Set per__cst_url_code_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_url_code_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_url_code_dn(?string $per__cst_url_code_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_url_code_dn) && !is_string($per__cst_url_code_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_url_code_dn, true), gettype($per__cst_url_code_dn)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($per__cst_url_code_dn) && mb_strlen((string) $per__cst_url_code_dn) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $per__cst_url_code_dn)), __LINE__);
        }
        if (is_null($per__cst_url_code_dn) || (is_array($per__cst_url_code_dn) && empty($per__cst_url_code_dn))) {
            unset($this->per__cst_url_code_dn);
        } else {
            $this->per__cst_url_code_dn = $per__cst_url_code_dn;
        }
        
        return $this;
    }
    /**
     * Get per__cst_parent_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_parent_cst_key(): ?string
    {
        return $this->per__cst_parent_cst_key ?? null;
    }
    /**
     * Set per__cst_parent_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_parent_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_parent_cst_key(?string $per__cst_parent_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_parent_cst_key) && !is_string($per__cst_parent_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_parent_cst_key, true), gettype($per__cst_parent_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_parent_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_parent_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_parent_cst_key, true)), __LINE__);
        }
        if (is_null($per__cst_parent_cst_key) || (is_array($per__cst_parent_cst_key) && empty($per__cst_parent_cst_key))) {
            unset($this->per__cst_parent_cst_key);
        } else {
            $this->per__cst_parent_cst_key = $per__cst_parent_cst_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_url_key(): ?string
    {
        return $this->per__cst_url_key ?? null;
    }
    /**
     * Set per__cst_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_url_key(?string $per__cst_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_url_key) && !is_string($per__cst_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_url_key, true), gettype($per__cst_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_url_key, true)), __LINE__);
        }
        if (is_null($per__cst_url_key) || (is_array($per__cst_url_key) && empty($per__cst_url_key))) {
            unset($this->per__cst_url_key);
        } else {
            $this->per__cst_url_key = $per__cst_url_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_no_msg_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_no_msg_flag(): ?string
    {
        return $this->per__cst_no_msg_flag ?? null;
    }
    /**
     * Set per__cst_no_msg_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_no_msg_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_no_msg_flag(?string $per__cst_no_msg_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_no_msg_flag) && !is_string($per__cst_no_msg_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_no_msg_flag, true), gettype($per__cst_no_msg_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_no_msg_flag) && $per__cst_no_msg_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_no_msg_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_no_msg_flag) && $per__cst_no_msg_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_no_msg_flag, true)), __LINE__);
        }
        if (is_null($per__cst_no_msg_flag) || (is_array($per__cst_no_msg_flag) && empty($per__cst_no_msg_flag))) {
            unset($this->per__cst_no_msg_flag);
        } else {
            $this->per__cst_no_msg_flag = $per__cst_no_msg_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_msg_handle_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_msg_handle_dn(): ?string
    {
        return $this->per__cst_msg_handle_dn ?? null;
    }
    /**
     * Set per__cst_msg_handle_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_msg_handle_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_msg_handle_dn(?string $per__cst_msg_handle_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_msg_handle_dn) && !is_string($per__cst_msg_handle_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_msg_handle_dn, true), gettype($per__cst_msg_handle_dn)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($per__cst_msg_handle_dn) && mb_strlen((string) $per__cst_msg_handle_dn) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $per__cst_msg_handle_dn)), __LINE__);
        }
        if (is_null($per__cst_msg_handle_dn) || (is_array($per__cst_msg_handle_dn) && empty($per__cst_msg_handle_dn))) {
            unset($this->per__cst_msg_handle_dn);
        } else {
            $this->per__cst_msg_handle_dn = $per__cst_msg_handle_dn;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_login(): ?string
    {
        return $this->per__cst_web_login ?? null;
    }
    /**
     * Set per__cst_web_login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_login
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_login(?string $per__cst_web_login = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_login) && !is_string($per__cst_web_login)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_login, true), gettype($per__cst_web_login)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($per__cst_web_login) && mb_strlen((string) $per__cst_web_login) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $per__cst_web_login)), __LINE__);
        }
        if (is_null($per__cst_web_login) || (is_array($per__cst_web_login) && empty($per__cst_web_login))) {
            unset($this->per__cst_web_login);
        } else {
            $this->per__cst_web_login = $per__cst_web_login;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_password(): ?string
    {
        return $this->per__cst_web_password ?? null;
    }
    /**
     * Set per__cst_web_password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_password
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_password(?string $per__cst_web_password = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_password) && !is_string($per__cst_web_password)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_password, true), gettype($per__cst_web_password)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($per__cst_web_password) && mb_strlen((string) $per__cst_web_password) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $per__cst_web_password)), __LINE__);
        }
        if (is_null($per__cst_web_password) || (is_array($per__cst_web_password) && empty($per__cst_web_password))) {
            unset($this->per__cst_web_password);
        } else {
            $this->per__cst_web_password = $per__cst_web_password;
        }
        
        return $this;
    }
    /**
     * Get per__cst_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_entity_key(): ?string
    {
        return $this->per__cst_entity_key ?? null;
    }
    /**
     * Set per__cst_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_entity_key(?string $per__cst_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_entity_key) && !is_string($per__cst_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_entity_key, true), gettype($per__cst_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_entity_key, true)), __LINE__);
        }
        if (is_null($per__cst_entity_key) || (is_array($per__cst_entity_key) && empty($per__cst_entity_key))) {
            unset($this->per__cst_entity_key);
        } else {
            $this->per__cst_entity_key = $per__cst_entity_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_msg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_msg_key(): ?string
    {
        return $this->per__cst_msg_key ?? null;
    }
    /**
     * Set per__cst_msg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_msg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_msg_key(?string $per__cst_msg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_msg_key) && !is_string($per__cst_msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_msg_key, true), gettype($per__cst_msg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_msg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_msg_key, true)), __LINE__);
        }
        if (is_null($per__cst_msg_key) || (is_array($per__cst_msg_key) && empty($per__cst_msg_key))) {
            unset($this->per__cst_msg_key);
        } else {
            $this->per__cst_msg_key = $per__cst_msg_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_no_mail_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_no_mail_flag(): ?string
    {
        return $this->per__cst_no_mail_flag ?? null;
    }
    /**
     * Set per__cst_no_mail_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_no_mail_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_no_mail_flag(?string $per__cst_no_mail_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_no_mail_flag) && !is_string($per__cst_no_mail_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_no_mail_flag, true), gettype($per__cst_no_mail_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_no_mail_flag) && $per__cst_no_mail_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_no_mail_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_no_mail_flag) && $per__cst_no_mail_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_no_mail_flag, true)), __LINE__);
        }
        if (is_null($per__cst_no_mail_flag) || (is_array($per__cst_no_mail_flag) && empty($per__cst_no_mail_flag))) {
            unset($this->per__cst_no_mail_flag);
        } else {
            $this->per__cst_no_mail_flag = $per__cst_no_mail_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_start_date(): ?string
    {
        return $this->per__cst_web_start_date ?? null;
    }
    /**
     * Set per__cst_web_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_start_date(?string $per__cst_web_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_start_date) && !is_string($per__cst_web_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_start_date, true), gettype($per__cst_web_start_date)), __LINE__);
        }
        if (is_null($per__cst_web_start_date) || (is_array($per__cst_web_start_date) && empty($per__cst_web_start_date))) {
            unset($this->per__cst_web_start_date);
        } else {
            $this->per__cst_web_start_date = $per__cst_web_start_date;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_end_date(): ?string
    {
        return $this->per__cst_web_end_date ?? null;
    }
    /**
     * Set per__cst_web_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_end_date(?string $per__cst_web_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_end_date) && !is_string($per__cst_web_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_end_date, true), gettype($per__cst_web_end_date)), __LINE__);
        }
        if (is_null($per__cst_web_end_date) || (is_array($per__cst_web_end_date) && empty($per__cst_web_end_date))) {
            unset($this->per__cst_web_end_date);
        } else {
            $this->per__cst_web_end_date = $per__cst_web_end_date;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_force_password_change value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_force_password_change(): ?string
    {
        return $this->per__cst_web_force_password_change ?? null;
    }
    /**
     * Set per__cst_web_force_password_change value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_force_password_change
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_force_password_change(?string $per__cst_web_force_password_change = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_force_password_change) && !is_string($per__cst_web_force_password_change)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_force_password_change, true), gettype($per__cst_web_force_password_change)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_web_force_password_change) && $per__cst_web_force_password_change > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_web_force_password_change, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_web_force_password_change) && $per__cst_web_force_password_change < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_web_force_password_change, true)), __LINE__);
        }
        if (is_null($per__cst_web_force_password_change) || (is_array($per__cst_web_force_password_change) && empty($per__cst_web_force_password_change))) {
            unset($this->per__cst_web_force_password_change);
        } else {
            $this->per__cst_web_force_password_change = $per__cst_web_force_password_change;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_login_disabled_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_login_disabled_flag(): ?string
    {
        return $this->per__cst_web_login_disabled_flag ?? null;
    }
    /**
     * Set per__cst_web_login_disabled_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_login_disabled_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_login_disabled_flag(?string $per__cst_web_login_disabled_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_login_disabled_flag) && !is_string($per__cst_web_login_disabled_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_login_disabled_flag, true), gettype($per__cst_web_login_disabled_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_web_login_disabled_flag) && $per__cst_web_login_disabled_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_web_login_disabled_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_web_login_disabled_flag) && $per__cst_web_login_disabled_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_web_login_disabled_flag, true)), __LINE__);
        }
        if (is_null($per__cst_web_login_disabled_flag) || (is_array($per__cst_web_login_disabled_flag) && empty($per__cst_web_login_disabled_flag))) {
            unset($this->per__cst_web_login_disabled_flag);
        } else {
            $this->per__cst_web_login_disabled_flag = $per__cst_web_login_disabled_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_comment(): ?string
    {
        return $this->per__cst_comment ?? null;
    }
    /**
     * Set per__cst_comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_comment
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_comment(?string $per__cst_comment = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_comment) && !is_string($per__cst_comment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_comment, true), gettype($per__cst_comment)), __LINE__);
        }
        if (is_null($per__cst_comment) || (is_array($per__cst_comment) && empty($per__cst_comment))) {
            unset($this->per__cst_comment);
        } else {
            $this->per__cst_comment = $per__cst_comment;
        }
        
        return $this;
    }
    /**
     * Get per__cst_credit_hold_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_credit_hold_flag(): ?string
    {
        return $this->per__cst_credit_hold_flag ?? null;
    }
    /**
     * Set per__cst_credit_hold_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_credit_hold_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_credit_hold_flag(?string $per__cst_credit_hold_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_credit_hold_flag) && !is_string($per__cst_credit_hold_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_credit_hold_flag, true), gettype($per__cst_credit_hold_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_credit_hold_flag) && $per__cst_credit_hold_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_credit_hold_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_credit_hold_flag) && $per__cst_credit_hold_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_credit_hold_flag, true)), __LINE__);
        }
        if (is_null($per__cst_credit_hold_flag) || (is_array($per__cst_credit_hold_flag) && empty($per__cst_credit_hold_flag))) {
            unset($this->per__cst_credit_hold_flag);
        } else {
            $this->per__cst_credit_hold_flag = $per__cst_credit_hold_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_credit_hold_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_credit_hold_reason(): ?string
    {
        return $this->per__cst_credit_hold_reason ?? null;
    }
    /**
     * Set per__cst_credit_hold_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_credit_hold_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_credit_hold_reason(?string $per__cst_credit_hold_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_credit_hold_reason) && !is_string($per__cst_credit_hold_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_credit_hold_reason, true), gettype($per__cst_credit_hold_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($per__cst_credit_hold_reason) && mb_strlen((string) $per__cst_credit_hold_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $per__cst_credit_hold_reason)), __LINE__);
        }
        if (is_null($per__cst_credit_hold_reason) || (is_array($per__cst_credit_hold_reason) && empty($per__cst_credit_hold_reason))) {
            unset($this->per__cst_credit_hold_reason);
        } else {
            $this->per__cst_credit_hold_reason = $per__cst_credit_hold_reason;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_forgot_password_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_forgot_password_status(): ?string
    {
        return $this->per__cst_web_forgot_password_status ?? null;
    }
    /**
     * Set per__cst_web_forgot_password_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_forgot_password_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_forgot_password_status(?string $per__cst_web_forgot_password_status = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_forgot_password_status) && !is_string($per__cst_web_forgot_password_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_forgot_password_status, true), gettype($per__cst_web_forgot_password_status)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_web_forgot_password_status) && $per__cst_web_forgot_password_status > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_web_forgot_password_status, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_web_forgot_password_status) && $per__cst_web_forgot_password_status < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_web_forgot_password_status, true)), __LINE__);
        }
        if (is_null($per__cst_web_forgot_password_status) || (is_array($per__cst_web_forgot_password_status) && empty($per__cst_web_forgot_password_status))) {
            unset($this->per__cst_web_forgot_password_status);
        } else {
            $this->per__cst_web_forgot_password_status = $per__cst_web_forgot_password_status;
        }
        
        return $this;
    }
    /**
     * Get per__cst_old_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_old_cxa_key(): ?string
    {
        return $this->per__cst_old_cxa_key ?? null;
    }
    /**
     * Set per__cst_old_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_old_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_old_cxa_key(?string $per__cst_old_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_old_cxa_key) && !is_string($per__cst_old_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_old_cxa_key, true), gettype($per__cst_old_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_old_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_old_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_old_cxa_key, true)), __LINE__);
        }
        if (is_null($per__cst_old_cxa_key) || (is_array($per__cst_old_cxa_key) && empty($per__cst_old_cxa_key))) {
            unset($this->per__cst_old_cxa_key);
        } else {
            $this->per__cst_old_cxa_key = $per__cst_old_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_last_email_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_last_email_date(): ?string
    {
        return $this->per__cst_last_email_date ?? null;
    }
    /**
     * Set per__cst_last_email_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_last_email_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_last_email_date(?string $per__cst_last_email_date = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_last_email_date) && !is_string($per__cst_last_email_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_last_email_date, true), gettype($per__cst_last_email_date)), __LINE__);
        }
        if (is_null($per__cst_last_email_date) || (is_array($per__cst_last_email_date) && empty($per__cst_last_email_date))) {
            unset($this->per__cst_last_email_date);
        } else {
            $this->per__cst_last_email_date = $per__cst_last_email_date;
        }
        
        return $this;
    }
    /**
     * Get per__cst_no_publish_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_no_publish_flag(): ?string
    {
        return $this->per__cst_no_publish_flag ?? null;
    }
    /**
     * Set per__cst_no_publish_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_no_publish_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_no_publish_flag(?string $per__cst_no_publish_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_no_publish_flag) && !is_string($per__cst_no_publish_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_no_publish_flag, true), gettype($per__cst_no_publish_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_no_publish_flag) && $per__cst_no_publish_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_no_publish_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_no_publish_flag) && $per__cst_no_publish_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_no_publish_flag, true)), __LINE__);
        }
        if (is_null($per__cst_no_publish_flag) || (is_array($per__cst_no_publish_flag) && empty($per__cst_no_publish_flag))) {
            unset($this->per__cst_no_publish_flag);
        } else {
            $this->per__cst_no_publish_flag = $per__cst_no_publish_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_sin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_sin_key(): ?string
    {
        return $this->per__cst_sin_key ?? null;
    }
    /**
     * Set per__cst_sin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_sin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_sin_key(?string $per__cst_sin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_sin_key) && !is_string($per__cst_sin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_sin_key, true), gettype($per__cst_sin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_sin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_sin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_sin_key, true)), __LINE__);
        }
        if (is_null($per__cst_sin_key) || (is_array($per__cst_sin_key) && empty($per__cst_sin_key))) {
            unset($this->per__cst_sin_key);
        } else {
            $this->per__cst_sin_key = $per__cst_sin_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_ttl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_ttl_key(): ?string
    {
        return $this->per__cst_ttl_key ?? null;
    }
    /**
     * Set per__cst_ttl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_ttl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_ttl_key(?string $per__cst_ttl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_ttl_key) && !is_string($per__cst_ttl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_ttl_key, true), gettype($per__cst_ttl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_ttl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_ttl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_ttl_key, true)), __LINE__);
        }
        if (is_null($per__cst_ttl_key) || (is_array($per__cst_ttl_key) && empty($per__cst_ttl_key))) {
            unset($this->per__cst_ttl_key);
        } else {
            $this->per__cst_ttl_key = $per__cst_ttl_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_jfn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_jfn_key(): ?string
    {
        return $this->per__cst_jfn_key ?? null;
    }
    /**
     * Set per__cst_jfn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_jfn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_jfn_key(?string $per__cst_jfn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_jfn_key) && !is_string($per__cst_jfn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_jfn_key, true), gettype($per__cst_jfn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_jfn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_jfn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_jfn_key, true)), __LINE__);
        }
        if (is_null($per__cst_jfn_key) || (is_array($per__cst_jfn_key) && empty($per__cst_jfn_key))) {
            unset($this->per__cst_jfn_key);
        } else {
            $this->per__cst_jfn_key = $per__cst_jfn_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_cur_key(): ?string
    {
        return $this->per__cst_cur_key ?? null;
    }
    /**
     * Set per__cst_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_cur_key(?string $per__cst_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_cur_key) && !is_string($per__cst_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_cur_key, true), gettype($per__cst_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_cur_key, true)), __LINE__);
        }
        if (is_null($per__cst_cur_key) || (is_array($per__cst_cur_key) && empty($per__cst_cur_key))) {
            unset($this->per__cst_cur_key);
        } else {
            $this->per__cst_cur_key = $per__cst_cur_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_attribute value
     * @return per__cst_attribute
     */
    public function getPer__cst_attribute_1(): ?string
    {
        return $this->per__cst_attribute_1 ?? null;
    }
    /**
     * Set per__cst_attribute value
     * @param per__cst_attribute $per__cst_attribute
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_attribute_1(?string $per__cst_attribute_1 = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_attribute_1) && !is_string($per__cst_attribute_1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_attribute_1, true), gettype($per__cst_attribute_1)), __LINE__);
        }
        // validation for constraint: maxLength(510)
        if (!is_null($per__cst_attribute_1) && mb_strlen((string) $per__cst_attribute_1) > 510) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 510', mb_strlen((string) $per__cst_attribute_1)), __LINE__);
        }
        if (is_null($per__cst_attribute_1) || (is_array($per__cst_attribute_1) && empty($per__cst_attribute_1))) {
            unset($this->per__cst_attribute_1);
        } else {
            $this->per__cst_attribute_1 = $per__cst_attribute_1;
        }
        
        return $this;
    }
    /**
     * Get per__cst_attribute value
     * @return per__cst_attribute
     */
    public function getPer__cst_attribute_2(): ?string
    {
        return $this->per__cst_attribute_2 ?? null;
    }
    /**
     * Set per__cst_attribute value
     * @param per__cst_attribute $per__cst_attribute
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_attribute_2(?string $per__cst_attribute_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_attribute_2) && !is_string($per__cst_attribute_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_attribute_2, true), gettype($per__cst_attribute_2)), __LINE__);
        }
        // validation for constraint: maxLength(510)
        if (!is_null($per__cst_attribute_2) && mb_strlen((string) $per__cst_attribute_2) > 510) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 510', mb_strlen((string) $per__cst_attribute_2)), __LINE__);
        }
        if (is_null($per__cst_attribute_2) || (is_array($per__cst_attribute_2) && empty($per__cst_attribute_2))) {
            unset($this->per__cst_attribute_2);
        } else {
            $this->per__cst_attribute_2 = $per__cst_attribute_2;
        }
        
        return $this;
    }
    /**
     * Get per__cst_salutation value
     * @return per__cst_salutation
     */
    public function getPer__cst_salutation_1(): ?string
    {
        return $this->per__cst_salutation_1 ?? null;
    }
    /**
     * Set per__cst_salutation value
     * @param per__cst_salutation $per__cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_salutation_1(?string $per__cst_salutation_1 = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_salutation_1) && !is_string($per__cst_salutation_1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_salutation_1, true), gettype($per__cst_salutation_1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($per__cst_salutation_1) && mb_strlen((string) $per__cst_salutation_1) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $per__cst_salutation_1)), __LINE__);
        }
        if (is_null($per__cst_salutation_1) || (is_array($per__cst_salutation_1) && empty($per__cst_salutation_1))) {
            unset($this->per__cst_salutation_1);
        } else {
            $this->per__cst_salutation_1 = $per__cst_salutation_1;
        }
        
        return $this;
    }
    /**
     * Get per__cst_salutation value
     * @return per__cst_salutation
     */
    public function getPer__cst_salutation_2(): ?string
    {
        return $this->per__cst_salutation_2 ?? null;
    }
    /**
     * Set per__cst_salutation value
     * @param per__cst_salutation $per__cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_salutation_2(?string $per__cst_salutation_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_salutation_2) && !is_string($per__cst_salutation_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_salutation_2, true), gettype($per__cst_salutation_2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($per__cst_salutation_2) && mb_strlen((string) $per__cst_salutation_2) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $per__cst_salutation_2)), __LINE__);
        }
        if (is_null($per__cst_salutation_2) || (is_array($per__cst_salutation_2) && empty($per__cst_salutation_2))) {
            unset($this->per__cst_salutation_2);
        } else {
            $this->per__cst_salutation_2 = $per__cst_salutation_2;
        }
        
        return $this;
    }
    /**
     * Get per__cst_merge_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_merge_cst_key(): ?string
    {
        return $this->per__cst_merge_cst_key ?? null;
    }
    /**
     * Set per__cst_merge_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_merge_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_merge_cst_key(?string $per__cst_merge_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_merge_cst_key) && !is_string($per__cst_merge_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_merge_cst_key, true), gettype($per__cst_merge_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_merge_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_merge_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_merge_cst_key, true)), __LINE__);
        }
        if (is_null($per__cst_merge_cst_key) || (is_array($per__cst_merge_cst_key) && empty($per__cst_merge_cst_key))) {
            unset($this->per__cst_merge_cst_key);
        } else {
            $this->per__cst_merge_cst_key = $per__cst_merge_cst_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_salutation value
     * @return per__cst_salutation
     */
    public function getPer__cst_salutation_3(): ?string
    {
        return $this->per__cst_salutation_3 ?? null;
    }
    /**
     * Set per__cst_salutation value
     * @param per__cst_salutation $per__cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_salutation_3(?string $per__cst_salutation_3 = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_salutation_3) && !is_string($per__cst_salutation_3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_salutation_3, true), gettype($per__cst_salutation_3)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($per__cst_salutation_3) && mb_strlen((string) $per__cst_salutation_3) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $per__cst_salutation_3)), __LINE__);
        }
        if (is_null($per__cst_salutation_3) || (is_array($per__cst_salutation_3) && empty($per__cst_salutation_3))) {
            unset($this->per__cst_salutation_3);
        } else {
            $this->per__cst_salutation_3 = $per__cst_salutation_3;
        }
        
        return $this;
    }
    /**
     * Get per__cst_salutation value
     * @return per__cst_salutation
     */
    public function getPer__cst_salutation_4(): ?string
    {
        return $this->per__cst_salutation_4 ?? null;
    }
    /**
     * Set per__cst_salutation value
     * @param per__cst_salutation $per__cst_salutation
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_salutation_4(?string $per__cst_salutation_4 = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_salutation_4) && !is_string($per__cst_salutation_4)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_salutation_4, true), gettype($per__cst_salutation_4)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($per__cst_salutation_4) && mb_strlen((string) $per__cst_salutation_4) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $per__cst_salutation_4)), __LINE__);
        }
        if (is_null($per__cst_salutation_4) || (is_array($per__cst_salutation_4) && empty($per__cst_salutation_4))) {
            unset($this->per__cst_salutation_4);
        } else {
            $this->per__cst_salutation_4 = $per__cst_salutation_4;
        }
        
        return $this;
    }
    /**
     * Get per__cst_default_recognize_as value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_default_recognize_as(): ?string
    {
        return $this->per__cst_default_recognize_as ?? null;
    }
    /**
     * Set per__cst_default_recognize_as value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_default_recognize_as
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_default_recognize_as(?string $per__cst_default_recognize_as = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_default_recognize_as) && !is_string($per__cst_default_recognize_as)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_default_recognize_as, true), gettype($per__cst_default_recognize_as)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($per__cst_default_recognize_as) && mb_strlen((string) $per__cst_default_recognize_as) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $per__cst_default_recognize_as)), __LINE__);
        }
        if (is_null($per__cst_default_recognize_as) || (is_array($per__cst_default_recognize_as) && empty($per__cst_default_recognize_as))) {
            unset($this->per__cst_default_recognize_as);
        } else {
            $this->per__cst_default_recognize_as = $per__cst_default_recognize_as;
        }
        
        return $this;
    }
    /**
     * Get per__cst_score value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPer__cst_score(): ?float
    {
        return $this->per__cst_score ?? null;
    }
    /**
     * Set per__cst_score value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $per__cst_score
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_score(?float $per__cst_score = null): self
    {
        // validation for constraint: float
        if (!is_null($per__cst_score) && !(is_float($per__cst_score) || is_numeric($per__cst_score))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($per__cst_score, true), gettype($per__cst_score)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($per__cst_score) && mb_strlen(mb_substr((string) $per__cst_score, false !== mb_strpos((string) $per__cst_score, '.') ? mb_strpos((string) $per__cst_score, '.') + 1 : mb_strlen((string) $per__cst_score))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($per__cst_score, true), mb_strlen(mb_substr((string) $per__cst_score, mb_strpos((string) $per__cst_score, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($per__cst_score) && mb_strlen(preg_replace('/(\D)/', '', (string) $per__cst_score)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($per__cst_score, true), mb_strlen(preg_replace('/(\D)/', '', (string) $per__cst_score))), __LINE__);
        }
        if (is_null($per__cst_score) || (is_array($per__cst_score) && empty($per__cst_score))) {
            unset($this->per__cst_score);
        } else {
            $this->per__cst_score = $per__cst_score;
        }
        
        return $this;
    }
    /**
     * Get per__cst_score_normalized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPer__cst_score_normalized(): ?int
    {
        return $this->per__cst_score_normalized ?? null;
    }
    /**
     * Set per__cst_score_normalized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $per__cst_score_normalized
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_score_normalized(?int $per__cst_score_normalized = null): self
    {
        // validation for constraint: int
        if (!is_null($per__cst_score_normalized) && !(is_int($per__cst_score_normalized) || ctype_digit($per__cst_score_normalized))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($per__cst_score_normalized, true), gettype($per__cst_score_normalized)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($per__cst_score_normalized) && $per__cst_score_normalized > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($per__cst_score_normalized, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($per__cst_score_normalized) && $per__cst_score_normalized < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($per__cst_score_normalized, true)), __LINE__);
        }
        if (is_null($per__cst_score_normalized) || (is_array($per__cst_score_normalized) && empty($per__cst_score_normalized))) {
            unset($this->per__cst_score_normalized);
        } else {
            $this->per__cst_score_normalized = $per__cst_score_normalized;
        }
        
        return $this;
    }
    /**
     * Get per__cst_score_trend value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPer__cst_score_trend(): ?int
    {
        return $this->per__cst_score_trend ?? null;
    }
    /**
     * Set per__cst_score_trend value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $per__cst_score_trend
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_score_trend(?int $per__cst_score_trend = null): self
    {
        // validation for constraint: int
        if (!is_null($per__cst_score_trend) && !(is_int($per__cst_score_trend) || ctype_digit($per__cst_score_trend))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($per__cst_score_trend, true), gettype($per__cst_score_trend)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($per__cst_score_trend) && $per__cst_score_trend > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($per__cst_score_trend, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($per__cst_score_trend) && $per__cst_score_trend < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($per__cst_score_trend, true)), __LINE__);
        }
        if (is_null($per__cst_score_trend) || (is_array($per__cst_score_trend) && empty($per__cst_score_trend))) {
            unset($this->per__cst_score_trend);
        } else {
            $this->per__cst_score_trend = $per__cst_score_trend;
        }
        
        return $this;
    }
    /**
     * Get per__cst_vault_account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_vault_account(): ?string
    {
        return $this->per__cst_vault_account ?? null;
    }
    /**
     * Set per__cst_vault_account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_vault_account
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_vault_account(?string $per__cst_vault_account = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_vault_account) && !is_string($per__cst_vault_account)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_vault_account, true), gettype($per__cst_vault_account)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($per__cst_vault_account) && mb_strlen((string) $per__cst_vault_account) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen((string) $per__cst_vault_account)), __LINE__);
        }
        if (is_null($per__cst_vault_account) || (is_array($per__cst_vault_account) && empty($per__cst_vault_account))) {
            unset($this->per__cst_vault_account);
        } else {
            $this->per__cst_vault_account = $per__cst_vault_account;
        }
        
        return $this;
    }
    /**
     * Get per__cst_exclude_from_social_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_exclude_from_social_flag(): ?string
    {
        return $this->per__cst_exclude_from_social_flag ?? null;
    }
    /**
     * Set per__cst_exclude_from_social_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_exclude_from_social_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_exclude_from_social_flag(?string $per__cst_exclude_from_social_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_exclude_from_social_flag) && !is_string($per__cst_exclude_from_social_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_exclude_from_social_flag, true), gettype($per__cst_exclude_from_social_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_exclude_from_social_flag) && $per__cst_exclude_from_social_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_exclude_from_social_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_exclude_from_social_flag) && $per__cst_exclude_from_social_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_exclude_from_social_flag, true)), __LINE__);
        }
        if (is_null($per__cst_exclude_from_social_flag) || (is_array($per__cst_exclude_from_social_flag) && empty($per__cst_exclude_from_social_flag))) {
            unset($this->per__cst_exclude_from_social_flag);
        } else {
            $this->per__cst_exclude_from_social_flag = $per__cst_exclude_from_social_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_social_score value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPer__cst_social_score(): ?int
    {
        return $this->per__cst_social_score ?? null;
    }
    /**
     * Set per__cst_social_score value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $per__cst_social_score
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_social_score(?int $per__cst_social_score = null): self
    {
        // validation for constraint: int
        if (!is_null($per__cst_social_score) && !(is_int($per__cst_social_score) || ctype_digit($per__cst_social_score))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($per__cst_social_score, true), gettype($per__cst_social_score)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($per__cst_social_score) && $per__cst_social_score > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($per__cst_social_score, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($per__cst_social_score) && $per__cst_social_score < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($per__cst_social_score, true)), __LINE__);
        }
        if (is_null($per__cst_social_score) || (is_array($per__cst_social_score) && empty($per__cst_social_score))) {
            unset($this->per__cst_social_score);
        } else {
            $this->per__cst_social_score = $per__cst_social_score;
        }
        
        return $this;
    }
    /**
     * Get per__cst_ptin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_ptin(): ?string
    {
        return $this->per__cst_ptin ?? null;
    }
    /**
     * Set per__cst_ptin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_ptin
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_ptin(?string $per__cst_ptin = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_ptin) && !is_string($per__cst_ptin)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_ptin, true), gettype($per__cst_ptin)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($per__cst_ptin) && mb_strlen((string) $per__cst_ptin) > 9) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen((string) $per__cst_ptin)), __LINE__);
        }
        if (is_null($per__cst_ptin) || (is_array($per__cst_ptin) && empty($per__cst_ptin))) {
            unset($this->per__cst_ptin);
        } else {
            $this->per__cst_ptin = $per__cst_ptin;
        }
        
        return $this;
    }
    /**
     * Get per__cst_aicpa_member_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPer__cst_aicpa_member_id(): ?int
    {
        return $this->per__cst_aicpa_member_id ?? null;
    }
    /**
     * Set per__cst_aicpa_member_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $per__cst_aicpa_member_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_aicpa_member_id(?int $per__cst_aicpa_member_id = null): self
    {
        // validation for constraint: int
        if (!is_null($per__cst_aicpa_member_id) && !(is_int($per__cst_aicpa_member_id) || ctype_digit($per__cst_aicpa_member_id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($per__cst_aicpa_member_id, true), gettype($per__cst_aicpa_member_id)), __LINE__);
        }
        // validation for constraint: maxInclusive(9223372036854775807)
        if (!is_null($per__cst_aicpa_member_id) && $per__cst_aicpa_member_id > 9223372036854775807) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9223372036854775807', var_export($per__cst_aicpa_member_id, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9223372036854775808)
        if (!is_null($per__cst_aicpa_member_id) && $per__cst_aicpa_member_id < -9223372036854775808) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9223372036854775808', var_export($per__cst_aicpa_member_id, true)), __LINE__);
        }
        if (is_null($per__cst_aicpa_member_id) || (is_array($per__cst_aicpa_member_id) && empty($per__cst_aicpa_member_id))) {
            unset($this->per__cst_aicpa_member_id);
        } else {
            $this->per__cst_aicpa_member_id = $per__cst_aicpa_member_id;
        }
        
        return $this;
    }
    /**
     * Get per__cst_vendor_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_vendor_code(): ?string
    {
        return $this->per__cst_vendor_code ?? null;
    }
    /**
     * Set per__cst_vendor_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_vendor_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_vendor_code(?string $per__cst_vendor_code = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_vendor_code) && !is_string($per__cst_vendor_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_vendor_code, true), gettype($per__cst_vendor_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($per__cst_vendor_code) && mb_strlen((string) $per__cst_vendor_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $per__cst_vendor_code)), __LINE__);
        }
        if (is_null($per__cst_vendor_code) || (is_array($per__cst_vendor_code) && empty($per__cst_vendor_code))) {
            unset($this->per__cst_vendor_code);
        } else {
            $this->per__cst_vendor_code = $per__cst_vendor_code;
        }
        
        return $this;
    }
    /**
     * Get per__cst_salt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_salt(): ?string
    {
        return $this->per__cst_salt ?? null;
    }
    /**
     * Set per__cst_salt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_salt
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_salt(?string $per__cst_salt = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_salt) && !is_string($per__cst_salt)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_salt, true), gettype($per__cst_salt)), __LINE__);
        }
        if (is_null($per__cst_salt) || (is_array($per__cst_salt) && empty($per__cst_salt))) {
            unset($this->per__cst_salt);
        } else {
            $this->per__cst_salt = $per__cst_salt;
        }
        
        return $this;
    }
    /**
     * Get per__cst_sca_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_sca_key(): ?string
    {
        return $this->per__cst_sca_key ?? null;
    }
    /**
     * Set per__cst_sca_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_sca_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_sca_key(?string $per__cst_sca_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_sca_key) && !is_string($per__cst_sca_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_sca_key, true), gettype($per__cst_sca_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_sca_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_sca_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_sca_key, true)), __LINE__);
        }
        if (is_null($per__cst_sca_key) || (is_array($per__cst_sca_key) && empty($per__cst_sca_key))) {
            unset($this->per__cst_sca_key);
        } else {
            $this->per__cst_sca_key = $per__cst_sca_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_iterations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPer__cst_iterations(): ?int
    {
        return $this->per__cst_iterations ?? null;
    }
    /**
     * Set per__cst_iterations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $per__cst_iterations
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_iterations(?int $per__cst_iterations = null): self
    {
        // validation for constraint: int
        if (!is_null($per__cst_iterations) && !(is_int($per__cst_iterations) || ctype_digit($per__cst_iterations))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($per__cst_iterations, true), gettype($per__cst_iterations)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($per__cst_iterations) && $per__cst_iterations > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($per__cst_iterations, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($per__cst_iterations) && $per__cst_iterations < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($per__cst_iterations, true)), __LINE__);
        }
        if (is_null($per__cst_iterations) || (is_array($per__cst_iterations) && empty($per__cst_iterations))) {
            unset($this->per__cst_iterations);
        } else {
            $this->per__cst_iterations = $per__cst_iterations;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_password_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_password_change_date(): ?string
    {
        return $this->per__cst_web_password_change_date ?? null;
    }
    /**
     * Set per__cst_web_password_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_password_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_password_change_date(?string $per__cst_web_password_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_password_change_date) && !is_string($per__cst_web_password_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_password_change_date, true), gettype($per__cst_web_password_change_date)), __LINE__);
        }
        if (is_null($per__cst_web_password_change_date) || (is_array($per__cst_web_password_change_date) && empty($per__cst_web_password_change_date))) {
            unset($this->per__cst_web_password_change_date);
        } else {
            $this->per__cst_web_password_change_date = $per__cst_web_password_change_date;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_failed_login_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_failed_login_count(): ?string
    {
        return $this->per__cst_web_failed_login_count ?? null;
    }
    /**
     * Set per__cst_web_failed_login_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_failed_login_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_failed_login_count(?string $per__cst_web_failed_login_count = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_failed_login_count) && !is_string($per__cst_web_failed_login_count)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_failed_login_count, true), gettype($per__cst_web_failed_login_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_web_failed_login_count) && $per__cst_web_failed_login_count > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_web_failed_login_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_web_failed_login_count) && $per__cst_web_failed_login_count < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_web_failed_login_count, true)), __LINE__);
        }
        if (is_null($per__cst_web_failed_login_count) || (is_array($per__cst_web_failed_login_count) && empty($per__cst_web_failed_login_count))) {
            unset($this->per__cst_web_failed_login_count);
        } else {
            $this->per__cst_web_failed_login_count = $per__cst_web_failed_login_count;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_last_failed_login_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_last_failed_login_date(): ?string
    {
        return $this->per__cst_web_last_failed_login_date ?? null;
    }
    /**
     * Set per__cst_web_last_failed_login_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_last_failed_login_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_last_failed_login_date(?string $per__cst_web_last_failed_login_date = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_last_failed_login_date) && !is_string($per__cst_web_last_failed_login_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_last_failed_login_date, true), gettype($per__cst_web_last_failed_login_date)), __LINE__);
        }
        if (is_null($per__cst_web_last_failed_login_date) || (is_array($per__cst_web_last_failed_login_date) && empty($per__cst_web_last_failed_login_date))) {
            unset($this->per__cst_web_last_failed_login_date);
        } else {
            $this->per__cst_web_last_failed_login_date = $per__cst_web_last_failed_login_date;
        }
        
        return $this;
    }
    /**
     * Get per__cst_web_login_locked_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_web_login_locked_flag(): ?string
    {
        return $this->per__cst_web_login_locked_flag ?? null;
    }
    /**
     * Set per__cst_web_login_locked_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_web_login_locked_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_web_login_locked_flag(?string $per__cst_web_login_locked_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_web_login_locked_flag) && !is_string($per__cst_web_login_locked_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_web_login_locked_flag, true), gettype($per__cst_web_login_locked_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($per__cst_web_login_locked_flag) && $per__cst_web_login_locked_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($per__cst_web_login_locked_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($per__cst_web_login_locked_flag) && $per__cst_web_login_locked_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($per__cst_web_login_locked_flag, true)), __LINE__);
        }
        if (is_null($per__cst_web_login_locked_flag) || (is_array($per__cst_web_login_locked_flag) && empty($per__cst_web_login_locked_flag))) {
            unset($this->per__cst_web_login_locked_flag);
        } else {
            $this->per__cst_web_login_locked_flag = $per__cst_web_login_locked_flag;
        }
        
        return $this;
    }
    /**
     * Get per__cst_cph_sms_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_cph_sms_key(): ?string
    {
        return $this->per__cst_cph_sms_key ?? null;
    }
    /**
     * Set per__cst_cph_sms_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_cph_sms_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_cph_sms_key(?string $per__cst_cph_sms_key = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_cph_sms_key) && !is_string($per__cst_cph_sms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_cph_sms_key, true), gettype($per__cst_cph_sms_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($per__cst_cph_sms_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $per__cst_cph_sms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($per__cst_cph_sms_key, true)), __LINE__);
        }
        if (is_null($per__cst_cph_sms_key) || (is_array($per__cst_cph_sms_key) && empty($per__cst_cph_sms_key))) {
            unset($this->per__cst_cph_sms_key);
        } else {
            $this->per__cst_cph_sms_key = $per__cst_cph_sms_key;
        }
        
        return $this;
    }
    /**
     * Get per__cst_sms_opt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_sms_opt(): ?string
    {
        return $this->per__cst_sms_opt ?? null;
    }
    /**
     * Set per__cst_sms_opt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_sms_opt
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_sms_opt(?string $per__cst_sms_opt = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_sms_opt) && !is_string($per__cst_sms_opt)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_sms_opt, true), gettype($per__cst_sms_opt)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($per__cst_sms_opt) && mb_strlen((string) $per__cst_sms_opt) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $per__cst_sms_opt)), __LINE__);
        }
        if (is_null($per__cst_sms_opt) || (is_array($per__cst_sms_opt) && empty($per__cst_sms_opt))) {
            unset($this->per__cst_sms_opt);
        } else {
            $this->per__cst_sms_opt = $per__cst_sms_opt;
        }
        
        return $this;
    }
    /**
     * Get per__cst_sms_consent_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_sms_consent_type(): ?string
    {
        return $this->per__cst_sms_consent_type ?? null;
    }
    /**
     * Set per__cst_sms_consent_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_sms_consent_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_sms_consent_type(?string $per__cst_sms_consent_type = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_sms_consent_type) && !is_string($per__cst_sms_consent_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_sms_consent_type, true), gettype($per__cst_sms_consent_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($per__cst_sms_consent_type) && mb_strlen((string) $per__cst_sms_consent_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $per__cst_sms_consent_type)), __LINE__);
        }
        if (is_null($per__cst_sms_consent_type) || (is_array($per__cst_sms_consent_type) && empty($per__cst_sms_consent_type))) {
            unset($this->per__cst_sms_consent_type);
        } else {
            $this->per__cst_sms_consent_type = $per__cst_sms_consent_type;
        }
        
        return $this;
    }
    /**
     * Get per__cst_failed_payment_attempts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPer__cst_failed_payment_attempts(): ?string
    {
        return $this->per__cst_failed_payment_attempts ?? null;
    }
    /**
     * Set per__cst_failed_payment_attempts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $per__cst_failed_payment_attempts
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Contact_Person_DataObjectType
     */
    public function setPer__cst_failed_payment_attempts(?string $per__cst_failed_payment_attempts = null): self
    {
        // validation for constraint: string
        if (!is_null($per__cst_failed_payment_attempts) && !is_string($per__cst_failed_payment_attempts)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($per__cst_failed_payment_attempts, true), gettype($per__cst_failed_payment_attempts)), __LINE__);
        }
        if (is_null($per__cst_failed_payment_attempts) || (is_array($per__cst_failed_payment_attempts) && empty($per__cst_failed_payment_attempts))) {
            unset($this->per__cst_failed_payment_attempts);
        } else {
            $this->per__cst_failed_payment_attempts = $per__cst_failed_payment_attempts;
        }
        
        return $this;
    }
}
