<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_Exhibitor_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_Exhibitor_DataObjectType extends AbstractStructBase
{
    /**
     * The exh_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_key = null;
    /**
     * The exh_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_cst_key = null;
    /**
     * The exh_inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_inv_code = null;
    /**
     * The exh_exb_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibit Show. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_exb_key = null;
    /**
     * The exh_directory_name
     * Meta information extracted from the WSDL
     * - documentation: directory name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_directory_name = null;
    /**
     * The exh_directory_desc_html
     * Meta information extracted from the WSDL
     * - documentation: directory description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_directory_desc_html = null;
    /**
     * The exh_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: organization. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_ind_cst_key = null;
    /**
     * The exh_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Registrant. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_reg_key = null;
    /**
     * The exh_pref_comm_method
     * Meta information extracted from the WSDL
     * - documentation: pref comm method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_pref_comm_method = null;
    /**
     * The exh_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_cxa_key = null;
    /**
     * The exh_cph_key
     * Meta information extracted from the WSDL
     * - documentation: phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_cph_key = null;
    /**
     * The exh_eml_key
     * Meta information extracted from the WSDL
     * - documentation: email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_eml_key = null;
    /**
     * The exh_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_cfx_key = null;
    /**
     * The exh_url_key
     * Meta information extracted from the WSDL
     * - documentation: url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_url_key = null;
    /**
     * The exh_on_wait_list_flag
     * Meta information extracted from the WSDL
     * - documentation: on wait list?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_on_wait_list_flag = null;
    /**
     * The exh_confirm_date
     * Meta information extracted from the WSDL
     * - documentation: date confirmation sent. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_confirm_date = null;
    /**
     * The exh_attendance_flag
     * Meta information extracted from the WSDL
     * - documentation: attended?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_attendance_flag = null;
    /**
     * The exh_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_add_user = null;
    /**
     * The exh_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_add_date = null;
    /**
     * The exh_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_change_user = null;
    /**
     * The exh_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_change_date = null;
    /**
     * The exh_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_delete_flag = null;
    /**
     * The exh_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_key_ext = null;
    /**
     * The exh_avoid_competitors
     * Meta information extracted from the WSDL
     * - documentation: Avoid competitors. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_avoid_competitors = null;
    /**
     * The exh_priority_points_gained
     * Meta information extracted from the WSDL
     * - documentation: priority points gained. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $exh_priority_points_gained = null;
    /**
     * The exh_comp_registrations_total
     * Meta information extracted from the WSDL
     * - documentation: total comp registrations. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $exh_comp_registrations_total = null;
    /**
     * The exh_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_entity_key = null;
    /**
     * The exh_contract_send_date
     * Meta information extracted from the WSDL
     * - documentation: contract send date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_contract_send_date = null;
    /**
     * The exh_contract_status
     * Meta information extracted from the WSDL
     * - documentation: contract status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_contract_status = null;
    /**
     * The exh_contract_receive_date
     * Meta information extracted from the WSDL
     * - documentation: contract receive date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_contract_receive_date = null;
    /**
     * The exh_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: cancellation date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_cancel_date = null;
    /**
     * The exh_cancel_reason
     * Meta information extracted from the WSDL
     * - documentation: cancel reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_cancel_reason = null;
    /**
     * The exh_ord_code
     * Meta information extracted from the WSDL
     * - documentation: order code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_ord_code = null;
    /**
     * The exh_comp_booth_personnel_total
     * Meta information extracted from the WSDL
     * - documentation: total comp booth person. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $exh_comp_booth_personnel_total = null;
    /**
     * The exh_bup_prd_key
     * Meta information extracted from the WSDL
     * - documentation: bundle component product key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exh_bup_prd_key = null;
    /**
     * The exh_comp_booth_personnel_available
     * Meta information extracted from the WSDL
     * - documentation: comp booth available this session.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $exh_comp_booth_personnel_available = null;
    /**
     * The exh_comp_product_available_flag
     * Meta information extracted from the WSDL
     * - documentation: comp product available.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_comp_product_available_flag = null;
    /**
     * The exh_shared_booths_available_flag
     * Meta information extracted from the WSDL
     * - documentation: shared booths available.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_shared_booths_available_flag = null;
    /**
     * The exh_can_create_invoice_flag
     * Meta information extracted from the WSDL
     * - documentation: can create a invoice.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_can_create_invoice_flag = null;
    /**
     * The exh_can_have_booth_person_flag
     * Meta information extracted from the WSDL
     * - documentation: can have booth person.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_can_have_booth_person_flag = null;
    /**
     * The exh_process
     * Meta information extracted from the WSDL
     * - documentation: process.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_process = null;
    /**
     * The exh_can_have_sponsor_flag
     * Meta information extracted from the WSDL
     * - documentation: can have sponsor.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_can_have_sponsor_flag = null;
    /**
     * The exh_can_have_booth_flag
     * Meta information extracted from the WSDL
     * - documentation: can have booth.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_can_have_booth_flag = null;
    /**
     * The exh_can_have_booth_preferences
     * Meta information extracted from the WSDL
     * - documentation: can have booth preference.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exh_can_have_booth_preferences = null;
    /**
     * Constructor method for ExhibitorNew_Exhibitor_DataObjectType
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_cst_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_inv_code()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_exb_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_directory_name()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_directory_desc_html()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_ind_cst_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_reg_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_pref_comm_method()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_cxa_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_cph_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_eml_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_cfx_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_url_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_on_wait_list_flag()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_confirm_date()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_attendance_flag()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_add_user()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_add_date()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_change_user()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_change_date()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_delete_flag()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_key_ext()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_avoid_competitors()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_priority_points_gained()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_comp_registrations_total()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_entity_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_contract_send_date()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_contract_status()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_contract_receive_date()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_cancel_date()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_cancel_reason()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_ord_code()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_comp_booth_personnel_total()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_bup_prd_key()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_comp_booth_personnel_available()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_comp_product_available_flag()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_shared_booths_available_flag()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_can_create_invoice_flag()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_can_have_booth_person_flag()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_process()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_can_have_sponsor_flag()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_can_have_booth_flag()
     * @uses ExhibitorNew_Exhibitor_DataObjectType::setExh_can_have_booth_preferences()
     * @param string $exh_key
     * @param string $exh_cst_key
     * @param string $exh_inv_code
     * @param string $exh_exb_key
     * @param string $exh_directory_name
     * @param string $exh_directory_desc_html
     * @param string $exh_ind_cst_key
     * @param string $exh_reg_key
     * @param string $exh_pref_comm_method
     * @param string $exh_cxa_key
     * @param string $exh_cph_key
     * @param string $exh_eml_key
     * @param string $exh_cfx_key
     * @param string $exh_url_key
     * @param string $exh_on_wait_list_flag
     * @param string $exh_confirm_date
     * @param string $exh_attendance_flag
     * @param string $exh_add_user
     * @param string $exh_add_date
     * @param string $exh_change_user
     * @param string $exh_change_date
     * @param string $exh_delete_flag
     * @param string $exh_key_ext
     * @param string $exh_avoid_competitors
     * @param float $exh_priority_points_gained
     * @param int $exh_comp_registrations_total
     * @param string $exh_entity_key
     * @param string $exh_contract_send_date
     * @param string $exh_contract_status
     * @param string $exh_contract_receive_date
     * @param string $exh_cancel_date
     * @param string $exh_cancel_reason
     * @param string $exh_ord_code
     * @param int $exh_comp_booth_personnel_total
     * @param string $exh_bup_prd_key
     * @param int $exh_comp_booth_personnel_available
     * @param string $exh_comp_product_available_flag
     * @param string $exh_shared_booths_available_flag
     * @param string $exh_can_create_invoice_flag
     * @param string $exh_can_have_booth_person_flag
     * @param string $exh_process
     * @param string $exh_can_have_sponsor_flag
     * @param string $exh_can_have_booth_flag
     * @param string $exh_can_have_booth_preferences
     */
    public function __construct(?string $exh_key = null, ?string $exh_cst_key = null, ?string $exh_inv_code = null, ?string $exh_exb_key = null, ?string $exh_directory_name = null, ?string $exh_directory_desc_html = null, ?string $exh_ind_cst_key = null, ?string $exh_reg_key = null, ?string $exh_pref_comm_method = null, ?string $exh_cxa_key = null, ?string $exh_cph_key = null, ?string $exh_eml_key = null, ?string $exh_cfx_key = null, ?string $exh_url_key = null, ?string $exh_on_wait_list_flag = null, ?string $exh_confirm_date = null, ?string $exh_attendance_flag = null, ?string $exh_add_user = null, ?string $exh_add_date = null, ?string $exh_change_user = null, ?string $exh_change_date = null, ?string $exh_delete_flag = null, ?string $exh_key_ext = null, ?string $exh_avoid_competitors = null, ?float $exh_priority_points_gained = null, ?int $exh_comp_registrations_total = null, ?string $exh_entity_key = null, ?string $exh_contract_send_date = null, ?string $exh_contract_status = null, ?string $exh_contract_receive_date = null, ?string $exh_cancel_date = null, ?string $exh_cancel_reason = null, ?string $exh_ord_code = null, ?int $exh_comp_booth_personnel_total = null, ?string $exh_bup_prd_key = null, ?int $exh_comp_booth_personnel_available = null, ?string $exh_comp_product_available_flag = null, ?string $exh_shared_booths_available_flag = null, ?string $exh_can_create_invoice_flag = null, ?string $exh_can_have_booth_person_flag = null, ?string $exh_process = null, ?string $exh_can_have_sponsor_flag = null, ?string $exh_can_have_booth_flag = null, ?string $exh_can_have_booth_preferences = null)
    {
        $this
            ->setExh_key($exh_key)
            ->setExh_cst_key($exh_cst_key)
            ->setExh_inv_code($exh_inv_code)
            ->setExh_exb_key($exh_exb_key)
            ->setExh_directory_name($exh_directory_name)
            ->setExh_directory_desc_html($exh_directory_desc_html)
            ->setExh_ind_cst_key($exh_ind_cst_key)
            ->setExh_reg_key($exh_reg_key)
            ->setExh_pref_comm_method($exh_pref_comm_method)
            ->setExh_cxa_key($exh_cxa_key)
            ->setExh_cph_key($exh_cph_key)
            ->setExh_eml_key($exh_eml_key)
            ->setExh_cfx_key($exh_cfx_key)
            ->setExh_url_key($exh_url_key)
            ->setExh_on_wait_list_flag($exh_on_wait_list_flag)
            ->setExh_confirm_date($exh_confirm_date)
            ->setExh_attendance_flag($exh_attendance_flag)
            ->setExh_add_user($exh_add_user)
            ->setExh_add_date($exh_add_date)
            ->setExh_change_user($exh_change_user)
            ->setExh_change_date($exh_change_date)
            ->setExh_delete_flag($exh_delete_flag)
            ->setExh_key_ext($exh_key_ext)
            ->setExh_avoid_competitors($exh_avoid_competitors)
            ->setExh_priority_points_gained($exh_priority_points_gained)
            ->setExh_comp_registrations_total($exh_comp_registrations_total)
            ->setExh_entity_key($exh_entity_key)
            ->setExh_contract_send_date($exh_contract_send_date)
            ->setExh_contract_status($exh_contract_status)
            ->setExh_contract_receive_date($exh_contract_receive_date)
            ->setExh_cancel_date($exh_cancel_date)
            ->setExh_cancel_reason($exh_cancel_reason)
            ->setExh_ord_code($exh_ord_code)
            ->setExh_comp_booth_personnel_total($exh_comp_booth_personnel_total)
            ->setExh_bup_prd_key($exh_bup_prd_key)
            ->setExh_comp_booth_personnel_available($exh_comp_booth_personnel_available)
            ->setExh_comp_product_available_flag($exh_comp_product_available_flag)
            ->setExh_shared_booths_available_flag($exh_shared_booths_available_flag)
            ->setExh_can_create_invoice_flag($exh_can_create_invoice_flag)
            ->setExh_can_have_booth_person_flag($exh_can_have_booth_person_flag)
            ->setExh_process($exh_process)
            ->setExh_can_have_sponsor_flag($exh_can_have_sponsor_flag)
            ->setExh_can_have_booth_flag($exh_can_have_booth_flag)
            ->setExh_can_have_booth_preferences($exh_can_have_booth_preferences);
    }
    /**
     * Get exh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_key(): ?string
    {
        return $this->exh_key ?? null;
    }
    /**
     * Set exh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_key(?string $exh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_key) && !is_string($exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_key, true), gettype($exh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_key, true)), __LINE__);
        }
        if (is_null($exh_key) || (is_array($exh_key) && empty($exh_key))) {
            unset($this->exh_key);
        } else {
            $this->exh_key = $exh_key;
        }
        
        return $this;
    }
    /**
     * Get exh_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_cst_key(): ?string
    {
        return $this->exh_cst_key ?? null;
    }
    /**
     * Set exh_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_cst_key(?string $exh_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_cst_key) && !is_string($exh_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_cst_key, true), gettype($exh_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_cst_key, true)), __LINE__);
        }
        if (is_null($exh_cst_key) || (is_array($exh_cst_key) && empty($exh_cst_key))) {
            unset($this->exh_cst_key);
        } else {
            $this->exh_cst_key = $exh_cst_key;
        }
        
        return $this;
    }
    /**
     * Get exh_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_inv_code(): ?string
    {
        return $this->exh_inv_code ?? null;
    }
    /**
     * Set exh_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_inv_code(?string $exh_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_inv_code) && !is_string($exh_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_inv_code, true), gettype($exh_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($exh_inv_code) && mb_strlen((string) $exh_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $exh_inv_code)), __LINE__);
        }
        if (is_null($exh_inv_code) || (is_array($exh_inv_code) && empty($exh_inv_code))) {
            unset($this->exh_inv_code);
        } else {
            $this->exh_inv_code = $exh_inv_code;
        }
        
        return $this;
    }
    /**
     * Get exh_exb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_exb_key(): ?string
    {
        return $this->exh_exb_key ?? null;
    }
    /**
     * Set exh_exb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_exb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_exb_key(?string $exh_exb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_exb_key) && !is_string($exh_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_exb_key, true), gettype($exh_exb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_exb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_exb_key, true)), __LINE__);
        }
        if (is_null($exh_exb_key) || (is_array($exh_exb_key) && empty($exh_exb_key))) {
            unset($this->exh_exb_key);
        } else {
            $this->exh_exb_key = $exh_exb_key;
        }
        
        return $this;
    }
    /**
     * Get exh_directory_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_directory_name(): ?string
    {
        return $this->exh_directory_name ?? null;
    }
    /**
     * Set exh_directory_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_directory_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_directory_name(?string $exh_directory_name = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_directory_name) && !is_string($exh_directory_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_directory_name, true), gettype($exh_directory_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($exh_directory_name) && mb_strlen((string) $exh_directory_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $exh_directory_name)), __LINE__);
        }
        if (is_null($exh_directory_name) || (is_array($exh_directory_name) && empty($exh_directory_name))) {
            unset($this->exh_directory_name);
        } else {
            $this->exh_directory_name = $exh_directory_name;
        }
        
        return $this;
    }
    /**
     * Get exh_directory_desc_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_directory_desc_html(): ?string
    {
        return $this->exh_directory_desc_html ?? null;
    }
    /**
     * Set exh_directory_desc_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_directory_desc_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_directory_desc_html(?string $exh_directory_desc_html = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_directory_desc_html) && !is_string($exh_directory_desc_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_directory_desc_html, true), gettype($exh_directory_desc_html)), __LINE__);
        }
        if (is_null($exh_directory_desc_html) || (is_array($exh_directory_desc_html) && empty($exh_directory_desc_html))) {
            unset($this->exh_directory_desc_html);
        } else {
            $this->exh_directory_desc_html = $exh_directory_desc_html;
        }
        
        return $this;
    }
    /**
     * Get exh_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_ind_cst_key(): ?string
    {
        return $this->exh_ind_cst_key ?? null;
    }
    /**
     * Set exh_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_ind_cst_key(?string $exh_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_ind_cst_key) && !is_string($exh_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_ind_cst_key, true), gettype($exh_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_ind_cst_key, true)), __LINE__);
        }
        if (is_null($exh_ind_cst_key) || (is_array($exh_ind_cst_key) && empty($exh_ind_cst_key))) {
            unset($this->exh_ind_cst_key);
        } else {
            $this->exh_ind_cst_key = $exh_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get exh_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_reg_key(): ?string
    {
        return $this->exh_reg_key ?? null;
    }
    /**
     * Set exh_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_reg_key(?string $exh_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_reg_key) && !is_string($exh_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_reg_key, true), gettype($exh_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_reg_key, true)), __LINE__);
        }
        if (is_null($exh_reg_key) || (is_array($exh_reg_key) && empty($exh_reg_key))) {
            unset($this->exh_reg_key);
        } else {
            $this->exh_reg_key = $exh_reg_key;
        }
        
        return $this;
    }
    /**
     * Get exh_pref_comm_method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_pref_comm_method(): ?string
    {
        return $this->exh_pref_comm_method ?? null;
    }
    /**
     * Set exh_pref_comm_method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_pref_comm_method
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_pref_comm_method(?string $exh_pref_comm_method = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_pref_comm_method) && !is_string($exh_pref_comm_method)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_pref_comm_method, true), gettype($exh_pref_comm_method)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($exh_pref_comm_method) && mb_strlen((string) $exh_pref_comm_method) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $exh_pref_comm_method)), __LINE__);
        }
        if (is_null($exh_pref_comm_method) || (is_array($exh_pref_comm_method) && empty($exh_pref_comm_method))) {
            unset($this->exh_pref_comm_method);
        } else {
            $this->exh_pref_comm_method = $exh_pref_comm_method;
        }
        
        return $this;
    }
    /**
     * Get exh_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_cxa_key(): ?string
    {
        return $this->exh_cxa_key ?? null;
    }
    /**
     * Set exh_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_cxa_key(?string $exh_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_cxa_key) && !is_string($exh_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_cxa_key, true), gettype($exh_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_cxa_key, true)), __LINE__);
        }
        if (is_null($exh_cxa_key) || (is_array($exh_cxa_key) && empty($exh_cxa_key))) {
            unset($this->exh_cxa_key);
        } else {
            $this->exh_cxa_key = $exh_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get exh_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_cph_key(): ?string
    {
        return $this->exh_cph_key ?? null;
    }
    /**
     * Set exh_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_cph_key(?string $exh_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_cph_key) && !is_string($exh_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_cph_key, true), gettype($exh_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_cph_key, true)), __LINE__);
        }
        if (is_null($exh_cph_key) || (is_array($exh_cph_key) && empty($exh_cph_key))) {
            unset($this->exh_cph_key);
        } else {
            $this->exh_cph_key = $exh_cph_key;
        }
        
        return $this;
    }
    /**
     * Get exh_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_eml_key(): ?string
    {
        return $this->exh_eml_key ?? null;
    }
    /**
     * Set exh_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_eml_key(?string $exh_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_eml_key) && !is_string($exh_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_eml_key, true), gettype($exh_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_eml_key, true)), __LINE__);
        }
        if (is_null($exh_eml_key) || (is_array($exh_eml_key) && empty($exh_eml_key))) {
            unset($this->exh_eml_key);
        } else {
            $this->exh_eml_key = $exh_eml_key;
        }
        
        return $this;
    }
    /**
     * Get exh_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_cfx_key(): ?string
    {
        return $this->exh_cfx_key ?? null;
    }
    /**
     * Set exh_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_cfx_key(?string $exh_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_cfx_key) && !is_string($exh_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_cfx_key, true), gettype($exh_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_cfx_key, true)), __LINE__);
        }
        if (is_null($exh_cfx_key) || (is_array($exh_cfx_key) && empty($exh_cfx_key))) {
            unset($this->exh_cfx_key);
        } else {
            $this->exh_cfx_key = $exh_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get exh_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_url_key(): ?string
    {
        return $this->exh_url_key ?? null;
    }
    /**
     * Set exh_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_url_key(?string $exh_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_url_key) && !is_string($exh_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_url_key, true), gettype($exh_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_url_key, true)), __LINE__);
        }
        if (is_null($exh_url_key) || (is_array($exh_url_key) && empty($exh_url_key))) {
            unset($this->exh_url_key);
        } else {
            $this->exh_url_key = $exh_url_key;
        }
        
        return $this;
    }
    /**
     * Get exh_on_wait_list_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_on_wait_list_flag(): ?string
    {
        return $this->exh_on_wait_list_flag ?? null;
    }
    /**
     * Set exh_on_wait_list_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_on_wait_list_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_on_wait_list_flag(?string $exh_on_wait_list_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_on_wait_list_flag) && !is_string($exh_on_wait_list_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_on_wait_list_flag, true), gettype($exh_on_wait_list_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_on_wait_list_flag) && $exh_on_wait_list_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_on_wait_list_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_on_wait_list_flag) && $exh_on_wait_list_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_on_wait_list_flag, true)), __LINE__);
        }
        if (is_null($exh_on_wait_list_flag) || (is_array($exh_on_wait_list_flag) && empty($exh_on_wait_list_flag))) {
            unset($this->exh_on_wait_list_flag);
        } else {
            $this->exh_on_wait_list_flag = $exh_on_wait_list_flag;
        }
        
        return $this;
    }
    /**
     * Get exh_confirm_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_confirm_date(): ?string
    {
        return $this->exh_confirm_date ?? null;
    }
    /**
     * Set exh_confirm_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_confirm_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_confirm_date(?string $exh_confirm_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_confirm_date) && !is_string($exh_confirm_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_confirm_date, true), gettype($exh_confirm_date)), __LINE__);
        }
        if (is_null($exh_confirm_date) || (is_array($exh_confirm_date) && empty($exh_confirm_date))) {
            unset($this->exh_confirm_date);
        } else {
            $this->exh_confirm_date = $exh_confirm_date;
        }
        
        return $this;
    }
    /**
     * Get exh_attendance_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_attendance_flag(): ?string
    {
        return $this->exh_attendance_flag ?? null;
    }
    /**
     * Set exh_attendance_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_attendance_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_attendance_flag(?string $exh_attendance_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_attendance_flag) && !is_string($exh_attendance_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_attendance_flag, true), gettype($exh_attendance_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_attendance_flag) && $exh_attendance_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_attendance_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_attendance_flag) && $exh_attendance_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_attendance_flag, true)), __LINE__);
        }
        if (is_null($exh_attendance_flag) || (is_array($exh_attendance_flag) && empty($exh_attendance_flag))) {
            unset($this->exh_attendance_flag);
        } else {
            $this->exh_attendance_flag = $exh_attendance_flag;
        }
        
        return $this;
    }
    /**
     * Get exh_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_add_user(): ?string
    {
        return $this->exh_add_user ?? null;
    }
    /**
     * Set exh_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_add_user(?string $exh_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_add_user) && !is_string($exh_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_add_user, true), gettype($exh_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($exh_add_user) && mb_strlen((string) $exh_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $exh_add_user)), __LINE__);
        }
        if (is_null($exh_add_user) || (is_array($exh_add_user) && empty($exh_add_user))) {
            unset($this->exh_add_user);
        } else {
            $this->exh_add_user = $exh_add_user;
        }
        
        return $this;
    }
    /**
     * Get exh_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_add_date(): ?string
    {
        return $this->exh_add_date ?? null;
    }
    /**
     * Set exh_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_add_date(?string $exh_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_add_date) && !is_string($exh_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_add_date, true), gettype($exh_add_date)), __LINE__);
        }
        if (is_null($exh_add_date) || (is_array($exh_add_date) && empty($exh_add_date))) {
            unset($this->exh_add_date);
        } else {
            $this->exh_add_date = $exh_add_date;
        }
        
        return $this;
    }
    /**
     * Get exh_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_change_user(): ?string
    {
        return $this->exh_change_user ?? null;
    }
    /**
     * Set exh_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_change_user(?string $exh_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_change_user) && !is_string($exh_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_change_user, true), gettype($exh_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($exh_change_user) && mb_strlen((string) $exh_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $exh_change_user)), __LINE__);
        }
        if (is_null($exh_change_user) || (is_array($exh_change_user) && empty($exh_change_user))) {
            unset($this->exh_change_user);
        } else {
            $this->exh_change_user = $exh_change_user;
        }
        
        return $this;
    }
    /**
     * Get exh_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_change_date(): ?string
    {
        return $this->exh_change_date ?? null;
    }
    /**
     * Set exh_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_change_date(?string $exh_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_change_date) && !is_string($exh_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_change_date, true), gettype($exh_change_date)), __LINE__);
        }
        if (is_null($exh_change_date) || (is_array($exh_change_date) && empty($exh_change_date))) {
            unset($this->exh_change_date);
        } else {
            $this->exh_change_date = $exh_change_date;
        }
        
        return $this;
    }
    /**
     * Get exh_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_delete_flag(): ?string
    {
        return $this->exh_delete_flag ?? null;
    }
    /**
     * Set exh_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_delete_flag(?string $exh_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_delete_flag) && !is_string($exh_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_delete_flag, true), gettype($exh_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_delete_flag) && $exh_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_delete_flag) && $exh_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_delete_flag, true)), __LINE__);
        }
        if (is_null($exh_delete_flag) || (is_array($exh_delete_flag) && empty($exh_delete_flag))) {
            unset($this->exh_delete_flag);
        } else {
            $this->exh_delete_flag = $exh_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get exh_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_key_ext(): ?string
    {
        return $this->exh_key_ext ?? null;
    }
    /**
     * Set exh_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_key_ext(?string $exh_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_key_ext) && !is_string($exh_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_key_ext, true), gettype($exh_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_key_ext, true)), __LINE__);
        }
        if (is_null($exh_key_ext) || (is_array($exh_key_ext) && empty($exh_key_ext))) {
            unset($this->exh_key_ext);
        } else {
            $this->exh_key_ext = $exh_key_ext;
        }
        
        return $this;
    }
    /**
     * Get exh_avoid_competitors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_avoid_competitors(): ?string
    {
        return $this->exh_avoid_competitors ?? null;
    }
    /**
     * Set exh_avoid_competitors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_avoid_competitors
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_avoid_competitors(?string $exh_avoid_competitors = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_avoid_competitors) && !is_string($exh_avoid_competitors)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_avoid_competitors, true), gettype($exh_avoid_competitors)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($exh_avoid_competitors) && mb_strlen((string) $exh_avoid_competitors) > 500) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen((string) $exh_avoid_competitors)), __LINE__);
        }
        if (is_null($exh_avoid_competitors) || (is_array($exh_avoid_competitors) && empty($exh_avoid_competitors))) {
            unset($this->exh_avoid_competitors);
        } else {
            $this->exh_avoid_competitors = $exh_avoid_competitors;
        }
        
        return $this;
    }
    /**
     * Get exh_priority_points_gained value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExh_priority_points_gained(): ?float
    {
        return $this->exh_priority_points_gained ?? null;
    }
    /**
     * Set exh_priority_points_gained value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $exh_priority_points_gained
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_priority_points_gained(?float $exh_priority_points_gained = null): self
    {
        // validation for constraint: float
        if (!is_null($exh_priority_points_gained) && !(is_float($exh_priority_points_gained) || is_numeric($exh_priority_points_gained))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exh_priority_points_gained, true), gettype($exh_priority_points_gained)), __LINE__);
        }
        if (is_null($exh_priority_points_gained) || (is_array($exh_priority_points_gained) && empty($exh_priority_points_gained))) {
            unset($this->exh_priority_points_gained);
        } else {
            $this->exh_priority_points_gained = $exh_priority_points_gained;
        }
        
        return $this;
    }
    /**
     * Get exh_comp_registrations_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExh_comp_registrations_total(): ?int
    {
        return $this->exh_comp_registrations_total ?? null;
    }
    /**
     * Set exh_comp_registrations_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $exh_comp_registrations_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_comp_registrations_total(?int $exh_comp_registrations_total = null): self
    {
        // validation for constraint: int
        if (!is_null($exh_comp_registrations_total) && !(is_int($exh_comp_registrations_total) || ctype_digit($exh_comp_registrations_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exh_comp_registrations_total, true), gettype($exh_comp_registrations_total)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($exh_comp_registrations_total) && $exh_comp_registrations_total > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($exh_comp_registrations_total, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($exh_comp_registrations_total) && $exh_comp_registrations_total < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($exh_comp_registrations_total, true)), __LINE__);
        }
        if (is_null($exh_comp_registrations_total) || (is_array($exh_comp_registrations_total) && empty($exh_comp_registrations_total))) {
            unset($this->exh_comp_registrations_total);
        } else {
            $this->exh_comp_registrations_total = $exh_comp_registrations_total;
        }
        
        return $this;
    }
    /**
     * Get exh_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_entity_key(): ?string
    {
        return $this->exh_entity_key ?? null;
    }
    /**
     * Set exh_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_entity_key(?string $exh_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_entity_key) && !is_string($exh_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_entity_key, true), gettype($exh_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_entity_key, true)), __LINE__);
        }
        if (is_null($exh_entity_key) || (is_array($exh_entity_key) && empty($exh_entity_key))) {
            unset($this->exh_entity_key);
        } else {
            $this->exh_entity_key = $exh_entity_key;
        }
        
        return $this;
    }
    /**
     * Get exh_contract_send_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_contract_send_date(): ?string
    {
        return $this->exh_contract_send_date ?? null;
    }
    /**
     * Set exh_contract_send_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_contract_send_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_contract_send_date(?string $exh_contract_send_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_contract_send_date) && !is_string($exh_contract_send_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_contract_send_date, true), gettype($exh_contract_send_date)), __LINE__);
        }
        if (is_null($exh_contract_send_date) || (is_array($exh_contract_send_date) && empty($exh_contract_send_date))) {
            unset($this->exh_contract_send_date);
        } else {
            $this->exh_contract_send_date = $exh_contract_send_date;
        }
        
        return $this;
    }
    /**
     * Get exh_contract_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_contract_status(): ?string
    {
        return $this->exh_contract_status ?? null;
    }
    /**
     * Set exh_contract_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_contract_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_contract_status(?string $exh_contract_status = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_contract_status) && !is_string($exh_contract_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_contract_status, true), gettype($exh_contract_status)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($exh_contract_status) && mb_strlen((string) $exh_contract_status) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $exh_contract_status)), __LINE__);
        }
        if (is_null($exh_contract_status) || (is_array($exh_contract_status) && empty($exh_contract_status))) {
            unset($this->exh_contract_status);
        } else {
            $this->exh_contract_status = $exh_contract_status;
        }
        
        return $this;
    }
    /**
     * Get exh_contract_receive_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_contract_receive_date(): ?string
    {
        return $this->exh_contract_receive_date ?? null;
    }
    /**
     * Set exh_contract_receive_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_contract_receive_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_contract_receive_date(?string $exh_contract_receive_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_contract_receive_date) && !is_string($exh_contract_receive_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_contract_receive_date, true), gettype($exh_contract_receive_date)), __LINE__);
        }
        if (is_null($exh_contract_receive_date) || (is_array($exh_contract_receive_date) && empty($exh_contract_receive_date))) {
            unset($this->exh_contract_receive_date);
        } else {
            $this->exh_contract_receive_date = $exh_contract_receive_date;
        }
        
        return $this;
    }
    /**
     * Get exh_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_cancel_date(): ?string
    {
        return $this->exh_cancel_date ?? null;
    }
    /**
     * Set exh_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_cancel_date(?string $exh_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_cancel_date) && !is_string($exh_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_cancel_date, true), gettype($exh_cancel_date)), __LINE__);
        }
        if (is_null($exh_cancel_date) || (is_array($exh_cancel_date) && empty($exh_cancel_date))) {
            unset($this->exh_cancel_date);
        } else {
            $this->exh_cancel_date = $exh_cancel_date;
        }
        
        return $this;
    }
    /**
     * Get exh_cancel_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_cancel_reason(): ?string
    {
        return $this->exh_cancel_reason ?? null;
    }
    /**
     * Set exh_cancel_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_cancel_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_cancel_reason(?string $exh_cancel_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_cancel_reason) && !is_string($exh_cancel_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_cancel_reason, true), gettype($exh_cancel_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($exh_cancel_reason) && mb_strlen((string) $exh_cancel_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $exh_cancel_reason)), __LINE__);
        }
        if (is_null($exh_cancel_reason) || (is_array($exh_cancel_reason) && empty($exh_cancel_reason))) {
            unset($this->exh_cancel_reason);
        } else {
            $this->exh_cancel_reason = $exh_cancel_reason;
        }
        
        return $this;
    }
    /**
     * Get exh_ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_ord_code(): ?string
    {
        return $this->exh_ord_code ?? null;
    }
    /**
     * Set exh_ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_ord_code(?string $exh_ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_ord_code) && !is_string($exh_ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_ord_code, true), gettype($exh_ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($exh_ord_code) && mb_strlen((string) $exh_ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $exh_ord_code)), __LINE__);
        }
        if (is_null($exh_ord_code) || (is_array($exh_ord_code) && empty($exh_ord_code))) {
            unset($this->exh_ord_code);
        } else {
            $this->exh_ord_code = $exh_ord_code;
        }
        
        return $this;
    }
    /**
     * Get exh_comp_booth_personnel_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExh_comp_booth_personnel_total(): ?int
    {
        return $this->exh_comp_booth_personnel_total ?? null;
    }
    /**
     * Set exh_comp_booth_personnel_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $exh_comp_booth_personnel_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_comp_booth_personnel_total(?int $exh_comp_booth_personnel_total = null): self
    {
        // validation for constraint: int
        if (!is_null($exh_comp_booth_personnel_total) && !(is_int($exh_comp_booth_personnel_total) || ctype_digit($exh_comp_booth_personnel_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exh_comp_booth_personnel_total, true), gettype($exh_comp_booth_personnel_total)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($exh_comp_booth_personnel_total) && $exh_comp_booth_personnel_total > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($exh_comp_booth_personnel_total, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($exh_comp_booth_personnel_total) && $exh_comp_booth_personnel_total < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($exh_comp_booth_personnel_total, true)), __LINE__);
        }
        if (is_null($exh_comp_booth_personnel_total) || (is_array($exh_comp_booth_personnel_total) && empty($exh_comp_booth_personnel_total))) {
            unset($this->exh_comp_booth_personnel_total);
        } else {
            $this->exh_comp_booth_personnel_total = $exh_comp_booth_personnel_total;
        }
        
        return $this;
    }
    /**
     * Get exh_bup_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_bup_prd_key(): ?string
    {
        return $this->exh_bup_prd_key ?? null;
    }
    /**
     * Set exh_bup_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_bup_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_bup_prd_key(?string $exh_bup_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_bup_prd_key) && !is_string($exh_bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_bup_prd_key, true), gettype($exh_bup_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exh_bup_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exh_bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exh_bup_prd_key, true)), __LINE__);
        }
        if (is_null($exh_bup_prd_key) || (is_array($exh_bup_prd_key) && empty($exh_bup_prd_key))) {
            unset($this->exh_bup_prd_key);
        } else {
            $this->exh_bup_prd_key = $exh_bup_prd_key;
        }
        
        return $this;
    }
    /**
     * Get exh_comp_booth_personnel_available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExh_comp_booth_personnel_available(): ?int
    {
        return $this->exh_comp_booth_personnel_available ?? null;
    }
    /**
     * Set exh_comp_booth_personnel_available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $exh_comp_booth_personnel_available
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_comp_booth_personnel_available(?int $exh_comp_booth_personnel_available = null): self
    {
        // validation for constraint: int
        if (!is_null($exh_comp_booth_personnel_available) && !(is_int($exh_comp_booth_personnel_available) || ctype_digit($exh_comp_booth_personnel_available))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exh_comp_booth_personnel_available, true), gettype($exh_comp_booth_personnel_available)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($exh_comp_booth_personnel_available) && $exh_comp_booth_personnel_available > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($exh_comp_booth_personnel_available, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($exh_comp_booth_personnel_available) && $exh_comp_booth_personnel_available < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($exh_comp_booth_personnel_available, true)), __LINE__);
        }
        if (is_null($exh_comp_booth_personnel_available) || (is_array($exh_comp_booth_personnel_available) && empty($exh_comp_booth_personnel_available))) {
            unset($this->exh_comp_booth_personnel_available);
        } else {
            $this->exh_comp_booth_personnel_available = $exh_comp_booth_personnel_available;
        }
        
        return $this;
    }
    /**
     * Get exh_comp_product_available_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_comp_product_available_flag(): ?string
    {
        return $this->exh_comp_product_available_flag ?? null;
    }
    /**
     * Set exh_comp_product_available_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_comp_product_available_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_comp_product_available_flag(?string $exh_comp_product_available_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_comp_product_available_flag) && !is_string($exh_comp_product_available_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_comp_product_available_flag, true), gettype($exh_comp_product_available_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_comp_product_available_flag) && $exh_comp_product_available_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_comp_product_available_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_comp_product_available_flag) && $exh_comp_product_available_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_comp_product_available_flag, true)), __LINE__);
        }
        if (is_null($exh_comp_product_available_flag) || (is_array($exh_comp_product_available_flag) && empty($exh_comp_product_available_flag))) {
            unset($this->exh_comp_product_available_flag);
        } else {
            $this->exh_comp_product_available_flag = $exh_comp_product_available_flag;
        }
        
        return $this;
    }
    /**
     * Get exh_shared_booths_available_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_shared_booths_available_flag(): ?string
    {
        return $this->exh_shared_booths_available_flag ?? null;
    }
    /**
     * Set exh_shared_booths_available_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_shared_booths_available_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_shared_booths_available_flag(?string $exh_shared_booths_available_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_shared_booths_available_flag) && !is_string($exh_shared_booths_available_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_shared_booths_available_flag, true), gettype($exh_shared_booths_available_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_shared_booths_available_flag) && $exh_shared_booths_available_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_shared_booths_available_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_shared_booths_available_flag) && $exh_shared_booths_available_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_shared_booths_available_flag, true)), __LINE__);
        }
        if (is_null($exh_shared_booths_available_flag) || (is_array($exh_shared_booths_available_flag) && empty($exh_shared_booths_available_flag))) {
            unset($this->exh_shared_booths_available_flag);
        } else {
            $this->exh_shared_booths_available_flag = $exh_shared_booths_available_flag;
        }
        
        return $this;
    }
    /**
     * Get exh_can_create_invoice_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_can_create_invoice_flag(): ?string
    {
        return $this->exh_can_create_invoice_flag ?? null;
    }
    /**
     * Set exh_can_create_invoice_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_can_create_invoice_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_can_create_invoice_flag(?string $exh_can_create_invoice_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_can_create_invoice_flag) && !is_string($exh_can_create_invoice_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_can_create_invoice_flag, true), gettype($exh_can_create_invoice_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_can_create_invoice_flag) && $exh_can_create_invoice_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_can_create_invoice_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_can_create_invoice_flag) && $exh_can_create_invoice_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_can_create_invoice_flag, true)), __LINE__);
        }
        if (is_null($exh_can_create_invoice_flag) || (is_array($exh_can_create_invoice_flag) && empty($exh_can_create_invoice_flag))) {
            unset($this->exh_can_create_invoice_flag);
        } else {
            $this->exh_can_create_invoice_flag = $exh_can_create_invoice_flag;
        }
        
        return $this;
    }
    /**
     * Get exh_can_have_booth_person_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_can_have_booth_person_flag(): ?string
    {
        return $this->exh_can_have_booth_person_flag ?? null;
    }
    /**
     * Set exh_can_have_booth_person_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_can_have_booth_person_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_can_have_booth_person_flag(?string $exh_can_have_booth_person_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_can_have_booth_person_flag) && !is_string($exh_can_have_booth_person_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_can_have_booth_person_flag, true), gettype($exh_can_have_booth_person_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_can_have_booth_person_flag) && $exh_can_have_booth_person_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_can_have_booth_person_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_can_have_booth_person_flag) && $exh_can_have_booth_person_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_can_have_booth_person_flag, true)), __LINE__);
        }
        if (is_null($exh_can_have_booth_person_flag) || (is_array($exh_can_have_booth_person_flag) && empty($exh_can_have_booth_person_flag))) {
            unset($this->exh_can_have_booth_person_flag);
        } else {
            $this->exh_can_have_booth_person_flag = $exh_can_have_booth_person_flag;
        }
        
        return $this;
    }
    /**
     * Get exh_process value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_process(): ?string
    {
        return $this->exh_process ?? null;
    }
    /**
     * Set exh_process value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_process
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_process(?string $exh_process = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_process) && !is_string($exh_process)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_process, true), gettype($exh_process)), __LINE__);
        }
        if (is_null($exh_process) || (is_array($exh_process) && empty($exh_process))) {
            unset($this->exh_process);
        } else {
            $this->exh_process = $exh_process;
        }
        
        return $this;
    }
    /**
     * Get exh_can_have_sponsor_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_can_have_sponsor_flag(): ?string
    {
        return $this->exh_can_have_sponsor_flag ?? null;
    }
    /**
     * Set exh_can_have_sponsor_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_can_have_sponsor_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_can_have_sponsor_flag(?string $exh_can_have_sponsor_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_can_have_sponsor_flag) && !is_string($exh_can_have_sponsor_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_can_have_sponsor_flag, true), gettype($exh_can_have_sponsor_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_can_have_sponsor_flag) && $exh_can_have_sponsor_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_can_have_sponsor_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_can_have_sponsor_flag) && $exh_can_have_sponsor_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_can_have_sponsor_flag, true)), __LINE__);
        }
        if (is_null($exh_can_have_sponsor_flag) || (is_array($exh_can_have_sponsor_flag) && empty($exh_can_have_sponsor_flag))) {
            unset($this->exh_can_have_sponsor_flag);
        } else {
            $this->exh_can_have_sponsor_flag = $exh_can_have_sponsor_flag;
        }
        
        return $this;
    }
    /**
     * Get exh_can_have_booth_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_can_have_booth_flag(): ?string
    {
        return $this->exh_can_have_booth_flag ?? null;
    }
    /**
     * Set exh_can_have_booth_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_can_have_booth_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_can_have_booth_flag(?string $exh_can_have_booth_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_can_have_booth_flag) && !is_string($exh_can_have_booth_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_can_have_booth_flag, true), gettype($exh_can_have_booth_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_can_have_booth_flag) && $exh_can_have_booth_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_can_have_booth_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_can_have_booth_flag) && $exh_can_have_booth_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_can_have_booth_flag, true)), __LINE__);
        }
        if (is_null($exh_can_have_booth_flag) || (is_array($exh_can_have_booth_flag) && empty($exh_can_have_booth_flag))) {
            unset($this->exh_can_have_booth_flag);
        } else {
            $this->exh_can_have_booth_flag = $exh_can_have_booth_flag;
        }
        
        return $this;
    }
    /**
     * Get exh_can_have_booth_preferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExh_can_have_booth_preferences(): ?string
    {
        return $this->exh_can_have_booth_preferences ?? null;
    }
    /**
     * Set exh_can_have_booth_preferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exh_can_have_booth_preferences
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_DataObjectType
     */
    public function setExh_can_have_booth_preferences(?string $exh_can_have_booth_preferences = null): self
    {
        // validation for constraint: string
        if (!is_null($exh_can_have_booth_preferences) && !is_string($exh_can_have_booth_preferences)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exh_can_have_booth_preferences, true), gettype($exh_can_have_booth_preferences)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exh_can_have_booth_preferences) && $exh_can_have_booth_preferences > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exh_can_have_booth_preferences, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exh_can_have_booth_preferences) && $exh_can_have_booth_preferences < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exh_can_have_booth_preferences, true)), __LINE__);
        }
        if (is_null($exh_can_have_booth_preferences) || (is_array($exh_can_have_booth_preferences) && empty($exh_can_have_booth_preferences))) {
            unset($this->exh_can_have_booth_preferences);
        } else {
            $this->exh_can_have_booth_preferences = $exh_can_have_booth_preferences;
        }
        
        return $this;
    }
}
