<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_Exhibitor_Email_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_Exhibitor_Email_DataObjectType extends AbstractStructBase
{
    /**
     * The em2__eml_key
     * Meta information extracted from the WSDL
     * - documentation: Email Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $em2__eml_key = null;
    /**
     * The em2__eml_address
     * Meta information extracted from the WSDL
     * - documentation: E-Mail Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_address = null;
    /**
     * The em2__eml_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $em2__eml_cst_key = null;
    /**
     * The em2__eml_type
     * Meta information extracted from the WSDL
     * - documentation: e-mail type.This element has a default value of 'business'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_type = null;
    /**
     * The em2__eml_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_add_user = null;
    /**
     * The em2__eml_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_add_date = null;
    /**
     * The em2__eml_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_change_user = null;
    /**
     * The em2__eml_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_change_date = null;
    /**
     * The em2__eml_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_delete_flag = null;
    /**
     * The em2__eml_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $em2__eml_key_ext = null;
    /**
     * The em2__eml_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $em2__eml_entity_key = null;
    /**
     * The em2__eml_invalid_flag
     * Meta information extracted from the WSDL
     * - documentation: Invalid E-mail Address. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_invalid_flag = null;
    /**
     * The em2__eml_invalid_reason
     * Meta information extracted from the WSDL
     * - documentation: Invalid E-mail Address Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_invalid_reason = null;
    /**
     * The em2__eml_unlisted_flag
     * Meta information extracted from the WSDL
     * - documentation: do not list my email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $em2__eml_unlisted_flag = null;
    /**
     * Constructor method for ExhibitorNew_Exhibitor_Email_DataObjectType
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_key()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_address()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_cst_key()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_type()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_add_user()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_add_date()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_change_user()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_change_date()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_delete_flag()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_key_ext()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_entity_key()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_invalid_flag()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_invalid_reason()
     * @uses ExhibitorNew_Exhibitor_Email_DataObjectType::setEm2__eml_unlisted_flag()
     * @param string $em2__eml_key
     * @param string $em2__eml_address
     * @param string $em2__eml_cst_key
     * @param string $em2__eml_type
     * @param string $em2__eml_add_user
     * @param string $em2__eml_add_date
     * @param string $em2__eml_change_user
     * @param string $em2__eml_change_date
     * @param string $em2__eml_delete_flag
     * @param string $em2__eml_key_ext
     * @param string $em2__eml_entity_key
     * @param string $em2__eml_invalid_flag
     * @param string $em2__eml_invalid_reason
     * @param string $em2__eml_unlisted_flag
     */
    public function __construct(?string $em2__eml_key = null, ?string $em2__eml_address = null, ?string $em2__eml_cst_key = null, ?string $em2__eml_type = null, ?string $em2__eml_add_user = null, ?string $em2__eml_add_date = null, ?string $em2__eml_change_user = null, ?string $em2__eml_change_date = null, ?string $em2__eml_delete_flag = null, ?string $em2__eml_key_ext = null, ?string $em2__eml_entity_key = null, ?string $em2__eml_invalid_flag = null, ?string $em2__eml_invalid_reason = null, ?string $em2__eml_unlisted_flag = null)
    {
        $this
            ->setEm2__eml_key($em2__eml_key)
            ->setEm2__eml_address($em2__eml_address)
            ->setEm2__eml_cst_key($em2__eml_cst_key)
            ->setEm2__eml_type($em2__eml_type)
            ->setEm2__eml_add_user($em2__eml_add_user)
            ->setEm2__eml_add_date($em2__eml_add_date)
            ->setEm2__eml_change_user($em2__eml_change_user)
            ->setEm2__eml_change_date($em2__eml_change_date)
            ->setEm2__eml_delete_flag($em2__eml_delete_flag)
            ->setEm2__eml_key_ext($em2__eml_key_ext)
            ->setEm2__eml_entity_key($em2__eml_entity_key)
            ->setEm2__eml_invalid_flag($em2__eml_invalid_flag)
            ->setEm2__eml_invalid_reason($em2__eml_invalid_reason)
            ->setEm2__eml_unlisted_flag($em2__eml_unlisted_flag);
    }
    /**
     * Get em2__eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_key(): ?string
    {
        return $this->em2__eml_key ?? null;
    }
    /**
     * Set em2__eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_key(?string $em2__eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_key) && !is_string($em2__eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_key, true), gettype($em2__eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($em2__eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $em2__eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($em2__eml_key, true)), __LINE__);
        }
        if (is_null($em2__eml_key) || (is_array($em2__eml_key) && empty($em2__eml_key))) {
            unset($this->em2__eml_key);
        } else {
            $this->em2__eml_key = $em2__eml_key;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_address(): ?string
    {
        return $this->em2__eml_address ?? null;
    }
    /**
     * Set em2__eml_address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_address
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_address(?string $em2__eml_address = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_address) && !is_string($em2__eml_address)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_address, true), gettype($em2__eml_address)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($em2__eml_address) && mb_strlen((string) $em2__eml_address) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $em2__eml_address)), __LINE__);
        }
        if (is_null($em2__eml_address) || (is_array($em2__eml_address) && empty($em2__eml_address))) {
            unset($this->em2__eml_address);
        } else {
            $this->em2__eml_address = $em2__eml_address;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_cst_key(): ?string
    {
        return $this->em2__eml_cst_key ?? null;
    }
    /**
     * Set em2__eml_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_cst_key(?string $em2__eml_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_cst_key) && !is_string($em2__eml_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_cst_key, true), gettype($em2__eml_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($em2__eml_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $em2__eml_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($em2__eml_cst_key, true)), __LINE__);
        }
        if (is_null($em2__eml_cst_key) || (is_array($em2__eml_cst_key) && empty($em2__eml_cst_key))) {
            unset($this->em2__eml_cst_key);
        } else {
            $this->em2__eml_cst_key = $em2__eml_cst_key;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_type(): ?string
    {
        return $this->em2__eml_type ?? null;
    }
    /**
     * Set em2__eml_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_type(?string $em2__eml_type = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_type) && !is_string($em2__eml_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_type, true), gettype($em2__eml_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($em2__eml_type) && mb_strlen((string) $em2__eml_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $em2__eml_type)), __LINE__);
        }
        if (is_null($em2__eml_type) || (is_array($em2__eml_type) && empty($em2__eml_type))) {
            unset($this->em2__eml_type);
        } else {
            $this->em2__eml_type = $em2__eml_type;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_add_user(): ?string
    {
        return $this->em2__eml_add_user ?? null;
    }
    /**
     * Set em2__eml_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_add_user(?string $em2__eml_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_add_user) && !is_string($em2__eml_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_add_user, true), gettype($em2__eml_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($em2__eml_add_user) && mb_strlen((string) $em2__eml_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $em2__eml_add_user)), __LINE__);
        }
        if (is_null($em2__eml_add_user) || (is_array($em2__eml_add_user) && empty($em2__eml_add_user))) {
            unset($this->em2__eml_add_user);
        } else {
            $this->em2__eml_add_user = $em2__eml_add_user;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_add_date(): ?string
    {
        return $this->em2__eml_add_date ?? null;
    }
    /**
     * Set em2__eml_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_add_date(?string $em2__eml_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_add_date) && !is_string($em2__eml_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_add_date, true), gettype($em2__eml_add_date)), __LINE__);
        }
        if (is_null($em2__eml_add_date) || (is_array($em2__eml_add_date) && empty($em2__eml_add_date))) {
            unset($this->em2__eml_add_date);
        } else {
            $this->em2__eml_add_date = $em2__eml_add_date;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_change_user(): ?string
    {
        return $this->em2__eml_change_user ?? null;
    }
    /**
     * Set em2__eml_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_change_user(?string $em2__eml_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_change_user) && !is_string($em2__eml_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_change_user, true), gettype($em2__eml_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($em2__eml_change_user) && mb_strlen((string) $em2__eml_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $em2__eml_change_user)), __LINE__);
        }
        if (is_null($em2__eml_change_user) || (is_array($em2__eml_change_user) && empty($em2__eml_change_user))) {
            unset($this->em2__eml_change_user);
        } else {
            $this->em2__eml_change_user = $em2__eml_change_user;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_change_date(): ?string
    {
        return $this->em2__eml_change_date ?? null;
    }
    /**
     * Set em2__eml_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_change_date(?string $em2__eml_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_change_date) && !is_string($em2__eml_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_change_date, true), gettype($em2__eml_change_date)), __LINE__);
        }
        if (is_null($em2__eml_change_date) || (is_array($em2__eml_change_date) && empty($em2__eml_change_date))) {
            unset($this->em2__eml_change_date);
        } else {
            $this->em2__eml_change_date = $em2__eml_change_date;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_delete_flag(): ?string
    {
        return $this->em2__eml_delete_flag ?? null;
    }
    /**
     * Set em2__eml_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_delete_flag(?string $em2__eml_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_delete_flag) && !is_string($em2__eml_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_delete_flag, true), gettype($em2__eml_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($em2__eml_delete_flag) && $em2__eml_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($em2__eml_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($em2__eml_delete_flag) && $em2__eml_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($em2__eml_delete_flag, true)), __LINE__);
        }
        if (is_null($em2__eml_delete_flag) || (is_array($em2__eml_delete_flag) && empty($em2__eml_delete_flag))) {
            unset($this->em2__eml_delete_flag);
        } else {
            $this->em2__eml_delete_flag = $em2__eml_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_key_ext(): ?string
    {
        return $this->em2__eml_key_ext ?? null;
    }
    /**
     * Set em2__eml_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_key_ext(?string $em2__eml_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_key_ext) && !is_string($em2__eml_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_key_ext, true), gettype($em2__eml_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($em2__eml_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $em2__eml_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($em2__eml_key_ext, true)), __LINE__);
        }
        if (is_null($em2__eml_key_ext) || (is_array($em2__eml_key_ext) && empty($em2__eml_key_ext))) {
            unset($this->em2__eml_key_ext);
        } else {
            $this->em2__eml_key_ext = $em2__eml_key_ext;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_entity_key(): ?string
    {
        return $this->em2__eml_entity_key ?? null;
    }
    /**
     * Set em2__eml_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_entity_key(?string $em2__eml_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_entity_key) && !is_string($em2__eml_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_entity_key, true), gettype($em2__eml_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($em2__eml_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $em2__eml_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($em2__eml_entity_key, true)), __LINE__);
        }
        if (is_null($em2__eml_entity_key) || (is_array($em2__eml_entity_key) && empty($em2__eml_entity_key))) {
            unset($this->em2__eml_entity_key);
        } else {
            $this->em2__eml_entity_key = $em2__eml_entity_key;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_invalid_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_invalid_flag(): ?string
    {
        return $this->em2__eml_invalid_flag ?? null;
    }
    /**
     * Set em2__eml_invalid_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_invalid_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_invalid_flag(?string $em2__eml_invalid_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_invalid_flag) && !is_string($em2__eml_invalid_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_invalid_flag, true), gettype($em2__eml_invalid_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($em2__eml_invalid_flag) && $em2__eml_invalid_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($em2__eml_invalid_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($em2__eml_invalid_flag) && $em2__eml_invalid_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($em2__eml_invalid_flag, true)), __LINE__);
        }
        if (is_null($em2__eml_invalid_flag) || (is_array($em2__eml_invalid_flag) && empty($em2__eml_invalid_flag))) {
            unset($this->em2__eml_invalid_flag);
        } else {
            $this->em2__eml_invalid_flag = $em2__eml_invalid_flag;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_invalid_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_invalid_reason(): ?string
    {
        return $this->em2__eml_invalid_reason ?? null;
    }
    /**
     * Set em2__eml_invalid_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_invalid_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_invalid_reason(?string $em2__eml_invalid_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_invalid_reason) && !is_string($em2__eml_invalid_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_invalid_reason, true), gettype($em2__eml_invalid_reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($em2__eml_invalid_reason) && mb_strlen((string) $em2__eml_invalid_reason) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $em2__eml_invalid_reason)), __LINE__);
        }
        if (is_null($em2__eml_invalid_reason) || (is_array($em2__eml_invalid_reason) && empty($em2__eml_invalid_reason))) {
            unset($this->em2__eml_invalid_reason);
        } else {
            $this->em2__eml_invalid_reason = $em2__eml_invalid_reason;
        }
        
        return $this;
    }
    /**
     * Get em2__eml_unlisted_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEm2__eml_unlisted_flag(): ?string
    {
        return $this->em2__eml_unlisted_flag ?? null;
    }
    /**
     * Set em2__eml_unlisted_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $em2__eml_unlisted_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_Email_DataObjectType
     */
    public function setEm2__eml_unlisted_flag(?string $em2__eml_unlisted_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($em2__eml_unlisted_flag) && !is_string($em2__eml_unlisted_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($em2__eml_unlisted_flag, true), gettype($em2__eml_unlisted_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($em2__eml_unlisted_flag) && $em2__eml_unlisted_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($em2__eml_unlisted_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($em2__eml_unlisted_flag) && $em2__eml_unlisted_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($em2__eml_unlisted_flag, true)), __LINE__);
        }
        if (is_null($em2__eml_unlisted_flag) || (is_array($em2__eml_unlisted_flag) && empty($em2__eml_unlisted_flag))) {
            unset($this->em2__eml_unlisted_flag);
        } else {
            $this->em2__eml_unlisted_flag = $em2__eml_unlisted_flag;
        }
        
        return $this;
    }
}
