<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_Exhibitor_X_Contact_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_Exhibitor_X_Contact_DataObjectType extends AbstractStructBase
{
    /**
     * The exc_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_key = null;
    /**
     * The exc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exc_add_user = null;
    /**
     * The exc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exc_add_date = null;
    /**
     * The exc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exc_change_user = null;
    /**
     * The exc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exc_change_date = null;
    /**
     * The exc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $exc_delete_flag = null;
    /**
     * The exc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_entity_key = null;
    /**
     * The exc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_key_ext = null;
    /**
     * The exc_exh_key
     * Meta information extracted from the WSDL
     * - documentation: exhibitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_exh_key = null;
    /**
     * The exc_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_cxa_key = null;
    /**
     * The exc_cph_key
     * Meta information extracted from the WSDL
     * - documentation: phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_cph_key = null;
    /**
     * The exc_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_cfx_key = null;
    /**
     * The exc_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_ind_cst_key = null;
    /**
     * The exc_url_key
     * Meta information extracted from the WSDL
     * - documentation: url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_url_key = null;
    /**
     * The exc_eml_key
     * Meta information extracted from the WSDL
     * - documentation: email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_eml_key = null;
    /**
     * The exc_rlt_key
     * Meta information extracted from the WSDL
     * - documentation: role. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $exc_rlt_key = null;
    /**
     * Constructor method for ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_key()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_add_user()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_add_date()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_change_user()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_change_date()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_delete_flag()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_entity_key()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_key_ext()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_exh_key()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_cxa_key()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_cph_key()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_cfx_key()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_ind_cst_key()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_url_key()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_eml_key()
     * @uses ExhibitorNew_Exhibitor_X_Contact_DataObjectType::setExc_rlt_key()
     * @param string $exc_key
     * @param string $exc_add_user
     * @param string $exc_add_date
     * @param string $exc_change_user
     * @param string $exc_change_date
     * @param string $exc_delete_flag
     * @param string $exc_entity_key
     * @param string $exc_key_ext
     * @param string $exc_exh_key
     * @param string $exc_cxa_key
     * @param string $exc_cph_key
     * @param string $exc_cfx_key
     * @param string $exc_ind_cst_key
     * @param string $exc_url_key
     * @param string $exc_eml_key
     * @param string $exc_rlt_key
     */
    public function __construct(?string $exc_key = null, ?string $exc_add_user = null, ?string $exc_add_date = null, ?string $exc_change_user = null, ?string $exc_change_date = null, ?string $exc_delete_flag = null, ?string $exc_entity_key = null, ?string $exc_key_ext = null, ?string $exc_exh_key = null, ?string $exc_cxa_key = null, ?string $exc_cph_key = null, ?string $exc_cfx_key = null, ?string $exc_ind_cst_key = null, ?string $exc_url_key = null, ?string $exc_eml_key = null, ?string $exc_rlt_key = null)
    {
        $this
            ->setExc_key($exc_key)
            ->setExc_add_user($exc_add_user)
            ->setExc_add_date($exc_add_date)
            ->setExc_change_user($exc_change_user)
            ->setExc_change_date($exc_change_date)
            ->setExc_delete_flag($exc_delete_flag)
            ->setExc_entity_key($exc_entity_key)
            ->setExc_key_ext($exc_key_ext)
            ->setExc_exh_key($exc_exh_key)
            ->setExc_cxa_key($exc_cxa_key)
            ->setExc_cph_key($exc_cph_key)
            ->setExc_cfx_key($exc_cfx_key)
            ->setExc_ind_cst_key($exc_ind_cst_key)
            ->setExc_url_key($exc_url_key)
            ->setExc_eml_key($exc_eml_key)
            ->setExc_rlt_key($exc_rlt_key);
    }
    /**
     * Get exc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_key(): ?string
    {
        return $this->exc_key ?? null;
    }
    /**
     * Set exc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_key(?string $exc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_key) && !is_string($exc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_key, true), gettype($exc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_key, true)), __LINE__);
        }
        if (is_null($exc_key) || (is_array($exc_key) && empty($exc_key))) {
            unset($this->exc_key);
        } else {
            $this->exc_key = $exc_key;
        }
        
        return $this;
    }
    /**
     * Get exc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_add_user(): ?string
    {
        return $this->exc_add_user ?? null;
    }
    /**
     * Set exc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_add_user(?string $exc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_add_user) && !is_string($exc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_add_user, true), gettype($exc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($exc_add_user) && mb_strlen((string) $exc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $exc_add_user)), __LINE__);
        }
        if (is_null($exc_add_user) || (is_array($exc_add_user) && empty($exc_add_user))) {
            unset($this->exc_add_user);
        } else {
            $this->exc_add_user = $exc_add_user;
        }
        
        return $this;
    }
    /**
     * Get exc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_add_date(): ?string
    {
        return $this->exc_add_date ?? null;
    }
    /**
     * Set exc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_add_date(?string $exc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_add_date) && !is_string($exc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_add_date, true), gettype($exc_add_date)), __LINE__);
        }
        if (is_null($exc_add_date) || (is_array($exc_add_date) && empty($exc_add_date))) {
            unset($this->exc_add_date);
        } else {
            $this->exc_add_date = $exc_add_date;
        }
        
        return $this;
    }
    /**
     * Get exc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_change_user(): ?string
    {
        return $this->exc_change_user ?? null;
    }
    /**
     * Set exc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_change_user(?string $exc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_change_user) && !is_string($exc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_change_user, true), gettype($exc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($exc_change_user) && mb_strlen((string) $exc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $exc_change_user)), __LINE__);
        }
        if (is_null($exc_change_user) || (is_array($exc_change_user) && empty($exc_change_user))) {
            unset($this->exc_change_user);
        } else {
            $this->exc_change_user = $exc_change_user;
        }
        
        return $this;
    }
    /**
     * Get exc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_change_date(): ?string
    {
        return $this->exc_change_date ?? null;
    }
    /**
     * Set exc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_change_date(?string $exc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_change_date) && !is_string($exc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_change_date, true), gettype($exc_change_date)), __LINE__);
        }
        if (is_null($exc_change_date) || (is_array($exc_change_date) && empty($exc_change_date))) {
            unset($this->exc_change_date);
        } else {
            $this->exc_change_date = $exc_change_date;
        }
        
        return $this;
    }
    /**
     * Get exc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_delete_flag(): ?string
    {
        return $this->exc_delete_flag ?? null;
    }
    /**
     * Set exc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_delete_flag(?string $exc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_delete_flag) && !is_string($exc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_delete_flag, true), gettype($exc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($exc_delete_flag) && $exc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($exc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($exc_delete_flag) && $exc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($exc_delete_flag, true)), __LINE__);
        }
        if (is_null($exc_delete_flag) || (is_array($exc_delete_flag) && empty($exc_delete_flag))) {
            unset($this->exc_delete_flag);
        } else {
            $this->exc_delete_flag = $exc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get exc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_entity_key(): ?string
    {
        return $this->exc_entity_key ?? null;
    }
    /**
     * Set exc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_entity_key(?string $exc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_entity_key) && !is_string($exc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_entity_key, true), gettype($exc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_entity_key, true)), __LINE__);
        }
        if (is_null($exc_entity_key) || (is_array($exc_entity_key) && empty($exc_entity_key))) {
            unset($this->exc_entity_key);
        } else {
            $this->exc_entity_key = $exc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get exc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_key_ext(): ?string
    {
        return $this->exc_key_ext ?? null;
    }
    /**
     * Set exc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_key_ext(?string $exc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_key_ext) && !is_string($exc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_key_ext, true), gettype($exc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_key_ext, true)), __LINE__);
        }
        if (is_null($exc_key_ext) || (is_array($exc_key_ext) && empty($exc_key_ext))) {
            unset($this->exc_key_ext);
        } else {
            $this->exc_key_ext = $exc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get exc_exh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_exh_key(): ?string
    {
        return $this->exc_exh_key ?? null;
    }
    /**
     * Set exc_exh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_exh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_exh_key(?string $exc_exh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_exh_key) && !is_string($exc_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_exh_key, true), gettype($exc_exh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_exh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_exh_key, true)), __LINE__);
        }
        if (is_null($exc_exh_key) || (is_array($exc_exh_key) && empty($exc_exh_key))) {
            unset($this->exc_exh_key);
        } else {
            $this->exc_exh_key = $exc_exh_key;
        }
        
        return $this;
    }
    /**
     * Get exc_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_cxa_key(): ?string
    {
        return $this->exc_cxa_key ?? null;
    }
    /**
     * Set exc_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_cxa_key(?string $exc_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_cxa_key) && !is_string($exc_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_cxa_key, true), gettype($exc_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_cxa_key, true)), __LINE__);
        }
        if (is_null($exc_cxa_key) || (is_array($exc_cxa_key) && empty($exc_cxa_key))) {
            unset($this->exc_cxa_key);
        } else {
            $this->exc_cxa_key = $exc_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get exc_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_cph_key(): ?string
    {
        return $this->exc_cph_key ?? null;
    }
    /**
     * Set exc_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_cph_key(?string $exc_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_cph_key) && !is_string($exc_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_cph_key, true), gettype($exc_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_cph_key, true)), __LINE__);
        }
        if (is_null($exc_cph_key) || (is_array($exc_cph_key) && empty($exc_cph_key))) {
            unset($this->exc_cph_key);
        } else {
            $this->exc_cph_key = $exc_cph_key;
        }
        
        return $this;
    }
    /**
     * Get exc_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_cfx_key(): ?string
    {
        return $this->exc_cfx_key ?? null;
    }
    /**
     * Set exc_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_cfx_key(?string $exc_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_cfx_key) && !is_string($exc_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_cfx_key, true), gettype($exc_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_cfx_key, true)), __LINE__);
        }
        if (is_null($exc_cfx_key) || (is_array($exc_cfx_key) && empty($exc_cfx_key))) {
            unset($this->exc_cfx_key);
        } else {
            $this->exc_cfx_key = $exc_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get exc_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_ind_cst_key(): ?string
    {
        return $this->exc_ind_cst_key ?? null;
    }
    /**
     * Set exc_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_ind_cst_key(?string $exc_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_ind_cst_key) && !is_string($exc_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_ind_cst_key, true), gettype($exc_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_ind_cst_key, true)), __LINE__);
        }
        if (is_null($exc_ind_cst_key) || (is_array($exc_ind_cst_key) && empty($exc_ind_cst_key))) {
            unset($this->exc_ind_cst_key);
        } else {
            $this->exc_ind_cst_key = $exc_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get exc_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_url_key(): ?string
    {
        return $this->exc_url_key ?? null;
    }
    /**
     * Set exc_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_url_key(?string $exc_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_url_key) && !is_string($exc_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_url_key, true), gettype($exc_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_url_key, true)), __LINE__);
        }
        if (is_null($exc_url_key) || (is_array($exc_url_key) && empty($exc_url_key))) {
            unset($this->exc_url_key);
        } else {
            $this->exc_url_key = $exc_url_key;
        }
        
        return $this;
    }
    /**
     * Get exc_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_eml_key(): ?string
    {
        return $this->exc_eml_key ?? null;
    }
    /**
     * Set exc_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_eml_key(?string $exc_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_eml_key) && !is_string($exc_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_eml_key, true), gettype($exc_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_eml_key, true)), __LINE__);
        }
        if (is_null($exc_eml_key) || (is_array($exc_eml_key) && empty($exc_eml_key))) {
            unset($this->exc_eml_key);
        } else {
            $this->exc_eml_key = $exc_eml_key;
        }
        
        return $this;
    }
    /**
     * Get exc_rlt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExc_rlt_key(): ?string
    {
        return $this->exc_rlt_key ?? null;
    }
    /**
     * Set exc_rlt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exc_rlt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Exhibitor_X_Contact_DataObjectType
     */
    public function setExc_rlt_key(?string $exc_rlt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($exc_rlt_key) && !is_string($exc_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exc_rlt_key, true), gettype($exc_rlt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($exc_rlt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $exc_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($exc_rlt_key, true)), __LINE__);
        }
        if (is_null($exc_rlt_key) || (is_array($exc_rlt_key) && empty($exc_rlt_key))) {
            unset($this->exc_rlt_key);
        } else {
            $this->exc_rlt_key = $exc_rlt_key;
        }
        
        return $this;
    }
}
