<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_Shared_Booth_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_Shared_Booth_DataObjectType extends AbstractStructBase
{
    /**
     * The ebs_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebs_key = null;
    /**
     * The ebs_exb_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebs_exb_key = null;
    /**
     * The ebs_exh_key_parent
     * Meta information extracted from the WSDL
     * - documentation: Parent Exhibitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebs_exh_key_parent = null;
    /**
     * The ebs_hxb_key
     * Meta information extracted from the WSDL
     * - documentation: Booth. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebs_hxb_key = null;
    /**
     * The ebs_exh_key
     * Meta information extracted from the WSDL
     * - documentation: Exhibitor. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebs_exh_key = null;
    /**
     * The ebs_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebs_add_user = null;
    /**
     * The ebs_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebs_add_date = null;
    /**
     * The ebs_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebs_change_user = null;
    /**
     * The ebs_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebs_change_date = null;
    /**
     * The ebs_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebs_delete_flag = null;
    /**
     * The ebs_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebs_key_ext = null;
    /**
     * The ebs_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ebs_entity_key = null;
    /**
     * The ebs_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: cancel date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ebs_cancel_date = null;
    /**
     * Constructor method for ExhibitorNew_Shared_Booth_DataObjectType
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_key()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_exb_key()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_exh_key_parent()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_hxb_key()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_exh_key()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_add_user()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_add_date()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_change_user()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_change_date()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_delete_flag()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_key_ext()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_entity_key()
     * @uses ExhibitorNew_Shared_Booth_DataObjectType::setEbs_cancel_date()
     * @param string $ebs_key
     * @param string $ebs_exb_key
     * @param string $ebs_exh_key_parent
     * @param string $ebs_hxb_key
     * @param string $ebs_exh_key
     * @param string $ebs_add_user
     * @param string $ebs_add_date
     * @param string $ebs_change_user
     * @param string $ebs_change_date
     * @param string $ebs_delete_flag
     * @param string $ebs_key_ext
     * @param string $ebs_entity_key
     * @param string $ebs_cancel_date
     */
    public function __construct(?string $ebs_key = null, ?string $ebs_exb_key = null, ?string $ebs_exh_key_parent = null, ?string $ebs_hxb_key = null, ?string $ebs_exh_key = null, ?string $ebs_add_user = null, ?string $ebs_add_date = null, ?string $ebs_change_user = null, ?string $ebs_change_date = null, ?string $ebs_delete_flag = null, ?string $ebs_key_ext = null, ?string $ebs_entity_key = null, ?string $ebs_cancel_date = null)
    {
        $this
            ->setEbs_key($ebs_key)
            ->setEbs_exb_key($ebs_exb_key)
            ->setEbs_exh_key_parent($ebs_exh_key_parent)
            ->setEbs_hxb_key($ebs_hxb_key)
            ->setEbs_exh_key($ebs_exh_key)
            ->setEbs_add_user($ebs_add_user)
            ->setEbs_add_date($ebs_add_date)
            ->setEbs_change_user($ebs_change_user)
            ->setEbs_change_date($ebs_change_date)
            ->setEbs_delete_flag($ebs_delete_flag)
            ->setEbs_key_ext($ebs_key_ext)
            ->setEbs_entity_key($ebs_entity_key)
            ->setEbs_cancel_date($ebs_cancel_date);
    }
    /**
     * Get ebs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_key(): ?string
    {
        return $this->ebs_key ?? null;
    }
    /**
     * Set ebs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_key(?string $ebs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_key) && !is_string($ebs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_key, true), gettype($ebs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebs_key, true)), __LINE__);
        }
        if (is_null($ebs_key) || (is_array($ebs_key) && empty($ebs_key))) {
            unset($this->ebs_key);
        } else {
            $this->ebs_key = $ebs_key;
        }
        
        return $this;
    }
    /**
     * Get ebs_exb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_exb_key(): ?string
    {
        return $this->ebs_exb_key ?? null;
    }
    /**
     * Set ebs_exb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_exb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_exb_key(?string $ebs_exb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_exb_key) && !is_string($ebs_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_exb_key, true), gettype($ebs_exb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebs_exb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebs_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebs_exb_key, true)), __LINE__);
        }
        if (is_null($ebs_exb_key) || (is_array($ebs_exb_key) && empty($ebs_exb_key))) {
            unset($this->ebs_exb_key);
        } else {
            $this->ebs_exb_key = $ebs_exb_key;
        }
        
        return $this;
    }
    /**
     * Get ebs_exh_key_parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_exh_key_parent(): ?string
    {
        return $this->ebs_exh_key_parent ?? null;
    }
    /**
     * Set ebs_exh_key_parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_exh_key_parent
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_exh_key_parent(?string $ebs_exh_key_parent = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_exh_key_parent) && !is_string($ebs_exh_key_parent)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_exh_key_parent, true), gettype($ebs_exh_key_parent)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebs_exh_key_parent) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebs_exh_key_parent)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebs_exh_key_parent, true)), __LINE__);
        }
        if (is_null($ebs_exh_key_parent) || (is_array($ebs_exh_key_parent) && empty($ebs_exh_key_parent))) {
            unset($this->ebs_exh_key_parent);
        } else {
            $this->ebs_exh_key_parent = $ebs_exh_key_parent;
        }
        
        return $this;
    }
    /**
     * Get ebs_hxb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_hxb_key(): ?string
    {
        return $this->ebs_hxb_key ?? null;
    }
    /**
     * Set ebs_hxb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_hxb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_hxb_key(?string $ebs_hxb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_hxb_key) && !is_string($ebs_hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_hxb_key, true), gettype($ebs_hxb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebs_hxb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebs_hxb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebs_hxb_key, true)), __LINE__);
        }
        if (is_null($ebs_hxb_key) || (is_array($ebs_hxb_key) && empty($ebs_hxb_key))) {
            unset($this->ebs_hxb_key);
        } else {
            $this->ebs_hxb_key = $ebs_hxb_key;
        }
        
        return $this;
    }
    /**
     * Get ebs_exh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_exh_key(): ?string
    {
        return $this->ebs_exh_key ?? null;
    }
    /**
     * Set ebs_exh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_exh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_exh_key(?string $ebs_exh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_exh_key) && !is_string($ebs_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_exh_key, true), gettype($ebs_exh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebs_exh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebs_exh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebs_exh_key, true)), __LINE__);
        }
        if (is_null($ebs_exh_key) || (is_array($ebs_exh_key) && empty($ebs_exh_key))) {
            unset($this->ebs_exh_key);
        } else {
            $this->ebs_exh_key = $ebs_exh_key;
        }
        
        return $this;
    }
    /**
     * Get ebs_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_add_user(): ?string
    {
        return $this->ebs_add_user ?? null;
    }
    /**
     * Set ebs_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_add_user(?string $ebs_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_add_user) && !is_string($ebs_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_add_user, true), gettype($ebs_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ebs_add_user) && mb_strlen((string) $ebs_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ebs_add_user)), __LINE__);
        }
        if (is_null($ebs_add_user) || (is_array($ebs_add_user) && empty($ebs_add_user))) {
            unset($this->ebs_add_user);
        } else {
            $this->ebs_add_user = $ebs_add_user;
        }
        
        return $this;
    }
    /**
     * Get ebs_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_add_date(): ?string
    {
        return $this->ebs_add_date ?? null;
    }
    /**
     * Set ebs_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_add_date(?string $ebs_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_add_date) && !is_string($ebs_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_add_date, true), gettype($ebs_add_date)), __LINE__);
        }
        if (is_null($ebs_add_date) || (is_array($ebs_add_date) && empty($ebs_add_date))) {
            unset($this->ebs_add_date);
        } else {
            $this->ebs_add_date = $ebs_add_date;
        }
        
        return $this;
    }
    /**
     * Get ebs_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_change_user(): ?string
    {
        return $this->ebs_change_user ?? null;
    }
    /**
     * Set ebs_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_change_user(?string $ebs_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_change_user) && !is_string($ebs_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_change_user, true), gettype($ebs_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ebs_change_user) && mb_strlen((string) $ebs_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ebs_change_user)), __LINE__);
        }
        if (is_null($ebs_change_user) || (is_array($ebs_change_user) && empty($ebs_change_user))) {
            unset($this->ebs_change_user);
        } else {
            $this->ebs_change_user = $ebs_change_user;
        }
        
        return $this;
    }
    /**
     * Get ebs_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_change_date(): ?string
    {
        return $this->ebs_change_date ?? null;
    }
    /**
     * Set ebs_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_change_date(?string $ebs_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_change_date) && !is_string($ebs_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_change_date, true), gettype($ebs_change_date)), __LINE__);
        }
        if (is_null($ebs_change_date) || (is_array($ebs_change_date) && empty($ebs_change_date))) {
            unset($this->ebs_change_date);
        } else {
            $this->ebs_change_date = $ebs_change_date;
        }
        
        return $this;
    }
    /**
     * Get ebs_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_delete_flag(): ?string
    {
        return $this->ebs_delete_flag ?? null;
    }
    /**
     * Set ebs_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_delete_flag(?string $ebs_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_delete_flag) && !is_string($ebs_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_delete_flag, true), gettype($ebs_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ebs_delete_flag) && $ebs_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ebs_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ebs_delete_flag) && $ebs_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ebs_delete_flag, true)), __LINE__);
        }
        if (is_null($ebs_delete_flag) || (is_array($ebs_delete_flag) && empty($ebs_delete_flag))) {
            unset($this->ebs_delete_flag);
        } else {
            $this->ebs_delete_flag = $ebs_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ebs_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_key_ext(): ?string
    {
        return $this->ebs_key_ext ?? null;
    }
    /**
     * Set ebs_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_key_ext(?string $ebs_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_key_ext) && !is_string($ebs_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_key_ext, true), gettype($ebs_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebs_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebs_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebs_key_ext, true)), __LINE__);
        }
        if (is_null($ebs_key_ext) || (is_array($ebs_key_ext) && empty($ebs_key_ext))) {
            unset($this->ebs_key_ext);
        } else {
            $this->ebs_key_ext = $ebs_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ebs_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_entity_key(): ?string
    {
        return $this->ebs_entity_key ?? null;
    }
    /**
     * Set ebs_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_entity_key(?string $ebs_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_entity_key) && !is_string($ebs_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_entity_key, true), gettype($ebs_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ebs_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ebs_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ebs_entity_key, true)), __LINE__);
        }
        if (is_null($ebs_entity_key) || (is_array($ebs_entity_key) && empty($ebs_entity_key))) {
            unset($this->ebs_entity_key);
        } else {
            $this->ebs_entity_key = $ebs_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ebs_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEbs_cancel_date(): ?string
    {
        return $this->ebs_cancel_date ?? null;
    }
    /**
     * Set ebs_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ebs_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Shared_Booth_DataObjectType
     */
    public function setEbs_cancel_date(?string $ebs_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ebs_cancel_date) && !is_string($ebs_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ebs_cancel_date, true), gettype($ebs_cancel_date)), __LINE__);
        }
        if (is_null($ebs_cancel_date) || (is_array($ebs_cancel_date) && empty($ebs_cancel_date))) {
            unset($this->ebs_cancel_date);
        } else {
            $this->ebs_cancel_date = $ebs_cancel_date;
        }
        
        return $this;
    }
}
