<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExhibitorNew_Sponsor_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ExhibitorNew_Sponsor_DataObjectType extends AbstractStructBase
{
    /**
     * The spo_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_key = null;
    /**
     * The spo_cst_key
     * Meta information extracted from the WSDL
     * - documentation: customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_cst_key = null;
    /**
     * The spo_snt_key
     * Meta information extracted from the WSDL
     * - documentation: Sponsor Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_snt_key = null;
    /**
     * The spo_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_ind_cst_key = null;
    /**
     * The spo_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_cxa_key = null;
    /**
     * The spo_cph_key
     * Meta information extracted from the WSDL
     * - documentation: Phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_cph_key = null;
    /**
     * The spo_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_cfx_key = null;
    /**
     * The spo_eml_key
     * Meta information extracted from the WSDL
     * - documentation: Email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_eml_key = null;
    /**
     * The spo_url_key
     * Meta information extracted from the WSDL
     * - documentation: URL. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_url_key = null;
    /**
     * The spo_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $spo_add_user = null;
    /**
     * The spo_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $spo_add_date = null;
    /**
     * The spo_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $spo_change_user = null;
    /**
     * The spo_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $spo_change_date = null;
    /**
     * The spo_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $spo_delete_flag = null;
    /**
     * The spo_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_key_ext = null;
    /**
     * The spo_evt_key
     * Meta information extracted from the WSDL
     * - documentation: Event. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_evt_key = null;
    /**
     * The spo_ses_key
     * Meta information extracted from the WSDL
     * - documentation: Session. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_ses_key = null;
    /**
     * The spo_trk_key
     * Meta information extracted from the WSDL
     * - documentation: Track. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_trk_key = null;
    /**
     * The spo_fac_key
     * Meta information extracted from the WSDL
     * - documentation: Faculty. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_fac_key = null;
    /**
     * The spo_notes
     * Meta information extracted from the WSDL
     * - documentation: Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $spo_notes = null;
    /**
     * The spo_inv_code
     * Meta information extracted from the WSDL
     * - documentation: invoice code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $spo_inv_code = null;
    /**
     * The spo_logo_doc_key
     * Meta information extracted from the WSDL
     * - documentation: Logo. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_logo_doc_key = null;
    /**
     * The spo_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: invoice detail key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_ivd_key = null;
    /**
     * The spo_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_entity_key = null;
    /**
     * The spo_exb_key
     * Meta information extracted from the WSDL
     * - documentation: exhibit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_exb_key = null;
    /**
     * The spo_cancel_date
     * Meta information extracted from the WSDL
     * - documentation: Cancel Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $spo_cancel_date = null;
    /**
     * The spo_ord_code
     * Meta information extracted from the WSDL
     * - documentation: Order Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $spo_ord_code = null;
    /**
     * The spo_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $spo_odd_key = null;
    /**
     * Constructor method for ExhibitorNew_Sponsor_DataObjectType
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_cst_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_snt_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_ind_cst_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_cxa_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_cph_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_cfx_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_eml_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_url_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_add_user()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_add_date()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_change_user()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_change_date()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_delete_flag()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_key_ext()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_evt_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_ses_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_trk_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_fac_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_notes()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_inv_code()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_logo_doc_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_ivd_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_entity_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_exb_key()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_cancel_date()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_ord_code()
     * @uses ExhibitorNew_Sponsor_DataObjectType::setSpo_odd_key()
     * @param string $spo_key
     * @param string $spo_cst_key
     * @param string $spo_snt_key
     * @param string $spo_ind_cst_key
     * @param string $spo_cxa_key
     * @param string $spo_cph_key
     * @param string $spo_cfx_key
     * @param string $spo_eml_key
     * @param string $spo_url_key
     * @param string $spo_add_user
     * @param string $spo_add_date
     * @param string $spo_change_user
     * @param string $spo_change_date
     * @param string $spo_delete_flag
     * @param string $spo_key_ext
     * @param string $spo_evt_key
     * @param string $spo_ses_key
     * @param string $spo_trk_key
     * @param string $spo_fac_key
     * @param string $spo_notes
     * @param string $spo_inv_code
     * @param string $spo_logo_doc_key
     * @param string $spo_ivd_key
     * @param string $spo_entity_key
     * @param string $spo_exb_key
     * @param string $spo_cancel_date
     * @param string $spo_ord_code
     * @param string $spo_odd_key
     */
    public function __construct(?string $spo_key = null, ?string $spo_cst_key = null, ?string $spo_snt_key = null, ?string $spo_ind_cst_key = null, ?string $spo_cxa_key = null, ?string $spo_cph_key = null, ?string $spo_cfx_key = null, ?string $spo_eml_key = null, ?string $spo_url_key = null, ?string $spo_add_user = null, ?string $spo_add_date = null, ?string $spo_change_user = null, ?string $spo_change_date = null, ?string $spo_delete_flag = null, ?string $spo_key_ext = null, ?string $spo_evt_key = null, ?string $spo_ses_key = null, ?string $spo_trk_key = null, ?string $spo_fac_key = null, ?string $spo_notes = null, ?string $spo_inv_code = null, ?string $spo_logo_doc_key = null, ?string $spo_ivd_key = null, ?string $spo_entity_key = null, ?string $spo_exb_key = null, ?string $spo_cancel_date = null, ?string $spo_ord_code = null, ?string $spo_odd_key = null)
    {
        $this
            ->setSpo_key($spo_key)
            ->setSpo_cst_key($spo_cst_key)
            ->setSpo_snt_key($spo_snt_key)
            ->setSpo_ind_cst_key($spo_ind_cst_key)
            ->setSpo_cxa_key($spo_cxa_key)
            ->setSpo_cph_key($spo_cph_key)
            ->setSpo_cfx_key($spo_cfx_key)
            ->setSpo_eml_key($spo_eml_key)
            ->setSpo_url_key($spo_url_key)
            ->setSpo_add_user($spo_add_user)
            ->setSpo_add_date($spo_add_date)
            ->setSpo_change_user($spo_change_user)
            ->setSpo_change_date($spo_change_date)
            ->setSpo_delete_flag($spo_delete_flag)
            ->setSpo_key_ext($spo_key_ext)
            ->setSpo_evt_key($spo_evt_key)
            ->setSpo_ses_key($spo_ses_key)
            ->setSpo_trk_key($spo_trk_key)
            ->setSpo_fac_key($spo_fac_key)
            ->setSpo_notes($spo_notes)
            ->setSpo_inv_code($spo_inv_code)
            ->setSpo_logo_doc_key($spo_logo_doc_key)
            ->setSpo_ivd_key($spo_ivd_key)
            ->setSpo_entity_key($spo_entity_key)
            ->setSpo_exb_key($spo_exb_key)
            ->setSpo_cancel_date($spo_cancel_date)
            ->setSpo_ord_code($spo_ord_code)
            ->setSpo_odd_key($spo_odd_key);
    }
    /**
     * Get spo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_key(): ?string
    {
        return $this->spo_key ?? null;
    }
    /**
     * Set spo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_key(?string $spo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_key) && !is_string($spo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_key, true), gettype($spo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_key, true)), __LINE__);
        }
        if (is_null($spo_key) || (is_array($spo_key) && empty($spo_key))) {
            unset($this->spo_key);
        } else {
            $this->spo_key = $spo_key;
        }
        
        return $this;
    }
    /**
     * Get spo_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_cst_key(): ?string
    {
        return $this->spo_cst_key ?? null;
    }
    /**
     * Set spo_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_cst_key(?string $spo_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_cst_key) && !is_string($spo_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_cst_key, true), gettype($spo_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_cst_key, true)), __LINE__);
        }
        if (is_null($spo_cst_key) || (is_array($spo_cst_key) && empty($spo_cst_key))) {
            unset($this->spo_cst_key);
        } else {
            $this->spo_cst_key = $spo_cst_key;
        }
        
        return $this;
    }
    /**
     * Get spo_snt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_snt_key(): ?string
    {
        return $this->spo_snt_key ?? null;
    }
    /**
     * Set spo_snt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_snt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_snt_key(?string $spo_snt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_snt_key) && !is_string($spo_snt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_snt_key, true), gettype($spo_snt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_snt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_snt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_snt_key, true)), __LINE__);
        }
        if (is_null($spo_snt_key) || (is_array($spo_snt_key) && empty($spo_snt_key))) {
            unset($this->spo_snt_key);
        } else {
            $this->spo_snt_key = $spo_snt_key;
        }
        
        return $this;
    }
    /**
     * Get spo_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_ind_cst_key(): ?string
    {
        return $this->spo_ind_cst_key ?? null;
    }
    /**
     * Set spo_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_ind_cst_key(?string $spo_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_ind_cst_key) && !is_string($spo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_ind_cst_key, true), gettype($spo_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_ind_cst_key, true)), __LINE__);
        }
        if (is_null($spo_ind_cst_key) || (is_array($spo_ind_cst_key) && empty($spo_ind_cst_key))) {
            unset($this->spo_ind_cst_key);
        } else {
            $this->spo_ind_cst_key = $spo_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get spo_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_cxa_key(): ?string
    {
        return $this->spo_cxa_key ?? null;
    }
    /**
     * Set spo_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_cxa_key(?string $spo_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_cxa_key) && !is_string($spo_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_cxa_key, true), gettype($spo_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_cxa_key, true)), __LINE__);
        }
        if (is_null($spo_cxa_key) || (is_array($spo_cxa_key) && empty($spo_cxa_key))) {
            unset($this->spo_cxa_key);
        } else {
            $this->spo_cxa_key = $spo_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get spo_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_cph_key(): ?string
    {
        return $this->spo_cph_key ?? null;
    }
    /**
     * Set spo_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_cph_key(?string $spo_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_cph_key) && !is_string($spo_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_cph_key, true), gettype($spo_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_cph_key, true)), __LINE__);
        }
        if (is_null($spo_cph_key) || (is_array($spo_cph_key) && empty($spo_cph_key))) {
            unset($this->spo_cph_key);
        } else {
            $this->spo_cph_key = $spo_cph_key;
        }
        
        return $this;
    }
    /**
     * Get spo_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_cfx_key(): ?string
    {
        return $this->spo_cfx_key ?? null;
    }
    /**
     * Set spo_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_cfx_key(?string $spo_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_cfx_key) && !is_string($spo_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_cfx_key, true), gettype($spo_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_cfx_key, true)), __LINE__);
        }
        if (is_null($spo_cfx_key) || (is_array($spo_cfx_key) && empty($spo_cfx_key))) {
            unset($this->spo_cfx_key);
        } else {
            $this->spo_cfx_key = $spo_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get spo_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_eml_key(): ?string
    {
        return $this->spo_eml_key ?? null;
    }
    /**
     * Set spo_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_eml_key(?string $spo_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_eml_key) && !is_string($spo_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_eml_key, true), gettype($spo_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_eml_key, true)), __LINE__);
        }
        if (is_null($spo_eml_key) || (is_array($spo_eml_key) && empty($spo_eml_key))) {
            unset($this->spo_eml_key);
        } else {
            $this->spo_eml_key = $spo_eml_key;
        }
        
        return $this;
    }
    /**
     * Get spo_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_url_key(): ?string
    {
        return $this->spo_url_key ?? null;
    }
    /**
     * Set spo_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_url_key(?string $spo_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_url_key) && !is_string($spo_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_url_key, true), gettype($spo_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_url_key, true)), __LINE__);
        }
        if (is_null($spo_url_key) || (is_array($spo_url_key) && empty($spo_url_key))) {
            unset($this->spo_url_key);
        } else {
            $this->spo_url_key = $spo_url_key;
        }
        
        return $this;
    }
    /**
     * Get spo_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_add_user(): ?string
    {
        return $this->spo_add_user ?? null;
    }
    /**
     * Set spo_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_add_user(?string $spo_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_add_user) && !is_string($spo_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_add_user, true), gettype($spo_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($spo_add_user) && mb_strlen((string) $spo_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $spo_add_user)), __LINE__);
        }
        if (is_null($spo_add_user) || (is_array($spo_add_user) && empty($spo_add_user))) {
            unset($this->spo_add_user);
        } else {
            $this->spo_add_user = $spo_add_user;
        }
        
        return $this;
    }
    /**
     * Get spo_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_add_date(): ?string
    {
        return $this->spo_add_date ?? null;
    }
    /**
     * Set spo_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_add_date(?string $spo_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_add_date) && !is_string($spo_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_add_date, true), gettype($spo_add_date)), __LINE__);
        }
        if (is_null($spo_add_date) || (is_array($spo_add_date) && empty($spo_add_date))) {
            unset($this->spo_add_date);
        } else {
            $this->spo_add_date = $spo_add_date;
        }
        
        return $this;
    }
    /**
     * Get spo_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_change_user(): ?string
    {
        return $this->spo_change_user ?? null;
    }
    /**
     * Set spo_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_change_user(?string $spo_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_change_user) && !is_string($spo_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_change_user, true), gettype($spo_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($spo_change_user) && mb_strlen((string) $spo_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $spo_change_user)), __LINE__);
        }
        if (is_null($spo_change_user) || (is_array($spo_change_user) && empty($spo_change_user))) {
            unset($this->spo_change_user);
        } else {
            $this->spo_change_user = $spo_change_user;
        }
        
        return $this;
    }
    /**
     * Get spo_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_change_date(): ?string
    {
        return $this->spo_change_date ?? null;
    }
    /**
     * Set spo_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_change_date(?string $spo_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_change_date) && !is_string($spo_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_change_date, true), gettype($spo_change_date)), __LINE__);
        }
        if (is_null($spo_change_date) || (is_array($spo_change_date) && empty($spo_change_date))) {
            unset($this->spo_change_date);
        } else {
            $this->spo_change_date = $spo_change_date;
        }
        
        return $this;
    }
    /**
     * Get spo_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_delete_flag(): ?string
    {
        return $this->spo_delete_flag ?? null;
    }
    /**
     * Set spo_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_delete_flag(?string $spo_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_delete_flag) && !is_string($spo_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_delete_flag, true), gettype($spo_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($spo_delete_flag) && $spo_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($spo_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($spo_delete_flag) && $spo_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($spo_delete_flag, true)), __LINE__);
        }
        if (is_null($spo_delete_flag) || (is_array($spo_delete_flag) && empty($spo_delete_flag))) {
            unset($this->spo_delete_flag);
        } else {
            $this->spo_delete_flag = $spo_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get spo_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_key_ext(): ?string
    {
        return $this->spo_key_ext ?? null;
    }
    /**
     * Set spo_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_key_ext(?string $spo_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_key_ext) && !is_string($spo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_key_ext, true), gettype($spo_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_key_ext, true)), __LINE__);
        }
        if (is_null($spo_key_ext) || (is_array($spo_key_ext) && empty($spo_key_ext))) {
            unset($this->spo_key_ext);
        } else {
            $this->spo_key_ext = $spo_key_ext;
        }
        
        return $this;
    }
    /**
     * Get spo_evt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_evt_key(): ?string
    {
        return $this->spo_evt_key ?? null;
    }
    /**
     * Set spo_evt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_evt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_evt_key(?string $spo_evt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_evt_key) && !is_string($spo_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_evt_key, true), gettype($spo_evt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_evt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_evt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_evt_key, true)), __LINE__);
        }
        if (is_null($spo_evt_key) || (is_array($spo_evt_key) && empty($spo_evt_key))) {
            unset($this->spo_evt_key);
        } else {
            $this->spo_evt_key = $spo_evt_key;
        }
        
        return $this;
    }
    /**
     * Get spo_ses_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_ses_key(): ?string
    {
        return $this->spo_ses_key ?? null;
    }
    /**
     * Set spo_ses_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_ses_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_ses_key(?string $spo_ses_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_ses_key) && !is_string($spo_ses_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_ses_key, true), gettype($spo_ses_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_ses_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_ses_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_ses_key, true)), __LINE__);
        }
        if (is_null($spo_ses_key) || (is_array($spo_ses_key) && empty($spo_ses_key))) {
            unset($this->spo_ses_key);
        } else {
            $this->spo_ses_key = $spo_ses_key;
        }
        
        return $this;
    }
    /**
     * Get spo_trk_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_trk_key(): ?string
    {
        return $this->spo_trk_key ?? null;
    }
    /**
     * Set spo_trk_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_trk_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_trk_key(?string $spo_trk_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_trk_key) && !is_string($spo_trk_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_trk_key, true), gettype($spo_trk_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_trk_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_trk_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_trk_key, true)), __LINE__);
        }
        if (is_null($spo_trk_key) || (is_array($spo_trk_key) && empty($spo_trk_key))) {
            unset($this->spo_trk_key);
        } else {
            $this->spo_trk_key = $spo_trk_key;
        }
        
        return $this;
    }
    /**
     * Get spo_fac_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_fac_key(): ?string
    {
        return $this->spo_fac_key ?? null;
    }
    /**
     * Set spo_fac_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_fac_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_fac_key(?string $spo_fac_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_fac_key) && !is_string($spo_fac_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_fac_key, true), gettype($spo_fac_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_fac_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_fac_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_fac_key, true)), __LINE__);
        }
        if (is_null($spo_fac_key) || (is_array($spo_fac_key) && empty($spo_fac_key))) {
            unset($this->spo_fac_key);
        } else {
            $this->spo_fac_key = $spo_fac_key;
        }
        
        return $this;
    }
    /**
     * Get spo_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_notes(): ?string
    {
        return $this->spo_notes ?? null;
    }
    /**
     * Set spo_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_notes(?string $spo_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_notes) && !is_string($spo_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_notes, true), gettype($spo_notes)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($spo_notes) && mb_strlen((string) $spo_notes) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $spo_notes)), __LINE__);
        }
        if (is_null($spo_notes) || (is_array($spo_notes) && empty($spo_notes))) {
            unset($this->spo_notes);
        } else {
            $this->spo_notes = $spo_notes;
        }
        
        return $this;
    }
    /**
     * Get spo_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_inv_code(): ?string
    {
        return $this->spo_inv_code ?? null;
    }
    /**
     * Set spo_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_inv_code(?string $spo_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_inv_code) && !is_string($spo_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_inv_code, true), gettype($spo_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($spo_inv_code) && mb_strlen((string) $spo_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $spo_inv_code)), __LINE__);
        }
        if (is_null($spo_inv_code) || (is_array($spo_inv_code) && empty($spo_inv_code))) {
            unset($this->spo_inv_code);
        } else {
            $this->spo_inv_code = $spo_inv_code;
        }
        
        return $this;
    }
    /**
     * Get spo_logo_doc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_logo_doc_key(): ?string
    {
        return $this->spo_logo_doc_key ?? null;
    }
    /**
     * Set spo_logo_doc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_logo_doc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_logo_doc_key(?string $spo_logo_doc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_logo_doc_key) && !is_string($spo_logo_doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_logo_doc_key, true), gettype($spo_logo_doc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_logo_doc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_logo_doc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_logo_doc_key, true)), __LINE__);
        }
        if (is_null($spo_logo_doc_key) || (is_array($spo_logo_doc_key) && empty($spo_logo_doc_key))) {
            unset($this->spo_logo_doc_key);
        } else {
            $this->spo_logo_doc_key = $spo_logo_doc_key;
        }
        
        return $this;
    }
    /**
     * Get spo_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_ivd_key(): ?string
    {
        return $this->spo_ivd_key ?? null;
    }
    /**
     * Set spo_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_ivd_key(?string $spo_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_ivd_key) && !is_string($spo_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_ivd_key, true), gettype($spo_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_ivd_key, true)), __LINE__);
        }
        if (is_null($spo_ivd_key) || (is_array($spo_ivd_key) && empty($spo_ivd_key))) {
            unset($this->spo_ivd_key);
        } else {
            $this->spo_ivd_key = $spo_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get spo_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_entity_key(): ?string
    {
        return $this->spo_entity_key ?? null;
    }
    /**
     * Set spo_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_entity_key(?string $spo_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_entity_key) && !is_string($spo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_entity_key, true), gettype($spo_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_entity_key, true)), __LINE__);
        }
        if (is_null($spo_entity_key) || (is_array($spo_entity_key) && empty($spo_entity_key))) {
            unset($this->spo_entity_key);
        } else {
            $this->spo_entity_key = $spo_entity_key;
        }
        
        return $this;
    }
    /**
     * Get spo_exb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_exb_key(): ?string
    {
        return $this->spo_exb_key ?? null;
    }
    /**
     * Set spo_exb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_exb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_exb_key(?string $spo_exb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_exb_key) && !is_string($spo_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_exb_key, true), gettype($spo_exb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_exb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_exb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_exb_key, true)), __LINE__);
        }
        if (is_null($spo_exb_key) || (is_array($spo_exb_key) && empty($spo_exb_key))) {
            unset($this->spo_exb_key);
        } else {
            $this->spo_exb_key = $spo_exb_key;
        }
        
        return $this;
    }
    /**
     * Get spo_cancel_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_cancel_date(): ?string
    {
        return $this->spo_cancel_date ?? null;
    }
    /**
     * Set spo_cancel_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_cancel_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_cancel_date(?string $spo_cancel_date = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_cancel_date) && !is_string($spo_cancel_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_cancel_date, true), gettype($spo_cancel_date)), __LINE__);
        }
        if (is_null($spo_cancel_date) || (is_array($spo_cancel_date) && empty($spo_cancel_date))) {
            unset($this->spo_cancel_date);
        } else {
            $this->spo_cancel_date = $spo_cancel_date;
        }
        
        return $this;
    }
    /**
     * Get spo_ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_ord_code(): ?string
    {
        return $this->spo_ord_code ?? null;
    }
    /**
     * Set spo_ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_ord_code(?string $spo_ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_ord_code) && !is_string($spo_ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_ord_code, true), gettype($spo_ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($spo_ord_code) && mb_strlen((string) $spo_ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $spo_ord_code)), __LINE__);
        }
        if (is_null($spo_ord_code) || (is_array($spo_ord_code) && empty($spo_ord_code))) {
            unset($this->spo_ord_code);
        } else {
            $this->spo_ord_code = $spo_ord_code;
        }
        
        return $this;
    }
    /**
     * Get spo_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpo_odd_key(): ?string
    {
        return $this->spo_odd_key ?? null;
    }
    /**
     * Set spo_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spo_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNew_Sponsor_DataObjectType
     */
    public function setSpo_odd_key(?string $spo_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($spo_odd_key) && !is_string($spo_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spo_odd_key, true), gettype($spo_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($spo_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $spo_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($spo_odd_key, true)), __LINE__);
        }
        if (is_null($spo_odd_key) || (is_array($spo_odd_key) && empty($spo_odd_key))) {
            unset($this->spo_odd_key);
        } else {
            $this->spo_odd_key = $spo_odd_key;
        }
        
        return $this;
    }
}
