<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Appeal_Code_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Appeal_Code_DataObjectType extends AbstractStructBase
{
    /**
     * The apl_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apl_key = null;
    /**
     * The apl_code
     * Meta information extracted from the WSDL
     * - documentation: Appeal Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_code = null;
    /**
     * The apl_description
     * Meta information extracted from the WSDL
     * - documentation: Appeal Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_description = null;
    /**
     * The apl_start_date
     * Meta information extracted from the WSDL
     * - documentation: Appeal Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_start_date = null;
    /**
     * The apl_end_date
     * Meta information extracted from the WSDL
     * - documentation: Appeal End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_end_date = null;
    /**
     * The apl_goal
     * Meta information extracted from the WSDL
     * - documentation: Appeal Goal. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $apl_goal = null;
    /**
     * The apl_notes
     * Meta information extracted from the WSDL
     * - documentation: Appeal Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_notes = null;
    /**
     * The apl_active_flag
     * Meta information extracted from the WSDL
     * - documentation: Appeal Active Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_active_flag = null;
    /**
     * The apl_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_add_user = null;
    /**
     * The apl_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_add_date = null;
    /**
     * The apl_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_change_user = null;
    /**
     * The apl_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_change_date = null;
    /**
     * The apl_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $apl_delete_flag = null;
    /**
     * The apl_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apl_entity_key = null;
    /**
     * The apl_raised
     * Meta information extracted from the WSDL
     * - documentation: Funds Raised. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $apl_raised = null;
    /**
     * The apl_pledged
     * Meta information extracted from the WSDL
     * - documentation: Funds Pledged. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $apl_pledged = null;
    /**
     * The apl_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apl_key_ext = null;
    /**
     * The apl_cmp_key
     * Meta information extracted from the WSDL
     * - documentation: Campaign Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apl_cmp_key = null;
    /**
     * The apl_act_key
     * Meta information extracted from the WSDL
     * - documentation: Call to Action. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apl_act_key = null;
    /**
     * The apl_apc_key
     * Meta information extracted from the WSDL
     * - documentation: Appeal Channel Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $apl_apc_key = null;
    /**
     * Constructor method for FundraisingGift_Appeal_Code_DataObjectType
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_key()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_code()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_description()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_start_date()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_end_date()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_goal()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_notes()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_active_flag()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_add_user()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_add_date()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_change_user()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_change_date()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_delete_flag()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_entity_key()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_raised()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_pledged()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_key_ext()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_cmp_key()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_act_key()
     * @uses FundraisingGift_Appeal_Code_DataObjectType::setApl_apc_key()
     * @param string $apl_key
     * @param string $apl_code
     * @param string $apl_description
     * @param string $apl_start_date
     * @param string $apl_end_date
     * @param float $apl_goal
     * @param string $apl_notes
     * @param string $apl_active_flag
     * @param string $apl_add_user
     * @param string $apl_add_date
     * @param string $apl_change_user
     * @param string $apl_change_date
     * @param string $apl_delete_flag
     * @param string $apl_entity_key
     * @param float $apl_raised
     * @param float $apl_pledged
     * @param string $apl_key_ext
     * @param string $apl_cmp_key
     * @param string $apl_act_key
     * @param string $apl_apc_key
     */
    public function __construct(?string $apl_key = null, ?string $apl_code = null, ?string $apl_description = null, ?string $apl_start_date = null, ?string $apl_end_date = null, ?float $apl_goal = null, ?string $apl_notes = null, ?string $apl_active_flag = null, ?string $apl_add_user = null, ?string $apl_add_date = null, ?string $apl_change_user = null, ?string $apl_change_date = null, ?string $apl_delete_flag = null, ?string $apl_entity_key = null, ?float $apl_raised = null, ?float $apl_pledged = null, ?string $apl_key_ext = null, ?string $apl_cmp_key = null, ?string $apl_act_key = null, ?string $apl_apc_key = null)
    {
        $this
            ->setApl_key($apl_key)
            ->setApl_code($apl_code)
            ->setApl_description($apl_description)
            ->setApl_start_date($apl_start_date)
            ->setApl_end_date($apl_end_date)
            ->setApl_goal($apl_goal)
            ->setApl_notes($apl_notes)
            ->setApl_active_flag($apl_active_flag)
            ->setApl_add_user($apl_add_user)
            ->setApl_add_date($apl_add_date)
            ->setApl_change_user($apl_change_user)
            ->setApl_change_date($apl_change_date)
            ->setApl_delete_flag($apl_delete_flag)
            ->setApl_entity_key($apl_entity_key)
            ->setApl_raised($apl_raised)
            ->setApl_pledged($apl_pledged)
            ->setApl_key_ext($apl_key_ext)
            ->setApl_cmp_key($apl_cmp_key)
            ->setApl_act_key($apl_act_key)
            ->setApl_apc_key($apl_apc_key);
    }
    /**
     * Get apl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_key(): ?string
    {
        return $this->apl_key ?? null;
    }
    /**
     * Set apl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_key(?string $apl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_key) && !is_string($apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_key, true), gettype($apl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apl_key, true)), __LINE__);
        }
        if (is_null($apl_key) || (is_array($apl_key) && empty($apl_key))) {
            unset($this->apl_key);
        } else {
            $this->apl_key = $apl_key;
        }
        
        return $this;
    }
    /**
     * Get apl_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_code(): ?string
    {
        return $this->apl_code ?? null;
    }
    /**
     * Set apl_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_code(?string $apl_code = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_code) && !is_string($apl_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_code, true), gettype($apl_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($apl_code) && mb_strlen((string) $apl_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $apl_code)), __LINE__);
        }
        if (is_null($apl_code) || (is_array($apl_code) && empty($apl_code))) {
            unset($this->apl_code);
        } else {
            $this->apl_code = $apl_code;
        }
        
        return $this;
    }
    /**
     * Get apl_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_description(): ?string
    {
        return $this->apl_description ?? null;
    }
    /**
     * Set apl_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_description(?string $apl_description = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_description) && !is_string($apl_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_description, true), gettype($apl_description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($apl_description) && mb_strlen((string) $apl_description) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $apl_description)), __LINE__);
        }
        if (is_null($apl_description) || (is_array($apl_description) && empty($apl_description))) {
            unset($this->apl_description);
        } else {
            $this->apl_description = $apl_description;
        }
        
        return $this;
    }
    /**
     * Get apl_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_start_date(): ?string
    {
        return $this->apl_start_date ?? null;
    }
    /**
     * Set apl_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_start_date(?string $apl_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_start_date) && !is_string($apl_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_start_date, true), gettype($apl_start_date)), __LINE__);
        }
        if (is_null($apl_start_date) || (is_array($apl_start_date) && empty($apl_start_date))) {
            unset($this->apl_start_date);
        } else {
            $this->apl_start_date = $apl_start_date;
        }
        
        return $this;
    }
    /**
     * Get apl_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_end_date(): ?string
    {
        return $this->apl_end_date ?? null;
    }
    /**
     * Set apl_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_end_date(?string $apl_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_end_date) && !is_string($apl_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_end_date, true), gettype($apl_end_date)), __LINE__);
        }
        if (is_null($apl_end_date) || (is_array($apl_end_date) && empty($apl_end_date))) {
            unset($this->apl_end_date);
        } else {
            $this->apl_end_date = $apl_end_date;
        }
        
        return $this;
    }
    /**
     * Get apl_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getApl_goal(): ?float
    {
        return $this->apl_goal ?? null;
    }
    /**
     * Set apl_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $apl_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_goal(?float $apl_goal = null): self
    {
        // validation for constraint: float
        if (!is_null($apl_goal) && !(is_float($apl_goal) || is_numeric($apl_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($apl_goal, true), gettype($apl_goal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($apl_goal) && mb_strlen(mb_substr((string) $apl_goal, false !== mb_strpos((string) $apl_goal, '.') ? mb_strpos((string) $apl_goal, '.') + 1 : mb_strlen((string) $apl_goal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($apl_goal, true), mb_strlen(mb_substr((string) $apl_goal, mb_strpos((string) $apl_goal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($apl_goal) && mb_strlen(preg_replace('/(\D)/', '', (string) $apl_goal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($apl_goal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $apl_goal))), __LINE__);
        }
        if (is_null($apl_goal) || (is_array($apl_goal) && empty($apl_goal))) {
            unset($this->apl_goal);
        } else {
            $this->apl_goal = $apl_goal;
        }
        
        return $this;
    }
    /**
     * Get apl_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_notes(): ?string
    {
        return $this->apl_notes ?? null;
    }
    /**
     * Set apl_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_notes(?string $apl_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_notes) && !is_string($apl_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_notes, true), gettype($apl_notes)), __LINE__);
        }
        if (is_null($apl_notes) || (is_array($apl_notes) && empty($apl_notes))) {
            unset($this->apl_notes);
        } else {
            $this->apl_notes = $apl_notes;
        }
        
        return $this;
    }
    /**
     * Get apl_active_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_active_flag(): ?string
    {
        return $this->apl_active_flag ?? null;
    }
    /**
     * Set apl_active_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_active_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_active_flag(?string $apl_active_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_active_flag) && !is_string($apl_active_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_active_flag, true), gettype($apl_active_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($apl_active_flag) && $apl_active_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($apl_active_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($apl_active_flag) && $apl_active_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($apl_active_flag, true)), __LINE__);
        }
        if (is_null($apl_active_flag) || (is_array($apl_active_flag) && empty($apl_active_flag))) {
            unset($this->apl_active_flag);
        } else {
            $this->apl_active_flag = $apl_active_flag;
        }
        
        return $this;
    }
    /**
     * Get apl_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_add_user(): ?string
    {
        return $this->apl_add_user ?? null;
    }
    /**
     * Set apl_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_add_user(?string $apl_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_add_user) && !is_string($apl_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_add_user, true), gettype($apl_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($apl_add_user) && mb_strlen((string) $apl_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $apl_add_user)), __LINE__);
        }
        if (is_null($apl_add_user) || (is_array($apl_add_user) && empty($apl_add_user))) {
            unset($this->apl_add_user);
        } else {
            $this->apl_add_user = $apl_add_user;
        }
        
        return $this;
    }
    /**
     * Get apl_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_add_date(): ?string
    {
        return $this->apl_add_date ?? null;
    }
    /**
     * Set apl_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_add_date(?string $apl_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_add_date) && !is_string($apl_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_add_date, true), gettype($apl_add_date)), __LINE__);
        }
        if (is_null($apl_add_date) || (is_array($apl_add_date) && empty($apl_add_date))) {
            unset($this->apl_add_date);
        } else {
            $this->apl_add_date = $apl_add_date;
        }
        
        return $this;
    }
    /**
     * Get apl_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_change_user(): ?string
    {
        return $this->apl_change_user ?? null;
    }
    /**
     * Set apl_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_change_user(?string $apl_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_change_user) && !is_string($apl_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_change_user, true), gettype($apl_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($apl_change_user) && mb_strlen((string) $apl_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $apl_change_user)), __LINE__);
        }
        if (is_null($apl_change_user) || (is_array($apl_change_user) && empty($apl_change_user))) {
            unset($this->apl_change_user);
        } else {
            $this->apl_change_user = $apl_change_user;
        }
        
        return $this;
    }
    /**
     * Get apl_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_change_date(): ?string
    {
        return $this->apl_change_date ?? null;
    }
    /**
     * Set apl_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_change_date(?string $apl_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_change_date) && !is_string($apl_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_change_date, true), gettype($apl_change_date)), __LINE__);
        }
        if (is_null($apl_change_date) || (is_array($apl_change_date) && empty($apl_change_date))) {
            unset($this->apl_change_date);
        } else {
            $this->apl_change_date = $apl_change_date;
        }
        
        return $this;
    }
    /**
     * Get apl_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_delete_flag(): ?string
    {
        return $this->apl_delete_flag ?? null;
    }
    /**
     * Set apl_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_delete_flag(?string $apl_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_delete_flag) && !is_string($apl_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_delete_flag, true), gettype($apl_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($apl_delete_flag) && $apl_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($apl_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($apl_delete_flag) && $apl_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($apl_delete_flag, true)), __LINE__);
        }
        if (is_null($apl_delete_flag) || (is_array($apl_delete_flag) && empty($apl_delete_flag))) {
            unset($this->apl_delete_flag);
        } else {
            $this->apl_delete_flag = $apl_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get apl_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_entity_key(): ?string
    {
        return $this->apl_entity_key ?? null;
    }
    /**
     * Set apl_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_entity_key(?string $apl_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_entity_key) && !is_string($apl_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_entity_key, true), gettype($apl_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apl_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apl_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apl_entity_key, true)), __LINE__);
        }
        if (is_null($apl_entity_key) || (is_array($apl_entity_key) && empty($apl_entity_key))) {
            unset($this->apl_entity_key);
        } else {
            $this->apl_entity_key = $apl_entity_key;
        }
        
        return $this;
    }
    /**
     * Get apl_raised value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getApl_raised(): ?float
    {
        return $this->apl_raised ?? null;
    }
    /**
     * Set apl_raised value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $apl_raised
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_raised(?float $apl_raised = null): self
    {
        // validation for constraint: float
        if (!is_null($apl_raised) && !(is_float($apl_raised) || is_numeric($apl_raised))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($apl_raised, true), gettype($apl_raised)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($apl_raised) && mb_strlen(mb_substr((string) $apl_raised, false !== mb_strpos((string) $apl_raised, '.') ? mb_strpos((string) $apl_raised, '.') + 1 : mb_strlen((string) $apl_raised))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($apl_raised, true), mb_strlen(mb_substr((string) $apl_raised, mb_strpos((string) $apl_raised, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($apl_raised) && mb_strlen(preg_replace('/(\D)/', '', (string) $apl_raised)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($apl_raised, true), mb_strlen(preg_replace('/(\D)/', '', (string) $apl_raised))), __LINE__);
        }
        if (is_null($apl_raised) || (is_array($apl_raised) && empty($apl_raised))) {
            unset($this->apl_raised);
        } else {
            $this->apl_raised = $apl_raised;
        }
        
        return $this;
    }
    /**
     * Get apl_pledged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getApl_pledged(): ?float
    {
        return $this->apl_pledged ?? null;
    }
    /**
     * Set apl_pledged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $apl_pledged
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_pledged(?float $apl_pledged = null): self
    {
        // validation for constraint: float
        if (!is_null($apl_pledged) && !(is_float($apl_pledged) || is_numeric($apl_pledged))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($apl_pledged, true), gettype($apl_pledged)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($apl_pledged) && mb_strlen(mb_substr((string) $apl_pledged, false !== mb_strpos((string) $apl_pledged, '.') ? mb_strpos((string) $apl_pledged, '.') + 1 : mb_strlen((string) $apl_pledged))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($apl_pledged, true), mb_strlen(mb_substr((string) $apl_pledged, mb_strpos((string) $apl_pledged, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($apl_pledged) && mb_strlen(preg_replace('/(\D)/', '', (string) $apl_pledged)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($apl_pledged, true), mb_strlen(preg_replace('/(\D)/', '', (string) $apl_pledged))), __LINE__);
        }
        if (is_null($apl_pledged) || (is_array($apl_pledged) && empty($apl_pledged))) {
            unset($this->apl_pledged);
        } else {
            $this->apl_pledged = $apl_pledged;
        }
        
        return $this;
    }
    /**
     * Get apl_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_key_ext(): ?string
    {
        return $this->apl_key_ext ?? null;
    }
    /**
     * Set apl_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_key_ext(?string $apl_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_key_ext) && !is_string($apl_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_key_ext, true), gettype($apl_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apl_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apl_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apl_key_ext, true)), __LINE__);
        }
        if (is_null($apl_key_ext) || (is_array($apl_key_ext) && empty($apl_key_ext))) {
            unset($this->apl_key_ext);
        } else {
            $this->apl_key_ext = $apl_key_ext;
        }
        
        return $this;
    }
    /**
     * Get apl_cmp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_cmp_key(): ?string
    {
        return $this->apl_cmp_key ?? null;
    }
    /**
     * Set apl_cmp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_cmp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_cmp_key(?string $apl_cmp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_cmp_key) && !is_string($apl_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_cmp_key, true), gettype($apl_cmp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apl_cmp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apl_cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apl_cmp_key, true)), __LINE__);
        }
        if (is_null($apl_cmp_key) || (is_array($apl_cmp_key) && empty($apl_cmp_key))) {
            unset($this->apl_cmp_key);
        } else {
            $this->apl_cmp_key = $apl_cmp_key;
        }
        
        return $this;
    }
    /**
     * Get apl_act_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_act_key(): ?string
    {
        return $this->apl_act_key ?? null;
    }
    /**
     * Set apl_act_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_act_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_act_key(?string $apl_act_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_act_key) && !is_string($apl_act_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_act_key, true), gettype($apl_act_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apl_act_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apl_act_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apl_act_key, true)), __LINE__);
        }
        if (is_null($apl_act_key) || (is_array($apl_act_key) && empty($apl_act_key))) {
            unset($this->apl_act_key);
        } else {
            $this->apl_act_key = $apl_act_key;
        }
        
        return $this;
    }
    /**
     * Get apl_apc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApl_apc_key(): ?string
    {
        return $this->apl_apc_key ?? null;
    }
    /**
     * Set apl_apc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apl_apc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Appeal_Code_DataObjectType
     */
    public function setApl_apc_key(?string $apl_apc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($apl_apc_key) && !is_string($apl_apc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apl_apc_key, true), gettype($apl_apc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($apl_apc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $apl_apc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($apl_apc_key, true)), __LINE__);
        }
        if (is_null($apl_apc_key) || (is_array($apl_apc_key) && empty($apl_apc_key))) {
            unset($this->apl_apc_key);
        } else {
            $this->apl_apc_key = $apl_apc_key;
        }
        
        return $this;
    }
}
