<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Campaign_Code_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Campaign_Code_DataObjectType extends AbstractStructBase
{
    /**
     * The cmp_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp_key = null;
    /**
     * The cmp_code
     * Meta information extracted from the WSDL
     * - documentation: Campaign Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_code = null;
    /**
     * The cmp_description
     * Meta information extracted from the WSDL
     * - documentation: Campaign Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_description = null;
    /**
     * The cmp_start_date
     * Meta information extracted from the WSDL
     * - documentation: Campaign Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_start_date = null;
    /**
     * The cmp_end_date
     * Meta information extracted from the WSDL
     * - documentation: Campaign End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_end_date = null;
    /**
     * The cmp_goal
     * Meta information extracted from the WSDL
     * - documentation: Campaign Goal. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $cmp_goal = null;
    /**
     * The cmp_notes
     * Meta information extracted from the WSDL
     * - documentation: Campaign Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_notes = null;
    /**
     * The cmp_active_flag
     * Meta information extracted from the WSDL
     * - documentation: Campaign Active Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_active_flag = null;
    /**
     * The cmp_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_add_user = null;
    /**
     * The cmp_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_add_date = null;
    /**
     * The cmp_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_change_user = null;
    /**
     * The cmp_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_change_date = null;
    /**
     * The cmp_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp_delete_flag = null;
    /**
     * The cmp_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp_entity_key = null;
    /**
     * The cmp_raised
     * Meta information extracted from the WSDL
     * - documentation: Funds Raised. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $cmp_raised = null;
    /**
     * The cmp_pledged
     * Meta information extracted from the WSDL
     * - documentation: Funds Pledged. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $cmp_pledged = null;
    /**
     * The cmp_gft_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp_gft_cct_key = null;
    /**
     * The cmp_plg_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Pledge Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp_plg_cct_key = null;
    /**
     * The cmp_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp_key_ext = null;
    /**
     * The cmp_acc_key
     * Meta information extracted from the WSDL
     * - documentation: Messaging Campaign. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp_acc_key = null;
    /**
     * Constructor method for FundraisingGift_Campaign_Code_DataObjectType
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_key()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_code()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_description()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_start_date()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_end_date()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_goal()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_notes()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_active_flag()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_add_user()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_add_date()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_change_user()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_change_date()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_delete_flag()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_entity_key()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_raised()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_pledged()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_gft_cct_key()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_plg_cct_key()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_key_ext()
     * @uses FundraisingGift_Campaign_Code_DataObjectType::setCmp_acc_key()
     * @param string $cmp_key
     * @param string $cmp_code
     * @param string $cmp_description
     * @param string $cmp_start_date
     * @param string $cmp_end_date
     * @param float $cmp_goal
     * @param string $cmp_notes
     * @param string $cmp_active_flag
     * @param string $cmp_add_user
     * @param string $cmp_add_date
     * @param string $cmp_change_user
     * @param string $cmp_change_date
     * @param string $cmp_delete_flag
     * @param string $cmp_entity_key
     * @param float $cmp_raised
     * @param float $cmp_pledged
     * @param string $cmp_gft_cct_key
     * @param string $cmp_plg_cct_key
     * @param string $cmp_key_ext
     * @param string $cmp_acc_key
     */
    public function __construct(?string $cmp_key = null, ?string $cmp_code = null, ?string $cmp_description = null, ?string $cmp_start_date = null, ?string $cmp_end_date = null, ?float $cmp_goal = null, ?string $cmp_notes = null, ?string $cmp_active_flag = null, ?string $cmp_add_user = null, ?string $cmp_add_date = null, ?string $cmp_change_user = null, ?string $cmp_change_date = null, ?string $cmp_delete_flag = null, ?string $cmp_entity_key = null, ?float $cmp_raised = null, ?float $cmp_pledged = null, ?string $cmp_gft_cct_key = null, ?string $cmp_plg_cct_key = null, ?string $cmp_key_ext = null, ?string $cmp_acc_key = null)
    {
        $this
            ->setCmp_key($cmp_key)
            ->setCmp_code($cmp_code)
            ->setCmp_description($cmp_description)
            ->setCmp_start_date($cmp_start_date)
            ->setCmp_end_date($cmp_end_date)
            ->setCmp_goal($cmp_goal)
            ->setCmp_notes($cmp_notes)
            ->setCmp_active_flag($cmp_active_flag)
            ->setCmp_add_user($cmp_add_user)
            ->setCmp_add_date($cmp_add_date)
            ->setCmp_change_user($cmp_change_user)
            ->setCmp_change_date($cmp_change_date)
            ->setCmp_delete_flag($cmp_delete_flag)
            ->setCmp_entity_key($cmp_entity_key)
            ->setCmp_raised($cmp_raised)
            ->setCmp_pledged($cmp_pledged)
            ->setCmp_gft_cct_key($cmp_gft_cct_key)
            ->setCmp_plg_cct_key($cmp_plg_cct_key)
            ->setCmp_key_ext($cmp_key_ext)
            ->setCmp_acc_key($cmp_acc_key);
    }
    /**
     * Get cmp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_key(): ?string
    {
        return $this->cmp_key ?? null;
    }
    /**
     * Set cmp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_key(?string $cmp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_key) && !is_string($cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_key, true), gettype($cmp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp_key, true)), __LINE__);
        }
        if (is_null($cmp_key) || (is_array($cmp_key) && empty($cmp_key))) {
            unset($this->cmp_key);
        } else {
            $this->cmp_key = $cmp_key;
        }
        
        return $this;
    }
    /**
     * Get cmp_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_code(): ?string
    {
        return $this->cmp_code ?? null;
    }
    /**
     * Set cmp_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_code(?string $cmp_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_code) && !is_string($cmp_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_code, true), gettype($cmp_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cmp_code) && mb_strlen((string) $cmp_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cmp_code)), __LINE__);
        }
        if (is_null($cmp_code) || (is_array($cmp_code) && empty($cmp_code))) {
            unset($this->cmp_code);
        } else {
            $this->cmp_code = $cmp_code;
        }
        
        return $this;
    }
    /**
     * Get cmp_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_description(): ?string
    {
        return $this->cmp_description ?? null;
    }
    /**
     * Set cmp_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_description(?string $cmp_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_description) && !is_string($cmp_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_description, true), gettype($cmp_description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($cmp_description) && mb_strlen((string) $cmp_description) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $cmp_description)), __LINE__);
        }
        if (is_null($cmp_description) || (is_array($cmp_description) && empty($cmp_description))) {
            unset($this->cmp_description);
        } else {
            $this->cmp_description = $cmp_description;
        }
        
        return $this;
    }
    /**
     * Get cmp_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_start_date(): ?string
    {
        return $this->cmp_start_date ?? null;
    }
    /**
     * Set cmp_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_start_date(?string $cmp_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_start_date) && !is_string($cmp_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_start_date, true), gettype($cmp_start_date)), __LINE__);
        }
        if (is_null($cmp_start_date) || (is_array($cmp_start_date) && empty($cmp_start_date))) {
            unset($this->cmp_start_date);
        } else {
            $this->cmp_start_date = $cmp_start_date;
        }
        
        return $this;
    }
    /**
     * Get cmp_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_end_date(): ?string
    {
        return $this->cmp_end_date ?? null;
    }
    /**
     * Set cmp_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_end_date(?string $cmp_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_end_date) && !is_string($cmp_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_end_date, true), gettype($cmp_end_date)), __LINE__);
        }
        if (is_null($cmp_end_date) || (is_array($cmp_end_date) && empty($cmp_end_date))) {
            unset($this->cmp_end_date);
        } else {
            $this->cmp_end_date = $cmp_end_date;
        }
        
        return $this;
    }
    /**
     * Get cmp_goal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCmp_goal(): ?float
    {
        return $this->cmp_goal ?? null;
    }
    /**
     * Set cmp_goal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cmp_goal
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_goal(?float $cmp_goal = null): self
    {
        // validation for constraint: float
        if (!is_null($cmp_goal) && !(is_float($cmp_goal) || is_numeric($cmp_goal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cmp_goal, true), gettype($cmp_goal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cmp_goal) && mb_strlen(mb_substr((string) $cmp_goal, false !== mb_strpos((string) $cmp_goal, '.') ? mb_strpos((string) $cmp_goal, '.') + 1 : mb_strlen((string) $cmp_goal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cmp_goal, true), mb_strlen(mb_substr((string) $cmp_goal, mb_strpos((string) $cmp_goal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($cmp_goal) && mb_strlen(preg_replace('/(\D)/', '', (string) $cmp_goal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($cmp_goal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cmp_goal))), __LINE__);
        }
        if (is_null($cmp_goal) || (is_array($cmp_goal) && empty($cmp_goal))) {
            unset($this->cmp_goal);
        } else {
            $this->cmp_goal = $cmp_goal;
        }
        
        return $this;
    }
    /**
     * Get cmp_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_notes(): ?string
    {
        return $this->cmp_notes ?? null;
    }
    /**
     * Set cmp_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_notes(?string $cmp_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_notes) && !is_string($cmp_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_notes, true), gettype($cmp_notes)), __LINE__);
        }
        if (is_null($cmp_notes) || (is_array($cmp_notes) && empty($cmp_notes))) {
            unset($this->cmp_notes);
        } else {
            $this->cmp_notes = $cmp_notes;
        }
        
        return $this;
    }
    /**
     * Get cmp_active_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_active_flag(): ?string
    {
        return $this->cmp_active_flag ?? null;
    }
    /**
     * Set cmp_active_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_active_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_active_flag(?string $cmp_active_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_active_flag) && !is_string($cmp_active_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_active_flag, true), gettype($cmp_active_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cmp_active_flag) && $cmp_active_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cmp_active_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cmp_active_flag) && $cmp_active_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cmp_active_flag, true)), __LINE__);
        }
        if (is_null($cmp_active_flag) || (is_array($cmp_active_flag) && empty($cmp_active_flag))) {
            unset($this->cmp_active_flag);
        } else {
            $this->cmp_active_flag = $cmp_active_flag;
        }
        
        return $this;
    }
    /**
     * Get cmp_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_add_user(): ?string
    {
        return $this->cmp_add_user ?? null;
    }
    /**
     * Set cmp_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_add_user(?string $cmp_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_add_user) && !is_string($cmp_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_add_user, true), gettype($cmp_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cmp_add_user) && mb_strlen((string) $cmp_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cmp_add_user)), __LINE__);
        }
        if (is_null($cmp_add_user) || (is_array($cmp_add_user) && empty($cmp_add_user))) {
            unset($this->cmp_add_user);
        } else {
            $this->cmp_add_user = $cmp_add_user;
        }
        
        return $this;
    }
    /**
     * Get cmp_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_add_date(): ?string
    {
        return $this->cmp_add_date ?? null;
    }
    /**
     * Set cmp_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_add_date(?string $cmp_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_add_date) && !is_string($cmp_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_add_date, true), gettype($cmp_add_date)), __LINE__);
        }
        if (is_null($cmp_add_date) || (is_array($cmp_add_date) && empty($cmp_add_date))) {
            unset($this->cmp_add_date);
        } else {
            $this->cmp_add_date = $cmp_add_date;
        }
        
        return $this;
    }
    /**
     * Get cmp_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_change_user(): ?string
    {
        return $this->cmp_change_user ?? null;
    }
    /**
     * Set cmp_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_change_user(?string $cmp_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_change_user) && !is_string($cmp_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_change_user, true), gettype($cmp_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cmp_change_user) && mb_strlen((string) $cmp_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cmp_change_user)), __LINE__);
        }
        if (is_null($cmp_change_user) || (is_array($cmp_change_user) && empty($cmp_change_user))) {
            unset($this->cmp_change_user);
        } else {
            $this->cmp_change_user = $cmp_change_user;
        }
        
        return $this;
    }
    /**
     * Get cmp_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_change_date(): ?string
    {
        return $this->cmp_change_date ?? null;
    }
    /**
     * Set cmp_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_change_date(?string $cmp_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_change_date) && !is_string($cmp_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_change_date, true), gettype($cmp_change_date)), __LINE__);
        }
        if (is_null($cmp_change_date) || (is_array($cmp_change_date) && empty($cmp_change_date))) {
            unset($this->cmp_change_date);
        } else {
            $this->cmp_change_date = $cmp_change_date;
        }
        
        return $this;
    }
    /**
     * Get cmp_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_delete_flag(): ?string
    {
        return $this->cmp_delete_flag ?? null;
    }
    /**
     * Set cmp_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_delete_flag(?string $cmp_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_delete_flag) && !is_string($cmp_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_delete_flag, true), gettype($cmp_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cmp_delete_flag) && $cmp_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cmp_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cmp_delete_flag) && $cmp_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cmp_delete_flag, true)), __LINE__);
        }
        if (is_null($cmp_delete_flag) || (is_array($cmp_delete_flag) && empty($cmp_delete_flag))) {
            unset($this->cmp_delete_flag);
        } else {
            $this->cmp_delete_flag = $cmp_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cmp_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_entity_key(): ?string
    {
        return $this->cmp_entity_key ?? null;
    }
    /**
     * Set cmp_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_entity_key(?string $cmp_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_entity_key) && !is_string($cmp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_entity_key, true), gettype($cmp_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp_entity_key, true)), __LINE__);
        }
        if (is_null($cmp_entity_key) || (is_array($cmp_entity_key) && empty($cmp_entity_key))) {
            unset($this->cmp_entity_key);
        } else {
            $this->cmp_entity_key = $cmp_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cmp_raised value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCmp_raised(): ?float
    {
        return $this->cmp_raised ?? null;
    }
    /**
     * Set cmp_raised value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cmp_raised
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_raised(?float $cmp_raised = null): self
    {
        // validation for constraint: float
        if (!is_null($cmp_raised) && !(is_float($cmp_raised) || is_numeric($cmp_raised))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cmp_raised, true), gettype($cmp_raised)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cmp_raised) && mb_strlen(mb_substr((string) $cmp_raised, false !== mb_strpos((string) $cmp_raised, '.') ? mb_strpos((string) $cmp_raised, '.') + 1 : mb_strlen((string) $cmp_raised))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cmp_raised, true), mb_strlen(mb_substr((string) $cmp_raised, mb_strpos((string) $cmp_raised, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($cmp_raised) && mb_strlen(preg_replace('/(\D)/', '', (string) $cmp_raised)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($cmp_raised, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cmp_raised))), __LINE__);
        }
        if (is_null($cmp_raised) || (is_array($cmp_raised) && empty($cmp_raised))) {
            unset($this->cmp_raised);
        } else {
            $this->cmp_raised = $cmp_raised;
        }
        
        return $this;
    }
    /**
     * Get cmp_pledged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCmp_pledged(): ?float
    {
        return $this->cmp_pledged ?? null;
    }
    /**
     * Set cmp_pledged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cmp_pledged
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_pledged(?float $cmp_pledged = null): self
    {
        // validation for constraint: float
        if (!is_null($cmp_pledged) && !(is_float($cmp_pledged) || is_numeric($cmp_pledged))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cmp_pledged, true), gettype($cmp_pledged)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($cmp_pledged) && mb_strlen(mb_substr((string) $cmp_pledged, false !== mb_strpos((string) $cmp_pledged, '.') ? mb_strpos((string) $cmp_pledged, '.') + 1 : mb_strlen((string) $cmp_pledged))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($cmp_pledged, true), mb_strlen(mb_substr((string) $cmp_pledged, mb_strpos((string) $cmp_pledged, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($cmp_pledged) && mb_strlen(preg_replace('/(\D)/', '', (string) $cmp_pledged)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($cmp_pledged, true), mb_strlen(preg_replace('/(\D)/', '', (string) $cmp_pledged))), __LINE__);
        }
        if (is_null($cmp_pledged) || (is_array($cmp_pledged) && empty($cmp_pledged))) {
            unset($this->cmp_pledged);
        } else {
            $this->cmp_pledged = $cmp_pledged;
        }
        
        return $this;
    }
    /**
     * Get cmp_gft_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_gft_cct_key(): ?string
    {
        return $this->cmp_gft_cct_key ?? null;
    }
    /**
     * Set cmp_gft_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_gft_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_gft_cct_key(?string $cmp_gft_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_gft_cct_key) && !is_string($cmp_gft_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_gft_cct_key, true), gettype($cmp_gft_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp_gft_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp_gft_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp_gft_cct_key, true)), __LINE__);
        }
        if (is_null($cmp_gft_cct_key) || (is_array($cmp_gft_cct_key) && empty($cmp_gft_cct_key))) {
            unset($this->cmp_gft_cct_key);
        } else {
            $this->cmp_gft_cct_key = $cmp_gft_cct_key;
        }
        
        return $this;
    }
    /**
     * Get cmp_plg_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_plg_cct_key(): ?string
    {
        return $this->cmp_plg_cct_key ?? null;
    }
    /**
     * Set cmp_plg_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_plg_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_plg_cct_key(?string $cmp_plg_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_plg_cct_key) && !is_string($cmp_plg_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_plg_cct_key, true), gettype($cmp_plg_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp_plg_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp_plg_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp_plg_cct_key, true)), __LINE__);
        }
        if (is_null($cmp_plg_cct_key) || (is_array($cmp_plg_cct_key) && empty($cmp_plg_cct_key))) {
            unset($this->cmp_plg_cct_key);
        } else {
            $this->cmp_plg_cct_key = $cmp_plg_cct_key;
        }
        
        return $this;
    }
    /**
     * Get cmp_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_key_ext(): ?string
    {
        return $this->cmp_key_ext ?? null;
    }
    /**
     * Set cmp_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_key_ext(?string $cmp_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_key_ext) && !is_string($cmp_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_key_ext, true), gettype($cmp_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp_key_ext, true)), __LINE__);
        }
        if (is_null($cmp_key_ext) || (is_array($cmp_key_ext) && empty($cmp_key_ext))) {
            unset($this->cmp_key_ext);
        } else {
            $this->cmp_key_ext = $cmp_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cmp_acc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp_acc_key(): ?string
    {
        return $this->cmp_acc_key ?? null;
    }
    /**
     * Set cmp_acc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp_acc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Campaign_Code_DataObjectType
     */
    public function setCmp_acc_key(?string $cmp_acc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp_acc_key) && !is_string($cmp_acc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp_acc_key, true), gettype($cmp_acc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp_acc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp_acc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp_acc_key, true)), __LINE__);
        }
        if (is_null($cmp_acc_key) || (is_array($cmp_acc_key) && empty($cmp_acc_key))) {
            unset($this->cmp_acc_key);
        } else {
            $this->cmp_acc_key = $cmp_acc_key;
        }
        
        return $this;
    }
}
