<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Gift_Type_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Gift_Type_DataObjectType extends AbstractStructBase
{
    /**
     * The gty_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gty_key = null;
    /**
     * The gty_type
     * Meta information extracted from the WSDL
     * - documentation: Gift Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gty_type = null;
    /**
     * The gty_description
     * Meta information extracted from the WSDL
     * - documentation: Gift Type Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gty_description = null;
    /**
     * The gty_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gty_add_user = null;
    /**
     * The gty_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gty_add_date = null;
    /**
     * The gty_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gty_change_user = null;
    /**
     * The gty_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gty_change_date = null;
    /**
     * The gty_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $gty_delete_flag = null;
    /**
     * The gty_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gty_entity_key = null;
    /**
     * The gty_display_order
     * Meta information extracted from the WSDL
     * - documentation: Display Order. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $gty_display_order = null;
    /**
     * The gty_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $gty_key_ext = null;
    /**
     * Constructor method for FundraisingGift_Gift_Type_DataObjectType
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_key()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_type()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_description()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_add_user()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_add_date()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_change_user()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_change_date()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_delete_flag()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_entity_key()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_display_order()
     * @uses FundraisingGift_Gift_Type_DataObjectType::setGty_key_ext()
     * @param string $gty_key
     * @param string $gty_type
     * @param string $gty_description
     * @param string $gty_add_user
     * @param string $gty_add_date
     * @param string $gty_change_user
     * @param string $gty_change_date
     * @param string $gty_delete_flag
     * @param string $gty_entity_key
     * @param int $gty_display_order
     * @param string $gty_key_ext
     */
    public function __construct(?string $gty_key = null, ?string $gty_type = null, ?string $gty_description = null, ?string $gty_add_user = null, ?string $gty_add_date = null, ?string $gty_change_user = null, ?string $gty_change_date = null, ?string $gty_delete_flag = null, ?string $gty_entity_key = null, ?int $gty_display_order = null, ?string $gty_key_ext = null)
    {
        $this
            ->setGty_key($gty_key)
            ->setGty_type($gty_type)
            ->setGty_description($gty_description)
            ->setGty_add_user($gty_add_user)
            ->setGty_add_date($gty_add_date)
            ->setGty_change_user($gty_change_user)
            ->setGty_change_date($gty_change_date)
            ->setGty_delete_flag($gty_delete_flag)
            ->setGty_entity_key($gty_entity_key)
            ->setGty_display_order($gty_display_order)
            ->setGty_key_ext($gty_key_ext);
    }
    /**
     * Get gty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_key(): ?string
    {
        return $this->gty_key ?? null;
    }
    /**
     * Set gty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_key(?string $gty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_key) && !is_string($gty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_key, true), gettype($gty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gty_key, true)), __LINE__);
        }
        if (is_null($gty_key) || (is_array($gty_key) && empty($gty_key))) {
            unset($this->gty_key);
        } else {
            $this->gty_key = $gty_key;
        }
        
        return $this;
    }
    /**
     * Get gty_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_type(): ?string
    {
        return $this->gty_type ?? null;
    }
    /**
     * Set gty_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_type(?string $gty_type = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_type) && !is_string($gty_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_type, true), gettype($gty_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($gty_type) && mb_strlen((string) $gty_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $gty_type)), __LINE__);
        }
        if (is_null($gty_type) || (is_array($gty_type) && empty($gty_type))) {
            unset($this->gty_type);
        } else {
            $this->gty_type = $gty_type;
        }
        
        return $this;
    }
    /**
     * Get gty_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_description(): ?string
    {
        return $this->gty_description ?? null;
    }
    /**
     * Set gty_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_description(?string $gty_description = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_description) && !is_string($gty_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_description, true), gettype($gty_description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($gty_description) && mb_strlen((string) $gty_description) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $gty_description)), __LINE__);
        }
        if (is_null($gty_description) || (is_array($gty_description) && empty($gty_description))) {
            unset($this->gty_description);
        } else {
            $this->gty_description = $gty_description;
        }
        
        return $this;
    }
    /**
     * Get gty_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_add_user(): ?string
    {
        return $this->gty_add_user ?? null;
    }
    /**
     * Set gty_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_add_user(?string $gty_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_add_user) && !is_string($gty_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_add_user, true), gettype($gty_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($gty_add_user) && mb_strlen((string) $gty_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $gty_add_user)), __LINE__);
        }
        if (is_null($gty_add_user) || (is_array($gty_add_user) && empty($gty_add_user))) {
            unset($this->gty_add_user);
        } else {
            $this->gty_add_user = $gty_add_user;
        }
        
        return $this;
    }
    /**
     * Get gty_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_add_date(): ?string
    {
        return $this->gty_add_date ?? null;
    }
    /**
     * Set gty_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_add_date(?string $gty_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_add_date) && !is_string($gty_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_add_date, true), gettype($gty_add_date)), __LINE__);
        }
        if (is_null($gty_add_date) || (is_array($gty_add_date) && empty($gty_add_date))) {
            unset($this->gty_add_date);
        } else {
            $this->gty_add_date = $gty_add_date;
        }
        
        return $this;
    }
    /**
     * Get gty_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_change_user(): ?string
    {
        return $this->gty_change_user ?? null;
    }
    /**
     * Set gty_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_change_user(?string $gty_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_change_user) && !is_string($gty_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_change_user, true), gettype($gty_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($gty_change_user) && mb_strlen((string) $gty_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $gty_change_user)), __LINE__);
        }
        if (is_null($gty_change_user) || (is_array($gty_change_user) && empty($gty_change_user))) {
            unset($this->gty_change_user);
        } else {
            $this->gty_change_user = $gty_change_user;
        }
        
        return $this;
    }
    /**
     * Get gty_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_change_date(): ?string
    {
        return $this->gty_change_date ?? null;
    }
    /**
     * Set gty_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_change_date(?string $gty_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_change_date) && !is_string($gty_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_change_date, true), gettype($gty_change_date)), __LINE__);
        }
        if (is_null($gty_change_date) || (is_array($gty_change_date) && empty($gty_change_date))) {
            unset($this->gty_change_date);
        } else {
            $this->gty_change_date = $gty_change_date;
        }
        
        return $this;
    }
    /**
     * Get gty_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_delete_flag(): ?string
    {
        return $this->gty_delete_flag ?? null;
    }
    /**
     * Set gty_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_delete_flag(?string $gty_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_delete_flag) && !is_string($gty_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_delete_flag, true), gettype($gty_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($gty_delete_flag) && $gty_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($gty_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($gty_delete_flag) && $gty_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($gty_delete_flag, true)), __LINE__);
        }
        if (is_null($gty_delete_flag) || (is_array($gty_delete_flag) && empty($gty_delete_flag))) {
            unset($this->gty_delete_flag);
        } else {
            $this->gty_delete_flag = $gty_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get gty_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_entity_key(): ?string
    {
        return $this->gty_entity_key ?? null;
    }
    /**
     * Set gty_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_entity_key(?string $gty_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_entity_key) && !is_string($gty_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_entity_key, true), gettype($gty_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gty_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gty_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gty_entity_key, true)), __LINE__);
        }
        if (is_null($gty_entity_key) || (is_array($gty_entity_key) && empty($gty_entity_key))) {
            unset($this->gty_entity_key);
        } else {
            $this->gty_entity_key = $gty_entity_key;
        }
        
        return $this;
    }
    /**
     * Get gty_display_order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGty_display_order(): ?int
    {
        return $this->gty_display_order ?? null;
    }
    /**
     * Set gty_display_order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gty_display_order
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_display_order(?int $gty_display_order = null): self
    {
        // validation for constraint: int
        if (!is_null($gty_display_order) && !(is_int($gty_display_order) || ctype_digit($gty_display_order))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gty_display_order, true), gettype($gty_display_order)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($gty_display_order) && $gty_display_order > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($gty_display_order, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($gty_display_order) && $gty_display_order < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($gty_display_order, true)), __LINE__);
        }
        if (is_null($gty_display_order) || (is_array($gty_display_order) && empty($gty_display_order))) {
            unset($this->gty_display_order);
        } else {
            $this->gty_display_order = $gty_display_order;
        }
        
        return $this;
    }
    /**
     * Get gty_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGty_key_ext(): ?string
    {
        return $this->gty_key_ext ?? null;
    }
    /**
     * Set gty_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gty_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Gift_Type_DataObjectType
     */
    public function setGty_key_ext(?string $gty_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($gty_key_ext) && !is_string($gty_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gty_key_ext, true), gettype($gty_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($gty_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $gty_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($gty_key_ext, true)), __LINE__);
        }
        if (is_null($gty_key_ext) || (is_array($gty_key_ext) && empty($gty_key_ext))) {
            unset($this->gty_key_ext);
        } else {
            $this->gty_key_ext = $gty_key_ext;
        }
        
        return $this;
    }
}
