<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Org_Business_Address_XRef_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Org_Business_Address_XRef_DataObjectType extends AbstractStructBase
{
    /**
     * The cx6__cxa_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx6__cxa_cst_key = null;
    /**
     * The cx6__cxa_adr_key
     * Meta information extracted from the WSDL
     * - documentation: Address Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx6__cxa_adr_key = null;
    /**
     * The cx6__cxa_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_add_date = null;
    /**
     * The cx6__cxa_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_add_user = null;
    /**
     * The cx6__cxa_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_change_date = null;
    /**
     * The cx6__cxa_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_change_user = null;
    /**
     * The cx6__cxa_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_delete_flag = null;
    /**
     * The cx6__cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx6__cxa_key = null;
    /**
     * The cx6__cxa_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx6__cxa_key_ext = null;
    /**
     * The cx6__cxa_on_hold_flag
     * Meta information extracted from the WSDL
     * - documentation: Address On Hold Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_on_hold_flag = null;
    /**
     * The cx6__cxa_adh_key
     * Meta information extracted from the WSDL
     * - documentation: On Hold Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx6__cxa_adh_key = null;
    /**
     * The cx6__cxa_adt_key
     * Meta information extracted from the WSDL
     * - documentation: Address Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx6__cxa_adt_key = null;
    /**
     * The cx6__cxa_seasonal_from_date
     * Meta information extracted from the WSDL
     * - documentation: Seasonal From Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_seasonal_from_date = null;
    /**
     * The cx6__cxa_mailing_label
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_mailing_label = null;
    /**
     * The cx6__cxa_seasonal_through_date
     * Meta information extracted from the WSDL
     * - documentation: Seasonal Through Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_seasonal_through_date = null;
    /**
     * The cx6__cxa_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cx6__cxa_entity_key = null;
    /**
     * The cx6__cxa_mail_stop
     * Meta information extracted from the WSDL
     * - documentation: Mailstop. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_mail_stop = null;
    /**
     * The cx6__cxa_mailing_label_html
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label HTML. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_mailing_label_html = null;
    /**
     * The cx6__cxa_on_hold_from
     * Meta information extracted from the WSDL
     * - documentation: Hold From. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_on_hold_from = null;
    /**
     * The cx6__cxa_on_hold_through
     * Meta information extracted from the WSDL
     * - documentation: On Hold Until Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_on_hold_through = null;
    /**
     * The cx6__cxa_primary
     * Meta information extracted from the WSDL
     * - documentation: Primary.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_primary = null;
    /**
     * The cx6__cxa_owner
     * Meta information extracted from the WSDL
     * - documentation: Address Owner.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_owner = null;
    /**
     * The cx6__cxa_billing
     * Meta information extracted from the WSDL
     * - documentation: Billing.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_billing = null;
    /**
     * The cx6__cxa_create_change_log
     * Meta information extracted from the WSDL
     * - documentation: Create address change log?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_create_change_log = null;
    /**
     * The cx6__cxa_AddressLinkingDropDownList
     * Meta information extracted from the WSDL
     * - documentation: linking drop down list.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cx6__cxa_AddressLinkingDropDownList = null;
    /**
     * Constructor method for FundraisingGift_Org_Business_Address_XRef_DataObjectType
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_cst_key()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_adr_key()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_add_date()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_add_user()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_change_date()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_change_user()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_delete_flag()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_key()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_key_ext()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_on_hold_flag()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_adh_key()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_adt_key()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_seasonal_from_date()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_mailing_label()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_seasonal_through_date()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_entity_key()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_mail_stop()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_mailing_label_html()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_on_hold_from()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_on_hold_through()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_primary()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_owner()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_billing()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_create_change_log()
     * @uses FundraisingGift_Org_Business_Address_XRef_DataObjectType::setCx6__cxa_AddressLinkingDropDownList()
     * @param string $cx6__cxa_cst_key
     * @param string $cx6__cxa_adr_key
     * @param string $cx6__cxa_add_date
     * @param string $cx6__cxa_add_user
     * @param string $cx6__cxa_change_date
     * @param string $cx6__cxa_change_user
     * @param string $cx6__cxa_delete_flag
     * @param string $cx6__cxa_key
     * @param string $cx6__cxa_key_ext
     * @param string $cx6__cxa_on_hold_flag
     * @param string $cx6__cxa_adh_key
     * @param string $cx6__cxa_adt_key
     * @param string $cx6__cxa_seasonal_from_date
     * @param string $cx6__cxa_mailing_label
     * @param string $cx6__cxa_seasonal_through_date
     * @param string $cx6__cxa_entity_key
     * @param string $cx6__cxa_mail_stop
     * @param string $cx6__cxa_mailing_label_html
     * @param string $cx6__cxa_on_hold_from
     * @param string $cx6__cxa_on_hold_through
     * @param string $cx6__cxa_primary
     * @param string $cx6__cxa_owner
     * @param string $cx6__cxa_billing
     * @param string $cx6__cxa_create_change_log
     * @param string $cx6__cxa_AddressLinkingDropDownList
     */
    public function __construct(?string $cx6__cxa_cst_key = null, ?string $cx6__cxa_adr_key = null, ?string $cx6__cxa_add_date = null, ?string $cx6__cxa_add_user = null, ?string $cx6__cxa_change_date = null, ?string $cx6__cxa_change_user = null, ?string $cx6__cxa_delete_flag = null, ?string $cx6__cxa_key = null, ?string $cx6__cxa_key_ext = null, ?string $cx6__cxa_on_hold_flag = null, ?string $cx6__cxa_adh_key = null, ?string $cx6__cxa_adt_key = null, ?string $cx6__cxa_seasonal_from_date = null, ?string $cx6__cxa_mailing_label = null, ?string $cx6__cxa_seasonal_through_date = null, ?string $cx6__cxa_entity_key = null, ?string $cx6__cxa_mail_stop = null, ?string $cx6__cxa_mailing_label_html = null, ?string $cx6__cxa_on_hold_from = null, ?string $cx6__cxa_on_hold_through = null, ?string $cx6__cxa_primary = null, ?string $cx6__cxa_owner = null, ?string $cx6__cxa_billing = null, ?string $cx6__cxa_create_change_log = null, ?string $cx6__cxa_AddressLinkingDropDownList = null)
    {
        $this
            ->setCx6__cxa_cst_key($cx6__cxa_cst_key)
            ->setCx6__cxa_adr_key($cx6__cxa_adr_key)
            ->setCx6__cxa_add_date($cx6__cxa_add_date)
            ->setCx6__cxa_add_user($cx6__cxa_add_user)
            ->setCx6__cxa_change_date($cx6__cxa_change_date)
            ->setCx6__cxa_change_user($cx6__cxa_change_user)
            ->setCx6__cxa_delete_flag($cx6__cxa_delete_flag)
            ->setCx6__cxa_key($cx6__cxa_key)
            ->setCx6__cxa_key_ext($cx6__cxa_key_ext)
            ->setCx6__cxa_on_hold_flag($cx6__cxa_on_hold_flag)
            ->setCx6__cxa_adh_key($cx6__cxa_adh_key)
            ->setCx6__cxa_adt_key($cx6__cxa_adt_key)
            ->setCx6__cxa_seasonal_from_date($cx6__cxa_seasonal_from_date)
            ->setCx6__cxa_mailing_label($cx6__cxa_mailing_label)
            ->setCx6__cxa_seasonal_through_date($cx6__cxa_seasonal_through_date)
            ->setCx6__cxa_entity_key($cx6__cxa_entity_key)
            ->setCx6__cxa_mail_stop($cx6__cxa_mail_stop)
            ->setCx6__cxa_mailing_label_html($cx6__cxa_mailing_label_html)
            ->setCx6__cxa_on_hold_from($cx6__cxa_on_hold_from)
            ->setCx6__cxa_on_hold_through($cx6__cxa_on_hold_through)
            ->setCx6__cxa_primary($cx6__cxa_primary)
            ->setCx6__cxa_owner($cx6__cxa_owner)
            ->setCx6__cxa_billing($cx6__cxa_billing)
            ->setCx6__cxa_create_change_log($cx6__cxa_create_change_log)
            ->setCx6__cxa_AddressLinkingDropDownList($cx6__cxa_AddressLinkingDropDownList);
    }
    /**
     * Get cx6__cxa_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_cst_key(): ?string
    {
        return $this->cx6__cxa_cst_key ?? null;
    }
    /**
     * Set cx6__cxa_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_cst_key(?string $cx6__cxa_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_cst_key) && !is_string($cx6__cxa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_cst_key, true), gettype($cx6__cxa_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx6__cxa_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx6__cxa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx6__cxa_cst_key, true)), __LINE__);
        }
        if (is_null($cx6__cxa_cst_key) || (is_array($cx6__cxa_cst_key) && empty($cx6__cxa_cst_key))) {
            unset($this->cx6__cxa_cst_key);
        } else {
            $this->cx6__cxa_cst_key = $cx6__cxa_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_adr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_adr_key(): ?string
    {
        return $this->cx6__cxa_adr_key ?? null;
    }
    /**
     * Set cx6__cxa_adr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_adr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_adr_key(?string $cx6__cxa_adr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_adr_key) && !is_string($cx6__cxa_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_adr_key, true), gettype($cx6__cxa_adr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx6__cxa_adr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx6__cxa_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx6__cxa_adr_key, true)), __LINE__);
        }
        if (is_null($cx6__cxa_adr_key) || (is_array($cx6__cxa_adr_key) && empty($cx6__cxa_adr_key))) {
            unset($this->cx6__cxa_adr_key);
        } else {
            $this->cx6__cxa_adr_key = $cx6__cxa_adr_key;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_add_date(): ?string
    {
        return $this->cx6__cxa_add_date ?? null;
    }
    /**
     * Set cx6__cxa_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_add_date(?string $cx6__cxa_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_add_date) && !is_string($cx6__cxa_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_add_date, true), gettype($cx6__cxa_add_date)), __LINE__);
        }
        if (is_null($cx6__cxa_add_date) || (is_array($cx6__cxa_add_date) && empty($cx6__cxa_add_date))) {
            unset($this->cx6__cxa_add_date);
        } else {
            $this->cx6__cxa_add_date = $cx6__cxa_add_date;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_add_user(): ?string
    {
        return $this->cx6__cxa_add_user ?? null;
    }
    /**
     * Set cx6__cxa_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_add_user(?string $cx6__cxa_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_add_user) && !is_string($cx6__cxa_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_add_user, true), gettype($cx6__cxa_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cx6__cxa_add_user) && mb_strlen((string) $cx6__cxa_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cx6__cxa_add_user)), __LINE__);
        }
        if (is_null($cx6__cxa_add_user) || (is_array($cx6__cxa_add_user) && empty($cx6__cxa_add_user))) {
            unset($this->cx6__cxa_add_user);
        } else {
            $this->cx6__cxa_add_user = $cx6__cxa_add_user;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_change_date(): ?string
    {
        return $this->cx6__cxa_change_date ?? null;
    }
    /**
     * Set cx6__cxa_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_change_date(?string $cx6__cxa_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_change_date) && !is_string($cx6__cxa_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_change_date, true), gettype($cx6__cxa_change_date)), __LINE__);
        }
        if (is_null($cx6__cxa_change_date) || (is_array($cx6__cxa_change_date) && empty($cx6__cxa_change_date))) {
            unset($this->cx6__cxa_change_date);
        } else {
            $this->cx6__cxa_change_date = $cx6__cxa_change_date;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_change_user(): ?string
    {
        return $this->cx6__cxa_change_user ?? null;
    }
    /**
     * Set cx6__cxa_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_change_user(?string $cx6__cxa_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_change_user) && !is_string($cx6__cxa_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_change_user, true), gettype($cx6__cxa_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cx6__cxa_change_user) && mb_strlen((string) $cx6__cxa_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cx6__cxa_change_user)), __LINE__);
        }
        if (is_null($cx6__cxa_change_user) || (is_array($cx6__cxa_change_user) && empty($cx6__cxa_change_user))) {
            unset($this->cx6__cxa_change_user);
        } else {
            $this->cx6__cxa_change_user = $cx6__cxa_change_user;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_delete_flag(): ?string
    {
        return $this->cx6__cxa_delete_flag ?? null;
    }
    /**
     * Set cx6__cxa_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_delete_flag(?string $cx6__cxa_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_delete_flag) && !is_string($cx6__cxa_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_delete_flag, true), gettype($cx6__cxa_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cx6__cxa_delete_flag) && $cx6__cxa_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cx6__cxa_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cx6__cxa_delete_flag) && $cx6__cxa_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cx6__cxa_delete_flag, true)), __LINE__);
        }
        if (is_null($cx6__cxa_delete_flag) || (is_array($cx6__cxa_delete_flag) && empty($cx6__cxa_delete_flag))) {
            unset($this->cx6__cxa_delete_flag);
        } else {
            $this->cx6__cxa_delete_flag = $cx6__cxa_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_key(): ?string
    {
        return $this->cx6__cxa_key ?? null;
    }
    /**
     * Set cx6__cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_key(?string $cx6__cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_key) && !is_string($cx6__cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_key, true), gettype($cx6__cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx6__cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx6__cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx6__cxa_key, true)), __LINE__);
        }
        if (is_null($cx6__cxa_key) || (is_array($cx6__cxa_key) && empty($cx6__cxa_key))) {
            unset($this->cx6__cxa_key);
        } else {
            $this->cx6__cxa_key = $cx6__cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_key_ext(): ?string
    {
        return $this->cx6__cxa_key_ext ?? null;
    }
    /**
     * Set cx6__cxa_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_key_ext(?string $cx6__cxa_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_key_ext) && !is_string($cx6__cxa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_key_ext, true), gettype($cx6__cxa_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx6__cxa_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx6__cxa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx6__cxa_key_ext, true)), __LINE__);
        }
        if (is_null($cx6__cxa_key_ext) || (is_array($cx6__cxa_key_ext) && empty($cx6__cxa_key_ext))) {
            unset($this->cx6__cxa_key_ext);
        } else {
            $this->cx6__cxa_key_ext = $cx6__cxa_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_on_hold_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_on_hold_flag(): ?string
    {
        return $this->cx6__cxa_on_hold_flag ?? null;
    }
    /**
     * Set cx6__cxa_on_hold_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_on_hold_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_on_hold_flag(?string $cx6__cxa_on_hold_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_on_hold_flag) && !is_string($cx6__cxa_on_hold_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_on_hold_flag, true), gettype($cx6__cxa_on_hold_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cx6__cxa_on_hold_flag) && $cx6__cxa_on_hold_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cx6__cxa_on_hold_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cx6__cxa_on_hold_flag) && $cx6__cxa_on_hold_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cx6__cxa_on_hold_flag, true)), __LINE__);
        }
        if (is_null($cx6__cxa_on_hold_flag) || (is_array($cx6__cxa_on_hold_flag) && empty($cx6__cxa_on_hold_flag))) {
            unset($this->cx6__cxa_on_hold_flag);
        } else {
            $this->cx6__cxa_on_hold_flag = $cx6__cxa_on_hold_flag;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_adh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_adh_key(): ?string
    {
        return $this->cx6__cxa_adh_key ?? null;
    }
    /**
     * Set cx6__cxa_adh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_adh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_adh_key(?string $cx6__cxa_adh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_adh_key) && !is_string($cx6__cxa_adh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_adh_key, true), gettype($cx6__cxa_adh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx6__cxa_adh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx6__cxa_adh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx6__cxa_adh_key, true)), __LINE__);
        }
        if (is_null($cx6__cxa_adh_key) || (is_array($cx6__cxa_adh_key) && empty($cx6__cxa_adh_key))) {
            unset($this->cx6__cxa_adh_key);
        } else {
            $this->cx6__cxa_adh_key = $cx6__cxa_adh_key;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_adt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_adt_key(): ?string
    {
        return $this->cx6__cxa_adt_key ?? null;
    }
    /**
     * Set cx6__cxa_adt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_adt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_adt_key(?string $cx6__cxa_adt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_adt_key) && !is_string($cx6__cxa_adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_adt_key, true), gettype($cx6__cxa_adt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx6__cxa_adt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx6__cxa_adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx6__cxa_adt_key, true)), __LINE__);
        }
        if (is_null($cx6__cxa_adt_key) || (is_array($cx6__cxa_adt_key) && empty($cx6__cxa_adt_key))) {
            unset($this->cx6__cxa_adt_key);
        } else {
            $this->cx6__cxa_adt_key = $cx6__cxa_adt_key;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_seasonal_from_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_seasonal_from_date(): ?string
    {
        return $this->cx6__cxa_seasonal_from_date ?? null;
    }
    /**
     * Set cx6__cxa_seasonal_from_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_seasonal_from_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_seasonal_from_date(?string $cx6__cxa_seasonal_from_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_seasonal_from_date) && !is_string($cx6__cxa_seasonal_from_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_seasonal_from_date, true), gettype($cx6__cxa_seasonal_from_date)), __LINE__);
        }
        if (is_null($cx6__cxa_seasonal_from_date) || (is_array($cx6__cxa_seasonal_from_date) && empty($cx6__cxa_seasonal_from_date))) {
            unset($this->cx6__cxa_seasonal_from_date);
        } else {
            $this->cx6__cxa_seasonal_from_date = $cx6__cxa_seasonal_from_date;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_mailing_label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_mailing_label(): ?string
    {
        return $this->cx6__cxa_mailing_label ?? null;
    }
    /**
     * Set cx6__cxa_mailing_label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_mailing_label
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_mailing_label(?string $cx6__cxa_mailing_label = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_mailing_label) && !is_string($cx6__cxa_mailing_label)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_mailing_label, true), gettype($cx6__cxa_mailing_label)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($cx6__cxa_mailing_label) && mb_strlen((string) $cx6__cxa_mailing_label) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $cx6__cxa_mailing_label)), __LINE__);
        }
        if (is_null($cx6__cxa_mailing_label) || (is_array($cx6__cxa_mailing_label) && empty($cx6__cxa_mailing_label))) {
            unset($this->cx6__cxa_mailing_label);
        } else {
            $this->cx6__cxa_mailing_label = $cx6__cxa_mailing_label;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_seasonal_through_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_seasonal_through_date(): ?string
    {
        return $this->cx6__cxa_seasonal_through_date ?? null;
    }
    /**
     * Set cx6__cxa_seasonal_through_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_seasonal_through_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_seasonal_through_date(?string $cx6__cxa_seasonal_through_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_seasonal_through_date) && !is_string($cx6__cxa_seasonal_through_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_seasonal_through_date, true), gettype($cx6__cxa_seasonal_through_date)), __LINE__);
        }
        if (is_null($cx6__cxa_seasonal_through_date) || (is_array($cx6__cxa_seasonal_through_date) && empty($cx6__cxa_seasonal_through_date))) {
            unset($this->cx6__cxa_seasonal_through_date);
        } else {
            $this->cx6__cxa_seasonal_through_date = $cx6__cxa_seasonal_through_date;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_entity_key(): ?string
    {
        return $this->cx6__cxa_entity_key ?? null;
    }
    /**
     * Set cx6__cxa_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_entity_key(?string $cx6__cxa_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_entity_key) && !is_string($cx6__cxa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_entity_key, true), gettype($cx6__cxa_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cx6__cxa_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cx6__cxa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cx6__cxa_entity_key, true)), __LINE__);
        }
        if (is_null($cx6__cxa_entity_key) || (is_array($cx6__cxa_entity_key) && empty($cx6__cxa_entity_key))) {
            unset($this->cx6__cxa_entity_key);
        } else {
            $this->cx6__cxa_entity_key = $cx6__cxa_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_mail_stop value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_mail_stop(): ?string
    {
        return $this->cx6__cxa_mail_stop ?? null;
    }
    /**
     * Set cx6__cxa_mail_stop value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_mail_stop
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_mail_stop(?string $cx6__cxa_mail_stop = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_mail_stop) && !is_string($cx6__cxa_mail_stop)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_mail_stop, true), gettype($cx6__cxa_mail_stop)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cx6__cxa_mail_stop) && mb_strlen((string) $cx6__cxa_mail_stop) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cx6__cxa_mail_stop)), __LINE__);
        }
        if (is_null($cx6__cxa_mail_stop) || (is_array($cx6__cxa_mail_stop) && empty($cx6__cxa_mail_stop))) {
            unset($this->cx6__cxa_mail_stop);
        } else {
            $this->cx6__cxa_mail_stop = $cx6__cxa_mail_stop;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_mailing_label_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_mailing_label_html(): ?string
    {
        return $this->cx6__cxa_mailing_label_html ?? null;
    }
    /**
     * Set cx6__cxa_mailing_label_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_mailing_label_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_mailing_label_html(?string $cx6__cxa_mailing_label_html = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_mailing_label_html) && !is_string($cx6__cxa_mailing_label_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_mailing_label_html, true), gettype($cx6__cxa_mailing_label_html)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($cx6__cxa_mailing_label_html) && mb_strlen((string) $cx6__cxa_mailing_label_html) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $cx6__cxa_mailing_label_html)), __LINE__);
        }
        if (is_null($cx6__cxa_mailing_label_html) || (is_array($cx6__cxa_mailing_label_html) && empty($cx6__cxa_mailing_label_html))) {
            unset($this->cx6__cxa_mailing_label_html);
        } else {
            $this->cx6__cxa_mailing_label_html = $cx6__cxa_mailing_label_html;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_on_hold_from value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_on_hold_from(): ?string
    {
        return $this->cx6__cxa_on_hold_from ?? null;
    }
    /**
     * Set cx6__cxa_on_hold_from value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_on_hold_from
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_on_hold_from(?string $cx6__cxa_on_hold_from = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_on_hold_from) && !is_string($cx6__cxa_on_hold_from)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_on_hold_from, true), gettype($cx6__cxa_on_hold_from)), __LINE__);
        }
        if (is_null($cx6__cxa_on_hold_from) || (is_array($cx6__cxa_on_hold_from) && empty($cx6__cxa_on_hold_from))) {
            unset($this->cx6__cxa_on_hold_from);
        } else {
            $this->cx6__cxa_on_hold_from = $cx6__cxa_on_hold_from;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_on_hold_through value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_on_hold_through(): ?string
    {
        return $this->cx6__cxa_on_hold_through ?? null;
    }
    /**
     * Set cx6__cxa_on_hold_through value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_on_hold_through
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_on_hold_through(?string $cx6__cxa_on_hold_through = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_on_hold_through) && !is_string($cx6__cxa_on_hold_through)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_on_hold_through, true), gettype($cx6__cxa_on_hold_through)), __LINE__);
        }
        if (is_null($cx6__cxa_on_hold_through) || (is_array($cx6__cxa_on_hold_through) && empty($cx6__cxa_on_hold_through))) {
            unset($this->cx6__cxa_on_hold_through);
        } else {
            $this->cx6__cxa_on_hold_through = $cx6__cxa_on_hold_through;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_primary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_primary(): ?string
    {
        return $this->cx6__cxa_primary ?? null;
    }
    /**
     * Set cx6__cxa_primary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_primary
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_primary(?string $cx6__cxa_primary = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_primary) && !is_string($cx6__cxa_primary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_primary, true), gettype($cx6__cxa_primary)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cx6__cxa_primary) && $cx6__cxa_primary > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cx6__cxa_primary, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cx6__cxa_primary) && $cx6__cxa_primary < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cx6__cxa_primary, true)), __LINE__);
        }
        if (is_null($cx6__cxa_primary) || (is_array($cx6__cxa_primary) && empty($cx6__cxa_primary))) {
            unset($this->cx6__cxa_primary);
        } else {
            $this->cx6__cxa_primary = $cx6__cxa_primary;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_owner(): ?string
    {
        return $this->cx6__cxa_owner ?? null;
    }
    /**
     * Set cx6__cxa_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_owner(?string $cx6__cxa_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_owner) && !is_string($cx6__cxa_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_owner, true), gettype($cx6__cxa_owner)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cx6__cxa_owner) && $cx6__cxa_owner > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cx6__cxa_owner, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cx6__cxa_owner) && $cx6__cxa_owner < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cx6__cxa_owner, true)), __LINE__);
        }
        if (is_null($cx6__cxa_owner) || (is_array($cx6__cxa_owner) && empty($cx6__cxa_owner))) {
            unset($this->cx6__cxa_owner);
        } else {
            $this->cx6__cxa_owner = $cx6__cxa_owner;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_billing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_billing(): ?string
    {
        return $this->cx6__cxa_billing ?? null;
    }
    /**
     * Set cx6__cxa_billing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_billing
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_billing(?string $cx6__cxa_billing = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_billing) && !is_string($cx6__cxa_billing)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_billing, true), gettype($cx6__cxa_billing)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cx6__cxa_billing) && $cx6__cxa_billing > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cx6__cxa_billing, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cx6__cxa_billing) && $cx6__cxa_billing < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cx6__cxa_billing, true)), __LINE__);
        }
        if (is_null($cx6__cxa_billing) || (is_array($cx6__cxa_billing) && empty($cx6__cxa_billing))) {
            unset($this->cx6__cxa_billing);
        } else {
            $this->cx6__cxa_billing = $cx6__cxa_billing;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_create_change_log value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_create_change_log(): ?string
    {
        return $this->cx6__cxa_create_change_log ?? null;
    }
    /**
     * Set cx6__cxa_create_change_log value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_create_change_log
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_create_change_log(?string $cx6__cxa_create_change_log = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_create_change_log) && !is_string($cx6__cxa_create_change_log)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_create_change_log, true), gettype($cx6__cxa_create_change_log)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cx6__cxa_create_change_log) && $cx6__cxa_create_change_log > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cx6__cxa_create_change_log, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cx6__cxa_create_change_log) && $cx6__cxa_create_change_log < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cx6__cxa_create_change_log, true)), __LINE__);
        }
        if (is_null($cx6__cxa_create_change_log) || (is_array($cx6__cxa_create_change_log) && empty($cx6__cxa_create_change_log))) {
            unset($this->cx6__cxa_create_change_log);
        } else {
            $this->cx6__cxa_create_change_log = $cx6__cxa_create_change_log;
        }
        
        return $this;
    }
    /**
     * Get cx6__cxa_AddressLinkingDropDownList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCx6__cxa_AddressLinkingDropDownList(): ?string
    {
        return $this->cx6__cxa_AddressLinkingDropDownList ?? null;
    }
    /**
     * Set cx6__cxa_AddressLinkingDropDownList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cx6__cxa_AddressLinkingDropDownList
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Business_Address_XRef_DataObjectType
     */
    public function setCx6__cxa_AddressLinkingDropDownList(?string $cx6__cxa_AddressLinkingDropDownList = null): self
    {
        // validation for constraint: string
        if (!is_null($cx6__cxa_AddressLinkingDropDownList) && !is_string($cx6__cxa_AddressLinkingDropDownList)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cx6__cxa_AddressLinkingDropDownList, true), gettype($cx6__cxa_AddressLinkingDropDownList)), __LINE__);
        }
        if (is_null($cx6__cxa_AddressLinkingDropDownList) || (is_array($cx6__cxa_AddressLinkingDropDownList) && empty($cx6__cxa_AddressLinkingDropDownList))) {
            unset($this->cx6__cxa_AddressLinkingDropDownList);
        } else {
            $this->cx6__cxa_AddressLinkingDropDownList = $cx6__cxa_AddressLinkingDropDownList;
        }
        
        return $this;
    }
}
