<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Org_Messaging_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Org_Messaging_DataObjectType extends AbstractStructBase
{
    /**
     * The ms6__msg_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ms6__msg_key = null;
    /**
     * The ms6__msg_handle
     * Meta information extracted from the WSDL
     * - documentation: IM handle. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ms6__msg_handle = null;
    /**
     * The ms6__msg_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ms6__msg_cst_key = null;
    /**
     * The ms6__msg_type
     * Meta information extracted from the WSDL
     * - documentation: IM Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ms6__msg_type = null;
    /**
     * The ms6__msg_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ms6__msg_add_user = null;
    /**
     * The ms6__msg_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ms6__msg_add_date = null;
    /**
     * The ms6__msg_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ms6__msg_change_user = null;
    /**
     * The ms6__msg_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ms6__msg_change_date = null;
    /**
     * The ms6__msg_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ms6__msg_delete_flag = null;
    /**
     * The ms6__msg_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ms6__msg_key_ext = null;
    /**
     * The ms6__msg_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ms6__msg_entity_key = null;
    /**
     * The ms6__msg_primary
     * Meta information extracted from the WSDL
     * - documentation: Primary.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ms6__msg_primary = null;
    /**
     * Constructor method for FundraisingGift_Org_Messaging_DataObjectType
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_key()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_handle()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_cst_key()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_type()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_add_user()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_add_date()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_change_user()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_change_date()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_delete_flag()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_key_ext()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_entity_key()
     * @uses FundraisingGift_Org_Messaging_DataObjectType::setMs6__msg_primary()
     * @param string $ms6__msg_key
     * @param string $ms6__msg_handle
     * @param string $ms6__msg_cst_key
     * @param string $ms6__msg_type
     * @param string $ms6__msg_add_user
     * @param string $ms6__msg_add_date
     * @param string $ms6__msg_change_user
     * @param string $ms6__msg_change_date
     * @param string $ms6__msg_delete_flag
     * @param string $ms6__msg_key_ext
     * @param string $ms6__msg_entity_key
     * @param string $ms6__msg_primary
     */
    public function __construct(?string $ms6__msg_key = null, ?string $ms6__msg_handle = null, ?string $ms6__msg_cst_key = null, ?string $ms6__msg_type = null, ?string $ms6__msg_add_user = null, ?string $ms6__msg_add_date = null, ?string $ms6__msg_change_user = null, ?string $ms6__msg_change_date = null, ?string $ms6__msg_delete_flag = null, ?string $ms6__msg_key_ext = null, ?string $ms6__msg_entity_key = null, ?string $ms6__msg_primary = null)
    {
        $this
            ->setMs6__msg_key($ms6__msg_key)
            ->setMs6__msg_handle($ms6__msg_handle)
            ->setMs6__msg_cst_key($ms6__msg_cst_key)
            ->setMs6__msg_type($ms6__msg_type)
            ->setMs6__msg_add_user($ms6__msg_add_user)
            ->setMs6__msg_add_date($ms6__msg_add_date)
            ->setMs6__msg_change_user($ms6__msg_change_user)
            ->setMs6__msg_change_date($ms6__msg_change_date)
            ->setMs6__msg_delete_flag($ms6__msg_delete_flag)
            ->setMs6__msg_key_ext($ms6__msg_key_ext)
            ->setMs6__msg_entity_key($ms6__msg_entity_key)
            ->setMs6__msg_primary($ms6__msg_primary);
    }
    /**
     * Get ms6__msg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_key(): ?string
    {
        return $this->ms6__msg_key ?? null;
    }
    /**
     * Set ms6__msg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_key(?string $ms6__msg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_key) && !is_string($ms6__msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_key, true), gettype($ms6__msg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ms6__msg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ms6__msg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ms6__msg_key, true)), __LINE__);
        }
        if (is_null($ms6__msg_key) || (is_array($ms6__msg_key) && empty($ms6__msg_key))) {
            unset($this->ms6__msg_key);
        } else {
            $this->ms6__msg_key = $ms6__msg_key;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_handle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_handle(): ?string
    {
        return $this->ms6__msg_handle ?? null;
    }
    /**
     * Set ms6__msg_handle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_handle
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_handle(?string $ms6__msg_handle = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_handle) && !is_string($ms6__msg_handle)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_handle, true), gettype($ms6__msg_handle)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ms6__msg_handle) && mb_strlen((string) $ms6__msg_handle) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ms6__msg_handle)), __LINE__);
        }
        if (is_null($ms6__msg_handle) || (is_array($ms6__msg_handle) && empty($ms6__msg_handle))) {
            unset($this->ms6__msg_handle);
        } else {
            $this->ms6__msg_handle = $ms6__msg_handle;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_cst_key(): ?string
    {
        return $this->ms6__msg_cst_key ?? null;
    }
    /**
     * Set ms6__msg_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_cst_key(?string $ms6__msg_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_cst_key) && !is_string($ms6__msg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_cst_key, true), gettype($ms6__msg_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ms6__msg_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ms6__msg_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ms6__msg_cst_key, true)), __LINE__);
        }
        if (is_null($ms6__msg_cst_key) || (is_array($ms6__msg_cst_key) && empty($ms6__msg_cst_key))) {
            unset($this->ms6__msg_cst_key);
        } else {
            $this->ms6__msg_cst_key = $ms6__msg_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_type(): ?string
    {
        return $this->ms6__msg_type ?? null;
    }
    /**
     * Set ms6__msg_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_type(?string $ms6__msg_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_type) && !is_string($ms6__msg_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_type, true), gettype($ms6__msg_type)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ms6__msg_type) && mb_strlen((string) $ms6__msg_type) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $ms6__msg_type)), __LINE__);
        }
        if (is_null($ms6__msg_type) || (is_array($ms6__msg_type) && empty($ms6__msg_type))) {
            unset($this->ms6__msg_type);
        } else {
            $this->ms6__msg_type = $ms6__msg_type;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_add_user(): ?string
    {
        return $this->ms6__msg_add_user ?? null;
    }
    /**
     * Set ms6__msg_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_add_user(?string $ms6__msg_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_add_user) && !is_string($ms6__msg_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_add_user, true), gettype($ms6__msg_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ms6__msg_add_user) && mb_strlen((string) $ms6__msg_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ms6__msg_add_user)), __LINE__);
        }
        if (is_null($ms6__msg_add_user) || (is_array($ms6__msg_add_user) && empty($ms6__msg_add_user))) {
            unset($this->ms6__msg_add_user);
        } else {
            $this->ms6__msg_add_user = $ms6__msg_add_user;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_add_date(): ?string
    {
        return $this->ms6__msg_add_date ?? null;
    }
    /**
     * Set ms6__msg_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_add_date(?string $ms6__msg_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_add_date) && !is_string($ms6__msg_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_add_date, true), gettype($ms6__msg_add_date)), __LINE__);
        }
        if (is_null($ms6__msg_add_date) || (is_array($ms6__msg_add_date) && empty($ms6__msg_add_date))) {
            unset($this->ms6__msg_add_date);
        } else {
            $this->ms6__msg_add_date = $ms6__msg_add_date;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_change_user(): ?string
    {
        return $this->ms6__msg_change_user ?? null;
    }
    /**
     * Set ms6__msg_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_change_user(?string $ms6__msg_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_change_user) && !is_string($ms6__msg_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_change_user, true), gettype($ms6__msg_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ms6__msg_change_user) && mb_strlen((string) $ms6__msg_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ms6__msg_change_user)), __LINE__);
        }
        if (is_null($ms6__msg_change_user) || (is_array($ms6__msg_change_user) && empty($ms6__msg_change_user))) {
            unset($this->ms6__msg_change_user);
        } else {
            $this->ms6__msg_change_user = $ms6__msg_change_user;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_change_date(): ?string
    {
        return $this->ms6__msg_change_date ?? null;
    }
    /**
     * Set ms6__msg_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_change_date(?string $ms6__msg_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_change_date) && !is_string($ms6__msg_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_change_date, true), gettype($ms6__msg_change_date)), __LINE__);
        }
        if (is_null($ms6__msg_change_date) || (is_array($ms6__msg_change_date) && empty($ms6__msg_change_date))) {
            unset($this->ms6__msg_change_date);
        } else {
            $this->ms6__msg_change_date = $ms6__msg_change_date;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_delete_flag(): ?string
    {
        return $this->ms6__msg_delete_flag ?? null;
    }
    /**
     * Set ms6__msg_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_delete_flag(?string $ms6__msg_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_delete_flag) && !is_string($ms6__msg_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_delete_flag, true), gettype($ms6__msg_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ms6__msg_delete_flag) && $ms6__msg_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ms6__msg_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ms6__msg_delete_flag) && $ms6__msg_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ms6__msg_delete_flag, true)), __LINE__);
        }
        if (is_null($ms6__msg_delete_flag) || (is_array($ms6__msg_delete_flag) && empty($ms6__msg_delete_flag))) {
            unset($this->ms6__msg_delete_flag);
        } else {
            $this->ms6__msg_delete_flag = $ms6__msg_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_key_ext(): ?string
    {
        return $this->ms6__msg_key_ext ?? null;
    }
    /**
     * Set ms6__msg_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_key_ext(?string $ms6__msg_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_key_ext) && !is_string($ms6__msg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_key_ext, true), gettype($ms6__msg_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ms6__msg_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ms6__msg_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ms6__msg_key_ext, true)), __LINE__);
        }
        if (is_null($ms6__msg_key_ext) || (is_array($ms6__msg_key_ext) && empty($ms6__msg_key_ext))) {
            unset($this->ms6__msg_key_ext);
        } else {
            $this->ms6__msg_key_ext = $ms6__msg_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_entity_key(): ?string
    {
        return $this->ms6__msg_entity_key ?? null;
    }
    /**
     * Set ms6__msg_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_entity_key(?string $ms6__msg_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_entity_key) && !is_string($ms6__msg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_entity_key, true), gettype($ms6__msg_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ms6__msg_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ms6__msg_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ms6__msg_entity_key, true)), __LINE__);
        }
        if (is_null($ms6__msg_entity_key) || (is_array($ms6__msg_entity_key) && empty($ms6__msg_entity_key))) {
            unset($this->ms6__msg_entity_key);
        } else {
            $this->ms6__msg_entity_key = $ms6__msg_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ms6__msg_primary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMs6__msg_primary(): ?string
    {
        return $this->ms6__msg_primary ?? null;
    }
    /**
     * Set ms6__msg_primary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ms6__msg_primary
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Org_Messaging_DataObjectType
     */
    public function setMs6__msg_primary(?string $ms6__msg_primary = null): self
    {
        // validation for constraint: string
        if (!is_null($ms6__msg_primary) && !is_string($ms6__msg_primary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ms6__msg_primary, true), gettype($ms6__msg_primary)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ms6__msg_primary) && $ms6__msg_primary > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ms6__msg_primary, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ms6__msg_primary) && $ms6__msg_primary < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ms6__msg_primary, true)), __LINE__);
        }
        if (is_null($ms6__msg_primary) || (is_array($ms6__msg_primary) && empty($ms6__msg_primary))) {
            unset($this->ms6__msg_primary);
        } else {
            $this->ms6__msg_primary = $ms6__msg_primary;
        }
        
        return $this;
    }
}
