<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundraisingGift_Premium_Price_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class FundraisingGift_Premium_Price_DataObjectType extends AbstractStructBase
{
    /**
     * The pr2__prc_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_key = null;
    /**
     * The pr2__prc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_prd_key = null;
    /**
     * The pr2__prc_price
     * Meta information extracted from the WSDL
     * - documentation: Price/Rate.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $pr2__prc_price = null;
    /**
     * The pr2__prc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_add_user = null;
    /**
     * The pr2__prc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_add_date = null;
    /**
     * The pr2__prc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_change_user = null;
    /**
     * The pr2__prc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_change_date = null;
    /**
     * The pr2__prc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_delete_flag = null;
    /**
     * The pr2__prc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_key_ext = null;
    /**
     * The pr2__prc_gla_ar_key
     * Meta information extracted from the WSDL
     * - documentation: A/R Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_gla_ar_key = null;
    /**
     * The pr2__prc_gla_revenue_key
     * Meta information extracted from the WSDL
     * - documentation: Revenue Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_gla_revenue_key = null;
    /**
     * The pr2__prc_gla_liability_key
     * Meta information extracted from the WSDL
     * - documentation: Liability Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_gla_liability_key = null;
    /**
     * The pr2__prc_gla_return_key
     * Meta information extracted from the WSDL
     * - documentation: Return Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_gla_return_key = null;
    /**
     * The pr2__prc_gla_writeoff_key
     * Meta information extracted from the WSDL
     * - documentation: Write Off Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_gla_writeoff_key = null;
    /**
     * The pr2__prc_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_start_date = null;
    /**
     * The pr2__prc_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_end_date = null;
    /**
     * The pr2__prc_ptr_key
     * Meta information extracted from the WSDL
     * - documentation: Term Length. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_ptr_key = null;
    /**
     * The pr2__prc_num_issues
     * Meta information extracted from the WSDL
     * - documentation: Number of Issues. This field has this Input Mask: 9,999,999. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $pr2__prc_num_issues = null;
    /**
     * The pr2__prc_prd_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_prd_ptp_key = null;
    /**
     * The pr2__prc_percent
     * Meta information extracted from the WSDL
     * - documentation: Percentage. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $pr2__prc_percent = null;
    /**
     * The pr2__prc_percent_cp
     * Meta information extracted from the WSDL
     * - documentation: percent. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $pr2__prc_percent_cp = null;
    /**
     * The pr2__prc_prd_atc_key
     * Meta information extracted from the WSDL
     * - documentation: Business Unit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_prd_atc_key = null;
    /**
     * The pr2__prc_code
     * Meta information extracted from the WSDL
     * - documentation: Price Lookup Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_code = null;
    /**
     * The pr2__prc_display_name
     * Meta information extracted from the WSDL
     * - documentation: Display Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_display_name = null;
    /**
     * The pr2__prc_sell_online
     * Meta information extracted from the WSDL
     * - documentation: Sell Online. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_sell_online = null;
    /**
     * The pr2__prc_gla_deferred_key
     * Meta information extracted from the WSDL
     * - documentation: Deferred Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_gla_deferred_key = null;
    /**
     * The pr2__prc_deferred_flag
     * Meta information extracted from the WSDL
     * - documentation: Deferred?.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_deferred_flag = null;
    /**
     * The pr2__prc_mail
     * Meta information extracted from the WSDL
     * - documentation: send via mail. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_mail = null;
    /**
     * The pr2__prc_email
     * Meta information extracted from the WSDL
     * - documentation: send via email. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_email = null;
    /**
     * The pr2__prc_fax
     * Meta information extracted from the WSDL
     * - documentation: send via fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_fax = null;
    /**
     * The pr2__prc_thumbnail
     * Meta information extracted from the WSDL
     * - documentation: Thumbnail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_thumbnail = null;
    /**
     * The pr2__prc_online_abstract
     * Meta information extracted from the WSDL
     * - documentation: Online Abstract. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_online_abstract = null;
    /**
     * The pr2__prc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_entity_key = null;
    /**
     * The pr2__prc_qty_min
     * Meta information extracted from the WSDL
     * - documentation: Minimum Quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $pr2__prc_qty_min = null;
    /**
     * The pr2__prc_qty_max
     * Meta information extracted from the WSDL
     * - documentation: Maximum Quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $pr2__prc_qty_max = null;
    /**
     * The pr2__prc_recognize_after_date
     * Meta information extracted from the WSDL
     * - documentation: Recognize Revenue After Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_recognize_after_date = null;
    /**
     * The pr2__prc_account_split_flag
     * Meta information extracted from the WSDL
     * - documentation: Split Revenue. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_account_split_flag = null;
    /**
     * The pr2__prc_prorate_flag
     * Meta information extracted from the WSDL
     * - documentation: Proration Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_prorate_flag = null;
    /**
     * The pr2__prc_prorate_first_year_flag
     * Meta information extracted from the WSDL
     * - documentation: Prorate in First Year. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_prorate_first_year_flag = null;
    /**
     * The pr2__prc_web
     * Meta information extracted from the WSDL
     * - documentation: send via web. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_web = null;
    /**
     * The pr2__prc_microfiche
     * Meta information extracted from the WSDL
     * - documentation: send via microfiche. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_microfiche = null;
    /**
     * The pr2__prc_revenue_recog_frequency
     * Meta information extracted from the WSDL
     * - documentation: revenue recog frequency. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $pr2__prc_revenue_recog_frequency = null;
    /**
     * The pr2__prc_allow_installment
     * Meta information extracted from the WSDL
     * - documentation: allow installment. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_allow_installment = null;
    /**
     * The pr2__prc_pjt_key
     * Meta information extracted from the WSDL
     * - documentation: Project. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_pjt_key = null;
    /**
     * The pr2__prc_shippable_flag
     * Meta information extracted from the WSDL
     * - documentation: shippable. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_shippable_flag = null;
    /**
     * The pr2__prc_eweb_code
     * Meta information extracted from the WSDL
     * - documentation: eweb code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_eweb_code = null;
    /**
     * The pr2__prc_weight_min
     * Meta information extracted from the WSDL
     * - documentation: Minimum Weight. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $pr2__prc_weight_min = null;
    /**
     * The pr2__prc_weight_max
     * Meta information extracted from the WSDL
     * - documentation: Maximum Weight. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $pr2__prc_weight_max = null;
    /**
     * The pr2__prc_recognize_by_issue_flag
     * Meta information extracted from the WSDL
     * - documentation: Recognize Revenue by Issue. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_recognize_by_issue_flag = null;
    /**
     * The pr2__prc_num_grace_issues
     * Meta information extracted from the WSDL
     * - documentation: Number of Grace Issues. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $pr2__prc_num_grace_issues = null;
    /**
     * The pr2__prc_back_issue_flag
     * Meta information extracted from the WSDL
     * - documentation: Back Issue Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_back_issue_flag = null;
    /**
     * The pr2__prc_renew_unpaid_orders_flag
     * Meta information extracted from the WSDL
     * - documentation: Renew Unpaid Orders.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_renew_unpaid_orders_flag = null;
    /**
     * The pr2__prc_allow_unpaid_orders_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow Unpaid Orders.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_allow_unpaid_orders_flag = null;
    /**
     * The pr2__prc_deferral_num_years
     * Meta information extracted from the WSDL
     * - documentation: years for deferral. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $pr2__prc_deferral_num_years = null;
    /**
     * The pr2__prc_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_cur_key = null;
    /**
     * The pr2__prc_award_credit_flag
     * Meta information extracted from the WSDL
     * - documentation: Award Credit Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_award_credit_flag = null;
    /**
     * The pr2__prc_deferral_num_issues
     * Meta information extracted from the WSDL
     * - documentation: issues for deferral. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $pr2__prc_deferral_num_issues = null;
    /**
     * The pr2__prc_allow_sync_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow sync with National Membe. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_allow_sync_flag = null;
    /**
     * The pr2__prc_cct_key
     * Meta information extracted from the WSDL
     * - documentation: Correspondence Template. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_cct_key = null;
    /**
     * The pr2__prc_no_discount_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Discount. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pr2__prc_no_discount_flag = null;
    /**
     * The pr2__prc_pcl_key
     * Meta information extracted from the WSDL
     * - documentation: Class. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_pcl_key = null;
    /**
     * The pr2__prc_pde_key
     * Meta information extracted from the WSDL
     * - documentation: Department. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_pde_key = null;
    /**
     * The pr2__prc_plo_key
     * Meta information extracted from the WSDL
     * - documentation: Location. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pr2__prc_plo_key = null;
    /**
     * Constructor method for FundraisingGift_Premium_Price_DataObjectType
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_prd_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_price()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_add_user()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_add_date()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_change_user()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_change_date()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_delete_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_key_ext()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_gla_ar_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_gla_revenue_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_gla_liability_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_gla_return_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_gla_writeoff_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_start_date()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_end_date()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_ptr_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_num_issues()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_prd_ptp_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_percent()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_percent_cp()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_prd_atc_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_code()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_display_name()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_sell_online()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_gla_deferred_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_deferred_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_mail()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_email()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_fax()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_thumbnail()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_online_abstract()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_entity_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_qty_min()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_qty_max()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_recognize_after_date()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_account_split_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_prorate_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_prorate_first_year_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_web()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_microfiche()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_revenue_recog_frequency()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_allow_installment()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_pjt_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_shippable_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_eweb_code()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_weight_min()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_weight_max()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_recognize_by_issue_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_num_grace_issues()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_back_issue_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_renew_unpaid_orders_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_allow_unpaid_orders_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_deferral_num_years()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_cur_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_award_credit_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_deferral_num_issues()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_allow_sync_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_cct_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_no_discount_flag()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_pcl_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_pde_key()
     * @uses FundraisingGift_Premium_Price_DataObjectType::setPr2__prc_plo_key()
     * @param string $pr2__prc_key
     * @param string $pr2__prc_prd_key
     * @param float $pr2__prc_price
     * @param string $pr2__prc_add_user
     * @param string $pr2__prc_add_date
     * @param string $pr2__prc_change_user
     * @param string $pr2__prc_change_date
     * @param string $pr2__prc_delete_flag
     * @param string $pr2__prc_key_ext
     * @param string $pr2__prc_gla_ar_key
     * @param string $pr2__prc_gla_revenue_key
     * @param string $pr2__prc_gla_liability_key
     * @param string $pr2__prc_gla_return_key
     * @param string $pr2__prc_gla_writeoff_key
     * @param string $pr2__prc_start_date
     * @param string $pr2__prc_end_date
     * @param string $pr2__prc_ptr_key
     * @param int $pr2__prc_num_issues
     * @param string $pr2__prc_prd_ptp_key
     * @param float $pr2__prc_percent
     * @param float $pr2__prc_percent_cp
     * @param string $pr2__prc_prd_atc_key
     * @param string $pr2__prc_code
     * @param string $pr2__prc_display_name
     * @param string $pr2__prc_sell_online
     * @param string $pr2__prc_gla_deferred_key
     * @param string $pr2__prc_deferred_flag
     * @param string $pr2__prc_mail
     * @param string $pr2__prc_email
     * @param string $pr2__prc_fax
     * @param string $pr2__prc_thumbnail
     * @param string $pr2__prc_online_abstract
     * @param string $pr2__prc_entity_key
     * @param float $pr2__prc_qty_min
     * @param float $pr2__prc_qty_max
     * @param string $pr2__prc_recognize_after_date
     * @param string $pr2__prc_account_split_flag
     * @param string $pr2__prc_prorate_flag
     * @param string $pr2__prc_prorate_first_year_flag
     * @param string $pr2__prc_web
     * @param string $pr2__prc_microfiche
     * @param int $pr2__prc_revenue_recog_frequency
     * @param string $pr2__prc_allow_installment
     * @param string $pr2__prc_pjt_key
     * @param string $pr2__prc_shippable_flag
     * @param string $pr2__prc_eweb_code
     * @param float $pr2__prc_weight_min
     * @param float $pr2__prc_weight_max
     * @param string $pr2__prc_recognize_by_issue_flag
     * @param int $pr2__prc_num_grace_issues
     * @param string $pr2__prc_back_issue_flag
     * @param string $pr2__prc_renew_unpaid_orders_flag
     * @param string $pr2__prc_allow_unpaid_orders_flag
     * @param int $pr2__prc_deferral_num_years
     * @param string $pr2__prc_cur_key
     * @param string $pr2__prc_award_credit_flag
     * @param int $pr2__prc_deferral_num_issues
     * @param string $pr2__prc_allow_sync_flag
     * @param string $pr2__prc_cct_key
     * @param string $pr2__prc_no_discount_flag
     * @param string $pr2__prc_pcl_key
     * @param string $pr2__prc_pde_key
     * @param string $pr2__prc_plo_key
     */
    public function __construct(?string $pr2__prc_key = null, ?string $pr2__prc_prd_key = null, ?float $pr2__prc_price = null, ?string $pr2__prc_add_user = null, ?string $pr2__prc_add_date = null, ?string $pr2__prc_change_user = null, ?string $pr2__prc_change_date = null, ?string $pr2__prc_delete_flag = null, ?string $pr2__prc_key_ext = null, ?string $pr2__prc_gla_ar_key = null, ?string $pr2__prc_gla_revenue_key = null, ?string $pr2__prc_gla_liability_key = null, ?string $pr2__prc_gla_return_key = null, ?string $pr2__prc_gla_writeoff_key = null, ?string $pr2__prc_start_date = null, ?string $pr2__prc_end_date = null, ?string $pr2__prc_ptr_key = null, ?int $pr2__prc_num_issues = null, ?string $pr2__prc_prd_ptp_key = null, ?float $pr2__prc_percent = null, ?float $pr2__prc_percent_cp = null, ?string $pr2__prc_prd_atc_key = null, ?string $pr2__prc_code = null, ?string $pr2__prc_display_name = null, ?string $pr2__prc_sell_online = null, ?string $pr2__prc_gla_deferred_key = null, ?string $pr2__prc_deferred_flag = null, ?string $pr2__prc_mail = null, ?string $pr2__prc_email = null, ?string $pr2__prc_fax = null, ?string $pr2__prc_thumbnail = null, ?string $pr2__prc_online_abstract = null, ?string $pr2__prc_entity_key = null, ?float $pr2__prc_qty_min = null, ?float $pr2__prc_qty_max = null, ?string $pr2__prc_recognize_after_date = null, ?string $pr2__prc_account_split_flag = null, ?string $pr2__prc_prorate_flag = null, ?string $pr2__prc_prorate_first_year_flag = null, ?string $pr2__prc_web = null, ?string $pr2__prc_microfiche = null, ?int $pr2__prc_revenue_recog_frequency = null, ?string $pr2__prc_allow_installment = null, ?string $pr2__prc_pjt_key = null, ?string $pr2__prc_shippable_flag = null, ?string $pr2__prc_eweb_code = null, ?float $pr2__prc_weight_min = null, ?float $pr2__prc_weight_max = null, ?string $pr2__prc_recognize_by_issue_flag = null, ?int $pr2__prc_num_grace_issues = null, ?string $pr2__prc_back_issue_flag = null, ?string $pr2__prc_renew_unpaid_orders_flag = null, ?string $pr2__prc_allow_unpaid_orders_flag = null, ?int $pr2__prc_deferral_num_years = null, ?string $pr2__prc_cur_key = null, ?string $pr2__prc_award_credit_flag = null, ?int $pr2__prc_deferral_num_issues = null, ?string $pr2__prc_allow_sync_flag = null, ?string $pr2__prc_cct_key = null, ?string $pr2__prc_no_discount_flag = null, ?string $pr2__prc_pcl_key = null, ?string $pr2__prc_pde_key = null, ?string $pr2__prc_plo_key = null)
    {
        $this
            ->setPr2__prc_key($pr2__prc_key)
            ->setPr2__prc_prd_key($pr2__prc_prd_key)
            ->setPr2__prc_price($pr2__prc_price)
            ->setPr2__prc_add_user($pr2__prc_add_user)
            ->setPr2__prc_add_date($pr2__prc_add_date)
            ->setPr2__prc_change_user($pr2__prc_change_user)
            ->setPr2__prc_change_date($pr2__prc_change_date)
            ->setPr2__prc_delete_flag($pr2__prc_delete_flag)
            ->setPr2__prc_key_ext($pr2__prc_key_ext)
            ->setPr2__prc_gla_ar_key($pr2__prc_gla_ar_key)
            ->setPr2__prc_gla_revenue_key($pr2__prc_gla_revenue_key)
            ->setPr2__prc_gla_liability_key($pr2__prc_gla_liability_key)
            ->setPr2__prc_gla_return_key($pr2__prc_gla_return_key)
            ->setPr2__prc_gla_writeoff_key($pr2__prc_gla_writeoff_key)
            ->setPr2__prc_start_date($pr2__prc_start_date)
            ->setPr2__prc_end_date($pr2__prc_end_date)
            ->setPr2__prc_ptr_key($pr2__prc_ptr_key)
            ->setPr2__prc_num_issues($pr2__prc_num_issues)
            ->setPr2__prc_prd_ptp_key($pr2__prc_prd_ptp_key)
            ->setPr2__prc_percent($pr2__prc_percent)
            ->setPr2__prc_percent_cp($pr2__prc_percent_cp)
            ->setPr2__prc_prd_atc_key($pr2__prc_prd_atc_key)
            ->setPr2__prc_code($pr2__prc_code)
            ->setPr2__prc_display_name($pr2__prc_display_name)
            ->setPr2__prc_sell_online($pr2__prc_sell_online)
            ->setPr2__prc_gla_deferred_key($pr2__prc_gla_deferred_key)
            ->setPr2__prc_deferred_flag($pr2__prc_deferred_flag)
            ->setPr2__prc_mail($pr2__prc_mail)
            ->setPr2__prc_email($pr2__prc_email)
            ->setPr2__prc_fax($pr2__prc_fax)
            ->setPr2__prc_thumbnail($pr2__prc_thumbnail)
            ->setPr2__prc_online_abstract($pr2__prc_online_abstract)
            ->setPr2__prc_entity_key($pr2__prc_entity_key)
            ->setPr2__prc_qty_min($pr2__prc_qty_min)
            ->setPr2__prc_qty_max($pr2__prc_qty_max)
            ->setPr2__prc_recognize_after_date($pr2__prc_recognize_after_date)
            ->setPr2__prc_account_split_flag($pr2__prc_account_split_flag)
            ->setPr2__prc_prorate_flag($pr2__prc_prorate_flag)
            ->setPr2__prc_prorate_first_year_flag($pr2__prc_prorate_first_year_flag)
            ->setPr2__prc_web($pr2__prc_web)
            ->setPr2__prc_microfiche($pr2__prc_microfiche)
            ->setPr2__prc_revenue_recog_frequency($pr2__prc_revenue_recog_frequency)
            ->setPr2__prc_allow_installment($pr2__prc_allow_installment)
            ->setPr2__prc_pjt_key($pr2__prc_pjt_key)
            ->setPr2__prc_shippable_flag($pr2__prc_shippable_flag)
            ->setPr2__prc_eweb_code($pr2__prc_eweb_code)
            ->setPr2__prc_weight_min($pr2__prc_weight_min)
            ->setPr2__prc_weight_max($pr2__prc_weight_max)
            ->setPr2__prc_recognize_by_issue_flag($pr2__prc_recognize_by_issue_flag)
            ->setPr2__prc_num_grace_issues($pr2__prc_num_grace_issues)
            ->setPr2__prc_back_issue_flag($pr2__prc_back_issue_flag)
            ->setPr2__prc_renew_unpaid_orders_flag($pr2__prc_renew_unpaid_orders_flag)
            ->setPr2__prc_allow_unpaid_orders_flag($pr2__prc_allow_unpaid_orders_flag)
            ->setPr2__prc_deferral_num_years($pr2__prc_deferral_num_years)
            ->setPr2__prc_cur_key($pr2__prc_cur_key)
            ->setPr2__prc_award_credit_flag($pr2__prc_award_credit_flag)
            ->setPr2__prc_deferral_num_issues($pr2__prc_deferral_num_issues)
            ->setPr2__prc_allow_sync_flag($pr2__prc_allow_sync_flag)
            ->setPr2__prc_cct_key($pr2__prc_cct_key)
            ->setPr2__prc_no_discount_flag($pr2__prc_no_discount_flag)
            ->setPr2__prc_pcl_key($pr2__prc_pcl_key)
            ->setPr2__prc_pde_key($pr2__prc_pde_key)
            ->setPr2__prc_plo_key($pr2__prc_plo_key);
    }
    /**
     * Get pr2__prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_key(): ?string
    {
        return $this->pr2__prc_key ?? null;
    }
    /**
     * Set pr2__prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_key(?string $pr2__prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_key) && !is_string($pr2__prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_key, true), gettype($pr2__prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_key) || (is_array($pr2__prc_key) && empty($pr2__prc_key))) {
            unset($this->pr2__prc_key);
        } else {
            $this->pr2__prc_key = $pr2__prc_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_prd_key(): ?string
    {
        return $this->pr2__prc_prd_key ?? null;
    }
    /**
     * Set pr2__prc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_prd_key(?string $pr2__prc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_prd_key) && !is_string($pr2__prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_prd_key, true), gettype($pr2__prc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_prd_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_prd_key) || (is_array($pr2__prc_prd_key) && empty($pr2__prc_prd_key))) {
            unset($this->pr2__prc_prd_key);
        } else {
            $this->pr2__prc_prd_key = $pr2__prc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPr2__prc_price(): ?float
    {
        return $this->pr2__prc_price ?? null;
    }
    /**
     * Set pr2__prc_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pr2__prc_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_price(?float $pr2__prc_price = null): self
    {
        // validation for constraint: float
        if (!is_null($pr2__prc_price) && !(is_float($pr2__prc_price) || is_numeric($pr2__prc_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pr2__prc_price, true), gettype($pr2__prc_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pr2__prc_price) && mb_strlen(mb_substr((string) $pr2__prc_price, false !== mb_strpos((string) $pr2__prc_price, '.') ? mb_strpos((string) $pr2__prc_price, '.') + 1 : mb_strlen((string) $pr2__prc_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pr2__prc_price, true), mb_strlen(mb_substr((string) $pr2__prc_price, mb_strpos((string) $pr2__prc_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($pr2__prc_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($pr2__prc_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_price))), __LINE__);
        }
        if (is_null($pr2__prc_price) || (is_array($pr2__prc_price) && empty($pr2__prc_price))) {
            unset($this->pr2__prc_price);
        } else {
            $this->pr2__prc_price = $pr2__prc_price;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_add_user(): ?string
    {
        return $this->pr2__prc_add_user ?? null;
    }
    /**
     * Set pr2__prc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_add_user(?string $pr2__prc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_add_user) && !is_string($pr2__prc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_add_user, true), gettype($pr2__prc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pr2__prc_add_user) && mb_strlen((string) $pr2__prc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pr2__prc_add_user)), __LINE__);
        }
        if (is_null($pr2__prc_add_user) || (is_array($pr2__prc_add_user) && empty($pr2__prc_add_user))) {
            unset($this->pr2__prc_add_user);
        } else {
            $this->pr2__prc_add_user = $pr2__prc_add_user;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_add_date(): ?string
    {
        return $this->pr2__prc_add_date ?? null;
    }
    /**
     * Set pr2__prc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_add_date(?string $pr2__prc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_add_date) && !is_string($pr2__prc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_add_date, true), gettype($pr2__prc_add_date)), __LINE__);
        }
        if (is_null($pr2__prc_add_date) || (is_array($pr2__prc_add_date) && empty($pr2__prc_add_date))) {
            unset($this->pr2__prc_add_date);
        } else {
            $this->pr2__prc_add_date = $pr2__prc_add_date;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_change_user(): ?string
    {
        return $this->pr2__prc_change_user ?? null;
    }
    /**
     * Set pr2__prc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_change_user(?string $pr2__prc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_change_user) && !is_string($pr2__prc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_change_user, true), gettype($pr2__prc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pr2__prc_change_user) && mb_strlen((string) $pr2__prc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pr2__prc_change_user)), __LINE__);
        }
        if (is_null($pr2__prc_change_user) || (is_array($pr2__prc_change_user) && empty($pr2__prc_change_user))) {
            unset($this->pr2__prc_change_user);
        } else {
            $this->pr2__prc_change_user = $pr2__prc_change_user;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_change_date(): ?string
    {
        return $this->pr2__prc_change_date ?? null;
    }
    /**
     * Set pr2__prc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_change_date(?string $pr2__prc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_change_date) && !is_string($pr2__prc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_change_date, true), gettype($pr2__prc_change_date)), __LINE__);
        }
        if (is_null($pr2__prc_change_date) || (is_array($pr2__prc_change_date) && empty($pr2__prc_change_date))) {
            unset($this->pr2__prc_change_date);
        } else {
            $this->pr2__prc_change_date = $pr2__prc_change_date;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_delete_flag(): ?string
    {
        return $this->pr2__prc_delete_flag ?? null;
    }
    /**
     * Set pr2__prc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_delete_flag(?string $pr2__prc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_delete_flag) && !is_string($pr2__prc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_delete_flag, true), gettype($pr2__prc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_delete_flag) && $pr2__prc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_delete_flag) && $pr2__prc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_delete_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_delete_flag) || (is_array($pr2__prc_delete_flag) && empty($pr2__prc_delete_flag))) {
            unset($this->pr2__prc_delete_flag);
        } else {
            $this->pr2__prc_delete_flag = $pr2__prc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_key_ext(): ?string
    {
        return $this->pr2__prc_key_ext ?? null;
    }
    /**
     * Set pr2__prc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_key_ext(?string $pr2__prc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_key_ext) && !is_string($pr2__prc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_key_ext, true), gettype($pr2__prc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_key_ext, true)), __LINE__);
        }
        if (is_null($pr2__prc_key_ext) || (is_array($pr2__prc_key_ext) && empty($pr2__prc_key_ext))) {
            unset($this->pr2__prc_key_ext);
        } else {
            $this->pr2__prc_key_ext = $pr2__prc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_gla_ar_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_gla_ar_key(): ?string
    {
        return $this->pr2__prc_gla_ar_key ?? null;
    }
    /**
     * Set pr2__prc_gla_ar_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_gla_ar_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_gla_ar_key(?string $pr2__prc_gla_ar_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_gla_ar_key) && !is_string($pr2__prc_gla_ar_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_gla_ar_key, true), gettype($pr2__prc_gla_ar_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_gla_ar_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_gla_ar_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_gla_ar_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_gla_ar_key) || (is_array($pr2__prc_gla_ar_key) && empty($pr2__prc_gla_ar_key))) {
            unset($this->pr2__prc_gla_ar_key);
        } else {
            $this->pr2__prc_gla_ar_key = $pr2__prc_gla_ar_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_gla_revenue_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_gla_revenue_key(): ?string
    {
        return $this->pr2__prc_gla_revenue_key ?? null;
    }
    /**
     * Set pr2__prc_gla_revenue_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_gla_revenue_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_gla_revenue_key(?string $pr2__prc_gla_revenue_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_gla_revenue_key) && !is_string($pr2__prc_gla_revenue_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_gla_revenue_key, true), gettype($pr2__prc_gla_revenue_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_gla_revenue_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_gla_revenue_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_gla_revenue_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_gla_revenue_key) || (is_array($pr2__prc_gla_revenue_key) && empty($pr2__prc_gla_revenue_key))) {
            unset($this->pr2__prc_gla_revenue_key);
        } else {
            $this->pr2__prc_gla_revenue_key = $pr2__prc_gla_revenue_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_gla_liability_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_gla_liability_key(): ?string
    {
        return $this->pr2__prc_gla_liability_key ?? null;
    }
    /**
     * Set pr2__prc_gla_liability_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_gla_liability_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_gla_liability_key(?string $pr2__prc_gla_liability_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_gla_liability_key) && !is_string($pr2__prc_gla_liability_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_gla_liability_key, true), gettype($pr2__prc_gla_liability_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_gla_liability_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_gla_liability_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_gla_liability_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_gla_liability_key) || (is_array($pr2__prc_gla_liability_key) && empty($pr2__prc_gla_liability_key))) {
            unset($this->pr2__prc_gla_liability_key);
        } else {
            $this->pr2__prc_gla_liability_key = $pr2__prc_gla_liability_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_gla_return_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_gla_return_key(): ?string
    {
        return $this->pr2__prc_gla_return_key ?? null;
    }
    /**
     * Set pr2__prc_gla_return_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_gla_return_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_gla_return_key(?string $pr2__prc_gla_return_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_gla_return_key) && !is_string($pr2__prc_gla_return_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_gla_return_key, true), gettype($pr2__prc_gla_return_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_gla_return_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_gla_return_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_gla_return_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_gla_return_key) || (is_array($pr2__prc_gla_return_key) && empty($pr2__prc_gla_return_key))) {
            unset($this->pr2__prc_gla_return_key);
        } else {
            $this->pr2__prc_gla_return_key = $pr2__prc_gla_return_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_gla_writeoff_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_gla_writeoff_key(): ?string
    {
        return $this->pr2__prc_gla_writeoff_key ?? null;
    }
    /**
     * Set pr2__prc_gla_writeoff_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_gla_writeoff_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_gla_writeoff_key(?string $pr2__prc_gla_writeoff_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_gla_writeoff_key) && !is_string($pr2__prc_gla_writeoff_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_gla_writeoff_key, true), gettype($pr2__prc_gla_writeoff_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_gla_writeoff_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_gla_writeoff_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_gla_writeoff_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_gla_writeoff_key) || (is_array($pr2__prc_gla_writeoff_key) && empty($pr2__prc_gla_writeoff_key))) {
            unset($this->pr2__prc_gla_writeoff_key);
        } else {
            $this->pr2__prc_gla_writeoff_key = $pr2__prc_gla_writeoff_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_start_date(): ?string
    {
        return $this->pr2__prc_start_date ?? null;
    }
    /**
     * Set pr2__prc_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_start_date(?string $pr2__prc_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_start_date) && !is_string($pr2__prc_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_start_date, true), gettype($pr2__prc_start_date)), __LINE__);
        }
        if (is_null($pr2__prc_start_date) || (is_array($pr2__prc_start_date) && empty($pr2__prc_start_date))) {
            unset($this->pr2__prc_start_date);
        } else {
            $this->pr2__prc_start_date = $pr2__prc_start_date;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_end_date(): ?string
    {
        return $this->pr2__prc_end_date ?? null;
    }
    /**
     * Set pr2__prc_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_end_date(?string $pr2__prc_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_end_date) && !is_string($pr2__prc_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_end_date, true), gettype($pr2__prc_end_date)), __LINE__);
        }
        if (is_null($pr2__prc_end_date) || (is_array($pr2__prc_end_date) && empty($pr2__prc_end_date))) {
            unset($this->pr2__prc_end_date);
        } else {
            $this->pr2__prc_end_date = $pr2__prc_end_date;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_ptr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_ptr_key(): ?string
    {
        return $this->pr2__prc_ptr_key ?? null;
    }
    /**
     * Set pr2__prc_ptr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_ptr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_ptr_key(?string $pr2__prc_ptr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_ptr_key) && !is_string($pr2__prc_ptr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_ptr_key, true), gettype($pr2__prc_ptr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_ptr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_ptr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_ptr_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_ptr_key) || (is_array($pr2__prc_ptr_key) && empty($pr2__prc_ptr_key))) {
            unset($this->pr2__prc_ptr_key);
        } else {
            $this->pr2__prc_ptr_key = $pr2__prc_ptr_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_num_issues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPr2__prc_num_issues(): ?int
    {
        return $this->pr2__prc_num_issues ?? null;
    }
    /**
     * Set pr2__prc_num_issues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pr2__prc_num_issues
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_num_issues(?int $pr2__prc_num_issues = null): self
    {
        // validation for constraint: int
        if (!is_null($pr2__prc_num_issues) && !(is_int($pr2__prc_num_issues) || ctype_digit($pr2__prc_num_issues))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pr2__prc_num_issues, true), gettype($pr2__prc_num_issues)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($pr2__prc_num_issues) && $pr2__prc_num_issues > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($pr2__prc_num_issues, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($pr2__prc_num_issues) && $pr2__prc_num_issues < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($pr2__prc_num_issues, true)), __LINE__);
        }
        if (is_null($pr2__prc_num_issues) || (is_array($pr2__prc_num_issues) && empty($pr2__prc_num_issues))) {
            unset($this->pr2__prc_num_issues);
        } else {
            $this->pr2__prc_num_issues = $pr2__prc_num_issues;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_prd_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_prd_ptp_key(): ?string
    {
        return $this->pr2__prc_prd_ptp_key ?? null;
    }
    /**
     * Set pr2__prc_prd_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_prd_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_prd_ptp_key(?string $pr2__prc_prd_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_prd_ptp_key) && !is_string($pr2__prc_prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_prd_ptp_key, true), gettype($pr2__prc_prd_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_prd_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_prd_ptp_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_prd_ptp_key) || (is_array($pr2__prc_prd_ptp_key) && empty($pr2__prc_prd_ptp_key))) {
            unset($this->pr2__prc_prd_ptp_key);
        } else {
            $this->pr2__prc_prd_ptp_key = $pr2__prc_prd_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_percent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPr2__prc_percent(): ?float
    {
        return $this->pr2__prc_percent ?? null;
    }
    /**
     * Set pr2__prc_percent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pr2__prc_percent
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_percent(?float $pr2__prc_percent = null): self
    {
        // validation for constraint: float
        if (!is_null($pr2__prc_percent) && !(is_float($pr2__prc_percent) || is_numeric($pr2__prc_percent))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pr2__prc_percent, true), gettype($pr2__prc_percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pr2__prc_percent) && mb_strlen(mb_substr((string) $pr2__prc_percent, false !== mb_strpos((string) $pr2__prc_percent, '.') ? mb_strpos((string) $pr2__prc_percent, '.') + 1 : mb_strlen((string) $pr2__prc_percent))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pr2__prc_percent, true), mb_strlen(mb_substr((string) $pr2__prc_percent, mb_strpos((string) $pr2__prc_percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($pr2__prc_percent) && mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_percent)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($pr2__prc_percent, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_percent))), __LINE__);
        }
        if (is_null($pr2__prc_percent) || (is_array($pr2__prc_percent) && empty($pr2__prc_percent))) {
            unset($this->pr2__prc_percent);
        } else {
            $this->pr2__prc_percent = $pr2__prc_percent;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_percent_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPr2__prc_percent_cp(): ?float
    {
        return $this->pr2__prc_percent_cp ?? null;
    }
    /**
     * Set pr2__prc_percent_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pr2__prc_percent_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_percent_cp(?float $pr2__prc_percent_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($pr2__prc_percent_cp) && !(is_float($pr2__prc_percent_cp) || is_numeric($pr2__prc_percent_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pr2__prc_percent_cp, true), gettype($pr2__prc_percent_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pr2__prc_percent_cp) && mb_strlen(mb_substr((string) $pr2__prc_percent_cp, false !== mb_strpos((string) $pr2__prc_percent_cp, '.') ? mb_strpos((string) $pr2__prc_percent_cp, '.') + 1 : mb_strlen((string) $pr2__prc_percent_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pr2__prc_percent_cp, true), mb_strlen(mb_substr((string) $pr2__prc_percent_cp, mb_strpos((string) $pr2__prc_percent_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($pr2__prc_percent_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_percent_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($pr2__prc_percent_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_percent_cp))), __LINE__);
        }
        if (is_null($pr2__prc_percent_cp) || (is_array($pr2__prc_percent_cp) && empty($pr2__prc_percent_cp))) {
            unset($this->pr2__prc_percent_cp);
        } else {
            $this->pr2__prc_percent_cp = $pr2__prc_percent_cp;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_prd_atc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_prd_atc_key(): ?string
    {
        return $this->pr2__prc_prd_atc_key ?? null;
    }
    /**
     * Set pr2__prc_prd_atc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_prd_atc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_prd_atc_key(?string $pr2__prc_prd_atc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_prd_atc_key) && !is_string($pr2__prc_prd_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_prd_atc_key, true), gettype($pr2__prc_prd_atc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_prd_atc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_prd_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_prd_atc_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_prd_atc_key) || (is_array($pr2__prc_prd_atc_key) && empty($pr2__prc_prd_atc_key))) {
            unset($this->pr2__prc_prd_atc_key);
        } else {
            $this->pr2__prc_prd_atc_key = $pr2__prc_prd_atc_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_code(): ?string
    {
        return $this->pr2__prc_code ?? null;
    }
    /**
     * Set pr2__prc_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_code(?string $pr2__prc_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_code) && !is_string($pr2__prc_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_code, true), gettype($pr2__prc_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pr2__prc_code) && mb_strlen((string) $pr2__prc_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $pr2__prc_code)), __LINE__);
        }
        if (is_null($pr2__prc_code) || (is_array($pr2__prc_code) && empty($pr2__prc_code))) {
            unset($this->pr2__prc_code);
        } else {
            $this->pr2__prc_code = $pr2__prc_code;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_display_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_display_name(): ?string
    {
        return $this->pr2__prc_display_name ?? null;
    }
    /**
     * Set pr2__prc_display_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_display_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_display_name(?string $pr2__prc_display_name = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_display_name) && !is_string($pr2__prc_display_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_display_name, true), gettype($pr2__prc_display_name)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($pr2__prc_display_name) && mb_strlen((string) $pr2__prc_display_name) > 250) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen((string) $pr2__prc_display_name)), __LINE__);
        }
        if (is_null($pr2__prc_display_name) || (is_array($pr2__prc_display_name) && empty($pr2__prc_display_name))) {
            unset($this->pr2__prc_display_name);
        } else {
            $this->pr2__prc_display_name = $pr2__prc_display_name;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_sell_online value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_sell_online(): ?string
    {
        return $this->pr2__prc_sell_online ?? null;
    }
    /**
     * Set pr2__prc_sell_online value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_sell_online
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_sell_online(?string $pr2__prc_sell_online = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_sell_online) && !is_string($pr2__prc_sell_online)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_sell_online, true), gettype($pr2__prc_sell_online)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_sell_online) && $pr2__prc_sell_online > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_sell_online, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_sell_online) && $pr2__prc_sell_online < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_sell_online, true)), __LINE__);
        }
        if (is_null($pr2__prc_sell_online) || (is_array($pr2__prc_sell_online) && empty($pr2__prc_sell_online))) {
            unset($this->pr2__prc_sell_online);
        } else {
            $this->pr2__prc_sell_online = $pr2__prc_sell_online;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_gla_deferred_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_gla_deferred_key(): ?string
    {
        return $this->pr2__prc_gla_deferred_key ?? null;
    }
    /**
     * Set pr2__prc_gla_deferred_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_gla_deferred_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_gla_deferred_key(?string $pr2__prc_gla_deferred_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_gla_deferred_key) && !is_string($pr2__prc_gla_deferred_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_gla_deferred_key, true), gettype($pr2__prc_gla_deferred_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_gla_deferred_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_gla_deferred_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_gla_deferred_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_gla_deferred_key) || (is_array($pr2__prc_gla_deferred_key) && empty($pr2__prc_gla_deferred_key))) {
            unset($this->pr2__prc_gla_deferred_key);
        } else {
            $this->pr2__prc_gla_deferred_key = $pr2__prc_gla_deferred_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_deferred_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_deferred_flag(): ?string
    {
        return $this->pr2__prc_deferred_flag ?? null;
    }
    /**
     * Set pr2__prc_deferred_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_deferred_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_deferred_flag(?string $pr2__prc_deferred_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_deferred_flag) && !is_string($pr2__prc_deferred_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_deferred_flag, true), gettype($pr2__prc_deferred_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_deferred_flag) && $pr2__prc_deferred_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_deferred_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_deferred_flag) && $pr2__prc_deferred_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_deferred_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_deferred_flag) || (is_array($pr2__prc_deferred_flag) && empty($pr2__prc_deferred_flag))) {
            unset($this->pr2__prc_deferred_flag);
        } else {
            $this->pr2__prc_deferred_flag = $pr2__prc_deferred_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_mail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_mail(): ?string
    {
        return $this->pr2__prc_mail ?? null;
    }
    /**
     * Set pr2__prc_mail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_mail
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_mail(?string $pr2__prc_mail = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_mail) && !is_string($pr2__prc_mail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_mail, true), gettype($pr2__prc_mail)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_mail) && $pr2__prc_mail > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_mail, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_mail) && $pr2__prc_mail < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_mail, true)), __LINE__);
        }
        if (is_null($pr2__prc_mail) || (is_array($pr2__prc_mail) && empty($pr2__prc_mail))) {
            unset($this->pr2__prc_mail);
        } else {
            $this->pr2__prc_mail = $pr2__prc_mail;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_email(): ?string
    {
        return $this->pr2__prc_email ?? null;
    }
    /**
     * Set pr2__prc_email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_email
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_email(?string $pr2__prc_email = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_email) && !is_string($pr2__prc_email)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_email, true), gettype($pr2__prc_email)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_email) && $pr2__prc_email > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_email, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_email) && $pr2__prc_email < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_email, true)), __LINE__);
        }
        if (is_null($pr2__prc_email) || (is_array($pr2__prc_email) && empty($pr2__prc_email))) {
            unset($this->pr2__prc_email);
        } else {
            $this->pr2__prc_email = $pr2__prc_email;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_fax(): ?string
    {
        return $this->pr2__prc_fax ?? null;
    }
    /**
     * Set pr2__prc_fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_fax(?string $pr2__prc_fax = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_fax) && !is_string($pr2__prc_fax)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_fax, true), gettype($pr2__prc_fax)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_fax) && $pr2__prc_fax > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_fax, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_fax) && $pr2__prc_fax < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_fax, true)), __LINE__);
        }
        if (is_null($pr2__prc_fax) || (is_array($pr2__prc_fax) && empty($pr2__prc_fax))) {
            unset($this->pr2__prc_fax);
        } else {
            $this->pr2__prc_fax = $pr2__prc_fax;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_thumbnail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_thumbnail(): ?string
    {
        return $this->pr2__prc_thumbnail ?? null;
    }
    /**
     * Set pr2__prc_thumbnail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_thumbnail
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_thumbnail(?string $pr2__prc_thumbnail = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_thumbnail) && !is_string($pr2__prc_thumbnail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_thumbnail, true), gettype($pr2__prc_thumbnail)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($pr2__prc_thumbnail) && mb_strlen((string) $pr2__prc_thumbnail) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $pr2__prc_thumbnail)), __LINE__);
        }
        if (is_null($pr2__prc_thumbnail) || (is_array($pr2__prc_thumbnail) && empty($pr2__prc_thumbnail))) {
            unset($this->pr2__prc_thumbnail);
        } else {
            $this->pr2__prc_thumbnail = $pr2__prc_thumbnail;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_online_abstract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_online_abstract(): ?string
    {
        return $this->pr2__prc_online_abstract ?? null;
    }
    /**
     * Set pr2__prc_online_abstract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_online_abstract
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_online_abstract(?string $pr2__prc_online_abstract = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_online_abstract) && !is_string($pr2__prc_online_abstract)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_online_abstract, true), gettype($pr2__prc_online_abstract)), __LINE__);
        }
        if (is_null($pr2__prc_online_abstract) || (is_array($pr2__prc_online_abstract) && empty($pr2__prc_online_abstract))) {
            unset($this->pr2__prc_online_abstract);
        } else {
            $this->pr2__prc_online_abstract = $pr2__prc_online_abstract;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_entity_key(): ?string
    {
        return $this->pr2__prc_entity_key ?? null;
    }
    /**
     * Set pr2__prc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_entity_key(?string $pr2__prc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_entity_key) && !is_string($pr2__prc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_entity_key, true), gettype($pr2__prc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_entity_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_entity_key) || (is_array($pr2__prc_entity_key) && empty($pr2__prc_entity_key))) {
            unset($this->pr2__prc_entity_key);
        } else {
            $this->pr2__prc_entity_key = $pr2__prc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_qty_min value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPr2__prc_qty_min(): ?float
    {
        return $this->pr2__prc_qty_min ?? null;
    }
    /**
     * Set pr2__prc_qty_min value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pr2__prc_qty_min
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_qty_min(?float $pr2__prc_qty_min = null): self
    {
        // validation for constraint: float
        if (!is_null($pr2__prc_qty_min) && !(is_float($pr2__prc_qty_min) || is_numeric($pr2__prc_qty_min))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pr2__prc_qty_min, true), gettype($pr2__prc_qty_min)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pr2__prc_qty_min) && mb_strlen(mb_substr((string) $pr2__prc_qty_min, false !== mb_strpos((string) $pr2__prc_qty_min, '.') ? mb_strpos((string) $pr2__prc_qty_min, '.') + 1 : mb_strlen((string) $pr2__prc_qty_min))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pr2__prc_qty_min, true), mb_strlen(mb_substr((string) $pr2__prc_qty_min, mb_strpos((string) $pr2__prc_qty_min, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($pr2__prc_qty_min) && mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_qty_min)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($pr2__prc_qty_min, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_qty_min))), __LINE__);
        }
        if (is_null($pr2__prc_qty_min) || (is_array($pr2__prc_qty_min) && empty($pr2__prc_qty_min))) {
            unset($this->pr2__prc_qty_min);
        } else {
            $this->pr2__prc_qty_min = $pr2__prc_qty_min;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_qty_max value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPr2__prc_qty_max(): ?float
    {
        return $this->pr2__prc_qty_max ?? null;
    }
    /**
     * Set pr2__prc_qty_max value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pr2__prc_qty_max
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_qty_max(?float $pr2__prc_qty_max = null): self
    {
        // validation for constraint: float
        if (!is_null($pr2__prc_qty_max) && !(is_float($pr2__prc_qty_max) || is_numeric($pr2__prc_qty_max))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pr2__prc_qty_max, true), gettype($pr2__prc_qty_max)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pr2__prc_qty_max) && mb_strlen(mb_substr((string) $pr2__prc_qty_max, false !== mb_strpos((string) $pr2__prc_qty_max, '.') ? mb_strpos((string) $pr2__prc_qty_max, '.') + 1 : mb_strlen((string) $pr2__prc_qty_max))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pr2__prc_qty_max, true), mb_strlen(mb_substr((string) $pr2__prc_qty_max, mb_strpos((string) $pr2__prc_qty_max, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($pr2__prc_qty_max) && mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_qty_max)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($pr2__prc_qty_max, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_qty_max))), __LINE__);
        }
        if (is_null($pr2__prc_qty_max) || (is_array($pr2__prc_qty_max) && empty($pr2__prc_qty_max))) {
            unset($this->pr2__prc_qty_max);
        } else {
            $this->pr2__prc_qty_max = $pr2__prc_qty_max;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_recognize_after_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_recognize_after_date(): ?string
    {
        return $this->pr2__prc_recognize_after_date ?? null;
    }
    /**
     * Set pr2__prc_recognize_after_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_recognize_after_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_recognize_after_date(?string $pr2__prc_recognize_after_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_recognize_after_date) && !is_string($pr2__prc_recognize_after_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_recognize_after_date, true), gettype($pr2__prc_recognize_after_date)), __LINE__);
        }
        if (is_null($pr2__prc_recognize_after_date) || (is_array($pr2__prc_recognize_after_date) && empty($pr2__prc_recognize_after_date))) {
            unset($this->pr2__prc_recognize_after_date);
        } else {
            $this->pr2__prc_recognize_after_date = $pr2__prc_recognize_after_date;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_account_split_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_account_split_flag(): ?string
    {
        return $this->pr2__prc_account_split_flag ?? null;
    }
    /**
     * Set pr2__prc_account_split_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_account_split_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_account_split_flag(?string $pr2__prc_account_split_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_account_split_flag) && !is_string($pr2__prc_account_split_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_account_split_flag, true), gettype($pr2__prc_account_split_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_account_split_flag) && $pr2__prc_account_split_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_account_split_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_account_split_flag) && $pr2__prc_account_split_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_account_split_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_account_split_flag) || (is_array($pr2__prc_account_split_flag) && empty($pr2__prc_account_split_flag))) {
            unset($this->pr2__prc_account_split_flag);
        } else {
            $this->pr2__prc_account_split_flag = $pr2__prc_account_split_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_prorate_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_prorate_flag(): ?string
    {
        return $this->pr2__prc_prorate_flag ?? null;
    }
    /**
     * Set pr2__prc_prorate_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_prorate_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_prorate_flag(?string $pr2__prc_prorate_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_prorate_flag) && !is_string($pr2__prc_prorate_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_prorate_flag, true), gettype($pr2__prc_prorate_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_prorate_flag) && $pr2__prc_prorate_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_prorate_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_prorate_flag) && $pr2__prc_prorate_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_prorate_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_prorate_flag) || (is_array($pr2__prc_prorate_flag) && empty($pr2__prc_prorate_flag))) {
            unset($this->pr2__prc_prorate_flag);
        } else {
            $this->pr2__prc_prorate_flag = $pr2__prc_prorate_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_prorate_first_year_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_prorate_first_year_flag(): ?string
    {
        return $this->pr2__prc_prorate_first_year_flag ?? null;
    }
    /**
     * Set pr2__prc_prorate_first_year_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_prorate_first_year_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_prorate_first_year_flag(?string $pr2__prc_prorate_first_year_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_prorate_first_year_flag) && !is_string($pr2__prc_prorate_first_year_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_prorate_first_year_flag, true), gettype($pr2__prc_prorate_first_year_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_prorate_first_year_flag) && $pr2__prc_prorate_first_year_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_prorate_first_year_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_prorate_first_year_flag) && $pr2__prc_prorate_first_year_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_prorate_first_year_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_prorate_first_year_flag) || (is_array($pr2__prc_prorate_first_year_flag) && empty($pr2__prc_prorate_first_year_flag))) {
            unset($this->pr2__prc_prorate_first_year_flag);
        } else {
            $this->pr2__prc_prorate_first_year_flag = $pr2__prc_prorate_first_year_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_web value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_web(): ?string
    {
        return $this->pr2__prc_web ?? null;
    }
    /**
     * Set pr2__prc_web value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_web
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_web(?string $pr2__prc_web = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_web) && !is_string($pr2__prc_web)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_web, true), gettype($pr2__prc_web)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_web) && $pr2__prc_web > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_web, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_web) && $pr2__prc_web < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_web, true)), __LINE__);
        }
        if (is_null($pr2__prc_web) || (is_array($pr2__prc_web) && empty($pr2__prc_web))) {
            unset($this->pr2__prc_web);
        } else {
            $this->pr2__prc_web = $pr2__prc_web;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_microfiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_microfiche(): ?string
    {
        return $this->pr2__prc_microfiche ?? null;
    }
    /**
     * Set pr2__prc_microfiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_microfiche
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_microfiche(?string $pr2__prc_microfiche = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_microfiche) && !is_string($pr2__prc_microfiche)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_microfiche, true), gettype($pr2__prc_microfiche)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_microfiche) && $pr2__prc_microfiche > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_microfiche, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_microfiche) && $pr2__prc_microfiche < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_microfiche, true)), __LINE__);
        }
        if (is_null($pr2__prc_microfiche) || (is_array($pr2__prc_microfiche) && empty($pr2__prc_microfiche))) {
            unset($this->pr2__prc_microfiche);
        } else {
            $this->pr2__prc_microfiche = $pr2__prc_microfiche;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_revenue_recog_frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPr2__prc_revenue_recog_frequency(): ?int
    {
        return $this->pr2__prc_revenue_recog_frequency ?? null;
    }
    /**
     * Set pr2__prc_revenue_recog_frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pr2__prc_revenue_recog_frequency
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_revenue_recog_frequency(?int $pr2__prc_revenue_recog_frequency = null): self
    {
        // validation for constraint: int
        if (!is_null($pr2__prc_revenue_recog_frequency) && !(is_int($pr2__prc_revenue_recog_frequency) || ctype_digit($pr2__prc_revenue_recog_frequency))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pr2__prc_revenue_recog_frequency, true), gettype($pr2__prc_revenue_recog_frequency)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($pr2__prc_revenue_recog_frequency) && $pr2__prc_revenue_recog_frequency > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($pr2__prc_revenue_recog_frequency, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($pr2__prc_revenue_recog_frequency) && $pr2__prc_revenue_recog_frequency < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($pr2__prc_revenue_recog_frequency, true)), __LINE__);
        }
        if (is_null($pr2__prc_revenue_recog_frequency) || (is_array($pr2__prc_revenue_recog_frequency) && empty($pr2__prc_revenue_recog_frequency))) {
            unset($this->pr2__prc_revenue_recog_frequency);
        } else {
            $this->pr2__prc_revenue_recog_frequency = $pr2__prc_revenue_recog_frequency;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_allow_installment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_allow_installment(): ?string
    {
        return $this->pr2__prc_allow_installment ?? null;
    }
    /**
     * Set pr2__prc_allow_installment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_allow_installment
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_allow_installment(?string $pr2__prc_allow_installment = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_allow_installment) && !is_string($pr2__prc_allow_installment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_allow_installment, true), gettype($pr2__prc_allow_installment)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_allow_installment) && $pr2__prc_allow_installment > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_allow_installment, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_allow_installment) && $pr2__prc_allow_installment < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_allow_installment, true)), __LINE__);
        }
        if (is_null($pr2__prc_allow_installment) || (is_array($pr2__prc_allow_installment) && empty($pr2__prc_allow_installment))) {
            unset($this->pr2__prc_allow_installment);
        } else {
            $this->pr2__prc_allow_installment = $pr2__prc_allow_installment;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_pjt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_pjt_key(): ?string
    {
        return $this->pr2__prc_pjt_key ?? null;
    }
    /**
     * Set pr2__prc_pjt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_pjt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_pjt_key(?string $pr2__prc_pjt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_pjt_key) && !is_string($pr2__prc_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_pjt_key, true), gettype($pr2__prc_pjt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_pjt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_pjt_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_pjt_key) || (is_array($pr2__prc_pjt_key) && empty($pr2__prc_pjt_key))) {
            unset($this->pr2__prc_pjt_key);
        } else {
            $this->pr2__prc_pjt_key = $pr2__prc_pjt_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_shippable_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_shippable_flag(): ?string
    {
        return $this->pr2__prc_shippable_flag ?? null;
    }
    /**
     * Set pr2__prc_shippable_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_shippable_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_shippable_flag(?string $pr2__prc_shippable_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_shippable_flag) && !is_string($pr2__prc_shippable_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_shippable_flag, true), gettype($pr2__prc_shippable_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_shippable_flag) && $pr2__prc_shippable_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_shippable_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_shippable_flag) && $pr2__prc_shippable_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_shippable_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_shippable_flag) || (is_array($pr2__prc_shippable_flag) && empty($pr2__prc_shippable_flag))) {
            unset($this->pr2__prc_shippable_flag);
        } else {
            $this->pr2__prc_shippable_flag = $pr2__prc_shippable_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_eweb_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_eweb_code(): ?string
    {
        return $this->pr2__prc_eweb_code ?? null;
    }
    /**
     * Set pr2__prc_eweb_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_eweb_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_eweb_code(?string $pr2__prc_eweb_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_eweb_code) && !is_string($pr2__prc_eweb_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_eweb_code, true), gettype($pr2__prc_eweb_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($pr2__prc_eweb_code) && mb_strlen((string) $pr2__prc_eweb_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $pr2__prc_eweb_code)), __LINE__);
        }
        if (is_null($pr2__prc_eweb_code) || (is_array($pr2__prc_eweb_code) && empty($pr2__prc_eweb_code))) {
            unset($this->pr2__prc_eweb_code);
        } else {
            $this->pr2__prc_eweb_code = $pr2__prc_eweb_code;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_weight_min value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPr2__prc_weight_min(): ?float
    {
        return $this->pr2__prc_weight_min ?? null;
    }
    /**
     * Set pr2__prc_weight_min value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pr2__prc_weight_min
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_weight_min(?float $pr2__prc_weight_min = null): self
    {
        // validation for constraint: float
        if (!is_null($pr2__prc_weight_min) && !(is_float($pr2__prc_weight_min) || is_numeric($pr2__prc_weight_min))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pr2__prc_weight_min, true), gettype($pr2__prc_weight_min)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pr2__prc_weight_min) && mb_strlen(mb_substr((string) $pr2__prc_weight_min, false !== mb_strpos((string) $pr2__prc_weight_min, '.') ? mb_strpos((string) $pr2__prc_weight_min, '.') + 1 : mb_strlen((string) $pr2__prc_weight_min))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pr2__prc_weight_min, true), mb_strlen(mb_substr((string) $pr2__prc_weight_min, mb_strpos((string) $pr2__prc_weight_min, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($pr2__prc_weight_min) && mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_weight_min)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($pr2__prc_weight_min, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_weight_min))), __LINE__);
        }
        if (is_null($pr2__prc_weight_min) || (is_array($pr2__prc_weight_min) && empty($pr2__prc_weight_min))) {
            unset($this->pr2__prc_weight_min);
        } else {
            $this->pr2__prc_weight_min = $pr2__prc_weight_min;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_weight_max value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPr2__prc_weight_max(): ?float
    {
        return $this->pr2__prc_weight_max ?? null;
    }
    /**
     * Set pr2__prc_weight_max value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pr2__prc_weight_max
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_weight_max(?float $pr2__prc_weight_max = null): self
    {
        // validation for constraint: float
        if (!is_null($pr2__prc_weight_max) && !(is_float($pr2__prc_weight_max) || is_numeric($pr2__prc_weight_max))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pr2__prc_weight_max, true), gettype($pr2__prc_weight_max)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($pr2__prc_weight_max) && mb_strlen(mb_substr((string) $pr2__prc_weight_max, false !== mb_strpos((string) $pr2__prc_weight_max, '.') ? mb_strpos((string) $pr2__prc_weight_max, '.') + 1 : mb_strlen((string) $pr2__prc_weight_max))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($pr2__prc_weight_max, true), mb_strlen(mb_substr((string) $pr2__prc_weight_max, mb_strpos((string) $pr2__prc_weight_max, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($pr2__prc_weight_max) && mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_weight_max)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($pr2__prc_weight_max, true), mb_strlen(preg_replace('/(\D)/', '', (string) $pr2__prc_weight_max))), __LINE__);
        }
        if (is_null($pr2__prc_weight_max) || (is_array($pr2__prc_weight_max) && empty($pr2__prc_weight_max))) {
            unset($this->pr2__prc_weight_max);
        } else {
            $this->pr2__prc_weight_max = $pr2__prc_weight_max;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_recognize_by_issue_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_recognize_by_issue_flag(): ?string
    {
        return $this->pr2__prc_recognize_by_issue_flag ?? null;
    }
    /**
     * Set pr2__prc_recognize_by_issue_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_recognize_by_issue_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_recognize_by_issue_flag(?string $pr2__prc_recognize_by_issue_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_recognize_by_issue_flag) && !is_string($pr2__prc_recognize_by_issue_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_recognize_by_issue_flag, true), gettype($pr2__prc_recognize_by_issue_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_recognize_by_issue_flag) && $pr2__prc_recognize_by_issue_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_recognize_by_issue_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_recognize_by_issue_flag) && $pr2__prc_recognize_by_issue_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_recognize_by_issue_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_recognize_by_issue_flag) || (is_array($pr2__prc_recognize_by_issue_flag) && empty($pr2__prc_recognize_by_issue_flag))) {
            unset($this->pr2__prc_recognize_by_issue_flag);
        } else {
            $this->pr2__prc_recognize_by_issue_flag = $pr2__prc_recognize_by_issue_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_num_grace_issues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPr2__prc_num_grace_issues(): ?int
    {
        return $this->pr2__prc_num_grace_issues ?? null;
    }
    /**
     * Set pr2__prc_num_grace_issues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pr2__prc_num_grace_issues
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_num_grace_issues(?int $pr2__prc_num_grace_issues = null): self
    {
        // validation for constraint: int
        if (!is_null($pr2__prc_num_grace_issues) && !(is_int($pr2__prc_num_grace_issues) || ctype_digit($pr2__prc_num_grace_issues))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pr2__prc_num_grace_issues, true), gettype($pr2__prc_num_grace_issues)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($pr2__prc_num_grace_issues) && $pr2__prc_num_grace_issues > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($pr2__prc_num_grace_issues, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($pr2__prc_num_grace_issues) && $pr2__prc_num_grace_issues < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($pr2__prc_num_grace_issues, true)), __LINE__);
        }
        if (is_null($pr2__prc_num_grace_issues) || (is_array($pr2__prc_num_grace_issues) && empty($pr2__prc_num_grace_issues))) {
            unset($this->pr2__prc_num_grace_issues);
        } else {
            $this->pr2__prc_num_grace_issues = $pr2__prc_num_grace_issues;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_back_issue_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_back_issue_flag(): ?string
    {
        return $this->pr2__prc_back_issue_flag ?? null;
    }
    /**
     * Set pr2__prc_back_issue_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_back_issue_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_back_issue_flag(?string $pr2__prc_back_issue_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_back_issue_flag) && !is_string($pr2__prc_back_issue_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_back_issue_flag, true), gettype($pr2__prc_back_issue_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_back_issue_flag) && $pr2__prc_back_issue_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_back_issue_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_back_issue_flag) && $pr2__prc_back_issue_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_back_issue_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_back_issue_flag) || (is_array($pr2__prc_back_issue_flag) && empty($pr2__prc_back_issue_flag))) {
            unset($this->pr2__prc_back_issue_flag);
        } else {
            $this->pr2__prc_back_issue_flag = $pr2__prc_back_issue_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_renew_unpaid_orders_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_renew_unpaid_orders_flag(): ?string
    {
        return $this->pr2__prc_renew_unpaid_orders_flag ?? null;
    }
    /**
     * Set pr2__prc_renew_unpaid_orders_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_renew_unpaid_orders_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_renew_unpaid_orders_flag(?string $pr2__prc_renew_unpaid_orders_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_renew_unpaid_orders_flag) && !is_string($pr2__prc_renew_unpaid_orders_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_renew_unpaid_orders_flag, true), gettype($pr2__prc_renew_unpaid_orders_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_renew_unpaid_orders_flag) && $pr2__prc_renew_unpaid_orders_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_renew_unpaid_orders_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_renew_unpaid_orders_flag) && $pr2__prc_renew_unpaid_orders_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_renew_unpaid_orders_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_renew_unpaid_orders_flag) || (is_array($pr2__prc_renew_unpaid_orders_flag) && empty($pr2__prc_renew_unpaid_orders_flag))) {
            unset($this->pr2__prc_renew_unpaid_orders_flag);
        } else {
            $this->pr2__prc_renew_unpaid_orders_flag = $pr2__prc_renew_unpaid_orders_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_allow_unpaid_orders_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_allow_unpaid_orders_flag(): ?string
    {
        return $this->pr2__prc_allow_unpaid_orders_flag ?? null;
    }
    /**
     * Set pr2__prc_allow_unpaid_orders_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_allow_unpaid_orders_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_allow_unpaid_orders_flag(?string $pr2__prc_allow_unpaid_orders_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_allow_unpaid_orders_flag) && !is_string($pr2__prc_allow_unpaid_orders_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_allow_unpaid_orders_flag, true), gettype($pr2__prc_allow_unpaid_orders_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_allow_unpaid_orders_flag) && $pr2__prc_allow_unpaid_orders_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_allow_unpaid_orders_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_allow_unpaid_orders_flag) && $pr2__prc_allow_unpaid_orders_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_allow_unpaid_orders_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_allow_unpaid_orders_flag) || (is_array($pr2__prc_allow_unpaid_orders_flag) && empty($pr2__prc_allow_unpaid_orders_flag))) {
            unset($this->pr2__prc_allow_unpaid_orders_flag);
        } else {
            $this->pr2__prc_allow_unpaid_orders_flag = $pr2__prc_allow_unpaid_orders_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_deferral_num_years value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPr2__prc_deferral_num_years(): ?int
    {
        return $this->pr2__prc_deferral_num_years ?? null;
    }
    /**
     * Set pr2__prc_deferral_num_years value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pr2__prc_deferral_num_years
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_deferral_num_years(?int $pr2__prc_deferral_num_years = null): self
    {
        // validation for constraint: int
        if (!is_null($pr2__prc_deferral_num_years) && !(is_int($pr2__prc_deferral_num_years) || ctype_digit($pr2__prc_deferral_num_years))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pr2__prc_deferral_num_years, true), gettype($pr2__prc_deferral_num_years)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($pr2__prc_deferral_num_years) && $pr2__prc_deferral_num_years > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($pr2__prc_deferral_num_years, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($pr2__prc_deferral_num_years) && $pr2__prc_deferral_num_years < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($pr2__prc_deferral_num_years, true)), __LINE__);
        }
        if (is_null($pr2__prc_deferral_num_years) || (is_array($pr2__prc_deferral_num_years) && empty($pr2__prc_deferral_num_years))) {
            unset($this->pr2__prc_deferral_num_years);
        } else {
            $this->pr2__prc_deferral_num_years = $pr2__prc_deferral_num_years;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_cur_key(): ?string
    {
        return $this->pr2__prc_cur_key ?? null;
    }
    /**
     * Set pr2__prc_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_cur_key(?string $pr2__prc_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_cur_key) && !is_string($pr2__prc_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_cur_key, true), gettype($pr2__prc_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_cur_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_cur_key) || (is_array($pr2__prc_cur_key) && empty($pr2__prc_cur_key))) {
            unset($this->pr2__prc_cur_key);
        } else {
            $this->pr2__prc_cur_key = $pr2__prc_cur_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_award_credit_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_award_credit_flag(): ?string
    {
        return $this->pr2__prc_award_credit_flag ?? null;
    }
    /**
     * Set pr2__prc_award_credit_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_award_credit_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_award_credit_flag(?string $pr2__prc_award_credit_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_award_credit_flag) && !is_string($pr2__prc_award_credit_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_award_credit_flag, true), gettype($pr2__prc_award_credit_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_award_credit_flag) && $pr2__prc_award_credit_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_award_credit_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_award_credit_flag) && $pr2__prc_award_credit_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_award_credit_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_award_credit_flag) || (is_array($pr2__prc_award_credit_flag) && empty($pr2__prc_award_credit_flag))) {
            unset($this->pr2__prc_award_credit_flag);
        } else {
            $this->pr2__prc_award_credit_flag = $pr2__prc_award_credit_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_deferral_num_issues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPr2__prc_deferral_num_issues(): ?int
    {
        return $this->pr2__prc_deferral_num_issues ?? null;
    }
    /**
     * Set pr2__prc_deferral_num_issues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pr2__prc_deferral_num_issues
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_deferral_num_issues(?int $pr2__prc_deferral_num_issues = null): self
    {
        // validation for constraint: int
        if (!is_null($pr2__prc_deferral_num_issues) && !(is_int($pr2__prc_deferral_num_issues) || ctype_digit($pr2__prc_deferral_num_issues))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pr2__prc_deferral_num_issues, true), gettype($pr2__prc_deferral_num_issues)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($pr2__prc_deferral_num_issues) && $pr2__prc_deferral_num_issues > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($pr2__prc_deferral_num_issues, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($pr2__prc_deferral_num_issues) && $pr2__prc_deferral_num_issues < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($pr2__prc_deferral_num_issues, true)), __LINE__);
        }
        if (is_null($pr2__prc_deferral_num_issues) || (is_array($pr2__prc_deferral_num_issues) && empty($pr2__prc_deferral_num_issues))) {
            unset($this->pr2__prc_deferral_num_issues);
        } else {
            $this->pr2__prc_deferral_num_issues = $pr2__prc_deferral_num_issues;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_allow_sync_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_allow_sync_flag(): ?string
    {
        return $this->pr2__prc_allow_sync_flag ?? null;
    }
    /**
     * Set pr2__prc_allow_sync_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_allow_sync_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_allow_sync_flag(?string $pr2__prc_allow_sync_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_allow_sync_flag) && !is_string($pr2__prc_allow_sync_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_allow_sync_flag, true), gettype($pr2__prc_allow_sync_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_allow_sync_flag) && $pr2__prc_allow_sync_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_allow_sync_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_allow_sync_flag) && $pr2__prc_allow_sync_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_allow_sync_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_allow_sync_flag) || (is_array($pr2__prc_allow_sync_flag) && empty($pr2__prc_allow_sync_flag))) {
            unset($this->pr2__prc_allow_sync_flag);
        } else {
            $this->pr2__prc_allow_sync_flag = $pr2__prc_allow_sync_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_cct_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_cct_key(): ?string
    {
        return $this->pr2__prc_cct_key ?? null;
    }
    /**
     * Set pr2__prc_cct_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_cct_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_cct_key(?string $pr2__prc_cct_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_cct_key) && !is_string($pr2__prc_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_cct_key, true), gettype($pr2__prc_cct_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_cct_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_cct_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_cct_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_cct_key) || (is_array($pr2__prc_cct_key) && empty($pr2__prc_cct_key))) {
            unset($this->pr2__prc_cct_key);
        } else {
            $this->pr2__prc_cct_key = $pr2__prc_cct_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_no_discount_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_no_discount_flag(): ?string
    {
        return $this->pr2__prc_no_discount_flag ?? null;
    }
    /**
     * Set pr2__prc_no_discount_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_no_discount_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_no_discount_flag(?string $pr2__prc_no_discount_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_no_discount_flag) && !is_string($pr2__prc_no_discount_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_no_discount_flag, true), gettype($pr2__prc_no_discount_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pr2__prc_no_discount_flag) && $pr2__prc_no_discount_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pr2__prc_no_discount_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pr2__prc_no_discount_flag) && $pr2__prc_no_discount_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pr2__prc_no_discount_flag, true)), __LINE__);
        }
        if (is_null($pr2__prc_no_discount_flag) || (is_array($pr2__prc_no_discount_flag) && empty($pr2__prc_no_discount_flag))) {
            unset($this->pr2__prc_no_discount_flag);
        } else {
            $this->pr2__prc_no_discount_flag = $pr2__prc_no_discount_flag;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_pcl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_pcl_key(): ?string
    {
        return $this->pr2__prc_pcl_key ?? null;
    }
    /**
     * Set pr2__prc_pcl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_pcl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_pcl_key(?string $pr2__prc_pcl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_pcl_key) && !is_string($pr2__prc_pcl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_pcl_key, true), gettype($pr2__prc_pcl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_pcl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_pcl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_pcl_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_pcl_key) || (is_array($pr2__prc_pcl_key) && empty($pr2__prc_pcl_key))) {
            unset($this->pr2__prc_pcl_key);
        } else {
            $this->pr2__prc_pcl_key = $pr2__prc_pcl_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_pde_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_pde_key(): ?string
    {
        return $this->pr2__prc_pde_key ?? null;
    }
    /**
     * Set pr2__prc_pde_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_pde_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_pde_key(?string $pr2__prc_pde_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_pde_key) && !is_string($pr2__prc_pde_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_pde_key, true), gettype($pr2__prc_pde_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_pde_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_pde_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_pde_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_pde_key) || (is_array($pr2__prc_pde_key) && empty($pr2__prc_pde_key))) {
            unset($this->pr2__prc_pde_key);
        } else {
            $this->pr2__prc_pde_key = $pr2__prc_pde_key;
        }
        
        return $this;
    }
    /**
     * Get pr2__prc_plo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPr2__prc_plo_key(): ?string
    {
        return $this->pr2__prc_plo_key ?? null;
    }
    /**
     * Set pr2__prc_plo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pr2__prc_plo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\FundraisingGift_Premium_Price_DataObjectType
     */
    public function setPr2__prc_plo_key(?string $pr2__prc_plo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pr2__prc_plo_key) && !is_string($pr2__prc_plo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pr2__prc_plo_key, true), gettype($pr2__prc_plo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pr2__prc_plo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pr2__prc_plo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pr2__prc_plo_key, true)), __LINE__);
        }
        if (is_null($pr2__prc_plo_key) || (is_array($pr2__prc_plo_key) && empty($pr2__prc_plo_key))) {
            unset($this->pr2__prc_plo_key);
        } else {
            $this->pr2__prc_plo_key = $pr2__prc_plo_key;
        }
        
        return $this;
    }
}
