<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDynamicQuery StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class GetDynamicQuery extends AbstractStructBase
{
    /**
     * The currentPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    protected int $currentPage;
    /**
     * The WithDescriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $WithDescriptions = null;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $Parameters = null;
    /**
     * The szObjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $szObjectName;
    /**
     * The szQueryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $szQueryName;
    /**
     * Constructor method for GetDynamicQuery
     * @uses GetDynamicQuery::setCurrentPage()
     * @uses GetDynamicQuery::setWithDescriptions()
     * @uses GetDynamicQuery::setParameters()
     * @uses GetDynamicQuery::setSzObjectName()
     * @uses GetDynamicQuery::setSzQueryName()
     * @param int $currentPage
     * @param string $withDescriptions
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters
     * @param string $szObjectName
     * @param string $szQueryName
     */
    public function __construct(int $currentPage, ?string $withDescriptions = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters = null, ?string $szObjectName, ?string $szQueryName)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setWithDescriptions($withDescriptions)
            ->setParameters($parameters)
            ->setSzObjectName($szObjectName)
            ->setSzQueryName($szQueryName);
    }
    /**
     * Get currentPage value
     * @return int
     */
    public function getCurrentPage(): int
    {
        return $this->currentPage;
    }
    /**
     * Set currentPage value
     * @param int $currentPage
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetDynamicQuery
     */
    public function setCurrentPage(int $currentPage): self
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->currentPage = $currentPage;
        
        return $this;
    }
    /**
     * Get WithDescriptions value
     * @return string|null
     */
    public function getWithDescriptions(): ?string
    {
        return $this->WithDescriptions;
    }
    /**
     * Set WithDescriptions value
     * @param string $withDescriptions
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetDynamicQuery
     */
    public function setWithDescriptions(?string $withDescriptions = null): self
    {
        // validation for constraint: string
        if (!is_null($withDescriptions) && !is_string($withDescriptions)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($withDescriptions, true), gettype($withDescriptions)), __LINE__);
        }
        $this->WithDescriptions = $withDescriptions;
        
        return $this;
    }
    /**
     * Get Parameters value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter|null
     */
    public function getParameters(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetDynamicQuery
     */
    public function setParameters(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter $parameters = null): self
    {
        $this->Parameters = $parameters;
        
        return $this;
    }
    /**
     * Get szObjectName value
     * @return string|null
     */
    public function getSzObjectName(): ?string
    {
        return $this->szObjectName;
    }
    /**
     * Set szObjectName value
     * @param string $szObjectName
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetDynamicQuery
     */
    public function setSzObjectName(?string $szObjectName): self
    {
        // validation for constraint: string
        if (!is_null($szObjectName) && !is_string($szObjectName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($szObjectName, true), gettype($szObjectName)), __LINE__);
        }
        $this->szObjectName = $szObjectName;
        
        return $this;
    }
    /**
     * Get szQueryName value
     * @return string|null
     */
    public function getSzQueryName(): ?string
    {
        return $this->szQueryName;
    }
    /**
     * Set szQueryName value
     * @param string $szQueryName
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetDynamicQuery
     */
    public function setSzQueryName(?string $szQueryName): self
    {
        // validation for constraint: string
        if (!is_null($szQueryName) && !is_string($szQueryName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($szQueryName, true), gettype($szQueryName)), __LINE__);
        }
        $this->szQueryName = $szQueryName;
        
        return $this;
    }
}
