<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IndividualAddress_Chapter_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class IndividualAddress_Chapter_DataObjectType extends AbstractStructBase
{
    /**
     * The chp_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Chapter Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $chp_cst_key = null;
    /**
     * The chp_name
     * Meta information extracted from the WSDL
     * - documentation: Chapter Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_name = null;
    /**
     * The chp_website
     * Meta information extracted from the WSDL
     * - documentation: Website. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_website = null;
    /**
     * The chp_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_add_user = null;
    /**
     * The chp_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_add_date = null;
    /**
     * The chp_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_change_user = null;
    /**
     * The chp_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_change_date = null;
    /**
     * The chp_charter_date
     * Meta information extracted from the WSDL
     * - documentation: Date Chartered. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_charter_date = null;
    /**
     * The chp_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_delete_flag = null;
    /**
     * The chp_cst_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $chp_cst_key_ext = null;
    /**
     * The chp_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_description = null;
    /**
     * The chp_terminate_date
     * Meta information extracted from the WSDL
     * - documentation: Terminate Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_terminate_date = null;
    /**
     * The chp_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $chp_ind_cst_key = null;
    /**
     * The chp_asn_key
     * Meta information extracted from the WSDL
     * - documentation: Association. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $chp_asn_key = null;
    /**
     * The chp_code
     * Meta information extracted from the WSDL
     * - documentation: Chapter Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_code = null;
    /**
     * The chp_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $chp_entity_key = null;
    /**
     * The chp_chapter_number
     * Meta information extracted from the WSDL
     * - documentation: Chapter Number. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $chp_chapter_number = null;
    /**
     * The chp_html_description
     * Meta information extracted from the WSDL
     * - documentation: html description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $chp_html_description = null;
    /**
     * The chp_cht_key
     * Meta information extracted from the WSDL
     * - documentation: Chapter Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $chp_cht_key = null;
    /**
     * The chp_chs_key
     * Meta information extracted from the WSDL
     * - documentation: Chapter Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $chp_chs_key = null;
    /**
     * Constructor method for IndividualAddress_Chapter_DataObjectType
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_cst_key()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_name()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_website()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_add_user()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_add_date()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_change_user()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_change_date()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_charter_date()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_delete_flag()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_cst_key_ext()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_description()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_terminate_date()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_ind_cst_key()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_asn_key()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_code()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_entity_key()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_chapter_number()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_html_description()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_cht_key()
     * @uses IndividualAddress_Chapter_DataObjectType::setChp_chs_key()
     * @param string $chp_cst_key
     * @param string $chp_name
     * @param string $chp_website
     * @param string $chp_add_user
     * @param string $chp_add_date
     * @param string $chp_change_user
     * @param string $chp_change_date
     * @param string $chp_charter_date
     * @param string $chp_delete_flag
     * @param string $chp_cst_key_ext
     * @param string $chp_description
     * @param string $chp_terminate_date
     * @param string $chp_ind_cst_key
     * @param string $chp_asn_key
     * @param string $chp_code
     * @param string $chp_entity_key
     * @param int $chp_chapter_number
     * @param string $chp_html_description
     * @param string $chp_cht_key
     * @param string $chp_chs_key
     */
    public function __construct(?string $chp_cst_key = null, ?string $chp_name = null, ?string $chp_website = null, ?string $chp_add_user = null, ?string $chp_add_date = null, ?string $chp_change_user = null, ?string $chp_change_date = null, ?string $chp_charter_date = null, ?string $chp_delete_flag = null, ?string $chp_cst_key_ext = null, ?string $chp_description = null, ?string $chp_terminate_date = null, ?string $chp_ind_cst_key = null, ?string $chp_asn_key = null, ?string $chp_code = null, ?string $chp_entity_key = null, ?int $chp_chapter_number = null, ?string $chp_html_description = null, ?string $chp_cht_key = null, ?string $chp_chs_key = null)
    {
        $this
            ->setChp_cst_key($chp_cst_key)
            ->setChp_name($chp_name)
            ->setChp_website($chp_website)
            ->setChp_add_user($chp_add_user)
            ->setChp_add_date($chp_add_date)
            ->setChp_change_user($chp_change_user)
            ->setChp_change_date($chp_change_date)
            ->setChp_charter_date($chp_charter_date)
            ->setChp_delete_flag($chp_delete_flag)
            ->setChp_cst_key_ext($chp_cst_key_ext)
            ->setChp_description($chp_description)
            ->setChp_terminate_date($chp_terminate_date)
            ->setChp_ind_cst_key($chp_ind_cst_key)
            ->setChp_asn_key($chp_asn_key)
            ->setChp_code($chp_code)
            ->setChp_entity_key($chp_entity_key)
            ->setChp_chapter_number($chp_chapter_number)
            ->setChp_html_description($chp_html_description)
            ->setChp_cht_key($chp_cht_key)
            ->setChp_chs_key($chp_chs_key);
    }
    /**
     * Get chp_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_cst_key(): ?string
    {
        return $this->chp_cst_key ?? null;
    }
    /**
     * Set chp_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_cst_key(?string $chp_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_cst_key) && !is_string($chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_cst_key, true), gettype($chp_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($chp_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $chp_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($chp_cst_key, true)), __LINE__);
        }
        if (is_null($chp_cst_key) || (is_array($chp_cst_key) && empty($chp_cst_key))) {
            unset($this->chp_cst_key);
        } else {
            $this->chp_cst_key = $chp_cst_key;
        }
        
        return $this;
    }
    /**
     * Get chp_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_name(): ?string
    {
        return $this->chp_name ?? null;
    }
    /**
     * Set chp_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_name(?string $chp_name = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_name) && !is_string($chp_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_name, true), gettype($chp_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($chp_name) && mb_strlen((string) $chp_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $chp_name)), __LINE__);
        }
        if (is_null($chp_name) || (is_array($chp_name) && empty($chp_name))) {
            unset($this->chp_name);
        } else {
            $this->chp_name = $chp_name;
        }
        
        return $this;
    }
    /**
     * Get chp_website value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_website(): ?string
    {
        return $this->chp_website ?? null;
    }
    /**
     * Set chp_website value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_website
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_website(?string $chp_website = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_website) && !is_string($chp_website)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_website, true), gettype($chp_website)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($chp_website) && mb_strlen((string) $chp_website) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $chp_website)), __LINE__);
        }
        if (is_null($chp_website) || (is_array($chp_website) && empty($chp_website))) {
            unset($this->chp_website);
        } else {
            $this->chp_website = $chp_website;
        }
        
        return $this;
    }
    /**
     * Get chp_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_add_user(): ?string
    {
        return $this->chp_add_user ?? null;
    }
    /**
     * Set chp_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_add_user(?string $chp_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_add_user) && !is_string($chp_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_add_user, true), gettype($chp_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($chp_add_user) && mb_strlen((string) $chp_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $chp_add_user)), __LINE__);
        }
        if (is_null($chp_add_user) || (is_array($chp_add_user) && empty($chp_add_user))) {
            unset($this->chp_add_user);
        } else {
            $this->chp_add_user = $chp_add_user;
        }
        
        return $this;
    }
    /**
     * Get chp_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_add_date(): ?string
    {
        return $this->chp_add_date ?? null;
    }
    /**
     * Set chp_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_add_date(?string $chp_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_add_date) && !is_string($chp_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_add_date, true), gettype($chp_add_date)), __LINE__);
        }
        if (is_null($chp_add_date) || (is_array($chp_add_date) && empty($chp_add_date))) {
            unset($this->chp_add_date);
        } else {
            $this->chp_add_date = $chp_add_date;
        }
        
        return $this;
    }
    /**
     * Get chp_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_change_user(): ?string
    {
        return $this->chp_change_user ?? null;
    }
    /**
     * Set chp_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_change_user(?string $chp_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_change_user) && !is_string($chp_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_change_user, true), gettype($chp_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($chp_change_user) && mb_strlen((string) $chp_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $chp_change_user)), __LINE__);
        }
        if (is_null($chp_change_user) || (is_array($chp_change_user) && empty($chp_change_user))) {
            unset($this->chp_change_user);
        } else {
            $this->chp_change_user = $chp_change_user;
        }
        
        return $this;
    }
    /**
     * Get chp_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_change_date(): ?string
    {
        return $this->chp_change_date ?? null;
    }
    /**
     * Set chp_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_change_date(?string $chp_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_change_date) && !is_string($chp_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_change_date, true), gettype($chp_change_date)), __LINE__);
        }
        if (is_null($chp_change_date) || (is_array($chp_change_date) && empty($chp_change_date))) {
            unset($this->chp_change_date);
        } else {
            $this->chp_change_date = $chp_change_date;
        }
        
        return $this;
    }
    /**
     * Get chp_charter_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_charter_date(): ?string
    {
        return $this->chp_charter_date ?? null;
    }
    /**
     * Set chp_charter_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_charter_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_charter_date(?string $chp_charter_date = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_charter_date) && !is_string($chp_charter_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_charter_date, true), gettype($chp_charter_date)), __LINE__);
        }
        if (is_null($chp_charter_date) || (is_array($chp_charter_date) && empty($chp_charter_date))) {
            unset($this->chp_charter_date);
        } else {
            $this->chp_charter_date = $chp_charter_date;
        }
        
        return $this;
    }
    /**
     * Get chp_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_delete_flag(): ?string
    {
        return $this->chp_delete_flag ?? null;
    }
    /**
     * Set chp_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_delete_flag(?string $chp_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_delete_flag) && !is_string($chp_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_delete_flag, true), gettype($chp_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($chp_delete_flag) && $chp_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($chp_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($chp_delete_flag) && $chp_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($chp_delete_flag, true)), __LINE__);
        }
        if (is_null($chp_delete_flag) || (is_array($chp_delete_flag) && empty($chp_delete_flag))) {
            unset($this->chp_delete_flag);
        } else {
            $this->chp_delete_flag = $chp_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get chp_cst_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_cst_key_ext(): ?string
    {
        return $this->chp_cst_key_ext ?? null;
    }
    /**
     * Set chp_cst_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_cst_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_cst_key_ext(?string $chp_cst_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_cst_key_ext) && !is_string($chp_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_cst_key_ext, true), gettype($chp_cst_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($chp_cst_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $chp_cst_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($chp_cst_key_ext, true)), __LINE__);
        }
        if (is_null($chp_cst_key_ext) || (is_array($chp_cst_key_ext) && empty($chp_cst_key_ext))) {
            unset($this->chp_cst_key_ext);
        } else {
            $this->chp_cst_key_ext = $chp_cst_key_ext;
        }
        
        return $this;
    }
    /**
     * Get chp_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_description(): ?string
    {
        return $this->chp_description ?? null;
    }
    /**
     * Set chp_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_description(?string $chp_description = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_description) && !is_string($chp_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_description, true), gettype($chp_description)), __LINE__);
        }
        if (is_null($chp_description) || (is_array($chp_description) && empty($chp_description))) {
            unset($this->chp_description);
        } else {
            $this->chp_description = $chp_description;
        }
        
        return $this;
    }
    /**
     * Get chp_terminate_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_terminate_date(): ?string
    {
        return $this->chp_terminate_date ?? null;
    }
    /**
     * Set chp_terminate_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_terminate_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_terminate_date(?string $chp_terminate_date = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_terminate_date) && !is_string($chp_terminate_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_terminate_date, true), gettype($chp_terminate_date)), __LINE__);
        }
        if (is_null($chp_terminate_date) || (is_array($chp_terminate_date) && empty($chp_terminate_date))) {
            unset($this->chp_terminate_date);
        } else {
            $this->chp_terminate_date = $chp_terminate_date;
        }
        
        return $this;
    }
    /**
     * Get chp_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_ind_cst_key(): ?string
    {
        return $this->chp_ind_cst_key ?? null;
    }
    /**
     * Set chp_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_ind_cst_key(?string $chp_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_ind_cst_key) && !is_string($chp_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_ind_cst_key, true), gettype($chp_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($chp_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $chp_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($chp_ind_cst_key, true)), __LINE__);
        }
        if (is_null($chp_ind_cst_key) || (is_array($chp_ind_cst_key) && empty($chp_ind_cst_key))) {
            unset($this->chp_ind_cst_key);
        } else {
            $this->chp_ind_cst_key = $chp_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get chp_asn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_asn_key(): ?string
    {
        return $this->chp_asn_key ?? null;
    }
    /**
     * Set chp_asn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_asn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_asn_key(?string $chp_asn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_asn_key) && !is_string($chp_asn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_asn_key, true), gettype($chp_asn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($chp_asn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $chp_asn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($chp_asn_key, true)), __LINE__);
        }
        if (is_null($chp_asn_key) || (is_array($chp_asn_key) && empty($chp_asn_key))) {
            unset($this->chp_asn_key);
        } else {
            $this->chp_asn_key = $chp_asn_key;
        }
        
        return $this;
    }
    /**
     * Get chp_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_code(): ?string
    {
        return $this->chp_code ?? null;
    }
    /**
     * Set chp_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_code(?string $chp_code = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_code) && !is_string($chp_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_code, true), gettype($chp_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($chp_code) && mb_strlen((string) $chp_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $chp_code)), __LINE__);
        }
        if (is_null($chp_code) || (is_array($chp_code) && empty($chp_code))) {
            unset($this->chp_code);
        } else {
            $this->chp_code = $chp_code;
        }
        
        return $this;
    }
    /**
     * Get chp_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_entity_key(): ?string
    {
        return $this->chp_entity_key ?? null;
    }
    /**
     * Set chp_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_entity_key(?string $chp_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_entity_key) && !is_string($chp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_entity_key, true), gettype($chp_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($chp_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $chp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($chp_entity_key, true)), __LINE__);
        }
        if (is_null($chp_entity_key) || (is_array($chp_entity_key) && empty($chp_entity_key))) {
            unset($this->chp_entity_key);
        } else {
            $this->chp_entity_key = $chp_entity_key;
        }
        
        return $this;
    }
    /**
     * Get chp_chapter_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getChp_chapter_number(): ?int
    {
        return $this->chp_chapter_number ?? null;
    }
    /**
     * Set chp_chapter_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $chp_chapter_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_chapter_number(?int $chp_chapter_number = null): self
    {
        // validation for constraint: int
        if (!is_null($chp_chapter_number) && !(is_int($chp_chapter_number) || ctype_digit($chp_chapter_number))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chp_chapter_number, true), gettype($chp_chapter_number)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($chp_chapter_number) && $chp_chapter_number > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($chp_chapter_number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($chp_chapter_number) && $chp_chapter_number < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($chp_chapter_number, true)), __LINE__);
        }
        if (is_null($chp_chapter_number) || (is_array($chp_chapter_number) && empty($chp_chapter_number))) {
            unset($this->chp_chapter_number);
        } else {
            $this->chp_chapter_number = $chp_chapter_number;
        }
        
        return $this;
    }
    /**
     * Get chp_html_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_html_description(): ?string
    {
        return $this->chp_html_description ?? null;
    }
    /**
     * Set chp_html_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_html_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_html_description(?string $chp_html_description = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_html_description) && !is_string($chp_html_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_html_description, true), gettype($chp_html_description)), __LINE__);
        }
        if (is_null($chp_html_description) || (is_array($chp_html_description) && empty($chp_html_description))) {
            unset($this->chp_html_description);
        } else {
            $this->chp_html_description = $chp_html_description;
        }
        
        return $this;
    }
    /**
     * Get chp_cht_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_cht_key(): ?string
    {
        return $this->chp_cht_key ?? null;
    }
    /**
     * Set chp_cht_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_cht_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_cht_key(?string $chp_cht_key = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_cht_key) && !is_string($chp_cht_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_cht_key, true), gettype($chp_cht_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($chp_cht_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $chp_cht_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($chp_cht_key, true)), __LINE__);
        }
        if (is_null($chp_cht_key) || (is_array($chp_cht_key) && empty($chp_cht_key))) {
            unset($this->chp_cht_key);
        } else {
            $this->chp_cht_key = $chp_cht_key;
        }
        
        return $this;
    }
    /**
     * Get chp_chs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChp_chs_key(): ?string
    {
        return $this->chp_chs_key ?? null;
    }
    /**
     * Set chp_chs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chp_chs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualAddress_Chapter_DataObjectType
     */
    public function setChp_chs_key(?string $chp_chs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($chp_chs_key) && !is_string($chp_chs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chp_chs_key, true), gettype($chp_chs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($chp_chs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $chp_chs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($chp_chs_key, true)), __LINE__);
        }
        if (is_null($chp_chs_key) || (is_array($chp_chs_key) && empty($chp_chs_key))) {
            unset($this->chp_chs_key);
        } else {
            $this->chp_chs_key = $chp_chs_key;
        }
        
        return $this;
    }
}
