<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IndividualType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class IndividualType extends AbstractStructBase
{
    /**
     * The Individual
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType $Individual = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Customer_DataObjectType $Customer = null;
    /**
     * The Organization_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_XRef_DataObjectType $Organization_XRef = null;
    /**
     * The Organization
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_DataObjectType $Organization = null;
    /**
     * The Email
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Email_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Email_DataObjectType $Email = null;
    /**
     * The Website
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Website_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Website_DataObjectType $Website = null;
    /**
     * The Messaging
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Messaging_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Messaging_DataObjectType $Messaging = null;
    /**
     * The Business_Address_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_XRef_DataObjectType $Business_Address_XRef = null;
    /**
     * The Business_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_DataObjectType $Business_Address = null;
    /**
     * The Business_Address_State
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_State_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_State_DataObjectType $Business_Address_State = null;
    /**
     * The Business_Address_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType $Business_Address_Country = null;
    /**
     * The Business_Phone_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType $Business_Phone_XRef = null;
    /**
     * The Business_Phone
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_DataObjectType $Business_Phone = null;
    /**
     * The Business_Phone_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_Country_DataObjectType $Business_Phone_Country = null;
    /**
     * The Business_Fax_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_XRef_DataObjectType $Business_Fax_XRef = null;
    /**
     * The Business_Fax
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_DataObjectType $Business_Fax = null;
    /**
     * The Business_Fax_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_Country_DataObjectType $Business_Fax_Country = null;
    /**
     * The Home_Address_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_XRef_DataObjectType $Home_Address_XRef = null;
    /**
     * The Home_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_DataObjectType $Home_Address = null;
    /**
     * The Home_Address_State
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_State_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_State_DataObjectType $Home_Address_State = null;
    /**
     * The Home_Address_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType $Home_Address_Country = null;
    /**
     * The Home_Phone
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_DataObjectType $Home_Phone = null;
    /**
     * The Home_Phone_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_Country_DataObjectType $Home_Phone_Country = null;
    /**
     * The Home_Phone_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_XRef_DataObjectType $Home_Phone_XRef = null;
    /**
     * The Home_Fax
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType $Home_Fax = null;
    /**
     * The Home_Fax_Country
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_Country_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_Country_DataObjectType $Home_Fax_Country = null;
    /**
     * The Home_Fax_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType $Home_Fax_XRef = null;
    /**
     * The Address_Change_Log
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType $Address_Change_Log = null;
    /**
     * The TransferToCustomer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_TransferToCustomer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_TransferToCustomer_DataObjectType $TransferToCustomer = null;
    /**
     * The Individual_Custom_Demographics
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_Custom_Demographics_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_Custom_Demographics_DataObjectType $Individual_Custom_Demographics = null;
    /**
     * The Social_Links
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_Social_Links_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Social_Links_DataObjectType $Social_Links = null;
    /**
     * The source_code
     * @var \Drupal\netforum\xWeb\Generated\StructType\Individual_source_code_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Individual_source_code_DataObjectType $source_code = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Primary Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for IndividualType
     * @uses IndividualType::setIndividual()
     * @uses IndividualType::setCustomer()
     * @uses IndividualType::setOrganization_XRef()
     * @uses IndividualType::setOrganization()
     * @uses IndividualType::setEmail()
     * @uses IndividualType::setWebsite()
     * @uses IndividualType::setMessaging()
     * @uses IndividualType::setBusiness_Address_XRef()
     * @uses IndividualType::setBusiness_Address()
     * @uses IndividualType::setBusiness_Address_State()
     * @uses IndividualType::setBusiness_Address_Country()
     * @uses IndividualType::setBusiness_Phone_XRef()
     * @uses IndividualType::setBusiness_Phone()
     * @uses IndividualType::setBusiness_Phone_Country()
     * @uses IndividualType::setBusiness_Fax_XRef()
     * @uses IndividualType::setBusiness_Fax()
     * @uses IndividualType::setBusiness_Fax_Country()
     * @uses IndividualType::setHome_Address_XRef()
     * @uses IndividualType::setHome_Address()
     * @uses IndividualType::setHome_Address_State()
     * @uses IndividualType::setHome_Address_Country()
     * @uses IndividualType::setHome_Phone()
     * @uses IndividualType::setHome_Phone_Country()
     * @uses IndividualType::setHome_Phone_XRef()
     * @uses IndividualType::setHome_Fax()
     * @uses IndividualType::setHome_Fax_Country()
     * @uses IndividualType::setHome_Fax_XRef()
     * @uses IndividualType::setAddress_Change_Log()
     * @uses IndividualType::setTransferToCustomer()
     * @uses IndividualType::setIndividual_Custom_Demographics()
     * @uses IndividualType::setSocial_Links()
     * @uses IndividualType::setSource_code()
     * @uses IndividualType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType $individual
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_XRef_DataObjectType $organization_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_DataObjectType $organization
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Email_DataObjectType $email
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Website_DataObjectType $website
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Messaging_DataObjectType $messaging
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_XRef_DataObjectType $business_Address_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_DataObjectType $business_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_State_DataObjectType $business_Address_State
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType $business_Address_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType $business_Phone_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_DataObjectType $business_Phone
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_Country_DataObjectType $business_Phone_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_XRef_DataObjectType $business_Fax_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_DataObjectType $business_Fax
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_Country_DataObjectType $business_Fax_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_XRef_DataObjectType $home_Address_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_DataObjectType $home_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_State_DataObjectType $home_Address_State
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType $home_Address_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_DataObjectType $home_Phone
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_Country_DataObjectType $home_Phone_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_XRef_DataObjectType $home_Phone_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType $home_Fax
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_Country_DataObjectType $home_Fax_Country
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType $home_Fax_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType $address_Change_Log
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_TransferToCustomer_DataObjectType $transferToCustomer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_Custom_Demographics_DataObjectType $individual_Custom_Demographics
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Social_Links_DataObjectType $social_Links
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_source_code_DataObjectType $source_code
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType $individual = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_XRef_DataObjectType $organization_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_DataObjectType $organization = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Email_DataObjectType $email = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Website_DataObjectType $website = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Messaging_DataObjectType $messaging = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_XRef_DataObjectType $business_Address_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_DataObjectType $business_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_State_DataObjectType $business_Address_State = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType $business_Address_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType $business_Phone_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_DataObjectType $business_Phone = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_Country_DataObjectType $business_Phone_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_XRef_DataObjectType $business_Fax_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_DataObjectType $business_Fax = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_Country_DataObjectType $business_Fax_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_XRef_DataObjectType $home_Address_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_DataObjectType $home_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_State_DataObjectType $home_Address_State = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType $home_Address_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_DataObjectType $home_Phone = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_Country_DataObjectType $home_Phone_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_XRef_DataObjectType $home_Phone_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType $home_Fax = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_Country_DataObjectType $home_Fax_Country = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType $home_Fax_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType $address_Change_Log = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_TransferToCustomer_DataObjectType $transferToCustomer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_Custom_Demographics_DataObjectType $individual_Custom_Demographics = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Social_Links_DataObjectType $social_Links = null, ?\Drupal\netforum\xWeb\Generated\StructType\Individual_source_code_DataObjectType $source_code = null, ?string $currentKey = null)
    {
        $this
            ->setIndividual($individual)
            ->setCustomer($customer)
            ->setOrganization_XRef($organization_XRef)
            ->setOrganization($organization)
            ->setEmail($email)
            ->setWebsite($website)
            ->setMessaging($messaging)
            ->setBusiness_Address_XRef($business_Address_XRef)
            ->setBusiness_Address($business_Address)
            ->setBusiness_Address_State($business_Address_State)
            ->setBusiness_Address_Country($business_Address_Country)
            ->setBusiness_Phone_XRef($business_Phone_XRef)
            ->setBusiness_Phone($business_Phone)
            ->setBusiness_Phone_Country($business_Phone_Country)
            ->setBusiness_Fax_XRef($business_Fax_XRef)
            ->setBusiness_Fax($business_Fax)
            ->setBusiness_Fax_Country($business_Fax_Country)
            ->setHome_Address_XRef($home_Address_XRef)
            ->setHome_Address($home_Address)
            ->setHome_Address_State($home_Address_State)
            ->setHome_Address_Country($home_Address_Country)
            ->setHome_Phone($home_Phone)
            ->setHome_Phone_Country($home_Phone_Country)
            ->setHome_Phone_XRef($home_Phone_XRef)
            ->setHome_Fax($home_Fax)
            ->setHome_Fax_Country($home_Fax_Country)
            ->setHome_Fax_XRef($home_Fax_XRef)
            ->setAddress_Change_Log($address_Change_Log)
            ->setTransferToCustomer($transferToCustomer)
            ->setIndividual_Custom_Demographics($individual_Custom_Demographics)
            ->setSocial_Links($social_Links)
            ->setSource_code($source_code)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Individual value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType|null
     */
    public function getIndividual(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType $individual
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setIndividual(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_DataObjectType $individual = null): self
    {
        $this->Individual = $individual;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Organization_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_XRef_DataObjectType|null
     */
    public function getOrganization_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_XRef_DataObjectType
    {
        return $this->Organization_XRef;
    }
    /**
     * Set Organization_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_XRef_DataObjectType $organization_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setOrganization_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_XRef_DataObjectType $organization_XRef = null): self
    {
        $this->Organization_XRef = $organization_XRef;
        
        return $this;
    }
    /**
     * Get Organization value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_DataObjectType|null
     */
    public function getOrganization(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_DataObjectType
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_DataObjectType $organization
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setOrganization(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Organization_DataObjectType $organization = null): self
    {
        $this->Organization = $organization;
        
        return $this;
    }
    /**
     * Get Email value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Email_DataObjectType|null
     */
    public function getEmail(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Email_DataObjectType
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Email_DataObjectType $email
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setEmail(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Email_DataObjectType $email = null): self
    {
        $this->Email = $email;
        
        return $this;
    }
    /**
     * Get Website value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Website_DataObjectType|null
     */
    public function getWebsite(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Website_DataObjectType
    {
        return $this->Website;
    }
    /**
     * Set Website value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Website_DataObjectType $website
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setWebsite(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Website_DataObjectType $website = null): self
    {
        $this->Website = $website;
        
        return $this;
    }
    /**
     * Get Messaging value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Messaging_DataObjectType|null
     */
    public function getMessaging(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Messaging_DataObjectType
    {
        return $this->Messaging;
    }
    /**
     * Set Messaging value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Messaging_DataObjectType $messaging
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setMessaging(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Messaging_DataObjectType $messaging = null): self
    {
        $this->Messaging = $messaging;
        
        return $this;
    }
    /**
     * Get Business_Address_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_XRef_DataObjectType|null
     */
    public function getBusiness_Address_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_XRef_DataObjectType
    {
        return $this->Business_Address_XRef;
    }
    /**
     * Set Business_Address_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_XRef_DataObjectType $business_Address_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Address_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_XRef_DataObjectType $business_Address_XRef = null): self
    {
        $this->Business_Address_XRef = $business_Address_XRef;
        
        return $this;
    }
    /**
     * Get Business_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_DataObjectType|null
     */
    public function getBusiness_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_DataObjectType
    {
        return $this->Business_Address;
    }
    /**
     * Set Business_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_DataObjectType $business_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Address(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_DataObjectType $business_Address = null): self
    {
        $this->Business_Address = $business_Address;
        
        return $this;
    }
    /**
     * Get Business_Address_State value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_State_DataObjectType|null
     */
    public function getBusiness_Address_State(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_State_DataObjectType
    {
        return $this->Business_Address_State;
    }
    /**
     * Set Business_Address_State value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_State_DataObjectType $business_Address_State
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Address_State(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_State_DataObjectType $business_Address_State = null): self
    {
        $this->Business_Address_State = $business_Address_State;
        
        return $this;
    }
    /**
     * Get Business_Address_Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType|null
     */
    public function getBusiness_Address_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
    {
        return $this->Business_Address_Country;
    }
    /**
     * Set Business_Address_Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType $business_Address_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Address_Country(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType $business_Address_Country = null): self
    {
        $this->Business_Address_Country = $business_Address_Country;
        
        return $this;
    }
    /**
     * Get Business_Phone_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType|null
     */
    public function getBusiness_Phone_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
    {
        return $this->Business_Phone_XRef;
    }
    /**
     * Set Business_Phone_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType $business_Phone_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Phone_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType $business_Phone_XRef = null): self
    {
        $this->Business_Phone_XRef = $business_Phone_XRef;
        
        return $this;
    }
    /**
     * Get Business_Phone value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_DataObjectType|null
     */
    public function getBusiness_Phone(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_DataObjectType
    {
        return $this->Business_Phone;
    }
    /**
     * Set Business_Phone value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_DataObjectType $business_Phone
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Phone(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_DataObjectType $business_Phone = null): self
    {
        $this->Business_Phone = $business_Phone;
        
        return $this;
    }
    /**
     * Get Business_Phone_Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_Country_DataObjectType|null
     */
    public function getBusiness_Phone_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_Country_DataObjectType
    {
        return $this->Business_Phone_Country;
    }
    /**
     * Set Business_Phone_Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_Country_DataObjectType $business_Phone_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Phone_Country(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_Country_DataObjectType $business_Phone_Country = null): self
    {
        $this->Business_Phone_Country = $business_Phone_Country;
        
        return $this;
    }
    /**
     * Get Business_Fax_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_XRef_DataObjectType|null
     */
    public function getBusiness_Fax_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_XRef_DataObjectType
    {
        return $this->Business_Fax_XRef;
    }
    /**
     * Set Business_Fax_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_XRef_DataObjectType $business_Fax_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Fax_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_XRef_DataObjectType $business_Fax_XRef = null): self
    {
        $this->Business_Fax_XRef = $business_Fax_XRef;
        
        return $this;
    }
    /**
     * Get Business_Fax value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_DataObjectType|null
     */
    public function getBusiness_Fax(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_DataObjectType
    {
        return $this->Business_Fax;
    }
    /**
     * Set Business_Fax value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_DataObjectType $business_Fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Fax(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_DataObjectType $business_Fax = null): self
    {
        $this->Business_Fax = $business_Fax;
        
        return $this;
    }
    /**
     * Get Business_Fax_Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_Country_DataObjectType|null
     */
    public function getBusiness_Fax_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_Country_DataObjectType
    {
        return $this->Business_Fax_Country;
    }
    /**
     * Set Business_Fax_Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_Country_DataObjectType $business_Fax_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setBusiness_Fax_Country(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Fax_Country_DataObjectType $business_Fax_Country = null): self
    {
        $this->Business_Fax_Country = $business_Fax_Country;
        
        return $this;
    }
    /**
     * Get Home_Address_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_XRef_DataObjectType|null
     */
    public function getHome_Address_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_XRef_DataObjectType
    {
        return $this->Home_Address_XRef;
    }
    /**
     * Set Home_Address_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_XRef_DataObjectType $home_Address_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Address_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_XRef_DataObjectType $home_Address_XRef = null): self
    {
        $this->Home_Address_XRef = $home_Address_XRef;
        
        return $this;
    }
    /**
     * Get Home_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_DataObjectType|null
     */
    public function getHome_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_DataObjectType
    {
        return $this->Home_Address;
    }
    /**
     * Set Home_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_DataObjectType $home_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Address(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_DataObjectType $home_Address = null): self
    {
        $this->Home_Address = $home_Address;
        
        return $this;
    }
    /**
     * Get Home_Address_State value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_State_DataObjectType|null
     */
    public function getHome_Address_State(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_State_DataObjectType
    {
        return $this->Home_Address_State;
    }
    /**
     * Set Home_Address_State value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_State_DataObjectType $home_Address_State
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Address_State(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_State_DataObjectType $home_Address_State = null): self
    {
        $this->Home_Address_State = $home_Address_State;
        
        return $this;
    }
    /**
     * Get Home_Address_Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType|null
     */
    public function getHome_Address_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
    {
        return $this->Home_Address_Country;
    }
    /**
     * Set Home_Address_Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType $home_Address_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Address_Country(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType $home_Address_Country = null): self
    {
        $this->Home_Address_Country = $home_Address_Country;
        
        return $this;
    }
    /**
     * Get Home_Phone value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_DataObjectType|null
     */
    public function getHome_Phone(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_DataObjectType
    {
        return $this->Home_Phone;
    }
    /**
     * Set Home_Phone value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_DataObjectType $home_Phone
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Phone(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_DataObjectType $home_Phone = null): self
    {
        $this->Home_Phone = $home_Phone;
        
        return $this;
    }
    /**
     * Get Home_Phone_Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_Country_DataObjectType|null
     */
    public function getHome_Phone_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_Country_DataObjectType
    {
        return $this->Home_Phone_Country;
    }
    /**
     * Set Home_Phone_Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_Country_DataObjectType $home_Phone_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Phone_Country(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_Country_DataObjectType $home_Phone_Country = null): self
    {
        $this->Home_Phone_Country = $home_Phone_Country;
        
        return $this;
    }
    /**
     * Get Home_Phone_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_XRef_DataObjectType|null
     */
    public function getHome_Phone_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_XRef_DataObjectType
    {
        return $this->Home_Phone_XRef;
    }
    /**
     * Set Home_Phone_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_XRef_DataObjectType $home_Phone_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Phone_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Phone_XRef_DataObjectType $home_Phone_XRef = null): self
    {
        $this->Home_Phone_XRef = $home_Phone_XRef;
        
        return $this;
    }
    /**
     * Get Home_Fax value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType|null
     */
    public function getHome_Fax(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
    {
        return $this->Home_Fax;
    }
    /**
     * Set Home_Fax value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType $home_Fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Fax(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType $home_Fax = null): self
    {
        $this->Home_Fax = $home_Fax;
        
        return $this;
    }
    /**
     * Get Home_Fax_Country value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_Country_DataObjectType|null
     */
    public function getHome_Fax_Country(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_Country_DataObjectType
    {
        return $this->Home_Fax_Country;
    }
    /**
     * Set Home_Fax_Country value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_Country_DataObjectType $home_Fax_Country
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Fax_Country(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_Country_DataObjectType $home_Fax_Country = null): self
    {
        $this->Home_Fax_Country = $home_Fax_Country;
        
        return $this;
    }
    /**
     * Get Home_Fax_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType|null
     */
    public function getHome_Fax_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType
    {
        return $this->Home_Fax_XRef;
    }
    /**
     * Set Home_Fax_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType $home_Fax_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setHome_Fax_XRef(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_XRef_DataObjectType $home_Fax_XRef = null): self
    {
        $this->Home_Fax_XRef = $home_Fax_XRef;
        
        return $this;
    }
    /**
     * Get Address_Change_Log value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType|null
     */
    public function getAddress_Change_Log(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
    {
        return $this->Address_Change_Log;
    }
    /**
     * Set Address_Change_Log value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType $address_Change_Log
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setAddress_Change_Log(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType $address_Change_Log = null): self
    {
        $this->Address_Change_Log = $address_Change_Log;
        
        return $this;
    }
    /**
     * Get TransferToCustomer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_TransferToCustomer_DataObjectType|null
     */
    public function getTransferToCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_TransferToCustomer_DataObjectType
    {
        return $this->TransferToCustomer;
    }
    /**
     * Set TransferToCustomer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_TransferToCustomer_DataObjectType $transferToCustomer
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setTransferToCustomer(?\Drupal\netforum\xWeb\Generated\StructType\Individual_TransferToCustomer_DataObjectType $transferToCustomer = null): self
    {
        $this->TransferToCustomer = $transferToCustomer;
        
        return $this;
    }
    /**
     * Get Individual_Custom_Demographics value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_Custom_Demographics_DataObjectType|null
     */
    public function getIndividual_Custom_Demographics(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_Custom_Demographics_DataObjectType
    {
        return $this->Individual_Custom_Demographics;
    }
    /**
     * Set Individual_Custom_Demographics value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_Custom_Demographics_DataObjectType $individual_Custom_Demographics
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setIndividual_Custom_Demographics(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Individual_Custom_Demographics_DataObjectType $individual_Custom_Demographics = null): self
    {
        $this->Individual_Custom_Demographics = $individual_Custom_Demographics;
        
        return $this;
    }
    /**
     * Get Social_Links value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Social_Links_DataObjectType|null
     */
    public function getSocial_Links(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_Social_Links_DataObjectType
    {
        return $this->Social_Links;
    }
    /**
     * Set Social_Links value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_Social_Links_DataObjectType $social_Links
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setSocial_Links(?\Drupal\netforum\xWeb\Generated\StructType\Individual_Social_Links_DataObjectType $social_Links = null): self
    {
        $this->Social_Links = $social_Links;
        
        return $this;
    }
    /**
     * Get source_code value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_source_code_DataObjectType|null
     */
    public function getSource_code(): ?\Drupal\netforum\xWeb\Generated\StructType\Individual_source_code_DataObjectType
    {
        return $this->source_code;
    }
    /**
     * Set source_code value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Individual_source_code_DataObjectType $source_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setSource_code(?\Drupal\netforum\xWeb\Generated\StructType\Individual_source_code_DataObjectType $source_code = null): self
    {
        $this->source_code = $source_code;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\IndividualType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
