<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Individual_Address_Change_Log_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Individual_Address_Change_Log_DataObjectType extends AbstractStructBase
{
    /**
     * The acl_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $acl_key = null;
    /**
     * The acl_adr_key
     * Meta information extracted from the WSDL
     * - documentation: Address Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $acl_adr_key = null;
    /**
     * The acl_adn_key
     * Meta information extracted from the WSDL
     * - documentation: Change Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $acl_adn_key = null;
    /**
     * The acl_src_key
     * Meta information extracted from the WSDL
     * - documentation: Change Source. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $acl_src_key = null;
    /**
     * The acl_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $acl_add_user = null;
    /**
     * The acl_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $acl_add_date = null;
    /**
     * The acl_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $acl_change_user = null;
    /**
     * The acl_mailing_label
     * Meta information extracted from the WSDL
     * - documentation: mailing label. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $acl_mailing_label = null;
    /**
     * The acl_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $acl_key_ext = null;
    /**
     * The acl_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $acl_change_date = null;
    /**
     * The acl_mailing_label_html
     * Meta information extracted from the WSDL
     * - documentation: mailing label html. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $acl_mailing_label_html = null;
    /**
     * The acl_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $acl_delete_flag = null;
    /**
     * The acl_new_mailing_label
     * Meta information extracted from the WSDL
     * - documentation: new mailing label. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $acl_new_mailing_label = null;
    /**
     * The acl_new_mailing_label_html
     * Meta information extracted from the WSDL
     * - documentation: new mailing label html. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $acl_new_mailing_label_html = null;
    /**
     * The acl_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $acl_entity_key = null;
    /**
     * The acl_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $acl_cst_key = null;
    /**
     * Constructor method for Individual_Address_Change_Log_DataObjectType
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_key()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_adr_key()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_adn_key()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_src_key()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_add_user()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_add_date()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_change_user()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_mailing_label()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_key_ext()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_change_date()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_mailing_label_html()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_delete_flag()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_new_mailing_label()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_new_mailing_label_html()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_entity_key()
     * @uses Individual_Address_Change_Log_DataObjectType::setAcl_cst_key()
     * @param string $acl_key
     * @param string $acl_adr_key
     * @param string $acl_adn_key
     * @param string $acl_src_key
     * @param string $acl_add_user
     * @param string $acl_add_date
     * @param string $acl_change_user
     * @param string $acl_mailing_label
     * @param string $acl_key_ext
     * @param string $acl_change_date
     * @param string $acl_mailing_label_html
     * @param string $acl_delete_flag
     * @param string $acl_new_mailing_label
     * @param string $acl_new_mailing_label_html
     * @param string $acl_entity_key
     * @param string $acl_cst_key
     */
    public function __construct(?string $acl_key = null, ?string $acl_adr_key = null, ?string $acl_adn_key = null, ?string $acl_src_key = null, ?string $acl_add_user = null, ?string $acl_add_date = null, ?string $acl_change_user = null, ?string $acl_mailing_label = null, ?string $acl_key_ext = null, ?string $acl_change_date = null, ?string $acl_mailing_label_html = null, ?string $acl_delete_flag = null, ?string $acl_new_mailing_label = null, ?string $acl_new_mailing_label_html = null, ?string $acl_entity_key = null, ?string $acl_cst_key = null)
    {
        $this
            ->setAcl_key($acl_key)
            ->setAcl_adr_key($acl_adr_key)
            ->setAcl_adn_key($acl_adn_key)
            ->setAcl_src_key($acl_src_key)
            ->setAcl_add_user($acl_add_user)
            ->setAcl_add_date($acl_add_date)
            ->setAcl_change_user($acl_change_user)
            ->setAcl_mailing_label($acl_mailing_label)
            ->setAcl_key_ext($acl_key_ext)
            ->setAcl_change_date($acl_change_date)
            ->setAcl_mailing_label_html($acl_mailing_label_html)
            ->setAcl_delete_flag($acl_delete_flag)
            ->setAcl_new_mailing_label($acl_new_mailing_label)
            ->setAcl_new_mailing_label_html($acl_new_mailing_label_html)
            ->setAcl_entity_key($acl_entity_key)
            ->setAcl_cst_key($acl_cst_key);
    }
    /**
     * Get acl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_key(): ?string
    {
        return $this->acl_key ?? null;
    }
    /**
     * Set acl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_key(?string $acl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_key) && !is_string($acl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_key, true), gettype($acl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($acl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $acl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($acl_key, true)), __LINE__);
        }
        if (is_null($acl_key) || (is_array($acl_key) && empty($acl_key))) {
            unset($this->acl_key);
        } else {
            $this->acl_key = $acl_key;
        }
        
        return $this;
    }
    /**
     * Get acl_adr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_adr_key(): ?string
    {
        return $this->acl_adr_key ?? null;
    }
    /**
     * Set acl_adr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_adr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_adr_key(?string $acl_adr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_adr_key) && !is_string($acl_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_adr_key, true), gettype($acl_adr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($acl_adr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $acl_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($acl_adr_key, true)), __LINE__);
        }
        if (is_null($acl_adr_key) || (is_array($acl_adr_key) && empty($acl_adr_key))) {
            unset($this->acl_adr_key);
        } else {
            $this->acl_adr_key = $acl_adr_key;
        }
        
        return $this;
    }
    /**
     * Get acl_adn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_adn_key(): ?string
    {
        return $this->acl_adn_key ?? null;
    }
    /**
     * Set acl_adn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_adn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_adn_key(?string $acl_adn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_adn_key) && !is_string($acl_adn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_adn_key, true), gettype($acl_adn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($acl_adn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $acl_adn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($acl_adn_key, true)), __LINE__);
        }
        if (is_null($acl_adn_key) || (is_array($acl_adn_key) && empty($acl_adn_key))) {
            unset($this->acl_adn_key);
        } else {
            $this->acl_adn_key = $acl_adn_key;
        }
        
        return $this;
    }
    /**
     * Get acl_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_src_key(): ?string
    {
        return $this->acl_src_key ?? null;
    }
    /**
     * Set acl_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_src_key(?string $acl_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_src_key) && !is_string($acl_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_src_key, true), gettype($acl_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($acl_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $acl_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($acl_src_key, true)), __LINE__);
        }
        if (is_null($acl_src_key) || (is_array($acl_src_key) && empty($acl_src_key))) {
            unset($this->acl_src_key);
        } else {
            $this->acl_src_key = $acl_src_key;
        }
        
        return $this;
    }
    /**
     * Get acl_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_add_user(): ?string
    {
        return $this->acl_add_user ?? null;
    }
    /**
     * Set acl_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_add_user(?string $acl_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_add_user) && !is_string($acl_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_add_user, true), gettype($acl_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($acl_add_user) && mb_strlen((string) $acl_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $acl_add_user)), __LINE__);
        }
        if (is_null($acl_add_user) || (is_array($acl_add_user) && empty($acl_add_user))) {
            unset($this->acl_add_user);
        } else {
            $this->acl_add_user = $acl_add_user;
        }
        
        return $this;
    }
    /**
     * Get acl_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_add_date(): ?string
    {
        return $this->acl_add_date ?? null;
    }
    /**
     * Set acl_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_add_date(?string $acl_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_add_date) && !is_string($acl_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_add_date, true), gettype($acl_add_date)), __LINE__);
        }
        if (is_null($acl_add_date) || (is_array($acl_add_date) && empty($acl_add_date))) {
            unset($this->acl_add_date);
        } else {
            $this->acl_add_date = $acl_add_date;
        }
        
        return $this;
    }
    /**
     * Get acl_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_change_user(): ?string
    {
        return $this->acl_change_user ?? null;
    }
    /**
     * Set acl_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_change_user(?string $acl_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_change_user) && !is_string($acl_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_change_user, true), gettype($acl_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($acl_change_user) && mb_strlen((string) $acl_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $acl_change_user)), __LINE__);
        }
        if (is_null($acl_change_user) || (is_array($acl_change_user) && empty($acl_change_user))) {
            unset($this->acl_change_user);
        } else {
            $this->acl_change_user = $acl_change_user;
        }
        
        return $this;
    }
    /**
     * Get acl_mailing_label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_mailing_label(): ?string
    {
        return $this->acl_mailing_label ?? null;
    }
    /**
     * Set acl_mailing_label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_mailing_label
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_mailing_label(?string $acl_mailing_label = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_mailing_label) && !is_string($acl_mailing_label)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_mailing_label, true), gettype($acl_mailing_label)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($acl_mailing_label) && mb_strlen((string) $acl_mailing_label) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $acl_mailing_label)), __LINE__);
        }
        if (is_null($acl_mailing_label) || (is_array($acl_mailing_label) && empty($acl_mailing_label))) {
            unset($this->acl_mailing_label);
        } else {
            $this->acl_mailing_label = $acl_mailing_label;
        }
        
        return $this;
    }
    /**
     * Get acl_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_key_ext(): ?string
    {
        return $this->acl_key_ext ?? null;
    }
    /**
     * Set acl_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_key_ext(?string $acl_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_key_ext) && !is_string($acl_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_key_ext, true), gettype($acl_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($acl_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $acl_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($acl_key_ext, true)), __LINE__);
        }
        if (is_null($acl_key_ext) || (is_array($acl_key_ext) && empty($acl_key_ext))) {
            unset($this->acl_key_ext);
        } else {
            $this->acl_key_ext = $acl_key_ext;
        }
        
        return $this;
    }
    /**
     * Get acl_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_change_date(): ?string
    {
        return $this->acl_change_date ?? null;
    }
    /**
     * Set acl_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_change_date(?string $acl_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_change_date) && !is_string($acl_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_change_date, true), gettype($acl_change_date)), __LINE__);
        }
        if (is_null($acl_change_date) || (is_array($acl_change_date) && empty($acl_change_date))) {
            unset($this->acl_change_date);
        } else {
            $this->acl_change_date = $acl_change_date;
        }
        
        return $this;
    }
    /**
     * Get acl_mailing_label_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_mailing_label_html(): ?string
    {
        return $this->acl_mailing_label_html ?? null;
    }
    /**
     * Set acl_mailing_label_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_mailing_label_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_mailing_label_html(?string $acl_mailing_label_html = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_mailing_label_html) && !is_string($acl_mailing_label_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_mailing_label_html, true), gettype($acl_mailing_label_html)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($acl_mailing_label_html) && mb_strlen((string) $acl_mailing_label_html) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $acl_mailing_label_html)), __LINE__);
        }
        if (is_null($acl_mailing_label_html) || (is_array($acl_mailing_label_html) && empty($acl_mailing_label_html))) {
            unset($this->acl_mailing_label_html);
        } else {
            $this->acl_mailing_label_html = $acl_mailing_label_html;
        }
        
        return $this;
    }
    /**
     * Get acl_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_delete_flag(): ?string
    {
        return $this->acl_delete_flag ?? null;
    }
    /**
     * Set acl_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_delete_flag(?string $acl_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_delete_flag) && !is_string($acl_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_delete_flag, true), gettype($acl_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($acl_delete_flag) && $acl_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($acl_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($acl_delete_flag) && $acl_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($acl_delete_flag, true)), __LINE__);
        }
        if (is_null($acl_delete_flag) || (is_array($acl_delete_flag) && empty($acl_delete_flag))) {
            unset($this->acl_delete_flag);
        } else {
            $this->acl_delete_flag = $acl_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get acl_new_mailing_label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_new_mailing_label(): ?string
    {
        return $this->acl_new_mailing_label ?? null;
    }
    /**
     * Set acl_new_mailing_label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_new_mailing_label
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_new_mailing_label(?string $acl_new_mailing_label = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_new_mailing_label) && !is_string($acl_new_mailing_label)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_new_mailing_label, true), gettype($acl_new_mailing_label)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($acl_new_mailing_label) && mb_strlen((string) $acl_new_mailing_label) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $acl_new_mailing_label)), __LINE__);
        }
        if (is_null($acl_new_mailing_label) || (is_array($acl_new_mailing_label) && empty($acl_new_mailing_label))) {
            unset($this->acl_new_mailing_label);
        } else {
            $this->acl_new_mailing_label = $acl_new_mailing_label;
        }
        
        return $this;
    }
    /**
     * Get acl_new_mailing_label_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_new_mailing_label_html(): ?string
    {
        return $this->acl_new_mailing_label_html ?? null;
    }
    /**
     * Set acl_new_mailing_label_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_new_mailing_label_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_new_mailing_label_html(?string $acl_new_mailing_label_html = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_new_mailing_label_html) && !is_string($acl_new_mailing_label_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_new_mailing_label_html, true), gettype($acl_new_mailing_label_html)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($acl_new_mailing_label_html) && mb_strlen((string) $acl_new_mailing_label_html) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $acl_new_mailing_label_html)), __LINE__);
        }
        if (is_null($acl_new_mailing_label_html) || (is_array($acl_new_mailing_label_html) && empty($acl_new_mailing_label_html))) {
            unset($this->acl_new_mailing_label_html);
        } else {
            $this->acl_new_mailing_label_html = $acl_new_mailing_label_html;
        }
        
        return $this;
    }
    /**
     * Get acl_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_entity_key(): ?string
    {
        return $this->acl_entity_key ?? null;
    }
    /**
     * Set acl_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_entity_key(?string $acl_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_entity_key) && !is_string($acl_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_entity_key, true), gettype($acl_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($acl_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $acl_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($acl_entity_key, true)), __LINE__);
        }
        if (is_null($acl_entity_key) || (is_array($acl_entity_key) && empty($acl_entity_key))) {
            unset($this->acl_entity_key);
        } else {
            $this->acl_entity_key = $acl_entity_key;
        }
        
        return $this;
    }
    /**
     * Get acl_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcl_cst_key(): ?string
    {
        return $this->acl_cst_key ?? null;
    }
    /**
     * Set acl_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acl_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Address_Change_Log_DataObjectType
     */
    public function setAcl_cst_key(?string $acl_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($acl_cst_key) && !is_string($acl_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acl_cst_key, true), gettype($acl_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($acl_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $acl_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($acl_cst_key, true)), __LINE__);
        }
        if (is_null($acl_cst_key) || (is_array($acl_cst_key) && empty($acl_cst_key))) {
            unset($this->acl_cst_key);
        } else {
            $this->acl_cst_key = $acl_cst_key;
        }
        
        return $this;
    }
}
