<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Individual_Business_Address_Country_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Individual_Business_Address_Country_DataObjectType extends AbstractStructBase
{
    /**
     * The cty_code
     * Meta information extracted from the WSDL
     * - documentation: Country. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_code = null;
    /**
     * The cty_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_add_date = null;
    /**
     * The cty_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_add_user = null;
    /**
     * The cty_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_change_date = null;
    /**
     * The cty_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_change_user = null;
    /**
     * The cty_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_delete_flag = null;
    /**
     * The cty_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cty_key = null;
    /**
     * The cty_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cty_key_ext = null;
    /**
     * The cty_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cty_entity_key = null;
    /**
     * The cty_long_name
     * Meta information extracted from the WSDL
     * - documentation: Offical Long Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_long_name = null;
    /**
     * The cty_fips_code
     * Meta information extracted from the WSDL
     * - documentation: FIPS Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_fips_code = null;
    /**
     * The cty_sovereignty
     * Meta information extracted from the WSDL
     * - documentation: Sovereignty. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_sovereignty = null;
    /**
     * The cty_status
     * Meta information extracted from the WSDL
     * - documentation: Dependency Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_status = null;
    /**
     * The cty_capital
     * Meta information extracted from the WSDL
     * - documentation: Capital. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_capital = null;
    /**
     * The cty_idd_code
     * Meta information extracted from the WSDL
     * - documentation: Phone Country Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_idd_code = null;
    /**
     * The cty_rgn_key
     * Meta information extracted from the WSDL
     * - documentation: Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cty_rgn_key = null;
    /**
     * The cty_srg_key
     * Meta information extracted from the WSDL
     * - documentation: Shipping Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cty_srg_key = null;
    /**
     * The cty_postal_input_mask
     * Meta information extracted from the WSDL
     * - documentation: Postal Code Input Mask. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_postal_input_mask = null;
    /**
     * The cty_phone_input_mask
     * Meta information extracted from the WSDL
     * - documentation: Phone/Fax Input Mask. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_phone_input_mask = null;
    /**
     * The cty_currency_code
     * Meta information extracted from the WSDL
     * - documentation: Currency Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_currency_code = null;
    /**
     * The cty_currency_code_description
     * Meta information extracted from the WSDL
     * - documentation: Currency Code Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_currency_code_description = null;
    /**
     * The cty_vat_flag
     * Meta information extracted from the WSDL
     * - documentation: VAT?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_vat_flag = null;
    /**
     * The cty_iso_2
     * Meta information extracted from the WSDL
     * - documentation: ISO Alpha 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_iso_2 = null;
    /**
     * The cty_iso_3
     * Meta information extracted from the WSDL
     * - documentation: ISO Alpha 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_iso_3 = null;
    /**
     * The cty_do_not_ship
     * Meta information extracted from the WSDL
     * - documentation: do not ship. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_do_not_ship = null;
    /**
     * The cty_iso_number
     * Meta information extracted from the WSDL
     * - documentation: ISO Numeric. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_iso_number = null;
    /**
     * The cty_bpa_region
     * Meta information extracted from the WSDL
     * - documentation: BPA Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_bpa_region = null;
    /**
     * The cty_do_not_sell
     * Meta information extracted from the WSDL
     * - documentation: do not sell. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_do_not_sell = null;
    /**
     * The cty_dyn_key
     * Meta information extracted from the WSDL
     * - documentation: Address Sub Form. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cty_dyn_key = null;
    /**
     * The cty_dyn_key_2
     * Meta information extracted from the WSDL
     * - documentation: Address Sub Form 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cty_dyn_key_2 = null;
    /**
     * The cty_cgy_key
     * Meta information extracted from the WSDL
     * - documentation: Country Catagory Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cty_cgy_key = null;
    /**
     * The cty_state_descriptor
     * Meta information extracted from the WSDL
     * - documentation: State/Territory Descriptor.This element has a default value of 'State/Territory'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cty_state_descriptor = null;
    /**
     * Constructor method for Individual_Business_Address_Country_DataObjectType
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_code()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_add_date()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_add_user()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_change_date()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_change_user()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_delete_flag()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_key()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_key_ext()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_entity_key()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_long_name()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_fips_code()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_sovereignty()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_status()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_capital()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_idd_code()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_rgn_key()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_srg_key()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_postal_input_mask()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_phone_input_mask()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_currency_code()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_currency_code_description()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_vat_flag()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_iso_2()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_iso_3()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_do_not_ship()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_iso_number()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_bpa_region()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_do_not_sell()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_dyn_key()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_dyn_key_2()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_cgy_key()
     * @uses Individual_Business_Address_Country_DataObjectType::setCty_state_descriptor()
     * @param string $cty_code
     * @param string $cty_add_date
     * @param string $cty_add_user
     * @param string $cty_change_date
     * @param string $cty_change_user
     * @param string $cty_delete_flag
     * @param string $cty_key
     * @param string $cty_key_ext
     * @param string $cty_entity_key
     * @param string $cty_long_name
     * @param string $cty_fips_code
     * @param string $cty_sovereignty
     * @param string $cty_status
     * @param string $cty_capital
     * @param string $cty_idd_code
     * @param string $cty_rgn_key
     * @param string $cty_srg_key
     * @param string $cty_postal_input_mask
     * @param string $cty_phone_input_mask
     * @param string $cty_currency_code
     * @param string $cty_currency_code_description
     * @param string $cty_vat_flag
     * @param string $cty_iso_2
     * @param string $cty_iso_3
     * @param string $cty_do_not_ship
     * @param string $cty_iso_number
     * @param string $cty_bpa_region
     * @param string $cty_do_not_sell
     * @param string $cty_dyn_key
     * @param string $cty_dyn_key_2
     * @param string $cty_cgy_key
     * @param string $cty_state_descriptor
     */
    public function __construct(?string $cty_code = null, ?string $cty_add_date = null, ?string $cty_add_user = null, ?string $cty_change_date = null, ?string $cty_change_user = null, ?string $cty_delete_flag = null, ?string $cty_key = null, ?string $cty_key_ext = null, ?string $cty_entity_key = null, ?string $cty_long_name = null, ?string $cty_fips_code = null, ?string $cty_sovereignty = null, ?string $cty_status = null, ?string $cty_capital = null, ?string $cty_idd_code = null, ?string $cty_rgn_key = null, ?string $cty_srg_key = null, ?string $cty_postal_input_mask = null, ?string $cty_phone_input_mask = null, ?string $cty_currency_code = null, ?string $cty_currency_code_description = null, ?string $cty_vat_flag = null, ?string $cty_iso_2 = null, ?string $cty_iso_3 = null, ?string $cty_do_not_ship = null, ?string $cty_iso_number = null, ?string $cty_bpa_region = null, ?string $cty_do_not_sell = null, ?string $cty_dyn_key = null, ?string $cty_dyn_key_2 = null, ?string $cty_cgy_key = null, ?string $cty_state_descriptor = null)
    {
        $this
            ->setCty_code($cty_code)
            ->setCty_add_date($cty_add_date)
            ->setCty_add_user($cty_add_user)
            ->setCty_change_date($cty_change_date)
            ->setCty_change_user($cty_change_user)
            ->setCty_delete_flag($cty_delete_flag)
            ->setCty_key($cty_key)
            ->setCty_key_ext($cty_key_ext)
            ->setCty_entity_key($cty_entity_key)
            ->setCty_long_name($cty_long_name)
            ->setCty_fips_code($cty_fips_code)
            ->setCty_sovereignty($cty_sovereignty)
            ->setCty_status($cty_status)
            ->setCty_capital($cty_capital)
            ->setCty_idd_code($cty_idd_code)
            ->setCty_rgn_key($cty_rgn_key)
            ->setCty_srg_key($cty_srg_key)
            ->setCty_postal_input_mask($cty_postal_input_mask)
            ->setCty_phone_input_mask($cty_phone_input_mask)
            ->setCty_currency_code($cty_currency_code)
            ->setCty_currency_code_description($cty_currency_code_description)
            ->setCty_vat_flag($cty_vat_flag)
            ->setCty_iso_2($cty_iso_2)
            ->setCty_iso_3($cty_iso_3)
            ->setCty_do_not_ship($cty_do_not_ship)
            ->setCty_iso_number($cty_iso_number)
            ->setCty_bpa_region($cty_bpa_region)
            ->setCty_do_not_sell($cty_do_not_sell)
            ->setCty_dyn_key($cty_dyn_key)
            ->setCty_dyn_key_2($cty_dyn_key_2)
            ->setCty_cgy_key($cty_cgy_key)
            ->setCty_state_descriptor($cty_state_descriptor);
    }
    /**
     * Get cty_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_code(): ?string
    {
        return $this->cty_code ?? null;
    }
    /**
     * Set cty_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_code(?string $cty_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_code) && !is_string($cty_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_code, true), gettype($cty_code)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($cty_code) && mb_strlen((string) $cty_code) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $cty_code)), __LINE__);
        }
        if (is_null($cty_code) || (is_array($cty_code) && empty($cty_code))) {
            unset($this->cty_code);
        } else {
            $this->cty_code = $cty_code;
        }
        
        return $this;
    }
    /**
     * Get cty_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_add_date(): ?string
    {
        return $this->cty_add_date ?? null;
    }
    /**
     * Set cty_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_add_date(?string $cty_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_add_date) && !is_string($cty_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_add_date, true), gettype($cty_add_date)), __LINE__);
        }
        if (is_null($cty_add_date) || (is_array($cty_add_date) && empty($cty_add_date))) {
            unset($this->cty_add_date);
        } else {
            $this->cty_add_date = $cty_add_date;
        }
        
        return $this;
    }
    /**
     * Get cty_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_add_user(): ?string
    {
        return $this->cty_add_user ?? null;
    }
    /**
     * Set cty_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_add_user(?string $cty_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_add_user) && !is_string($cty_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_add_user, true), gettype($cty_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cty_add_user) && mb_strlen((string) $cty_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cty_add_user)), __LINE__);
        }
        if (is_null($cty_add_user) || (is_array($cty_add_user) && empty($cty_add_user))) {
            unset($this->cty_add_user);
        } else {
            $this->cty_add_user = $cty_add_user;
        }
        
        return $this;
    }
    /**
     * Get cty_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_change_date(): ?string
    {
        return $this->cty_change_date ?? null;
    }
    /**
     * Set cty_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_change_date(?string $cty_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_change_date) && !is_string($cty_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_change_date, true), gettype($cty_change_date)), __LINE__);
        }
        if (is_null($cty_change_date) || (is_array($cty_change_date) && empty($cty_change_date))) {
            unset($this->cty_change_date);
        } else {
            $this->cty_change_date = $cty_change_date;
        }
        
        return $this;
    }
    /**
     * Get cty_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_change_user(): ?string
    {
        return $this->cty_change_user ?? null;
    }
    /**
     * Set cty_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_change_user(?string $cty_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_change_user) && !is_string($cty_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_change_user, true), gettype($cty_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cty_change_user) && mb_strlen((string) $cty_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cty_change_user)), __LINE__);
        }
        if (is_null($cty_change_user) || (is_array($cty_change_user) && empty($cty_change_user))) {
            unset($this->cty_change_user);
        } else {
            $this->cty_change_user = $cty_change_user;
        }
        
        return $this;
    }
    /**
     * Get cty_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_delete_flag(): ?string
    {
        return $this->cty_delete_flag ?? null;
    }
    /**
     * Set cty_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_delete_flag(?string $cty_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_delete_flag) && !is_string($cty_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_delete_flag, true), gettype($cty_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cty_delete_flag) && $cty_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cty_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cty_delete_flag) && $cty_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cty_delete_flag, true)), __LINE__);
        }
        if (is_null($cty_delete_flag) || (is_array($cty_delete_flag) && empty($cty_delete_flag))) {
            unset($this->cty_delete_flag);
        } else {
            $this->cty_delete_flag = $cty_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_key(): ?string
    {
        return $this->cty_key ?? null;
    }
    /**
     * Set cty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_key(?string $cty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_key) && !is_string($cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_key, true), gettype($cty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cty_key, true)), __LINE__);
        }
        if (is_null($cty_key) || (is_array($cty_key) && empty($cty_key))) {
            unset($this->cty_key);
        } else {
            $this->cty_key = $cty_key;
        }
        
        return $this;
    }
    /**
     * Get cty_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_key_ext(): ?string
    {
        return $this->cty_key_ext ?? null;
    }
    /**
     * Set cty_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_key_ext(?string $cty_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_key_ext) && !is_string($cty_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_key_ext, true), gettype($cty_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cty_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cty_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cty_key_ext, true)), __LINE__);
        }
        if (is_null($cty_key_ext) || (is_array($cty_key_ext) && empty($cty_key_ext))) {
            unset($this->cty_key_ext);
        } else {
            $this->cty_key_ext = $cty_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cty_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_entity_key(): ?string
    {
        return $this->cty_entity_key ?? null;
    }
    /**
     * Set cty_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_entity_key(?string $cty_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_entity_key) && !is_string($cty_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_entity_key, true), gettype($cty_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cty_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cty_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cty_entity_key, true)), __LINE__);
        }
        if (is_null($cty_entity_key) || (is_array($cty_entity_key) && empty($cty_entity_key))) {
            unset($this->cty_entity_key);
        } else {
            $this->cty_entity_key = $cty_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cty_long_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_long_name(): ?string
    {
        return $this->cty_long_name ?? null;
    }
    /**
     * Set cty_long_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_long_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_long_name(?string $cty_long_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_long_name) && !is_string($cty_long_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_long_name, true), gettype($cty_long_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cty_long_name) && mb_strlen((string) $cty_long_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cty_long_name)), __LINE__);
        }
        if (is_null($cty_long_name) || (is_array($cty_long_name) && empty($cty_long_name))) {
            unset($this->cty_long_name);
        } else {
            $this->cty_long_name = $cty_long_name;
        }
        
        return $this;
    }
    /**
     * Get cty_fips_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_fips_code(): ?string
    {
        return $this->cty_fips_code ?? null;
    }
    /**
     * Set cty_fips_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_fips_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_fips_code(?string $cty_fips_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_fips_code) && !is_string($cty_fips_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_fips_code, true), gettype($cty_fips_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cty_fips_code) && mb_strlen((string) $cty_fips_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cty_fips_code)), __LINE__);
        }
        if (is_null($cty_fips_code) || (is_array($cty_fips_code) && empty($cty_fips_code))) {
            unset($this->cty_fips_code);
        } else {
            $this->cty_fips_code = $cty_fips_code;
        }
        
        return $this;
    }
    /**
     * Get cty_sovereignty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_sovereignty(): ?string
    {
        return $this->cty_sovereignty ?? null;
    }
    /**
     * Set cty_sovereignty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_sovereignty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_sovereignty(?string $cty_sovereignty = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_sovereignty) && !is_string($cty_sovereignty)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_sovereignty, true), gettype($cty_sovereignty)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($cty_sovereignty) && mb_strlen((string) $cty_sovereignty) > 120) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen((string) $cty_sovereignty)), __LINE__);
        }
        if (is_null($cty_sovereignty) || (is_array($cty_sovereignty) && empty($cty_sovereignty))) {
            unset($this->cty_sovereignty);
        } else {
            $this->cty_sovereignty = $cty_sovereignty;
        }
        
        return $this;
    }
    /**
     * Get cty_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_status(): ?string
    {
        return $this->cty_status ?? null;
    }
    /**
     * Set cty_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_status(?string $cty_status = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_status) && !is_string($cty_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_status, true), gettype($cty_status)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($cty_status) && mb_strlen((string) $cty_status) > 120) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen((string) $cty_status)), __LINE__);
        }
        if (is_null($cty_status) || (is_array($cty_status) && empty($cty_status))) {
            unset($this->cty_status);
        } else {
            $this->cty_status = $cty_status;
        }
        
        return $this;
    }
    /**
     * Get cty_capital value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_capital(): ?string
    {
        return $this->cty_capital ?? null;
    }
    /**
     * Set cty_capital value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_capital
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_capital(?string $cty_capital = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_capital) && !is_string($cty_capital)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_capital, true), gettype($cty_capital)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($cty_capital) && mb_strlen((string) $cty_capital) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $cty_capital)), __LINE__);
        }
        if (is_null($cty_capital) || (is_array($cty_capital) && empty($cty_capital))) {
            unset($this->cty_capital);
        } else {
            $this->cty_capital = $cty_capital;
        }
        
        return $this;
    }
    /**
     * Get cty_idd_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_idd_code(): ?string
    {
        return $this->cty_idd_code ?? null;
    }
    /**
     * Set cty_idd_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_idd_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_idd_code(?string $cty_idd_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_idd_code) && !is_string($cty_idd_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_idd_code, true), gettype($cty_idd_code)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($cty_idd_code) && mb_strlen((string) $cty_idd_code) > 7) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen((string) $cty_idd_code)), __LINE__);
        }
        if (is_null($cty_idd_code) || (is_array($cty_idd_code) && empty($cty_idd_code))) {
            unset($this->cty_idd_code);
        } else {
            $this->cty_idd_code = $cty_idd_code;
        }
        
        return $this;
    }
    /**
     * Get cty_rgn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_rgn_key(): ?string
    {
        return $this->cty_rgn_key ?? null;
    }
    /**
     * Set cty_rgn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_rgn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_rgn_key(?string $cty_rgn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_rgn_key) && !is_string($cty_rgn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_rgn_key, true), gettype($cty_rgn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cty_rgn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cty_rgn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cty_rgn_key, true)), __LINE__);
        }
        if (is_null($cty_rgn_key) || (is_array($cty_rgn_key) && empty($cty_rgn_key))) {
            unset($this->cty_rgn_key);
        } else {
            $this->cty_rgn_key = $cty_rgn_key;
        }
        
        return $this;
    }
    /**
     * Get cty_srg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_srg_key(): ?string
    {
        return $this->cty_srg_key ?? null;
    }
    /**
     * Set cty_srg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_srg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_srg_key(?string $cty_srg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_srg_key) && !is_string($cty_srg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_srg_key, true), gettype($cty_srg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cty_srg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cty_srg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cty_srg_key, true)), __LINE__);
        }
        if (is_null($cty_srg_key) || (is_array($cty_srg_key) && empty($cty_srg_key))) {
            unset($this->cty_srg_key);
        } else {
            $this->cty_srg_key = $cty_srg_key;
        }
        
        return $this;
    }
    /**
     * Get cty_postal_input_mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_postal_input_mask(): ?string
    {
        return $this->cty_postal_input_mask ?? null;
    }
    /**
     * Set cty_postal_input_mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_postal_input_mask
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_postal_input_mask(?string $cty_postal_input_mask = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_postal_input_mask) && !is_string($cty_postal_input_mask)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_postal_input_mask, true), gettype($cty_postal_input_mask)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($cty_postal_input_mask) && mb_strlen((string) $cty_postal_input_mask) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $cty_postal_input_mask)), __LINE__);
        }
        if (is_null($cty_postal_input_mask) || (is_array($cty_postal_input_mask) && empty($cty_postal_input_mask))) {
            unset($this->cty_postal_input_mask);
        } else {
            $this->cty_postal_input_mask = $cty_postal_input_mask;
        }
        
        return $this;
    }
    /**
     * Get cty_phone_input_mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_phone_input_mask(): ?string
    {
        return $this->cty_phone_input_mask ?? null;
    }
    /**
     * Set cty_phone_input_mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_phone_input_mask
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_phone_input_mask(?string $cty_phone_input_mask = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_phone_input_mask) && !is_string($cty_phone_input_mask)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_phone_input_mask, true), gettype($cty_phone_input_mask)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($cty_phone_input_mask) && mb_strlen((string) $cty_phone_input_mask) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $cty_phone_input_mask)), __LINE__);
        }
        if (is_null($cty_phone_input_mask) || (is_array($cty_phone_input_mask) && empty($cty_phone_input_mask))) {
            unset($this->cty_phone_input_mask);
        } else {
            $this->cty_phone_input_mask = $cty_phone_input_mask;
        }
        
        return $this;
    }
    /**
     * Get cty_currency_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_currency_code(): ?string
    {
        return $this->cty_currency_code ?? null;
    }
    /**
     * Set cty_currency_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_currency_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_currency_code(?string $cty_currency_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_currency_code) && !is_string($cty_currency_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_currency_code, true), gettype($cty_currency_code)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($cty_currency_code) && mb_strlen((string) $cty_currency_code) > 3) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen((string) $cty_currency_code)), __LINE__);
        }
        if (is_null($cty_currency_code) || (is_array($cty_currency_code) && empty($cty_currency_code))) {
            unset($this->cty_currency_code);
        } else {
            $this->cty_currency_code = $cty_currency_code;
        }
        
        return $this;
    }
    /**
     * Get cty_currency_code_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_currency_code_description(): ?string
    {
        return $this->cty_currency_code_description ?? null;
    }
    /**
     * Set cty_currency_code_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_currency_code_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_currency_code_description(?string $cty_currency_code_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_currency_code_description) && !is_string($cty_currency_code_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_currency_code_description, true), gettype($cty_currency_code_description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cty_currency_code_description) && mb_strlen((string) $cty_currency_code_description) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cty_currency_code_description)), __LINE__);
        }
        if (is_null($cty_currency_code_description) || (is_array($cty_currency_code_description) && empty($cty_currency_code_description))) {
            unset($this->cty_currency_code_description);
        } else {
            $this->cty_currency_code_description = $cty_currency_code_description;
        }
        
        return $this;
    }
    /**
     * Get cty_vat_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_vat_flag(): ?string
    {
        return $this->cty_vat_flag ?? null;
    }
    /**
     * Set cty_vat_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_vat_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_vat_flag(?string $cty_vat_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_vat_flag) && !is_string($cty_vat_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_vat_flag, true), gettype($cty_vat_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cty_vat_flag) && $cty_vat_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cty_vat_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cty_vat_flag) && $cty_vat_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cty_vat_flag, true)), __LINE__);
        }
        if (is_null($cty_vat_flag) || (is_array($cty_vat_flag) && empty($cty_vat_flag))) {
            unset($this->cty_vat_flag);
        } else {
            $this->cty_vat_flag = $cty_vat_flag;
        }
        
        return $this;
    }
    /**
     * Get cty_iso value
     * @return cty_iso
     */
    public function getCty_iso_2(): ?string
    {
        return $this->cty_iso_2 ?? null;
    }
    /**
     * Set cty_iso value
     * @param cty_iso $cty_iso
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_iso_2(?string $cty_iso_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_iso_2) && !is_string($cty_iso_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_iso_2, true), gettype($cty_iso_2)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($cty_iso_2) && mb_strlen((string) $cty_iso_2) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen((string) $cty_iso_2)), __LINE__);
        }
        if (is_null($cty_iso_2) || (is_array($cty_iso_2) && empty($cty_iso_2))) {
            unset($this->cty_iso_2);
        } else {
            $this->cty_iso_2 = $cty_iso_2;
        }
        
        return $this;
    }
    /**
     * Get cty_iso value
     * @return cty_iso
     */
    public function getCty_iso_3(): ?string
    {
        return $this->cty_iso_3 ?? null;
    }
    /**
     * Set cty_iso value
     * @param cty_iso $cty_iso
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_iso_3(?string $cty_iso_3 = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_iso_3) && !is_string($cty_iso_3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_iso_3, true), gettype($cty_iso_3)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($cty_iso_3) && mb_strlen((string) $cty_iso_3) > 3) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen((string) $cty_iso_3)), __LINE__);
        }
        if (is_null($cty_iso_3) || (is_array($cty_iso_3) && empty($cty_iso_3))) {
            unset($this->cty_iso_3);
        } else {
            $this->cty_iso_3 = $cty_iso_3;
        }
        
        return $this;
    }
    /**
     * Get cty_do_not_ship value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_do_not_ship(): ?string
    {
        return $this->cty_do_not_ship ?? null;
    }
    /**
     * Set cty_do_not_ship value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_do_not_ship
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_do_not_ship(?string $cty_do_not_ship = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_do_not_ship) && !is_string($cty_do_not_ship)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_do_not_ship, true), gettype($cty_do_not_ship)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cty_do_not_ship) && $cty_do_not_ship > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cty_do_not_ship, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cty_do_not_ship) && $cty_do_not_ship < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cty_do_not_ship, true)), __LINE__);
        }
        if (is_null($cty_do_not_ship) || (is_array($cty_do_not_ship) && empty($cty_do_not_ship))) {
            unset($this->cty_do_not_ship);
        } else {
            $this->cty_do_not_ship = $cty_do_not_ship;
        }
        
        return $this;
    }
    /**
     * Get cty_iso_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_iso_number(): ?string
    {
        return $this->cty_iso_number ?? null;
    }
    /**
     * Set cty_iso_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_iso_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_iso_number(?string $cty_iso_number = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_iso_number) && !is_string($cty_iso_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_iso_number, true), gettype($cty_iso_number)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($cty_iso_number) && mb_strlen((string) $cty_iso_number) > 3) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen((string) $cty_iso_number)), __LINE__);
        }
        if (is_null($cty_iso_number) || (is_array($cty_iso_number) && empty($cty_iso_number))) {
            unset($this->cty_iso_number);
        } else {
            $this->cty_iso_number = $cty_iso_number;
        }
        
        return $this;
    }
    /**
     * Get cty_bpa_region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_bpa_region(): ?string
    {
        return $this->cty_bpa_region ?? null;
    }
    /**
     * Set cty_bpa_region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_bpa_region
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_bpa_region(?string $cty_bpa_region = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_bpa_region) && !is_string($cty_bpa_region)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_bpa_region, true), gettype($cty_bpa_region)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($cty_bpa_region) && mb_strlen((string) $cty_bpa_region) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $cty_bpa_region)), __LINE__);
        }
        if (is_null($cty_bpa_region) || (is_array($cty_bpa_region) && empty($cty_bpa_region))) {
            unset($this->cty_bpa_region);
        } else {
            $this->cty_bpa_region = $cty_bpa_region;
        }
        
        return $this;
    }
    /**
     * Get cty_do_not_sell value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_do_not_sell(): ?string
    {
        return $this->cty_do_not_sell ?? null;
    }
    /**
     * Set cty_do_not_sell value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_do_not_sell
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_do_not_sell(?string $cty_do_not_sell = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_do_not_sell) && !is_string($cty_do_not_sell)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_do_not_sell, true), gettype($cty_do_not_sell)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cty_do_not_sell) && $cty_do_not_sell > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cty_do_not_sell, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cty_do_not_sell) && $cty_do_not_sell < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cty_do_not_sell, true)), __LINE__);
        }
        if (is_null($cty_do_not_sell) || (is_array($cty_do_not_sell) && empty($cty_do_not_sell))) {
            unset($this->cty_do_not_sell);
        } else {
            $this->cty_do_not_sell = $cty_do_not_sell;
        }
        
        return $this;
    }
    /**
     * Get cty_dyn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_dyn_key(): ?string
    {
        return $this->cty_dyn_key ?? null;
    }
    /**
     * Set cty_dyn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_dyn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_dyn_key(?string $cty_dyn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_dyn_key) && !is_string($cty_dyn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_dyn_key, true), gettype($cty_dyn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cty_dyn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cty_dyn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cty_dyn_key, true)), __LINE__);
        }
        if (is_null($cty_dyn_key) || (is_array($cty_dyn_key) && empty($cty_dyn_key))) {
            unset($this->cty_dyn_key);
        } else {
            $this->cty_dyn_key = $cty_dyn_key;
        }
        
        return $this;
    }
    /**
     * Get cty_dyn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_dyn_key_2(): ?string
    {
        return $this->cty_dyn_key_2 ?? null;
    }
    /**
     * Set cty_dyn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_dyn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_dyn_key_2(?string $cty_dyn_key_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_dyn_key_2) && !is_string($cty_dyn_key_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_dyn_key_2, true), gettype($cty_dyn_key_2)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cty_dyn_key_2) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cty_dyn_key_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cty_dyn_key_2, true)), __LINE__);
        }
        if (is_null($cty_dyn_key_2) || (is_array($cty_dyn_key_2) && empty($cty_dyn_key_2))) {
            unset($this->cty_dyn_key_2);
        } else {
            $this->cty_dyn_key_2 = $cty_dyn_key_2;
        }
        
        return $this;
    }
    /**
     * Get cty_cgy_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_cgy_key(): ?string
    {
        return $this->cty_cgy_key ?? null;
    }
    /**
     * Set cty_cgy_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_cgy_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_cgy_key(?string $cty_cgy_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_cgy_key) && !is_string($cty_cgy_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_cgy_key, true), gettype($cty_cgy_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cty_cgy_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cty_cgy_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cty_cgy_key, true)), __LINE__);
        }
        if (is_null($cty_cgy_key) || (is_array($cty_cgy_key) && empty($cty_cgy_key))) {
            unset($this->cty_cgy_key);
        } else {
            $this->cty_cgy_key = $cty_cgy_key;
        }
        
        return $this;
    }
    /**
     * Get cty_state_descriptor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCty_state_descriptor(): ?string
    {
        return $this->cty_state_descriptor ?? null;
    }
    /**
     * Set cty_state_descriptor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cty_state_descriptor
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Address_Country_DataObjectType
     */
    public function setCty_state_descriptor(?string $cty_state_descriptor = null): self
    {
        // validation for constraint: string
        if (!is_null($cty_state_descriptor) && !is_string($cty_state_descriptor)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cty_state_descriptor, true), gettype($cty_state_descriptor)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($cty_state_descriptor) && mb_strlen((string) $cty_state_descriptor) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $cty_state_descriptor)), __LINE__);
        }
        if (is_null($cty_state_descriptor) || (is_array($cty_state_descriptor) && empty($cty_state_descriptor))) {
            unset($this->cty_state_descriptor);
        } else {
            $this->cty_state_descriptor = $cty_state_descriptor;
        }
        
        return $this;
    }
}
