<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Individual_Business_Phone_XRef_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Individual_Business_Phone_XRef_DataObjectType extends AbstractStructBase
{
    /**
     * The cph_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cph_key = null;
    /**
     * The cph_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cph_cst_key = null;
    /**
     * The cph_phn_key
     * Meta information extracted from the WSDL
     * - documentation: Phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cph_phn_key = null;
    /**
     * The cph_pht_key
     * Meta information extracted from the WSDL
     * - documentation: Phone Type.This element has a default value of 'f2110a0a-9c30-40a3-8842-54dc0d05d415'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cph_pht_key = null;
    /**
     * The cph_cst_link_key
     * Meta information extracted from the WSDL
     * - documentation: Linked Phone Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cph_cst_link_key = null;
    /**
     * The cph_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_add_user = null;
    /**
     * The cph_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_add_date = null;
    /**
     * The cph_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_change_user = null;
    /**
     * The cph_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_change_date = null;
    /**
     * The cph_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_delete_flag = null;
    /**
     * The cph_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cph_key_ext = null;
    /**
     * The cph_unlisted_flag
     * Meta information extracted from the WSDL
     * - documentation: Unlisted Phone. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_unlisted_flag = null;
    /**
     * The cph_phn_number_complete
     * Meta information extracted from the WSDL
     * - documentation: Phone Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_phn_number_complete = null;
    /**
     * The cph_extension
     * Meta information extracted from the WSDL
     * - documentation: ph. ext.. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_extension = null;
    /**
     * The cph_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cph_entity_key = null;
    /**
     * The cph_primary
     * Meta information extracted from the WSDL
     * - documentation: Primary.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_primary = null;
    /**
     * The cph_owner
     * Meta information extracted from the WSDL
     * - documentation: Phone Owner.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_owner = null;
    /**
     * The cph_sms
     * Meta information extracted from the WSDL
     * - documentation: Preferred SMS/Text Number.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_sms = null;
    /**
     * The cph_PhoneLinkingDropDownList
     * Meta information extracted from the WSDL
     * - documentation: PhoneLinkingDropDownList.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cph_PhoneLinkingDropDownList = null;
    /**
     * Constructor method for Individual_Business_Phone_XRef_DataObjectType
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_key()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_cst_key()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_phn_key()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_pht_key()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_cst_link_key()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_add_user()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_add_date()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_change_user()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_change_date()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_delete_flag()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_key_ext()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_unlisted_flag()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_phn_number_complete()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_extension()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_entity_key()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_primary()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_owner()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_sms()
     * @uses Individual_Business_Phone_XRef_DataObjectType::setCph_PhoneLinkingDropDownList()
     * @param string $cph_key
     * @param string $cph_cst_key
     * @param string $cph_phn_key
     * @param string $cph_pht_key
     * @param string $cph_cst_link_key
     * @param string $cph_add_user
     * @param string $cph_add_date
     * @param string $cph_change_user
     * @param string $cph_change_date
     * @param string $cph_delete_flag
     * @param string $cph_key_ext
     * @param string $cph_unlisted_flag
     * @param string $cph_phn_number_complete
     * @param string $cph_extension
     * @param string $cph_entity_key
     * @param string $cph_primary
     * @param string $cph_owner
     * @param string $cph_sms
     * @param string $cph_PhoneLinkingDropDownList
     */
    public function __construct(?string $cph_key = null, ?string $cph_cst_key = null, ?string $cph_phn_key = null, ?string $cph_pht_key = null, ?string $cph_cst_link_key = null, ?string $cph_add_user = null, ?string $cph_add_date = null, ?string $cph_change_user = null, ?string $cph_change_date = null, ?string $cph_delete_flag = null, ?string $cph_key_ext = null, ?string $cph_unlisted_flag = null, ?string $cph_phn_number_complete = null, ?string $cph_extension = null, ?string $cph_entity_key = null, ?string $cph_primary = null, ?string $cph_owner = null, ?string $cph_sms = null, ?string $cph_PhoneLinkingDropDownList = null)
    {
        $this
            ->setCph_key($cph_key)
            ->setCph_cst_key($cph_cst_key)
            ->setCph_phn_key($cph_phn_key)
            ->setCph_pht_key($cph_pht_key)
            ->setCph_cst_link_key($cph_cst_link_key)
            ->setCph_add_user($cph_add_user)
            ->setCph_add_date($cph_add_date)
            ->setCph_change_user($cph_change_user)
            ->setCph_change_date($cph_change_date)
            ->setCph_delete_flag($cph_delete_flag)
            ->setCph_key_ext($cph_key_ext)
            ->setCph_unlisted_flag($cph_unlisted_flag)
            ->setCph_phn_number_complete($cph_phn_number_complete)
            ->setCph_extension($cph_extension)
            ->setCph_entity_key($cph_entity_key)
            ->setCph_primary($cph_primary)
            ->setCph_owner($cph_owner)
            ->setCph_sms($cph_sms)
            ->setCph_PhoneLinkingDropDownList($cph_PhoneLinkingDropDownList);
    }
    /**
     * Get cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_key(): ?string
    {
        return $this->cph_key ?? null;
    }
    /**
     * Set cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_key(?string $cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_key) && !is_string($cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_key, true), gettype($cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cph_key, true)), __LINE__);
        }
        if (is_null($cph_key) || (is_array($cph_key) && empty($cph_key))) {
            unset($this->cph_key);
        } else {
            $this->cph_key = $cph_key;
        }
        
        return $this;
    }
    /**
     * Get cph_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_cst_key(): ?string
    {
        return $this->cph_cst_key ?? null;
    }
    /**
     * Set cph_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_cst_key(?string $cph_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_cst_key) && !is_string($cph_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_cst_key, true), gettype($cph_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cph_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cph_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cph_cst_key, true)), __LINE__);
        }
        if (is_null($cph_cst_key) || (is_array($cph_cst_key) && empty($cph_cst_key))) {
            unset($this->cph_cst_key);
        } else {
            $this->cph_cst_key = $cph_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cph_phn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_phn_key(): ?string
    {
        return $this->cph_phn_key ?? null;
    }
    /**
     * Set cph_phn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_phn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_phn_key(?string $cph_phn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_phn_key) && !is_string($cph_phn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_phn_key, true), gettype($cph_phn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cph_phn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cph_phn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cph_phn_key, true)), __LINE__);
        }
        if (is_null($cph_phn_key) || (is_array($cph_phn_key) && empty($cph_phn_key))) {
            unset($this->cph_phn_key);
        } else {
            $this->cph_phn_key = $cph_phn_key;
        }
        
        return $this;
    }
    /**
     * Get cph_pht_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_pht_key(): ?string
    {
        return $this->cph_pht_key ?? null;
    }
    /**
     * Set cph_pht_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_pht_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_pht_key(?string $cph_pht_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_pht_key) && !is_string($cph_pht_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_pht_key, true), gettype($cph_pht_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cph_pht_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cph_pht_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cph_pht_key, true)), __LINE__);
        }
        if (is_null($cph_pht_key) || (is_array($cph_pht_key) && empty($cph_pht_key))) {
            unset($this->cph_pht_key);
        } else {
            $this->cph_pht_key = $cph_pht_key;
        }
        
        return $this;
    }
    /**
     * Get cph_cst_link_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_cst_link_key(): ?string
    {
        return $this->cph_cst_link_key ?? null;
    }
    /**
     * Set cph_cst_link_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_cst_link_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_cst_link_key(?string $cph_cst_link_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_cst_link_key) && !is_string($cph_cst_link_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_cst_link_key, true), gettype($cph_cst_link_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cph_cst_link_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cph_cst_link_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cph_cst_link_key, true)), __LINE__);
        }
        if (is_null($cph_cst_link_key) || (is_array($cph_cst_link_key) && empty($cph_cst_link_key))) {
            unset($this->cph_cst_link_key);
        } else {
            $this->cph_cst_link_key = $cph_cst_link_key;
        }
        
        return $this;
    }
    /**
     * Get cph_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_add_user(): ?string
    {
        return $this->cph_add_user ?? null;
    }
    /**
     * Set cph_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_add_user(?string $cph_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_add_user) && !is_string($cph_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_add_user, true), gettype($cph_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cph_add_user) && mb_strlen((string) $cph_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cph_add_user)), __LINE__);
        }
        if (is_null($cph_add_user) || (is_array($cph_add_user) && empty($cph_add_user))) {
            unset($this->cph_add_user);
        } else {
            $this->cph_add_user = $cph_add_user;
        }
        
        return $this;
    }
    /**
     * Get cph_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_add_date(): ?string
    {
        return $this->cph_add_date ?? null;
    }
    /**
     * Set cph_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_add_date(?string $cph_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_add_date) && !is_string($cph_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_add_date, true), gettype($cph_add_date)), __LINE__);
        }
        if (is_null($cph_add_date) || (is_array($cph_add_date) && empty($cph_add_date))) {
            unset($this->cph_add_date);
        } else {
            $this->cph_add_date = $cph_add_date;
        }
        
        return $this;
    }
    /**
     * Get cph_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_change_user(): ?string
    {
        return $this->cph_change_user ?? null;
    }
    /**
     * Set cph_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_change_user(?string $cph_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_change_user) && !is_string($cph_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_change_user, true), gettype($cph_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cph_change_user) && mb_strlen((string) $cph_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cph_change_user)), __LINE__);
        }
        if (is_null($cph_change_user) || (is_array($cph_change_user) && empty($cph_change_user))) {
            unset($this->cph_change_user);
        } else {
            $this->cph_change_user = $cph_change_user;
        }
        
        return $this;
    }
    /**
     * Get cph_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_change_date(): ?string
    {
        return $this->cph_change_date ?? null;
    }
    /**
     * Set cph_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_change_date(?string $cph_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_change_date) && !is_string($cph_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_change_date, true), gettype($cph_change_date)), __LINE__);
        }
        if (is_null($cph_change_date) || (is_array($cph_change_date) && empty($cph_change_date))) {
            unset($this->cph_change_date);
        } else {
            $this->cph_change_date = $cph_change_date;
        }
        
        return $this;
    }
    /**
     * Get cph_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_delete_flag(): ?string
    {
        return $this->cph_delete_flag ?? null;
    }
    /**
     * Set cph_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_delete_flag(?string $cph_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_delete_flag) && !is_string($cph_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_delete_flag, true), gettype($cph_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cph_delete_flag) && $cph_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cph_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cph_delete_flag) && $cph_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cph_delete_flag, true)), __LINE__);
        }
        if (is_null($cph_delete_flag) || (is_array($cph_delete_flag) && empty($cph_delete_flag))) {
            unset($this->cph_delete_flag);
        } else {
            $this->cph_delete_flag = $cph_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cph_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_key_ext(): ?string
    {
        return $this->cph_key_ext ?? null;
    }
    /**
     * Set cph_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_key_ext(?string $cph_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_key_ext) && !is_string($cph_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_key_ext, true), gettype($cph_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cph_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cph_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cph_key_ext, true)), __LINE__);
        }
        if (is_null($cph_key_ext) || (is_array($cph_key_ext) && empty($cph_key_ext))) {
            unset($this->cph_key_ext);
        } else {
            $this->cph_key_ext = $cph_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cph_unlisted_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_unlisted_flag(): ?string
    {
        return $this->cph_unlisted_flag ?? null;
    }
    /**
     * Set cph_unlisted_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_unlisted_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_unlisted_flag(?string $cph_unlisted_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_unlisted_flag) && !is_string($cph_unlisted_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_unlisted_flag, true), gettype($cph_unlisted_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cph_unlisted_flag) && $cph_unlisted_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cph_unlisted_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cph_unlisted_flag) && $cph_unlisted_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cph_unlisted_flag, true)), __LINE__);
        }
        if (is_null($cph_unlisted_flag) || (is_array($cph_unlisted_flag) && empty($cph_unlisted_flag))) {
            unset($this->cph_unlisted_flag);
        } else {
            $this->cph_unlisted_flag = $cph_unlisted_flag;
        }
        
        return $this;
    }
    /**
     * Get cph_phn_number_complete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_phn_number_complete(): ?string
    {
        return $this->cph_phn_number_complete ?? null;
    }
    /**
     * Set cph_phn_number_complete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_phn_number_complete
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_phn_number_complete(?string $cph_phn_number_complete = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_phn_number_complete) && !is_string($cph_phn_number_complete)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_phn_number_complete, true), gettype($cph_phn_number_complete)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($cph_phn_number_complete) && mb_strlen((string) $cph_phn_number_complete) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $cph_phn_number_complete)), __LINE__);
        }
        if (is_null($cph_phn_number_complete) || (is_array($cph_phn_number_complete) && empty($cph_phn_number_complete))) {
            unset($this->cph_phn_number_complete);
        } else {
            $this->cph_phn_number_complete = $cph_phn_number_complete;
        }
        
        return $this;
    }
    /**
     * Get cph_extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_extension(): ?string
    {
        return $this->cph_extension ?? null;
    }
    /**
     * Set cph_extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_extension
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_extension(?string $cph_extension = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_extension) && !is_string($cph_extension)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_extension, true), gettype($cph_extension)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cph_extension) && mb_strlen((string) $cph_extension) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cph_extension)), __LINE__);
        }
        if (is_null($cph_extension) || (is_array($cph_extension) && empty($cph_extension))) {
            unset($this->cph_extension);
        } else {
            $this->cph_extension = $cph_extension;
        }
        
        return $this;
    }
    /**
     * Get cph_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_entity_key(): ?string
    {
        return $this->cph_entity_key ?? null;
    }
    /**
     * Set cph_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_entity_key(?string $cph_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_entity_key) && !is_string($cph_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_entity_key, true), gettype($cph_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cph_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cph_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cph_entity_key, true)), __LINE__);
        }
        if (is_null($cph_entity_key) || (is_array($cph_entity_key) && empty($cph_entity_key))) {
            unset($this->cph_entity_key);
        } else {
            $this->cph_entity_key = $cph_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cph_primary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_primary(): ?string
    {
        return $this->cph_primary ?? null;
    }
    /**
     * Set cph_primary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_primary
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_primary(?string $cph_primary = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_primary) && !is_string($cph_primary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_primary, true), gettype($cph_primary)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cph_primary) && $cph_primary > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cph_primary, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cph_primary) && $cph_primary < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cph_primary, true)), __LINE__);
        }
        if (is_null($cph_primary) || (is_array($cph_primary) && empty($cph_primary))) {
            unset($this->cph_primary);
        } else {
            $this->cph_primary = $cph_primary;
        }
        
        return $this;
    }
    /**
     * Get cph_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_owner(): ?string
    {
        return $this->cph_owner ?? null;
    }
    /**
     * Set cph_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_owner(?string $cph_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_owner) && !is_string($cph_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_owner, true), gettype($cph_owner)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cph_owner) && $cph_owner > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cph_owner, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cph_owner) && $cph_owner < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cph_owner, true)), __LINE__);
        }
        if (is_null($cph_owner) || (is_array($cph_owner) && empty($cph_owner))) {
            unset($this->cph_owner);
        } else {
            $this->cph_owner = $cph_owner;
        }
        
        return $this;
    }
    /**
     * Get cph_sms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_sms(): ?string
    {
        return $this->cph_sms ?? null;
    }
    /**
     * Set cph_sms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_sms
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_sms(?string $cph_sms = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_sms) && !is_string($cph_sms)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_sms, true), gettype($cph_sms)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cph_sms) && $cph_sms > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cph_sms, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cph_sms) && $cph_sms < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cph_sms, true)), __LINE__);
        }
        if (is_null($cph_sms) || (is_array($cph_sms) && empty($cph_sms))) {
            unset($this->cph_sms);
        } else {
            $this->cph_sms = $cph_sms;
        }
        
        return $this;
    }
    /**
     * Get cph_PhoneLinkingDropDownList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCph_PhoneLinkingDropDownList(): ?string
    {
        return $this->cph_PhoneLinkingDropDownList ?? null;
    }
    /**
     * Set cph_PhoneLinkingDropDownList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cph_PhoneLinkingDropDownList
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Business_Phone_XRef_DataObjectType
     */
    public function setCph_PhoneLinkingDropDownList(?string $cph_PhoneLinkingDropDownList = null): self
    {
        // validation for constraint: string
        if (!is_null($cph_PhoneLinkingDropDownList) && !is_string($cph_PhoneLinkingDropDownList)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cph_PhoneLinkingDropDownList, true), gettype($cph_PhoneLinkingDropDownList)), __LINE__);
        }
        if (is_null($cph_PhoneLinkingDropDownList) || (is_array($cph_PhoneLinkingDropDownList) && empty($cph_PhoneLinkingDropDownList))) {
            unset($this->cph_PhoneLinkingDropDownList);
        } else {
            $this->cph_PhoneLinkingDropDownList = $cph_PhoneLinkingDropDownList;
        }
        
        return $this;
    }
}
