<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Individual_Home_Address_Country_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Individual_Home_Address_Country_DataObjectType extends AbstractStructBase
{
    /**
     * The ct2__cty_code
     * Meta information extracted from the WSDL
     * - documentation: Country. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_code = null;
    /**
     * The ct2__cty_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_add_date = null;
    /**
     * The ct2__cty_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_add_user = null;
    /**
     * The ct2__cty_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_change_date = null;
    /**
     * The ct2__cty_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_change_user = null;
    /**
     * The ct2__cty_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_delete_flag = null;
    /**
     * The ct2__cty_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ct2__cty_key = null;
    /**
     * The ct2__cty_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ct2__cty_key_ext = null;
    /**
     * The ct2__cty_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ct2__cty_entity_key = null;
    /**
     * The ct2__cty_long_name
     * Meta information extracted from the WSDL
     * - documentation: Offical Long Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_long_name = null;
    /**
     * The ct2__cty_fips_code
     * Meta information extracted from the WSDL
     * - documentation: FIPS Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_fips_code = null;
    /**
     * The ct2__cty_sovereignty
     * Meta information extracted from the WSDL
     * - documentation: Sovereignty. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_sovereignty = null;
    /**
     * The ct2__cty_status
     * Meta information extracted from the WSDL
     * - documentation: Dependency Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_status = null;
    /**
     * The ct2__cty_capital
     * Meta information extracted from the WSDL
     * - documentation: Capital. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_capital = null;
    /**
     * The ct2__cty_idd_code
     * Meta information extracted from the WSDL
     * - documentation: Phone Country Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_idd_code = null;
    /**
     * The ct2__cty_rgn_key
     * Meta information extracted from the WSDL
     * - documentation: Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ct2__cty_rgn_key = null;
    /**
     * The ct2__cty_srg_key
     * Meta information extracted from the WSDL
     * - documentation: Shipping Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ct2__cty_srg_key = null;
    /**
     * The ct2__cty_postal_input_mask
     * Meta information extracted from the WSDL
     * - documentation: Postal Code Input Mask. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_postal_input_mask = null;
    /**
     * The ct2__cty_phone_input_mask
     * Meta information extracted from the WSDL
     * - documentation: Phone/Fax Input Mask. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_phone_input_mask = null;
    /**
     * The ct2__cty_currency_code
     * Meta information extracted from the WSDL
     * - documentation: Currency Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_currency_code = null;
    /**
     * The ct2__cty_currency_code_description
     * Meta information extracted from the WSDL
     * - documentation: Currency Code Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_currency_code_description = null;
    /**
     * The ct2__cty_vat_flag
     * Meta information extracted from the WSDL
     * - documentation: VAT?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_vat_flag = null;
    /**
     * The ct2__cty_iso_2
     * Meta information extracted from the WSDL
     * - documentation: ISO Alpha 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_iso_2 = null;
    /**
     * The ct2__cty_iso_3
     * Meta information extracted from the WSDL
     * - documentation: ISO Alpha 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_iso_3 = null;
    /**
     * The ct2__cty_do_not_ship
     * Meta information extracted from the WSDL
     * - documentation: do not ship. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_do_not_ship = null;
    /**
     * The ct2__cty_iso_number
     * Meta information extracted from the WSDL
     * - documentation: ISO Numeric. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_iso_number = null;
    /**
     * The ct2__cty_bpa_region
     * Meta information extracted from the WSDL
     * - documentation: BPA Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_bpa_region = null;
    /**
     * The ct2__cty_do_not_sell
     * Meta information extracted from the WSDL
     * - documentation: do not sell. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_do_not_sell = null;
    /**
     * The ct2__cty_dyn_key
     * Meta information extracted from the WSDL
     * - documentation: Address Sub Form. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ct2__cty_dyn_key = null;
    /**
     * The ct2__cty_dyn_key_2
     * Meta information extracted from the WSDL
     * - documentation: Address Sub Form 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ct2__cty_dyn_key_2 = null;
    /**
     * The ct2__cty_cgy_key
     * Meta information extracted from the WSDL
     * - documentation: Country Catagory Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ct2__cty_cgy_key = null;
    /**
     * The ct2__cty_state_descriptor
     * Meta information extracted from the WSDL
     * - documentation: State/Territory Descriptor.This element has a default value of 'State/Territory'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ct2__cty_state_descriptor = null;
    /**
     * Constructor method for Individual_Home_Address_Country_DataObjectType
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_code()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_add_date()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_add_user()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_change_date()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_change_user()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_delete_flag()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_key()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_key_ext()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_entity_key()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_long_name()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_fips_code()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_sovereignty()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_status()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_capital()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_idd_code()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_rgn_key()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_srg_key()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_postal_input_mask()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_phone_input_mask()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_currency_code()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_currency_code_description()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_vat_flag()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_iso_2()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_iso_3()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_do_not_ship()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_iso_number()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_bpa_region()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_do_not_sell()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_dyn_key()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_dyn_key_2()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_cgy_key()
     * @uses Individual_Home_Address_Country_DataObjectType::setCt2__cty_state_descriptor()
     * @param string $ct2__cty_code
     * @param string $ct2__cty_add_date
     * @param string $ct2__cty_add_user
     * @param string $ct2__cty_change_date
     * @param string $ct2__cty_change_user
     * @param string $ct2__cty_delete_flag
     * @param string $ct2__cty_key
     * @param string $ct2__cty_key_ext
     * @param string $ct2__cty_entity_key
     * @param string $ct2__cty_long_name
     * @param string $ct2__cty_fips_code
     * @param string $ct2__cty_sovereignty
     * @param string $ct2__cty_status
     * @param string $ct2__cty_capital
     * @param string $ct2__cty_idd_code
     * @param string $ct2__cty_rgn_key
     * @param string $ct2__cty_srg_key
     * @param string $ct2__cty_postal_input_mask
     * @param string $ct2__cty_phone_input_mask
     * @param string $ct2__cty_currency_code
     * @param string $ct2__cty_currency_code_description
     * @param string $ct2__cty_vat_flag
     * @param string $ct2__cty_iso_2
     * @param string $ct2__cty_iso_3
     * @param string $ct2__cty_do_not_ship
     * @param string $ct2__cty_iso_number
     * @param string $ct2__cty_bpa_region
     * @param string $ct2__cty_do_not_sell
     * @param string $ct2__cty_dyn_key
     * @param string $ct2__cty_dyn_key_2
     * @param string $ct2__cty_cgy_key
     * @param string $ct2__cty_state_descriptor
     */
    public function __construct(?string $ct2__cty_code = null, ?string $ct2__cty_add_date = null, ?string $ct2__cty_add_user = null, ?string $ct2__cty_change_date = null, ?string $ct2__cty_change_user = null, ?string $ct2__cty_delete_flag = null, ?string $ct2__cty_key = null, ?string $ct2__cty_key_ext = null, ?string $ct2__cty_entity_key = null, ?string $ct2__cty_long_name = null, ?string $ct2__cty_fips_code = null, ?string $ct2__cty_sovereignty = null, ?string $ct2__cty_status = null, ?string $ct2__cty_capital = null, ?string $ct2__cty_idd_code = null, ?string $ct2__cty_rgn_key = null, ?string $ct2__cty_srg_key = null, ?string $ct2__cty_postal_input_mask = null, ?string $ct2__cty_phone_input_mask = null, ?string $ct2__cty_currency_code = null, ?string $ct2__cty_currency_code_description = null, ?string $ct2__cty_vat_flag = null, ?string $ct2__cty_iso_2 = null, ?string $ct2__cty_iso_3 = null, ?string $ct2__cty_do_not_ship = null, ?string $ct2__cty_iso_number = null, ?string $ct2__cty_bpa_region = null, ?string $ct2__cty_do_not_sell = null, ?string $ct2__cty_dyn_key = null, ?string $ct2__cty_dyn_key_2 = null, ?string $ct2__cty_cgy_key = null, ?string $ct2__cty_state_descriptor = null)
    {
        $this
            ->setCt2__cty_code($ct2__cty_code)
            ->setCt2__cty_add_date($ct2__cty_add_date)
            ->setCt2__cty_add_user($ct2__cty_add_user)
            ->setCt2__cty_change_date($ct2__cty_change_date)
            ->setCt2__cty_change_user($ct2__cty_change_user)
            ->setCt2__cty_delete_flag($ct2__cty_delete_flag)
            ->setCt2__cty_key($ct2__cty_key)
            ->setCt2__cty_key_ext($ct2__cty_key_ext)
            ->setCt2__cty_entity_key($ct2__cty_entity_key)
            ->setCt2__cty_long_name($ct2__cty_long_name)
            ->setCt2__cty_fips_code($ct2__cty_fips_code)
            ->setCt2__cty_sovereignty($ct2__cty_sovereignty)
            ->setCt2__cty_status($ct2__cty_status)
            ->setCt2__cty_capital($ct2__cty_capital)
            ->setCt2__cty_idd_code($ct2__cty_idd_code)
            ->setCt2__cty_rgn_key($ct2__cty_rgn_key)
            ->setCt2__cty_srg_key($ct2__cty_srg_key)
            ->setCt2__cty_postal_input_mask($ct2__cty_postal_input_mask)
            ->setCt2__cty_phone_input_mask($ct2__cty_phone_input_mask)
            ->setCt2__cty_currency_code($ct2__cty_currency_code)
            ->setCt2__cty_currency_code_description($ct2__cty_currency_code_description)
            ->setCt2__cty_vat_flag($ct2__cty_vat_flag)
            ->setCt2__cty_iso_2($ct2__cty_iso_2)
            ->setCt2__cty_iso_3($ct2__cty_iso_3)
            ->setCt2__cty_do_not_ship($ct2__cty_do_not_ship)
            ->setCt2__cty_iso_number($ct2__cty_iso_number)
            ->setCt2__cty_bpa_region($ct2__cty_bpa_region)
            ->setCt2__cty_do_not_sell($ct2__cty_do_not_sell)
            ->setCt2__cty_dyn_key($ct2__cty_dyn_key)
            ->setCt2__cty_dyn_key_2($ct2__cty_dyn_key_2)
            ->setCt2__cty_cgy_key($ct2__cty_cgy_key)
            ->setCt2__cty_state_descriptor($ct2__cty_state_descriptor);
    }
    /**
     * Get ct2__cty_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_code(): ?string
    {
        return $this->ct2__cty_code ?? null;
    }
    /**
     * Set ct2__cty_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_code(?string $ct2__cty_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_code) && !is_string($ct2__cty_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_code, true), gettype($ct2__cty_code)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($ct2__cty_code) && mb_strlen((string) $ct2__cty_code) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $ct2__cty_code)), __LINE__);
        }
        if (is_null($ct2__cty_code) || (is_array($ct2__cty_code) && empty($ct2__cty_code))) {
            unset($this->ct2__cty_code);
        } else {
            $this->ct2__cty_code = $ct2__cty_code;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_add_date(): ?string
    {
        return $this->ct2__cty_add_date ?? null;
    }
    /**
     * Set ct2__cty_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_add_date(?string $ct2__cty_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_add_date) && !is_string($ct2__cty_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_add_date, true), gettype($ct2__cty_add_date)), __LINE__);
        }
        if (is_null($ct2__cty_add_date) || (is_array($ct2__cty_add_date) && empty($ct2__cty_add_date))) {
            unset($this->ct2__cty_add_date);
        } else {
            $this->ct2__cty_add_date = $ct2__cty_add_date;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_add_user(): ?string
    {
        return $this->ct2__cty_add_user ?? null;
    }
    /**
     * Set ct2__cty_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_add_user(?string $ct2__cty_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_add_user) && !is_string($ct2__cty_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_add_user, true), gettype($ct2__cty_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ct2__cty_add_user) && mb_strlen((string) $ct2__cty_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ct2__cty_add_user)), __LINE__);
        }
        if (is_null($ct2__cty_add_user) || (is_array($ct2__cty_add_user) && empty($ct2__cty_add_user))) {
            unset($this->ct2__cty_add_user);
        } else {
            $this->ct2__cty_add_user = $ct2__cty_add_user;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_change_date(): ?string
    {
        return $this->ct2__cty_change_date ?? null;
    }
    /**
     * Set ct2__cty_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_change_date(?string $ct2__cty_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_change_date) && !is_string($ct2__cty_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_change_date, true), gettype($ct2__cty_change_date)), __LINE__);
        }
        if (is_null($ct2__cty_change_date) || (is_array($ct2__cty_change_date) && empty($ct2__cty_change_date))) {
            unset($this->ct2__cty_change_date);
        } else {
            $this->ct2__cty_change_date = $ct2__cty_change_date;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_change_user(): ?string
    {
        return $this->ct2__cty_change_user ?? null;
    }
    /**
     * Set ct2__cty_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_change_user(?string $ct2__cty_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_change_user) && !is_string($ct2__cty_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_change_user, true), gettype($ct2__cty_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ct2__cty_change_user) && mb_strlen((string) $ct2__cty_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ct2__cty_change_user)), __LINE__);
        }
        if (is_null($ct2__cty_change_user) || (is_array($ct2__cty_change_user) && empty($ct2__cty_change_user))) {
            unset($this->ct2__cty_change_user);
        } else {
            $this->ct2__cty_change_user = $ct2__cty_change_user;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_delete_flag(): ?string
    {
        return $this->ct2__cty_delete_flag ?? null;
    }
    /**
     * Set ct2__cty_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_delete_flag(?string $ct2__cty_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_delete_flag) && !is_string($ct2__cty_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_delete_flag, true), gettype($ct2__cty_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ct2__cty_delete_flag) && $ct2__cty_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ct2__cty_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ct2__cty_delete_flag) && $ct2__cty_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ct2__cty_delete_flag, true)), __LINE__);
        }
        if (is_null($ct2__cty_delete_flag) || (is_array($ct2__cty_delete_flag) && empty($ct2__cty_delete_flag))) {
            unset($this->ct2__cty_delete_flag);
        } else {
            $this->ct2__cty_delete_flag = $ct2__cty_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_key(): ?string
    {
        return $this->ct2__cty_key ?? null;
    }
    /**
     * Set ct2__cty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_key(?string $ct2__cty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_key) && !is_string($ct2__cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_key, true), gettype($ct2__cty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ct2__cty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ct2__cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ct2__cty_key, true)), __LINE__);
        }
        if (is_null($ct2__cty_key) || (is_array($ct2__cty_key) && empty($ct2__cty_key))) {
            unset($this->ct2__cty_key);
        } else {
            $this->ct2__cty_key = $ct2__cty_key;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_key_ext(): ?string
    {
        return $this->ct2__cty_key_ext ?? null;
    }
    /**
     * Set ct2__cty_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_key_ext(?string $ct2__cty_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_key_ext) && !is_string($ct2__cty_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_key_ext, true), gettype($ct2__cty_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ct2__cty_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ct2__cty_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ct2__cty_key_ext, true)), __LINE__);
        }
        if (is_null($ct2__cty_key_ext) || (is_array($ct2__cty_key_ext) && empty($ct2__cty_key_ext))) {
            unset($this->ct2__cty_key_ext);
        } else {
            $this->ct2__cty_key_ext = $ct2__cty_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_entity_key(): ?string
    {
        return $this->ct2__cty_entity_key ?? null;
    }
    /**
     * Set ct2__cty_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_entity_key(?string $ct2__cty_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_entity_key) && !is_string($ct2__cty_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_entity_key, true), gettype($ct2__cty_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ct2__cty_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ct2__cty_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ct2__cty_entity_key, true)), __LINE__);
        }
        if (is_null($ct2__cty_entity_key) || (is_array($ct2__cty_entity_key) && empty($ct2__cty_entity_key))) {
            unset($this->ct2__cty_entity_key);
        } else {
            $this->ct2__cty_entity_key = $ct2__cty_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_long_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_long_name(): ?string
    {
        return $this->ct2__cty_long_name ?? null;
    }
    /**
     * Set ct2__cty_long_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_long_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_long_name(?string $ct2__cty_long_name = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_long_name) && !is_string($ct2__cty_long_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_long_name, true), gettype($ct2__cty_long_name)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($ct2__cty_long_name) && mb_strlen((string) $ct2__cty_long_name) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $ct2__cty_long_name)), __LINE__);
        }
        if (is_null($ct2__cty_long_name) || (is_array($ct2__cty_long_name) && empty($ct2__cty_long_name))) {
            unset($this->ct2__cty_long_name);
        } else {
            $this->ct2__cty_long_name = $ct2__cty_long_name;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_fips_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_fips_code(): ?string
    {
        return $this->ct2__cty_fips_code ?? null;
    }
    /**
     * Set ct2__cty_fips_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_fips_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_fips_code(?string $ct2__cty_fips_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_fips_code) && !is_string($ct2__cty_fips_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_fips_code, true), gettype($ct2__cty_fips_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ct2__cty_fips_code) && mb_strlen((string) $ct2__cty_fips_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ct2__cty_fips_code)), __LINE__);
        }
        if (is_null($ct2__cty_fips_code) || (is_array($ct2__cty_fips_code) && empty($ct2__cty_fips_code))) {
            unset($this->ct2__cty_fips_code);
        } else {
            $this->ct2__cty_fips_code = $ct2__cty_fips_code;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_sovereignty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_sovereignty(): ?string
    {
        return $this->ct2__cty_sovereignty ?? null;
    }
    /**
     * Set ct2__cty_sovereignty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_sovereignty
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_sovereignty(?string $ct2__cty_sovereignty = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_sovereignty) && !is_string($ct2__cty_sovereignty)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_sovereignty, true), gettype($ct2__cty_sovereignty)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($ct2__cty_sovereignty) && mb_strlen((string) $ct2__cty_sovereignty) > 120) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen((string) $ct2__cty_sovereignty)), __LINE__);
        }
        if (is_null($ct2__cty_sovereignty) || (is_array($ct2__cty_sovereignty) && empty($ct2__cty_sovereignty))) {
            unset($this->ct2__cty_sovereignty);
        } else {
            $this->ct2__cty_sovereignty = $ct2__cty_sovereignty;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_status(): ?string
    {
        return $this->ct2__cty_status ?? null;
    }
    /**
     * Set ct2__cty_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_status(?string $ct2__cty_status = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_status) && !is_string($ct2__cty_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_status, true), gettype($ct2__cty_status)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($ct2__cty_status) && mb_strlen((string) $ct2__cty_status) > 120) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen((string) $ct2__cty_status)), __LINE__);
        }
        if (is_null($ct2__cty_status) || (is_array($ct2__cty_status) && empty($ct2__cty_status))) {
            unset($this->ct2__cty_status);
        } else {
            $this->ct2__cty_status = $ct2__cty_status;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_capital value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_capital(): ?string
    {
        return $this->ct2__cty_capital ?? null;
    }
    /**
     * Set ct2__cty_capital value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_capital
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_capital(?string $ct2__cty_capital = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_capital) && !is_string($ct2__cty_capital)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_capital, true), gettype($ct2__cty_capital)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($ct2__cty_capital) && mb_strlen((string) $ct2__cty_capital) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $ct2__cty_capital)), __LINE__);
        }
        if (is_null($ct2__cty_capital) || (is_array($ct2__cty_capital) && empty($ct2__cty_capital))) {
            unset($this->ct2__cty_capital);
        } else {
            $this->ct2__cty_capital = $ct2__cty_capital;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_idd_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_idd_code(): ?string
    {
        return $this->ct2__cty_idd_code ?? null;
    }
    /**
     * Set ct2__cty_idd_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_idd_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_idd_code(?string $ct2__cty_idd_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_idd_code) && !is_string($ct2__cty_idd_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_idd_code, true), gettype($ct2__cty_idd_code)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($ct2__cty_idd_code) && mb_strlen((string) $ct2__cty_idd_code) > 7) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen((string) $ct2__cty_idd_code)), __LINE__);
        }
        if (is_null($ct2__cty_idd_code) || (is_array($ct2__cty_idd_code) && empty($ct2__cty_idd_code))) {
            unset($this->ct2__cty_idd_code);
        } else {
            $this->ct2__cty_idd_code = $ct2__cty_idd_code;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_rgn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_rgn_key(): ?string
    {
        return $this->ct2__cty_rgn_key ?? null;
    }
    /**
     * Set ct2__cty_rgn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_rgn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_rgn_key(?string $ct2__cty_rgn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_rgn_key) && !is_string($ct2__cty_rgn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_rgn_key, true), gettype($ct2__cty_rgn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ct2__cty_rgn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ct2__cty_rgn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ct2__cty_rgn_key, true)), __LINE__);
        }
        if (is_null($ct2__cty_rgn_key) || (is_array($ct2__cty_rgn_key) && empty($ct2__cty_rgn_key))) {
            unset($this->ct2__cty_rgn_key);
        } else {
            $this->ct2__cty_rgn_key = $ct2__cty_rgn_key;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_srg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_srg_key(): ?string
    {
        return $this->ct2__cty_srg_key ?? null;
    }
    /**
     * Set ct2__cty_srg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_srg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_srg_key(?string $ct2__cty_srg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_srg_key) && !is_string($ct2__cty_srg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_srg_key, true), gettype($ct2__cty_srg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ct2__cty_srg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ct2__cty_srg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ct2__cty_srg_key, true)), __LINE__);
        }
        if (is_null($ct2__cty_srg_key) || (is_array($ct2__cty_srg_key) && empty($ct2__cty_srg_key))) {
            unset($this->ct2__cty_srg_key);
        } else {
            $this->ct2__cty_srg_key = $ct2__cty_srg_key;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_postal_input_mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_postal_input_mask(): ?string
    {
        return $this->ct2__cty_postal_input_mask ?? null;
    }
    /**
     * Set ct2__cty_postal_input_mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_postal_input_mask
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_postal_input_mask(?string $ct2__cty_postal_input_mask = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_postal_input_mask) && !is_string($ct2__cty_postal_input_mask)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_postal_input_mask, true), gettype($ct2__cty_postal_input_mask)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($ct2__cty_postal_input_mask) && mb_strlen((string) $ct2__cty_postal_input_mask) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $ct2__cty_postal_input_mask)), __LINE__);
        }
        if (is_null($ct2__cty_postal_input_mask) || (is_array($ct2__cty_postal_input_mask) && empty($ct2__cty_postal_input_mask))) {
            unset($this->ct2__cty_postal_input_mask);
        } else {
            $this->ct2__cty_postal_input_mask = $ct2__cty_postal_input_mask;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_phone_input_mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_phone_input_mask(): ?string
    {
        return $this->ct2__cty_phone_input_mask ?? null;
    }
    /**
     * Set ct2__cty_phone_input_mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_phone_input_mask
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_phone_input_mask(?string $ct2__cty_phone_input_mask = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_phone_input_mask) && !is_string($ct2__cty_phone_input_mask)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_phone_input_mask, true), gettype($ct2__cty_phone_input_mask)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($ct2__cty_phone_input_mask) && mb_strlen((string) $ct2__cty_phone_input_mask) > 255) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen((string) $ct2__cty_phone_input_mask)), __LINE__);
        }
        if (is_null($ct2__cty_phone_input_mask) || (is_array($ct2__cty_phone_input_mask) && empty($ct2__cty_phone_input_mask))) {
            unset($this->ct2__cty_phone_input_mask);
        } else {
            $this->ct2__cty_phone_input_mask = $ct2__cty_phone_input_mask;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_currency_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_currency_code(): ?string
    {
        return $this->ct2__cty_currency_code ?? null;
    }
    /**
     * Set ct2__cty_currency_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_currency_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_currency_code(?string $ct2__cty_currency_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_currency_code) && !is_string($ct2__cty_currency_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_currency_code, true), gettype($ct2__cty_currency_code)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ct2__cty_currency_code) && mb_strlen((string) $ct2__cty_currency_code) > 3) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen((string) $ct2__cty_currency_code)), __LINE__);
        }
        if (is_null($ct2__cty_currency_code) || (is_array($ct2__cty_currency_code) && empty($ct2__cty_currency_code))) {
            unset($this->ct2__cty_currency_code);
        } else {
            $this->ct2__cty_currency_code = $ct2__cty_currency_code;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_currency_code_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_currency_code_description(): ?string
    {
        return $this->ct2__cty_currency_code_description ?? null;
    }
    /**
     * Set ct2__cty_currency_code_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_currency_code_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_currency_code_description(?string $ct2__cty_currency_code_description = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_currency_code_description) && !is_string($ct2__cty_currency_code_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_currency_code_description, true), gettype($ct2__cty_currency_code_description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ct2__cty_currency_code_description) && mb_strlen((string) $ct2__cty_currency_code_description) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ct2__cty_currency_code_description)), __LINE__);
        }
        if (is_null($ct2__cty_currency_code_description) || (is_array($ct2__cty_currency_code_description) && empty($ct2__cty_currency_code_description))) {
            unset($this->ct2__cty_currency_code_description);
        } else {
            $this->ct2__cty_currency_code_description = $ct2__cty_currency_code_description;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_vat_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_vat_flag(): ?string
    {
        return $this->ct2__cty_vat_flag ?? null;
    }
    /**
     * Set ct2__cty_vat_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_vat_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_vat_flag(?string $ct2__cty_vat_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_vat_flag) && !is_string($ct2__cty_vat_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_vat_flag, true), gettype($ct2__cty_vat_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ct2__cty_vat_flag) && $ct2__cty_vat_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ct2__cty_vat_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ct2__cty_vat_flag) && $ct2__cty_vat_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ct2__cty_vat_flag, true)), __LINE__);
        }
        if (is_null($ct2__cty_vat_flag) || (is_array($ct2__cty_vat_flag) && empty($ct2__cty_vat_flag))) {
            unset($this->ct2__cty_vat_flag);
        } else {
            $this->ct2__cty_vat_flag = $ct2__cty_vat_flag;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_iso value
     * @return ct2__cty_iso
     */
    public function getCt2__cty_iso_2(): ?string
    {
        return $this->ct2__cty_iso_2 ?? null;
    }
    /**
     * Set ct2__cty_iso value
     * @param ct2__cty_iso $ct2__cty_iso
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_iso_2(?string $ct2__cty_iso_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_iso_2) && !is_string($ct2__cty_iso_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_iso_2, true), gettype($ct2__cty_iso_2)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($ct2__cty_iso_2) && mb_strlen((string) $ct2__cty_iso_2) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen((string) $ct2__cty_iso_2)), __LINE__);
        }
        if (is_null($ct2__cty_iso_2) || (is_array($ct2__cty_iso_2) && empty($ct2__cty_iso_2))) {
            unset($this->ct2__cty_iso_2);
        } else {
            $this->ct2__cty_iso_2 = $ct2__cty_iso_2;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_iso value
     * @return ct2__cty_iso
     */
    public function getCt2__cty_iso_3(): ?string
    {
        return $this->ct2__cty_iso_3 ?? null;
    }
    /**
     * Set ct2__cty_iso value
     * @param ct2__cty_iso $ct2__cty_iso
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_iso_3(?string $ct2__cty_iso_3 = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_iso_3) && !is_string($ct2__cty_iso_3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_iso_3, true), gettype($ct2__cty_iso_3)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ct2__cty_iso_3) && mb_strlen((string) $ct2__cty_iso_3) > 3) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen((string) $ct2__cty_iso_3)), __LINE__);
        }
        if (is_null($ct2__cty_iso_3) || (is_array($ct2__cty_iso_3) && empty($ct2__cty_iso_3))) {
            unset($this->ct2__cty_iso_3);
        } else {
            $this->ct2__cty_iso_3 = $ct2__cty_iso_3;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_do_not_ship value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_do_not_ship(): ?string
    {
        return $this->ct2__cty_do_not_ship ?? null;
    }
    /**
     * Set ct2__cty_do_not_ship value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_do_not_ship
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_do_not_ship(?string $ct2__cty_do_not_ship = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_do_not_ship) && !is_string($ct2__cty_do_not_ship)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_do_not_ship, true), gettype($ct2__cty_do_not_ship)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ct2__cty_do_not_ship) && $ct2__cty_do_not_ship > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ct2__cty_do_not_ship, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ct2__cty_do_not_ship) && $ct2__cty_do_not_ship < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ct2__cty_do_not_ship, true)), __LINE__);
        }
        if (is_null($ct2__cty_do_not_ship) || (is_array($ct2__cty_do_not_ship) && empty($ct2__cty_do_not_ship))) {
            unset($this->ct2__cty_do_not_ship);
        } else {
            $this->ct2__cty_do_not_ship = $ct2__cty_do_not_ship;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_iso_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_iso_number(): ?string
    {
        return $this->ct2__cty_iso_number ?? null;
    }
    /**
     * Set ct2__cty_iso_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_iso_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_iso_number(?string $ct2__cty_iso_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_iso_number) && !is_string($ct2__cty_iso_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_iso_number, true), gettype($ct2__cty_iso_number)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ct2__cty_iso_number) && mb_strlen((string) $ct2__cty_iso_number) > 3) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen((string) $ct2__cty_iso_number)), __LINE__);
        }
        if (is_null($ct2__cty_iso_number) || (is_array($ct2__cty_iso_number) && empty($ct2__cty_iso_number))) {
            unset($this->ct2__cty_iso_number);
        } else {
            $this->ct2__cty_iso_number = $ct2__cty_iso_number;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_bpa_region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_bpa_region(): ?string
    {
        return $this->ct2__cty_bpa_region ?? null;
    }
    /**
     * Set ct2__cty_bpa_region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_bpa_region
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_bpa_region(?string $ct2__cty_bpa_region = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_bpa_region) && !is_string($ct2__cty_bpa_region)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_bpa_region, true), gettype($ct2__cty_bpa_region)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ct2__cty_bpa_region) && mb_strlen((string) $ct2__cty_bpa_region) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $ct2__cty_bpa_region)), __LINE__);
        }
        if (is_null($ct2__cty_bpa_region) || (is_array($ct2__cty_bpa_region) && empty($ct2__cty_bpa_region))) {
            unset($this->ct2__cty_bpa_region);
        } else {
            $this->ct2__cty_bpa_region = $ct2__cty_bpa_region;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_do_not_sell value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_do_not_sell(): ?string
    {
        return $this->ct2__cty_do_not_sell ?? null;
    }
    /**
     * Set ct2__cty_do_not_sell value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_do_not_sell
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_do_not_sell(?string $ct2__cty_do_not_sell = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_do_not_sell) && !is_string($ct2__cty_do_not_sell)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_do_not_sell, true), gettype($ct2__cty_do_not_sell)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ct2__cty_do_not_sell) && $ct2__cty_do_not_sell > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ct2__cty_do_not_sell, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ct2__cty_do_not_sell) && $ct2__cty_do_not_sell < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ct2__cty_do_not_sell, true)), __LINE__);
        }
        if (is_null($ct2__cty_do_not_sell) || (is_array($ct2__cty_do_not_sell) && empty($ct2__cty_do_not_sell))) {
            unset($this->ct2__cty_do_not_sell);
        } else {
            $this->ct2__cty_do_not_sell = $ct2__cty_do_not_sell;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_dyn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_dyn_key(): ?string
    {
        return $this->ct2__cty_dyn_key ?? null;
    }
    /**
     * Set ct2__cty_dyn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_dyn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_dyn_key(?string $ct2__cty_dyn_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_dyn_key) && !is_string($ct2__cty_dyn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_dyn_key, true), gettype($ct2__cty_dyn_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ct2__cty_dyn_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ct2__cty_dyn_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ct2__cty_dyn_key, true)), __LINE__);
        }
        if (is_null($ct2__cty_dyn_key) || (is_array($ct2__cty_dyn_key) && empty($ct2__cty_dyn_key))) {
            unset($this->ct2__cty_dyn_key);
        } else {
            $this->ct2__cty_dyn_key = $ct2__cty_dyn_key;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_dyn_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_dyn_key_2(): ?string
    {
        return $this->ct2__cty_dyn_key_2 ?? null;
    }
    /**
     * Set ct2__cty_dyn_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_dyn_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_dyn_key_2(?string $ct2__cty_dyn_key_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_dyn_key_2) && !is_string($ct2__cty_dyn_key_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_dyn_key_2, true), gettype($ct2__cty_dyn_key_2)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ct2__cty_dyn_key_2) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ct2__cty_dyn_key_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ct2__cty_dyn_key_2, true)), __LINE__);
        }
        if (is_null($ct2__cty_dyn_key_2) || (is_array($ct2__cty_dyn_key_2) && empty($ct2__cty_dyn_key_2))) {
            unset($this->ct2__cty_dyn_key_2);
        } else {
            $this->ct2__cty_dyn_key_2 = $ct2__cty_dyn_key_2;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_cgy_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_cgy_key(): ?string
    {
        return $this->ct2__cty_cgy_key ?? null;
    }
    /**
     * Set ct2__cty_cgy_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_cgy_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_cgy_key(?string $ct2__cty_cgy_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_cgy_key) && !is_string($ct2__cty_cgy_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_cgy_key, true), gettype($ct2__cty_cgy_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ct2__cty_cgy_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ct2__cty_cgy_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ct2__cty_cgy_key, true)), __LINE__);
        }
        if (is_null($ct2__cty_cgy_key) || (is_array($ct2__cty_cgy_key) && empty($ct2__cty_cgy_key))) {
            unset($this->ct2__cty_cgy_key);
        } else {
            $this->ct2__cty_cgy_key = $ct2__cty_cgy_key;
        }
        
        return $this;
    }
    /**
     * Get ct2__cty_state_descriptor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCt2__cty_state_descriptor(): ?string
    {
        return $this->ct2__cty_state_descriptor ?? null;
    }
    /**
     * Set ct2__cty_state_descriptor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ct2__cty_state_descriptor
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Address_Country_DataObjectType
     */
    public function setCt2__cty_state_descriptor(?string $ct2__cty_state_descriptor = null): self
    {
        // validation for constraint: string
        if (!is_null($ct2__cty_state_descriptor) && !is_string($ct2__cty_state_descriptor)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ct2__cty_state_descriptor, true), gettype($ct2__cty_state_descriptor)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($ct2__cty_state_descriptor) && mb_strlen((string) $ct2__cty_state_descriptor) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $ct2__cty_state_descriptor)), __LINE__);
        }
        if (is_null($ct2__cty_state_descriptor) || (is_array($ct2__cty_state_descriptor) && empty($ct2__cty_state_descriptor))) {
            unset($this->ct2__cty_state_descriptor);
        } else {
            $this->ct2__cty_state_descriptor = $ct2__cty_state_descriptor;
        }
        
        return $this;
    }
}
