<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Individual_Home_Fax_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Individual_Home_Fax_DataObjectType extends AbstractStructBase
{
    /**
     * The fa2__fax_key
     * Meta information extracted from the WSDL
     * - documentation: Fax Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fa2__fax_key = null;
    /**
     * The fa2__fax_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Fax Owner. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fa2__fax_cst_key_owner = null;
    /**
     * The fa2__fax_number
     * Meta information extracted from the WSDL
     * - documentation: Fax Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fa2__fax_number = null;
    /**
     * The fa2__fax_number_display
     * Meta information extracted from the WSDL
     * - documentation: Formatted Fax Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fa2__fax_number_display = null;
    /**
     * The fa2__fax_cty_key
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'bc4b70f8-280e-4bb0-b935-9f728c50e183'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fa2__fax_cty_key = null;
    /**
     * The fa2__fax_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fa2__fax_add_user = null;
    /**
     * The fa2__fax_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fa2__fax_add_date = null;
    /**
     * The fa2__fax_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fa2__fax_change_user = null;
    /**
     * The fa2__fax_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fa2__fax_change_date = null;
    /**
     * The fa2__fax_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fa2__fax_delete_flag = null;
    /**
     * The fa2__fax_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fa2__fax_entity_key = null;
    /**
     * The fa2__fax_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $fa2__fax_key_ext = null;
    /**
     * Constructor method for Individual_Home_Fax_DataObjectType
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_key()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_cst_key_owner()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_number()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_number_display()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_cty_key()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_add_user()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_add_date()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_change_user()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_change_date()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_delete_flag()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_entity_key()
     * @uses Individual_Home_Fax_DataObjectType::setFa2__fax_key_ext()
     * @param string $fa2__fax_key
     * @param string $fa2__fax_cst_key_owner
     * @param string $fa2__fax_number
     * @param string $fa2__fax_number_display
     * @param string $fa2__fax_cty_key
     * @param string $fa2__fax_add_user
     * @param string $fa2__fax_add_date
     * @param string $fa2__fax_change_user
     * @param string $fa2__fax_change_date
     * @param string $fa2__fax_delete_flag
     * @param string $fa2__fax_entity_key
     * @param string $fa2__fax_key_ext
     */
    public function __construct(?string $fa2__fax_key = null, ?string $fa2__fax_cst_key_owner = null, ?string $fa2__fax_number = null, ?string $fa2__fax_number_display = null, ?string $fa2__fax_cty_key = null, ?string $fa2__fax_add_user = null, ?string $fa2__fax_add_date = null, ?string $fa2__fax_change_user = null, ?string $fa2__fax_change_date = null, ?string $fa2__fax_delete_flag = null, ?string $fa2__fax_entity_key = null, ?string $fa2__fax_key_ext = null)
    {
        $this
            ->setFa2__fax_key($fa2__fax_key)
            ->setFa2__fax_cst_key_owner($fa2__fax_cst_key_owner)
            ->setFa2__fax_number($fa2__fax_number)
            ->setFa2__fax_number_display($fa2__fax_number_display)
            ->setFa2__fax_cty_key($fa2__fax_cty_key)
            ->setFa2__fax_add_user($fa2__fax_add_user)
            ->setFa2__fax_add_date($fa2__fax_add_date)
            ->setFa2__fax_change_user($fa2__fax_change_user)
            ->setFa2__fax_change_date($fa2__fax_change_date)
            ->setFa2__fax_delete_flag($fa2__fax_delete_flag)
            ->setFa2__fax_entity_key($fa2__fax_entity_key)
            ->setFa2__fax_key_ext($fa2__fax_key_ext);
    }
    /**
     * Get fa2__fax_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_key(): ?string
    {
        return $this->fa2__fax_key ?? null;
    }
    /**
     * Set fa2__fax_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_key(?string $fa2__fax_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_key) && !is_string($fa2__fax_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_key, true), gettype($fa2__fax_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fa2__fax_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fa2__fax_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fa2__fax_key, true)), __LINE__);
        }
        if (is_null($fa2__fax_key) || (is_array($fa2__fax_key) && empty($fa2__fax_key))) {
            unset($this->fa2__fax_key);
        } else {
            $this->fa2__fax_key = $fa2__fax_key;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_cst_key_owner(): ?string
    {
        return $this->fa2__fax_cst_key_owner ?? null;
    }
    /**
     * Set fa2__fax_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_cst_key_owner(?string $fa2__fax_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_cst_key_owner) && !is_string($fa2__fax_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_cst_key_owner, true), gettype($fa2__fax_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fa2__fax_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fa2__fax_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fa2__fax_cst_key_owner, true)), __LINE__);
        }
        if (is_null($fa2__fax_cst_key_owner) || (is_array($fa2__fax_cst_key_owner) && empty($fa2__fax_cst_key_owner))) {
            unset($this->fa2__fax_cst_key_owner);
        } else {
            $this->fa2__fax_cst_key_owner = $fa2__fax_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_number(): ?string
    {
        return $this->fa2__fax_number ?? null;
    }
    /**
     * Set fa2__fax_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_number(?string $fa2__fax_number = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_number) && !is_string($fa2__fax_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_number, true), gettype($fa2__fax_number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fa2__fax_number) && mb_strlen((string) $fa2__fax_number) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $fa2__fax_number)), __LINE__);
        }
        if (is_null($fa2__fax_number) || (is_array($fa2__fax_number) && empty($fa2__fax_number))) {
            unset($this->fa2__fax_number);
        } else {
            $this->fa2__fax_number = $fa2__fax_number;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_number_display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_number_display(): ?string
    {
        return $this->fa2__fax_number_display ?? null;
    }
    /**
     * Set fa2__fax_number_display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_number_display
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_number_display(?string $fa2__fax_number_display = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_number_display) && !is_string($fa2__fax_number_display)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_number_display, true), gettype($fa2__fax_number_display)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($fa2__fax_number_display) && mb_strlen((string) $fa2__fax_number_display) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $fa2__fax_number_display)), __LINE__);
        }
        if (is_null($fa2__fax_number_display) || (is_array($fa2__fax_number_display) && empty($fa2__fax_number_display))) {
            unset($this->fa2__fax_number_display);
        } else {
            $this->fa2__fax_number_display = $fa2__fax_number_display;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_cty_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_cty_key(): ?string
    {
        return $this->fa2__fax_cty_key ?? null;
    }
    /**
     * Set fa2__fax_cty_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_cty_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_cty_key(?string $fa2__fax_cty_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_cty_key) && !is_string($fa2__fax_cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_cty_key, true), gettype($fa2__fax_cty_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fa2__fax_cty_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fa2__fax_cty_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fa2__fax_cty_key, true)), __LINE__);
        }
        if (is_null($fa2__fax_cty_key) || (is_array($fa2__fax_cty_key) && empty($fa2__fax_cty_key))) {
            unset($this->fa2__fax_cty_key);
        } else {
            $this->fa2__fax_cty_key = $fa2__fax_cty_key;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_add_user(): ?string
    {
        return $this->fa2__fax_add_user ?? null;
    }
    /**
     * Set fa2__fax_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_add_user(?string $fa2__fax_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_add_user) && !is_string($fa2__fax_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_add_user, true), gettype($fa2__fax_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fa2__fax_add_user) && mb_strlen((string) $fa2__fax_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $fa2__fax_add_user)), __LINE__);
        }
        if (is_null($fa2__fax_add_user) || (is_array($fa2__fax_add_user) && empty($fa2__fax_add_user))) {
            unset($this->fa2__fax_add_user);
        } else {
            $this->fa2__fax_add_user = $fa2__fax_add_user;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_add_date(): ?string
    {
        return $this->fa2__fax_add_date ?? null;
    }
    /**
     * Set fa2__fax_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_add_date(?string $fa2__fax_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_add_date) && !is_string($fa2__fax_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_add_date, true), gettype($fa2__fax_add_date)), __LINE__);
        }
        if (is_null($fa2__fax_add_date) || (is_array($fa2__fax_add_date) && empty($fa2__fax_add_date))) {
            unset($this->fa2__fax_add_date);
        } else {
            $this->fa2__fax_add_date = $fa2__fax_add_date;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_change_user(): ?string
    {
        return $this->fa2__fax_change_user ?? null;
    }
    /**
     * Set fa2__fax_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_change_user(?string $fa2__fax_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_change_user) && !is_string($fa2__fax_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_change_user, true), gettype($fa2__fax_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fa2__fax_change_user) && mb_strlen((string) $fa2__fax_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $fa2__fax_change_user)), __LINE__);
        }
        if (is_null($fa2__fax_change_user) || (is_array($fa2__fax_change_user) && empty($fa2__fax_change_user))) {
            unset($this->fa2__fax_change_user);
        } else {
            $this->fa2__fax_change_user = $fa2__fax_change_user;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_change_date(): ?string
    {
        return $this->fa2__fax_change_date ?? null;
    }
    /**
     * Set fa2__fax_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_change_date(?string $fa2__fax_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_change_date) && !is_string($fa2__fax_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_change_date, true), gettype($fa2__fax_change_date)), __LINE__);
        }
        if (is_null($fa2__fax_change_date) || (is_array($fa2__fax_change_date) && empty($fa2__fax_change_date))) {
            unset($this->fa2__fax_change_date);
        } else {
            $this->fa2__fax_change_date = $fa2__fax_change_date;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_delete_flag(): ?string
    {
        return $this->fa2__fax_delete_flag ?? null;
    }
    /**
     * Set fa2__fax_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_delete_flag(?string $fa2__fax_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_delete_flag) && !is_string($fa2__fax_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_delete_flag, true), gettype($fa2__fax_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($fa2__fax_delete_flag) && $fa2__fax_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($fa2__fax_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fa2__fax_delete_flag) && $fa2__fax_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fa2__fax_delete_flag, true)), __LINE__);
        }
        if (is_null($fa2__fax_delete_flag) || (is_array($fa2__fax_delete_flag) && empty($fa2__fax_delete_flag))) {
            unset($this->fa2__fax_delete_flag);
        } else {
            $this->fa2__fax_delete_flag = $fa2__fax_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_entity_key(): ?string
    {
        return $this->fa2__fax_entity_key ?? null;
    }
    /**
     * Set fa2__fax_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_entity_key(?string $fa2__fax_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_entity_key) && !is_string($fa2__fax_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_entity_key, true), gettype($fa2__fax_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fa2__fax_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fa2__fax_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fa2__fax_entity_key, true)), __LINE__);
        }
        if (is_null($fa2__fax_entity_key) || (is_array($fa2__fax_entity_key) && empty($fa2__fax_entity_key))) {
            unset($this->fa2__fax_entity_key);
        } else {
            $this->fa2__fax_entity_key = $fa2__fax_entity_key;
        }
        
        return $this;
    }
    /**
     * Get fa2__fax_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFa2__fax_key_ext(): ?string
    {
        return $this->fa2__fax_key_ext ?? null;
    }
    /**
     * Set fa2__fax_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fa2__fax_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Individual_Home_Fax_DataObjectType
     */
    public function setFa2__fax_key_ext(?string $fa2__fax_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($fa2__fax_key_ext) && !is_string($fa2__fax_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fa2__fax_key_ext, true), gettype($fa2__fax_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($fa2__fax_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $fa2__fax_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($fa2__fax_key_ext, true)), __LINE__);
        }
        if (is_null($fa2__fax_key_ext) || (is_array($fa2__fax_key_ext) && empty($fa2__fax_key_ext))) {
            unset($this->fa2__fax_key_ext);
        } else {
            $this->fa2__fax_key_ext = $fa2__fax_key_ext;
        }
        
        return $this;
    }
}
