<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertCustomerAction StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InsertCustomerAction extends AbstractStructBase
{
    /**
     * The actionCustomerKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $actionCustomerKey;
    /**
     * The actionTypeKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $actionTypeKey;
    /**
     * The actionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    protected string $actionDate;
    /**
     * The action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $action = null;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $source = null;
    /**
     * The actionSubtypeList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfGuid|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfGuid $actionSubtypeList = null;
    /**
     * Constructor method for InsertCustomerAction
     * @uses InsertCustomerAction::setActionCustomerKey()
     * @uses InsertCustomerAction::setActionTypeKey()
     * @uses InsertCustomerAction::setActionDate()
     * @uses InsertCustomerAction::setAction()
     * @uses InsertCustomerAction::setSource()
     * @uses InsertCustomerAction::setActionSubtypeList()
     * @param string $actionCustomerKey
     * @param string $actionTypeKey
     * @param string $actionDate
     * @param string $action
     * @param string $source
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfGuid $actionSubtypeList
     */
    public function __construct(string $actionCustomerKey, string $actionTypeKey, string $actionDate, ?string $action = null, ?string $source = null, ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfGuid $actionSubtypeList = null)
    {
        $this
            ->setActionCustomerKey($actionCustomerKey)
            ->setActionTypeKey($actionTypeKey)
            ->setActionDate($actionDate)
            ->setAction($action)
            ->setSource($source)
            ->setActionSubtypeList($actionSubtypeList);
    }
    /**
     * Get actionCustomerKey value
     * @return string
     */
    public function getActionCustomerKey(): string
    {
        return $this->actionCustomerKey;
    }
    /**
     * Set actionCustomerKey value
     * @param string $actionCustomerKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertCustomerAction
     */
    public function setActionCustomerKey(string $actionCustomerKey): self
    {
        // validation for constraint: string
        if (!is_null($actionCustomerKey) && !is_string($actionCustomerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionCustomerKey, true), gettype($actionCustomerKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($actionCustomerKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $actionCustomerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($actionCustomerKey, true)), __LINE__);
        }
        $this->actionCustomerKey = $actionCustomerKey;
        
        return $this;
    }
    /**
     * Get actionTypeKey value
     * @return string
     */
    public function getActionTypeKey(): string
    {
        return $this->actionTypeKey;
    }
    /**
     * Set actionTypeKey value
     * @param string $actionTypeKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertCustomerAction
     */
    public function setActionTypeKey(string $actionTypeKey): self
    {
        // validation for constraint: string
        if (!is_null($actionTypeKey) && !is_string($actionTypeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionTypeKey, true), gettype($actionTypeKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($actionTypeKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $actionTypeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($actionTypeKey, true)), __LINE__);
        }
        $this->actionTypeKey = $actionTypeKey;
        
        return $this;
    }
    /**
     * Get actionDate value
     * @return string
     */
    public function getActionDate(): string
    {
        return $this->actionDate;
    }
    /**
     * Set actionDate value
     * @param string $actionDate
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertCustomerAction
     */
    public function setActionDate(string $actionDate): self
    {
        // validation for constraint: string
        if (!is_null($actionDate) && !is_string($actionDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDate, true), gettype($actionDate)), __LINE__);
        }
        $this->actionDate = $actionDate;
        
        return $this;
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction(): ?string
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param string $action
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertCustomerAction
     */
    public function setAction(?string $action = null): self
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource(): ?string
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertCustomerAction
     */
    public function setSource(?string $source = null): self
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        
        return $this;
    }
    /**
     * Get actionSubtypeList value
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfGuid|null
     */
    public function getActionSubtypeList(): ?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfGuid
    {
        return $this->actionSubtypeList;
    }
    /**
     * Set actionSubtypeList value
     * @param \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfGuid $actionSubtypeList
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertCustomerAction
     */
    public function setActionSubtypeList(?\Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfGuid $actionSubtypeList = null): self
    {
        $this->actionSubtypeList = $actionSubtypeList;
        
        return $this;
    }
}
