<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType extends AbstractStructBase
{
    /**
     * The idc_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_key = null;
    /**
     * The idc_cst_sort_name_dn
     * Meta information extracted from the WSDL
     * - documentation: Sort Name. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_cst_sort_name_dn = null;
    /**
     * The idc_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_cst_key = null;
    /**
     * The idc_ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Affiliation Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ixo_key = null;
    /**
     * The idc_ixt_key
     * Meta information extracted from the WSDL
     * - documentation: idc_ixt_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ixt_key = null;
    /**
     * The idc_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ivd_key = null;
    /**
     * The idc_ivd_inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ivd_inv_key = null;
    /**
     * The idc_date
     * Meta information extracted from the WSDL
     * - documentation: Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_date = null;
    /**
     * The idc_code
     * Meta information extracted from the WSDL
     * - documentation: Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_code = null;
    /**
     * The idc_price
     * Meta information extracted from the WSDL
     * - documentation: Price. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idc_price = null;
    /**
     * The idc_qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $idc_qty = null;
    /**
     * The idc_ods_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Schedule Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_ods_key = null;
    /**
     * The idc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_add_user = null;
    /**
     * The idc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_add_date = null;
    /**
     * The idc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_change_user = null;
    /**
     * The idc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_change_date = null;
    /**
     * The idc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $idc_delete_flag = null;
    /**
     * The idc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $idc_entity_key = null;
    /**
     * The idc_total
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Liability Total.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idc_total = null;
    /**
     * The idc_return_qty
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Liability New Return Qty.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $idc_return_qty = null;
    /**
     * The idc_cancel_qty
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Liability New Cancel Qty.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $idc_cancel_qty = null;
    /**
     * The idc_credit_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Liability New Credit Amount.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idc_credit_to_apply = null;
    /**
     * The idc_payment_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Liability New Payment Amount.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idc_payment_to_apply = null;
    /**
     * The idc_payment_applied
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Liability New Payment Amount Applied.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idc_payment_applied = null;
    /**
     * The idc_credit_applied
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Liability New Payment Amount Applied.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idc_credit_applied = null;
    /**
     * The idc_writeoff_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Liability New WriteOff Amount.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $idc_writeoff_to_apply = null;
    /**
     * The idc_credit_dollar_amount
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Liability New Cancel Qty.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $idc_credit_dollar_amount = null;
    /**
     * Constructor method for
     * InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_key()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_cst_sort_name_dn()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_cst_key()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_ixo_key()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_ixt_key()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_ivd_key()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_ivd_inv_key()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_date()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_code()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_price()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_qty()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_ods_key()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_add_user()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_add_date()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_change_user()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_change_date()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_delete_flag()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_entity_key()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_total()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_return_qty()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_cancel_qty()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_credit_to_apply()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_payment_to_apply()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_payment_applied()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_credit_applied()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_writeoff_to_apply()
     * @uses InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType::setIdc_credit_dollar_amount()
     * @param string $idc_key
     * @param string $idc_cst_sort_name_dn
     * @param string $idc_cst_key
     * @param string $idc_ixo_key
     * @param string $idc_ixt_key
     * @param string $idc_ivd_key
     * @param string $idc_ivd_inv_key
     * @param string $idc_date
     * @param string $idc_code
     * @param float $idc_price
     * @param int $idc_qty
     * @param string $idc_ods_key
     * @param string $idc_add_user
     * @param string $idc_add_date
     * @param string $idc_change_user
     * @param string $idc_change_date
     * @param string $idc_delete_flag
     * @param string $idc_entity_key
     * @param float $idc_total
     * @param float $idc_return_qty
     * @param float $idc_cancel_qty
     * @param float $idc_credit_to_apply
     * @param float $idc_payment_to_apply
     * @param float $idc_payment_applied
     * @param float $idc_credit_applied
     * @param float $idc_writeoff_to_apply
     * @param float $idc_credit_dollar_amount
     */
    public function __construct(?string $idc_key = null, ?string $idc_cst_sort_name_dn = null, ?string $idc_cst_key = null, ?string $idc_ixo_key = null, ?string $idc_ixt_key = null, ?string $idc_ivd_key = null, ?string $idc_ivd_inv_key = null, ?string $idc_date = null, ?string $idc_code = null, ?float $idc_price = null, ?int $idc_qty = null, ?string $idc_ods_key = null, ?string $idc_add_user = null, ?string $idc_add_date = null, ?string $idc_change_user = null, ?string $idc_change_date = null, ?string $idc_delete_flag = null, ?string $idc_entity_key = null, ?float $idc_total = null, ?float $idc_return_qty = null, ?float $idc_cancel_qty = null, ?float $idc_credit_to_apply = null, ?float $idc_payment_to_apply = null, ?float $idc_payment_applied = null, ?float $idc_credit_applied = null, ?float $idc_writeoff_to_apply = null, ?float $idc_credit_dollar_amount = null)
    {
        $this
            ->setIdc_key($idc_key)
            ->setIdc_cst_sort_name_dn($idc_cst_sort_name_dn)
            ->setIdc_cst_key($idc_cst_key)
            ->setIdc_ixo_key($idc_ixo_key)
            ->setIdc_ixt_key($idc_ixt_key)
            ->setIdc_ivd_key($idc_ivd_key)
            ->setIdc_ivd_inv_key($idc_ivd_inv_key)
            ->setIdc_date($idc_date)
            ->setIdc_code($idc_code)
            ->setIdc_price($idc_price)
            ->setIdc_qty($idc_qty)
            ->setIdc_ods_key($idc_ods_key)
            ->setIdc_add_user($idc_add_user)
            ->setIdc_add_date($idc_add_date)
            ->setIdc_change_user($idc_change_user)
            ->setIdc_change_date($idc_change_date)
            ->setIdc_delete_flag($idc_delete_flag)
            ->setIdc_entity_key($idc_entity_key)
            ->setIdc_total($idc_total)
            ->setIdc_return_qty($idc_return_qty)
            ->setIdc_cancel_qty($idc_cancel_qty)
            ->setIdc_credit_to_apply($idc_credit_to_apply)
            ->setIdc_payment_to_apply($idc_payment_to_apply)
            ->setIdc_payment_applied($idc_payment_applied)
            ->setIdc_credit_applied($idc_credit_applied)
            ->setIdc_writeoff_to_apply($idc_writeoff_to_apply)
            ->setIdc_credit_dollar_amount($idc_credit_dollar_amount);
    }
    /**
     * Get idc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_key(): ?string
    {
        return $this->idc_key ?? null;
    }
    /**
     * Set idc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_key(?string $idc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_key) && !is_string($idc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_key, true), gettype($idc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_key, true)), __LINE__);
        }
        if (is_null($idc_key) || (is_array($idc_key) && empty($idc_key))) {
            unset($this->idc_key);
        } else {
            $this->idc_key = $idc_key;
        }
        
        return $this;
    }
    /**
     * Get idc_cst_sort_name_dn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_cst_sort_name_dn(): ?string
    {
        return $this->idc_cst_sort_name_dn ?? null;
    }
    /**
     * Set idc_cst_sort_name_dn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_cst_sort_name_dn
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_cst_sort_name_dn(?string $idc_cst_sort_name_dn = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_cst_sort_name_dn) && !is_string($idc_cst_sort_name_dn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_cst_sort_name_dn, true), gettype($idc_cst_sort_name_dn)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($idc_cst_sort_name_dn) && mb_strlen((string) $idc_cst_sort_name_dn) > 500) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen((string) $idc_cst_sort_name_dn)), __LINE__);
        }
        if (is_null($idc_cst_sort_name_dn) || (is_array($idc_cst_sort_name_dn) && empty($idc_cst_sort_name_dn))) {
            unset($this->idc_cst_sort_name_dn);
        } else {
            $this->idc_cst_sort_name_dn = $idc_cst_sort_name_dn;
        }
        
        return $this;
    }
    /**
     * Get idc_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_cst_key(): ?string
    {
        return $this->idc_cst_key ?? null;
    }
    /**
     * Set idc_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_cst_key(?string $idc_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_cst_key) && !is_string($idc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_cst_key, true), gettype($idc_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_cst_key, true)), __LINE__);
        }
        if (is_null($idc_cst_key) || (is_array($idc_cst_key) && empty($idc_cst_key))) {
            unset($this->idc_cst_key);
        } else {
            $this->idc_cst_key = $idc_cst_key;
        }
        
        return $this;
    }
    /**
     * Get idc_ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ixo_key(): ?string
    {
        return $this->idc_ixo_key ?? null;
    }
    /**
     * Set idc_ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ixo_key(?string $idc_ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ixo_key) && !is_string($idc_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ixo_key, true), gettype($idc_ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ixo_key, true)), __LINE__);
        }
        if (is_null($idc_ixo_key) || (is_array($idc_ixo_key) && empty($idc_ixo_key))) {
            unset($this->idc_ixo_key);
        } else {
            $this->idc_ixo_key = $idc_ixo_key;
        }
        
        return $this;
    }
    /**
     * Get idc_ixt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ixt_key(): ?string
    {
        return $this->idc_ixt_key ?? null;
    }
    /**
     * Set idc_ixt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ixt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ixt_key(?string $idc_ixt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ixt_key) && !is_string($idc_ixt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ixt_key, true), gettype($idc_ixt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ixt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ixt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ixt_key, true)), __LINE__);
        }
        if (is_null($idc_ixt_key) || (is_array($idc_ixt_key) && empty($idc_ixt_key))) {
            unset($this->idc_ixt_key);
        } else {
            $this->idc_ixt_key = $idc_ixt_key;
        }
        
        return $this;
    }
    /**
     * Get idc_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ivd_key(): ?string
    {
        return $this->idc_ivd_key ?? null;
    }
    /**
     * Set idc_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ivd_key(?string $idc_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ivd_key) && !is_string($idc_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ivd_key, true), gettype($idc_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ivd_key, true)), __LINE__);
        }
        if (is_null($idc_ivd_key) || (is_array($idc_ivd_key) && empty($idc_ivd_key))) {
            unset($this->idc_ivd_key);
        } else {
            $this->idc_ivd_key = $idc_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get idc_ivd_inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ivd_inv_key(): ?string
    {
        return $this->idc_ivd_inv_key ?? null;
    }
    /**
     * Set idc_ivd_inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ivd_inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ivd_inv_key(?string $idc_ivd_inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ivd_inv_key) && !is_string($idc_ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ivd_inv_key, true), gettype($idc_ivd_inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ivd_inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ivd_inv_key, true)), __LINE__);
        }
        if (is_null($idc_ivd_inv_key) || (is_array($idc_ivd_inv_key) && empty($idc_ivd_inv_key))) {
            unset($this->idc_ivd_inv_key);
        } else {
            $this->idc_ivd_inv_key = $idc_ivd_inv_key;
        }
        
        return $this;
    }
    /**
     * Get idc_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_date(): ?string
    {
        return $this->idc_date ?? null;
    }
    /**
     * Set idc_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_date(?string $idc_date = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_date) && !is_string($idc_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_date, true), gettype($idc_date)), __LINE__);
        }
        if (is_null($idc_date) || (is_array($idc_date) && empty($idc_date))) {
            unset($this->idc_date);
        } else {
            $this->idc_date = $idc_date;
        }
        
        return $this;
    }
    /**
     * Get idc_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_code(): ?string
    {
        return $this->idc_code ?? null;
    }
    /**
     * Set idc_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_code(?string $idc_code = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_code) && !is_string($idc_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_code, true), gettype($idc_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($idc_code) && mb_strlen((string) $idc_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $idc_code)), __LINE__);
        }
        if (is_null($idc_code) || (is_array($idc_code) && empty($idc_code))) {
            unset($this->idc_code);
        } else {
            $this->idc_code = $idc_code;
        }
        
        return $this;
    }
    /**
     * Get idc_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_price(): ?float
    {
        return $this->idc_price ?? null;
    }
    /**
     * Set idc_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_price(?float $idc_price = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_price) && !(is_float($idc_price) || is_numeric($idc_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_price, true), gettype($idc_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_price) && mb_strlen(mb_substr((string) $idc_price, false !== mb_strpos((string) $idc_price, '.') ? mb_strpos((string) $idc_price, '.') + 1 : mb_strlen((string) $idc_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_price, true), mb_strlen(mb_substr((string) $idc_price, mb_strpos((string) $idc_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idc_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idc_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_price))), __LINE__);
        }
        if (is_null($idc_price) || (is_array($idc_price) && empty($idc_price))) {
            unset($this->idc_price);
        } else {
            $this->idc_price = $idc_price;
        }
        
        return $this;
    }
    /**
     * Get idc_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdc_qty(): ?int
    {
        return $this->idc_qty ?? null;
    }
    /**
     * Set idc_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idc_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_qty(?int $idc_qty = null): self
    {
        // validation for constraint: int
        if (!is_null($idc_qty) && !(is_int($idc_qty) || ctype_digit($idc_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idc_qty, true), gettype($idc_qty)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($idc_qty) && $idc_qty > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($idc_qty, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($idc_qty) && $idc_qty < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($idc_qty, true)), __LINE__);
        }
        if (is_null($idc_qty) || (is_array($idc_qty) && empty($idc_qty))) {
            unset($this->idc_qty);
        } else {
            $this->idc_qty = $idc_qty;
        }
        
        return $this;
    }
    /**
     * Get idc_ods_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_ods_key(): ?string
    {
        return $this->idc_ods_key ?? null;
    }
    /**
     * Set idc_ods_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_ods_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_ods_key(?string $idc_ods_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_ods_key) && !is_string($idc_ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_ods_key, true), gettype($idc_ods_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_ods_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_ods_key, true)), __LINE__);
        }
        if (is_null($idc_ods_key) || (is_array($idc_ods_key) && empty($idc_ods_key))) {
            unset($this->idc_ods_key);
        } else {
            $this->idc_ods_key = $idc_ods_key;
        }
        
        return $this;
    }
    /**
     * Get idc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_add_user(): ?string
    {
        return $this->idc_add_user ?? null;
    }
    /**
     * Set idc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_add_user(?string $idc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_add_user) && !is_string($idc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_add_user, true), gettype($idc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($idc_add_user) && mb_strlen((string) $idc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $idc_add_user)), __LINE__);
        }
        if (is_null($idc_add_user) || (is_array($idc_add_user) && empty($idc_add_user))) {
            unset($this->idc_add_user);
        } else {
            $this->idc_add_user = $idc_add_user;
        }
        
        return $this;
    }
    /**
     * Get idc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_add_date(): ?string
    {
        return $this->idc_add_date ?? null;
    }
    /**
     * Set idc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_add_date(?string $idc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_add_date) && !is_string($idc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_add_date, true), gettype($idc_add_date)), __LINE__);
        }
        if (is_null($idc_add_date) || (is_array($idc_add_date) && empty($idc_add_date))) {
            unset($this->idc_add_date);
        } else {
            $this->idc_add_date = $idc_add_date;
        }
        
        return $this;
    }
    /**
     * Get idc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_change_user(): ?string
    {
        return $this->idc_change_user ?? null;
    }
    /**
     * Set idc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_change_user(?string $idc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_change_user) && !is_string($idc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_change_user, true), gettype($idc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($idc_change_user) && mb_strlen((string) $idc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $idc_change_user)), __LINE__);
        }
        if (is_null($idc_change_user) || (is_array($idc_change_user) && empty($idc_change_user))) {
            unset($this->idc_change_user);
        } else {
            $this->idc_change_user = $idc_change_user;
        }
        
        return $this;
    }
    /**
     * Get idc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_change_date(): ?string
    {
        return $this->idc_change_date ?? null;
    }
    /**
     * Set idc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_change_date(?string $idc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_change_date) && !is_string($idc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_change_date, true), gettype($idc_change_date)), __LINE__);
        }
        if (is_null($idc_change_date) || (is_array($idc_change_date) && empty($idc_change_date))) {
            unset($this->idc_change_date);
        } else {
            $this->idc_change_date = $idc_change_date;
        }
        
        return $this;
    }
    /**
     * Get idc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_delete_flag(): ?string
    {
        return $this->idc_delete_flag ?? null;
    }
    /**
     * Set idc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_delete_flag(?string $idc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_delete_flag) && !is_string($idc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_delete_flag, true), gettype($idc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($idc_delete_flag) && $idc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($idc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($idc_delete_flag) && $idc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($idc_delete_flag, true)), __LINE__);
        }
        if (is_null($idc_delete_flag) || (is_array($idc_delete_flag) && empty($idc_delete_flag))) {
            unset($this->idc_delete_flag);
        } else {
            $this->idc_delete_flag = $idc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get idc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdc_entity_key(): ?string
    {
        return $this->idc_entity_key ?? null;
    }
    /**
     * Set idc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_entity_key(?string $idc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($idc_entity_key) && !is_string($idc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idc_entity_key, true), gettype($idc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($idc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $idc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($idc_entity_key, true)), __LINE__);
        }
        if (is_null($idc_entity_key) || (is_array($idc_entity_key) && empty($idc_entity_key))) {
            unset($this->idc_entity_key);
        } else {
            $this->idc_entity_key = $idc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get idc_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_total(): ?float
    {
        return $this->idc_total ?? null;
    }
    /**
     * Set idc_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_total(?float $idc_total = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_total) && !(is_float($idc_total) || is_numeric($idc_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_total, true), gettype($idc_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_total) && mb_strlen(mb_substr((string) $idc_total, false !== mb_strpos((string) $idc_total, '.') ? mb_strpos((string) $idc_total, '.') + 1 : mb_strlen((string) $idc_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_total, true), mb_strlen(mb_substr((string) $idc_total, mb_strpos((string) $idc_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idc_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idc_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_total))), __LINE__);
        }
        if (is_null($idc_total) || (is_array($idc_total) && empty($idc_total))) {
            unset($this->idc_total);
        } else {
            $this->idc_total = $idc_total;
        }
        
        return $this;
    }
    /**
     * Get idc_return_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_return_qty(): ?float
    {
        return $this->idc_return_qty ?? null;
    }
    /**
     * Set idc_return_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_return_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_return_qty(?float $idc_return_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_return_qty) && !(is_float($idc_return_qty) || is_numeric($idc_return_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_return_qty, true), gettype($idc_return_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_return_qty) && mb_strlen(mb_substr((string) $idc_return_qty, false !== mb_strpos((string) $idc_return_qty, '.') ? mb_strpos((string) $idc_return_qty, '.') + 1 : mb_strlen((string) $idc_return_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_return_qty, true), mb_strlen(mb_substr((string) $idc_return_qty, mb_strpos((string) $idc_return_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($idc_return_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_return_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($idc_return_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_return_qty))), __LINE__);
        }
        if (is_null($idc_return_qty) || (is_array($idc_return_qty) && empty($idc_return_qty))) {
            unset($this->idc_return_qty);
        } else {
            $this->idc_return_qty = $idc_return_qty;
        }
        
        return $this;
    }
    /**
     * Get idc_cancel_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_cancel_qty(): ?float
    {
        return $this->idc_cancel_qty ?? null;
    }
    /**
     * Set idc_cancel_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_cancel_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_cancel_qty(?float $idc_cancel_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_cancel_qty) && !(is_float($idc_cancel_qty) || is_numeric($idc_cancel_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_cancel_qty, true), gettype($idc_cancel_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_cancel_qty) && mb_strlen(mb_substr((string) $idc_cancel_qty, false !== mb_strpos((string) $idc_cancel_qty, '.') ? mb_strpos((string) $idc_cancel_qty, '.') + 1 : mb_strlen((string) $idc_cancel_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_cancel_qty, true), mb_strlen(mb_substr((string) $idc_cancel_qty, mb_strpos((string) $idc_cancel_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($idc_cancel_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_cancel_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($idc_cancel_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_cancel_qty))), __LINE__);
        }
        if (is_null($idc_cancel_qty) || (is_array($idc_cancel_qty) && empty($idc_cancel_qty))) {
            unset($this->idc_cancel_qty);
        } else {
            $this->idc_cancel_qty = $idc_cancel_qty;
        }
        
        return $this;
    }
    /**
     * Get idc_credit_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_credit_to_apply(): ?float
    {
        return $this->idc_credit_to_apply ?? null;
    }
    /**
     * Set idc_credit_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_credit_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_credit_to_apply(?float $idc_credit_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_credit_to_apply) && !(is_float($idc_credit_to_apply) || is_numeric($idc_credit_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_credit_to_apply, true), gettype($idc_credit_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_credit_to_apply) && mb_strlen(mb_substr((string) $idc_credit_to_apply, false !== mb_strpos((string) $idc_credit_to_apply, '.') ? mb_strpos((string) $idc_credit_to_apply, '.') + 1 : mb_strlen((string) $idc_credit_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_credit_to_apply, true), mb_strlen(mb_substr((string) $idc_credit_to_apply, mb_strpos((string) $idc_credit_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idc_credit_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_credit_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idc_credit_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_credit_to_apply))), __LINE__);
        }
        if (is_null($idc_credit_to_apply) || (is_array($idc_credit_to_apply) && empty($idc_credit_to_apply))) {
            unset($this->idc_credit_to_apply);
        } else {
            $this->idc_credit_to_apply = $idc_credit_to_apply;
        }
        
        return $this;
    }
    /**
     * Get idc_payment_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_payment_to_apply(): ?float
    {
        return $this->idc_payment_to_apply ?? null;
    }
    /**
     * Set idc_payment_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_payment_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_payment_to_apply(?float $idc_payment_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_payment_to_apply) && !(is_float($idc_payment_to_apply) || is_numeric($idc_payment_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_payment_to_apply, true), gettype($idc_payment_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_payment_to_apply) && mb_strlen(mb_substr((string) $idc_payment_to_apply, false !== mb_strpos((string) $idc_payment_to_apply, '.') ? mb_strpos((string) $idc_payment_to_apply, '.') + 1 : mb_strlen((string) $idc_payment_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_payment_to_apply, true), mb_strlen(mb_substr((string) $idc_payment_to_apply, mb_strpos((string) $idc_payment_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idc_payment_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_payment_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idc_payment_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_payment_to_apply))), __LINE__);
        }
        if (is_null($idc_payment_to_apply) || (is_array($idc_payment_to_apply) && empty($idc_payment_to_apply))) {
            unset($this->idc_payment_to_apply);
        } else {
            $this->idc_payment_to_apply = $idc_payment_to_apply;
        }
        
        return $this;
    }
    /**
     * Get idc_payment_applied value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_payment_applied(): ?float
    {
        return $this->idc_payment_applied ?? null;
    }
    /**
     * Set idc_payment_applied value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_payment_applied
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_payment_applied(?float $idc_payment_applied = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_payment_applied) && !(is_float($idc_payment_applied) || is_numeric($idc_payment_applied))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_payment_applied, true), gettype($idc_payment_applied)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_payment_applied) && mb_strlen(mb_substr((string) $idc_payment_applied, false !== mb_strpos((string) $idc_payment_applied, '.') ? mb_strpos((string) $idc_payment_applied, '.') + 1 : mb_strlen((string) $idc_payment_applied))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_payment_applied, true), mb_strlen(mb_substr((string) $idc_payment_applied, mb_strpos((string) $idc_payment_applied, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idc_payment_applied) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_payment_applied)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idc_payment_applied, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_payment_applied))), __LINE__);
        }
        if (is_null($idc_payment_applied) || (is_array($idc_payment_applied) && empty($idc_payment_applied))) {
            unset($this->idc_payment_applied);
        } else {
            $this->idc_payment_applied = $idc_payment_applied;
        }
        
        return $this;
    }
    /**
     * Get idc_credit_applied value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_credit_applied(): ?float
    {
        return $this->idc_credit_applied ?? null;
    }
    /**
     * Set idc_credit_applied value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_credit_applied
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_credit_applied(?float $idc_credit_applied = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_credit_applied) && !(is_float($idc_credit_applied) || is_numeric($idc_credit_applied))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_credit_applied, true), gettype($idc_credit_applied)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_credit_applied) && mb_strlen(mb_substr((string) $idc_credit_applied, false !== mb_strpos((string) $idc_credit_applied, '.') ? mb_strpos((string) $idc_credit_applied, '.') + 1 : mb_strlen((string) $idc_credit_applied))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_credit_applied, true), mb_strlen(mb_substr((string) $idc_credit_applied, mb_strpos((string) $idc_credit_applied, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idc_credit_applied) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_credit_applied)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idc_credit_applied, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_credit_applied))), __LINE__);
        }
        if (is_null($idc_credit_applied) || (is_array($idc_credit_applied) && empty($idc_credit_applied))) {
            unset($this->idc_credit_applied);
        } else {
            $this->idc_credit_applied = $idc_credit_applied;
        }
        
        return $this;
    }
    /**
     * Get idc_writeoff_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_writeoff_to_apply(): ?float
    {
        return $this->idc_writeoff_to_apply ?? null;
    }
    /**
     * Set idc_writeoff_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_writeoff_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_writeoff_to_apply(?float $idc_writeoff_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_writeoff_to_apply) && !(is_float($idc_writeoff_to_apply) || is_numeric($idc_writeoff_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_writeoff_to_apply, true), gettype($idc_writeoff_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_writeoff_to_apply) && mb_strlen(mb_substr((string) $idc_writeoff_to_apply, false !== mb_strpos((string) $idc_writeoff_to_apply, '.') ? mb_strpos((string) $idc_writeoff_to_apply, '.') + 1 : mb_strlen((string) $idc_writeoff_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_writeoff_to_apply, true), mb_strlen(mb_substr((string) $idc_writeoff_to_apply, mb_strpos((string) $idc_writeoff_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($idc_writeoff_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_writeoff_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($idc_writeoff_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_writeoff_to_apply))), __LINE__);
        }
        if (is_null($idc_writeoff_to_apply) || (is_array($idc_writeoff_to_apply) && empty($idc_writeoff_to_apply))) {
            unset($this->idc_writeoff_to_apply);
        } else {
            $this->idc_writeoff_to_apply = $idc_writeoff_to_apply;
        }
        
        return $this;
    }
    /**
     * Get idc_credit_dollar_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIdc_credit_dollar_amount(): ?float
    {
        return $this->idc_credit_dollar_amount ?? null;
    }
    /**
     * Set idc_credit_dollar_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $idc_credit_dollar_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetailCustomer_Invoice_Detail_Liability_DataObjectType
     */
    public function setIdc_credit_dollar_amount(?float $idc_credit_dollar_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($idc_credit_dollar_amount) && !(is_float($idc_credit_dollar_amount) || is_numeric($idc_credit_dollar_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idc_credit_dollar_amount, true), gettype($idc_credit_dollar_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($idc_credit_dollar_amount) && mb_strlen(mb_substr((string) $idc_credit_dollar_amount, false !== mb_strpos((string) $idc_credit_dollar_amount, '.') ? mb_strpos((string) $idc_credit_dollar_amount, '.') + 1 : mb_strlen((string) $idc_credit_dollar_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($idc_credit_dollar_amount, true), mb_strlen(mb_substr((string) $idc_credit_dollar_amount, mb_strpos((string) $idc_credit_dollar_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($idc_credit_dollar_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $idc_credit_dollar_amount)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($idc_credit_dollar_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $idc_credit_dollar_amount))), __LINE__);
        }
        if (is_null($idc_credit_dollar_amount) || (is_array($idc_credit_dollar_amount) && empty($idc_credit_dollar_amount))) {
            unset($this->idc_credit_dollar_amount);
        } else {
            $this->idc_credit_dollar_amount = $idc_credit_dollar_amount;
        }
        
        return $this;
    }
}
