<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Bundle_Component_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Bundle_Component_DataObjectType extends AbstractStructBase
{
    /**
     * The bup_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bup_key = null;
    /**
     * The bup_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_add_user = null;
    /**
     * The bup_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_add_date = null;
    /**
     * The bup_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_change_user = null;
    /**
     * The bup_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_change_date = null;
    /**
     * The bup_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_delete_flag = null;
    /**
     * The bup_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bup_entity_key = null;
    /**
     * The bup_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bup_key_ext = null;
    /**
     * The bup_bun_prd_key
     * Meta information extracted from the WSDL
     * - documentation: bundle. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bup_bun_prd_key = null;
    /**
     * The bup_prd_key
     * Meta information extracted from the WSDL
     * - documentation: product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bup_prd_key = null;
    /**
     * The bup_qty
     * Meta information extracted from the WSDL
     * - documentation: quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $bup_qty = null;
    /**
     * The bup_discount_amount
     * Meta information extracted from the WSDL
     * - documentation: discount amt. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $bup_discount_amount = null;
    /**
     * The bup_discount_percent
     * Meta information extracted from the WSDL
     * - documentation: discount percent. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $bup_discount_percent = null;
    /**
     * The bup_discount_percent_cp
     * Meta information extracted from the WSDL
     * - documentation: discount percent cp. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $bup_discount_percent_cp = null;
    /**
     * The bup_flat_rate
     * Meta information extracted from the WSDL
     * - documentation: flat rate. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $bup_flat_rate = null;
    /**
     * The bup_calculation
     * Meta information extracted from the WSDL
     * - documentation: calculation. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_calculation = null;
    /**
     * The bup_start_date
     * Meta information extracted from the WSDL
     * - documentation: start date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_start_date = null;
    /**
     * The bup_end_date
     * Meta information extracted from the WSDL
     * - documentation: end date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_end_date = null;
    /**
     * The bup_discount_calculation_flag
     * Meta information extracted from the WSDL
     * - documentation: calculate. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_discount_calculation_flag = null;
    /**
     * The bup_optional_flag
     * Meta information extracted from the WSDL
     * - documentation: optional. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_optional_flag = null;
    /**
     * The bup_renewable_flag
     * Meta information extracted from the WSDL
     * - documentation: Renewable?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $bup_renewable_flag = null;
    /**
     * The bup_bup_renewal_key
     * Meta information extracted from the WSDL
     * - documentation: Renewal Bundle Component. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $bup_bup_renewal_key = null;
    /**
     * Constructor method for InvoiceDetail_Bundle_Component_DataObjectType
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_key()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_add_user()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_add_date()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_change_user()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_change_date()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_delete_flag()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_entity_key()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_key_ext()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_bun_prd_key()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_prd_key()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_qty()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_discount_amount()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_discount_percent()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_discount_percent_cp()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_flat_rate()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_calculation()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_start_date()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_end_date()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_discount_calculation_flag()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_optional_flag()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_renewable_flag()
     * @uses InvoiceDetail_Bundle_Component_DataObjectType::setBup_bup_renewal_key()
     * @param string $bup_key
     * @param string $bup_add_user
     * @param string $bup_add_date
     * @param string $bup_change_user
     * @param string $bup_change_date
     * @param string $bup_delete_flag
     * @param string $bup_entity_key
     * @param string $bup_key_ext
     * @param string $bup_bun_prd_key
     * @param string $bup_prd_key
     * @param float $bup_qty
     * @param float $bup_discount_amount
     * @param float $bup_discount_percent
     * @param float $bup_discount_percent_cp
     * @param float $bup_flat_rate
     * @param string $bup_calculation
     * @param string $bup_start_date
     * @param string $bup_end_date
     * @param string $bup_discount_calculation_flag
     * @param string $bup_optional_flag
     * @param string $bup_renewable_flag
     * @param string $bup_bup_renewal_key
     */
    public function __construct(?string $bup_key = null, ?string $bup_add_user = null, ?string $bup_add_date = null, ?string $bup_change_user = null, ?string $bup_change_date = null, ?string $bup_delete_flag = null, ?string $bup_entity_key = null, ?string $bup_key_ext = null, ?string $bup_bun_prd_key = null, ?string $bup_prd_key = null, ?float $bup_qty = null, ?float $bup_discount_amount = null, ?float $bup_discount_percent = null, ?float $bup_discount_percent_cp = null, ?float $bup_flat_rate = null, ?string $bup_calculation = null, ?string $bup_start_date = null, ?string $bup_end_date = null, ?string $bup_discount_calculation_flag = null, ?string $bup_optional_flag = null, ?string $bup_renewable_flag = null, ?string $bup_bup_renewal_key = null)
    {
        $this
            ->setBup_key($bup_key)
            ->setBup_add_user($bup_add_user)
            ->setBup_add_date($bup_add_date)
            ->setBup_change_user($bup_change_user)
            ->setBup_change_date($bup_change_date)
            ->setBup_delete_flag($bup_delete_flag)
            ->setBup_entity_key($bup_entity_key)
            ->setBup_key_ext($bup_key_ext)
            ->setBup_bun_prd_key($bup_bun_prd_key)
            ->setBup_prd_key($bup_prd_key)
            ->setBup_qty($bup_qty)
            ->setBup_discount_amount($bup_discount_amount)
            ->setBup_discount_percent($bup_discount_percent)
            ->setBup_discount_percent_cp($bup_discount_percent_cp)
            ->setBup_flat_rate($bup_flat_rate)
            ->setBup_calculation($bup_calculation)
            ->setBup_start_date($bup_start_date)
            ->setBup_end_date($bup_end_date)
            ->setBup_discount_calculation_flag($bup_discount_calculation_flag)
            ->setBup_optional_flag($bup_optional_flag)
            ->setBup_renewable_flag($bup_renewable_flag)
            ->setBup_bup_renewal_key($bup_bup_renewal_key);
    }
    /**
     * Get bup_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_key(): ?string
    {
        return $this->bup_key ?? null;
    }
    /**
     * Set bup_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_key(?string $bup_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_key) && !is_string($bup_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_key, true), gettype($bup_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bup_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bup_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bup_key, true)), __LINE__);
        }
        if (is_null($bup_key) || (is_array($bup_key) && empty($bup_key))) {
            unset($this->bup_key);
        } else {
            $this->bup_key = $bup_key;
        }
        
        return $this;
    }
    /**
     * Get bup_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_add_user(): ?string
    {
        return $this->bup_add_user ?? null;
    }
    /**
     * Set bup_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_add_user(?string $bup_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_add_user) && !is_string($bup_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_add_user, true), gettype($bup_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bup_add_user) && mb_strlen((string) $bup_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bup_add_user)), __LINE__);
        }
        if (is_null($bup_add_user) || (is_array($bup_add_user) && empty($bup_add_user))) {
            unset($this->bup_add_user);
        } else {
            $this->bup_add_user = $bup_add_user;
        }
        
        return $this;
    }
    /**
     * Get bup_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_add_date(): ?string
    {
        return $this->bup_add_date ?? null;
    }
    /**
     * Set bup_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_add_date(?string $bup_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_add_date) && !is_string($bup_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_add_date, true), gettype($bup_add_date)), __LINE__);
        }
        if (is_null($bup_add_date) || (is_array($bup_add_date) && empty($bup_add_date))) {
            unset($this->bup_add_date);
        } else {
            $this->bup_add_date = $bup_add_date;
        }
        
        return $this;
    }
    /**
     * Get bup_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_change_user(): ?string
    {
        return $this->bup_change_user ?? null;
    }
    /**
     * Set bup_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_change_user(?string $bup_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_change_user) && !is_string($bup_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_change_user, true), gettype($bup_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bup_change_user) && mb_strlen((string) $bup_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $bup_change_user)), __LINE__);
        }
        if (is_null($bup_change_user) || (is_array($bup_change_user) && empty($bup_change_user))) {
            unset($this->bup_change_user);
        } else {
            $this->bup_change_user = $bup_change_user;
        }
        
        return $this;
    }
    /**
     * Get bup_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_change_date(): ?string
    {
        return $this->bup_change_date ?? null;
    }
    /**
     * Set bup_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_change_date(?string $bup_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_change_date) && !is_string($bup_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_change_date, true), gettype($bup_change_date)), __LINE__);
        }
        if (is_null($bup_change_date) || (is_array($bup_change_date) && empty($bup_change_date))) {
            unset($this->bup_change_date);
        } else {
            $this->bup_change_date = $bup_change_date;
        }
        
        return $this;
    }
    /**
     * Get bup_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_delete_flag(): ?string
    {
        return $this->bup_delete_flag ?? null;
    }
    /**
     * Set bup_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_delete_flag(?string $bup_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_delete_flag) && !is_string($bup_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_delete_flag, true), gettype($bup_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bup_delete_flag) && $bup_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bup_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bup_delete_flag) && $bup_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bup_delete_flag, true)), __LINE__);
        }
        if (is_null($bup_delete_flag) || (is_array($bup_delete_flag) && empty($bup_delete_flag))) {
            unset($this->bup_delete_flag);
        } else {
            $this->bup_delete_flag = $bup_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get bup_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_entity_key(): ?string
    {
        return $this->bup_entity_key ?? null;
    }
    /**
     * Set bup_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_entity_key(?string $bup_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_entity_key) && !is_string($bup_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_entity_key, true), gettype($bup_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bup_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bup_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bup_entity_key, true)), __LINE__);
        }
        if (is_null($bup_entity_key) || (is_array($bup_entity_key) && empty($bup_entity_key))) {
            unset($this->bup_entity_key);
        } else {
            $this->bup_entity_key = $bup_entity_key;
        }
        
        return $this;
    }
    /**
     * Get bup_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_key_ext(): ?string
    {
        return $this->bup_key_ext ?? null;
    }
    /**
     * Set bup_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_key_ext(?string $bup_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_key_ext) && !is_string($bup_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_key_ext, true), gettype($bup_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bup_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bup_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bup_key_ext, true)), __LINE__);
        }
        if (is_null($bup_key_ext) || (is_array($bup_key_ext) && empty($bup_key_ext))) {
            unset($this->bup_key_ext);
        } else {
            $this->bup_key_ext = $bup_key_ext;
        }
        
        return $this;
    }
    /**
     * Get bup_bun_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_bun_prd_key(): ?string
    {
        return $this->bup_bun_prd_key ?? null;
    }
    /**
     * Set bup_bun_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_bun_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_bun_prd_key(?string $bup_bun_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_bun_prd_key) && !is_string($bup_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_bun_prd_key, true), gettype($bup_bun_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bup_bun_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bup_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bup_bun_prd_key, true)), __LINE__);
        }
        if (is_null($bup_bun_prd_key) || (is_array($bup_bun_prd_key) && empty($bup_bun_prd_key))) {
            unset($this->bup_bun_prd_key);
        } else {
            $this->bup_bun_prd_key = $bup_bun_prd_key;
        }
        
        return $this;
    }
    /**
     * Get bup_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_prd_key(): ?string
    {
        return $this->bup_prd_key ?? null;
    }
    /**
     * Set bup_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_prd_key(?string $bup_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_prd_key) && !is_string($bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_prd_key, true), gettype($bup_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bup_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bup_prd_key, true)), __LINE__);
        }
        if (is_null($bup_prd_key) || (is_array($bup_prd_key) && empty($bup_prd_key))) {
            unset($this->bup_prd_key);
        } else {
            $this->bup_prd_key = $bup_prd_key;
        }
        
        return $this;
    }
    /**
     * Get bup_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBup_qty(): ?float
    {
        return $this->bup_qty ?? null;
    }
    /**
     * Set bup_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bup_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_qty(?float $bup_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($bup_qty) && !(is_float($bup_qty) || is_numeric($bup_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bup_qty, true), gettype($bup_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bup_qty) && mb_strlen(mb_substr((string) $bup_qty, false !== mb_strpos((string) $bup_qty, '.') ? mb_strpos((string) $bup_qty, '.') + 1 : mb_strlen((string) $bup_qty))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bup_qty, true), mb_strlen(mb_substr((string) $bup_qty, mb_strpos((string) $bup_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($bup_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $bup_qty)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($bup_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bup_qty))), __LINE__);
        }
        if (is_null($bup_qty) || (is_array($bup_qty) && empty($bup_qty))) {
            unset($this->bup_qty);
        } else {
            $this->bup_qty = $bup_qty;
        }
        
        return $this;
    }
    /**
     * Get bup_discount_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBup_discount_amount(): ?float
    {
        return $this->bup_discount_amount ?? null;
    }
    /**
     * Set bup_discount_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bup_discount_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_discount_amount(?float $bup_discount_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($bup_discount_amount) && !(is_float($bup_discount_amount) || is_numeric($bup_discount_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bup_discount_amount, true), gettype($bup_discount_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bup_discount_amount) && mb_strlen(mb_substr((string) $bup_discount_amount, false !== mb_strpos((string) $bup_discount_amount, '.') ? mb_strpos((string) $bup_discount_amount, '.') + 1 : mb_strlen((string) $bup_discount_amount))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bup_discount_amount, true), mb_strlen(mb_substr((string) $bup_discount_amount, mb_strpos((string) $bup_discount_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($bup_discount_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $bup_discount_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($bup_discount_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bup_discount_amount))), __LINE__);
        }
        if (is_null($bup_discount_amount) || (is_array($bup_discount_amount) && empty($bup_discount_amount))) {
            unset($this->bup_discount_amount);
        } else {
            $this->bup_discount_amount = $bup_discount_amount;
        }
        
        return $this;
    }
    /**
     * Get bup_discount_percent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBup_discount_percent(): ?float
    {
        return $this->bup_discount_percent ?? null;
    }
    /**
     * Set bup_discount_percent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bup_discount_percent
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_discount_percent(?float $bup_discount_percent = null): self
    {
        // validation for constraint: float
        if (!is_null($bup_discount_percent) && !(is_float($bup_discount_percent) || is_numeric($bup_discount_percent))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bup_discount_percent, true), gettype($bup_discount_percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bup_discount_percent) && mb_strlen(mb_substr((string) $bup_discount_percent, false !== mb_strpos((string) $bup_discount_percent, '.') ? mb_strpos((string) $bup_discount_percent, '.') + 1 : mb_strlen((string) $bup_discount_percent))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bup_discount_percent, true), mb_strlen(mb_substr((string) $bup_discount_percent, mb_strpos((string) $bup_discount_percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($bup_discount_percent) && mb_strlen(preg_replace('/(\D)/', '', (string) $bup_discount_percent)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($bup_discount_percent, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bup_discount_percent))), __LINE__);
        }
        if (is_null($bup_discount_percent) || (is_array($bup_discount_percent) && empty($bup_discount_percent))) {
            unset($this->bup_discount_percent);
        } else {
            $this->bup_discount_percent = $bup_discount_percent;
        }
        
        return $this;
    }
    /**
     * Get bup_discount_percent_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBup_discount_percent_cp(): ?float
    {
        return $this->bup_discount_percent_cp ?? null;
    }
    /**
     * Set bup_discount_percent_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bup_discount_percent_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_discount_percent_cp(?float $bup_discount_percent_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($bup_discount_percent_cp) && !(is_float($bup_discount_percent_cp) || is_numeric($bup_discount_percent_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bup_discount_percent_cp, true), gettype($bup_discount_percent_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($bup_discount_percent_cp) && mb_strlen(mb_substr((string) $bup_discount_percent_cp, false !== mb_strpos((string) $bup_discount_percent_cp, '.') ? mb_strpos((string) $bup_discount_percent_cp, '.') + 1 : mb_strlen((string) $bup_discount_percent_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($bup_discount_percent_cp, true), mb_strlen(mb_substr((string) $bup_discount_percent_cp, mb_strpos((string) $bup_discount_percent_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($bup_discount_percent_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $bup_discount_percent_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($bup_discount_percent_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bup_discount_percent_cp))), __LINE__);
        }
        if (is_null($bup_discount_percent_cp) || (is_array($bup_discount_percent_cp) && empty($bup_discount_percent_cp))) {
            unset($this->bup_discount_percent_cp);
        } else {
            $this->bup_discount_percent_cp = $bup_discount_percent_cp;
        }
        
        return $this;
    }
    /**
     * Get bup_flat_rate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBup_flat_rate(): ?float
    {
        return $this->bup_flat_rate ?? null;
    }
    /**
     * Set bup_flat_rate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bup_flat_rate
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_flat_rate(?float $bup_flat_rate = null): self
    {
        // validation for constraint: float
        if (!is_null($bup_flat_rate) && !(is_float($bup_flat_rate) || is_numeric($bup_flat_rate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bup_flat_rate, true), gettype($bup_flat_rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bup_flat_rate) && mb_strlen(mb_substr((string) $bup_flat_rate, false !== mb_strpos((string) $bup_flat_rate, '.') ? mb_strpos((string) $bup_flat_rate, '.') + 1 : mb_strlen((string) $bup_flat_rate))) > 2) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bup_flat_rate, true), mb_strlen(mb_substr((string) $bup_flat_rate, mb_strpos((string) $bup_flat_rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($bup_flat_rate) && mb_strlen(preg_replace('/(\D)/', '', (string) $bup_flat_rate)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($bup_flat_rate, true), mb_strlen(preg_replace('/(\D)/', '', (string) $bup_flat_rate))), __LINE__);
        }
        if (is_null($bup_flat_rate) || (is_array($bup_flat_rate) && empty($bup_flat_rate))) {
            unset($this->bup_flat_rate);
        } else {
            $this->bup_flat_rate = $bup_flat_rate;
        }
        
        return $this;
    }
    /**
     * Get bup_calculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_calculation(): ?string
    {
        return $this->bup_calculation ?? null;
    }
    /**
     * Set bup_calculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_calculation
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_calculation(?string $bup_calculation = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_calculation) && !is_string($bup_calculation)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_calculation, true), gettype($bup_calculation)), __LINE__);
        }
        if (is_null($bup_calculation) || (is_array($bup_calculation) && empty($bup_calculation))) {
            unset($this->bup_calculation);
        } else {
            $this->bup_calculation = $bup_calculation;
        }
        
        return $this;
    }
    /**
     * Get bup_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_start_date(): ?string
    {
        return $this->bup_start_date ?? null;
    }
    /**
     * Set bup_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_start_date(?string $bup_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_start_date) && !is_string($bup_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_start_date, true), gettype($bup_start_date)), __LINE__);
        }
        if (is_null($bup_start_date) || (is_array($bup_start_date) && empty($bup_start_date))) {
            unset($this->bup_start_date);
        } else {
            $this->bup_start_date = $bup_start_date;
        }
        
        return $this;
    }
    /**
     * Get bup_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_end_date(): ?string
    {
        return $this->bup_end_date ?? null;
    }
    /**
     * Set bup_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_end_date(?string $bup_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_end_date) && !is_string($bup_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_end_date, true), gettype($bup_end_date)), __LINE__);
        }
        if (is_null($bup_end_date) || (is_array($bup_end_date) && empty($bup_end_date))) {
            unset($this->bup_end_date);
        } else {
            $this->bup_end_date = $bup_end_date;
        }
        
        return $this;
    }
    /**
     * Get bup_discount_calculation_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_discount_calculation_flag(): ?string
    {
        return $this->bup_discount_calculation_flag ?? null;
    }
    /**
     * Set bup_discount_calculation_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_discount_calculation_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_discount_calculation_flag(?string $bup_discount_calculation_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_discount_calculation_flag) && !is_string($bup_discount_calculation_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_discount_calculation_flag, true), gettype($bup_discount_calculation_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bup_discount_calculation_flag) && $bup_discount_calculation_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bup_discount_calculation_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bup_discount_calculation_flag) && $bup_discount_calculation_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bup_discount_calculation_flag, true)), __LINE__);
        }
        if (is_null($bup_discount_calculation_flag) || (is_array($bup_discount_calculation_flag) && empty($bup_discount_calculation_flag))) {
            unset($this->bup_discount_calculation_flag);
        } else {
            $this->bup_discount_calculation_flag = $bup_discount_calculation_flag;
        }
        
        return $this;
    }
    /**
     * Get bup_optional_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_optional_flag(): ?string
    {
        return $this->bup_optional_flag ?? null;
    }
    /**
     * Set bup_optional_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_optional_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_optional_flag(?string $bup_optional_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_optional_flag) && !is_string($bup_optional_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_optional_flag, true), gettype($bup_optional_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bup_optional_flag) && $bup_optional_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bup_optional_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bup_optional_flag) && $bup_optional_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bup_optional_flag, true)), __LINE__);
        }
        if (is_null($bup_optional_flag) || (is_array($bup_optional_flag) && empty($bup_optional_flag))) {
            unset($this->bup_optional_flag);
        } else {
            $this->bup_optional_flag = $bup_optional_flag;
        }
        
        return $this;
    }
    /**
     * Get bup_renewable_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_renewable_flag(): ?string
    {
        return $this->bup_renewable_flag ?? null;
    }
    /**
     * Set bup_renewable_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_renewable_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_renewable_flag(?string $bup_renewable_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_renewable_flag) && !is_string($bup_renewable_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_renewable_flag, true), gettype($bup_renewable_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($bup_renewable_flag) && $bup_renewable_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($bup_renewable_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bup_renewable_flag) && $bup_renewable_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bup_renewable_flag, true)), __LINE__);
        }
        if (is_null($bup_renewable_flag) || (is_array($bup_renewable_flag) && empty($bup_renewable_flag))) {
            unset($this->bup_renewable_flag);
        } else {
            $this->bup_renewable_flag = $bup_renewable_flag;
        }
        
        return $this;
    }
    /**
     * Get bup_bup_renewal_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBup_bup_renewal_key(): ?string
    {
        return $this->bup_bup_renewal_key ?? null;
    }
    /**
     * Set bup_bup_renewal_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bup_bup_renewal_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Bundle_Component_DataObjectType
     */
    public function setBup_bup_renewal_key(?string $bup_bup_renewal_key = null): self
    {
        // validation for constraint: string
        if (!is_null($bup_bup_renewal_key) && !is_string($bup_bup_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bup_bup_renewal_key, true), gettype($bup_bup_renewal_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($bup_bup_renewal_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $bup_bup_renewal_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($bup_bup_renewal_key, true)), __LINE__);
        }
        if (is_null($bup_bup_renewal_key) || (is_array($bup_bup_renewal_key) && empty($bup_bup_renewal_key))) {
            unset($this->bup_bup_renewal_key);
        } else {
            $this->bup_bup_renewal_key = $bup_bup_renewal_key;
        }
        
        return $this;
    }
}
