<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Invoice_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Invoice_DataObjectType extends AbstractStructBase
{
    /**
     * The inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_key = null;
    /**
     * The inv_proforma
     * Meta information extracted from the WSDL
     * - documentation: Proforma?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_proforma = null;
    /**
     * The inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_code = null;
    /**
     * The inv_trx_date
     * Meta information extracted from the WSDL
     * - documentation: Transaction Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_trx_date = null;
    /**
     * The inv_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cst_key = null;
    /**
     * The inv_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_add_user = null;
    /**
     * The inv_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_add_date = null;
    /**
     * The inv_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_change_user = null;
    /**
     * The inv_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_change_date = null;
    /**
     * The inv_code_count
     * Meta information extracted from the WSDL
     * - documentation: Invoice Counter. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $inv_code_count = null;
    /**
     * The inv_code_cp
     * Meta information extracted from the WSDL
     * - documentation: Invoice Number. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 54
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_code_cp = null;
    /**
     * The inv_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_delete_flag = null;
    /**
     * The inv_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_key_ext = null;
    /**
     * The inv_ait_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Terms. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_ait_key = null;
    /**
     * The inv_print_count
     * Meta information extracted from the WSDL
     * - documentation: Print Count.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $inv_print_count = null;
    /**
     * The inv_print_date
     * Meta information extracted from the WSDL
     * - documentation: Date Printed. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_print_date = null;
    /**
     * The inv_print_user
     * Meta information extracted from the WSDL
     * - documentation: Last Printed By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_print_user = null;
    /**
     * The inv_src_key
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_src_key = null;
    /**
     * The inv_med_key
     * Meta information extracted from the WSDL
     * - documentation: Media Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_med_key = null;
    /**
     * The inv_post_flag
     * Meta information extracted from the WSDL
     * - documentation: Posted?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_post_flag = null;
    /**
     * The inv_notes_internal
     * Meta information extracted from the WSDL
     * - documentation: Internal Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_notes_internal = null;
    /**
     * The inv_bat_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Batch. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_bat_key = null;
    /**
     * The inv_notes_external
     * Meta information extracted from the WSDL
     * - documentation: External Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_notes_external = null;
    /**
     * The inv_ship_on_date
     * Meta information extracted from the WSDL
     * - documentation: Expected Ship Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_ship_on_date = null;
    /**
     * The inv_ship_priority
     * Meta information extracted from the WSDL
     * - documentation: Shipping Priority.This element has a default value of '3'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $inv_ship_priority = null;
    /**
     * The inv_po_number
     * Meta information extracted from the WSDL
     * - documentation: PO Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_po_number = null;
    /**
     * The inv_orig_trans_type
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_orig_trans_type = null;
    /**
     * The inv_fax_confirm_sent_flag
     * Meta information extracted from the WSDL
     * - documentation: fax confirmation sent. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_fax_confirm_sent_flag = null;
    /**
     * The inv_email_confirm_sent_flag
     * Meta information extracted from the WSDL
     * - documentation: e-mail confirmation sent. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_email_confirm_sent_flag = null;
    /**
     * The inv_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cxa_key = null;
    /**
     * The inv_cph_key
     * Meta information extracted from the WSDL
     * - documentation: Phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cph_key = null;
    /**
     * The inv_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cfx_key = null;
    /**
     * The inv_eml_key
     * Meta information extracted from the WSDL
     * - documentation: Email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_eml_key = null;
    /**
     * The inv_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Preferred Communication Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_pref_comm_meth = null;
    /**
     * The inv_billing_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Billing Preferred Communication Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_billing_pref_comm_meth = null;
    /**
     * The inv_close_flag
     * Meta information extracted from the WSDL
     * - documentation: Closed?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_close_flag = null;
    /**
     * The inv_bat_close_flag
     * Meta information extracted from the WSDL
     * - documentation: Batch Closed?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_bat_close_flag = null;
    /**
     * The inv_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_entity_key = null;
    /**
     * The inv_col_key
     * Meta information extracted from the WSDL
     * - documentation: Collection Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_col_key = null;
    /**
     * The inv_cst_billing_key
     * Meta information extracted from the WSDL
     * - documentation: Bill To Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cst_billing_key = null;
    /**
     * The inv_ind_cst_billing_key
     * Meta information extracted from the WSDL
     * - documentation: Billing Contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_ind_cst_billing_key = null;
    /**
     * The inv_ord_key
     * Meta information extracted from the WSDL
     * - documentation: Order Id. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_ord_key = null;
    /**
     * The inv_tracking_number
     * Meta information extracted from the WSDL
     * - documentation: Tracking Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_tracking_number = null;
    /**
     * The inv_group_flag
     * Meta information extracted from the WSDL
     * - documentation: Group Items for Reporting. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_group_flag = null;
    /**
     * The inv_group_description
     * Meta information extracted from the WSDL
     * - documentation: Invoice Group Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $inv_group_description = null;
    /**
     * The inv_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_cur_key = null;
    /**
     * The inv_allow_installments
     * Meta information extracted from the WSDL
     * - documentation: Allow installments?. | Avectra netForum defined simpleType.
     * - base: s:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [0-1]
     * @var bool|null
     */
    protected ?bool $inv_allow_installments = null;
    /**
     * The inv_sfo_key
     * Meta information extracted from the WSDL
     * - documentation: opportunity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_sfo_key = null;
    /**
     * The inv_pbs_key
     * Meta information extracted from the WSDL
     * - documentation: Payment Batch Status Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_pbs_key = null;
    /**
     * The inv_NewBatch_key
     * Meta information extracted from the WSDL
     * - documentation: inv_NewBatch_key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_NewBatch_key = null;
    /**
     * The inv_pay_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Paid By.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $inv_pay_cst_key = null;
    /**
     * Constructor method for InvoiceDetail_Invoice_DataObjectType
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_proforma()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_code()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_trx_date()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_cst_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_add_user()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_add_date()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_change_user()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_change_date()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_code_count()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_code_cp()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_delete_flag()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_key_ext()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_ait_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_print_count()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_print_date()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_print_user()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_src_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_med_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_post_flag()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_notes_internal()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_bat_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_notes_external()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_ship_on_date()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_ship_priority()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_po_number()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_orig_trans_type()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_fax_confirm_sent_flag()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_email_confirm_sent_flag()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_cxa_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_cph_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_cfx_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_eml_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_pref_comm_meth()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_billing_pref_comm_meth()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_close_flag()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_bat_close_flag()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_entity_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_col_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_cst_billing_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_ind_cst_billing_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_ord_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_tracking_number()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_group_flag()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_group_description()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_cur_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_allow_installments()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_sfo_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_pbs_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_NewBatch_key()
     * @uses InvoiceDetail_Invoice_DataObjectType::setInv_pay_cst_key()
     * @param string $inv_key
     * @param string $inv_proforma
     * @param string $inv_code
     * @param string $inv_trx_date
     * @param string $inv_cst_key
     * @param string $inv_add_user
     * @param string $inv_add_date
     * @param string $inv_change_user
     * @param string $inv_change_date
     * @param int $inv_code_count
     * @param string $inv_code_cp
     * @param string $inv_delete_flag
     * @param string $inv_key_ext
     * @param string $inv_ait_key
     * @param int $inv_print_count
     * @param string $inv_print_date
     * @param string $inv_print_user
     * @param string $inv_src_key
     * @param string $inv_med_key
     * @param string $inv_post_flag
     * @param string $inv_notes_internal
     * @param string $inv_bat_key
     * @param string $inv_notes_external
     * @param string $inv_ship_on_date
     * @param int $inv_ship_priority
     * @param string $inv_po_number
     * @param string $inv_orig_trans_type
     * @param string $inv_fax_confirm_sent_flag
     * @param string $inv_email_confirm_sent_flag
     * @param string $inv_cxa_key
     * @param string $inv_cph_key
     * @param string $inv_cfx_key
     * @param string $inv_eml_key
     * @param string $inv_pref_comm_meth
     * @param string $inv_billing_pref_comm_meth
     * @param string $inv_close_flag
     * @param string $inv_bat_close_flag
     * @param string $inv_entity_key
     * @param string $inv_col_key
     * @param string $inv_cst_billing_key
     * @param string $inv_ind_cst_billing_key
     * @param string $inv_ord_key
     * @param string $inv_tracking_number
     * @param string $inv_group_flag
     * @param string $inv_group_description
     * @param string $inv_cur_key
     * @param bool $inv_allow_installments
     * @param string $inv_sfo_key
     * @param string $inv_pbs_key
     * @param string $inv_NewBatch_key
     * @param string $inv_pay_cst_key
     */
    public function __construct(?string $inv_key = null, ?string $inv_proforma = null, ?string $inv_code = null, ?string $inv_trx_date = null, ?string $inv_cst_key = null, ?string $inv_add_user = null, ?string $inv_add_date = null, ?string $inv_change_user = null, ?string $inv_change_date = null, ?int $inv_code_count = null, ?string $inv_code_cp = null, ?string $inv_delete_flag = null, ?string $inv_key_ext = null, ?string $inv_ait_key = null, ?int $inv_print_count = null, ?string $inv_print_date = null, ?string $inv_print_user = null, ?string $inv_src_key = null, ?string $inv_med_key = null, ?string $inv_post_flag = null, ?string $inv_notes_internal = null, ?string $inv_bat_key = null, ?string $inv_notes_external = null, ?string $inv_ship_on_date = null, ?int $inv_ship_priority = null, ?string $inv_po_number = null, ?string $inv_orig_trans_type = null, ?string $inv_fax_confirm_sent_flag = null, ?string $inv_email_confirm_sent_flag = null, ?string $inv_cxa_key = null, ?string $inv_cph_key = null, ?string $inv_cfx_key = null, ?string $inv_eml_key = null, ?string $inv_pref_comm_meth = null, ?string $inv_billing_pref_comm_meth = null, ?string $inv_close_flag = null, ?string $inv_bat_close_flag = null, ?string $inv_entity_key = null, ?string $inv_col_key = null, ?string $inv_cst_billing_key = null, ?string $inv_ind_cst_billing_key = null, ?string $inv_ord_key = null, ?string $inv_tracking_number = null, ?string $inv_group_flag = null, ?string $inv_group_description = null, ?string $inv_cur_key = null, ?bool $inv_allow_installments = null, ?string $inv_sfo_key = null, ?string $inv_pbs_key = null, ?string $inv_NewBatch_key = null, ?string $inv_pay_cst_key = null)
    {
        $this
            ->setInv_key($inv_key)
            ->setInv_proforma($inv_proforma)
            ->setInv_code($inv_code)
            ->setInv_trx_date($inv_trx_date)
            ->setInv_cst_key($inv_cst_key)
            ->setInv_add_user($inv_add_user)
            ->setInv_add_date($inv_add_date)
            ->setInv_change_user($inv_change_user)
            ->setInv_change_date($inv_change_date)
            ->setInv_code_count($inv_code_count)
            ->setInv_code_cp($inv_code_cp)
            ->setInv_delete_flag($inv_delete_flag)
            ->setInv_key_ext($inv_key_ext)
            ->setInv_ait_key($inv_ait_key)
            ->setInv_print_count($inv_print_count)
            ->setInv_print_date($inv_print_date)
            ->setInv_print_user($inv_print_user)
            ->setInv_src_key($inv_src_key)
            ->setInv_med_key($inv_med_key)
            ->setInv_post_flag($inv_post_flag)
            ->setInv_notes_internal($inv_notes_internal)
            ->setInv_bat_key($inv_bat_key)
            ->setInv_notes_external($inv_notes_external)
            ->setInv_ship_on_date($inv_ship_on_date)
            ->setInv_ship_priority($inv_ship_priority)
            ->setInv_po_number($inv_po_number)
            ->setInv_orig_trans_type($inv_orig_trans_type)
            ->setInv_fax_confirm_sent_flag($inv_fax_confirm_sent_flag)
            ->setInv_email_confirm_sent_flag($inv_email_confirm_sent_flag)
            ->setInv_cxa_key($inv_cxa_key)
            ->setInv_cph_key($inv_cph_key)
            ->setInv_cfx_key($inv_cfx_key)
            ->setInv_eml_key($inv_eml_key)
            ->setInv_pref_comm_meth($inv_pref_comm_meth)
            ->setInv_billing_pref_comm_meth($inv_billing_pref_comm_meth)
            ->setInv_close_flag($inv_close_flag)
            ->setInv_bat_close_flag($inv_bat_close_flag)
            ->setInv_entity_key($inv_entity_key)
            ->setInv_col_key($inv_col_key)
            ->setInv_cst_billing_key($inv_cst_billing_key)
            ->setInv_ind_cst_billing_key($inv_ind_cst_billing_key)
            ->setInv_ord_key($inv_ord_key)
            ->setInv_tracking_number($inv_tracking_number)
            ->setInv_group_flag($inv_group_flag)
            ->setInv_group_description($inv_group_description)
            ->setInv_cur_key($inv_cur_key)
            ->setInv_allow_installments($inv_allow_installments)
            ->setInv_sfo_key($inv_sfo_key)
            ->setInv_pbs_key($inv_pbs_key)
            ->setInv_NewBatch_key($inv_NewBatch_key)
            ->setInv_pay_cst_key($inv_pay_cst_key);
    }
    /**
     * Get inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_key(): ?string
    {
        return $this->inv_key ?? null;
    }
    /**
     * Set inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_key(?string $inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_key) && !is_string($inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_key, true), gettype($inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_key, true)), __LINE__);
        }
        if (is_null($inv_key) || (is_array($inv_key) && empty($inv_key))) {
            unset($this->inv_key);
        } else {
            $this->inv_key = $inv_key;
        }
        
        return $this;
    }
    /**
     * Get inv_proforma value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_proforma(): ?string
    {
        return $this->inv_proforma ?? null;
    }
    /**
     * Set inv_proforma value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_proforma
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_proforma(?string $inv_proforma = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_proforma) && !is_string($inv_proforma)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_proforma, true), gettype($inv_proforma)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_proforma) && $inv_proforma > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_proforma, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_proforma) && $inv_proforma < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_proforma, true)), __LINE__);
        }
        if (is_null($inv_proforma) || (is_array($inv_proforma) && empty($inv_proforma))) {
            unset($this->inv_proforma);
        } else {
            $this->inv_proforma = $inv_proforma;
        }
        
        return $this;
    }
    /**
     * Get inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_code(): ?string
    {
        return $this->inv_code ?? null;
    }
    /**
     * Set inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_code(?string $inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_code) && !is_string($inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_code, true), gettype($inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($inv_code) && mb_strlen((string) $inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $inv_code)), __LINE__);
        }
        if (is_null($inv_code) || (is_array($inv_code) && empty($inv_code))) {
            unset($this->inv_code);
        } else {
            $this->inv_code = $inv_code;
        }
        
        return $this;
    }
    /**
     * Get inv_trx_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_trx_date(): ?string
    {
        return $this->inv_trx_date ?? null;
    }
    /**
     * Set inv_trx_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_trx_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_trx_date(?string $inv_trx_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_trx_date) && !is_string($inv_trx_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_trx_date, true), gettype($inv_trx_date)), __LINE__);
        }
        if (is_null($inv_trx_date) || (is_array($inv_trx_date) && empty($inv_trx_date))) {
            unset($this->inv_trx_date);
        } else {
            $this->inv_trx_date = $inv_trx_date;
        }
        
        return $this;
    }
    /**
     * Get inv_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cst_key(): ?string
    {
        return $this->inv_cst_key ?? null;
    }
    /**
     * Set inv_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_cst_key(?string $inv_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cst_key) && !is_string($inv_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cst_key, true), gettype($inv_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cst_key, true)), __LINE__);
        }
        if (is_null($inv_cst_key) || (is_array($inv_cst_key) && empty($inv_cst_key))) {
            unset($this->inv_cst_key);
        } else {
            $this->inv_cst_key = $inv_cst_key;
        }
        
        return $this;
    }
    /**
     * Get inv_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_add_user(): ?string
    {
        return $this->inv_add_user ?? null;
    }
    /**
     * Set inv_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_add_user(?string $inv_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_add_user) && !is_string($inv_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_add_user, true), gettype($inv_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($inv_add_user) && mb_strlen((string) $inv_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $inv_add_user)), __LINE__);
        }
        if (is_null($inv_add_user) || (is_array($inv_add_user) && empty($inv_add_user))) {
            unset($this->inv_add_user);
        } else {
            $this->inv_add_user = $inv_add_user;
        }
        
        return $this;
    }
    /**
     * Get inv_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_add_date(): ?string
    {
        return $this->inv_add_date ?? null;
    }
    /**
     * Set inv_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_add_date(?string $inv_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_add_date) && !is_string($inv_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_add_date, true), gettype($inv_add_date)), __LINE__);
        }
        if (is_null($inv_add_date) || (is_array($inv_add_date) && empty($inv_add_date))) {
            unset($this->inv_add_date);
        } else {
            $this->inv_add_date = $inv_add_date;
        }
        
        return $this;
    }
    /**
     * Get inv_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_change_user(): ?string
    {
        return $this->inv_change_user ?? null;
    }
    /**
     * Set inv_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_change_user(?string $inv_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_change_user) && !is_string($inv_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_change_user, true), gettype($inv_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($inv_change_user) && mb_strlen((string) $inv_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $inv_change_user)), __LINE__);
        }
        if (is_null($inv_change_user) || (is_array($inv_change_user) && empty($inv_change_user))) {
            unset($this->inv_change_user);
        } else {
            $this->inv_change_user = $inv_change_user;
        }
        
        return $this;
    }
    /**
     * Get inv_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_change_date(): ?string
    {
        return $this->inv_change_date ?? null;
    }
    /**
     * Set inv_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_change_date(?string $inv_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_change_date) && !is_string($inv_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_change_date, true), gettype($inv_change_date)), __LINE__);
        }
        if (is_null($inv_change_date) || (is_array($inv_change_date) && empty($inv_change_date))) {
            unset($this->inv_change_date);
        } else {
            $this->inv_change_date = $inv_change_date;
        }
        
        return $this;
    }
    /**
     * Get inv_code_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInv_code_count(): ?int
    {
        return $this->inv_code_count ?? null;
    }
    /**
     * Set inv_code_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inv_code_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_code_count(?int $inv_code_count = null): self
    {
        // validation for constraint: int
        if (!is_null($inv_code_count) && !(is_int($inv_code_count) || ctype_digit($inv_code_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inv_code_count, true), gettype($inv_code_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($inv_code_count) && $inv_code_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($inv_code_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($inv_code_count) && $inv_code_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($inv_code_count, true)), __LINE__);
        }
        if (is_null($inv_code_count) || (is_array($inv_code_count) && empty($inv_code_count))) {
            unset($this->inv_code_count);
        } else {
            $this->inv_code_count = $inv_code_count;
        }
        
        return $this;
    }
    /**
     * Get inv_code_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_code_cp(): ?string
    {
        return $this->inv_code_cp ?? null;
    }
    /**
     * Set inv_code_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_code_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_code_cp(?string $inv_code_cp = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_code_cp) && !is_string($inv_code_cp)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_code_cp, true), gettype($inv_code_cp)), __LINE__);
        }
        // validation for constraint: maxLength(54)
        if (!is_null($inv_code_cp) && mb_strlen((string) $inv_code_cp) > 54) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 54', mb_strlen((string) $inv_code_cp)), __LINE__);
        }
        if (is_null($inv_code_cp) || (is_array($inv_code_cp) && empty($inv_code_cp))) {
            unset($this->inv_code_cp);
        } else {
            $this->inv_code_cp = $inv_code_cp;
        }
        
        return $this;
    }
    /**
     * Get inv_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_delete_flag(): ?string
    {
        return $this->inv_delete_flag ?? null;
    }
    /**
     * Set inv_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_delete_flag(?string $inv_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_delete_flag) && !is_string($inv_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_delete_flag, true), gettype($inv_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_delete_flag) && $inv_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_delete_flag) && $inv_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_delete_flag, true)), __LINE__);
        }
        if (is_null($inv_delete_flag) || (is_array($inv_delete_flag) && empty($inv_delete_flag))) {
            unset($this->inv_delete_flag);
        } else {
            $this->inv_delete_flag = $inv_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_key_ext(): ?string
    {
        return $this->inv_key_ext ?? null;
    }
    /**
     * Set inv_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_key_ext(?string $inv_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_key_ext) && !is_string($inv_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_key_ext, true), gettype($inv_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_key_ext, true)), __LINE__);
        }
        if (is_null($inv_key_ext) || (is_array($inv_key_ext) && empty($inv_key_ext))) {
            unset($this->inv_key_ext);
        } else {
            $this->inv_key_ext = $inv_key_ext;
        }
        
        return $this;
    }
    /**
     * Get inv_ait_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_ait_key(): ?string
    {
        return $this->inv_ait_key ?? null;
    }
    /**
     * Set inv_ait_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_ait_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_ait_key(?string $inv_ait_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_ait_key) && !is_string($inv_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_ait_key, true), gettype($inv_ait_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_ait_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_ait_key, true)), __LINE__);
        }
        if (is_null($inv_ait_key) || (is_array($inv_ait_key) && empty($inv_ait_key))) {
            unset($this->inv_ait_key);
        } else {
            $this->inv_ait_key = $inv_ait_key;
        }
        
        return $this;
    }
    /**
     * Get inv_print_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInv_print_count(): ?int
    {
        return $this->inv_print_count ?? null;
    }
    /**
     * Set inv_print_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inv_print_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_print_count(?int $inv_print_count = null): self
    {
        // validation for constraint: int
        if (!is_null($inv_print_count) && !(is_int($inv_print_count) || ctype_digit($inv_print_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inv_print_count, true), gettype($inv_print_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($inv_print_count) && $inv_print_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($inv_print_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($inv_print_count) && $inv_print_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($inv_print_count, true)), __LINE__);
        }
        if (is_null($inv_print_count) || (is_array($inv_print_count) && empty($inv_print_count))) {
            unset($this->inv_print_count);
        } else {
            $this->inv_print_count = $inv_print_count;
        }
        
        return $this;
    }
    /**
     * Get inv_print_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_print_date(): ?string
    {
        return $this->inv_print_date ?? null;
    }
    /**
     * Set inv_print_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_print_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_print_date(?string $inv_print_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_print_date) && !is_string($inv_print_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_print_date, true), gettype($inv_print_date)), __LINE__);
        }
        if (is_null($inv_print_date) || (is_array($inv_print_date) && empty($inv_print_date))) {
            unset($this->inv_print_date);
        } else {
            $this->inv_print_date = $inv_print_date;
        }
        
        return $this;
    }
    /**
     * Get inv_print_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_print_user(): ?string
    {
        return $this->inv_print_user ?? null;
    }
    /**
     * Set inv_print_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_print_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_print_user(?string $inv_print_user = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_print_user) && !is_string($inv_print_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_print_user, true), gettype($inv_print_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($inv_print_user) && mb_strlen((string) $inv_print_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $inv_print_user)), __LINE__);
        }
        if (is_null($inv_print_user) || (is_array($inv_print_user) && empty($inv_print_user))) {
            unset($this->inv_print_user);
        } else {
            $this->inv_print_user = $inv_print_user;
        }
        
        return $this;
    }
    /**
     * Get inv_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_src_key(): ?string
    {
        return $this->inv_src_key ?? null;
    }
    /**
     * Set inv_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_src_key(?string $inv_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_src_key) && !is_string($inv_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_src_key, true), gettype($inv_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_src_key, true)), __LINE__);
        }
        if (is_null($inv_src_key) || (is_array($inv_src_key) && empty($inv_src_key))) {
            unset($this->inv_src_key);
        } else {
            $this->inv_src_key = $inv_src_key;
        }
        
        return $this;
    }
    /**
     * Get inv_med_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_med_key(): ?string
    {
        return $this->inv_med_key ?? null;
    }
    /**
     * Set inv_med_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_med_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_med_key(?string $inv_med_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_med_key) && !is_string($inv_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_med_key, true), gettype($inv_med_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_med_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_med_key, true)), __LINE__);
        }
        if (is_null($inv_med_key) || (is_array($inv_med_key) && empty($inv_med_key))) {
            unset($this->inv_med_key);
        } else {
            $this->inv_med_key = $inv_med_key;
        }
        
        return $this;
    }
    /**
     * Get inv_post_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_post_flag(): ?string
    {
        return $this->inv_post_flag ?? null;
    }
    /**
     * Set inv_post_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_post_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_post_flag(?string $inv_post_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_post_flag) && !is_string($inv_post_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_post_flag, true), gettype($inv_post_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_post_flag) && $inv_post_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_post_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_post_flag) && $inv_post_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_post_flag, true)), __LINE__);
        }
        if (is_null($inv_post_flag) || (is_array($inv_post_flag) && empty($inv_post_flag))) {
            unset($this->inv_post_flag);
        } else {
            $this->inv_post_flag = $inv_post_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_notes_internal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_notes_internal(): ?string
    {
        return $this->inv_notes_internal ?? null;
    }
    /**
     * Set inv_notes_internal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_notes_internal
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_notes_internal(?string $inv_notes_internal = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_notes_internal) && !is_string($inv_notes_internal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_notes_internal, true), gettype($inv_notes_internal)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($inv_notes_internal) && mb_strlen((string) $inv_notes_internal) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $inv_notes_internal)), __LINE__);
        }
        if (is_null($inv_notes_internal) || (is_array($inv_notes_internal) && empty($inv_notes_internal))) {
            unset($this->inv_notes_internal);
        } else {
            $this->inv_notes_internal = $inv_notes_internal;
        }
        
        return $this;
    }
    /**
     * Get inv_bat_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_bat_key(): ?string
    {
        return $this->inv_bat_key ?? null;
    }
    /**
     * Set inv_bat_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_bat_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_bat_key(?string $inv_bat_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_bat_key) && !is_string($inv_bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_bat_key, true), gettype($inv_bat_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_bat_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_bat_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_bat_key, true)), __LINE__);
        }
        if (is_null($inv_bat_key) || (is_array($inv_bat_key) && empty($inv_bat_key))) {
            unset($this->inv_bat_key);
        } else {
            $this->inv_bat_key = $inv_bat_key;
        }
        
        return $this;
    }
    /**
     * Get inv_notes_external value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_notes_external(): ?string
    {
        return $this->inv_notes_external ?? null;
    }
    /**
     * Set inv_notes_external value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_notes_external
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_notes_external(?string $inv_notes_external = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_notes_external) && !is_string($inv_notes_external)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_notes_external, true), gettype($inv_notes_external)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($inv_notes_external) && mb_strlen((string) $inv_notes_external) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $inv_notes_external)), __LINE__);
        }
        if (is_null($inv_notes_external) || (is_array($inv_notes_external) && empty($inv_notes_external))) {
            unset($this->inv_notes_external);
        } else {
            $this->inv_notes_external = $inv_notes_external;
        }
        
        return $this;
    }
    /**
     * Get inv_ship_on_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_ship_on_date(): ?string
    {
        return $this->inv_ship_on_date ?? null;
    }
    /**
     * Set inv_ship_on_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_ship_on_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_ship_on_date(?string $inv_ship_on_date = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_ship_on_date) && !is_string($inv_ship_on_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_ship_on_date, true), gettype($inv_ship_on_date)), __LINE__);
        }
        if (is_null($inv_ship_on_date) || (is_array($inv_ship_on_date) && empty($inv_ship_on_date))) {
            unset($this->inv_ship_on_date);
        } else {
            $this->inv_ship_on_date = $inv_ship_on_date;
        }
        
        return $this;
    }
    /**
     * Get inv_ship_priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInv_ship_priority(): ?int
    {
        return $this->inv_ship_priority ?? null;
    }
    /**
     * Set inv_ship_priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inv_ship_priority
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_ship_priority(?int $inv_ship_priority = null): self
    {
        // validation for constraint: int
        if (!is_null($inv_ship_priority) && !(is_int($inv_ship_priority) || ctype_digit($inv_ship_priority))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inv_ship_priority, true), gettype($inv_ship_priority)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($inv_ship_priority) && $inv_ship_priority > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($inv_ship_priority, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($inv_ship_priority) && $inv_ship_priority < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($inv_ship_priority, true)), __LINE__);
        }
        if (is_null($inv_ship_priority) || (is_array($inv_ship_priority) && empty($inv_ship_priority))) {
            unset($this->inv_ship_priority);
        } else {
            $this->inv_ship_priority = $inv_ship_priority;
        }
        
        return $this;
    }
    /**
     * Get inv_po_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_po_number(): ?string
    {
        return $this->inv_po_number ?? null;
    }
    /**
     * Set inv_po_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_po_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_po_number(?string $inv_po_number = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_po_number) && !is_string($inv_po_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_po_number, true), gettype($inv_po_number)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($inv_po_number) && mb_strlen((string) $inv_po_number) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $inv_po_number)), __LINE__);
        }
        if (is_null($inv_po_number) || (is_array($inv_po_number) && empty($inv_po_number))) {
            unset($this->inv_po_number);
        } else {
            $this->inv_po_number = $inv_po_number;
        }
        
        return $this;
    }
    /**
     * Get inv_orig_trans_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_orig_trans_type(): ?string
    {
        return $this->inv_orig_trans_type ?? null;
    }
    /**
     * Set inv_orig_trans_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_orig_trans_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_orig_trans_type(?string $inv_orig_trans_type = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_orig_trans_type) && !is_string($inv_orig_trans_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_orig_trans_type, true), gettype($inv_orig_trans_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($inv_orig_trans_type) && mb_strlen((string) $inv_orig_trans_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $inv_orig_trans_type)), __LINE__);
        }
        if (is_null($inv_orig_trans_type) || (is_array($inv_orig_trans_type) && empty($inv_orig_trans_type))) {
            unset($this->inv_orig_trans_type);
        } else {
            $this->inv_orig_trans_type = $inv_orig_trans_type;
        }
        
        return $this;
    }
    /**
     * Get inv_fax_confirm_sent_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_fax_confirm_sent_flag(): ?string
    {
        return $this->inv_fax_confirm_sent_flag ?? null;
    }
    /**
     * Set inv_fax_confirm_sent_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_fax_confirm_sent_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_fax_confirm_sent_flag(?string $inv_fax_confirm_sent_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_fax_confirm_sent_flag) && !is_string($inv_fax_confirm_sent_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_fax_confirm_sent_flag, true), gettype($inv_fax_confirm_sent_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_fax_confirm_sent_flag) && $inv_fax_confirm_sent_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_fax_confirm_sent_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_fax_confirm_sent_flag) && $inv_fax_confirm_sent_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_fax_confirm_sent_flag, true)), __LINE__);
        }
        if (is_null($inv_fax_confirm_sent_flag) || (is_array($inv_fax_confirm_sent_flag) && empty($inv_fax_confirm_sent_flag))) {
            unset($this->inv_fax_confirm_sent_flag);
        } else {
            $this->inv_fax_confirm_sent_flag = $inv_fax_confirm_sent_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_email_confirm_sent_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_email_confirm_sent_flag(): ?string
    {
        return $this->inv_email_confirm_sent_flag ?? null;
    }
    /**
     * Set inv_email_confirm_sent_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_email_confirm_sent_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_email_confirm_sent_flag(?string $inv_email_confirm_sent_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_email_confirm_sent_flag) && !is_string($inv_email_confirm_sent_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_email_confirm_sent_flag, true), gettype($inv_email_confirm_sent_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_email_confirm_sent_flag) && $inv_email_confirm_sent_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_email_confirm_sent_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_email_confirm_sent_flag) && $inv_email_confirm_sent_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_email_confirm_sent_flag, true)), __LINE__);
        }
        if (is_null($inv_email_confirm_sent_flag) || (is_array($inv_email_confirm_sent_flag) && empty($inv_email_confirm_sent_flag))) {
            unset($this->inv_email_confirm_sent_flag);
        } else {
            $this->inv_email_confirm_sent_flag = $inv_email_confirm_sent_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cxa_key(): ?string
    {
        return $this->inv_cxa_key ?? null;
    }
    /**
     * Set inv_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_cxa_key(?string $inv_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cxa_key) && !is_string($inv_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cxa_key, true), gettype($inv_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cxa_key, true)), __LINE__);
        }
        if (is_null($inv_cxa_key) || (is_array($inv_cxa_key) && empty($inv_cxa_key))) {
            unset($this->inv_cxa_key);
        } else {
            $this->inv_cxa_key = $inv_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get inv_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cph_key(): ?string
    {
        return $this->inv_cph_key ?? null;
    }
    /**
     * Set inv_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_cph_key(?string $inv_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cph_key) && !is_string($inv_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cph_key, true), gettype($inv_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cph_key, true)), __LINE__);
        }
        if (is_null($inv_cph_key) || (is_array($inv_cph_key) && empty($inv_cph_key))) {
            unset($this->inv_cph_key);
        } else {
            $this->inv_cph_key = $inv_cph_key;
        }
        
        return $this;
    }
    /**
     * Get inv_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cfx_key(): ?string
    {
        return $this->inv_cfx_key ?? null;
    }
    /**
     * Set inv_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_cfx_key(?string $inv_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cfx_key) && !is_string($inv_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cfx_key, true), gettype($inv_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cfx_key, true)), __LINE__);
        }
        if (is_null($inv_cfx_key) || (is_array($inv_cfx_key) && empty($inv_cfx_key))) {
            unset($this->inv_cfx_key);
        } else {
            $this->inv_cfx_key = $inv_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get inv_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_eml_key(): ?string
    {
        return $this->inv_eml_key ?? null;
    }
    /**
     * Set inv_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_eml_key(?string $inv_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_eml_key) && !is_string($inv_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_eml_key, true), gettype($inv_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_eml_key, true)), __LINE__);
        }
        if (is_null($inv_eml_key) || (is_array($inv_eml_key) && empty($inv_eml_key))) {
            unset($this->inv_eml_key);
        } else {
            $this->inv_eml_key = $inv_eml_key;
        }
        
        return $this;
    }
    /**
     * Get inv_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_pref_comm_meth(): ?string
    {
        return $this->inv_pref_comm_meth ?? null;
    }
    /**
     * Set inv_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_pref_comm_meth(?string $inv_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_pref_comm_meth) && !is_string($inv_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_pref_comm_meth, true), gettype($inv_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($inv_pref_comm_meth) && mb_strlen((string) $inv_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $inv_pref_comm_meth)), __LINE__);
        }
        if (is_null($inv_pref_comm_meth) || (is_array($inv_pref_comm_meth) && empty($inv_pref_comm_meth))) {
            unset($this->inv_pref_comm_meth);
        } else {
            $this->inv_pref_comm_meth = $inv_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get inv_billing_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_billing_pref_comm_meth(): ?string
    {
        return $this->inv_billing_pref_comm_meth ?? null;
    }
    /**
     * Set inv_billing_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_billing_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_billing_pref_comm_meth(?string $inv_billing_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_billing_pref_comm_meth) && !is_string($inv_billing_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_billing_pref_comm_meth, true), gettype($inv_billing_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($inv_billing_pref_comm_meth) && mb_strlen((string) $inv_billing_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $inv_billing_pref_comm_meth)), __LINE__);
        }
        if (is_null($inv_billing_pref_comm_meth) || (is_array($inv_billing_pref_comm_meth) && empty($inv_billing_pref_comm_meth))) {
            unset($this->inv_billing_pref_comm_meth);
        } else {
            $this->inv_billing_pref_comm_meth = $inv_billing_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get inv_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_close_flag(): ?string
    {
        return $this->inv_close_flag ?? null;
    }
    /**
     * Set inv_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_close_flag(?string $inv_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_close_flag) && !is_string($inv_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_close_flag, true), gettype($inv_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_close_flag) && $inv_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_close_flag) && $inv_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_close_flag, true)), __LINE__);
        }
        if (is_null($inv_close_flag) || (is_array($inv_close_flag) && empty($inv_close_flag))) {
            unset($this->inv_close_flag);
        } else {
            $this->inv_close_flag = $inv_close_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_bat_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_bat_close_flag(): ?string
    {
        return $this->inv_bat_close_flag ?? null;
    }
    /**
     * Set inv_bat_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_bat_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_bat_close_flag(?string $inv_bat_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_bat_close_flag) && !is_string($inv_bat_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_bat_close_flag, true), gettype($inv_bat_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_bat_close_flag) && $inv_bat_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_bat_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_bat_close_flag) && $inv_bat_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_bat_close_flag, true)), __LINE__);
        }
        if (is_null($inv_bat_close_flag) || (is_array($inv_bat_close_flag) && empty($inv_bat_close_flag))) {
            unset($this->inv_bat_close_flag);
        } else {
            $this->inv_bat_close_flag = $inv_bat_close_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_entity_key(): ?string
    {
        return $this->inv_entity_key ?? null;
    }
    /**
     * Set inv_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_entity_key(?string $inv_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_entity_key) && !is_string($inv_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_entity_key, true), gettype($inv_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_entity_key, true)), __LINE__);
        }
        if (is_null($inv_entity_key) || (is_array($inv_entity_key) && empty($inv_entity_key))) {
            unset($this->inv_entity_key);
        } else {
            $this->inv_entity_key = $inv_entity_key;
        }
        
        return $this;
    }
    /**
     * Get inv_col_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_col_key(): ?string
    {
        return $this->inv_col_key ?? null;
    }
    /**
     * Set inv_col_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_col_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_col_key(?string $inv_col_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_col_key) && !is_string($inv_col_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_col_key, true), gettype($inv_col_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_col_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_col_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_col_key, true)), __LINE__);
        }
        if (is_null($inv_col_key) || (is_array($inv_col_key) && empty($inv_col_key))) {
            unset($this->inv_col_key);
        } else {
            $this->inv_col_key = $inv_col_key;
        }
        
        return $this;
    }
    /**
     * Get inv_cst_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cst_billing_key(): ?string
    {
        return $this->inv_cst_billing_key ?? null;
    }
    /**
     * Set inv_cst_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cst_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_cst_billing_key(?string $inv_cst_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cst_billing_key) && !is_string($inv_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cst_billing_key, true), gettype($inv_cst_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cst_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cst_billing_key, true)), __LINE__);
        }
        if (is_null($inv_cst_billing_key) || (is_array($inv_cst_billing_key) && empty($inv_cst_billing_key))) {
            unset($this->inv_cst_billing_key);
        } else {
            $this->inv_cst_billing_key = $inv_cst_billing_key;
        }
        
        return $this;
    }
    /**
     * Get inv_ind_cst_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_ind_cst_billing_key(): ?string
    {
        return $this->inv_ind_cst_billing_key ?? null;
    }
    /**
     * Set inv_ind_cst_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_ind_cst_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_ind_cst_billing_key(?string $inv_ind_cst_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_ind_cst_billing_key) && !is_string($inv_ind_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_ind_cst_billing_key, true), gettype($inv_ind_cst_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_ind_cst_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_ind_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_ind_cst_billing_key, true)), __LINE__);
        }
        if (is_null($inv_ind_cst_billing_key) || (is_array($inv_ind_cst_billing_key) && empty($inv_ind_cst_billing_key))) {
            unset($this->inv_ind_cst_billing_key);
        } else {
            $this->inv_ind_cst_billing_key = $inv_ind_cst_billing_key;
        }
        
        return $this;
    }
    /**
     * Get inv_ord_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_ord_key(): ?string
    {
        return $this->inv_ord_key ?? null;
    }
    /**
     * Set inv_ord_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_ord_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_ord_key(?string $inv_ord_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_ord_key) && !is_string($inv_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_ord_key, true), gettype($inv_ord_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_ord_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_ord_key, true)), __LINE__);
        }
        if (is_null($inv_ord_key) || (is_array($inv_ord_key) && empty($inv_ord_key))) {
            unset($this->inv_ord_key);
        } else {
            $this->inv_ord_key = $inv_ord_key;
        }
        
        return $this;
    }
    /**
     * Get inv_tracking_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_tracking_number(): ?string
    {
        return $this->inv_tracking_number ?? null;
    }
    /**
     * Set inv_tracking_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_tracking_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_tracking_number(?string $inv_tracking_number = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_tracking_number) && !is_string($inv_tracking_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_tracking_number, true), gettype($inv_tracking_number)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($inv_tracking_number) && mb_strlen((string) $inv_tracking_number) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $inv_tracking_number)), __LINE__);
        }
        if (is_null($inv_tracking_number) || (is_array($inv_tracking_number) && empty($inv_tracking_number))) {
            unset($this->inv_tracking_number);
        } else {
            $this->inv_tracking_number = $inv_tracking_number;
        }
        
        return $this;
    }
    /**
     * Get inv_group_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_group_flag(): ?string
    {
        return $this->inv_group_flag ?? null;
    }
    /**
     * Set inv_group_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_group_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_group_flag(?string $inv_group_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_group_flag) && !is_string($inv_group_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_group_flag, true), gettype($inv_group_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($inv_group_flag) && $inv_group_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($inv_group_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inv_group_flag) && $inv_group_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inv_group_flag, true)), __LINE__);
        }
        if (is_null($inv_group_flag) || (is_array($inv_group_flag) && empty($inv_group_flag))) {
            unset($this->inv_group_flag);
        } else {
            $this->inv_group_flag = $inv_group_flag;
        }
        
        return $this;
    }
    /**
     * Get inv_group_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_group_description(): ?string
    {
        return $this->inv_group_description ?? null;
    }
    /**
     * Set inv_group_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_group_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_group_description(?string $inv_group_description = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_group_description) && !is_string($inv_group_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_group_description, true), gettype($inv_group_description)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($inv_group_description) && mb_strlen((string) $inv_group_description) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $inv_group_description)), __LINE__);
        }
        if (is_null($inv_group_description) || (is_array($inv_group_description) && empty($inv_group_description))) {
            unset($this->inv_group_description);
        } else {
            $this->inv_group_description = $inv_group_description;
        }
        
        return $this;
    }
    /**
     * Get inv_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_cur_key(): ?string
    {
        return $this->inv_cur_key ?? null;
    }
    /**
     * Set inv_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_cur_key(?string $inv_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_cur_key) && !is_string($inv_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_cur_key, true), gettype($inv_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_cur_key, true)), __LINE__);
        }
        if (is_null($inv_cur_key) || (is_array($inv_cur_key) && empty($inv_cur_key))) {
            unset($this->inv_cur_key);
        } else {
            $this->inv_cur_key = $inv_cur_key;
        }
        
        return $this;
    }
    /**
     * Get inv_allow_installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInv_allow_installments(): ?bool
    {
        return $this->inv_allow_installments ?? null;
    }
    /**
     * Set inv_allow_installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inv_allow_installments
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_allow_installments(?bool $inv_allow_installments = null): self
    {
        // validation for constraint: boolean
        if (!is_null($inv_allow_installments) && !is_bool($inv_allow_installments)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inv_allow_installments, true), gettype($inv_allow_installments)), __LINE__);
        }
        // validation for constraint: pattern([0-1])
        if (!is_null($inv_allow_installments) && !preg_match('/[0-1]/', (string) $inv_allow_installments)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-1]/', var_export($inv_allow_installments, true)), __LINE__);
        }
        if (is_null($inv_allow_installments) || (is_array($inv_allow_installments) && empty($inv_allow_installments))) {
            unset($this->inv_allow_installments);
        } else {
            $this->inv_allow_installments = $inv_allow_installments;
        }
        
        return $this;
    }
    /**
     * Get inv_sfo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_sfo_key(): ?string
    {
        return $this->inv_sfo_key ?? null;
    }
    /**
     * Set inv_sfo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_sfo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_sfo_key(?string $inv_sfo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_sfo_key) && !is_string($inv_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_sfo_key, true), gettype($inv_sfo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_sfo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_sfo_key, true)), __LINE__);
        }
        if (is_null($inv_sfo_key) || (is_array($inv_sfo_key) && empty($inv_sfo_key))) {
            unset($this->inv_sfo_key);
        } else {
            $this->inv_sfo_key = $inv_sfo_key;
        }
        
        return $this;
    }
    /**
     * Get inv_pbs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_pbs_key(): ?string
    {
        return $this->inv_pbs_key ?? null;
    }
    /**
     * Set inv_pbs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_pbs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_pbs_key(?string $inv_pbs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_pbs_key) && !is_string($inv_pbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_pbs_key, true), gettype($inv_pbs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_pbs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_pbs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_pbs_key, true)), __LINE__);
        }
        if (is_null($inv_pbs_key) || (is_array($inv_pbs_key) && empty($inv_pbs_key))) {
            unset($this->inv_pbs_key);
        } else {
            $this->inv_pbs_key = $inv_pbs_key;
        }
        
        return $this;
    }
    /**
     * Get inv_NewBatch_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_NewBatch_key(): ?string
    {
        return $this->inv_NewBatch_key ?? null;
    }
    /**
     * Set inv_NewBatch_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_NewBatch_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_NewBatch_key(?string $inv_NewBatch_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_NewBatch_key) && !is_string($inv_NewBatch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_NewBatch_key, true), gettype($inv_NewBatch_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_NewBatch_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_NewBatch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_NewBatch_key, true)), __LINE__);
        }
        if (is_null($inv_NewBatch_key) || (is_array($inv_NewBatch_key) && empty($inv_NewBatch_key))) {
            unset($this->inv_NewBatch_key);
        } else {
            $this->inv_NewBatch_key = $inv_NewBatch_key;
        }
        
        return $this;
    }
    /**
     * Get inv_pay_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInv_pay_cst_key(): ?string
    {
        return $this->inv_pay_cst_key ?? null;
    }
    /**
     * Set inv_pay_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inv_pay_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_DataObjectType
     */
    public function setInv_pay_cst_key(?string $inv_pay_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($inv_pay_cst_key) && !is_string($inv_pay_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_pay_cst_key, true), gettype($inv_pay_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($inv_pay_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $inv_pay_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($inv_pay_cst_key, true)), __LINE__);
        }
        if (is_null($inv_pay_cst_key) || (is_array($inv_pay_cst_key) && empty($inv_pay_cst_key))) {
            unset($this->inv_pay_cst_key);
        } else {
            $this->inv_pay_cst_key = $inv_pay_cst_key;
        }
        
        return $this;
    }
}
