<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Invoice_Detail_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Invoice_Detail_DataObjectType extends AbstractStructBase
{
    /**
     * The ivd_price_previous
     * Meta information extracted from the WSDL
     * - documentation: Previous Price.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and
     * is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_price_previous = null;
    /**
     * The ivd_qty_previous
     * Meta information extracted from the WSDL
     * - documentation: Previous Quantity.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field
     * and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_qty_previous = null;
    /**
     * The ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_key = null;
    /**
     * The ivd_inv_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_inv_key = null;
    /**
     * The ivd_price
     * Meta information extracted from the WSDL
     * - documentation: Sale Price. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_price = null;
    /**
     * The ivd_qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity Sold. This field has this Input Mask: 999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_qty = null;
    /**
     * The ivd_approve_date
     * Meta information extracted from the WSDL
     * - documentation: Date Approved. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_approve_date = null;
    /**
     * The ivd_approve_user
     * Meta information extracted from the WSDL
     * - documentation: Approved By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_approve_user = null;
    /**
     * The ivd_void_date
     * Meta information extracted from the WSDL
     * - documentation: Date Voided. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_void_date = null;
    /**
     * The ivd_void_user
     * Meta information extracted from the WSDL
     * - documentation: Voided By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_void_user = null;
    /**
     * The ivd_ajd_key
     * Meta information extracted from the WSDL
     * - documentation: Adjustment. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ajd_key = null;
    /**
     * The ivd_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_add_user = null;
    /**
     * The ivd_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_add_date = null;
    /**
     * The ivd_backorder_flag
     * Meta information extracted from the WSDL
     * - documentation: Backorder?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_backorder_flag = null;
    /**
     * The ivd_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_change_user = null;
    /**
     * The ivd_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_change_date = null;
    /**
     * The ivd_inventory_held_qty
     * Meta information extracted from the WSDL
     * - documentation: Inventory Held Quantity. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_inventory_held_qty = null;
    /**
     * The ivd_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_delete_flag = null;
    /**
     * The ivd_ship_qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity Shipped. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_ship_qty = null;
    /**
     * The ivd_ship_flag_cp
     * Meta information extracted from the WSDL
     * - documentation: Shipped. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_ship_flag_cp = null;
    /**
     * The ivd_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_key_ext = null;
    /**
     * The ivd_close_flag
     * Meta information extracted from the WSDL
     * - documentation: Closed?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_close_flag = null;
    /**
     * The ivd_approve_flag
     * Meta information extracted from the WSDL
     * - documentation: Approved?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_approve_flag = null;
    /**
     * The ivd_void_flag
     * Meta information extracted from the WSDL
     * - documentation: Void?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_void_flag = null;
    /**
     * The ivd_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Price. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_prc_key = null;
    /**
     * The ivd_prc_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Product. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_prc_prd_key = null;
    /**
     * The ivd_amount_cp
     * Meta information extracted from the WSDL
     * - documentation: Amount. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_amount_cp = null;
    /**
     * The ivd_parity
     * Meta information extracted from the WSDL
     * - documentation: Parity Flag.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_parity = null;
    /**
     * The ivd_parity_amount_cp
     * Meta information extracted from the WSDL
     * - documentation: Parity Amount. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_parity_amount_cp = null;
    /**
     * The ivd_gla_dr_key
     * Meta information extracted from the WSDL
     * - documentation: Debit Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_gla_dr_key = null;
    /**
     * The ivd_gla_cr_key
     * Meta information extracted from the WSDL
     * - documentation: Credit Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_gla_cr_key = null;
    /**
     * The ivd_notes
     * Meta information extracted from the WSDL
     * - documentation: Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_notes = null;
    /**
     * The ivd_cst_ship_key
     * Meta information extracted from the WSDL
     * - documentation: Ship To Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cst_ship_key = null;
    /**
     * The ivd_prc_prd_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_prc_prd_ptp_key = null;
    /**
     * The ivd_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Ship To Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cxa_key = null;
    /**
     * The ivd_src_key
     * Meta information extracted from the WSDL
     * - documentation: source code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_src_key = null;
    /**
     * The ivd_type
     * Meta information extracted from the WSDL
     * - documentation: Line Item Type.This element has a default value of 'Product'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_type = null;
    /**
     * The ivd_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_entity_key = null;
    /**
     * The ivd_ivw_key
     * Meta information extracted from the WSDL
     * - documentation: Warehouse Inventory. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ivw_key = null;
    /**
     * The ivd_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_odd_key = null;
    /**
     * The ivd_do_not_fulfill
     * Meta information extracted from the WSDL
     * - documentation: Do Not Fulfill. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_do_not_fulfill = null;
    /**
     * The ivd_pak_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Package. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_pak_prd_key = null;
    /**
     * The ivd_ods_key
     * Meta information extracted from the WSDL
     * - documentation: installment schedule. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ods_key = null;
    /**
     * The ivd_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cst_key = null;
    /**
     * The ivd_account_number
     * Meta information extracted from the WSDL
     * - documentation: account number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_account_number = null;
    /**
     * The ivd_ovr_key
     * Meta information extracted from the WSDL
     * - documentation: Price Override Reason. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ovr_key = null;
    /**
     * The ivd_price_override_reason
     * Meta information extracted from the WSDL
     * - documentation: Price Override Reason Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_price_override_reason = null;
    /**
     * The ivd_pjt_key
     * Meta information extracted from the WSDL
     * - documentation: Project. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_pjt_key = null;
    /**
     * The ivd_backorder_email_sent_flag
     * Meta information extracted from the WSDL
     * - documentation: Backorder email sent. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_backorder_email_sent_flag = null;
    /**
     * The ivd_process_qty
     * Meta information extracted from the WSDL
     * - documentation: Process Qty. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_process_qty = null;
    /**
     * The ivd_bun_prd_key
     * Meta information extracted from the WSDL
     * - documentation: Bundle. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_bun_prd_key = null;
    /**
     * The ivd_download_count
     * Meta information extracted from the WSDL
     * - documentation: Download Count. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_download_count = null;
    /**
     * The ivd_eml_key
     * Meta information extracted from the WSDL
     * - documentation: Email Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_eml_key = null;
    /**
     * The ivd_package_grouping_key
     * Meta information extracted from the WSDL
     * - documentation: Package Grouping Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_package_grouping_key = null;
    /**
     * The ivd_cdd_key
     * Meta information extracted from the WSDL
     * - documentation: Gift Card Credit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cdd_key = null;
    /**
     * The ivd_download_limit_override
     * Meta information extracted from the WSDL
     * - documentation: Download Limit Override. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_download_limit_override = null;
    /**
     * The ivd_discount_program_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Discount Program Applied. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_discount_program_ivd_key = null;
    /**
     * The ivd_distributed_liability_flag
     * Meta information extracted from the WSDL
     * - documentation: Distributed Liability Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_distributed_liability_flag = null;
    /**
     * The ivd_download_days_override
     * Meta information extracted from the WSDL
     * - documentation: Download Days Override. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_download_days_override = null;
    /**
     * The ivd_gc_number
     * Meta information extracted from the WSDL
     * - documentation: Gift Card Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_gc_number = null;
    /**
     * The ivd_cdt_key
     * Meta information extracted from the WSDL
     * - documentation: Redemption. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_cdt_key = null;
    /**
     * The ivd_pro_key
     * Meta information extracted from the WSDL
     * - documentation: ivd_pro_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_pro_key = null;
    /**
     * The ivd_available_for_cancel
     * Meta information extracted from the WSDL
     * - documentation: Available for Cancel.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_available_for_cancel = null;
    /**
     * The ivd_available_for_return
     * Meta information extracted from the WSDL
     * - documentation: Available for Return.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_available_for_return = null;
    /**
     * The ivd_balance_quantity
     * Meta information extracted from the WSDL
     * - documentation: Balance Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_balance_quantity = null;
    /**
     * The ivd_amount_due
     * Meta information extracted from the WSDL
     * - documentation: Amount due. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_amount_due = null;
    /**
     * The ivd_automatically_added
     * Meta information extracted from the WSDL
     * - documentation: automatically added.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_automatically_added = null;
    /**
     * The ivd_createorder_flag
     * Meta information extracted from the WSDL
     * - documentation: Create Order?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_createorder_flag = null;
    /**
     * The ivd_deferral_total_returned
     * Meta information extracted from the WSDL
     * - documentation: Deferral Total Returned. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_deferral_total_returned = null;
    /**
     * The ivd_lineamount
     * Meta information extracted from the WSDL
     * - documentation: Line Amount. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_lineamount = null;
    /**
     * The ivd_lineamount_no_discount
     * Meta information extracted from the WSDL
     * - documentation: Line Amount. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_lineamount_no_discount = null;
    /**
     * The ivd_originallineamount
     * Meta information extracted from the WSDL
     * - documentation: Original Line Amount. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_originallineamount = null;
    /**
     * The ivd_restock_fee_calculated
     * Meta information extracted from the WSDL
     * - documentation: Restock fee calculated. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_restock_fee_calculated = null;
    /**
     * The ivd_createinvoice_flag
     * Meta information extracted from the WSDL
     * - documentation: Create Invoice?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_createinvoice_flag = null;
    /**
     * The ivd_linebalance
     * Meta information extracted from the WSDL
     * - documentation: Line Balance. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_linebalance = null;
    /**
     * The ivd_net_amount_due
     * Meta information extracted from the WSDL
     * - documentation: Net Amount due. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_net_amount_due = null;
    /**
     * The ivd_payamount
     * Meta information extracted from the WSDL
     * - documentation: PaymentAmount. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_payamount = null;
    /**
     * The ivd_payamount_noreturn
     * Meta information extracted from the WSDL
     * - documentation: PaymentAmountNoReturn. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_payamount_noreturn = null;
    /**
     * The ivd_cancelled_quantity
     * Meta information extracted from the WSDL
     * - documentation: Cancelled Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_cancelled_quantity = null;
    /**
     * The ivd_default_credit_dollar_amount
     * Meta information extracted from the WSDL
     * - documentation: Default Credit Dollar Amount for Deferral.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_default_credit_dollar_amount = null;
    /**
     * The ivd_deferral_number_periods
     * Meta information extracted from the WSDL
     * - documentation: ivd_deferral_number_periods.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_deferral_number_periods = null;
    /**
     * The ivd_deferral_number_periods_recognized
     * Meta information extracted from the WSDL
     * - documentation: ivd_deferral_number_periods_recognized.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_deferral_number_periods_recognized = null;
    /**
     * The ivd_deferral_price
     * Meta information extracted from the WSDL
     * - documentation: ivd_deferral_price.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_deferral_price = null;
    /**
     * The ivd_DeferralBalance
     * Meta information extracted from the WSDL
     * - documentation: Deferral Balance.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_DeferralBalance = null;
    /**
     * The ivd_minimum_quantity
     * Meta information extracted from the WSDL
     * - documentation: Minimum Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_minimum_quantity = null;
    /**
     * The ivd_reduce_quantity
     * Meta information extracted from the WSDL
     * - documentation: Reduce Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_reduce_quantity = null;
    /**
     * The ivd_return_quantity
     * Meta information extracted from the WSDL
     * - documentation: Return Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_return_quantity = null;
    /**
     * The ivd_returned_quantity
     * Meta information extracted from the WSDL
     * - documentation: Returned Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_returned_quantity = null;
    /**
     * The ivd_total_recognized
     * Meta information extracted from the WSDL
     * - documentation: Total Recognized.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_total_recognized = null;
    /**
     * The ivd_writeoff_dollar_amount
     * Meta information extracted from the WSDL
     * - documentation: Writeoff Dollar Amount.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_writeoff_dollar_amount = null;
    /**
     * The ivd_allow_change_qty_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow Change Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_allow_change_qty_flag = null;
    /**
     * The ivd_credit_dollar_amount
     * Meta information extracted from the WSDL
     * - documentation: Credit Dollar Amount for Deferral.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_credit_dollar_amount = null;
    /**
     * The ivd_pkg_optional
     * Meta information extracted from the WSDL
     * - documentation: ivd_pkg_optional.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_pkg_optional = null;
    /**
     * The ivd_allow_change_price_flag
     * Meta information extracted from the WSDL
     * - documentation: Allow Change Price.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_allow_change_price_flag = null;
    /**
     * The ivd_cancel_quantity
     * Meta information extracted from the WSDL
     * - documentation: Cancel Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_cancel_quantity = null;
    /**
     * The ivd_auto_refund
     * Meta information extracted from the WSDL
     * - documentation: Auto Refund.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_auto_refund = null;
    /**
     * The ivd_NewBatch_key
     * Meta information extracted from the WSDL
     * - documentation: ivd_NewBatch_key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_NewBatch_key = null;
    /**
     * The ivd_refund_credit_account
     * Meta information extracted from the WSDL
     * - documentation: Refund Credit Account.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_refund_credit_account = null;
    /**
     * The ivd_ship_atc_key
     * Meta information extracted from the WSDL
     * - documentation: atc_key to retrieve Shipping.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_ship_atc_key = null;
    /**
     * The ivd_writeoff_deferral
     * Meta information extracted from the WSDL
     * - documentation: Writeoff Unpaid Recognized Deferral Amount?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_writeoff_deferral = null;
    /**
     * The ivd_claim_quantity
     * Meta information extracted from the WSDL
     * - documentation: Claim Quantity.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_claim_quantity = null;
    /**
     * The ivd_disable_quantity
     * Meta information extracted from the WSDL
     * - documentation: Disable Quantity.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_disable_quantity = null;
    /**
     * The ivd_claimed_quantity
     * Meta information extracted from the WSDL
     * - documentation: Claimed Quantity.This element has a default value of '0'. This field has this Input Mask: 999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $ivd_claimed_quantity = null;
    /**
     * The ivd_claim_flag
     * Meta information extracted from the WSDL
     * - documentation: Claim?.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_claim_flag = null;
    /**
     * The ivd_subtotal
     * Meta information extracted from the WSDL
     * - documentation: Sub-Total. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_subtotal = null;
    /**
     * The ivd_discountamount
     * Meta information extracted from the WSDL
     * - documentation: Discount Amount. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_discountamount = null;
    /**
     * The ivd_total
     * Meta information extracted from the WSDL
     * - documentation: Total. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_total = null;
    /**
     * The ivd_unit_price_with_discount
     * Meta information extracted from the WSDL
     * - documentation: Price with Discount.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_unit_price_with_discount = null;
    /**
     * The ivd_applied_payment
     * Meta information extracted from the WSDL
     * - documentation: Applied Payment. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_applied_payment = null;
    /**
     * The ivd_applied_credit
     * Meta information extracted from the WSDL
     * - documentation: Applied Credit. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_applied_credit = null;
    /**
     * The ivd_write_off
     * Meta information extracted from the WSDL
     * - documentation: Applied Write-Off. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_write_off = null;
    /**
     * The ivd_return_payment
     * Meta information extracted from the WSDL
     * - documentation: Applied Return Payment. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_return_payment = null;
    /**
     * The ivd_total_payment
     * Meta information extracted from the WSDL
     * - documentation: Total Payment. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_total_payment = null;
    /**
     * The ivd_balance
     * Meta information extracted from the WSDL
     * - documentation: Balance. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_balance = null;
    /**
     * The ivd_tax
     * Meta information extracted from the WSDL
     * - documentation: Tax. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_tax = null;
    /**
     * The ivd_shipping
     * Meta information extracted from the WSDL
     * - documentation: Shipping. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_shipping = null;
    /**
     * The ivd_nettotal
     * Meta information extracted from the WSDL
     * - documentation: Net Total. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_nettotal = null;
    /**
     * The ivd_netpayment
     * Meta information extracted from the WSDL
     * - documentation: Net Payment. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_netpayment = null;
    /**
     * The ivd_payment_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Payment to Apply. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_payment_to_apply = null;
    /**
     * The ivd_credit_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Credit to apply. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_credit_to_apply = null;
    /**
     * The ivd_netcredit
     * Meta information extracted from the WSDL
     * - documentation: Net Credit. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_netcredit = null;
    /**
     * The ivd_netwriteoff
     * Meta information extracted from the WSDL
     * - documentation: Net Write-Off. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_netwriteoff = null;
    /**
     * The ivd_writeoff_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Write-Off to apply. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_writeoff_to_apply = null;
    /**
     * The ivd_netreturn
     * Meta information extracted from the WSDL
     * - documentation: Net Return. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_netreturn = null;
    /**
     * The ivd_return_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Return to apply. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_return_to_apply = null;
    /**
     * The ivd_netapplied
     * Meta information extracted from the WSDL
     * - documentation: Net Applied. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_netapplied = null;
    /**
     * The ivd_previous_netpayment
     * Meta information extracted from the WSDL
     * - documentation: Previous Net Payment. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_previous_netpayment = null;
    /**
     * The ivd_total_to_apply
     * Meta information extracted from the WSDL
     * - documentation: Total to apply. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_total_to_apply = null;
    /**
     * The ivd_netbalance
     * Meta information extracted from the WSDL
     * - documentation: Net-Balance. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_netbalance = null;
    /**
     * The ivd_netunpaidbalance
     * Meta information extracted from the WSDL
     * - documentation: Net Unpaid Balance. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_netunpaidbalance = null;
    /**
     * The ivd_price_aggregated
     * Meta information extracted from the WSDL
     * - documentation: Aggregated Price. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_price_aggregated = null;
    /**
     * The ivd_discountamount_aggregated
     * Meta information extracted from the WSDL
     * - documentation: Aggregated Discount Amount. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_discountamount_aggregated = null;
    /**
     * The ivd_tax_aggregated
     * Meta information extracted from the WSDL
     * - documentation: Aggregated Tax. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_tax_aggregated = null;
    /**
     * The ivd_shipping_aggregated
     * Meta information extracted from the WSDL
     * - documentation: Aggregated Shipping. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_shipping_aggregated = null;
    /**
     * The ivd_nettotal_aggregated
     * Meta information extracted from the WSDL
     * - documentation: Aggregated Net Total. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_nettotal_aggregated = null;
    /**
     * The ivd_netunpaidbalance_aggregated
     * Meta information extracted from the WSDL
     * - documentation: Aggregated Net Unpaid Balance. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_netunpaidbalance_aggregated = null;
    /**
     * The ivd_subtotal_aggregated
     * Meta information extracted from the WSDL
     * - documentation: Aggregated Sub-Total. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_subtotal_aggregated = null;
    /**
     * The ivd_shippable_flag_aggregated
     * Meta information extracted from the WSDL
     * - documentation: Shippable?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_shippable_flag_aggregated = null;
    /**
     * The ivd_partof_groupreg_discount
     * Meta information extracted from the WSDL
     * - documentation: Part Of Group Reg Discount.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_partof_groupreg_discount = null;
    /**
     * The ivd_booth_number
     * Meta information extracted from the WSDL
     * - documentation: Booth Number.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_booth_number = null;
    /**
     * The ivd_cst_credit_available
     * Meta information extracted from the WSDL
     * - documentation: Sold-To Customer Credit Available.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_cst_credit_available = null;
    /**
     * The ivd_reload_ivd_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Reload Invoice Details.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_reload_ivd_cxa_key = null;
    /**
     * The ivd_MulticurrencyKey
     * Meta information extracted from the WSDL
     * - documentation: Multicurrency Record Key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_MulticurrencyKey = null;
    /**
     * The ivd_pricingcontrol_date
     * Meta information extracted from the WSDL
     * - documentation: Pricing Control:Date.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_pricingcontrol_date = null;
    /**
     * The ivd_pricingcontrol_rgt_key
     * Meta information extracted from the WSDL
     * - documentation: Pricing Control:Registrant Type Key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_pricingcontrol_rgt_key = null;
    /**
     * The ivd_term_based
     * Meta information extracted from the WSDL
     * - documentation: Term Based?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_term_based = null;
    /**
     * The ivd_term_calendar
     * Meta information extracted from the WSDL
     * - documentation: Calendar Based?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_term_calendar = null;
    /**
     * The ivd_TransactionCurrencyKey
     * Meta information extracted from the WSDL
     * - documentation: Transaction Currency Key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_TransactionCurrencyKey = null;
    /**
     * The ivd_HomeCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Home Currency Code.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_HomeCurrencyCode = null;
    /**
     * The ivd_sub_prorated_flag
     * Meta information extracted from the WSDL
     * - documentation: Sub Prorated Flag.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_sub_prorated_flag = null;
    /**
     * The ivd_autoapply
     * Meta information extracted from the WSDL
     * - documentation: Auto Distribute Payment.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_autoapply = null;
    /**
     * The ivd_cancel_flag
     * Meta information extracted from the WSDL
     * - documentation: Cancel?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_cancel_flag = null;
    /**
     * The ivd_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Line Item that the Discount, Tax or Shipping applies to. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_ivd_key = null;
    /**
     * The ivd_is_agency_sub
     * Meta information extracted from the WSDL
     * - documentation: Agency Subscription.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_is_agency_sub = null;
    /**
     * The ivd_formdetailkey
     * Meta information extracted from the WSDL
     * - documentation: Form Detail Key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_formdetailkey = null;
    /**
     * The ivd_formkey
     * Meta information extracted from the WSDL
     * - documentation: Form Key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_formkey = null;
    /**
     * The ivd_parentdataobject
     * Meta information extracted from the WSDL
     * - documentation: Form Object.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_parentdataobject = null;
    /**
     * The ivd_reg_key
     * Meta information extracted from the WSDL
     * - documentation: Reg Key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ivd_reg_key = null;
    /**
     * The ivd_addl_info
     * Meta information extracted from the WSDL
     * - documentation: Addl info. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_addl_info = null;
    /**
     * The ivd_shippable_flag
     * Meta information extracted from the WSDL
     * - documentation: Shippable?.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd_shippable_flag = null;
    /**
     * The ivd_ods_number
     * Meta information extracted from the WSDL
     * - documentation: Installment Number.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ivd_ods_number = null;
    /**
     * The ivd_credit_to_distribute
     * Meta information extracted from the WSDL
     * - documentation: Credit to Distribute. This field has this Input Mask: $999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_credit_to_distribute = null;
    /**
     * The ivd_inv_shippable_total
     * Meta information extracted from the WSDL
     * - documentation: Invoice Total. This field has this Input Mask: 999,999,999.99.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_inv_shippable_total = null;
    /**
     * The ivd_inv_distributable_credit_total
     * Meta information extracted from the WSDL
     * - documentation: Distributable Credit Total.This element has a default value of '0'. This field is automatically calculated within netForum and cannot be updated via netForum xWeb.This field is NOT a Data Field and is Read-Only. | Avectra netForum
     * defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ivd_inv_distributable_credit_total = null;
    /**
     * The ivd__agy
     * Meta information extracted from the WSDL
     * - documentation: Request param agy.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ivd__agy = null;
    /**
     * Constructor method for InvoiceDetail_Invoice_Detail_DataObjectType
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_price_previous()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_qty_previous()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_inv_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_price()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_qty()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_approve_date()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_approve_user()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_void_date()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_void_user()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_ajd_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_add_user()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_add_date()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_backorder_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_change_user()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_change_date()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_inventory_held_qty()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_delete_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_ship_qty()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_ship_flag_cp()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_key_ext()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_close_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_approve_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_void_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_prc_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_prc_prd_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_amount_cp()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_parity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_parity_amount_cp()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_gla_dr_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_gla_cr_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_notes()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_cst_ship_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_prc_prd_ptp_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_cxa_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_src_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_type()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_entity_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_ivw_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_odd_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_do_not_fulfill()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_pak_prd_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_ods_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_cst_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_account_number()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_ovr_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_price_override_reason()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_pjt_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_backorder_email_sent_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_process_qty()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_bun_prd_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_download_count()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_eml_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_package_grouping_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_cdd_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_download_limit_override()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_discount_program_ivd_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_distributed_liability_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_download_days_override()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_gc_number()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_cdt_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_pro_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_available_for_cancel()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_available_for_return()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_balance_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_amount_due()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_automatically_added()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_createorder_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_deferral_total_returned()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_lineamount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_lineamount_no_discount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_originallineamount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_restock_fee_calculated()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_createinvoice_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_linebalance()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_net_amount_due()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_payamount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_payamount_noreturn()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_cancelled_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_default_credit_dollar_amount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_deferral_number_periods()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_deferral_number_periods_recognized()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_deferral_price()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_DeferralBalance()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_minimum_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_reduce_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_return_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_returned_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_total_recognized()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_writeoff_dollar_amount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_allow_change_qty_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_credit_dollar_amount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_pkg_optional()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_allow_change_price_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_cancel_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_auto_refund()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_NewBatch_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_refund_credit_account()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_ship_atc_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_writeoff_deferral()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_claim_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_disable_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_claimed_quantity()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_claim_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_subtotal()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_discountamount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_total()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_unit_price_with_discount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_applied_payment()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_applied_credit()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_write_off()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_return_payment()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_total_payment()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_balance()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_tax()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_shipping()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_nettotal()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_netpayment()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_payment_to_apply()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_credit_to_apply()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_netcredit()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_netwriteoff()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_writeoff_to_apply()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_netreturn()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_return_to_apply()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_netapplied()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_previous_netpayment()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_total_to_apply()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_netbalance()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_netunpaidbalance()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_price_aggregated()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_discountamount_aggregated()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_tax_aggregated()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_shipping_aggregated()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_nettotal_aggregated()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_netunpaidbalance_aggregated()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_subtotal_aggregated()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_shippable_flag_aggregated()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_partof_groupreg_discount()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_booth_number()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_cst_credit_available()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_reload_ivd_cxa_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_MulticurrencyKey()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_pricingcontrol_date()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_pricingcontrol_rgt_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_term_based()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_term_calendar()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_TransactionCurrencyKey()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_HomeCurrencyCode()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_sub_prorated_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_autoapply()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_cancel_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_ivd_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_is_agency_sub()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_formdetailkey()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_formkey()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_parentdataobject()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_reg_key()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_addl_info()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_shippable_flag()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_ods_number()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_credit_to_distribute()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_inv_shippable_total()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd_inv_distributable_credit_total()
     * @uses InvoiceDetail_Invoice_Detail_DataObjectType::setIvd__agy()
     * @param float $ivd_price_previous
     * @param float $ivd_qty_previous
     * @param string $ivd_key
     * @param string $ivd_inv_key
     * @param float $ivd_price
     * @param float $ivd_qty
     * @param string $ivd_approve_date
     * @param string $ivd_approve_user
     * @param string $ivd_void_date
     * @param string $ivd_void_user
     * @param string $ivd_ajd_key
     * @param string $ivd_add_user
     * @param string $ivd_add_date
     * @param string $ivd_backorder_flag
     * @param string $ivd_change_user
     * @param string $ivd_change_date
     * @param float $ivd_inventory_held_qty
     * @param string $ivd_delete_flag
     * @param float $ivd_ship_qty
     * @param int $ivd_ship_flag_cp
     * @param string $ivd_key_ext
     * @param string $ivd_close_flag
     * @param string $ivd_approve_flag
     * @param string $ivd_void_flag
     * @param string $ivd_prc_key
     * @param string $ivd_prc_prd_key
     * @param float $ivd_amount_cp
     * @param int $ivd_parity
     * @param float $ivd_parity_amount_cp
     * @param string $ivd_gla_dr_key
     * @param string $ivd_gla_cr_key
     * @param string $ivd_notes
     * @param string $ivd_cst_ship_key
     * @param string $ivd_prc_prd_ptp_key
     * @param string $ivd_cxa_key
     * @param string $ivd_src_key
     * @param string $ivd_type
     * @param string $ivd_entity_key
     * @param string $ivd_ivw_key
     * @param string $ivd_odd_key
     * @param string $ivd_do_not_fulfill
     * @param string $ivd_pak_prd_key
     * @param string $ivd_ods_key
     * @param string $ivd_cst_key
     * @param string $ivd_account_number
     * @param string $ivd_ovr_key
     * @param string $ivd_price_override_reason
     * @param string $ivd_pjt_key
     * @param string $ivd_backorder_email_sent_flag
     * @param float $ivd_process_qty
     * @param string $ivd_bun_prd_key
     * @param int $ivd_download_count
     * @param string $ivd_eml_key
     * @param string $ivd_package_grouping_key
     * @param string $ivd_cdd_key
     * @param int $ivd_download_limit_override
     * @param string $ivd_discount_program_ivd_key
     * @param string $ivd_distributed_liability_flag
     * @param int $ivd_download_days_override
     * @param string $ivd_gc_number
     * @param string $ivd_cdt_key
     * @param string $ivd_pro_key
     * @param float $ivd_available_for_cancel
     * @param float $ivd_available_for_return
     * @param float $ivd_balance_quantity
     * @param float $ivd_amount_due
     * @param string $ivd_automatically_added
     * @param string $ivd_createorder_flag
     * @param float $ivd_deferral_total_returned
     * @param float $ivd_lineamount
     * @param float $ivd_lineamount_no_discount
     * @param float $ivd_originallineamount
     * @param float $ivd_restock_fee_calculated
     * @param string $ivd_createinvoice_flag
     * @param float $ivd_linebalance
     * @param float $ivd_net_amount_due
     * @param float $ivd_payamount
     * @param float $ivd_payamount_noreturn
     * @param float $ivd_cancelled_quantity
     * @param float $ivd_default_credit_dollar_amount
     * @param float $ivd_deferral_number_periods
     * @param float $ivd_deferral_number_periods_recognized
     * @param float $ivd_deferral_price
     * @param float $ivd_DeferralBalance
     * @param float $ivd_minimum_quantity
     * @param float $ivd_reduce_quantity
     * @param float $ivd_return_quantity
     * @param float $ivd_returned_quantity
     * @param float $ivd_total_recognized
     * @param float $ivd_writeoff_dollar_amount
     * @param string $ivd_allow_change_qty_flag
     * @param float $ivd_credit_dollar_amount
     * @param string $ivd_pkg_optional
     * @param string $ivd_allow_change_price_flag
     * @param float $ivd_cancel_quantity
     * @param string $ivd_auto_refund
     * @param string $ivd_NewBatch_key
     * @param string $ivd_refund_credit_account
     * @param string $ivd_ship_atc_key
     * @param string $ivd_writeoff_deferral
     * @param float $ivd_claim_quantity
     * @param string $ivd_disable_quantity
     * @param float $ivd_claimed_quantity
     * @param string $ivd_claim_flag
     * @param float $ivd_subtotal
     * @param float $ivd_discountamount
     * @param float $ivd_total
     * @param float $ivd_unit_price_with_discount
     * @param float $ivd_applied_payment
     * @param float $ivd_applied_credit
     * @param float $ivd_write_off
     * @param float $ivd_return_payment
     * @param float $ivd_total_payment
     * @param float $ivd_balance
     * @param float $ivd_tax
     * @param float $ivd_shipping
     * @param float $ivd_nettotal
     * @param float $ivd_netpayment
     * @param float $ivd_payment_to_apply
     * @param float $ivd_credit_to_apply
     * @param float $ivd_netcredit
     * @param float $ivd_netwriteoff
     * @param float $ivd_writeoff_to_apply
     * @param float $ivd_netreturn
     * @param float $ivd_return_to_apply
     * @param float $ivd_netapplied
     * @param float $ivd_previous_netpayment
     * @param float $ivd_total_to_apply
     * @param float $ivd_netbalance
     * @param float $ivd_netunpaidbalance
     * @param float $ivd_price_aggregated
     * @param float $ivd_discountamount_aggregated
     * @param float $ivd_tax_aggregated
     * @param float $ivd_shipping_aggregated
     * @param float $ivd_nettotal_aggregated
     * @param float $ivd_netunpaidbalance_aggregated
     * @param float $ivd_subtotal_aggregated
     * @param string $ivd_shippable_flag_aggregated
     * @param string $ivd_partof_groupreg_discount
     * @param string $ivd_booth_number
     * @param float $ivd_cst_credit_available
     * @param string $ivd_reload_ivd_cxa_key
     * @param string $ivd_MulticurrencyKey
     * @param string $ivd_pricingcontrol_date
     * @param string $ivd_pricingcontrol_rgt_key
     * @param string $ivd_term_based
     * @param string $ivd_term_calendar
     * @param string $ivd_TransactionCurrencyKey
     * @param string $ivd_HomeCurrencyCode
     * @param string $ivd_sub_prorated_flag
     * @param string $ivd_autoapply
     * @param string $ivd_cancel_flag
     * @param string $ivd_ivd_key
     * @param string $ivd_is_agency_sub
     * @param string $ivd_formdetailkey
     * @param string $ivd_formkey
     * @param string $ivd_parentdataobject
     * @param string $ivd_reg_key
     * @param string $ivd_addl_info
     * @param string $ivd_shippable_flag
     * @param int $ivd_ods_number
     * @param float $ivd_credit_to_distribute
     * @param float $ivd_inv_shippable_total
     * @param float $ivd_inv_distributable_credit_total
     * @param string $ivd__agy
     */
    public function __construct(?float $ivd_price_previous = null, ?float $ivd_qty_previous = null, ?string $ivd_key = null, ?string $ivd_inv_key = null, ?float $ivd_price = null, ?float $ivd_qty = null, ?string $ivd_approve_date = null, ?string $ivd_approve_user = null, ?string $ivd_void_date = null, ?string $ivd_void_user = null, ?string $ivd_ajd_key = null, ?string $ivd_add_user = null, ?string $ivd_add_date = null, ?string $ivd_backorder_flag = null, ?string $ivd_change_user = null, ?string $ivd_change_date = null, ?float $ivd_inventory_held_qty = null, ?string $ivd_delete_flag = null, ?float $ivd_ship_qty = null, ?int $ivd_ship_flag_cp = null, ?string $ivd_key_ext = null, ?string $ivd_close_flag = null, ?string $ivd_approve_flag = null, ?string $ivd_void_flag = null, ?string $ivd_prc_key = null, ?string $ivd_prc_prd_key = null, ?float $ivd_amount_cp = null, ?int $ivd_parity = null, ?float $ivd_parity_amount_cp = null, ?string $ivd_gla_dr_key = null, ?string $ivd_gla_cr_key = null, ?string $ivd_notes = null, ?string $ivd_cst_ship_key = null, ?string $ivd_prc_prd_ptp_key = null, ?string $ivd_cxa_key = null, ?string $ivd_src_key = null, ?string $ivd_type = null, ?string $ivd_entity_key = null, ?string $ivd_ivw_key = null, ?string $ivd_odd_key = null, ?string $ivd_do_not_fulfill = null, ?string $ivd_pak_prd_key = null, ?string $ivd_ods_key = null, ?string $ivd_cst_key = null, ?string $ivd_account_number = null, ?string $ivd_ovr_key = null, ?string $ivd_price_override_reason = null, ?string $ivd_pjt_key = null, ?string $ivd_backorder_email_sent_flag = null, ?float $ivd_process_qty = null, ?string $ivd_bun_prd_key = null, ?int $ivd_download_count = null, ?string $ivd_eml_key = null, ?string $ivd_package_grouping_key = null, ?string $ivd_cdd_key = null, ?int $ivd_download_limit_override = null, ?string $ivd_discount_program_ivd_key = null, ?string $ivd_distributed_liability_flag = null, ?int $ivd_download_days_override = null, ?string $ivd_gc_number = null, ?string $ivd_cdt_key = null, ?string $ivd_pro_key = null, ?float $ivd_available_for_cancel = null, ?float $ivd_available_for_return = null, ?float $ivd_balance_quantity = null, ?float $ivd_amount_due = null, ?string $ivd_automatically_added = null, ?string $ivd_createorder_flag = null, ?float $ivd_deferral_total_returned = null, ?float $ivd_lineamount = null, ?float $ivd_lineamount_no_discount = null, ?float $ivd_originallineamount = null, ?float $ivd_restock_fee_calculated = null, ?string $ivd_createinvoice_flag = null, ?float $ivd_linebalance = null, ?float $ivd_net_amount_due = null, ?float $ivd_payamount = null, ?float $ivd_payamount_noreturn = null, ?float $ivd_cancelled_quantity = null, ?float $ivd_default_credit_dollar_amount = null, ?float $ivd_deferral_number_periods = null, ?float $ivd_deferral_number_periods_recognized = null, ?float $ivd_deferral_price = null, ?float $ivd_DeferralBalance = null, ?float $ivd_minimum_quantity = null, ?float $ivd_reduce_quantity = null, ?float $ivd_return_quantity = null, ?float $ivd_returned_quantity = null, ?float $ivd_total_recognized = null, ?float $ivd_writeoff_dollar_amount = null, ?string $ivd_allow_change_qty_flag = null, ?float $ivd_credit_dollar_amount = null, ?string $ivd_pkg_optional = null, ?string $ivd_allow_change_price_flag = null, ?float $ivd_cancel_quantity = null, ?string $ivd_auto_refund = null, ?string $ivd_NewBatch_key = null, ?string $ivd_refund_credit_account = null, ?string $ivd_ship_atc_key = null, ?string $ivd_writeoff_deferral = null, ?float $ivd_claim_quantity = null, ?string $ivd_disable_quantity = null, ?float $ivd_claimed_quantity = null, ?string $ivd_claim_flag = null, ?float $ivd_subtotal = null, ?float $ivd_discountamount = null, ?float $ivd_total = null, ?float $ivd_unit_price_with_discount = null, ?float $ivd_applied_payment = null, ?float $ivd_applied_credit = null, ?float $ivd_write_off = null, ?float $ivd_return_payment = null, ?float $ivd_total_payment = null, ?float $ivd_balance = null, ?float $ivd_tax = null, ?float $ivd_shipping = null, ?float $ivd_nettotal = null, ?float $ivd_netpayment = null, ?float $ivd_payment_to_apply = null, ?float $ivd_credit_to_apply = null, ?float $ivd_netcredit = null, ?float $ivd_netwriteoff = null, ?float $ivd_writeoff_to_apply = null, ?float $ivd_netreturn = null, ?float $ivd_return_to_apply = null, ?float $ivd_netapplied = null, ?float $ivd_previous_netpayment = null, ?float $ivd_total_to_apply = null, ?float $ivd_netbalance = null, ?float $ivd_netunpaidbalance = null, ?float $ivd_price_aggregated = null, ?float $ivd_discountamount_aggregated = null, ?float $ivd_tax_aggregated = null, ?float $ivd_shipping_aggregated = null, ?float $ivd_nettotal_aggregated = null, ?float $ivd_netunpaidbalance_aggregated = null, ?float $ivd_subtotal_aggregated = null, ?string $ivd_shippable_flag_aggregated = null, ?string $ivd_partof_groupreg_discount = null, ?string $ivd_booth_number = null, ?float $ivd_cst_credit_available = null, ?string $ivd_reload_ivd_cxa_key = null, ?string $ivd_MulticurrencyKey = null, ?string $ivd_pricingcontrol_date = null, ?string $ivd_pricingcontrol_rgt_key = null, ?string $ivd_term_based = null, ?string $ivd_term_calendar = null, ?string $ivd_TransactionCurrencyKey = null, ?string $ivd_HomeCurrencyCode = null, ?string $ivd_sub_prorated_flag = null, ?string $ivd_autoapply = null, ?string $ivd_cancel_flag = null, ?string $ivd_ivd_key = null, ?string $ivd_is_agency_sub = null, ?string $ivd_formdetailkey = null, ?string $ivd_formkey = null, ?string $ivd_parentdataobject = null, ?string $ivd_reg_key = null, ?string $ivd_addl_info = null, ?string $ivd_shippable_flag = null, ?int $ivd_ods_number = null, ?float $ivd_credit_to_distribute = null, ?float $ivd_inv_shippable_total = null, ?float $ivd_inv_distributable_credit_total = null, ?string $ivd__agy = null)
    {
        $this
            ->setIvd_price_previous($ivd_price_previous)
            ->setIvd_qty_previous($ivd_qty_previous)
            ->setIvd_key($ivd_key)
            ->setIvd_inv_key($ivd_inv_key)
            ->setIvd_price($ivd_price)
            ->setIvd_qty($ivd_qty)
            ->setIvd_approve_date($ivd_approve_date)
            ->setIvd_approve_user($ivd_approve_user)
            ->setIvd_void_date($ivd_void_date)
            ->setIvd_void_user($ivd_void_user)
            ->setIvd_ajd_key($ivd_ajd_key)
            ->setIvd_add_user($ivd_add_user)
            ->setIvd_add_date($ivd_add_date)
            ->setIvd_backorder_flag($ivd_backorder_flag)
            ->setIvd_change_user($ivd_change_user)
            ->setIvd_change_date($ivd_change_date)
            ->setIvd_inventory_held_qty($ivd_inventory_held_qty)
            ->setIvd_delete_flag($ivd_delete_flag)
            ->setIvd_ship_qty($ivd_ship_qty)
            ->setIvd_ship_flag_cp($ivd_ship_flag_cp)
            ->setIvd_key_ext($ivd_key_ext)
            ->setIvd_close_flag($ivd_close_flag)
            ->setIvd_approve_flag($ivd_approve_flag)
            ->setIvd_void_flag($ivd_void_flag)
            ->setIvd_prc_key($ivd_prc_key)
            ->setIvd_prc_prd_key($ivd_prc_prd_key)
            ->setIvd_amount_cp($ivd_amount_cp)
            ->setIvd_parity($ivd_parity)
            ->setIvd_parity_amount_cp($ivd_parity_amount_cp)
            ->setIvd_gla_dr_key($ivd_gla_dr_key)
            ->setIvd_gla_cr_key($ivd_gla_cr_key)
            ->setIvd_notes($ivd_notes)
            ->setIvd_cst_ship_key($ivd_cst_ship_key)
            ->setIvd_prc_prd_ptp_key($ivd_prc_prd_ptp_key)
            ->setIvd_cxa_key($ivd_cxa_key)
            ->setIvd_src_key($ivd_src_key)
            ->setIvd_type($ivd_type)
            ->setIvd_entity_key($ivd_entity_key)
            ->setIvd_ivw_key($ivd_ivw_key)
            ->setIvd_odd_key($ivd_odd_key)
            ->setIvd_do_not_fulfill($ivd_do_not_fulfill)
            ->setIvd_pak_prd_key($ivd_pak_prd_key)
            ->setIvd_ods_key($ivd_ods_key)
            ->setIvd_cst_key($ivd_cst_key)
            ->setIvd_account_number($ivd_account_number)
            ->setIvd_ovr_key($ivd_ovr_key)
            ->setIvd_price_override_reason($ivd_price_override_reason)
            ->setIvd_pjt_key($ivd_pjt_key)
            ->setIvd_backorder_email_sent_flag($ivd_backorder_email_sent_flag)
            ->setIvd_process_qty($ivd_process_qty)
            ->setIvd_bun_prd_key($ivd_bun_prd_key)
            ->setIvd_download_count($ivd_download_count)
            ->setIvd_eml_key($ivd_eml_key)
            ->setIvd_package_grouping_key($ivd_package_grouping_key)
            ->setIvd_cdd_key($ivd_cdd_key)
            ->setIvd_download_limit_override($ivd_download_limit_override)
            ->setIvd_discount_program_ivd_key($ivd_discount_program_ivd_key)
            ->setIvd_distributed_liability_flag($ivd_distributed_liability_flag)
            ->setIvd_download_days_override($ivd_download_days_override)
            ->setIvd_gc_number($ivd_gc_number)
            ->setIvd_cdt_key($ivd_cdt_key)
            ->setIvd_pro_key($ivd_pro_key)
            ->setIvd_available_for_cancel($ivd_available_for_cancel)
            ->setIvd_available_for_return($ivd_available_for_return)
            ->setIvd_balance_quantity($ivd_balance_quantity)
            ->setIvd_amount_due($ivd_amount_due)
            ->setIvd_automatically_added($ivd_automatically_added)
            ->setIvd_createorder_flag($ivd_createorder_flag)
            ->setIvd_deferral_total_returned($ivd_deferral_total_returned)
            ->setIvd_lineamount($ivd_lineamount)
            ->setIvd_lineamount_no_discount($ivd_lineamount_no_discount)
            ->setIvd_originallineamount($ivd_originallineamount)
            ->setIvd_restock_fee_calculated($ivd_restock_fee_calculated)
            ->setIvd_createinvoice_flag($ivd_createinvoice_flag)
            ->setIvd_linebalance($ivd_linebalance)
            ->setIvd_net_amount_due($ivd_net_amount_due)
            ->setIvd_payamount($ivd_payamount)
            ->setIvd_payamount_noreturn($ivd_payamount_noreturn)
            ->setIvd_cancelled_quantity($ivd_cancelled_quantity)
            ->setIvd_default_credit_dollar_amount($ivd_default_credit_dollar_amount)
            ->setIvd_deferral_number_periods($ivd_deferral_number_periods)
            ->setIvd_deferral_number_periods_recognized($ivd_deferral_number_periods_recognized)
            ->setIvd_deferral_price($ivd_deferral_price)
            ->setIvd_DeferralBalance($ivd_DeferralBalance)
            ->setIvd_minimum_quantity($ivd_minimum_quantity)
            ->setIvd_reduce_quantity($ivd_reduce_quantity)
            ->setIvd_return_quantity($ivd_return_quantity)
            ->setIvd_returned_quantity($ivd_returned_quantity)
            ->setIvd_total_recognized($ivd_total_recognized)
            ->setIvd_writeoff_dollar_amount($ivd_writeoff_dollar_amount)
            ->setIvd_allow_change_qty_flag($ivd_allow_change_qty_flag)
            ->setIvd_credit_dollar_amount($ivd_credit_dollar_amount)
            ->setIvd_pkg_optional($ivd_pkg_optional)
            ->setIvd_allow_change_price_flag($ivd_allow_change_price_flag)
            ->setIvd_cancel_quantity($ivd_cancel_quantity)
            ->setIvd_auto_refund($ivd_auto_refund)
            ->setIvd_NewBatch_key($ivd_NewBatch_key)
            ->setIvd_refund_credit_account($ivd_refund_credit_account)
            ->setIvd_ship_atc_key($ivd_ship_atc_key)
            ->setIvd_writeoff_deferral($ivd_writeoff_deferral)
            ->setIvd_claim_quantity($ivd_claim_quantity)
            ->setIvd_disable_quantity($ivd_disable_quantity)
            ->setIvd_claimed_quantity($ivd_claimed_quantity)
            ->setIvd_claim_flag($ivd_claim_flag)
            ->setIvd_subtotal($ivd_subtotal)
            ->setIvd_discountamount($ivd_discountamount)
            ->setIvd_total($ivd_total)
            ->setIvd_unit_price_with_discount($ivd_unit_price_with_discount)
            ->setIvd_applied_payment($ivd_applied_payment)
            ->setIvd_applied_credit($ivd_applied_credit)
            ->setIvd_write_off($ivd_write_off)
            ->setIvd_return_payment($ivd_return_payment)
            ->setIvd_total_payment($ivd_total_payment)
            ->setIvd_balance($ivd_balance)
            ->setIvd_tax($ivd_tax)
            ->setIvd_shipping($ivd_shipping)
            ->setIvd_nettotal($ivd_nettotal)
            ->setIvd_netpayment($ivd_netpayment)
            ->setIvd_payment_to_apply($ivd_payment_to_apply)
            ->setIvd_credit_to_apply($ivd_credit_to_apply)
            ->setIvd_netcredit($ivd_netcredit)
            ->setIvd_netwriteoff($ivd_netwriteoff)
            ->setIvd_writeoff_to_apply($ivd_writeoff_to_apply)
            ->setIvd_netreturn($ivd_netreturn)
            ->setIvd_return_to_apply($ivd_return_to_apply)
            ->setIvd_netapplied($ivd_netapplied)
            ->setIvd_previous_netpayment($ivd_previous_netpayment)
            ->setIvd_total_to_apply($ivd_total_to_apply)
            ->setIvd_netbalance($ivd_netbalance)
            ->setIvd_netunpaidbalance($ivd_netunpaidbalance)
            ->setIvd_price_aggregated($ivd_price_aggregated)
            ->setIvd_discountamount_aggregated($ivd_discountamount_aggregated)
            ->setIvd_tax_aggregated($ivd_tax_aggregated)
            ->setIvd_shipping_aggregated($ivd_shipping_aggregated)
            ->setIvd_nettotal_aggregated($ivd_nettotal_aggregated)
            ->setIvd_netunpaidbalance_aggregated($ivd_netunpaidbalance_aggregated)
            ->setIvd_subtotal_aggregated($ivd_subtotal_aggregated)
            ->setIvd_shippable_flag_aggregated($ivd_shippable_flag_aggregated)
            ->setIvd_partof_groupreg_discount($ivd_partof_groupreg_discount)
            ->setIvd_booth_number($ivd_booth_number)
            ->setIvd_cst_credit_available($ivd_cst_credit_available)
            ->setIvd_reload_ivd_cxa_key($ivd_reload_ivd_cxa_key)
            ->setIvd_MulticurrencyKey($ivd_MulticurrencyKey)
            ->setIvd_pricingcontrol_date($ivd_pricingcontrol_date)
            ->setIvd_pricingcontrol_rgt_key($ivd_pricingcontrol_rgt_key)
            ->setIvd_term_based($ivd_term_based)
            ->setIvd_term_calendar($ivd_term_calendar)
            ->setIvd_TransactionCurrencyKey($ivd_TransactionCurrencyKey)
            ->setIvd_HomeCurrencyCode($ivd_HomeCurrencyCode)
            ->setIvd_sub_prorated_flag($ivd_sub_prorated_flag)
            ->setIvd_autoapply($ivd_autoapply)
            ->setIvd_cancel_flag($ivd_cancel_flag)
            ->setIvd_ivd_key($ivd_ivd_key)
            ->setIvd_is_agency_sub($ivd_is_agency_sub)
            ->setIvd_formdetailkey($ivd_formdetailkey)
            ->setIvd_formkey($ivd_formkey)
            ->setIvd_parentdataobject($ivd_parentdataobject)
            ->setIvd_reg_key($ivd_reg_key)
            ->setIvd_addl_info($ivd_addl_info)
            ->setIvd_shippable_flag($ivd_shippable_flag)
            ->setIvd_ods_number($ivd_ods_number)
            ->setIvd_credit_to_distribute($ivd_credit_to_distribute)
            ->setIvd_inv_shippable_total($ivd_inv_shippable_total)
            ->setIvd_inv_distributable_credit_total($ivd_inv_distributable_credit_total)
            ->setIvd__agy($ivd__agy);
    }
    /**
     * Get ivd_price_previous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_price_previous(): ?float
    {
        return $this->ivd_price_previous ?? null;
    }
    /**
     * Set ivd_price_previous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_price_previous
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_price_previous(?float $ivd_price_previous = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_price_previous) && !(is_float($ivd_price_previous) || is_numeric($ivd_price_previous))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_price_previous, true), gettype($ivd_price_previous)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_price_previous) && mb_strlen(mb_substr((string) $ivd_price_previous, false !== mb_strpos((string) $ivd_price_previous, '.') ? mb_strpos((string) $ivd_price_previous, '.') + 1 : mb_strlen((string) $ivd_price_previous))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_price_previous, true), mb_strlen(mb_substr((string) $ivd_price_previous, mb_strpos((string) $ivd_price_previous, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_price_previous) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_price_previous)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_price_previous, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_price_previous))), __LINE__);
        }
        if (is_null($ivd_price_previous) || (is_array($ivd_price_previous) && empty($ivd_price_previous))) {
            unset($this->ivd_price_previous);
        } else {
            $this->ivd_price_previous = $ivd_price_previous;
        }
        
        return $this;
    }
    /**
     * Get ivd_qty_previous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_qty_previous(): ?float
    {
        return $this->ivd_qty_previous ?? null;
    }
    /**
     * Set ivd_qty_previous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_qty_previous
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_qty_previous(?float $ivd_qty_previous = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_qty_previous) && !(is_float($ivd_qty_previous) || is_numeric($ivd_qty_previous))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_qty_previous, true), gettype($ivd_qty_previous)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_qty_previous) && mb_strlen(mb_substr((string) $ivd_qty_previous, false !== mb_strpos((string) $ivd_qty_previous, '.') ? mb_strpos((string) $ivd_qty_previous, '.') + 1 : mb_strlen((string) $ivd_qty_previous))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_qty_previous, true), mb_strlen(mb_substr((string) $ivd_qty_previous, mb_strpos((string) $ivd_qty_previous, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_qty_previous) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_qty_previous)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_qty_previous, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_qty_previous))), __LINE__);
        }
        if (is_null($ivd_qty_previous) || (is_array($ivd_qty_previous) && empty($ivd_qty_previous))) {
            unset($this->ivd_qty_previous);
        } else {
            $this->ivd_qty_previous = $ivd_qty_previous;
        }
        
        return $this;
    }
    /**
     * Get ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_key(): ?string
    {
        return $this->ivd_key ?? null;
    }
    /**
     * Set ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_key(?string $ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_key) && !is_string($ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_key, true), gettype($ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_key, true)), __LINE__);
        }
        if (is_null($ivd_key) || (is_array($ivd_key) && empty($ivd_key))) {
            unset($this->ivd_key);
        } else {
            $this->ivd_key = $ivd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_inv_key(): ?string
    {
        return $this->ivd_inv_key ?? null;
    }
    /**
     * Set ivd_inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_inv_key(?string $ivd_inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_inv_key) && !is_string($ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_inv_key, true), gettype($ivd_inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_inv_key, true)), __LINE__);
        }
        if (is_null($ivd_inv_key) || (is_array($ivd_inv_key) && empty($ivd_inv_key))) {
            unset($this->ivd_inv_key);
        } else {
            $this->ivd_inv_key = $ivd_inv_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_price(): ?float
    {
        return $this->ivd_price ?? null;
    }
    /**
     * Set ivd_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_price(?float $ivd_price = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_price) && !(is_float($ivd_price) || is_numeric($ivd_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_price, true), gettype($ivd_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_price) && mb_strlen(mb_substr((string) $ivd_price, false !== mb_strpos((string) $ivd_price, '.') ? mb_strpos((string) $ivd_price, '.') + 1 : mb_strlen((string) $ivd_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_price, true), mb_strlen(mb_substr((string) $ivd_price, mb_strpos((string) $ivd_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_price))), __LINE__);
        }
        if (is_null($ivd_price) || (is_array($ivd_price) && empty($ivd_price))) {
            unset($this->ivd_price);
        } else {
            $this->ivd_price = $ivd_price;
        }
        
        return $this;
    }
    /**
     * Get ivd_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_qty(): ?float
    {
        return $this->ivd_qty ?? null;
    }
    /**
     * Set ivd_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_qty(?float $ivd_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_qty) && !(is_float($ivd_qty) || is_numeric($ivd_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_qty, true), gettype($ivd_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_qty) && mb_strlen(mb_substr((string) $ivd_qty, false !== mb_strpos((string) $ivd_qty, '.') ? mb_strpos((string) $ivd_qty, '.') + 1 : mb_strlen((string) $ivd_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_qty, true), mb_strlen(mb_substr((string) $ivd_qty, mb_strpos((string) $ivd_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_qty))), __LINE__);
        }
        if (is_null($ivd_qty) || (is_array($ivd_qty) && empty($ivd_qty))) {
            unset($this->ivd_qty);
        } else {
            $this->ivd_qty = $ivd_qty;
        }
        
        return $this;
    }
    /**
     * Get ivd_approve_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_approve_date(): ?string
    {
        return $this->ivd_approve_date ?? null;
    }
    /**
     * Set ivd_approve_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_approve_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_approve_date(?string $ivd_approve_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_approve_date) && !is_string($ivd_approve_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_approve_date, true), gettype($ivd_approve_date)), __LINE__);
        }
        if (is_null($ivd_approve_date) || (is_array($ivd_approve_date) && empty($ivd_approve_date))) {
            unset($this->ivd_approve_date);
        } else {
            $this->ivd_approve_date = $ivd_approve_date;
        }
        
        return $this;
    }
    /**
     * Get ivd_approve_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_approve_user(): ?string
    {
        return $this->ivd_approve_user ?? null;
    }
    /**
     * Set ivd_approve_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_approve_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_approve_user(?string $ivd_approve_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_approve_user) && !is_string($ivd_approve_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_approve_user, true), gettype($ivd_approve_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ivd_approve_user) && mb_strlen((string) $ivd_approve_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ivd_approve_user)), __LINE__);
        }
        if (is_null($ivd_approve_user) || (is_array($ivd_approve_user) && empty($ivd_approve_user))) {
            unset($this->ivd_approve_user);
        } else {
            $this->ivd_approve_user = $ivd_approve_user;
        }
        
        return $this;
    }
    /**
     * Get ivd_void_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_void_date(): ?string
    {
        return $this->ivd_void_date ?? null;
    }
    /**
     * Set ivd_void_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_void_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_void_date(?string $ivd_void_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_void_date) && !is_string($ivd_void_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_void_date, true), gettype($ivd_void_date)), __LINE__);
        }
        if (is_null($ivd_void_date) || (is_array($ivd_void_date) && empty($ivd_void_date))) {
            unset($this->ivd_void_date);
        } else {
            $this->ivd_void_date = $ivd_void_date;
        }
        
        return $this;
    }
    /**
     * Get ivd_void_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_void_user(): ?string
    {
        return $this->ivd_void_user ?? null;
    }
    /**
     * Set ivd_void_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_void_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_void_user(?string $ivd_void_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_void_user) && !is_string($ivd_void_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_void_user, true), gettype($ivd_void_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ivd_void_user) && mb_strlen((string) $ivd_void_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ivd_void_user)), __LINE__);
        }
        if (is_null($ivd_void_user) || (is_array($ivd_void_user) && empty($ivd_void_user))) {
            unset($this->ivd_void_user);
        } else {
            $this->ivd_void_user = $ivd_void_user;
        }
        
        return $this;
    }
    /**
     * Get ivd_ajd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ajd_key(): ?string
    {
        return $this->ivd_ajd_key ?? null;
    }
    /**
     * Set ivd_ajd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ajd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_ajd_key(?string $ivd_ajd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ajd_key) && !is_string($ivd_ajd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ajd_key, true), gettype($ivd_ajd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ajd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ajd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ajd_key, true)), __LINE__);
        }
        if (is_null($ivd_ajd_key) || (is_array($ivd_ajd_key) && empty($ivd_ajd_key))) {
            unset($this->ivd_ajd_key);
        } else {
            $this->ivd_ajd_key = $ivd_ajd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_add_user(): ?string
    {
        return $this->ivd_add_user ?? null;
    }
    /**
     * Set ivd_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_add_user(?string $ivd_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_add_user) && !is_string($ivd_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_add_user, true), gettype($ivd_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ivd_add_user) && mb_strlen((string) $ivd_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ivd_add_user)), __LINE__);
        }
        if (is_null($ivd_add_user) || (is_array($ivd_add_user) && empty($ivd_add_user))) {
            unset($this->ivd_add_user);
        } else {
            $this->ivd_add_user = $ivd_add_user;
        }
        
        return $this;
    }
    /**
     * Get ivd_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_add_date(): ?string
    {
        return $this->ivd_add_date ?? null;
    }
    /**
     * Set ivd_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_add_date(?string $ivd_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_add_date) && !is_string($ivd_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_add_date, true), gettype($ivd_add_date)), __LINE__);
        }
        if (is_null($ivd_add_date) || (is_array($ivd_add_date) && empty($ivd_add_date))) {
            unset($this->ivd_add_date);
        } else {
            $this->ivd_add_date = $ivd_add_date;
        }
        
        return $this;
    }
    /**
     * Get ivd_backorder_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_backorder_flag(): ?string
    {
        return $this->ivd_backorder_flag ?? null;
    }
    /**
     * Set ivd_backorder_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_backorder_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_backorder_flag(?string $ivd_backorder_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_backorder_flag) && !is_string($ivd_backorder_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_backorder_flag, true), gettype($ivd_backorder_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_backorder_flag) && $ivd_backorder_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_backorder_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_backorder_flag) && $ivd_backorder_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_backorder_flag, true)), __LINE__);
        }
        if (is_null($ivd_backorder_flag) || (is_array($ivd_backorder_flag) && empty($ivd_backorder_flag))) {
            unset($this->ivd_backorder_flag);
        } else {
            $this->ivd_backorder_flag = $ivd_backorder_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_change_user(): ?string
    {
        return $this->ivd_change_user ?? null;
    }
    /**
     * Set ivd_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_change_user(?string $ivd_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_change_user) && !is_string($ivd_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_change_user, true), gettype($ivd_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ivd_change_user) && mb_strlen((string) $ivd_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ivd_change_user)), __LINE__);
        }
        if (is_null($ivd_change_user) || (is_array($ivd_change_user) && empty($ivd_change_user))) {
            unset($this->ivd_change_user);
        } else {
            $this->ivd_change_user = $ivd_change_user;
        }
        
        return $this;
    }
    /**
     * Get ivd_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_change_date(): ?string
    {
        return $this->ivd_change_date ?? null;
    }
    /**
     * Set ivd_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_change_date(?string $ivd_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_change_date) && !is_string($ivd_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_change_date, true), gettype($ivd_change_date)), __LINE__);
        }
        if (is_null($ivd_change_date) || (is_array($ivd_change_date) && empty($ivd_change_date))) {
            unset($this->ivd_change_date);
        } else {
            $this->ivd_change_date = $ivd_change_date;
        }
        
        return $this;
    }
    /**
     * Get ivd_inventory_held_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_inventory_held_qty(): ?float
    {
        return $this->ivd_inventory_held_qty ?? null;
    }
    /**
     * Set ivd_inventory_held_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_inventory_held_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_inventory_held_qty(?float $ivd_inventory_held_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_inventory_held_qty) && !(is_float($ivd_inventory_held_qty) || is_numeric($ivd_inventory_held_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_inventory_held_qty, true), gettype($ivd_inventory_held_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_inventory_held_qty) && mb_strlen(mb_substr((string) $ivd_inventory_held_qty, false !== mb_strpos((string) $ivd_inventory_held_qty, '.') ? mb_strpos((string) $ivd_inventory_held_qty, '.') + 1 : mb_strlen((string) $ivd_inventory_held_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_inventory_held_qty, true), mb_strlen(mb_substr((string) $ivd_inventory_held_qty, mb_strpos((string) $ivd_inventory_held_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_inventory_held_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_inventory_held_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_inventory_held_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_inventory_held_qty))), __LINE__);
        }
        if (is_null($ivd_inventory_held_qty) || (is_array($ivd_inventory_held_qty) && empty($ivd_inventory_held_qty))) {
            unset($this->ivd_inventory_held_qty);
        } else {
            $this->ivd_inventory_held_qty = $ivd_inventory_held_qty;
        }
        
        return $this;
    }
    /**
     * Get ivd_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_delete_flag(): ?string
    {
        return $this->ivd_delete_flag ?? null;
    }
    /**
     * Set ivd_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_delete_flag(?string $ivd_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_delete_flag) && !is_string($ivd_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_delete_flag, true), gettype($ivd_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_delete_flag) && $ivd_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_delete_flag) && $ivd_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_delete_flag, true)), __LINE__);
        }
        if (is_null($ivd_delete_flag) || (is_array($ivd_delete_flag) && empty($ivd_delete_flag))) {
            unset($this->ivd_delete_flag);
        } else {
            $this->ivd_delete_flag = $ivd_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_ship_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_ship_qty(): ?float
    {
        return $this->ivd_ship_qty ?? null;
    }
    /**
     * Set ivd_ship_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_ship_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_ship_qty(?float $ivd_ship_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_ship_qty) && !(is_float($ivd_ship_qty) || is_numeric($ivd_ship_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_ship_qty, true), gettype($ivd_ship_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_ship_qty) && mb_strlen(mb_substr((string) $ivd_ship_qty, false !== mb_strpos((string) $ivd_ship_qty, '.') ? mb_strpos((string) $ivd_ship_qty, '.') + 1 : mb_strlen((string) $ivd_ship_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_ship_qty, true), mb_strlen(mb_substr((string) $ivd_ship_qty, mb_strpos((string) $ivd_ship_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_ship_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_ship_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_ship_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_ship_qty))), __LINE__);
        }
        if (is_null($ivd_ship_qty) || (is_array($ivd_ship_qty) && empty($ivd_ship_qty))) {
            unset($this->ivd_ship_qty);
        } else {
            $this->ivd_ship_qty = $ivd_ship_qty;
        }
        
        return $this;
    }
    /**
     * Get ivd_ship_flag_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_ship_flag_cp(): ?int
    {
        return $this->ivd_ship_flag_cp ?? null;
    }
    /**
     * Set ivd_ship_flag_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_ship_flag_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_ship_flag_cp(?int $ivd_ship_flag_cp = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_ship_flag_cp) && !(is_int($ivd_ship_flag_cp) || ctype_digit($ivd_ship_flag_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_ship_flag_cp, true), gettype($ivd_ship_flag_cp)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_ship_flag_cp) && $ivd_ship_flag_cp > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_ship_flag_cp, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_ship_flag_cp) && $ivd_ship_flag_cp < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_ship_flag_cp, true)), __LINE__);
        }
        if (is_null($ivd_ship_flag_cp) || (is_array($ivd_ship_flag_cp) && empty($ivd_ship_flag_cp))) {
            unset($this->ivd_ship_flag_cp);
        } else {
            $this->ivd_ship_flag_cp = $ivd_ship_flag_cp;
        }
        
        return $this;
    }
    /**
     * Get ivd_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_key_ext(): ?string
    {
        return $this->ivd_key_ext ?? null;
    }
    /**
     * Set ivd_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_key_ext(?string $ivd_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_key_ext) && !is_string($ivd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_key_ext, true), gettype($ivd_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_key_ext, true)), __LINE__);
        }
        if (is_null($ivd_key_ext) || (is_array($ivd_key_ext) && empty($ivd_key_ext))) {
            unset($this->ivd_key_ext);
        } else {
            $this->ivd_key_ext = $ivd_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ivd_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_close_flag(): ?string
    {
        return $this->ivd_close_flag ?? null;
    }
    /**
     * Set ivd_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_close_flag(?string $ivd_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_close_flag) && !is_string($ivd_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_close_flag, true), gettype($ivd_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_close_flag) && $ivd_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_close_flag) && $ivd_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_close_flag, true)), __LINE__);
        }
        if (is_null($ivd_close_flag) || (is_array($ivd_close_flag) && empty($ivd_close_flag))) {
            unset($this->ivd_close_flag);
        } else {
            $this->ivd_close_flag = $ivd_close_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_approve_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_approve_flag(): ?string
    {
        return $this->ivd_approve_flag ?? null;
    }
    /**
     * Set ivd_approve_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_approve_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_approve_flag(?string $ivd_approve_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_approve_flag) && !is_string($ivd_approve_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_approve_flag, true), gettype($ivd_approve_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_approve_flag) && $ivd_approve_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_approve_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_approve_flag) && $ivd_approve_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_approve_flag, true)), __LINE__);
        }
        if (is_null($ivd_approve_flag) || (is_array($ivd_approve_flag) && empty($ivd_approve_flag))) {
            unset($this->ivd_approve_flag);
        } else {
            $this->ivd_approve_flag = $ivd_approve_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_void_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_void_flag(): ?string
    {
        return $this->ivd_void_flag ?? null;
    }
    /**
     * Set ivd_void_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_void_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_void_flag(?string $ivd_void_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_void_flag) && !is_string($ivd_void_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_void_flag, true), gettype($ivd_void_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_void_flag) && $ivd_void_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_void_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_void_flag) && $ivd_void_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_void_flag, true)), __LINE__);
        }
        if (is_null($ivd_void_flag) || (is_array($ivd_void_flag) && empty($ivd_void_flag))) {
            unset($this->ivd_void_flag);
        } else {
            $this->ivd_void_flag = $ivd_void_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_prc_key(): ?string
    {
        return $this->ivd_prc_key ?? null;
    }
    /**
     * Set ivd_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_prc_key(?string $ivd_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_prc_key) && !is_string($ivd_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_prc_key, true), gettype($ivd_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_prc_key, true)), __LINE__);
        }
        if (is_null($ivd_prc_key) || (is_array($ivd_prc_key) && empty($ivd_prc_key))) {
            unset($this->ivd_prc_key);
        } else {
            $this->ivd_prc_key = $ivd_prc_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_prc_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_prc_prd_key(): ?string
    {
        return $this->ivd_prc_prd_key ?? null;
    }
    /**
     * Set ivd_prc_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_prc_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_prc_prd_key(?string $ivd_prc_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_prc_prd_key) && !is_string($ivd_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_prc_prd_key, true), gettype($ivd_prc_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_prc_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_prc_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_prc_prd_key, true)), __LINE__);
        }
        if (is_null($ivd_prc_prd_key) || (is_array($ivd_prc_prd_key) && empty($ivd_prc_prd_key))) {
            unset($this->ivd_prc_prd_key);
        } else {
            $this->ivd_prc_prd_key = $ivd_prc_prd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_amount_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_amount_cp(): ?float
    {
        return $this->ivd_amount_cp ?? null;
    }
    /**
     * Set ivd_amount_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_amount_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_amount_cp(?float $ivd_amount_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_amount_cp) && !(is_float($ivd_amount_cp) || is_numeric($ivd_amount_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_amount_cp, true), gettype($ivd_amount_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_amount_cp) && mb_strlen(mb_substr((string) $ivd_amount_cp, false !== mb_strpos((string) $ivd_amount_cp, '.') ? mb_strpos((string) $ivd_amount_cp, '.') + 1 : mb_strlen((string) $ivd_amount_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_amount_cp, true), mb_strlen(mb_substr((string) $ivd_amount_cp, mb_strpos((string) $ivd_amount_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_amount_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_amount_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_amount_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_amount_cp))), __LINE__);
        }
        if (is_null($ivd_amount_cp) || (is_array($ivd_amount_cp) && empty($ivd_amount_cp))) {
            unset($this->ivd_amount_cp);
        } else {
            $this->ivd_amount_cp = $ivd_amount_cp;
        }
        
        return $this;
    }
    /**
     * Get ivd_parity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_parity(): ?int
    {
        return $this->ivd_parity ?? null;
    }
    /**
     * Set ivd_parity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_parity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_parity(?int $ivd_parity = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_parity) && !(is_int($ivd_parity) || ctype_digit($ivd_parity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_parity, true), gettype($ivd_parity)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_parity) && $ivd_parity > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_parity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_parity) && $ivd_parity < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_parity, true)), __LINE__);
        }
        if (is_null($ivd_parity) || (is_array($ivd_parity) && empty($ivd_parity))) {
            unset($this->ivd_parity);
        } else {
            $this->ivd_parity = $ivd_parity;
        }
        
        return $this;
    }
    /**
     * Get ivd_parity_amount_cp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_parity_amount_cp(): ?float
    {
        return $this->ivd_parity_amount_cp ?? null;
    }
    /**
     * Set ivd_parity_amount_cp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_parity_amount_cp
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_parity_amount_cp(?float $ivd_parity_amount_cp = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_parity_amount_cp) && !(is_float($ivd_parity_amount_cp) || is_numeric($ivd_parity_amount_cp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_parity_amount_cp, true), gettype($ivd_parity_amount_cp)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_parity_amount_cp) && mb_strlen(mb_substr((string) $ivd_parity_amount_cp, false !== mb_strpos((string) $ivd_parity_amount_cp, '.') ? mb_strpos((string) $ivd_parity_amount_cp, '.') + 1 : mb_strlen((string) $ivd_parity_amount_cp))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_parity_amount_cp, true), mb_strlen(mb_substr((string) $ivd_parity_amount_cp, mb_strpos((string) $ivd_parity_amount_cp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_parity_amount_cp) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_parity_amount_cp)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_parity_amount_cp, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_parity_amount_cp))), __LINE__);
        }
        if (is_null($ivd_parity_amount_cp) || (is_array($ivd_parity_amount_cp) && empty($ivd_parity_amount_cp))) {
            unset($this->ivd_parity_amount_cp);
        } else {
            $this->ivd_parity_amount_cp = $ivd_parity_amount_cp;
        }
        
        return $this;
    }
    /**
     * Get ivd_gla_dr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_gla_dr_key(): ?string
    {
        return $this->ivd_gla_dr_key ?? null;
    }
    /**
     * Set ivd_gla_dr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_gla_dr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_gla_dr_key(?string $ivd_gla_dr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_gla_dr_key) && !is_string($ivd_gla_dr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_gla_dr_key, true), gettype($ivd_gla_dr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_gla_dr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_gla_dr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_gla_dr_key, true)), __LINE__);
        }
        if (is_null($ivd_gla_dr_key) || (is_array($ivd_gla_dr_key) && empty($ivd_gla_dr_key))) {
            unset($this->ivd_gla_dr_key);
        } else {
            $this->ivd_gla_dr_key = $ivd_gla_dr_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_gla_cr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_gla_cr_key(): ?string
    {
        return $this->ivd_gla_cr_key ?? null;
    }
    /**
     * Set ivd_gla_cr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_gla_cr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_gla_cr_key(?string $ivd_gla_cr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_gla_cr_key) && !is_string($ivd_gla_cr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_gla_cr_key, true), gettype($ivd_gla_cr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_gla_cr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_gla_cr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_gla_cr_key, true)), __LINE__);
        }
        if (is_null($ivd_gla_cr_key) || (is_array($ivd_gla_cr_key) && empty($ivd_gla_cr_key))) {
            unset($this->ivd_gla_cr_key);
        } else {
            $this->ivd_gla_cr_key = $ivd_gla_cr_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_notes(): ?string
    {
        return $this->ivd_notes ?? null;
    }
    /**
     * Set ivd_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_notes(?string $ivd_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_notes) && !is_string($ivd_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_notes, true), gettype($ivd_notes)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($ivd_notes) && mb_strlen((string) $ivd_notes) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $ivd_notes)), __LINE__);
        }
        if (is_null($ivd_notes) || (is_array($ivd_notes) && empty($ivd_notes))) {
            unset($this->ivd_notes);
        } else {
            $this->ivd_notes = $ivd_notes;
        }
        
        return $this;
    }
    /**
     * Get ivd_cst_ship_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cst_ship_key(): ?string
    {
        return $this->ivd_cst_ship_key ?? null;
    }
    /**
     * Set ivd_cst_ship_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cst_ship_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_cst_ship_key(?string $ivd_cst_ship_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cst_ship_key) && !is_string($ivd_cst_ship_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cst_ship_key, true), gettype($ivd_cst_ship_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cst_ship_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cst_ship_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cst_ship_key, true)), __LINE__);
        }
        if (is_null($ivd_cst_ship_key) || (is_array($ivd_cst_ship_key) && empty($ivd_cst_ship_key))) {
            unset($this->ivd_cst_ship_key);
        } else {
            $this->ivd_cst_ship_key = $ivd_cst_ship_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_prc_prd_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_prc_prd_ptp_key(): ?string
    {
        return $this->ivd_prc_prd_ptp_key ?? null;
    }
    /**
     * Set ivd_prc_prd_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_prc_prd_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_prc_prd_ptp_key(?string $ivd_prc_prd_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_prc_prd_ptp_key) && !is_string($ivd_prc_prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_prc_prd_ptp_key, true), gettype($ivd_prc_prd_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_prc_prd_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_prc_prd_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_prc_prd_ptp_key, true)), __LINE__);
        }
        if (is_null($ivd_prc_prd_ptp_key) || (is_array($ivd_prc_prd_ptp_key) && empty($ivd_prc_prd_ptp_key))) {
            unset($this->ivd_prc_prd_ptp_key);
        } else {
            $this->ivd_prc_prd_ptp_key = $ivd_prc_prd_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cxa_key(): ?string
    {
        return $this->ivd_cxa_key ?? null;
    }
    /**
     * Set ivd_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_cxa_key(?string $ivd_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cxa_key) && !is_string($ivd_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cxa_key, true), gettype($ivd_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cxa_key, true)), __LINE__);
        }
        if (is_null($ivd_cxa_key) || (is_array($ivd_cxa_key) && empty($ivd_cxa_key))) {
            unset($this->ivd_cxa_key);
        } else {
            $this->ivd_cxa_key = $ivd_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_src_key(): ?string
    {
        return $this->ivd_src_key ?? null;
    }
    /**
     * Set ivd_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_src_key(?string $ivd_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_src_key) && !is_string($ivd_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_src_key, true), gettype($ivd_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_src_key, true)), __LINE__);
        }
        if (is_null($ivd_src_key) || (is_array($ivd_src_key) && empty($ivd_src_key))) {
            unset($this->ivd_src_key);
        } else {
            $this->ivd_src_key = $ivd_src_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_type(): ?string
    {
        return $this->ivd_type ?? null;
    }
    /**
     * Set ivd_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_type(?string $ivd_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_type) && !is_string($ivd_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_type, true), gettype($ivd_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ivd_type) && mb_strlen((string) $ivd_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ivd_type)), __LINE__);
        }
        if (is_null($ivd_type) || (is_array($ivd_type) && empty($ivd_type))) {
            unset($this->ivd_type);
        } else {
            $this->ivd_type = $ivd_type;
        }
        
        return $this;
    }
    /**
     * Get ivd_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_entity_key(): ?string
    {
        return $this->ivd_entity_key ?? null;
    }
    /**
     * Set ivd_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_entity_key(?string $ivd_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_entity_key) && !is_string($ivd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_entity_key, true), gettype($ivd_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_entity_key, true)), __LINE__);
        }
        if (is_null($ivd_entity_key) || (is_array($ivd_entity_key) && empty($ivd_entity_key))) {
            unset($this->ivd_entity_key);
        } else {
            $this->ivd_entity_key = $ivd_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_ivw_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ivw_key(): ?string
    {
        return $this->ivd_ivw_key ?? null;
    }
    /**
     * Set ivd_ivw_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ivw_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_ivw_key(?string $ivd_ivw_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ivw_key) && !is_string($ivd_ivw_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ivw_key, true), gettype($ivd_ivw_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ivw_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ivw_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ivw_key, true)), __LINE__);
        }
        if (is_null($ivd_ivw_key) || (is_array($ivd_ivw_key) && empty($ivd_ivw_key))) {
            unset($this->ivd_ivw_key);
        } else {
            $this->ivd_ivw_key = $ivd_ivw_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_odd_key(): ?string
    {
        return $this->ivd_odd_key ?? null;
    }
    /**
     * Set ivd_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_odd_key(?string $ivd_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_odd_key) && !is_string($ivd_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_odd_key, true), gettype($ivd_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_odd_key, true)), __LINE__);
        }
        if (is_null($ivd_odd_key) || (is_array($ivd_odd_key) && empty($ivd_odd_key))) {
            unset($this->ivd_odd_key);
        } else {
            $this->ivd_odd_key = $ivd_odd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_do_not_fulfill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_do_not_fulfill(): ?string
    {
        return $this->ivd_do_not_fulfill ?? null;
    }
    /**
     * Set ivd_do_not_fulfill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_do_not_fulfill
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_do_not_fulfill(?string $ivd_do_not_fulfill = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_do_not_fulfill) && !is_string($ivd_do_not_fulfill)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_do_not_fulfill, true), gettype($ivd_do_not_fulfill)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_do_not_fulfill) && $ivd_do_not_fulfill > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_do_not_fulfill, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_do_not_fulfill) && $ivd_do_not_fulfill < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_do_not_fulfill, true)), __LINE__);
        }
        if (is_null($ivd_do_not_fulfill) || (is_array($ivd_do_not_fulfill) && empty($ivd_do_not_fulfill))) {
            unset($this->ivd_do_not_fulfill);
        } else {
            $this->ivd_do_not_fulfill = $ivd_do_not_fulfill;
        }
        
        return $this;
    }
    /**
     * Get ivd_pak_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_pak_prd_key(): ?string
    {
        return $this->ivd_pak_prd_key ?? null;
    }
    /**
     * Set ivd_pak_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_pak_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_pak_prd_key(?string $ivd_pak_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_pak_prd_key) && !is_string($ivd_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_pak_prd_key, true), gettype($ivd_pak_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_pak_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_pak_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_pak_prd_key, true)), __LINE__);
        }
        if (is_null($ivd_pak_prd_key) || (is_array($ivd_pak_prd_key) && empty($ivd_pak_prd_key))) {
            unset($this->ivd_pak_prd_key);
        } else {
            $this->ivd_pak_prd_key = $ivd_pak_prd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_ods_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ods_key(): ?string
    {
        return $this->ivd_ods_key ?? null;
    }
    /**
     * Set ivd_ods_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ods_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_ods_key(?string $ivd_ods_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ods_key) && !is_string($ivd_ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ods_key, true), gettype($ivd_ods_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ods_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ods_key, true)), __LINE__);
        }
        if (is_null($ivd_ods_key) || (is_array($ivd_ods_key) && empty($ivd_ods_key))) {
            unset($this->ivd_ods_key);
        } else {
            $this->ivd_ods_key = $ivd_ods_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cst_key(): ?string
    {
        return $this->ivd_cst_key ?? null;
    }
    /**
     * Set ivd_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_cst_key(?string $ivd_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cst_key) && !is_string($ivd_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cst_key, true), gettype($ivd_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cst_key, true)), __LINE__);
        }
        if (is_null($ivd_cst_key) || (is_array($ivd_cst_key) && empty($ivd_cst_key))) {
            unset($this->ivd_cst_key);
        } else {
            $this->ivd_cst_key = $ivd_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_account_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_account_number(): ?string
    {
        return $this->ivd_account_number ?? null;
    }
    /**
     * Set ivd_account_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_account_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_account_number(?string $ivd_account_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_account_number) && !is_string($ivd_account_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_account_number, true), gettype($ivd_account_number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ivd_account_number) && mb_strlen((string) $ivd_account_number) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ivd_account_number)), __LINE__);
        }
        if (is_null($ivd_account_number) || (is_array($ivd_account_number) && empty($ivd_account_number))) {
            unset($this->ivd_account_number);
        } else {
            $this->ivd_account_number = $ivd_account_number;
        }
        
        return $this;
    }
    /**
     * Get ivd_ovr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ovr_key(): ?string
    {
        return $this->ivd_ovr_key ?? null;
    }
    /**
     * Set ivd_ovr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ovr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_ovr_key(?string $ivd_ovr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ovr_key) && !is_string($ivd_ovr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ovr_key, true), gettype($ivd_ovr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ovr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ovr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ovr_key, true)), __LINE__);
        }
        if (is_null($ivd_ovr_key) || (is_array($ivd_ovr_key) && empty($ivd_ovr_key))) {
            unset($this->ivd_ovr_key);
        } else {
            $this->ivd_ovr_key = $ivd_ovr_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_price_override_reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_price_override_reason(): ?string
    {
        return $this->ivd_price_override_reason ?? null;
    }
    /**
     * Set ivd_price_override_reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_price_override_reason
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_price_override_reason(?string $ivd_price_override_reason = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_price_override_reason) && !is_string($ivd_price_override_reason)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_price_override_reason, true), gettype($ivd_price_override_reason)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($ivd_price_override_reason) && mb_strlen((string) $ivd_price_override_reason) > 100) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen((string) $ivd_price_override_reason)), __LINE__);
        }
        if (is_null($ivd_price_override_reason) || (is_array($ivd_price_override_reason) && empty($ivd_price_override_reason))) {
            unset($this->ivd_price_override_reason);
        } else {
            $this->ivd_price_override_reason = $ivd_price_override_reason;
        }
        
        return $this;
    }
    /**
     * Get ivd_pjt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_pjt_key(): ?string
    {
        return $this->ivd_pjt_key ?? null;
    }
    /**
     * Set ivd_pjt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_pjt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_pjt_key(?string $ivd_pjt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_pjt_key) && !is_string($ivd_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_pjt_key, true), gettype($ivd_pjt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_pjt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_pjt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_pjt_key, true)), __LINE__);
        }
        if (is_null($ivd_pjt_key) || (is_array($ivd_pjt_key) && empty($ivd_pjt_key))) {
            unset($this->ivd_pjt_key);
        } else {
            $this->ivd_pjt_key = $ivd_pjt_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_backorder_email_sent_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_backorder_email_sent_flag(): ?string
    {
        return $this->ivd_backorder_email_sent_flag ?? null;
    }
    /**
     * Set ivd_backorder_email_sent_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_backorder_email_sent_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_backorder_email_sent_flag(?string $ivd_backorder_email_sent_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_backorder_email_sent_flag) && !is_string($ivd_backorder_email_sent_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_backorder_email_sent_flag, true), gettype($ivd_backorder_email_sent_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_backorder_email_sent_flag) && $ivd_backorder_email_sent_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_backorder_email_sent_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_backorder_email_sent_flag) && $ivd_backorder_email_sent_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_backorder_email_sent_flag, true)), __LINE__);
        }
        if (is_null($ivd_backorder_email_sent_flag) || (is_array($ivd_backorder_email_sent_flag) && empty($ivd_backorder_email_sent_flag))) {
            unset($this->ivd_backorder_email_sent_flag);
        } else {
            $this->ivd_backorder_email_sent_flag = $ivd_backorder_email_sent_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_process_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_process_qty(): ?float
    {
        return $this->ivd_process_qty ?? null;
    }
    /**
     * Set ivd_process_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_process_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_process_qty(?float $ivd_process_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_process_qty) && !(is_float($ivd_process_qty) || is_numeric($ivd_process_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_process_qty, true), gettype($ivd_process_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_process_qty) && mb_strlen(mb_substr((string) $ivd_process_qty, false !== mb_strpos((string) $ivd_process_qty, '.') ? mb_strpos((string) $ivd_process_qty, '.') + 1 : mb_strlen((string) $ivd_process_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_process_qty, true), mb_strlen(mb_substr((string) $ivd_process_qty, mb_strpos((string) $ivd_process_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_process_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_process_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_process_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_process_qty))), __LINE__);
        }
        if (is_null($ivd_process_qty) || (is_array($ivd_process_qty) && empty($ivd_process_qty))) {
            unset($this->ivd_process_qty);
        } else {
            $this->ivd_process_qty = $ivd_process_qty;
        }
        
        return $this;
    }
    /**
     * Get ivd_bun_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_bun_prd_key(): ?string
    {
        return $this->ivd_bun_prd_key ?? null;
    }
    /**
     * Set ivd_bun_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_bun_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_bun_prd_key(?string $ivd_bun_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_bun_prd_key) && !is_string($ivd_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_bun_prd_key, true), gettype($ivd_bun_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_bun_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_bun_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_bun_prd_key, true)), __LINE__);
        }
        if (is_null($ivd_bun_prd_key) || (is_array($ivd_bun_prd_key) && empty($ivd_bun_prd_key))) {
            unset($this->ivd_bun_prd_key);
        } else {
            $this->ivd_bun_prd_key = $ivd_bun_prd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_download_count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_download_count(): ?int
    {
        return $this->ivd_download_count ?? null;
    }
    /**
     * Set ivd_download_count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_download_count
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_download_count(?int $ivd_download_count = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_download_count) && !(is_int($ivd_download_count) || ctype_digit($ivd_download_count))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_download_count, true), gettype($ivd_download_count)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_download_count) && $ivd_download_count > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_download_count, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_download_count) && $ivd_download_count < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_download_count, true)), __LINE__);
        }
        if (is_null($ivd_download_count) || (is_array($ivd_download_count) && empty($ivd_download_count))) {
            unset($this->ivd_download_count);
        } else {
            $this->ivd_download_count = $ivd_download_count;
        }
        
        return $this;
    }
    /**
     * Get ivd_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_eml_key(): ?string
    {
        return $this->ivd_eml_key ?? null;
    }
    /**
     * Set ivd_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_eml_key(?string $ivd_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_eml_key) && !is_string($ivd_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_eml_key, true), gettype($ivd_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_eml_key, true)), __LINE__);
        }
        if (is_null($ivd_eml_key) || (is_array($ivd_eml_key) && empty($ivd_eml_key))) {
            unset($this->ivd_eml_key);
        } else {
            $this->ivd_eml_key = $ivd_eml_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_package_grouping_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_package_grouping_key(): ?string
    {
        return $this->ivd_package_grouping_key ?? null;
    }
    /**
     * Set ivd_package_grouping_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_package_grouping_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_package_grouping_key(?string $ivd_package_grouping_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_package_grouping_key) && !is_string($ivd_package_grouping_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_package_grouping_key, true), gettype($ivd_package_grouping_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_package_grouping_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_package_grouping_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_package_grouping_key, true)), __LINE__);
        }
        if (is_null($ivd_package_grouping_key) || (is_array($ivd_package_grouping_key) && empty($ivd_package_grouping_key))) {
            unset($this->ivd_package_grouping_key);
        } else {
            $this->ivd_package_grouping_key = $ivd_package_grouping_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_cdd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cdd_key(): ?string
    {
        return $this->ivd_cdd_key ?? null;
    }
    /**
     * Set ivd_cdd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cdd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_cdd_key(?string $ivd_cdd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cdd_key) && !is_string($ivd_cdd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cdd_key, true), gettype($ivd_cdd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cdd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cdd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cdd_key, true)), __LINE__);
        }
        if (is_null($ivd_cdd_key) || (is_array($ivd_cdd_key) && empty($ivd_cdd_key))) {
            unset($this->ivd_cdd_key);
        } else {
            $this->ivd_cdd_key = $ivd_cdd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_download_limit_override value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_download_limit_override(): ?int
    {
        return $this->ivd_download_limit_override ?? null;
    }
    /**
     * Set ivd_download_limit_override value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_download_limit_override
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_download_limit_override(?int $ivd_download_limit_override = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_download_limit_override) && !(is_int($ivd_download_limit_override) || ctype_digit($ivd_download_limit_override))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_download_limit_override, true), gettype($ivd_download_limit_override)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_download_limit_override) && $ivd_download_limit_override > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_download_limit_override, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_download_limit_override) && $ivd_download_limit_override < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_download_limit_override, true)), __LINE__);
        }
        if (is_null($ivd_download_limit_override) || (is_array($ivd_download_limit_override) && empty($ivd_download_limit_override))) {
            unset($this->ivd_download_limit_override);
        } else {
            $this->ivd_download_limit_override = $ivd_download_limit_override;
        }
        
        return $this;
    }
    /**
     * Get ivd_discount_program_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_discount_program_ivd_key(): ?string
    {
        return $this->ivd_discount_program_ivd_key ?? null;
    }
    /**
     * Set ivd_discount_program_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_discount_program_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_discount_program_ivd_key(?string $ivd_discount_program_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_discount_program_ivd_key) && !is_string($ivd_discount_program_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_discount_program_ivd_key, true), gettype($ivd_discount_program_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_discount_program_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_discount_program_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_discount_program_ivd_key, true)), __LINE__);
        }
        if (is_null($ivd_discount_program_ivd_key) || (is_array($ivd_discount_program_ivd_key) && empty($ivd_discount_program_ivd_key))) {
            unset($this->ivd_discount_program_ivd_key);
        } else {
            $this->ivd_discount_program_ivd_key = $ivd_discount_program_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_distributed_liability_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_distributed_liability_flag(): ?string
    {
        return $this->ivd_distributed_liability_flag ?? null;
    }
    /**
     * Set ivd_distributed_liability_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_distributed_liability_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_distributed_liability_flag(?string $ivd_distributed_liability_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_distributed_liability_flag) && !is_string($ivd_distributed_liability_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_distributed_liability_flag, true), gettype($ivd_distributed_liability_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_distributed_liability_flag) && $ivd_distributed_liability_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_distributed_liability_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_distributed_liability_flag) && $ivd_distributed_liability_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_distributed_liability_flag, true)), __LINE__);
        }
        if (is_null($ivd_distributed_liability_flag) || (is_array($ivd_distributed_liability_flag) && empty($ivd_distributed_liability_flag))) {
            unset($this->ivd_distributed_liability_flag);
        } else {
            $this->ivd_distributed_liability_flag = $ivd_distributed_liability_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_download_days_override value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_download_days_override(): ?int
    {
        return $this->ivd_download_days_override ?? null;
    }
    /**
     * Set ivd_download_days_override value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_download_days_override
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_download_days_override(?int $ivd_download_days_override = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_download_days_override) && !(is_int($ivd_download_days_override) || ctype_digit($ivd_download_days_override))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_download_days_override, true), gettype($ivd_download_days_override)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_download_days_override) && $ivd_download_days_override > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_download_days_override, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_download_days_override) && $ivd_download_days_override < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_download_days_override, true)), __LINE__);
        }
        if (is_null($ivd_download_days_override) || (is_array($ivd_download_days_override) && empty($ivd_download_days_override))) {
            unset($this->ivd_download_days_override);
        } else {
            $this->ivd_download_days_override = $ivd_download_days_override;
        }
        
        return $this;
    }
    /**
     * Get ivd_gc_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_gc_number(): ?string
    {
        return $this->ivd_gc_number ?? null;
    }
    /**
     * Set ivd_gc_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_gc_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_gc_number(?string $ivd_gc_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_gc_number) && !is_string($ivd_gc_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_gc_number, true), gettype($ivd_gc_number)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ivd_gc_number) && mb_strlen((string) $ivd_gc_number) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ivd_gc_number)), __LINE__);
        }
        if (is_null($ivd_gc_number) || (is_array($ivd_gc_number) && empty($ivd_gc_number))) {
            unset($this->ivd_gc_number);
        } else {
            $this->ivd_gc_number = $ivd_gc_number;
        }
        
        return $this;
    }
    /**
     * Get ivd_cdt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cdt_key(): ?string
    {
        return $this->ivd_cdt_key ?? null;
    }
    /**
     * Set ivd_cdt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cdt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_cdt_key(?string $ivd_cdt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cdt_key) && !is_string($ivd_cdt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cdt_key, true), gettype($ivd_cdt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_cdt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_cdt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_cdt_key, true)), __LINE__);
        }
        if (is_null($ivd_cdt_key) || (is_array($ivd_cdt_key) && empty($ivd_cdt_key))) {
            unset($this->ivd_cdt_key);
        } else {
            $this->ivd_cdt_key = $ivd_cdt_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_pro_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_pro_key(): ?string
    {
        return $this->ivd_pro_key ?? null;
    }
    /**
     * Set ivd_pro_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_pro_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_pro_key(?string $ivd_pro_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_pro_key) && !is_string($ivd_pro_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_pro_key, true), gettype($ivd_pro_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_pro_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_pro_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_pro_key, true)), __LINE__);
        }
        if (is_null($ivd_pro_key) || (is_array($ivd_pro_key) && empty($ivd_pro_key))) {
            unset($this->ivd_pro_key);
        } else {
            $this->ivd_pro_key = $ivd_pro_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_available_for_cancel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_available_for_cancel(): ?float
    {
        return $this->ivd_available_for_cancel ?? null;
    }
    /**
     * Set ivd_available_for_cancel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_available_for_cancel
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_available_for_cancel(?float $ivd_available_for_cancel = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_available_for_cancel) && !(is_float($ivd_available_for_cancel) || is_numeric($ivd_available_for_cancel))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_available_for_cancel, true), gettype($ivd_available_for_cancel)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_available_for_cancel) && mb_strlen(mb_substr((string) $ivd_available_for_cancel, false !== mb_strpos((string) $ivd_available_for_cancel, '.') ? mb_strpos((string) $ivd_available_for_cancel, '.') + 1 : mb_strlen((string) $ivd_available_for_cancel))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_available_for_cancel, true), mb_strlen(mb_substr((string) $ivd_available_for_cancel, mb_strpos((string) $ivd_available_for_cancel, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_available_for_cancel) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_available_for_cancel)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_available_for_cancel, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_available_for_cancel))), __LINE__);
        }
        if (is_null($ivd_available_for_cancel) || (is_array($ivd_available_for_cancel) && empty($ivd_available_for_cancel))) {
            unset($this->ivd_available_for_cancel);
        } else {
            $this->ivd_available_for_cancel = $ivd_available_for_cancel;
        }
        
        return $this;
    }
    /**
     * Get ivd_available_for_return value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_available_for_return(): ?float
    {
        return $this->ivd_available_for_return ?? null;
    }
    /**
     * Set ivd_available_for_return value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_available_for_return
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_available_for_return(?float $ivd_available_for_return = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_available_for_return) && !(is_float($ivd_available_for_return) || is_numeric($ivd_available_for_return))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_available_for_return, true), gettype($ivd_available_for_return)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_available_for_return) && mb_strlen(mb_substr((string) $ivd_available_for_return, false !== mb_strpos((string) $ivd_available_for_return, '.') ? mb_strpos((string) $ivd_available_for_return, '.') + 1 : mb_strlen((string) $ivd_available_for_return))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_available_for_return, true), mb_strlen(mb_substr((string) $ivd_available_for_return, mb_strpos((string) $ivd_available_for_return, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_available_for_return) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_available_for_return)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_available_for_return, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_available_for_return))), __LINE__);
        }
        if (is_null($ivd_available_for_return) || (is_array($ivd_available_for_return) && empty($ivd_available_for_return))) {
            unset($this->ivd_available_for_return);
        } else {
            $this->ivd_available_for_return = $ivd_available_for_return;
        }
        
        return $this;
    }
    /**
     * Get ivd_balance_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_balance_quantity(): ?float
    {
        return $this->ivd_balance_quantity ?? null;
    }
    /**
     * Set ivd_balance_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_balance_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_balance_quantity(?float $ivd_balance_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_balance_quantity) && !(is_float($ivd_balance_quantity) || is_numeric($ivd_balance_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_balance_quantity, true), gettype($ivd_balance_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_balance_quantity) && mb_strlen(mb_substr((string) $ivd_balance_quantity, false !== mb_strpos((string) $ivd_balance_quantity, '.') ? mb_strpos((string) $ivd_balance_quantity, '.') + 1 : mb_strlen((string) $ivd_balance_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_balance_quantity, true), mb_strlen(mb_substr((string) $ivd_balance_quantity, mb_strpos((string) $ivd_balance_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_balance_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_balance_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_balance_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_balance_quantity))), __LINE__);
        }
        if (is_null($ivd_balance_quantity) || (is_array($ivd_balance_quantity) && empty($ivd_balance_quantity))) {
            unset($this->ivd_balance_quantity);
        } else {
            $this->ivd_balance_quantity = $ivd_balance_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_amount_due value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_amount_due(): ?float
    {
        return $this->ivd_amount_due ?? null;
    }
    /**
     * Set ivd_amount_due value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_amount_due
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_amount_due(?float $ivd_amount_due = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_amount_due) && !(is_float($ivd_amount_due) || is_numeric($ivd_amount_due))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_amount_due, true), gettype($ivd_amount_due)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_amount_due) && mb_strlen(mb_substr((string) $ivd_amount_due, false !== mb_strpos((string) $ivd_amount_due, '.') ? mb_strpos((string) $ivd_amount_due, '.') + 1 : mb_strlen((string) $ivd_amount_due))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_amount_due, true), mb_strlen(mb_substr((string) $ivd_amount_due, mb_strpos((string) $ivd_amount_due, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_amount_due) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_amount_due)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_amount_due, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_amount_due))), __LINE__);
        }
        if (is_null($ivd_amount_due) || (is_array($ivd_amount_due) && empty($ivd_amount_due))) {
            unset($this->ivd_amount_due);
        } else {
            $this->ivd_amount_due = $ivd_amount_due;
        }
        
        return $this;
    }
    /**
     * Get ivd_automatically_added value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_automatically_added(): ?string
    {
        return $this->ivd_automatically_added ?? null;
    }
    /**
     * Set ivd_automatically_added value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_automatically_added
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_automatically_added(?string $ivd_automatically_added = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_automatically_added) && !is_string($ivd_automatically_added)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_automatically_added, true), gettype($ivd_automatically_added)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_automatically_added) && $ivd_automatically_added > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_automatically_added, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_automatically_added) && $ivd_automatically_added < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_automatically_added, true)), __LINE__);
        }
        if (is_null($ivd_automatically_added) || (is_array($ivd_automatically_added) && empty($ivd_automatically_added))) {
            unset($this->ivd_automatically_added);
        } else {
            $this->ivd_automatically_added = $ivd_automatically_added;
        }
        
        return $this;
    }
    /**
     * Get ivd_createorder_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_createorder_flag(): ?string
    {
        return $this->ivd_createorder_flag ?? null;
    }
    /**
     * Set ivd_createorder_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_createorder_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_createorder_flag(?string $ivd_createorder_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_createorder_flag) && !is_string($ivd_createorder_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_createorder_flag, true), gettype($ivd_createorder_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_createorder_flag) && $ivd_createorder_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_createorder_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_createorder_flag) && $ivd_createorder_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_createorder_flag, true)), __LINE__);
        }
        if (is_null($ivd_createorder_flag) || (is_array($ivd_createorder_flag) && empty($ivd_createorder_flag))) {
            unset($this->ivd_createorder_flag);
        } else {
            $this->ivd_createorder_flag = $ivd_createorder_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_deferral_total_returned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_deferral_total_returned(): ?float
    {
        return $this->ivd_deferral_total_returned ?? null;
    }
    /**
     * Set ivd_deferral_total_returned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_deferral_total_returned
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_deferral_total_returned(?float $ivd_deferral_total_returned = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_deferral_total_returned) && !(is_float($ivd_deferral_total_returned) || is_numeric($ivd_deferral_total_returned))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_deferral_total_returned, true), gettype($ivd_deferral_total_returned)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_deferral_total_returned) && mb_strlen(mb_substr((string) $ivd_deferral_total_returned, false !== mb_strpos((string) $ivd_deferral_total_returned, '.') ? mb_strpos((string) $ivd_deferral_total_returned, '.') + 1 : mb_strlen((string) $ivd_deferral_total_returned))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_deferral_total_returned, true), mb_strlen(mb_substr((string) $ivd_deferral_total_returned, mb_strpos((string) $ivd_deferral_total_returned, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_deferral_total_returned) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_deferral_total_returned)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_deferral_total_returned, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_deferral_total_returned))), __LINE__);
        }
        if (is_null($ivd_deferral_total_returned) || (is_array($ivd_deferral_total_returned) && empty($ivd_deferral_total_returned))) {
            unset($this->ivd_deferral_total_returned);
        } else {
            $this->ivd_deferral_total_returned = $ivd_deferral_total_returned;
        }
        
        return $this;
    }
    /**
     * Get ivd_lineamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_lineamount(): ?float
    {
        return $this->ivd_lineamount ?? null;
    }
    /**
     * Set ivd_lineamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_lineamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_lineamount(?float $ivd_lineamount = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_lineamount) && !(is_float($ivd_lineamount) || is_numeric($ivd_lineamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_lineamount, true), gettype($ivd_lineamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_lineamount) && mb_strlen(mb_substr((string) $ivd_lineamount, false !== mb_strpos((string) $ivd_lineamount, '.') ? mb_strpos((string) $ivd_lineamount, '.') + 1 : mb_strlen((string) $ivd_lineamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_lineamount, true), mb_strlen(mb_substr((string) $ivd_lineamount, mb_strpos((string) $ivd_lineamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_lineamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_lineamount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_lineamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_lineamount))), __LINE__);
        }
        if (is_null($ivd_lineamount) || (is_array($ivd_lineamount) && empty($ivd_lineamount))) {
            unset($this->ivd_lineamount);
        } else {
            $this->ivd_lineamount = $ivd_lineamount;
        }
        
        return $this;
    }
    /**
     * Get ivd_lineamount_no_discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_lineamount_no_discount(): ?float
    {
        return $this->ivd_lineamount_no_discount ?? null;
    }
    /**
     * Set ivd_lineamount_no_discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_lineamount_no_discount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_lineamount_no_discount(?float $ivd_lineamount_no_discount = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_lineamount_no_discount) && !(is_float($ivd_lineamount_no_discount) || is_numeric($ivd_lineamount_no_discount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_lineamount_no_discount, true), gettype($ivd_lineamount_no_discount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_lineamount_no_discount) && mb_strlen(mb_substr((string) $ivd_lineamount_no_discount, false !== mb_strpos((string) $ivd_lineamount_no_discount, '.') ? mb_strpos((string) $ivd_lineamount_no_discount, '.') + 1 : mb_strlen((string) $ivd_lineamount_no_discount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_lineamount_no_discount, true), mb_strlen(mb_substr((string) $ivd_lineamount_no_discount, mb_strpos((string) $ivd_lineamount_no_discount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_lineamount_no_discount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_lineamount_no_discount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_lineamount_no_discount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_lineamount_no_discount))), __LINE__);
        }
        if (is_null($ivd_lineamount_no_discount) || (is_array($ivd_lineamount_no_discount) && empty($ivd_lineamount_no_discount))) {
            unset($this->ivd_lineamount_no_discount);
        } else {
            $this->ivd_lineamount_no_discount = $ivd_lineamount_no_discount;
        }
        
        return $this;
    }
    /**
     * Get ivd_originallineamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_originallineamount(): ?float
    {
        return $this->ivd_originallineamount ?? null;
    }
    /**
     * Set ivd_originallineamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_originallineamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_originallineamount(?float $ivd_originallineamount = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_originallineamount) && !(is_float($ivd_originallineamount) || is_numeric($ivd_originallineamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_originallineamount, true), gettype($ivd_originallineamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_originallineamount) && mb_strlen(mb_substr((string) $ivd_originallineamount, false !== mb_strpos((string) $ivd_originallineamount, '.') ? mb_strpos((string) $ivd_originallineamount, '.') + 1 : mb_strlen((string) $ivd_originallineamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_originallineamount, true), mb_strlen(mb_substr((string) $ivd_originallineamount, mb_strpos((string) $ivd_originallineamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_originallineamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_originallineamount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_originallineamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_originallineamount))), __LINE__);
        }
        if (is_null($ivd_originallineamount) || (is_array($ivd_originallineamount) && empty($ivd_originallineamount))) {
            unset($this->ivd_originallineamount);
        } else {
            $this->ivd_originallineamount = $ivd_originallineamount;
        }
        
        return $this;
    }
    /**
     * Get ivd_restock_fee_calculated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_restock_fee_calculated(): ?float
    {
        return $this->ivd_restock_fee_calculated ?? null;
    }
    /**
     * Set ivd_restock_fee_calculated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_restock_fee_calculated
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_restock_fee_calculated(?float $ivd_restock_fee_calculated = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_restock_fee_calculated) && !(is_float($ivd_restock_fee_calculated) || is_numeric($ivd_restock_fee_calculated))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_restock_fee_calculated, true), gettype($ivd_restock_fee_calculated)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_restock_fee_calculated) && mb_strlen(mb_substr((string) $ivd_restock_fee_calculated, false !== mb_strpos((string) $ivd_restock_fee_calculated, '.') ? mb_strpos((string) $ivd_restock_fee_calculated, '.') + 1 : mb_strlen((string) $ivd_restock_fee_calculated))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_restock_fee_calculated, true), mb_strlen(mb_substr((string) $ivd_restock_fee_calculated, mb_strpos((string) $ivd_restock_fee_calculated, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_restock_fee_calculated) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_restock_fee_calculated)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_restock_fee_calculated, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_restock_fee_calculated))), __LINE__);
        }
        if (is_null($ivd_restock_fee_calculated) || (is_array($ivd_restock_fee_calculated) && empty($ivd_restock_fee_calculated))) {
            unset($this->ivd_restock_fee_calculated);
        } else {
            $this->ivd_restock_fee_calculated = $ivd_restock_fee_calculated;
        }
        
        return $this;
    }
    /**
     * Get ivd_createinvoice_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_createinvoice_flag(): ?string
    {
        return $this->ivd_createinvoice_flag ?? null;
    }
    /**
     * Set ivd_createinvoice_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_createinvoice_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_createinvoice_flag(?string $ivd_createinvoice_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_createinvoice_flag) && !is_string($ivd_createinvoice_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_createinvoice_flag, true), gettype($ivd_createinvoice_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_createinvoice_flag) && $ivd_createinvoice_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_createinvoice_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_createinvoice_flag) && $ivd_createinvoice_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_createinvoice_flag, true)), __LINE__);
        }
        if (is_null($ivd_createinvoice_flag) || (is_array($ivd_createinvoice_flag) && empty($ivd_createinvoice_flag))) {
            unset($this->ivd_createinvoice_flag);
        } else {
            $this->ivd_createinvoice_flag = $ivd_createinvoice_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_linebalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_linebalance(): ?float
    {
        return $this->ivd_linebalance ?? null;
    }
    /**
     * Set ivd_linebalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_linebalance
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_linebalance(?float $ivd_linebalance = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_linebalance) && !(is_float($ivd_linebalance) || is_numeric($ivd_linebalance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_linebalance, true), gettype($ivd_linebalance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_linebalance) && mb_strlen(mb_substr((string) $ivd_linebalance, false !== mb_strpos((string) $ivd_linebalance, '.') ? mb_strpos((string) $ivd_linebalance, '.') + 1 : mb_strlen((string) $ivd_linebalance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_linebalance, true), mb_strlen(mb_substr((string) $ivd_linebalance, mb_strpos((string) $ivd_linebalance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_linebalance) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_linebalance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_linebalance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_linebalance))), __LINE__);
        }
        if (is_null($ivd_linebalance) || (is_array($ivd_linebalance) && empty($ivd_linebalance))) {
            unset($this->ivd_linebalance);
        } else {
            $this->ivd_linebalance = $ivd_linebalance;
        }
        
        return $this;
    }
    /**
     * Get ivd_net_amount_due value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_net_amount_due(): ?float
    {
        return $this->ivd_net_amount_due ?? null;
    }
    /**
     * Set ivd_net_amount_due value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_net_amount_due
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_net_amount_due(?float $ivd_net_amount_due = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_net_amount_due) && !(is_float($ivd_net_amount_due) || is_numeric($ivd_net_amount_due))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_net_amount_due, true), gettype($ivd_net_amount_due)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_net_amount_due) && mb_strlen(mb_substr((string) $ivd_net_amount_due, false !== mb_strpos((string) $ivd_net_amount_due, '.') ? mb_strpos((string) $ivd_net_amount_due, '.') + 1 : mb_strlen((string) $ivd_net_amount_due))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_net_amount_due, true), mb_strlen(mb_substr((string) $ivd_net_amount_due, mb_strpos((string) $ivd_net_amount_due, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_net_amount_due) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_net_amount_due)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_net_amount_due, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_net_amount_due))), __LINE__);
        }
        if (is_null($ivd_net_amount_due) || (is_array($ivd_net_amount_due) && empty($ivd_net_amount_due))) {
            unset($this->ivd_net_amount_due);
        } else {
            $this->ivd_net_amount_due = $ivd_net_amount_due;
        }
        
        return $this;
    }
    /**
     * Get ivd_payamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_payamount(): ?float
    {
        return $this->ivd_payamount ?? null;
    }
    /**
     * Set ivd_payamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_payamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_payamount(?float $ivd_payamount = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_payamount) && !(is_float($ivd_payamount) || is_numeric($ivd_payamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_payamount, true), gettype($ivd_payamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_payamount) && mb_strlen(mb_substr((string) $ivd_payamount, false !== mb_strpos((string) $ivd_payamount, '.') ? mb_strpos((string) $ivd_payamount, '.') + 1 : mb_strlen((string) $ivd_payamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_payamount, true), mb_strlen(mb_substr((string) $ivd_payamount, mb_strpos((string) $ivd_payamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_payamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_payamount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_payamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_payamount))), __LINE__);
        }
        if (is_null($ivd_payamount) || (is_array($ivd_payamount) && empty($ivd_payamount))) {
            unset($this->ivd_payamount);
        } else {
            $this->ivd_payamount = $ivd_payamount;
        }
        
        return $this;
    }
    /**
     * Get ivd_payamount_noreturn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_payamount_noreturn(): ?float
    {
        return $this->ivd_payamount_noreturn ?? null;
    }
    /**
     * Set ivd_payamount_noreturn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_payamount_noreturn
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_payamount_noreturn(?float $ivd_payamount_noreturn = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_payamount_noreturn) && !(is_float($ivd_payamount_noreturn) || is_numeric($ivd_payamount_noreturn))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_payamount_noreturn, true), gettype($ivd_payamount_noreturn)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_payamount_noreturn) && mb_strlen(mb_substr((string) $ivd_payamount_noreturn, false !== mb_strpos((string) $ivd_payamount_noreturn, '.') ? mb_strpos((string) $ivd_payamount_noreturn, '.') + 1 : mb_strlen((string) $ivd_payamount_noreturn))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_payamount_noreturn, true), mb_strlen(mb_substr((string) $ivd_payamount_noreturn, mb_strpos((string) $ivd_payamount_noreturn, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_payamount_noreturn) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_payamount_noreturn)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_payamount_noreturn, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_payamount_noreturn))), __LINE__);
        }
        if (is_null($ivd_payamount_noreturn) || (is_array($ivd_payamount_noreturn) && empty($ivd_payamount_noreturn))) {
            unset($this->ivd_payamount_noreturn);
        } else {
            $this->ivd_payamount_noreturn = $ivd_payamount_noreturn;
        }
        
        return $this;
    }
    /**
     * Get ivd_cancelled_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_cancelled_quantity(): ?float
    {
        return $this->ivd_cancelled_quantity ?? null;
    }
    /**
     * Set ivd_cancelled_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_cancelled_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_cancelled_quantity(?float $ivd_cancelled_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_cancelled_quantity) && !(is_float($ivd_cancelled_quantity) || is_numeric($ivd_cancelled_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_cancelled_quantity, true), gettype($ivd_cancelled_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_cancelled_quantity) && mb_strlen(mb_substr((string) $ivd_cancelled_quantity, false !== mb_strpos((string) $ivd_cancelled_quantity, '.') ? mb_strpos((string) $ivd_cancelled_quantity, '.') + 1 : mb_strlen((string) $ivd_cancelled_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_cancelled_quantity, true), mb_strlen(mb_substr((string) $ivd_cancelled_quantity, mb_strpos((string) $ivd_cancelled_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_cancelled_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_cancelled_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_cancelled_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_cancelled_quantity))), __LINE__);
        }
        if (is_null($ivd_cancelled_quantity) || (is_array($ivd_cancelled_quantity) && empty($ivd_cancelled_quantity))) {
            unset($this->ivd_cancelled_quantity);
        } else {
            $this->ivd_cancelled_quantity = $ivd_cancelled_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_default_credit_dollar_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_default_credit_dollar_amount(): ?float
    {
        return $this->ivd_default_credit_dollar_amount ?? null;
    }
    /**
     * Set ivd_default_credit_dollar_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_default_credit_dollar_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_default_credit_dollar_amount(?float $ivd_default_credit_dollar_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_default_credit_dollar_amount) && !(is_float($ivd_default_credit_dollar_amount) || is_numeric($ivd_default_credit_dollar_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_default_credit_dollar_amount, true), gettype($ivd_default_credit_dollar_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_default_credit_dollar_amount) && mb_strlen(mb_substr((string) $ivd_default_credit_dollar_amount, false !== mb_strpos((string) $ivd_default_credit_dollar_amount, '.') ? mb_strpos((string) $ivd_default_credit_dollar_amount, '.') + 1 : mb_strlen((string) $ivd_default_credit_dollar_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_default_credit_dollar_amount, true), mb_strlen(mb_substr((string) $ivd_default_credit_dollar_amount, mb_strpos((string) $ivd_default_credit_dollar_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_default_credit_dollar_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_default_credit_dollar_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_default_credit_dollar_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_default_credit_dollar_amount))), __LINE__);
        }
        if (is_null($ivd_default_credit_dollar_amount) || (is_array($ivd_default_credit_dollar_amount) && empty($ivd_default_credit_dollar_amount))) {
            unset($this->ivd_default_credit_dollar_amount);
        } else {
            $this->ivd_default_credit_dollar_amount = $ivd_default_credit_dollar_amount;
        }
        
        return $this;
    }
    /**
     * Get ivd_deferral_number_periods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_deferral_number_periods(): ?float
    {
        return $this->ivd_deferral_number_periods ?? null;
    }
    /**
     * Set ivd_deferral_number_periods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_deferral_number_periods
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_deferral_number_periods(?float $ivd_deferral_number_periods = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_deferral_number_periods) && !(is_float($ivd_deferral_number_periods) || is_numeric($ivd_deferral_number_periods))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_deferral_number_periods, true), gettype($ivd_deferral_number_periods)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_deferral_number_periods) && mb_strlen(mb_substr((string) $ivd_deferral_number_periods, false !== mb_strpos((string) $ivd_deferral_number_periods, '.') ? mb_strpos((string) $ivd_deferral_number_periods, '.') + 1 : mb_strlen((string) $ivd_deferral_number_periods))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_deferral_number_periods, true), mb_strlen(mb_substr((string) $ivd_deferral_number_periods, mb_strpos((string) $ivd_deferral_number_periods, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_deferral_number_periods) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_deferral_number_periods)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_deferral_number_periods, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_deferral_number_periods))), __LINE__);
        }
        if (is_null($ivd_deferral_number_periods) || (is_array($ivd_deferral_number_periods) && empty($ivd_deferral_number_periods))) {
            unset($this->ivd_deferral_number_periods);
        } else {
            $this->ivd_deferral_number_periods = $ivd_deferral_number_periods;
        }
        
        return $this;
    }
    /**
     * Get ivd_deferral_number_periods_recognized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_deferral_number_periods_recognized(): ?float
    {
        return $this->ivd_deferral_number_periods_recognized ?? null;
    }
    /**
     * Set ivd_deferral_number_periods_recognized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_deferral_number_periods_recognized
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_deferral_number_periods_recognized(?float $ivd_deferral_number_periods_recognized = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_deferral_number_periods_recognized) && !(is_float($ivd_deferral_number_periods_recognized) || is_numeric($ivd_deferral_number_periods_recognized))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_deferral_number_periods_recognized, true), gettype($ivd_deferral_number_periods_recognized)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_deferral_number_periods_recognized) && mb_strlen(mb_substr((string) $ivd_deferral_number_periods_recognized, false !== mb_strpos((string) $ivd_deferral_number_periods_recognized, '.') ? mb_strpos((string) $ivd_deferral_number_periods_recognized, '.') + 1 : mb_strlen((string) $ivd_deferral_number_periods_recognized))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_deferral_number_periods_recognized, true), mb_strlen(mb_substr((string) $ivd_deferral_number_periods_recognized, mb_strpos((string) $ivd_deferral_number_periods_recognized, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_deferral_number_periods_recognized) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_deferral_number_periods_recognized)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_deferral_number_periods_recognized, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_deferral_number_periods_recognized))), __LINE__);
        }
        if (is_null($ivd_deferral_number_periods_recognized) || (is_array($ivd_deferral_number_periods_recognized) && empty($ivd_deferral_number_periods_recognized))) {
            unset($this->ivd_deferral_number_periods_recognized);
        } else {
            $this->ivd_deferral_number_periods_recognized = $ivd_deferral_number_periods_recognized;
        }
        
        return $this;
    }
    /**
     * Get ivd_deferral_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_deferral_price(): ?float
    {
        return $this->ivd_deferral_price ?? null;
    }
    /**
     * Set ivd_deferral_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_deferral_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_deferral_price(?float $ivd_deferral_price = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_deferral_price) && !(is_float($ivd_deferral_price) || is_numeric($ivd_deferral_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_deferral_price, true), gettype($ivd_deferral_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_deferral_price) && mb_strlen(mb_substr((string) $ivd_deferral_price, false !== mb_strpos((string) $ivd_deferral_price, '.') ? mb_strpos((string) $ivd_deferral_price, '.') + 1 : mb_strlen((string) $ivd_deferral_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_deferral_price, true), mb_strlen(mb_substr((string) $ivd_deferral_price, mb_strpos((string) $ivd_deferral_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_deferral_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_deferral_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_deferral_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_deferral_price))), __LINE__);
        }
        if (is_null($ivd_deferral_price) || (is_array($ivd_deferral_price) && empty($ivd_deferral_price))) {
            unset($this->ivd_deferral_price);
        } else {
            $this->ivd_deferral_price = $ivd_deferral_price;
        }
        
        return $this;
    }
    /**
     * Get ivd_DeferralBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_DeferralBalance(): ?float
    {
        return $this->ivd_DeferralBalance ?? null;
    }
    /**
     * Set ivd_DeferralBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_DeferralBalance
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_DeferralBalance(?float $ivd_DeferralBalance = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_DeferralBalance) && !(is_float($ivd_DeferralBalance) || is_numeric($ivd_DeferralBalance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_DeferralBalance, true), gettype($ivd_DeferralBalance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_DeferralBalance) && mb_strlen(mb_substr((string) $ivd_DeferralBalance, false !== mb_strpos((string) $ivd_DeferralBalance, '.') ? mb_strpos((string) $ivd_DeferralBalance, '.') + 1 : mb_strlen((string) $ivd_DeferralBalance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_DeferralBalance, true), mb_strlen(mb_substr((string) $ivd_DeferralBalance, mb_strpos((string) $ivd_DeferralBalance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_DeferralBalance) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_DeferralBalance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_DeferralBalance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_DeferralBalance))), __LINE__);
        }
        if (is_null($ivd_DeferralBalance) || (is_array($ivd_DeferralBalance) && empty($ivd_DeferralBalance))) {
            unset($this->ivd_DeferralBalance);
        } else {
            $this->ivd_DeferralBalance = $ivd_DeferralBalance;
        }
        
        return $this;
    }
    /**
     * Get ivd_minimum_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_minimum_quantity(): ?float
    {
        return $this->ivd_minimum_quantity ?? null;
    }
    /**
     * Set ivd_minimum_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_minimum_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_minimum_quantity(?float $ivd_minimum_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_minimum_quantity) && !(is_float($ivd_minimum_quantity) || is_numeric($ivd_minimum_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_minimum_quantity, true), gettype($ivd_minimum_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_minimum_quantity) && mb_strlen(mb_substr((string) $ivd_minimum_quantity, false !== mb_strpos((string) $ivd_minimum_quantity, '.') ? mb_strpos((string) $ivd_minimum_quantity, '.') + 1 : mb_strlen((string) $ivd_minimum_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_minimum_quantity, true), mb_strlen(mb_substr((string) $ivd_minimum_quantity, mb_strpos((string) $ivd_minimum_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_minimum_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_minimum_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_minimum_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_minimum_quantity))), __LINE__);
        }
        if (is_null($ivd_minimum_quantity) || (is_array($ivd_minimum_quantity) && empty($ivd_minimum_quantity))) {
            unset($this->ivd_minimum_quantity);
        } else {
            $this->ivd_minimum_quantity = $ivd_minimum_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_reduce_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_reduce_quantity(): ?float
    {
        return $this->ivd_reduce_quantity ?? null;
    }
    /**
     * Set ivd_reduce_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_reduce_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_reduce_quantity(?float $ivd_reduce_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_reduce_quantity) && !(is_float($ivd_reduce_quantity) || is_numeric($ivd_reduce_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_reduce_quantity, true), gettype($ivd_reduce_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_reduce_quantity) && mb_strlen(mb_substr((string) $ivd_reduce_quantity, false !== mb_strpos((string) $ivd_reduce_quantity, '.') ? mb_strpos((string) $ivd_reduce_quantity, '.') + 1 : mb_strlen((string) $ivd_reduce_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_reduce_quantity, true), mb_strlen(mb_substr((string) $ivd_reduce_quantity, mb_strpos((string) $ivd_reduce_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_reduce_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_reduce_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_reduce_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_reduce_quantity))), __LINE__);
        }
        if (is_null($ivd_reduce_quantity) || (is_array($ivd_reduce_quantity) && empty($ivd_reduce_quantity))) {
            unset($this->ivd_reduce_quantity);
        } else {
            $this->ivd_reduce_quantity = $ivd_reduce_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_return_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_return_quantity(): ?float
    {
        return $this->ivd_return_quantity ?? null;
    }
    /**
     * Set ivd_return_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_return_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_return_quantity(?float $ivd_return_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_return_quantity) && !(is_float($ivd_return_quantity) || is_numeric($ivd_return_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_return_quantity, true), gettype($ivd_return_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_return_quantity) && mb_strlen(mb_substr((string) $ivd_return_quantity, false !== mb_strpos((string) $ivd_return_quantity, '.') ? mb_strpos((string) $ivd_return_quantity, '.') + 1 : mb_strlen((string) $ivd_return_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_return_quantity, true), mb_strlen(mb_substr((string) $ivd_return_quantity, mb_strpos((string) $ivd_return_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_return_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_return_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_return_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_return_quantity))), __LINE__);
        }
        if (is_null($ivd_return_quantity) || (is_array($ivd_return_quantity) && empty($ivd_return_quantity))) {
            unset($this->ivd_return_quantity);
        } else {
            $this->ivd_return_quantity = $ivd_return_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_returned_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_returned_quantity(): ?float
    {
        return $this->ivd_returned_quantity ?? null;
    }
    /**
     * Set ivd_returned_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_returned_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_returned_quantity(?float $ivd_returned_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_returned_quantity) && !(is_float($ivd_returned_quantity) || is_numeric($ivd_returned_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_returned_quantity, true), gettype($ivd_returned_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_returned_quantity) && mb_strlen(mb_substr((string) $ivd_returned_quantity, false !== mb_strpos((string) $ivd_returned_quantity, '.') ? mb_strpos((string) $ivd_returned_quantity, '.') + 1 : mb_strlen((string) $ivd_returned_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_returned_quantity, true), mb_strlen(mb_substr((string) $ivd_returned_quantity, mb_strpos((string) $ivd_returned_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_returned_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_returned_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_returned_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_returned_quantity))), __LINE__);
        }
        if (is_null($ivd_returned_quantity) || (is_array($ivd_returned_quantity) && empty($ivd_returned_quantity))) {
            unset($this->ivd_returned_quantity);
        } else {
            $this->ivd_returned_quantity = $ivd_returned_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_total_recognized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_total_recognized(): ?float
    {
        return $this->ivd_total_recognized ?? null;
    }
    /**
     * Set ivd_total_recognized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_total_recognized
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_total_recognized(?float $ivd_total_recognized = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_total_recognized) && !(is_float($ivd_total_recognized) || is_numeric($ivd_total_recognized))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_total_recognized, true), gettype($ivd_total_recognized)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_total_recognized) && mb_strlen(mb_substr((string) $ivd_total_recognized, false !== mb_strpos((string) $ivd_total_recognized, '.') ? mb_strpos((string) $ivd_total_recognized, '.') + 1 : mb_strlen((string) $ivd_total_recognized))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_total_recognized, true), mb_strlen(mb_substr((string) $ivd_total_recognized, mb_strpos((string) $ivd_total_recognized, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_total_recognized) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_total_recognized)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_total_recognized, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_total_recognized))), __LINE__);
        }
        if (is_null($ivd_total_recognized) || (is_array($ivd_total_recognized) && empty($ivd_total_recognized))) {
            unset($this->ivd_total_recognized);
        } else {
            $this->ivd_total_recognized = $ivd_total_recognized;
        }
        
        return $this;
    }
    /**
     * Get ivd_writeoff_dollar_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_writeoff_dollar_amount(): ?float
    {
        return $this->ivd_writeoff_dollar_amount ?? null;
    }
    /**
     * Set ivd_writeoff_dollar_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_writeoff_dollar_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_writeoff_dollar_amount(?float $ivd_writeoff_dollar_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_writeoff_dollar_amount) && !(is_float($ivd_writeoff_dollar_amount) || is_numeric($ivd_writeoff_dollar_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_writeoff_dollar_amount, true), gettype($ivd_writeoff_dollar_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_writeoff_dollar_amount) && mb_strlen(mb_substr((string) $ivd_writeoff_dollar_amount, false !== mb_strpos((string) $ivd_writeoff_dollar_amount, '.') ? mb_strpos((string) $ivd_writeoff_dollar_amount, '.') + 1 : mb_strlen((string) $ivd_writeoff_dollar_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_writeoff_dollar_amount, true), mb_strlen(mb_substr((string) $ivd_writeoff_dollar_amount, mb_strpos((string) $ivd_writeoff_dollar_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_writeoff_dollar_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_writeoff_dollar_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_writeoff_dollar_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_writeoff_dollar_amount))), __LINE__);
        }
        if (is_null($ivd_writeoff_dollar_amount) || (is_array($ivd_writeoff_dollar_amount) && empty($ivd_writeoff_dollar_amount))) {
            unset($this->ivd_writeoff_dollar_amount);
        } else {
            $this->ivd_writeoff_dollar_amount = $ivd_writeoff_dollar_amount;
        }
        
        return $this;
    }
    /**
     * Get ivd_allow_change_qty_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_allow_change_qty_flag(): ?string
    {
        return $this->ivd_allow_change_qty_flag ?? null;
    }
    /**
     * Set ivd_allow_change_qty_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_allow_change_qty_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_allow_change_qty_flag(?string $ivd_allow_change_qty_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_allow_change_qty_flag) && !is_string($ivd_allow_change_qty_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_allow_change_qty_flag, true), gettype($ivd_allow_change_qty_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_allow_change_qty_flag) && $ivd_allow_change_qty_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_allow_change_qty_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_allow_change_qty_flag) && $ivd_allow_change_qty_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_allow_change_qty_flag, true)), __LINE__);
        }
        if (is_null($ivd_allow_change_qty_flag) || (is_array($ivd_allow_change_qty_flag) && empty($ivd_allow_change_qty_flag))) {
            unset($this->ivd_allow_change_qty_flag);
        } else {
            $this->ivd_allow_change_qty_flag = $ivd_allow_change_qty_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_credit_dollar_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_credit_dollar_amount(): ?float
    {
        return $this->ivd_credit_dollar_amount ?? null;
    }
    /**
     * Set ivd_credit_dollar_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_credit_dollar_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_credit_dollar_amount(?float $ivd_credit_dollar_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_credit_dollar_amount) && !(is_float($ivd_credit_dollar_amount) || is_numeric($ivd_credit_dollar_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_credit_dollar_amount, true), gettype($ivd_credit_dollar_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_credit_dollar_amount) && mb_strlen(mb_substr((string) $ivd_credit_dollar_amount, false !== mb_strpos((string) $ivd_credit_dollar_amount, '.') ? mb_strpos((string) $ivd_credit_dollar_amount, '.') + 1 : mb_strlen((string) $ivd_credit_dollar_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_credit_dollar_amount, true), mb_strlen(mb_substr((string) $ivd_credit_dollar_amount, mb_strpos((string) $ivd_credit_dollar_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_credit_dollar_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_credit_dollar_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_credit_dollar_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_credit_dollar_amount))), __LINE__);
        }
        if (is_null($ivd_credit_dollar_amount) || (is_array($ivd_credit_dollar_amount) && empty($ivd_credit_dollar_amount))) {
            unset($this->ivd_credit_dollar_amount);
        } else {
            $this->ivd_credit_dollar_amount = $ivd_credit_dollar_amount;
        }
        
        return $this;
    }
    /**
     * Get ivd_pkg_optional value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_pkg_optional(): ?string
    {
        return $this->ivd_pkg_optional ?? null;
    }
    /**
     * Set ivd_pkg_optional value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_pkg_optional
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_pkg_optional(?string $ivd_pkg_optional = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_pkg_optional) && !is_string($ivd_pkg_optional)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_pkg_optional, true), gettype($ivd_pkg_optional)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_pkg_optional) && $ivd_pkg_optional > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_pkg_optional, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_pkg_optional) && $ivd_pkg_optional < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_pkg_optional, true)), __LINE__);
        }
        if (is_null($ivd_pkg_optional) || (is_array($ivd_pkg_optional) && empty($ivd_pkg_optional))) {
            unset($this->ivd_pkg_optional);
        } else {
            $this->ivd_pkg_optional = $ivd_pkg_optional;
        }
        
        return $this;
    }
    /**
     * Get ivd_allow_change_price_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_allow_change_price_flag(): ?string
    {
        return $this->ivd_allow_change_price_flag ?? null;
    }
    /**
     * Set ivd_allow_change_price_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_allow_change_price_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_allow_change_price_flag(?string $ivd_allow_change_price_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_allow_change_price_flag) && !is_string($ivd_allow_change_price_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_allow_change_price_flag, true), gettype($ivd_allow_change_price_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_allow_change_price_flag) && $ivd_allow_change_price_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_allow_change_price_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_allow_change_price_flag) && $ivd_allow_change_price_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_allow_change_price_flag, true)), __LINE__);
        }
        if (is_null($ivd_allow_change_price_flag) || (is_array($ivd_allow_change_price_flag) && empty($ivd_allow_change_price_flag))) {
            unset($this->ivd_allow_change_price_flag);
        } else {
            $this->ivd_allow_change_price_flag = $ivd_allow_change_price_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_cancel_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_cancel_quantity(): ?float
    {
        return $this->ivd_cancel_quantity ?? null;
    }
    /**
     * Set ivd_cancel_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_cancel_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_cancel_quantity(?float $ivd_cancel_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_cancel_quantity) && !(is_float($ivd_cancel_quantity) || is_numeric($ivd_cancel_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_cancel_quantity, true), gettype($ivd_cancel_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_cancel_quantity) && mb_strlen(mb_substr((string) $ivd_cancel_quantity, false !== mb_strpos((string) $ivd_cancel_quantity, '.') ? mb_strpos((string) $ivd_cancel_quantity, '.') + 1 : mb_strlen((string) $ivd_cancel_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_cancel_quantity, true), mb_strlen(mb_substr((string) $ivd_cancel_quantity, mb_strpos((string) $ivd_cancel_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_cancel_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_cancel_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_cancel_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_cancel_quantity))), __LINE__);
        }
        if (is_null($ivd_cancel_quantity) || (is_array($ivd_cancel_quantity) && empty($ivd_cancel_quantity))) {
            unset($this->ivd_cancel_quantity);
        } else {
            $this->ivd_cancel_quantity = $ivd_cancel_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_auto_refund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_auto_refund(): ?string
    {
        return $this->ivd_auto_refund ?? null;
    }
    /**
     * Set ivd_auto_refund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_auto_refund
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_auto_refund(?string $ivd_auto_refund = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_auto_refund) && !is_string($ivd_auto_refund)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_auto_refund, true), gettype($ivd_auto_refund)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_auto_refund) && $ivd_auto_refund > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_auto_refund, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_auto_refund) && $ivd_auto_refund < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_auto_refund, true)), __LINE__);
        }
        if (is_null($ivd_auto_refund) || (is_array($ivd_auto_refund) && empty($ivd_auto_refund))) {
            unset($this->ivd_auto_refund);
        } else {
            $this->ivd_auto_refund = $ivd_auto_refund;
        }
        
        return $this;
    }
    /**
     * Get ivd_NewBatch_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_NewBatch_key(): ?string
    {
        return $this->ivd_NewBatch_key ?? null;
    }
    /**
     * Set ivd_NewBatch_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_NewBatch_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_NewBatch_key(?string $ivd_NewBatch_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_NewBatch_key) && !is_string($ivd_NewBatch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_NewBatch_key, true), gettype($ivd_NewBatch_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_NewBatch_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_NewBatch_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_NewBatch_key, true)), __LINE__);
        }
        if (is_null($ivd_NewBatch_key) || (is_array($ivd_NewBatch_key) && empty($ivd_NewBatch_key))) {
            unset($this->ivd_NewBatch_key);
        } else {
            $this->ivd_NewBatch_key = $ivd_NewBatch_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_refund_credit_account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_refund_credit_account(): ?string
    {
        return $this->ivd_refund_credit_account ?? null;
    }
    /**
     * Set ivd_refund_credit_account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_refund_credit_account
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_refund_credit_account(?string $ivd_refund_credit_account = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_refund_credit_account) && !is_string($ivd_refund_credit_account)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_refund_credit_account, true), gettype($ivd_refund_credit_account)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_refund_credit_account) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_refund_credit_account)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_refund_credit_account, true)), __LINE__);
        }
        if (is_null($ivd_refund_credit_account) || (is_array($ivd_refund_credit_account) && empty($ivd_refund_credit_account))) {
            unset($this->ivd_refund_credit_account);
        } else {
            $this->ivd_refund_credit_account = $ivd_refund_credit_account;
        }
        
        return $this;
    }
    /**
     * Get ivd_ship_atc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ship_atc_key(): ?string
    {
        return $this->ivd_ship_atc_key ?? null;
    }
    /**
     * Set ivd_ship_atc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ship_atc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_ship_atc_key(?string $ivd_ship_atc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ship_atc_key) && !is_string($ivd_ship_atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ship_atc_key, true), gettype($ivd_ship_atc_key)), __LINE__);
        }
        if (is_null($ivd_ship_atc_key) || (is_array($ivd_ship_atc_key) && empty($ivd_ship_atc_key))) {
            unset($this->ivd_ship_atc_key);
        } else {
            $this->ivd_ship_atc_key = $ivd_ship_atc_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_writeoff_deferral value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_writeoff_deferral(): ?string
    {
        return $this->ivd_writeoff_deferral ?? null;
    }
    /**
     * Set ivd_writeoff_deferral value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_writeoff_deferral
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_writeoff_deferral(?string $ivd_writeoff_deferral = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_writeoff_deferral) && !is_string($ivd_writeoff_deferral)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_writeoff_deferral, true), gettype($ivd_writeoff_deferral)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_writeoff_deferral) && $ivd_writeoff_deferral > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_writeoff_deferral, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_writeoff_deferral) && $ivd_writeoff_deferral < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_writeoff_deferral, true)), __LINE__);
        }
        if (is_null($ivd_writeoff_deferral) || (is_array($ivd_writeoff_deferral) && empty($ivd_writeoff_deferral))) {
            unset($this->ivd_writeoff_deferral);
        } else {
            $this->ivd_writeoff_deferral = $ivd_writeoff_deferral;
        }
        
        return $this;
    }
    /**
     * Get ivd_claim_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_claim_quantity(): ?float
    {
        return $this->ivd_claim_quantity ?? null;
    }
    /**
     * Set ivd_claim_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_claim_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_claim_quantity(?float $ivd_claim_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_claim_quantity) && !(is_float($ivd_claim_quantity) || is_numeric($ivd_claim_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_claim_quantity, true), gettype($ivd_claim_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_claim_quantity) && mb_strlen(mb_substr((string) $ivd_claim_quantity, false !== mb_strpos((string) $ivd_claim_quantity, '.') ? mb_strpos((string) $ivd_claim_quantity, '.') + 1 : mb_strlen((string) $ivd_claim_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_claim_quantity, true), mb_strlen(mb_substr((string) $ivd_claim_quantity, mb_strpos((string) $ivd_claim_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_claim_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_claim_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_claim_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_claim_quantity))), __LINE__);
        }
        if (is_null($ivd_claim_quantity) || (is_array($ivd_claim_quantity) && empty($ivd_claim_quantity))) {
            unset($this->ivd_claim_quantity);
        } else {
            $this->ivd_claim_quantity = $ivd_claim_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_disable_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_disable_quantity(): ?string
    {
        return $this->ivd_disable_quantity ?? null;
    }
    /**
     * Set ivd_disable_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_disable_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_disable_quantity(?string $ivd_disable_quantity = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_disable_quantity) && !is_string($ivd_disable_quantity)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_disable_quantity, true), gettype($ivd_disable_quantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_disable_quantity) && $ivd_disable_quantity > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_disable_quantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_disable_quantity) && $ivd_disable_quantity < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_disable_quantity, true)), __LINE__);
        }
        if (is_null($ivd_disable_quantity) || (is_array($ivd_disable_quantity) && empty($ivd_disable_quantity))) {
            unset($this->ivd_disable_quantity);
        } else {
            $this->ivd_disable_quantity = $ivd_disable_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_claimed_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_claimed_quantity(): ?float
    {
        return $this->ivd_claimed_quantity ?? null;
    }
    /**
     * Set ivd_claimed_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_claimed_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_claimed_quantity(?float $ivd_claimed_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_claimed_quantity) && !(is_float($ivd_claimed_quantity) || is_numeric($ivd_claimed_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_claimed_quantity, true), gettype($ivd_claimed_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_claimed_quantity) && mb_strlen(mb_substr((string) $ivd_claimed_quantity, false !== mb_strpos((string) $ivd_claimed_quantity, '.') ? mb_strpos((string) $ivd_claimed_quantity, '.') + 1 : mb_strlen((string) $ivd_claimed_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_claimed_quantity, true), mb_strlen(mb_substr((string) $ivd_claimed_quantity, mb_strpos((string) $ivd_claimed_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($ivd_claimed_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_claimed_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($ivd_claimed_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_claimed_quantity))), __LINE__);
        }
        if (is_null($ivd_claimed_quantity) || (is_array($ivd_claimed_quantity) && empty($ivd_claimed_quantity))) {
            unset($this->ivd_claimed_quantity);
        } else {
            $this->ivd_claimed_quantity = $ivd_claimed_quantity;
        }
        
        return $this;
    }
    /**
     * Get ivd_claim_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_claim_flag(): ?string
    {
        return $this->ivd_claim_flag ?? null;
    }
    /**
     * Set ivd_claim_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_claim_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_claim_flag(?string $ivd_claim_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_claim_flag) && !is_string($ivd_claim_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_claim_flag, true), gettype($ivd_claim_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_claim_flag) && $ivd_claim_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_claim_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_claim_flag) && $ivd_claim_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_claim_flag, true)), __LINE__);
        }
        if (is_null($ivd_claim_flag) || (is_array($ivd_claim_flag) && empty($ivd_claim_flag))) {
            unset($this->ivd_claim_flag);
        } else {
            $this->ivd_claim_flag = $ivd_claim_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_subtotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_subtotal(): ?float
    {
        return $this->ivd_subtotal ?? null;
    }
    /**
     * Set ivd_subtotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_subtotal
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_subtotal(?float $ivd_subtotal = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_subtotal) && !(is_float($ivd_subtotal) || is_numeric($ivd_subtotal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_subtotal, true), gettype($ivd_subtotal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_subtotal) && mb_strlen(mb_substr((string) $ivd_subtotal, false !== mb_strpos((string) $ivd_subtotal, '.') ? mb_strpos((string) $ivd_subtotal, '.') + 1 : mb_strlen((string) $ivd_subtotal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_subtotal, true), mb_strlen(mb_substr((string) $ivd_subtotal, mb_strpos((string) $ivd_subtotal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_subtotal) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_subtotal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_subtotal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_subtotal))), __LINE__);
        }
        if (is_null($ivd_subtotal) || (is_array($ivd_subtotal) && empty($ivd_subtotal))) {
            unset($this->ivd_subtotal);
        } else {
            $this->ivd_subtotal = $ivd_subtotal;
        }
        
        return $this;
    }
    /**
     * Get ivd_discountamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_discountamount(): ?float
    {
        return $this->ivd_discountamount ?? null;
    }
    /**
     * Set ivd_discountamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_discountamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_discountamount(?float $ivd_discountamount = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_discountamount) && !(is_float($ivd_discountamount) || is_numeric($ivd_discountamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_discountamount, true), gettype($ivd_discountamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_discountamount) && mb_strlen(mb_substr((string) $ivd_discountamount, false !== mb_strpos((string) $ivd_discountamount, '.') ? mb_strpos((string) $ivd_discountamount, '.') + 1 : mb_strlen((string) $ivd_discountamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_discountamount, true), mb_strlen(mb_substr((string) $ivd_discountamount, mb_strpos((string) $ivd_discountamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_discountamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_discountamount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_discountamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_discountamount))), __LINE__);
        }
        if (is_null($ivd_discountamount) || (is_array($ivd_discountamount) && empty($ivd_discountamount))) {
            unset($this->ivd_discountamount);
        } else {
            $this->ivd_discountamount = $ivd_discountamount;
        }
        
        return $this;
    }
    /**
     * Get ivd_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_total(): ?float
    {
        return $this->ivd_total ?? null;
    }
    /**
     * Set ivd_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_total(?float $ivd_total = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_total) && !(is_float($ivd_total) || is_numeric($ivd_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_total, true), gettype($ivd_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_total) && mb_strlen(mb_substr((string) $ivd_total, false !== mb_strpos((string) $ivd_total, '.') ? mb_strpos((string) $ivd_total, '.') + 1 : mb_strlen((string) $ivd_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_total, true), mb_strlen(mb_substr((string) $ivd_total, mb_strpos((string) $ivd_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_total))), __LINE__);
        }
        if (is_null($ivd_total) || (is_array($ivd_total) && empty($ivd_total))) {
            unset($this->ivd_total);
        } else {
            $this->ivd_total = $ivd_total;
        }
        
        return $this;
    }
    /**
     * Get ivd_unit_price_with_discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_unit_price_with_discount(): ?float
    {
        return $this->ivd_unit_price_with_discount ?? null;
    }
    /**
     * Set ivd_unit_price_with_discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_unit_price_with_discount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_unit_price_with_discount(?float $ivd_unit_price_with_discount = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_unit_price_with_discount) && !(is_float($ivd_unit_price_with_discount) || is_numeric($ivd_unit_price_with_discount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_unit_price_with_discount, true), gettype($ivd_unit_price_with_discount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_unit_price_with_discount) && mb_strlen(mb_substr((string) $ivd_unit_price_with_discount, false !== mb_strpos((string) $ivd_unit_price_with_discount, '.') ? mb_strpos((string) $ivd_unit_price_with_discount, '.') + 1 : mb_strlen((string) $ivd_unit_price_with_discount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_unit_price_with_discount, true), mb_strlen(mb_substr((string) $ivd_unit_price_with_discount, mb_strpos((string) $ivd_unit_price_with_discount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_unit_price_with_discount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_unit_price_with_discount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_unit_price_with_discount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_unit_price_with_discount))), __LINE__);
        }
        if (is_null($ivd_unit_price_with_discount) || (is_array($ivd_unit_price_with_discount) && empty($ivd_unit_price_with_discount))) {
            unset($this->ivd_unit_price_with_discount);
        } else {
            $this->ivd_unit_price_with_discount = $ivd_unit_price_with_discount;
        }
        
        return $this;
    }
    /**
     * Get ivd_applied_payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_applied_payment(): ?float
    {
        return $this->ivd_applied_payment ?? null;
    }
    /**
     * Set ivd_applied_payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_applied_payment
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_applied_payment(?float $ivd_applied_payment = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_applied_payment) && !(is_float($ivd_applied_payment) || is_numeric($ivd_applied_payment))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_applied_payment, true), gettype($ivd_applied_payment)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_applied_payment) && mb_strlen(mb_substr((string) $ivd_applied_payment, false !== mb_strpos((string) $ivd_applied_payment, '.') ? mb_strpos((string) $ivd_applied_payment, '.') + 1 : mb_strlen((string) $ivd_applied_payment))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_applied_payment, true), mb_strlen(mb_substr((string) $ivd_applied_payment, mb_strpos((string) $ivd_applied_payment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_applied_payment) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_applied_payment)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_applied_payment, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_applied_payment))), __LINE__);
        }
        if (is_null($ivd_applied_payment) || (is_array($ivd_applied_payment) && empty($ivd_applied_payment))) {
            unset($this->ivd_applied_payment);
        } else {
            $this->ivd_applied_payment = $ivd_applied_payment;
        }
        
        return $this;
    }
    /**
     * Get ivd_applied_credit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_applied_credit(): ?float
    {
        return $this->ivd_applied_credit ?? null;
    }
    /**
     * Set ivd_applied_credit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_applied_credit
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_applied_credit(?float $ivd_applied_credit = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_applied_credit) && !(is_float($ivd_applied_credit) || is_numeric($ivd_applied_credit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_applied_credit, true), gettype($ivd_applied_credit)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_applied_credit) && mb_strlen(mb_substr((string) $ivd_applied_credit, false !== mb_strpos((string) $ivd_applied_credit, '.') ? mb_strpos((string) $ivd_applied_credit, '.') + 1 : mb_strlen((string) $ivd_applied_credit))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_applied_credit, true), mb_strlen(mb_substr((string) $ivd_applied_credit, mb_strpos((string) $ivd_applied_credit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_applied_credit) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_applied_credit)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_applied_credit, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_applied_credit))), __LINE__);
        }
        if (is_null($ivd_applied_credit) || (is_array($ivd_applied_credit) && empty($ivd_applied_credit))) {
            unset($this->ivd_applied_credit);
        } else {
            $this->ivd_applied_credit = $ivd_applied_credit;
        }
        
        return $this;
    }
    /**
     * Get ivd_write_off value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_write_off(): ?float
    {
        return $this->ivd_write_off ?? null;
    }
    /**
     * Set ivd_write_off value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_write_off
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_write_off(?float $ivd_write_off = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_write_off) && !(is_float($ivd_write_off) || is_numeric($ivd_write_off))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_write_off, true), gettype($ivd_write_off)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_write_off) && mb_strlen(mb_substr((string) $ivd_write_off, false !== mb_strpos((string) $ivd_write_off, '.') ? mb_strpos((string) $ivd_write_off, '.') + 1 : mb_strlen((string) $ivd_write_off))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_write_off, true), mb_strlen(mb_substr((string) $ivd_write_off, mb_strpos((string) $ivd_write_off, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_write_off) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_write_off)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_write_off, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_write_off))), __LINE__);
        }
        if (is_null($ivd_write_off) || (is_array($ivd_write_off) && empty($ivd_write_off))) {
            unset($this->ivd_write_off);
        } else {
            $this->ivd_write_off = $ivd_write_off;
        }
        
        return $this;
    }
    /**
     * Get ivd_return_payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_return_payment(): ?float
    {
        return $this->ivd_return_payment ?? null;
    }
    /**
     * Set ivd_return_payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_return_payment
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_return_payment(?float $ivd_return_payment = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_return_payment) && !(is_float($ivd_return_payment) || is_numeric($ivd_return_payment))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_return_payment, true), gettype($ivd_return_payment)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_return_payment) && mb_strlen(mb_substr((string) $ivd_return_payment, false !== mb_strpos((string) $ivd_return_payment, '.') ? mb_strpos((string) $ivd_return_payment, '.') + 1 : mb_strlen((string) $ivd_return_payment))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_return_payment, true), mb_strlen(mb_substr((string) $ivd_return_payment, mb_strpos((string) $ivd_return_payment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_return_payment) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_return_payment)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_return_payment, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_return_payment))), __LINE__);
        }
        if (is_null($ivd_return_payment) || (is_array($ivd_return_payment) && empty($ivd_return_payment))) {
            unset($this->ivd_return_payment);
        } else {
            $this->ivd_return_payment = $ivd_return_payment;
        }
        
        return $this;
    }
    /**
     * Get ivd_total_payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_total_payment(): ?float
    {
        return $this->ivd_total_payment ?? null;
    }
    /**
     * Set ivd_total_payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_total_payment
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_total_payment(?float $ivd_total_payment = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_total_payment) && !(is_float($ivd_total_payment) || is_numeric($ivd_total_payment))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_total_payment, true), gettype($ivd_total_payment)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_total_payment) && mb_strlen(mb_substr((string) $ivd_total_payment, false !== mb_strpos((string) $ivd_total_payment, '.') ? mb_strpos((string) $ivd_total_payment, '.') + 1 : mb_strlen((string) $ivd_total_payment))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_total_payment, true), mb_strlen(mb_substr((string) $ivd_total_payment, mb_strpos((string) $ivd_total_payment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_total_payment) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_total_payment)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_total_payment, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_total_payment))), __LINE__);
        }
        if (is_null($ivd_total_payment) || (is_array($ivd_total_payment) && empty($ivd_total_payment))) {
            unset($this->ivd_total_payment);
        } else {
            $this->ivd_total_payment = $ivd_total_payment;
        }
        
        return $this;
    }
    /**
     * Get ivd_balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_balance(): ?float
    {
        return $this->ivd_balance ?? null;
    }
    /**
     * Set ivd_balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_balance
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_balance(?float $ivd_balance = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_balance) && !(is_float($ivd_balance) || is_numeric($ivd_balance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_balance, true), gettype($ivd_balance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_balance) && mb_strlen(mb_substr((string) $ivd_balance, false !== mb_strpos((string) $ivd_balance, '.') ? mb_strpos((string) $ivd_balance, '.') + 1 : mb_strlen((string) $ivd_balance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_balance, true), mb_strlen(mb_substr((string) $ivd_balance, mb_strpos((string) $ivd_balance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_balance) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_balance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_balance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_balance))), __LINE__);
        }
        if (is_null($ivd_balance) || (is_array($ivd_balance) && empty($ivd_balance))) {
            unset($this->ivd_balance);
        } else {
            $this->ivd_balance = $ivd_balance;
        }
        
        return $this;
    }
    /**
     * Get ivd_tax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_tax(): ?float
    {
        return $this->ivd_tax ?? null;
    }
    /**
     * Set ivd_tax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_tax
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_tax(?float $ivd_tax = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_tax) && !(is_float($ivd_tax) || is_numeric($ivd_tax))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_tax, true), gettype($ivd_tax)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_tax) && mb_strlen(mb_substr((string) $ivd_tax, false !== mb_strpos((string) $ivd_tax, '.') ? mb_strpos((string) $ivd_tax, '.') + 1 : mb_strlen((string) $ivd_tax))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_tax, true), mb_strlen(mb_substr((string) $ivd_tax, mb_strpos((string) $ivd_tax, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_tax) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_tax)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_tax, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_tax))), __LINE__);
        }
        if (is_null($ivd_tax) || (is_array($ivd_tax) && empty($ivd_tax))) {
            unset($this->ivd_tax);
        } else {
            $this->ivd_tax = $ivd_tax;
        }
        
        return $this;
    }
    /**
     * Get ivd_shipping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_shipping(): ?float
    {
        return $this->ivd_shipping ?? null;
    }
    /**
     * Set ivd_shipping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_shipping
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_shipping(?float $ivd_shipping = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_shipping) && !(is_float($ivd_shipping) || is_numeric($ivd_shipping))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_shipping, true), gettype($ivd_shipping)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_shipping) && mb_strlen(mb_substr((string) $ivd_shipping, false !== mb_strpos((string) $ivd_shipping, '.') ? mb_strpos((string) $ivd_shipping, '.') + 1 : mb_strlen((string) $ivd_shipping))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_shipping, true), mb_strlen(mb_substr((string) $ivd_shipping, mb_strpos((string) $ivd_shipping, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_shipping) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_shipping)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_shipping, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_shipping))), __LINE__);
        }
        if (is_null($ivd_shipping) || (is_array($ivd_shipping) && empty($ivd_shipping))) {
            unset($this->ivd_shipping);
        } else {
            $this->ivd_shipping = $ivd_shipping;
        }
        
        return $this;
    }
    /**
     * Get ivd_nettotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_nettotal(): ?float
    {
        return $this->ivd_nettotal ?? null;
    }
    /**
     * Set ivd_nettotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_nettotal
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_nettotal(?float $ivd_nettotal = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_nettotal) && !(is_float($ivd_nettotal) || is_numeric($ivd_nettotal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_nettotal, true), gettype($ivd_nettotal)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_nettotal) && mb_strlen(mb_substr((string) $ivd_nettotal, false !== mb_strpos((string) $ivd_nettotal, '.') ? mb_strpos((string) $ivd_nettotal, '.') + 1 : mb_strlen((string) $ivd_nettotal))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_nettotal, true), mb_strlen(mb_substr((string) $ivd_nettotal, mb_strpos((string) $ivd_nettotal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_nettotal) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_nettotal)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_nettotal, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_nettotal))), __LINE__);
        }
        if (is_null($ivd_nettotal) || (is_array($ivd_nettotal) && empty($ivd_nettotal))) {
            unset($this->ivd_nettotal);
        } else {
            $this->ivd_nettotal = $ivd_nettotal;
        }
        
        return $this;
    }
    /**
     * Get ivd_netpayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_netpayment(): ?float
    {
        return $this->ivd_netpayment ?? null;
    }
    /**
     * Set ivd_netpayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_netpayment
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_netpayment(?float $ivd_netpayment = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_netpayment) && !(is_float($ivd_netpayment) || is_numeric($ivd_netpayment))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_netpayment, true), gettype($ivd_netpayment)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_netpayment) && mb_strlen(mb_substr((string) $ivd_netpayment, false !== mb_strpos((string) $ivd_netpayment, '.') ? mb_strpos((string) $ivd_netpayment, '.') + 1 : mb_strlen((string) $ivd_netpayment))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_netpayment, true), mb_strlen(mb_substr((string) $ivd_netpayment, mb_strpos((string) $ivd_netpayment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_netpayment) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netpayment)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_netpayment, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netpayment))), __LINE__);
        }
        if (is_null($ivd_netpayment) || (is_array($ivd_netpayment) && empty($ivd_netpayment))) {
            unset($this->ivd_netpayment);
        } else {
            $this->ivd_netpayment = $ivd_netpayment;
        }
        
        return $this;
    }
    /**
     * Get ivd_payment_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_payment_to_apply(): ?float
    {
        return $this->ivd_payment_to_apply ?? null;
    }
    /**
     * Set ivd_payment_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_payment_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_payment_to_apply(?float $ivd_payment_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_payment_to_apply) && !(is_float($ivd_payment_to_apply) || is_numeric($ivd_payment_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_payment_to_apply, true), gettype($ivd_payment_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_payment_to_apply) && mb_strlen(mb_substr((string) $ivd_payment_to_apply, false !== mb_strpos((string) $ivd_payment_to_apply, '.') ? mb_strpos((string) $ivd_payment_to_apply, '.') + 1 : mb_strlen((string) $ivd_payment_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_payment_to_apply, true), mb_strlen(mb_substr((string) $ivd_payment_to_apply, mb_strpos((string) $ivd_payment_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_payment_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_payment_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_payment_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_payment_to_apply))), __LINE__);
        }
        if (is_null($ivd_payment_to_apply) || (is_array($ivd_payment_to_apply) && empty($ivd_payment_to_apply))) {
            unset($this->ivd_payment_to_apply);
        } else {
            $this->ivd_payment_to_apply = $ivd_payment_to_apply;
        }
        
        return $this;
    }
    /**
     * Get ivd_credit_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_credit_to_apply(): ?float
    {
        return $this->ivd_credit_to_apply ?? null;
    }
    /**
     * Set ivd_credit_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_credit_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_credit_to_apply(?float $ivd_credit_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_credit_to_apply) && !(is_float($ivd_credit_to_apply) || is_numeric($ivd_credit_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_credit_to_apply, true), gettype($ivd_credit_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_credit_to_apply) && mb_strlen(mb_substr((string) $ivd_credit_to_apply, false !== mb_strpos((string) $ivd_credit_to_apply, '.') ? mb_strpos((string) $ivd_credit_to_apply, '.') + 1 : mb_strlen((string) $ivd_credit_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_credit_to_apply, true), mb_strlen(mb_substr((string) $ivd_credit_to_apply, mb_strpos((string) $ivd_credit_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_credit_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_credit_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_credit_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_credit_to_apply))), __LINE__);
        }
        if (is_null($ivd_credit_to_apply) || (is_array($ivd_credit_to_apply) && empty($ivd_credit_to_apply))) {
            unset($this->ivd_credit_to_apply);
        } else {
            $this->ivd_credit_to_apply = $ivd_credit_to_apply;
        }
        
        return $this;
    }
    /**
     * Get ivd_netcredit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_netcredit(): ?float
    {
        return $this->ivd_netcredit ?? null;
    }
    /**
     * Set ivd_netcredit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_netcredit
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_netcredit(?float $ivd_netcredit = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_netcredit) && !(is_float($ivd_netcredit) || is_numeric($ivd_netcredit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_netcredit, true), gettype($ivd_netcredit)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_netcredit) && mb_strlen(mb_substr((string) $ivd_netcredit, false !== mb_strpos((string) $ivd_netcredit, '.') ? mb_strpos((string) $ivd_netcredit, '.') + 1 : mb_strlen((string) $ivd_netcredit))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_netcredit, true), mb_strlen(mb_substr((string) $ivd_netcredit, mb_strpos((string) $ivd_netcredit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_netcredit) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netcredit)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_netcredit, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netcredit))), __LINE__);
        }
        if (is_null($ivd_netcredit) || (is_array($ivd_netcredit) && empty($ivd_netcredit))) {
            unset($this->ivd_netcredit);
        } else {
            $this->ivd_netcredit = $ivd_netcredit;
        }
        
        return $this;
    }
    /**
     * Get ivd_netwriteoff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_netwriteoff(): ?float
    {
        return $this->ivd_netwriteoff ?? null;
    }
    /**
     * Set ivd_netwriteoff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_netwriteoff
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_netwriteoff(?float $ivd_netwriteoff = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_netwriteoff) && !(is_float($ivd_netwriteoff) || is_numeric($ivd_netwriteoff))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_netwriteoff, true), gettype($ivd_netwriteoff)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_netwriteoff) && mb_strlen(mb_substr((string) $ivd_netwriteoff, false !== mb_strpos((string) $ivd_netwriteoff, '.') ? mb_strpos((string) $ivd_netwriteoff, '.') + 1 : mb_strlen((string) $ivd_netwriteoff))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_netwriteoff, true), mb_strlen(mb_substr((string) $ivd_netwriteoff, mb_strpos((string) $ivd_netwriteoff, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_netwriteoff) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netwriteoff)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_netwriteoff, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netwriteoff))), __LINE__);
        }
        if (is_null($ivd_netwriteoff) || (is_array($ivd_netwriteoff) && empty($ivd_netwriteoff))) {
            unset($this->ivd_netwriteoff);
        } else {
            $this->ivd_netwriteoff = $ivd_netwriteoff;
        }
        
        return $this;
    }
    /**
     * Get ivd_writeoff_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_writeoff_to_apply(): ?float
    {
        return $this->ivd_writeoff_to_apply ?? null;
    }
    /**
     * Set ivd_writeoff_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_writeoff_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_writeoff_to_apply(?float $ivd_writeoff_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_writeoff_to_apply) && !(is_float($ivd_writeoff_to_apply) || is_numeric($ivd_writeoff_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_writeoff_to_apply, true), gettype($ivd_writeoff_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_writeoff_to_apply) && mb_strlen(mb_substr((string) $ivd_writeoff_to_apply, false !== mb_strpos((string) $ivd_writeoff_to_apply, '.') ? mb_strpos((string) $ivd_writeoff_to_apply, '.') + 1 : mb_strlen((string) $ivd_writeoff_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_writeoff_to_apply, true), mb_strlen(mb_substr((string) $ivd_writeoff_to_apply, mb_strpos((string) $ivd_writeoff_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_writeoff_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_writeoff_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_writeoff_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_writeoff_to_apply))), __LINE__);
        }
        if (is_null($ivd_writeoff_to_apply) || (is_array($ivd_writeoff_to_apply) && empty($ivd_writeoff_to_apply))) {
            unset($this->ivd_writeoff_to_apply);
        } else {
            $this->ivd_writeoff_to_apply = $ivd_writeoff_to_apply;
        }
        
        return $this;
    }
    /**
     * Get ivd_netreturn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_netreturn(): ?float
    {
        return $this->ivd_netreturn ?? null;
    }
    /**
     * Set ivd_netreturn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_netreturn
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_netreturn(?float $ivd_netreturn = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_netreturn) && !(is_float($ivd_netreturn) || is_numeric($ivd_netreturn))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_netreturn, true), gettype($ivd_netreturn)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_netreturn) && mb_strlen(mb_substr((string) $ivd_netreturn, false !== mb_strpos((string) $ivd_netreturn, '.') ? mb_strpos((string) $ivd_netreturn, '.') + 1 : mb_strlen((string) $ivd_netreturn))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_netreturn, true), mb_strlen(mb_substr((string) $ivd_netreturn, mb_strpos((string) $ivd_netreturn, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_netreturn) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netreturn)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_netreturn, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netreturn))), __LINE__);
        }
        if (is_null($ivd_netreturn) || (is_array($ivd_netreturn) && empty($ivd_netreturn))) {
            unset($this->ivd_netreturn);
        } else {
            $this->ivd_netreturn = $ivd_netreturn;
        }
        
        return $this;
    }
    /**
     * Get ivd_return_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_return_to_apply(): ?float
    {
        return $this->ivd_return_to_apply ?? null;
    }
    /**
     * Set ivd_return_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_return_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_return_to_apply(?float $ivd_return_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_return_to_apply) && !(is_float($ivd_return_to_apply) || is_numeric($ivd_return_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_return_to_apply, true), gettype($ivd_return_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_return_to_apply) && mb_strlen(mb_substr((string) $ivd_return_to_apply, false !== mb_strpos((string) $ivd_return_to_apply, '.') ? mb_strpos((string) $ivd_return_to_apply, '.') + 1 : mb_strlen((string) $ivd_return_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_return_to_apply, true), mb_strlen(mb_substr((string) $ivd_return_to_apply, mb_strpos((string) $ivd_return_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_return_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_return_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_return_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_return_to_apply))), __LINE__);
        }
        if (is_null($ivd_return_to_apply) || (is_array($ivd_return_to_apply) && empty($ivd_return_to_apply))) {
            unset($this->ivd_return_to_apply);
        } else {
            $this->ivd_return_to_apply = $ivd_return_to_apply;
        }
        
        return $this;
    }
    /**
     * Get ivd_netapplied value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_netapplied(): ?float
    {
        return $this->ivd_netapplied ?? null;
    }
    /**
     * Set ivd_netapplied value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_netapplied
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_netapplied(?float $ivd_netapplied = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_netapplied) && !(is_float($ivd_netapplied) || is_numeric($ivd_netapplied))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_netapplied, true), gettype($ivd_netapplied)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_netapplied) && mb_strlen(mb_substr((string) $ivd_netapplied, false !== mb_strpos((string) $ivd_netapplied, '.') ? mb_strpos((string) $ivd_netapplied, '.') + 1 : mb_strlen((string) $ivd_netapplied))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_netapplied, true), mb_strlen(mb_substr((string) $ivd_netapplied, mb_strpos((string) $ivd_netapplied, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_netapplied) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netapplied)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_netapplied, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netapplied))), __LINE__);
        }
        if (is_null($ivd_netapplied) || (is_array($ivd_netapplied) && empty($ivd_netapplied))) {
            unset($this->ivd_netapplied);
        } else {
            $this->ivd_netapplied = $ivd_netapplied;
        }
        
        return $this;
    }
    /**
     * Get ivd_previous_netpayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_previous_netpayment(): ?float
    {
        return $this->ivd_previous_netpayment ?? null;
    }
    /**
     * Set ivd_previous_netpayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_previous_netpayment
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_previous_netpayment(?float $ivd_previous_netpayment = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_previous_netpayment) && !(is_float($ivd_previous_netpayment) || is_numeric($ivd_previous_netpayment))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_previous_netpayment, true), gettype($ivd_previous_netpayment)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_previous_netpayment) && mb_strlen(mb_substr((string) $ivd_previous_netpayment, false !== mb_strpos((string) $ivd_previous_netpayment, '.') ? mb_strpos((string) $ivd_previous_netpayment, '.') + 1 : mb_strlen((string) $ivd_previous_netpayment))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_previous_netpayment, true), mb_strlen(mb_substr((string) $ivd_previous_netpayment, mb_strpos((string) $ivd_previous_netpayment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_previous_netpayment) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_previous_netpayment)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_previous_netpayment, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_previous_netpayment))), __LINE__);
        }
        if (is_null($ivd_previous_netpayment) || (is_array($ivd_previous_netpayment) && empty($ivd_previous_netpayment))) {
            unset($this->ivd_previous_netpayment);
        } else {
            $this->ivd_previous_netpayment = $ivd_previous_netpayment;
        }
        
        return $this;
    }
    /**
     * Get ivd_total_to_apply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_total_to_apply(): ?float
    {
        return $this->ivd_total_to_apply ?? null;
    }
    /**
     * Set ivd_total_to_apply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_total_to_apply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_total_to_apply(?float $ivd_total_to_apply = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_total_to_apply) && !(is_float($ivd_total_to_apply) || is_numeric($ivd_total_to_apply))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_total_to_apply, true), gettype($ivd_total_to_apply)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_total_to_apply) && mb_strlen(mb_substr((string) $ivd_total_to_apply, false !== mb_strpos((string) $ivd_total_to_apply, '.') ? mb_strpos((string) $ivd_total_to_apply, '.') + 1 : mb_strlen((string) $ivd_total_to_apply))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_total_to_apply, true), mb_strlen(mb_substr((string) $ivd_total_to_apply, mb_strpos((string) $ivd_total_to_apply, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_total_to_apply) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_total_to_apply)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_total_to_apply, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_total_to_apply))), __LINE__);
        }
        if (is_null($ivd_total_to_apply) || (is_array($ivd_total_to_apply) && empty($ivd_total_to_apply))) {
            unset($this->ivd_total_to_apply);
        } else {
            $this->ivd_total_to_apply = $ivd_total_to_apply;
        }
        
        return $this;
    }
    /**
     * Get ivd_netbalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_netbalance(): ?float
    {
        return $this->ivd_netbalance ?? null;
    }
    /**
     * Set ivd_netbalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_netbalance
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_netbalance(?float $ivd_netbalance = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_netbalance) && !(is_float($ivd_netbalance) || is_numeric($ivd_netbalance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_netbalance, true), gettype($ivd_netbalance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_netbalance) && mb_strlen(mb_substr((string) $ivd_netbalance, false !== mb_strpos((string) $ivd_netbalance, '.') ? mb_strpos((string) $ivd_netbalance, '.') + 1 : mb_strlen((string) $ivd_netbalance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_netbalance, true), mb_strlen(mb_substr((string) $ivd_netbalance, mb_strpos((string) $ivd_netbalance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_netbalance) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netbalance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_netbalance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netbalance))), __LINE__);
        }
        if (is_null($ivd_netbalance) || (is_array($ivd_netbalance) && empty($ivd_netbalance))) {
            unset($this->ivd_netbalance);
        } else {
            $this->ivd_netbalance = $ivd_netbalance;
        }
        
        return $this;
    }
    /**
     * Get ivd_netunpaidbalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_netunpaidbalance(): ?float
    {
        return $this->ivd_netunpaidbalance ?? null;
    }
    /**
     * Set ivd_netunpaidbalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_netunpaidbalance
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_netunpaidbalance(?float $ivd_netunpaidbalance = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_netunpaidbalance) && !(is_float($ivd_netunpaidbalance) || is_numeric($ivd_netunpaidbalance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_netunpaidbalance, true), gettype($ivd_netunpaidbalance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_netunpaidbalance) && mb_strlen(mb_substr((string) $ivd_netunpaidbalance, false !== mb_strpos((string) $ivd_netunpaidbalance, '.') ? mb_strpos((string) $ivd_netunpaidbalance, '.') + 1 : mb_strlen((string) $ivd_netunpaidbalance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_netunpaidbalance, true), mb_strlen(mb_substr((string) $ivd_netunpaidbalance, mb_strpos((string) $ivd_netunpaidbalance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_netunpaidbalance) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netunpaidbalance)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_netunpaidbalance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netunpaidbalance))), __LINE__);
        }
        if (is_null($ivd_netunpaidbalance) || (is_array($ivd_netunpaidbalance) && empty($ivd_netunpaidbalance))) {
            unset($this->ivd_netunpaidbalance);
        } else {
            $this->ivd_netunpaidbalance = $ivd_netunpaidbalance;
        }
        
        return $this;
    }
    /**
     * Get ivd_price_aggregated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_price_aggregated(): ?float
    {
        return $this->ivd_price_aggregated ?? null;
    }
    /**
     * Set ivd_price_aggregated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_price_aggregated
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_price_aggregated(?float $ivd_price_aggregated = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_price_aggregated) && !(is_float($ivd_price_aggregated) || is_numeric($ivd_price_aggregated))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_price_aggregated, true), gettype($ivd_price_aggregated)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_price_aggregated) && mb_strlen(mb_substr((string) $ivd_price_aggregated, false !== mb_strpos((string) $ivd_price_aggregated, '.') ? mb_strpos((string) $ivd_price_aggregated, '.') + 1 : mb_strlen((string) $ivd_price_aggregated))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_price_aggregated, true), mb_strlen(mb_substr((string) $ivd_price_aggregated, mb_strpos((string) $ivd_price_aggregated, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_price_aggregated) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_price_aggregated)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_price_aggregated, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_price_aggregated))), __LINE__);
        }
        if (is_null($ivd_price_aggregated) || (is_array($ivd_price_aggregated) && empty($ivd_price_aggregated))) {
            unset($this->ivd_price_aggregated);
        } else {
            $this->ivd_price_aggregated = $ivd_price_aggregated;
        }
        
        return $this;
    }
    /**
     * Get ivd_discountamount_aggregated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_discountamount_aggregated(): ?float
    {
        return $this->ivd_discountamount_aggregated ?? null;
    }
    /**
     * Set ivd_discountamount_aggregated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_discountamount_aggregated
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_discountamount_aggregated(?float $ivd_discountamount_aggregated = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_discountamount_aggregated) && !(is_float($ivd_discountamount_aggregated) || is_numeric($ivd_discountamount_aggregated))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_discountamount_aggregated, true), gettype($ivd_discountamount_aggregated)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_discountamount_aggregated) && mb_strlen(mb_substr((string) $ivd_discountamount_aggregated, false !== mb_strpos((string) $ivd_discountamount_aggregated, '.') ? mb_strpos((string) $ivd_discountamount_aggregated, '.') + 1 : mb_strlen((string) $ivd_discountamount_aggregated))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_discountamount_aggregated, true), mb_strlen(mb_substr((string) $ivd_discountamount_aggregated, mb_strpos((string) $ivd_discountamount_aggregated, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_discountamount_aggregated) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_discountamount_aggregated)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_discountamount_aggregated, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_discountamount_aggregated))), __LINE__);
        }
        if (is_null($ivd_discountamount_aggregated) || (is_array($ivd_discountamount_aggregated) && empty($ivd_discountamount_aggregated))) {
            unset($this->ivd_discountamount_aggregated);
        } else {
            $this->ivd_discountamount_aggregated = $ivd_discountamount_aggregated;
        }
        
        return $this;
    }
    /**
     * Get ivd_tax_aggregated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_tax_aggregated(): ?float
    {
        return $this->ivd_tax_aggregated ?? null;
    }
    /**
     * Set ivd_tax_aggregated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_tax_aggregated
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_tax_aggregated(?float $ivd_tax_aggregated = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_tax_aggregated) && !(is_float($ivd_tax_aggregated) || is_numeric($ivd_tax_aggregated))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_tax_aggregated, true), gettype($ivd_tax_aggregated)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_tax_aggregated) && mb_strlen(mb_substr((string) $ivd_tax_aggregated, false !== mb_strpos((string) $ivd_tax_aggregated, '.') ? mb_strpos((string) $ivd_tax_aggregated, '.') + 1 : mb_strlen((string) $ivd_tax_aggregated))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_tax_aggregated, true), mb_strlen(mb_substr((string) $ivd_tax_aggregated, mb_strpos((string) $ivd_tax_aggregated, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_tax_aggregated) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_tax_aggregated)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_tax_aggregated, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_tax_aggregated))), __LINE__);
        }
        if (is_null($ivd_tax_aggregated) || (is_array($ivd_tax_aggregated) && empty($ivd_tax_aggregated))) {
            unset($this->ivd_tax_aggregated);
        } else {
            $this->ivd_tax_aggregated = $ivd_tax_aggregated;
        }
        
        return $this;
    }
    /**
     * Get ivd_shipping_aggregated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_shipping_aggregated(): ?float
    {
        return $this->ivd_shipping_aggregated ?? null;
    }
    /**
     * Set ivd_shipping_aggregated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_shipping_aggregated
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_shipping_aggregated(?float $ivd_shipping_aggregated = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_shipping_aggregated) && !(is_float($ivd_shipping_aggregated) || is_numeric($ivd_shipping_aggregated))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_shipping_aggregated, true), gettype($ivd_shipping_aggregated)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_shipping_aggregated) && mb_strlen(mb_substr((string) $ivd_shipping_aggregated, false !== mb_strpos((string) $ivd_shipping_aggregated, '.') ? mb_strpos((string) $ivd_shipping_aggregated, '.') + 1 : mb_strlen((string) $ivd_shipping_aggregated))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_shipping_aggregated, true), mb_strlen(mb_substr((string) $ivd_shipping_aggregated, mb_strpos((string) $ivd_shipping_aggregated, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_shipping_aggregated) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_shipping_aggregated)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_shipping_aggregated, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_shipping_aggregated))), __LINE__);
        }
        if (is_null($ivd_shipping_aggregated) || (is_array($ivd_shipping_aggregated) && empty($ivd_shipping_aggregated))) {
            unset($this->ivd_shipping_aggregated);
        } else {
            $this->ivd_shipping_aggregated = $ivd_shipping_aggregated;
        }
        
        return $this;
    }
    /**
     * Get ivd_nettotal_aggregated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_nettotal_aggregated(): ?float
    {
        return $this->ivd_nettotal_aggregated ?? null;
    }
    /**
     * Set ivd_nettotal_aggregated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_nettotal_aggregated
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_nettotal_aggregated(?float $ivd_nettotal_aggregated = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_nettotal_aggregated) && !(is_float($ivd_nettotal_aggregated) || is_numeric($ivd_nettotal_aggregated))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_nettotal_aggregated, true), gettype($ivd_nettotal_aggregated)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_nettotal_aggregated) && mb_strlen(mb_substr((string) $ivd_nettotal_aggregated, false !== mb_strpos((string) $ivd_nettotal_aggregated, '.') ? mb_strpos((string) $ivd_nettotal_aggregated, '.') + 1 : mb_strlen((string) $ivd_nettotal_aggregated))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_nettotal_aggregated, true), mb_strlen(mb_substr((string) $ivd_nettotal_aggregated, mb_strpos((string) $ivd_nettotal_aggregated, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_nettotal_aggregated) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_nettotal_aggregated)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_nettotal_aggregated, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_nettotal_aggregated))), __LINE__);
        }
        if (is_null($ivd_nettotal_aggregated) || (is_array($ivd_nettotal_aggregated) && empty($ivd_nettotal_aggregated))) {
            unset($this->ivd_nettotal_aggregated);
        } else {
            $this->ivd_nettotal_aggregated = $ivd_nettotal_aggregated;
        }
        
        return $this;
    }
    /**
     * Get ivd_netunpaidbalance_aggregated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_netunpaidbalance_aggregated(): ?float
    {
        return $this->ivd_netunpaidbalance_aggregated ?? null;
    }
    /**
     * Set ivd_netunpaidbalance_aggregated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_netunpaidbalance_aggregated
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_netunpaidbalance_aggregated(?float $ivd_netunpaidbalance_aggregated = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_netunpaidbalance_aggregated) && !(is_float($ivd_netunpaidbalance_aggregated) || is_numeric($ivd_netunpaidbalance_aggregated))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_netunpaidbalance_aggregated, true), gettype($ivd_netunpaidbalance_aggregated)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_netunpaidbalance_aggregated) && mb_strlen(mb_substr((string) $ivd_netunpaidbalance_aggregated, false !== mb_strpos((string) $ivd_netunpaidbalance_aggregated, '.') ? mb_strpos((string) $ivd_netunpaidbalance_aggregated, '.') + 1 : mb_strlen((string) $ivd_netunpaidbalance_aggregated))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_netunpaidbalance_aggregated, true), mb_strlen(mb_substr((string) $ivd_netunpaidbalance_aggregated, mb_strpos((string) $ivd_netunpaidbalance_aggregated, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_netunpaidbalance_aggregated) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netunpaidbalance_aggregated)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_netunpaidbalance_aggregated, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_netunpaidbalance_aggregated))), __LINE__);
        }
        if (is_null($ivd_netunpaidbalance_aggregated) || (is_array($ivd_netunpaidbalance_aggregated) && empty($ivd_netunpaidbalance_aggregated))) {
            unset($this->ivd_netunpaidbalance_aggregated);
        } else {
            $this->ivd_netunpaidbalance_aggregated = $ivd_netunpaidbalance_aggregated;
        }
        
        return $this;
    }
    /**
     * Get ivd_subtotal_aggregated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_subtotal_aggregated(): ?float
    {
        return $this->ivd_subtotal_aggregated ?? null;
    }
    /**
     * Set ivd_subtotal_aggregated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_subtotal_aggregated
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_subtotal_aggregated(?float $ivd_subtotal_aggregated = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_subtotal_aggregated) && !(is_float($ivd_subtotal_aggregated) || is_numeric($ivd_subtotal_aggregated))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_subtotal_aggregated, true), gettype($ivd_subtotal_aggregated)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_subtotal_aggregated) && mb_strlen(mb_substr((string) $ivd_subtotal_aggregated, false !== mb_strpos((string) $ivd_subtotal_aggregated, '.') ? mb_strpos((string) $ivd_subtotal_aggregated, '.') + 1 : mb_strlen((string) $ivd_subtotal_aggregated))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_subtotal_aggregated, true), mb_strlen(mb_substr((string) $ivd_subtotal_aggregated, mb_strpos((string) $ivd_subtotal_aggregated, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_subtotal_aggregated) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_subtotal_aggregated)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_subtotal_aggregated, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_subtotal_aggregated))), __LINE__);
        }
        if (is_null($ivd_subtotal_aggregated) || (is_array($ivd_subtotal_aggregated) && empty($ivd_subtotal_aggregated))) {
            unset($this->ivd_subtotal_aggregated);
        } else {
            $this->ivd_subtotal_aggregated = $ivd_subtotal_aggregated;
        }
        
        return $this;
    }
    /**
     * Get ivd_shippable_flag_aggregated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_shippable_flag_aggregated(): ?string
    {
        return $this->ivd_shippable_flag_aggregated ?? null;
    }
    /**
     * Set ivd_shippable_flag_aggregated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_shippable_flag_aggregated
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_shippable_flag_aggregated(?string $ivd_shippable_flag_aggregated = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_shippable_flag_aggregated) && !is_string($ivd_shippable_flag_aggregated)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_shippable_flag_aggregated, true), gettype($ivd_shippable_flag_aggregated)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_shippable_flag_aggregated) && $ivd_shippable_flag_aggregated > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_shippable_flag_aggregated, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_shippable_flag_aggregated) && $ivd_shippable_flag_aggregated < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_shippable_flag_aggregated, true)), __LINE__);
        }
        if (is_null($ivd_shippable_flag_aggregated) || (is_array($ivd_shippable_flag_aggregated) && empty($ivd_shippable_flag_aggregated))) {
            unset($this->ivd_shippable_flag_aggregated);
        } else {
            $this->ivd_shippable_flag_aggregated = $ivd_shippable_flag_aggregated;
        }
        
        return $this;
    }
    /**
     * Get ivd_partof_groupreg_discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_partof_groupreg_discount(): ?string
    {
        return $this->ivd_partof_groupreg_discount ?? null;
    }
    /**
     * Set ivd_partof_groupreg_discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_partof_groupreg_discount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_partof_groupreg_discount(?string $ivd_partof_groupreg_discount = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_partof_groupreg_discount) && !is_string($ivd_partof_groupreg_discount)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_partof_groupreg_discount, true), gettype($ivd_partof_groupreg_discount)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_partof_groupreg_discount) && $ivd_partof_groupreg_discount > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_partof_groupreg_discount, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_partof_groupreg_discount) && $ivd_partof_groupreg_discount < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_partof_groupreg_discount, true)), __LINE__);
        }
        if (is_null($ivd_partof_groupreg_discount) || (is_array($ivd_partof_groupreg_discount) && empty($ivd_partof_groupreg_discount))) {
            unset($this->ivd_partof_groupreg_discount);
        } else {
            $this->ivd_partof_groupreg_discount = $ivd_partof_groupreg_discount;
        }
        
        return $this;
    }
    /**
     * Get ivd_booth_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_booth_number(): ?string
    {
        return $this->ivd_booth_number ?? null;
    }
    /**
     * Set ivd_booth_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_booth_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_booth_number(?string $ivd_booth_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_booth_number) && !is_string($ivd_booth_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_booth_number, true), gettype($ivd_booth_number)), __LINE__);
        }
        if (is_null($ivd_booth_number) || (is_array($ivd_booth_number) && empty($ivd_booth_number))) {
            unset($this->ivd_booth_number);
        } else {
            $this->ivd_booth_number = $ivd_booth_number;
        }
        
        return $this;
    }
    /**
     * Get ivd_cst_credit_available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_cst_credit_available(): ?float
    {
        return $this->ivd_cst_credit_available ?? null;
    }
    /**
     * Set ivd_cst_credit_available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_cst_credit_available
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_cst_credit_available(?float $ivd_cst_credit_available = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_cst_credit_available) && !(is_float($ivd_cst_credit_available) || is_numeric($ivd_cst_credit_available))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_cst_credit_available, true), gettype($ivd_cst_credit_available)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_cst_credit_available) && mb_strlen(mb_substr((string) $ivd_cst_credit_available, false !== mb_strpos((string) $ivd_cst_credit_available, '.') ? mb_strpos((string) $ivd_cst_credit_available, '.') + 1 : mb_strlen((string) $ivd_cst_credit_available))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_cst_credit_available, true), mb_strlen(mb_substr((string) $ivd_cst_credit_available, mb_strpos((string) $ivd_cst_credit_available, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_cst_credit_available) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_cst_credit_available)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_cst_credit_available, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_cst_credit_available))), __LINE__);
        }
        if (is_null($ivd_cst_credit_available) || (is_array($ivd_cst_credit_available) && empty($ivd_cst_credit_available))) {
            unset($this->ivd_cst_credit_available);
        } else {
            $this->ivd_cst_credit_available = $ivd_cst_credit_available;
        }
        
        return $this;
    }
    /**
     * Get ivd_reload_ivd_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_reload_ivd_cxa_key(): ?string
    {
        return $this->ivd_reload_ivd_cxa_key ?? null;
    }
    /**
     * Set ivd_reload_ivd_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_reload_ivd_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_reload_ivd_cxa_key(?string $ivd_reload_ivd_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_reload_ivd_cxa_key) && !is_string($ivd_reload_ivd_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_reload_ivd_cxa_key, true), gettype($ivd_reload_ivd_cxa_key)), __LINE__);
        }
        if (is_null($ivd_reload_ivd_cxa_key) || (is_array($ivd_reload_ivd_cxa_key) && empty($ivd_reload_ivd_cxa_key))) {
            unset($this->ivd_reload_ivd_cxa_key);
        } else {
            $this->ivd_reload_ivd_cxa_key = $ivd_reload_ivd_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_MulticurrencyKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_MulticurrencyKey(): ?string
    {
        return $this->ivd_MulticurrencyKey ?? null;
    }
    /**
     * Set ivd_MulticurrencyKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_MulticurrencyKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_MulticurrencyKey(?string $ivd_MulticurrencyKey = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_MulticurrencyKey) && !is_string($ivd_MulticurrencyKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_MulticurrencyKey, true), gettype($ivd_MulticurrencyKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_MulticurrencyKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_MulticurrencyKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_MulticurrencyKey, true)), __LINE__);
        }
        if (is_null($ivd_MulticurrencyKey) || (is_array($ivd_MulticurrencyKey) && empty($ivd_MulticurrencyKey))) {
            unset($this->ivd_MulticurrencyKey);
        } else {
            $this->ivd_MulticurrencyKey = $ivd_MulticurrencyKey;
        }
        
        return $this;
    }
    /**
     * Get ivd_pricingcontrol_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_pricingcontrol_date(): ?string
    {
        return $this->ivd_pricingcontrol_date ?? null;
    }
    /**
     * Set ivd_pricingcontrol_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_pricingcontrol_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_pricingcontrol_date(?string $ivd_pricingcontrol_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_pricingcontrol_date) && !is_string($ivd_pricingcontrol_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_pricingcontrol_date, true), gettype($ivd_pricingcontrol_date)), __LINE__);
        }
        if (is_null($ivd_pricingcontrol_date) || (is_array($ivd_pricingcontrol_date) && empty($ivd_pricingcontrol_date))) {
            unset($this->ivd_pricingcontrol_date);
        } else {
            $this->ivd_pricingcontrol_date = $ivd_pricingcontrol_date;
        }
        
        return $this;
    }
    /**
     * Get ivd_pricingcontrol_rgt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_pricingcontrol_rgt_key(): ?string
    {
        return $this->ivd_pricingcontrol_rgt_key ?? null;
    }
    /**
     * Set ivd_pricingcontrol_rgt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_pricingcontrol_rgt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_pricingcontrol_rgt_key(?string $ivd_pricingcontrol_rgt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_pricingcontrol_rgt_key) && !is_string($ivd_pricingcontrol_rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_pricingcontrol_rgt_key, true), gettype($ivd_pricingcontrol_rgt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_pricingcontrol_rgt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_pricingcontrol_rgt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_pricingcontrol_rgt_key, true)), __LINE__);
        }
        if (is_null($ivd_pricingcontrol_rgt_key) || (is_array($ivd_pricingcontrol_rgt_key) && empty($ivd_pricingcontrol_rgt_key))) {
            unset($this->ivd_pricingcontrol_rgt_key);
        } else {
            $this->ivd_pricingcontrol_rgt_key = $ivd_pricingcontrol_rgt_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_term_based value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_term_based(): ?string
    {
        return $this->ivd_term_based ?? null;
    }
    /**
     * Set ivd_term_based value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_term_based
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_term_based(?string $ivd_term_based = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_term_based) && !is_string($ivd_term_based)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_term_based, true), gettype($ivd_term_based)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_term_based) && $ivd_term_based > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_term_based, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_term_based) && $ivd_term_based < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_term_based, true)), __LINE__);
        }
        if (is_null($ivd_term_based) || (is_array($ivd_term_based) && empty($ivd_term_based))) {
            unset($this->ivd_term_based);
        } else {
            $this->ivd_term_based = $ivd_term_based;
        }
        
        return $this;
    }
    /**
     * Get ivd_term_calendar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_term_calendar(): ?string
    {
        return $this->ivd_term_calendar ?? null;
    }
    /**
     * Set ivd_term_calendar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_term_calendar
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_term_calendar(?string $ivd_term_calendar = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_term_calendar) && !is_string($ivd_term_calendar)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_term_calendar, true), gettype($ivd_term_calendar)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_term_calendar) && $ivd_term_calendar > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_term_calendar, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_term_calendar) && $ivd_term_calendar < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_term_calendar, true)), __LINE__);
        }
        if (is_null($ivd_term_calendar) || (is_array($ivd_term_calendar) && empty($ivd_term_calendar))) {
            unset($this->ivd_term_calendar);
        } else {
            $this->ivd_term_calendar = $ivd_term_calendar;
        }
        
        return $this;
    }
    /**
     * Get ivd_TransactionCurrencyKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_TransactionCurrencyKey(): ?string
    {
        return $this->ivd_TransactionCurrencyKey ?? null;
    }
    /**
     * Set ivd_TransactionCurrencyKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_TransactionCurrencyKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_TransactionCurrencyKey(?string $ivd_TransactionCurrencyKey = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_TransactionCurrencyKey) && !is_string($ivd_TransactionCurrencyKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_TransactionCurrencyKey, true), gettype($ivd_TransactionCurrencyKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_TransactionCurrencyKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_TransactionCurrencyKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_TransactionCurrencyKey, true)), __LINE__);
        }
        if (is_null($ivd_TransactionCurrencyKey) || (is_array($ivd_TransactionCurrencyKey) && empty($ivd_TransactionCurrencyKey))) {
            unset($this->ivd_TransactionCurrencyKey);
        } else {
            $this->ivd_TransactionCurrencyKey = $ivd_TransactionCurrencyKey;
        }
        
        return $this;
    }
    /**
     * Get ivd_HomeCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_HomeCurrencyCode(): ?string
    {
        return $this->ivd_HomeCurrencyCode ?? null;
    }
    /**
     * Set ivd_HomeCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_HomeCurrencyCode
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_HomeCurrencyCode(?string $ivd_HomeCurrencyCode = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_HomeCurrencyCode) && !is_string($ivd_HomeCurrencyCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_HomeCurrencyCode, true), gettype($ivd_HomeCurrencyCode)), __LINE__);
        }
        if (is_null($ivd_HomeCurrencyCode) || (is_array($ivd_HomeCurrencyCode) && empty($ivd_HomeCurrencyCode))) {
            unset($this->ivd_HomeCurrencyCode);
        } else {
            $this->ivd_HomeCurrencyCode = $ivd_HomeCurrencyCode;
        }
        
        return $this;
    }
    /**
     * Get ivd_sub_prorated_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_sub_prorated_flag(): ?string
    {
        return $this->ivd_sub_prorated_flag ?? null;
    }
    /**
     * Set ivd_sub_prorated_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_sub_prorated_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_sub_prorated_flag(?string $ivd_sub_prorated_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_sub_prorated_flag) && !is_string($ivd_sub_prorated_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_sub_prorated_flag, true), gettype($ivd_sub_prorated_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_sub_prorated_flag) && $ivd_sub_prorated_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_sub_prorated_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_sub_prorated_flag) && $ivd_sub_prorated_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_sub_prorated_flag, true)), __LINE__);
        }
        if (is_null($ivd_sub_prorated_flag) || (is_array($ivd_sub_prorated_flag) && empty($ivd_sub_prorated_flag))) {
            unset($this->ivd_sub_prorated_flag);
        } else {
            $this->ivd_sub_prorated_flag = $ivd_sub_prorated_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_autoapply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_autoapply(): ?string
    {
        return $this->ivd_autoapply ?? null;
    }
    /**
     * Set ivd_autoapply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_autoapply
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_autoapply(?string $ivd_autoapply = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_autoapply) && !is_string($ivd_autoapply)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_autoapply, true), gettype($ivd_autoapply)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_autoapply) && $ivd_autoapply > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_autoapply, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_autoapply) && $ivd_autoapply < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_autoapply, true)), __LINE__);
        }
        if (is_null($ivd_autoapply) || (is_array($ivd_autoapply) && empty($ivd_autoapply))) {
            unset($this->ivd_autoapply);
        } else {
            $this->ivd_autoapply = $ivd_autoapply;
        }
        
        return $this;
    }
    /**
     * Get ivd_cancel_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_cancel_flag(): ?string
    {
        return $this->ivd_cancel_flag ?? null;
    }
    /**
     * Set ivd_cancel_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_cancel_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_cancel_flag(?string $ivd_cancel_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_cancel_flag) && !is_string($ivd_cancel_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_cancel_flag, true), gettype($ivd_cancel_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_cancel_flag) && $ivd_cancel_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_cancel_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_cancel_flag) && $ivd_cancel_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_cancel_flag, true)), __LINE__);
        }
        if (is_null($ivd_cancel_flag) || (is_array($ivd_cancel_flag) && empty($ivd_cancel_flag))) {
            unset($this->ivd_cancel_flag);
        } else {
            $this->ivd_cancel_flag = $ivd_cancel_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_ivd_key(): ?string
    {
        return $this->ivd_ivd_key ?? null;
    }
    /**
     * Set ivd_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_ivd_key(?string $ivd_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_ivd_key) && !is_string($ivd_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_ivd_key, true), gettype($ivd_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_ivd_key, true)), __LINE__);
        }
        if (is_null($ivd_ivd_key) || (is_array($ivd_ivd_key) && empty($ivd_ivd_key))) {
            unset($this->ivd_ivd_key);
        } else {
            $this->ivd_ivd_key = $ivd_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_is_agency_sub value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_is_agency_sub(): ?string
    {
        return $this->ivd_is_agency_sub ?? null;
    }
    /**
     * Set ivd_is_agency_sub value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_is_agency_sub
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_is_agency_sub(?string $ivd_is_agency_sub = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_is_agency_sub) && !is_string($ivd_is_agency_sub)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_is_agency_sub, true), gettype($ivd_is_agency_sub)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_is_agency_sub) && $ivd_is_agency_sub > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_is_agency_sub, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_is_agency_sub) && $ivd_is_agency_sub < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_is_agency_sub, true)), __LINE__);
        }
        if (is_null($ivd_is_agency_sub) || (is_array($ivd_is_agency_sub) && empty($ivd_is_agency_sub))) {
            unset($this->ivd_is_agency_sub);
        } else {
            $this->ivd_is_agency_sub = $ivd_is_agency_sub;
        }
        
        return $this;
    }
    /**
     * Get ivd_formdetailkey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_formdetailkey(): ?string
    {
        return $this->ivd_formdetailkey ?? null;
    }
    /**
     * Set ivd_formdetailkey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_formdetailkey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_formdetailkey(?string $ivd_formdetailkey = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_formdetailkey) && !is_string($ivd_formdetailkey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_formdetailkey, true), gettype($ivd_formdetailkey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_formdetailkey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_formdetailkey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_formdetailkey, true)), __LINE__);
        }
        if (is_null($ivd_formdetailkey) || (is_array($ivd_formdetailkey) && empty($ivd_formdetailkey))) {
            unset($this->ivd_formdetailkey);
        } else {
            $this->ivd_formdetailkey = $ivd_formdetailkey;
        }
        
        return $this;
    }
    /**
     * Get ivd_formkey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_formkey(): ?string
    {
        return $this->ivd_formkey ?? null;
    }
    /**
     * Set ivd_formkey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_formkey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_formkey(?string $ivd_formkey = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_formkey) && !is_string($ivd_formkey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_formkey, true), gettype($ivd_formkey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_formkey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_formkey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_formkey, true)), __LINE__);
        }
        if (is_null($ivd_formkey) || (is_array($ivd_formkey) && empty($ivd_formkey))) {
            unset($this->ivd_formkey);
        } else {
            $this->ivd_formkey = $ivd_formkey;
        }
        
        return $this;
    }
    /**
     * Get ivd_parentdataobject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_parentdataobject(): ?string
    {
        return $this->ivd_parentdataobject ?? null;
    }
    /**
     * Set ivd_parentdataobject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_parentdataobject
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_parentdataobject(?string $ivd_parentdataobject = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_parentdataobject) && !is_string($ivd_parentdataobject)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_parentdataobject, true), gettype($ivd_parentdataobject)), __LINE__);
        }
        if (is_null($ivd_parentdataobject) || (is_array($ivd_parentdataobject) && empty($ivd_parentdataobject))) {
            unset($this->ivd_parentdataobject);
        } else {
            $this->ivd_parentdataobject = $ivd_parentdataobject;
        }
        
        return $this;
    }
    /**
     * Get ivd_reg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_reg_key(): ?string
    {
        return $this->ivd_reg_key ?? null;
    }
    /**
     * Set ivd_reg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_reg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_reg_key(?string $ivd_reg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_reg_key) && !is_string($ivd_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_reg_key, true), gettype($ivd_reg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ivd_reg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ivd_reg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ivd_reg_key, true)), __LINE__);
        }
        if (is_null($ivd_reg_key) || (is_array($ivd_reg_key) && empty($ivd_reg_key))) {
            unset($this->ivd_reg_key);
        } else {
            $this->ivd_reg_key = $ivd_reg_key;
        }
        
        return $this;
    }
    /**
     * Get ivd_addl_info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_addl_info(): ?string
    {
        return $this->ivd_addl_info ?? null;
    }
    /**
     * Set ivd_addl_info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_addl_info
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_addl_info(?string $ivd_addl_info = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_addl_info) && !is_string($ivd_addl_info)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_addl_info, true), gettype($ivd_addl_info)), __LINE__);
        }
        if (is_null($ivd_addl_info) || (is_array($ivd_addl_info) && empty($ivd_addl_info))) {
            unset($this->ivd_addl_info);
        } else {
            $this->ivd_addl_info = $ivd_addl_info;
        }
        
        return $this;
    }
    /**
     * Get ivd_shippable_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd_shippable_flag(): ?string
    {
        return $this->ivd_shippable_flag ?? null;
    }
    /**
     * Set ivd_shippable_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd_shippable_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_shippable_flag(?string $ivd_shippable_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd_shippable_flag) && !is_string($ivd_shippable_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd_shippable_flag, true), gettype($ivd_shippable_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ivd_shippable_flag) && $ivd_shippable_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ivd_shippable_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ivd_shippable_flag) && $ivd_shippable_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ivd_shippable_flag, true)), __LINE__);
        }
        if (is_null($ivd_shippable_flag) || (is_array($ivd_shippable_flag) && empty($ivd_shippable_flag))) {
            unset($this->ivd_shippable_flag);
        } else {
            $this->ivd_shippable_flag = $ivd_shippable_flag;
        }
        
        return $this;
    }
    /**
     * Get ivd_ods_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIvd_ods_number(): ?int
    {
        return $this->ivd_ods_number ?? null;
    }
    /**
     * Set ivd_ods_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ivd_ods_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_ods_number(?int $ivd_ods_number = null): self
    {
        // validation for constraint: int
        if (!is_null($ivd_ods_number) && !(is_int($ivd_ods_number) || ctype_digit($ivd_ods_number))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ivd_ods_number, true), gettype($ivd_ods_number)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ivd_ods_number) && $ivd_ods_number > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ivd_ods_number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ivd_ods_number) && $ivd_ods_number < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ivd_ods_number, true)), __LINE__);
        }
        if (is_null($ivd_ods_number) || (is_array($ivd_ods_number) && empty($ivd_ods_number))) {
            unset($this->ivd_ods_number);
        } else {
            $this->ivd_ods_number = $ivd_ods_number;
        }
        
        return $this;
    }
    /**
     * Get ivd_credit_to_distribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_credit_to_distribute(): ?float
    {
        return $this->ivd_credit_to_distribute ?? null;
    }
    /**
     * Set ivd_credit_to_distribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_credit_to_distribute
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_credit_to_distribute(?float $ivd_credit_to_distribute = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_credit_to_distribute) && !(is_float($ivd_credit_to_distribute) || is_numeric($ivd_credit_to_distribute))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_credit_to_distribute, true), gettype($ivd_credit_to_distribute)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_credit_to_distribute) && mb_strlen(mb_substr((string) $ivd_credit_to_distribute, false !== mb_strpos((string) $ivd_credit_to_distribute, '.') ? mb_strpos((string) $ivd_credit_to_distribute, '.') + 1 : mb_strlen((string) $ivd_credit_to_distribute))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_credit_to_distribute, true), mb_strlen(mb_substr((string) $ivd_credit_to_distribute, mb_strpos((string) $ivd_credit_to_distribute, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_credit_to_distribute) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_credit_to_distribute)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_credit_to_distribute, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_credit_to_distribute))), __LINE__);
        }
        if (is_null($ivd_credit_to_distribute) || (is_array($ivd_credit_to_distribute) && empty($ivd_credit_to_distribute))) {
            unset($this->ivd_credit_to_distribute);
        } else {
            $this->ivd_credit_to_distribute = $ivd_credit_to_distribute;
        }
        
        return $this;
    }
    /**
     * Get ivd_inv_shippable_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_inv_shippable_total(): ?float
    {
        return $this->ivd_inv_shippable_total ?? null;
    }
    /**
     * Set ivd_inv_shippable_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_inv_shippable_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_inv_shippable_total(?float $ivd_inv_shippable_total = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_inv_shippable_total) && !(is_float($ivd_inv_shippable_total) || is_numeric($ivd_inv_shippable_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_inv_shippable_total, true), gettype($ivd_inv_shippable_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_inv_shippable_total) && mb_strlen(mb_substr((string) $ivd_inv_shippable_total, false !== mb_strpos((string) $ivd_inv_shippable_total, '.') ? mb_strpos((string) $ivd_inv_shippable_total, '.') + 1 : mb_strlen((string) $ivd_inv_shippable_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_inv_shippable_total, true), mb_strlen(mb_substr((string) $ivd_inv_shippable_total, mb_strpos((string) $ivd_inv_shippable_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_inv_shippable_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_inv_shippable_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_inv_shippable_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_inv_shippable_total))), __LINE__);
        }
        if (is_null($ivd_inv_shippable_total) || (is_array($ivd_inv_shippable_total) && empty($ivd_inv_shippable_total))) {
            unset($this->ivd_inv_shippable_total);
        } else {
            $this->ivd_inv_shippable_total = $ivd_inv_shippable_total;
        }
        
        return $this;
    }
    /**
     * Get ivd_inv_distributable_credit_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvd_inv_distributable_credit_total(): ?float
    {
        return $this->ivd_inv_distributable_credit_total ?? null;
    }
    /**
     * Set ivd_inv_distributable_credit_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivd_inv_distributable_credit_total
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd_inv_distributable_credit_total(?float $ivd_inv_distributable_credit_total = null): self
    {
        // validation for constraint: float
        if (!is_null($ivd_inv_distributable_credit_total) && !(is_float($ivd_inv_distributable_credit_total) || is_numeric($ivd_inv_distributable_credit_total))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ivd_inv_distributable_credit_total, true), gettype($ivd_inv_distributable_credit_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ivd_inv_distributable_credit_total) && mb_strlen(mb_substr((string) $ivd_inv_distributable_credit_total, false !== mb_strpos((string) $ivd_inv_distributable_credit_total, '.') ? mb_strpos((string) $ivd_inv_distributable_credit_total, '.') + 1 : mb_strlen((string) $ivd_inv_distributable_credit_total))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ivd_inv_distributable_credit_total, true), mb_strlen(mb_substr((string) $ivd_inv_distributable_credit_total, mb_strpos((string) $ivd_inv_distributable_credit_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ivd_inv_distributable_credit_total) && mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_inv_distributable_credit_total)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ivd_inv_distributable_credit_total, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ivd_inv_distributable_credit_total))), __LINE__);
        }
        if (is_null($ivd_inv_distributable_credit_total) || (is_array($ivd_inv_distributable_credit_total) && empty($ivd_inv_distributable_credit_total))) {
            unset($this->ivd_inv_distributable_credit_total);
        } else {
            $this->ivd_inv_distributable_credit_total = $ivd_inv_distributable_credit_total;
        }
        
        return $this;
    }
    /**
     * Get ivd__agy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIvd__agy(): ?string
    {
        return $this->ivd__agy ?? null;
    }
    /**
     * Set ivd__agy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ivd__agy
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_DataObjectType
     */
    public function setIvd__agy(?string $ivd__agy = null): self
    {
        // validation for constraint: string
        if (!is_null($ivd__agy) && !is_string($ivd__agy)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ivd__agy, true), gettype($ivd__agy)), __LINE__);
        }
        if (is_null($ivd__agy) || (is_array($ivd__agy) && empty($ivd__agy))) {
            unset($this->ivd__agy);
        } else {
            $this->ivd__agy = $ivd__agy;
        }
        
        return $this;
    }
}
