<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType extends AbstractStructBase
{
    /**
     * The igb_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: igb_ivd_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $igb_ivd_key = null;
    /**
     * The igb_inv_key
     * Meta information extracted from the WSDL
     * - documentation: igb_inv_key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $igb_inv_key = null;
    /**
     * The igb_ivd_qty
     * Meta information extracted from the WSDL
     * - documentation: igb_ivd_qty. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_ivd_qty = null;
    /**
     * The igb_ship_qty
     * Meta information extracted from the WSDL
     * - documentation: igb_ship_qty. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_ship_qty = null;
    /**
     * The igb_ivd_price
     * Meta information extracted from the WSDL
     * - documentation: igb_ivd_price. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $igb_ivd_price = null;
    /**
     * The igb_unit_price_with_discount
     * Meta information extracted from the WSDL
     * - documentation: igb_unit_price_with_discount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_unit_price_with_discount = null;
    /**
     * The igb_lineamount
     * Meta information extracted from the WSDL
     * - documentation: igb_lineamount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_lineamount = null;
    /**
     * The igb_lineamount_no_discount
     * Meta information extracted from the WSDL
     * - documentation: igb_lineamount_no_discount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_lineamount_no_discount = null;
    /**
     * The igb_originallineamount
     * Meta information extracted from the WSDL
     * - documentation: igb_originallineamount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_originallineamount = null;
    /**
     * The igb_payamount
     * Meta information extracted from the WSDL
     * - documentation: igb_payamount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $igb_payamount = null;
    /**
     * The igb_payamount_noreturn
     * Meta information extracted from the WSDL
     * - documentation: igb_payamount_noreturn. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $igb_payamount_noreturn = null;
    /**
     * The igb_linebalance
     * Meta information extracted from the WSDL
     * - documentation: igb_linebalance. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_linebalance = null;
    /**
     * The igb_returnquantity
     * Meta information extracted from the WSDL
     * - documentation: igb_returnquantity. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_returnquantity = null;
    /**
     * The igb_cancelquantity
     * Meta information extracted from the WSDL
     * - documentation: igb_cancelquantity. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_cancelquantity = null;
    /**
     * The igb_minimumquantity
     * Meta information extracted from the WSDL
     * - documentation: igb_minimumquantity. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_minimumquantity = null;
    /**
     * The igb_available_for_return
     * Meta information extracted from the WSDL
     * - documentation: igb_available_for_return. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_available_for_return = null;
    /**
     * The igb_available_for_cancel
     * Meta information extracted from the WSDL
     * - documentation: igb_available_for_cancel. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_available_for_cancel = null;
    /**
     * The igb_balance_quantity
     * Meta information extracted from the WSDL
     * - documentation: igb_balance_quantity. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_balance_quantity = null;
    /**
     * The igb_CreditDollarAmount
     * Meta information extracted from the WSDL
     * - documentation: igb_CreditDollarAmount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_CreditDollarAmount = null;
    /**
     * The igb_TotalRecognized
     * Meta information extracted from the WSDL
     * - documentation: igb_TotalRecognized. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_TotalRecognized = null;
    /**
     * The igb_DeferralBalance
     * Meta information extracted from the WSDL
     * - documentation: igb_DeferralBalance. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $igb_DeferralBalance = null;
    /**
     * The igb_Deferral_Price
     * Meta information extracted from the WSDL
     * - documentation: igb_Deferral_Price. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $igb_Deferral_Price = null;
    /**
     * The igb_Deferral_Number_Periods
     * Meta information extracted from the WSDL
     * - documentation: igb_Deferral_Number_Periods. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $igb_Deferral_Number_Periods = null;
    /**
     * The igb_Deferral_Number_Periods_Recognized
     * Meta information extracted from the WSDL
     * - documentation: igb_Deferral_Number_Periods_Recognized. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $igb_Deferral_Number_Periods_Recognized = null;
    /**
     * The igb_Tax
     * Meta information extracted from the WSDL
     * - documentation: igb_Tax. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $igb_Tax = null;
    /**
     * The igb_Shipping
     * Meta information extracted from the WSDL
     * - documentation: igb_Shipping. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $igb_Shipping = null;
    /**
     * The igb_discountamount
     * Meta information extracted from the WSDL
     * - documentation: igb_discountamount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $igb_discountamount = null;
    /**
     * The igb_TransactionCurrencyKey
     * Meta information extracted from the WSDL
     * - documentation: igb_TransactionCurrencyKey. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $igb_TransactionCurrencyKey = null;
    /**
     * The igb_HomeCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: igb_HomeCurrencyCode. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $igb_HomeCurrencyCode = null;
    /**
     * The igb_MulticurrencyKey
     * Meta information extracted from the WSDL
     * - documentation: igb_MulticurrencyKey. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $igb_MulticurrencyKey = null;
    /**
     * The igb_writeoffamount
     * Meta information extracted from the WSDL
     * - documentation: igb_writeoffamount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $igb_writeoffamount = null;
    /**
     * Constructor method for InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_ivd_key()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_inv_key()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_ivd_qty()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_ship_qty()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_ivd_price()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_unit_price_with_discount()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_lineamount()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_lineamount_no_discount()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_originallineamount()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_payamount()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_payamount_noreturn()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_linebalance()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_returnquantity()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_cancelquantity()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_minimumquantity()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_available_for_return()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_available_for_cancel()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_balance_quantity()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_CreditDollarAmount()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_TotalRecognized()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_DeferralBalance()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_Deferral_Price()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_Deferral_Number_Periods()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_Deferral_Number_Periods_Recognized()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_Tax()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_Shipping()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_discountamount()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_TransactionCurrencyKey()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_HomeCurrencyCode()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_MulticurrencyKey()
     * @uses InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType::setIgb_writeoffamount()
     * @param string $igb_ivd_key
     * @param string $igb_inv_key
     * @param float $igb_ivd_qty
     * @param float $igb_ship_qty
     * @param float $igb_ivd_price
     * @param float $igb_unit_price_with_discount
     * @param float $igb_lineamount
     * @param float $igb_lineamount_no_discount
     * @param float $igb_originallineamount
     * @param float $igb_payamount
     * @param float $igb_payamount_noreturn
     * @param float $igb_linebalance
     * @param float $igb_returnquantity
     * @param float $igb_cancelquantity
     * @param float $igb_minimumquantity
     * @param float $igb_available_for_return
     * @param float $igb_available_for_cancel
     * @param float $igb_balance_quantity
     * @param float $igb_CreditDollarAmount
     * @param float $igb_TotalRecognized
     * @param float $igb_DeferralBalance
     * @param float $igb_Deferral_Price
     * @param int $igb_Deferral_Number_Periods
     * @param int $igb_Deferral_Number_Periods_Recognized
     * @param float $igb_Tax
     * @param float $igb_Shipping
     * @param float $igb_discountamount
     * @param string $igb_TransactionCurrencyKey
     * @param string $igb_HomeCurrencyCode
     * @param string $igb_MulticurrencyKey
     * @param float $igb_writeoffamount
     */
    public function __construct(?string $igb_ivd_key = null, ?string $igb_inv_key = null, ?float $igb_ivd_qty = null, ?float $igb_ship_qty = null, ?float $igb_ivd_price = null, ?float $igb_unit_price_with_discount = null, ?float $igb_lineamount = null, ?float $igb_lineamount_no_discount = null, ?float $igb_originallineamount = null, ?float $igb_payamount = null, ?float $igb_payamount_noreturn = null, ?float $igb_linebalance = null, ?float $igb_returnquantity = null, ?float $igb_cancelquantity = null, ?float $igb_minimumquantity = null, ?float $igb_available_for_return = null, ?float $igb_available_for_cancel = null, ?float $igb_balance_quantity = null, ?float $igb_CreditDollarAmount = null, ?float $igb_TotalRecognized = null, ?float $igb_DeferralBalance = null, ?float $igb_Deferral_Price = null, ?int $igb_Deferral_Number_Periods = null, ?int $igb_Deferral_Number_Periods_Recognized = null, ?float $igb_Tax = null, ?float $igb_Shipping = null, ?float $igb_discountamount = null, ?string $igb_TransactionCurrencyKey = null, ?string $igb_HomeCurrencyCode = null, ?string $igb_MulticurrencyKey = null, ?float $igb_writeoffamount = null)
    {
        $this
            ->setIgb_ivd_key($igb_ivd_key)
            ->setIgb_inv_key($igb_inv_key)
            ->setIgb_ivd_qty($igb_ivd_qty)
            ->setIgb_ship_qty($igb_ship_qty)
            ->setIgb_ivd_price($igb_ivd_price)
            ->setIgb_unit_price_with_discount($igb_unit_price_with_discount)
            ->setIgb_lineamount($igb_lineamount)
            ->setIgb_lineamount_no_discount($igb_lineamount_no_discount)
            ->setIgb_originallineamount($igb_originallineamount)
            ->setIgb_payamount($igb_payamount)
            ->setIgb_payamount_noreturn($igb_payamount_noreturn)
            ->setIgb_linebalance($igb_linebalance)
            ->setIgb_returnquantity($igb_returnquantity)
            ->setIgb_cancelquantity($igb_cancelquantity)
            ->setIgb_minimumquantity($igb_minimumquantity)
            ->setIgb_available_for_return($igb_available_for_return)
            ->setIgb_available_for_cancel($igb_available_for_cancel)
            ->setIgb_balance_quantity($igb_balance_quantity)
            ->setIgb_CreditDollarAmount($igb_CreditDollarAmount)
            ->setIgb_TotalRecognized($igb_TotalRecognized)
            ->setIgb_DeferralBalance($igb_DeferralBalance)
            ->setIgb_Deferral_Price($igb_Deferral_Price)
            ->setIgb_Deferral_Number_Periods($igb_Deferral_Number_Periods)
            ->setIgb_Deferral_Number_Periods_Recognized($igb_Deferral_Number_Periods_Recognized)
            ->setIgb_Tax($igb_Tax)
            ->setIgb_Shipping($igb_Shipping)
            ->setIgb_discountamount($igb_discountamount)
            ->setIgb_TransactionCurrencyKey($igb_TransactionCurrencyKey)
            ->setIgb_HomeCurrencyCode($igb_HomeCurrencyCode)
            ->setIgb_MulticurrencyKey($igb_MulticurrencyKey)
            ->setIgb_writeoffamount($igb_writeoffamount);
    }
    /**
     * Get igb_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIgb_ivd_key(): ?string
    {
        return $this->igb_ivd_key ?? null;
    }
    /**
     * Set igb_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $igb_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_ivd_key(?string $igb_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($igb_ivd_key) && !is_string($igb_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($igb_ivd_key, true), gettype($igb_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($igb_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $igb_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($igb_ivd_key, true)), __LINE__);
        }
        if (is_null($igb_ivd_key) || (is_array($igb_ivd_key) && empty($igb_ivd_key))) {
            unset($this->igb_ivd_key);
        } else {
            $this->igb_ivd_key = $igb_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get igb_inv_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIgb_inv_key(): ?string
    {
        return $this->igb_inv_key ?? null;
    }
    /**
     * Set igb_inv_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $igb_inv_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_inv_key(?string $igb_inv_key = null): self
    {
        // validation for constraint: string
        if (!is_null($igb_inv_key) && !is_string($igb_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($igb_inv_key, true), gettype($igb_inv_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($igb_inv_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $igb_inv_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($igb_inv_key, true)), __LINE__);
        }
        if (is_null($igb_inv_key) || (is_array($igb_inv_key) && empty($igb_inv_key))) {
            unset($this->igb_inv_key);
        } else {
            $this->igb_inv_key = $igb_inv_key;
        }
        
        return $this;
    }
    /**
     * Get igb_ivd_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_ivd_qty(): ?float
    {
        return $this->igb_ivd_qty ?? null;
    }
    /**
     * Set igb_ivd_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_ivd_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_ivd_qty(?float $igb_ivd_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_ivd_qty) && !(is_float($igb_ivd_qty) || is_numeric($igb_ivd_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_ivd_qty, true), gettype($igb_ivd_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_ivd_qty) && mb_strlen(mb_substr((string) $igb_ivd_qty, false !== mb_strpos((string) $igb_ivd_qty, '.') ? mb_strpos((string) $igb_ivd_qty, '.') + 1 : mb_strlen((string) $igb_ivd_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_ivd_qty, true), mb_strlen(mb_substr((string) $igb_ivd_qty, mb_strpos((string) $igb_ivd_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_ivd_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_ivd_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_ivd_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_ivd_qty))), __LINE__);
        }
        if (is_null($igb_ivd_qty) || (is_array($igb_ivd_qty) && empty($igb_ivd_qty))) {
            unset($this->igb_ivd_qty);
        } else {
            $this->igb_ivd_qty = $igb_ivd_qty;
        }
        
        return $this;
    }
    /**
     * Get igb_ship_qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_ship_qty(): ?float
    {
        return $this->igb_ship_qty ?? null;
    }
    /**
     * Set igb_ship_qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_ship_qty
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_ship_qty(?float $igb_ship_qty = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_ship_qty) && !(is_float($igb_ship_qty) || is_numeric($igb_ship_qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_ship_qty, true), gettype($igb_ship_qty)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_ship_qty) && mb_strlen(mb_substr((string) $igb_ship_qty, false !== mb_strpos((string) $igb_ship_qty, '.') ? mb_strpos((string) $igb_ship_qty, '.') + 1 : mb_strlen((string) $igb_ship_qty))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_ship_qty, true), mb_strlen(mb_substr((string) $igb_ship_qty, mb_strpos((string) $igb_ship_qty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_ship_qty) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_ship_qty)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_ship_qty, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_ship_qty))), __LINE__);
        }
        if (is_null($igb_ship_qty) || (is_array($igb_ship_qty) && empty($igb_ship_qty))) {
            unset($this->igb_ship_qty);
        } else {
            $this->igb_ship_qty = $igb_ship_qty;
        }
        
        return $this;
    }
    /**
     * Get igb_ivd_price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_ivd_price(): ?float
    {
        return $this->igb_ivd_price ?? null;
    }
    /**
     * Set igb_ivd_price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_ivd_price
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_ivd_price(?float $igb_ivd_price = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_ivd_price) && !(is_float($igb_ivd_price) || is_numeric($igb_ivd_price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_ivd_price, true), gettype($igb_ivd_price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_ivd_price) && mb_strlen(mb_substr((string) $igb_ivd_price, false !== mb_strpos((string) $igb_ivd_price, '.') ? mb_strpos((string) $igb_ivd_price, '.') + 1 : mb_strlen((string) $igb_ivd_price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_ivd_price, true), mb_strlen(mb_substr((string) $igb_ivd_price, mb_strpos((string) $igb_ivd_price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($igb_ivd_price) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_ivd_price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($igb_ivd_price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_ivd_price))), __LINE__);
        }
        if (is_null($igb_ivd_price) || (is_array($igb_ivd_price) && empty($igb_ivd_price))) {
            unset($this->igb_ivd_price);
        } else {
            $this->igb_ivd_price = $igb_ivd_price;
        }
        
        return $this;
    }
    /**
     * Get igb_unit_price_with_discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_unit_price_with_discount(): ?float
    {
        return $this->igb_unit_price_with_discount ?? null;
    }
    /**
     * Set igb_unit_price_with_discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_unit_price_with_discount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_unit_price_with_discount(?float $igb_unit_price_with_discount = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_unit_price_with_discount) && !(is_float($igb_unit_price_with_discount) || is_numeric($igb_unit_price_with_discount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_unit_price_with_discount, true), gettype($igb_unit_price_with_discount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_unit_price_with_discount) && mb_strlen(mb_substr((string) $igb_unit_price_with_discount, false !== mb_strpos((string) $igb_unit_price_with_discount, '.') ? mb_strpos((string) $igb_unit_price_with_discount, '.') + 1 : mb_strlen((string) $igb_unit_price_with_discount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_unit_price_with_discount, true), mb_strlen(mb_substr((string) $igb_unit_price_with_discount, mb_strpos((string) $igb_unit_price_with_discount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_unit_price_with_discount) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_unit_price_with_discount)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_unit_price_with_discount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_unit_price_with_discount))), __LINE__);
        }
        if (is_null($igb_unit_price_with_discount) || (is_array($igb_unit_price_with_discount) && empty($igb_unit_price_with_discount))) {
            unset($this->igb_unit_price_with_discount);
        } else {
            $this->igb_unit_price_with_discount = $igb_unit_price_with_discount;
        }
        
        return $this;
    }
    /**
     * Get igb_lineamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_lineamount(): ?float
    {
        return $this->igb_lineamount ?? null;
    }
    /**
     * Set igb_lineamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_lineamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_lineamount(?float $igb_lineamount = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_lineamount) && !(is_float($igb_lineamount) || is_numeric($igb_lineamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_lineamount, true), gettype($igb_lineamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_lineamount) && mb_strlen(mb_substr((string) $igb_lineamount, false !== mb_strpos((string) $igb_lineamount, '.') ? mb_strpos((string) $igb_lineamount, '.') + 1 : mb_strlen((string) $igb_lineamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_lineamount, true), mb_strlen(mb_substr((string) $igb_lineamount, mb_strpos((string) $igb_lineamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_lineamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_lineamount)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_lineamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_lineamount))), __LINE__);
        }
        if (is_null($igb_lineamount) || (is_array($igb_lineamount) && empty($igb_lineamount))) {
            unset($this->igb_lineamount);
        } else {
            $this->igb_lineamount = $igb_lineamount;
        }
        
        return $this;
    }
    /**
     * Get igb_lineamount_no_discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_lineamount_no_discount(): ?float
    {
        return $this->igb_lineamount_no_discount ?? null;
    }
    /**
     * Set igb_lineamount_no_discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_lineamount_no_discount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_lineamount_no_discount(?float $igb_lineamount_no_discount = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_lineamount_no_discount) && !(is_float($igb_lineamount_no_discount) || is_numeric($igb_lineamount_no_discount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_lineamount_no_discount, true), gettype($igb_lineamount_no_discount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_lineamount_no_discount) && mb_strlen(mb_substr((string) $igb_lineamount_no_discount, false !== mb_strpos((string) $igb_lineamount_no_discount, '.') ? mb_strpos((string) $igb_lineamount_no_discount, '.') + 1 : mb_strlen((string) $igb_lineamount_no_discount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_lineamount_no_discount, true), mb_strlen(mb_substr((string) $igb_lineamount_no_discount, mb_strpos((string) $igb_lineamount_no_discount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_lineamount_no_discount) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_lineamount_no_discount)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_lineamount_no_discount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_lineamount_no_discount))), __LINE__);
        }
        if (is_null($igb_lineamount_no_discount) || (is_array($igb_lineamount_no_discount) && empty($igb_lineamount_no_discount))) {
            unset($this->igb_lineamount_no_discount);
        } else {
            $this->igb_lineamount_no_discount = $igb_lineamount_no_discount;
        }
        
        return $this;
    }
    /**
     * Get igb_originallineamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_originallineamount(): ?float
    {
        return $this->igb_originallineamount ?? null;
    }
    /**
     * Set igb_originallineamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_originallineamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_originallineamount(?float $igb_originallineamount = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_originallineamount) && !(is_float($igb_originallineamount) || is_numeric($igb_originallineamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_originallineamount, true), gettype($igb_originallineamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_originallineamount) && mb_strlen(mb_substr((string) $igb_originallineamount, false !== mb_strpos((string) $igb_originallineamount, '.') ? mb_strpos((string) $igb_originallineamount, '.') + 1 : mb_strlen((string) $igb_originallineamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_originallineamount, true), mb_strlen(mb_substr((string) $igb_originallineamount, mb_strpos((string) $igb_originallineamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_originallineamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_originallineamount)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_originallineamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_originallineamount))), __LINE__);
        }
        if (is_null($igb_originallineamount) || (is_array($igb_originallineamount) && empty($igb_originallineamount))) {
            unset($this->igb_originallineamount);
        } else {
            $this->igb_originallineamount = $igb_originallineamount;
        }
        
        return $this;
    }
    /**
     * Get igb_payamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_payamount(): ?float
    {
        return $this->igb_payamount ?? null;
    }
    /**
     * Set igb_payamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_payamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_payamount(?float $igb_payamount = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_payamount) && !(is_float($igb_payamount) || is_numeric($igb_payamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_payamount, true), gettype($igb_payamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_payamount) && mb_strlen(mb_substr((string) $igb_payamount, false !== mb_strpos((string) $igb_payamount, '.') ? mb_strpos((string) $igb_payamount, '.') + 1 : mb_strlen((string) $igb_payamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_payamount, true), mb_strlen(mb_substr((string) $igb_payamount, mb_strpos((string) $igb_payamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($igb_payamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_payamount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($igb_payamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_payamount))), __LINE__);
        }
        if (is_null($igb_payamount) || (is_array($igb_payamount) && empty($igb_payamount))) {
            unset($this->igb_payamount);
        } else {
            $this->igb_payamount = $igb_payamount;
        }
        
        return $this;
    }
    /**
     * Get igb_payamount_noreturn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_payamount_noreturn(): ?float
    {
        return $this->igb_payamount_noreturn ?? null;
    }
    /**
     * Set igb_payamount_noreturn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_payamount_noreturn
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_payamount_noreturn(?float $igb_payamount_noreturn = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_payamount_noreturn) && !(is_float($igb_payamount_noreturn) || is_numeric($igb_payamount_noreturn))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_payamount_noreturn, true), gettype($igb_payamount_noreturn)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_payamount_noreturn) && mb_strlen(mb_substr((string) $igb_payamount_noreturn, false !== mb_strpos((string) $igb_payamount_noreturn, '.') ? mb_strpos((string) $igb_payamount_noreturn, '.') + 1 : mb_strlen((string) $igb_payamount_noreturn))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_payamount_noreturn, true), mb_strlen(mb_substr((string) $igb_payamount_noreturn, mb_strpos((string) $igb_payamount_noreturn, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($igb_payamount_noreturn) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_payamount_noreturn)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($igb_payamount_noreturn, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_payamount_noreturn))), __LINE__);
        }
        if (is_null($igb_payamount_noreturn) || (is_array($igb_payamount_noreturn) && empty($igb_payamount_noreturn))) {
            unset($this->igb_payamount_noreturn);
        } else {
            $this->igb_payamount_noreturn = $igb_payamount_noreturn;
        }
        
        return $this;
    }
    /**
     * Get igb_linebalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_linebalance(): ?float
    {
        return $this->igb_linebalance ?? null;
    }
    /**
     * Set igb_linebalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_linebalance
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_linebalance(?float $igb_linebalance = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_linebalance) && !(is_float($igb_linebalance) || is_numeric($igb_linebalance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_linebalance, true), gettype($igb_linebalance)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($igb_linebalance) && mb_strlen(mb_substr((string) $igb_linebalance, false !== mb_strpos((string) $igb_linebalance, '.') ? mb_strpos((string) $igb_linebalance, '.') + 1 : mb_strlen((string) $igb_linebalance))) > 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($igb_linebalance, true), mb_strlen(mb_substr((string) $igb_linebalance, mb_strpos((string) $igb_linebalance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_linebalance) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_linebalance)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_linebalance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_linebalance))), __LINE__);
        }
        if (is_null($igb_linebalance) || (is_array($igb_linebalance) && empty($igb_linebalance))) {
            unset($this->igb_linebalance);
        } else {
            $this->igb_linebalance = $igb_linebalance;
        }
        
        return $this;
    }
    /**
     * Get igb_returnquantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_returnquantity(): ?float
    {
        return $this->igb_returnquantity ?? null;
    }
    /**
     * Set igb_returnquantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_returnquantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_returnquantity(?float $igb_returnquantity = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_returnquantity) && !(is_float($igb_returnquantity) || is_numeric($igb_returnquantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_returnquantity, true), gettype($igb_returnquantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_returnquantity) && mb_strlen(mb_substr((string) $igb_returnquantity, false !== mb_strpos((string) $igb_returnquantity, '.') ? mb_strpos((string) $igb_returnquantity, '.') + 1 : mb_strlen((string) $igb_returnquantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_returnquantity, true), mb_strlen(mb_substr((string) $igb_returnquantity, mb_strpos((string) $igb_returnquantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_returnquantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_returnquantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_returnquantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_returnquantity))), __LINE__);
        }
        if (is_null($igb_returnquantity) || (is_array($igb_returnquantity) && empty($igb_returnquantity))) {
            unset($this->igb_returnquantity);
        } else {
            $this->igb_returnquantity = $igb_returnquantity;
        }
        
        return $this;
    }
    /**
     * Get igb_cancelquantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_cancelquantity(): ?float
    {
        return $this->igb_cancelquantity ?? null;
    }
    /**
     * Set igb_cancelquantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_cancelquantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_cancelquantity(?float $igb_cancelquantity = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_cancelquantity) && !(is_float($igb_cancelquantity) || is_numeric($igb_cancelquantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_cancelquantity, true), gettype($igb_cancelquantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_cancelquantity) && mb_strlen(mb_substr((string) $igb_cancelquantity, false !== mb_strpos((string) $igb_cancelquantity, '.') ? mb_strpos((string) $igb_cancelquantity, '.') + 1 : mb_strlen((string) $igb_cancelquantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_cancelquantity, true), mb_strlen(mb_substr((string) $igb_cancelquantity, mb_strpos((string) $igb_cancelquantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_cancelquantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_cancelquantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_cancelquantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_cancelquantity))), __LINE__);
        }
        if (is_null($igb_cancelquantity) || (is_array($igb_cancelquantity) && empty($igb_cancelquantity))) {
            unset($this->igb_cancelquantity);
        } else {
            $this->igb_cancelquantity = $igb_cancelquantity;
        }
        
        return $this;
    }
    /**
     * Get igb_minimumquantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_minimumquantity(): ?float
    {
        return $this->igb_minimumquantity ?? null;
    }
    /**
     * Set igb_minimumquantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_minimumquantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_minimumquantity(?float $igb_minimumquantity = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_minimumquantity) && !(is_float($igb_minimumquantity) || is_numeric($igb_minimumquantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_minimumquantity, true), gettype($igb_minimumquantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_minimumquantity) && mb_strlen(mb_substr((string) $igb_minimumquantity, false !== mb_strpos((string) $igb_minimumquantity, '.') ? mb_strpos((string) $igb_minimumquantity, '.') + 1 : mb_strlen((string) $igb_minimumquantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_minimumquantity, true), mb_strlen(mb_substr((string) $igb_minimumquantity, mb_strpos((string) $igb_minimumquantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_minimumquantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_minimumquantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_minimumquantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_minimumquantity))), __LINE__);
        }
        if (is_null($igb_minimumquantity) || (is_array($igb_minimumquantity) && empty($igb_minimumquantity))) {
            unset($this->igb_minimumquantity);
        } else {
            $this->igb_minimumquantity = $igb_minimumquantity;
        }
        
        return $this;
    }
    /**
     * Get igb_available_for_return value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_available_for_return(): ?float
    {
        return $this->igb_available_for_return ?? null;
    }
    /**
     * Set igb_available_for_return value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_available_for_return
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_available_for_return(?float $igb_available_for_return = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_available_for_return) && !(is_float($igb_available_for_return) || is_numeric($igb_available_for_return))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_available_for_return, true), gettype($igb_available_for_return)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_available_for_return) && mb_strlen(mb_substr((string) $igb_available_for_return, false !== mb_strpos((string) $igb_available_for_return, '.') ? mb_strpos((string) $igb_available_for_return, '.') + 1 : mb_strlen((string) $igb_available_for_return))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_available_for_return, true), mb_strlen(mb_substr((string) $igb_available_for_return, mb_strpos((string) $igb_available_for_return, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_available_for_return) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_available_for_return)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_available_for_return, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_available_for_return))), __LINE__);
        }
        if (is_null($igb_available_for_return) || (is_array($igb_available_for_return) && empty($igb_available_for_return))) {
            unset($this->igb_available_for_return);
        } else {
            $this->igb_available_for_return = $igb_available_for_return;
        }
        
        return $this;
    }
    /**
     * Get igb_available_for_cancel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_available_for_cancel(): ?float
    {
        return $this->igb_available_for_cancel ?? null;
    }
    /**
     * Set igb_available_for_cancel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_available_for_cancel
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_available_for_cancel(?float $igb_available_for_cancel = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_available_for_cancel) && !(is_float($igb_available_for_cancel) || is_numeric($igb_available_for_cancel))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_available_for_cancel, true), gettype($igb_available_for_cancel)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_available_for_cancel) && mb_strlen(mb_substr((string) $igb_available_for_cancel, false !== mb_strpos((string) $igb_available_for_cancel, '.') ? mb_strpos((string) $igb_available_for_cancel, '.') + 1 : mb_strlen((string) $igb_available_for_cancel))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_available_for_cancel, true), mb_strlen(mb_substr((string) $igb_available_for_cancel, mb_strpos((string) $igb_available_for_cancel, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_available_for_cancel) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_available_for_cancel)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_available_for_cancel, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_available_for_cancel))), __LINE__);
        }
        if (is_null($igb_available_for_cancel) || (is_array($igb_available_for_cancel) && empty($igb_available_for_cancel))) {
            unset($this->igb_available_for_cancel);
        } else {
            $this->igb_available_for_cancel = $igb_available_for_cancel;
        }
        
        return $this;
    }
    /**
     * Get igb_balance_quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_balance_quantity(): ?float
    {
        return $this->igb_balance_quantity ?? null;
    }
    /**
     * Set igb_balance_quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_balance_quantity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_balance_quantity(?float $igb_balance_quantity = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_balance_quantity) && !(is_float($igb_balance_quantity) || is_numeric($igb_balance_quantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_balance_quantity, true), gettype($igb_balance_quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_balance_quantity) && mb_strlen(mb_substr((string) $igb_balance_quantity, false !== mb_strpos((string) $igb_balance_quantity, '.') ? mb_strpos((string) $igb_balance_quantity, '.') + 1 : mb_strlen((string) $igb_balance_quantity))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_balance_quantity, true), mb_strlen(mb_substr((string) $igb_balance_quantity, mb_strpos((string) $igb_balance_quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_balance_quantity) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_balance_quantity)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_balance_quantity, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_balance_quantity))), __LINE__);
        }
        if (is_null($igb_balance_quantity) || (is_array($igb_balance_quantity) && empty($igb_balance_quantity))) {
            unset($this->igb_balance_quantity);
        } else {
            $this->igb_balance_quantity = $igb_balance_quantity;
        }
        
        return $this;
    }
    /**
     * Get igb_CreditDollarAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_CreditDollarAmount(): ?float
    {
        return $this->igb_CreditDollarAmount ?? null;
    }
    /**
     * Set igb_CreditDollarAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_CreditDollarAmount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_CreditDollarAmount(?float $igb_CreditDollarAmount = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_CreditDollarAmount) && !(is_float($igb_CreditDollarAmount) || is_numeric($igb_CreditDollarAmount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_CreditDollarAmount, true), gettype($igb_CreditDollarAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_CreditDollarAmount) && mb_strlen(mb_substr((string) $igb_CreditDollarAmount, false !== mb_strpos((string) $igb_CreditDollarAmount, '.') ? mb_strpos((string) $igb_CreditDollarAmount, '.') + 1 : mb_strlen((string) $igb_CreditDollarAmount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_CreditDollarAmount, true), mb_strlen(mb_substr((string) $igb_CreditDollarAmount, mb_strpos((string) $igb_CreditDollarAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_CreditDollarAmount) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_CreditDollarAmount)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_CreditDollarAmount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_CreditDollarAmount))), __LINE__);
        }
        if (is_null($igb_CreditDollarAmount) || (is_array($igb_CreditDollarAmount) && empty($igb_CreditDollarAmount))) {
            unset($this->igb_CreditDollarAmount);
        } else {
            $this->igb_CreditDollarAmount = $igb_CreditDollarAmount;
        }
        
        return $this;
    }
    /**
     * Get igb_TotalRecognized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_TotalRecognized(): ?float
    {
        return $this->igb_TotalRecognized ?? null;
    }
    /**
     * Set igb_TotalRecognized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_TotalRecognized
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_TotalRecognized(?float $igb_TotalRecognized = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_TotalRecognized) && !(is_float($igb_TotalRecognized) || is_numeric($igb_TotalRecognized))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_TotalRecognized, true), gettype($igb_TotalRecognized)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_TotalRecognized) && mb_strlen(mb_substr((string) $igb_TotalRecognized, false !== mb_strpos((string) $igb_TotalRecognized, '.') ? mb_strpos((string) $igb_TotalRecognized, '.') + 1 : mb_strlen((string) $igb_TotalRecognized))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_TotalRecognized, true), mb_strlen(mb_substr((string) $igb_TotalRecognized, mb_strpos((string) $igb_TotalRecognized, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_TotalRecognized) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_TotalRecognized)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_TotalRecognized, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_TotalRecognized))), __LINE__);
        }
        if (is_null($igb_TotalRecognized) || (is_array($igb_TotalRecognized) && empty($igb_TotalRecognized))) {
            unset($this->igb_TotalRecognized);
        } else {
            $this->igb_TotalRecognized = $igb_TotalRecognized;
        }
        
        return $this;
    }
    /**
     * Get igb_DeferralBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_DeferralBalance(): ?float
    {
        return $this->igb_DeferralBalance ?? null;
    }
    /**
     * Set igb_DeferralBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_DeferralBalance
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_DeferralBalance(?float $igb_DeferralBalance = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_DeferralBalance) && !(is_float($igb_DeferralBalance) || is_numeric($igb_DeferralBalance))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_DeferralBalance, true), gettype($igb_DeferralBalance)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_DeferralBalance) && mb_strlen(mb_substr((string) $igb_DeferralBalance, false !== mb_strpos((string) $igb_DeferralBalance, '.') ? mb_strpos((string) $igb_DeferralBalance, '.') + 1 : mb_strlen((string) $igb_DeferralBalance))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_DeferralBalance, true), mb_strlen(mb_substr((string) $igb_DeferralBalance, mb_strpos((string) $igb_DeferralBalance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($igb_DeferralBalance) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_DeferralBalance)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($igb_DeferralBalance, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_DeferralBalance))), __LINE__);
        }
        if (is_null($igb_DeferralBalance) || (is_array($igb_DeferralBalance) && empty($igb_DeferralBalance))) {
            unset($this->igb_DeferralBalance);
        } else {
            $this->igb_DeferralBalance = $igb_DeferralBalance;
        }
        
        return $this;
    }
    /**
     * Get igb_Deferral_Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_Deferral_Price(): ?float
    {
        return $this->igb_Deferral_Price ?? null;
    }
    /**
     * Set igb_Deferral_Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_Deferral_Price
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_Deferral_Price(?float $igb_Deferral_Price = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_Deferral_Price) && !(is_float($igb_Deferral_Price) || is_numeric($igb_Deferral_Price))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_Deferral_Price, true), gettype($igb_Deferral_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_Deferral_Price) && mb_strlen(mb_substr((string) $igb_Deferral_Price, false !== mb_strpos((string) $igb_Deferral_Price, '.') ? mb_strpos((string) $igb_Deferral_Price, '.') + 1 : mb_strlen((string) $igb_Deferral_Price))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_Deferral_Price, true), mb_strlen(mb_substr((string) $igb_Deferral_Price, mb_strpos((string) $igb_Deferral_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($igb_Deferral_Price) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_Deferral_Price)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($igb_Deferral_Price, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_Deferral_Price))), __LINE__);
        }
        if (is_null($igb_Deferral_Price) || (is_array($igb_Deferral_Price) && empty($igb_Deferral_Price))) {
            unset($this->igb_Deferral_Price);
        } else {
            $this->igb_Deferral_Price = $igb_Deferral_Price;
        }
        
        return $this;
    }
    /**
     * Get igb_Deferral_Number_Periods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIgb_Deferral_Number_Periods(): ?int
    {
        return $this->igb_Deferral_Number_Periods ?? null;
    }
    /**
     * Set igb_Deferral_Number_Periods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $igb_Deferral_Number_Periods
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_Deferral_Number_Periods(?int $igb_Deferral_Number_Periods = null): self
    {
        // validation for constraint: int
        if (!is_null($igb_Deferral_Number_Periods) && !(is_int($igb_Deferral_Number_Periods) || ctype_digit($igb_Deferral_Number_Periods))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($igb_Deferral_Number_Periods, true), gettype($igb_Deferral_Number_Periods)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($igb_Deferral_Number_Periods) && $igb_Deferral_Number_Periods > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($igb_Deferral_Number_Periods, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($igb_Deferral_Number_Periods) && $igb_Deferral_Number_Periods < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($igb_Deferral_Number_Periods, true)), __LINE__);
        }
        if (is_null($igb_Deferral_Number_Periods) || (is_array($igb_Deferral_Number_Periods) && empty($igb_Deferral_Number_Periods))) {
            unset($this->igb_Deferral_Number_Periods);
        } else {
            $this->igb_Deferral_Number_Periods = $igb_Deferral_Number_Periods;
        }
        
        return $this;
    }
    /**
     * Get igb_Deferral_Number_Periods_Recognized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIgb_Deferral_Number_Periods_Recognized(): ?int
    {
        return $this->igb_Deferral_Number_Periods_Recognized ?? null;
    }
    /**
     * Set igb_Deferral_Number_Periods_Recognized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $igb_Deferral_Number_Periods_Recognized
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_Deferral_Number_Periods_Recognized(?int $igb_Deferral_Number_Periods_Recognized = null): self
    {
        // validation for constraint: int
        if (!is_null($igb_Deferral_Number_Periods_Recognized) && !(is_int($igb_Deferral_Number_Periods_Recognized) || ctype_digit($igb_Deferral_Number_Periods_Recognized))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($igb_Deferral_Number_Periods_Recognized, true), gettype($igb_Deferral_Number_Periods_Recognized)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($igb_Deferral_Number_Periods_Recognized) && $igb_Deferral_Number_Periods_Recognized > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($igb_Deferral_Number_Periods_Recognized, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($igb_Deferral_Number_Periods_Recognized) && $igb_Deferral_Number_Periods_Recognized < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($igb_Deferral_Number_Periods_Recognized, true)), __LINE__);
        }
        if (is_null($igb_Deferral_Number_Periods_Recognized) || (is_array($igb_Deferral_Number_Periods_Recognized) && empty($igb_Deferral_Number_Periods_Recognized))) {
            unset($this->igb_Deferral_Number_Periods_Recognized);
        } else {
            $this->igb_Deferral_Number_Periods_Recognized = $igb_Deferral_Number_Periods_Recognized;
        }
        
        return $this;
    }
    /**
     * Get igb_Tax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_Tax(): ?float
    {
        return $this->igb_Tax ?? null;
    }
    /**
     * Set igb_Tax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_Tax
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_Tax(?float $igb_Tax = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_Tax) && !(is_float($igb_Tax) || is_numeric($igb_Tax))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_Tax, true), gettype($igb_Tax)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_Tax) && mb_strlen(mb_substr((string) $igb_Tax, false !== mb_strpos((string) $igb_Tax, '.') ? mb_strpos((string) $igb_Tax, '.') + 1 : mb_strlen((string) $igb_Tax))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_Tax, true), mb_strlen(mb_substr((string) $igb_Tax, mb_strpos((string) $igb_Tax, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($igb_Tax) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_Tax)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($igb_Tax, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_Tax))), __LINE__);
        }
        if (is_null($igb_Tax) || (is_array($igb_Tax) && empty($igb_Tax))) {
            unset($this->igb_Tax);
        } else {
            $this->igb_Tax = $igb_Tax;
        }
        
        return $this;
    }
    /**
     * Get igb_Shipping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_Shipping(): ?float
    {
        return $this->igb_Shipping ?? null;
    }
    /**
     * Set igb_Shipping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_Shipping
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_Shipping(?float $igb_Shipping = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_Shipping) && !(is_float($igb_Shipping) || is_numeric($igb_Shipping))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_Shipping, true), gettype($igb_Shipping)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_Shipping) && mb_strlen(mb_substr((string) $igb_Shipping, false !== mb_strpos((string) $igb_Shipping, '.') ? mb_strpos((string) $igb_Shipping, '.') + 1 : mb_strlen((string) $igb_Shipping))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_Shipping, true), mb_strlen(mb_substr((string) $igb_Shipping, mb_strpos((string) $igb_Shipping, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($igb_Shipping) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_Shipping)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($igb_Shipping, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_Shipping))), __LINE__);
        }
        if (is_null($igb_Shipping) || (is_array($igb_Shipping) && empty($igb_Shipping))) {
            unset($this->igb_Shipping);
        } else {
            $this->igb_Shipping = $igb_Shipping;
        }
        
        return $this;
    }
    /**
     * Get igb_discountamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_discountamount(): ?float
    {
        return $this->igb_discountamount ?? null;
    }
    /**
     * Set igb_discountamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_discountamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_discountamount(?float $igb_discountamount = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_discountamount) && !(is_float($igb_discountamount) || is_numeric($igb_discountamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_discountamount, true), gettype($igb_discountamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_discountamount) && mb_strlen(mb_substr((string) $igb_discountamount, false !== mb_strpos((string) $igb_discountamount, '.') ? mb_strpos((string) $igb_discountamount, '.') + 1 : mb_strlen((string) $igb_discountamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_discountamount, true), mb_strlen(mb_substr((string) $igb_discountamount, mb_strpos((string) $igb_discountamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($igb_discountamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_discountamount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($igb_discountamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_discountamount))), __LINE__);
        }
        if (is_null($igb_discountamount) || (is_array($igb_discountamount) && empty($igb_discountamount))) {
            unset($this->igb_discountamount);
        } else {
            $this->igb_discountamount = $igb_discountamount;
        }
        
        return $this;
    }
    /**
     * Get igb_TransactionCurrencyKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIgb_TransactionCurrencyKey(): ?string
    {
        return $this->igb_TransactionCurrencyKey ?? null;
    }
    /**
     * Set igb_TransactionCurrencyKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $igb_TransactionCurrencyKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_TransactionCurrencyKey(?string $igb_TransactionCurrencyKey = null): self
    {
        // validation for constraint: string
        if (!is_null($igb_TransactionCurrencyKey) && !is_string($igb_TransactionCurrencyKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($igb_TransactionCurrencyKey, true), gettype($igb_TransactionCurrencyKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($igb_TransactionCurrencyKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $igb_TransactionCurrencyKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($igb_TransactionCurrencyKey, true)), __LINE__);
        }
        if (is_null($igb_TransactionCurrencyKey) || (is_array($igb_TransactionCurrencyKey) && empty($igb_TransactionCurrencyKey))) {
            unset($this->igb_TransactionCurrencyKey);
        } else {
            $this->igb_TransactionCurrencyKey = $igb_TransactionCurrencyKey;
        }
        
        return $this;
    }
    /**
     * Get igb_HomeCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIgb_HomeCurrencyCode(): ?string
    {
        return $this->igb_HomeCurrencyCode ?? null;
    }
    /**
     * Set igb_HomeCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $igb_HomeCurrencyCode
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_HomeCurrencyCode(?string $igb_HomeCurrencyCode = null): self
    {
        // validation for constraint: string
        if (!is_null($igb_HomeCurrencyCode) && !is_string($igb_HomeCurrencyCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($igb_HomeCurrencyCode, true), gettype($igb_HomeCurrencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($igb_HomeCurrencyCode) && mb_strlen((string) $igb_HomeCurrencyCode) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $igb_HomeCurrencyCode)), __LINE__);
        }
        if (is_null($igb_HomeCurrencyCode) || (is_array($igb_HomeCurrencyCode) && empty($igb_HomeCurrencyCode))) {
            unset($this->igb_HomeCurrencyCode);
        } else {
            $this->igb_HomeCurrencyCode = $igb_HomeCurrencyCode;
        }
        
        return $this;
    }
    /**
     * Get igb_MulticurrencyKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIgb_MulticurrencyKey(): ?string
    {
        return $this->igb_MulticurrencyKey ?? null;
    }
    /**
     * Set igb_MulticurrencyKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $igb_MulticurrencyKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_MulticurrencyKey(?string $igb_MulticurrencyKey = null): self
    {
        // validation for constraint: string
        if (!is_null($igb_MulticurrencyKey) && !is_string($igb_MulticurrencyKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($igb_MulticurrencyKey, true), gettype($igb_MulticurrencyKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($igb_MulticurrencyKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $igb_MulticurrencyKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($igb_MulticurrencyKey, true)), __LINE__);
        }
        if (is_null($igb_MulticurrencyKey) || (is_array($igb_MulticurrencyKey) && empty($igb_MulticurrencyKey))) {
            unset($this->igb_MulticurrencyKey);
        } else {
            $this->igb_MulticurrencyKey = $igb_MulticurrencyKey;
        }
        
        return $this;
    }
    /**
     * Get igb_writeoffamount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIgb_writeoffamount(): ?float
    {
        return $this->igb_writeoffamount ?? null;
    }
    /**
     * Set igb_writeoffamount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $igb_writeoffamount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_Get_Balance_DataObjectType
     */
    public function setIgb_writeoffamount(?float $igb_writeoffamount = null): self
    {
        // validation for constraint: float
        if (!is_null($igb_writeoffamount) && !(is_float($igb_writeoffamount) || is_numeric($igb_writeoffamount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($igb_writeoffamount, true), gettype($igb_writeoffamount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($igb_writeoffamount) && mb_strlen(mb_substr((string) $igb_writeoffamount, false !== mb_strpos((string) $igb_writeoffamount, '.') ? mb_strpos((string) $igb_writeoffamount, '.') + 1 : mb_strlen((string) $igb_writeoffamount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($igb_writeoffamount, true), mb_strlen(mb_substr((string) $igb_writeoffamount, mb_strpos((string) $igb_writeoffamount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($igb_writeoffamount) && mb_strlen(preg_replace('/(\D)/', '', (string) $igb_writeoffamount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($igb_writeoffamount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $igb_writeoffamount))), __LINE__);
        }
        if (is_null($igb_writeoffamount) || (is_array($igb_writeoffamount) && empty($igb_writeoffamount))) {
            unset($this->igb_writeoffamount);
        } else {
            $this->igb_writeoffamount = $igb_writeoffamount;
        }
        
        return $this;
    }
}
