<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType extends AbstractStructBase
{
    /**
     * The ixi_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixi_key = null;
    /**
     * The ixi_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixi_ivd_key = null;
    /**
     * The ixi_ipr_key
     * Meta information extracted from the WSDL
     * - documentation: IP Range. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixi_ipr_key = null;
    /**
     * The ixi_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixi_add_user = null;
    /**
     * The ixi_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixi_add_date = null;
    /**
     * The ixi_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixi_change_user = null;
    /**
     * The ixi_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixi_change_date = null;
    /**
     * The ixi_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ixi_delete_flag = null;
    /**
     * The ixi_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixi_entity_key = null;
    /**
     * The ixi_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ixi_key_ext = null;
    /**
     * Constructor method for InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_key()
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_ivd_key()
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_ipr_key()
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_add_user()
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_add_date()
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_change_user()
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_change_date()
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_delete_flag()
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_entity_key()
     * @uses InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType::setIxi_key_ext()
     * @param string $ixi_key
     * @param string $ixi_ivd_key
     * @param string $ixi_ipr_key
     * @param string $ixi_add_user
     * @param string $ixi_add_date
     * @param string $ixi_change_user
     * @param string $ixi_change_date
     * @param string $ixi_delete_flag
     * @param string $ixi_entity_key
     * @param string $ixi_key_ext
     */
    public function __construct(?string $ixi_key = null, ?string $ixi_ivd_key = null, ?string $ixi_ipr_key = null, ?string $ixi_add_user = null, ?string $ixi_add_date = null, ?string $ixi_change_user = null, ?string $ixi_change_date = null, ?string $ixi_delete_flag = null, ?string $ixi_entity_key = null, ?string $ixi_key_ext = null)
    {
        $this
            ->setIxi_key($ixi_key)
            ->setIxi_ivd_key($ixi_ivd_key)
            ->setIxi_ipr_key($ixi_ipr_key)
            ->setIxi_add_user($ixi_add_user)
            ->setIxi_add_date($ixi_add_date)
            ->setIxi_change_user($ixi_change_user)
            ->setIxi_change_date($ixi_change_date)
            ->setIxi_delete_flag($ixi_delete_flag)
            ->setIxi_entity_key($ixi_entity_key)
            ->setIxi_key_ext($ixi_key_ext);
    }
    /**
     * Get ixi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_key(): ?string
    {
        return $this->ixi_key ?? null;
    }
    /**
     * Set ixi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_key(?string $ixi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_key) && !is_string($ixi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_key, true), gettype($ixi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixi_key, true)), __LINE__);
        }
        if (is_null($ixi_key) || (is_array($ixi_key) && empty($ixi_key))) {
            unset($this->ixi_key);
        } else {
            $this->ixi_key = $ixi_key;
        }
        
        return $this;
    }
    /**
     * Get ixi_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_ivd_key(): ?string
    {
        return $this->ixi_ivd_key ?? null;
    }
    /**
     * Set ixi_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_ivd_key(?string $ixi_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_ivd_key) && !is_string($ixi_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_ivd_key, true), gettype($ixi_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixi_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixi_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixi_ivd_key, true)), __LINE__);
        }
        if (is_null($ixi_ivd_key) || (is_array($ixi_ivd_key) && empty($ixi_ivd_key))) {
            unset($this->ixi_ivd_key);
        } else {
            $this->ixi_ivd_key = $ixi_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get ixi_ipr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_ipr_key(): ?string
    {
        return $this->ixi_ipr_key ?? null;
    }
    /**
     * Set ixi_ipr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_ipr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_ipr_key(?string $ixi_ipr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_ipr_key) && !is_string($ixi_ipr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_ipr_key, true), gettype($ixi_ipr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixi_ipr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixi_ipr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixi_ipr_key, true)), __LINE__);
        }
        if (is_null($ixi_ipr_key) || (is_array($ixi_ipr_key) && empty($ixi_ipr_key))) {
            unset($this->ixi_ipr_key);
        } else {
            $this->ixi_ipr_key = $ixi_ipr_key;
        }
        
        return $this;
    }
    /**
     * Get ixi_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_add_user(): ?string
    {
        return $this->ixi_add_user ?? null;
    }
    /**
     * Set ixi_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_add_user(?string $ixi_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_add_user) && !is_string($ixi_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_add_user, true), gettype($ixi_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ixi_add_user) && mb_strlen((string) $ixi_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ixi_add_user)), __LINE__);
        }
        if (is_null($ixi_add_user) || (is_array($ixi_add_user) && empty($ixi_add_user))) {
            unset($this->ixi_add_user);
        } else {
            $this->ixi_add_user = $ixi_add_user;
        }
        
        return $this;
    }
    /**
     * Get ixi_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_add_date(): ?string
    {
        return $this->ixi_add_date ?? null;
    }
    /**
     * Set ixi_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_add_date(?string $ixi_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_add_date) && !is_string($ixi_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_add_date, true), gettype($ixi_add_date)), __LINE__);
        }
        if (is_null($ixi_add_date) || (is_array($ixi_add_date) && empty($ixi_add_date))) {
            unset($this->ixi_add_date);
        } else {
            $this->ixi_add_date = $ixi_add_date;
        }
        
        return $this;
    }
    /**
     * Get ixi_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_change_user(): ?string
    {
        return $this->ixi_change_user ?? null;
    }
    /**
     * Set ixi_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_change_user(?string $ixi_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_change_user) && !is_string($ixi_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_change_user, true), gettype($ixi_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ixi_change_user) && mb_strlen((string) $ixi_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ixi_change_user)), __LINE__);
        }
        if (is_null($ixi_change_user) || (is_array($ixi_change_user) && empty($ixi_change_user))) {
            unset($this->ixi_change_user);
        } else {
            $this->ixi_change_user = $ixi_change_user;
        }
        
        return $this;
    }
    /**
     * Get ixi_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_change_date(): ?string
    {
        return $this->ixi_change_date ?? null;
    }
    /**
     * Set ixi_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_change_date(?string $ixi_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_change_date) && !is_string($ixi_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_change_date, true), gettype($ixi_change_date)), __LINE__);
        }
        if (is_null($ixi_change_date) || (is_array($ixi_change_date) && empty($ixi_change_date))) {
            unset($this->ixi_change_date);
        } else {
            $this->ixi_change_date = $ixi_change_date;
        }
        
        return $this;
    }
    /**
     * Get ixi_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_delete_flag(): ?string
    {
        return $this->ixi_delete_flag ?? null;
    }
    /**
     * Set ixi_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_delete_flag(?string $ixi_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_delete_flag) && !is_string($ixi_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_delete_flag, true), gettype($ixi_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ixi_delete_flag) && $ixi_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ixi_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ixi_delete_flag) && $ixi_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ixi_delete_flag, true)), __LINE__);
        }
        if (is_null($ixi_delete_flag) || (is_array($ixi_delete_flag) && empty($ixi_delete_flag))) {
            unset($this->ixi_delete_flag);
        } else {
            $this->ixi_delete_flag = $ixi_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ixi_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_entity_key(): ?string
    {
        return $this->ixi_entity_key ?? null;
    }
    /**
     * Set ixi_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_entity_key(?string $ixi_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_entity_key) && !is_string($ixi_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_entity_key, true), gettype($ixi_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixi_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixi_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixi_entity_key, true)), __LINE__);
        }
        if (is_null($ixi_entity_key) || (is_array($ixi_entity_key) && empty($ixi_entity_key))) {
            unset($this->ixi_entity_key);
        } else {
            $this->ixi_entity_key = $ixi_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ixi_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIxi_key_ext(): ?string
    {
        return $this->ixi_key_ext ?? null;
    }
    /**
     * Set ixi_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ixi_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Invoice_Detail_IP_Range_DataObjectType
     */
    public function setIxi_key_ext(?string $ixi_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ixi_key_ext) && !is_string($ixi_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ixi_key_ext, true), gettype($ixi_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ixi_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ixi_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ixi_key_ext, true)), __LINE__);
        }
        if (is_null($ixi_key_ext) || (is_array($ixi_key_ext) && empty($ixi_key_ext))) {
            unset($this->ixi_key_ext);
        } else {
            $this->ixi_key_ext = $ixi_key_ext;
        }
        
        return $this;
    }
}
