<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Order_Detail_Schedule_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Order_Detail_Schedule_DataObjectType extends AbstractStructBase
{
    /**
     * The ods_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ods_key = null;
    /**
     * The ods_ord_key
     * Meta information extracted from the WSDL
     * - documentation: order. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ods_ord_key = null;
    /**
     * The ods_date
     * Meta information extracted from the WSDL
     * - documentation: schedule date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_date = null;
    /**
     * The ods_amount
     * Meta information extracted from the WSDL
     * - documentation: amount. This field has this Input Mask: 999,999,999.99. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ods_amount = null;
    /**
     * The ods_process_date
     * Meta information extracted from the WSDL
     * - documentation: process date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_process_date = null;
    /**
     * The ods_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_add_user = null;
    /**
     * The ods_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_add_date = null;
    /**
     * The ods_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_change_user = null;
    /**
     * The ods_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_change_date = null;
    /**
     * The ods_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_delete_flag = null;
    /**
     * The ods_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ods_entity_key = null;
    /**
     * The ods_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ods_key_ext = null;
    /**
     * The ods_number
     * Meta information extracted from the WSDL
     * - documentation: schedule number. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ods_number = null;
    /**
     * The ods_ims_key
     * Meta information extracted from the WSDL
     * - documentation: Installment Milestone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ods_ims_key = null;
    /**
     * The ods_void_date
     * Meta information extracted from the WSDL
     * - documentation: void date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_void_date = null;
    /**
     * The ods_void_user
     * Meta information extracted from the WSDL
     * - documentation: void user. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_void_user = null;
    /**
     * The ods_void_flag
     * Meta information extracted from the WSDL
     * - documentation: void. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ods_void_flag = null;
    /**
     * The ods_writeoff_amount
     * Meta information extracted from the WSDL
     * - documentation: Write off amount. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 19
     * @var float|null
     */
    protected ?float $ods_writeoff_amount = null;
    /**
     * Constructor method for InvoiceDetail_Order_Detail_Schedule_DataObjectType
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_key()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_ord_key()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_date()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_amount()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_process_date()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_add_user()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_add_date()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_change_user()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_change_date()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_delete_flag()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_entity_key()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_key_ext()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_number()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_ims_key()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_void_date()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_void_user()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_void_flag()
     * @uses InvoiceDetail_Order_Detail_Schedule_DataObjectType::setOds_writeoff_amount()
     * @param string $ods_key
     * @param string $ods_ord_key
     * @param string $ods_date
     * @param float $ods_amount
     * @param string $ods_process_date
     * @param string $ods_add_user
     * @param string $ods_add_date
     * @param string $ods_change_user
     * @param string $ods_change_date
     * @param string $ods_delete_flag
     * @param string $ods_entity_key
     * @param string $ods_key_ext
     * @param int $ods_number
     * @param string $ods_ims_key
     * @param string $ods_void_date
     * @param string $ods_void_user
     * @param string $ods_void_flag
     * @param float $ods_writeoff_amount
     */
    public function __construct(?string $ods_key = null, ?string $ods_ord_key = null, ?string $ods_date = null, ?float $ods_amount = null, ?string $ods_process_date = null, ?string $ods_add_user = null, ?string $ods_add_date = null, ?string $ods_change_user = null, ?string $ods_change_date = null, ?string $ods_delete_flag = null, ?string $ods_entity_key = null, ?string $ods_key_ext = null, ?int $ods_number = null, ?string $ods_ims_key = null, ?string $ods_void_date = null, ?string $ods_void_user = null, ?string $ods_void_flag = null, ?float $ods_writeoff_amount = null)
    {
        $this
            ->setOds_key($ods_key)
            ->setOds_ord_key($ods_ord_key)
            ->setOds_date($ods_date)
            ->setOds_amount($ods_amount)
            ->setOds_process_date($ods_process_date)
            ->setOds_add_user($ods_add_user)
            ->setOds_add_date($ods_add_date)
            ->setOds_change_user($ods_change_user)
            ->setOds_change_date($ods_change_date)
            ->setOds_delete_flag($ods_delete_flag)
            ->setOds_entity_key($ods_entity_key)
            ->setOds_key_ext($ods_key_ext)
            ->setOds_number($ods_number)
            ->setOds_ims_key($ods_ims_key)
            ->setOds_void_date($ods_void_date)
            ->setOds_void_user($ods_void_user)
            ->setOds_void_flag($ods_void_flag)
            ->setOds_writeoff_amount($ods_writeoff_amount);
    }
    /**
     * Get ods_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_key(): ?string
    {
        return $this->ods_key ?? null;
    }
    /**
     * Set ods_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_key(?string $ods_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_key) && !is_string($ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_key, true), gettype($ods_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ods_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ods_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ods_key, true)), __LINE__);
        }
        if (is_null($ods_key) || (is_array($ods_key) && empty($ods_key))) {
            unset($this->ods_key);
        } else {
            $this->ods_key = $ods_key;
        }
        
        return $this;
    }
    /**
     * Get ods_ord_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_ord_key(): ?string
    {
        return $this->ods_ord_key ?? null;
    }
    /**
     * Set ods_ord_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_ord_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_ord_key(?string $ods_ord_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_ord_key) && !is_string($ods_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_ord_key, true), gettype($ods_ord_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ods_ord_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ods_ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ods_ord_key, true)), __LINE__);
        }
        if (is_null($ods_ord_key) || (is_array($ods_ord_key) && empty($ods_ord_key))) {
            unset($this->ods_ord_key);
        } else {
            $this->ods_ord_key = $ods_ord_key;
        }
        
        return $this;
    }
    /**
     * Get ods_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_date(): ?string
    {
        return $this->ods_date ?? null;
    }
    /**
     * Set ods_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_date(?string $ods_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_date) && !is_string($ods_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_date, true), gettype($ods_date)), __LINE__);
        }
        if (is_null($ods_date) || (is_array($ods_date) && empty($ods_date))) {
            unset($this->ods_date);
        } else {
            $this->ods_date = $ods_date;
        }
        
        return $this;
    }
    /**
     * Get ods_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOds_amount(): ?float
    {
        return $this->ods_amount ?? null;
    }
    /**
     * Set ods_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ods_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_amount(?float $ods_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($ods_amount) && !(is_float($ods_amount) || is_numeric($ods_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ods_amount, true), gettype($ods_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ods_amount) && mb_strlen(mb_substr((string) $ods_amount, false !== mb_strpos((string) $ods_amount, '.') ? mb_strpos((string) $ods_amount, '.') + 1 : mb_strlen((string) $ods_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ods_amount, true), mb_strlen(mb_substr((string) $ods_amount, mb_strpos((string) $ods_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ods_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ods_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ods_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ods_amount))), __LINE__);
        }
        if (is_null($ods_amount) || (is_array($ods_amount) && empty($ods_amount))) {
            unset($this->ods_amount);
        } else {
            $this->ods_amount = $ods_amount;
        }
        
        return $this;
    }
    /**
     * Get ods_process_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_process_date(): ?string
    {
        return $this->ods_process_date ?? null;
    }
    /**
     * Set ods_process_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_process_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_process_date(?string $ods_process_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_process_date) && !is_string($ods_process_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_process_date, true), gettype($ods_process_date)), __LINE__);
        }
        if (is_null($ods_process_date) || (is_array($ods_process_date) && empty($ods_process_date))) {
            unset($this->ods_process_date);
        } else {
            $this->ods_process_date = $ods_process_date;
        }
        
        return $this;
    }
    /**
     * Get ods_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_add_user(): ?string
    {
        return $this->ods_add_user ?? null;
    }
    /**
     * Set ods_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_add_user(?string $ods_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_add_user) && !is_string($ods_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_add_user, true), gettype($ods_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ods_add_user) && mb_strlen((string) $ods_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ods_add_user)), __LINE__);
        }
        if (is_null($ods_add_user) || (is_array($ods_add_user) && empty($ods_add_user))) {
            unset($this->ods_add_user);
        } else {
            $this->ods_add_user = $ods_add_user;
        }
        
        return $this;
    }
    /**
     * Get ods_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_add_date(): ?string
    {
        return $this->ods_add_date ?? null;
    }
    /**
     * Set ods_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_add_date(?string $ods_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_add_date) && !is_string($ods_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_add_date, true), gettype($ods_add_date)), __LINE__);
        }
        if (is_null($ods_add_date) || (is_array($ods_add_date) && empty($ods_add_date))) {
            unset($this->ods_add_date);
        } else {
            $this->ods_add_date = $ods_add_date;
        }
        
        return $this;
    }
    /**
     * Get ods_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_change_user(): ?string
    {
        return $this->ods_change_user ?? null;
    }
    /**
     * Set ods_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_change_user(?string $ods_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_change_user) && !is_string($ods_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_change_user, true), gettype($ods_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ods_change_user) && mb_strlen((string) $ods_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ods_change_user)), __LINE__);
        }
        if (is_null($ods_change_user) || (is_array($ods_change_user) && empty($ods_change_user))) {
            unset($this->ods_change_user);
        } else {
            $this->ods_change_user = $ods_change_user;
        }
        
        return $this;
    }
    /**
     * Get ods_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_change_date(): ?string
    {
        return $this->ods_change_date ?? null;
    }
    /**
     * Set ods_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_change_date(?string $ods_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_change_date) && !is_string($ods_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_change_date, true), gettype($ods_change_date)), __LINE__);
        }
        if (is_null($ods_change_date) || (is_array($ods_change_date) && empty($ods_change_date))) {
            unset($this->ods_change_date);
        } else {
            $this->ods_change_date = $ods_change_date;
        }
        
        return $this;
    }
    /**
     * Get ods_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_delete_flag(): ?string
    {
        return $this->ods_delete_flag ?? null;
    }
    /**
     * Set ods_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_delete_flag(?string $ods_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_delete_flag) && !is_string($ods_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_delete_flag, true), gettype($ods_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ods_delete_flag) && $ods_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ods_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ods_delete_flag) && $ods_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ods_delete_flag, true)), __LINE__);
        }
        if (is_null($ods_delete_flag) || (is_array($ods_delete_flag) && empty($ods_delete_flag))) {
            unset($this->ods_delete_flag);
        } else {
            $this->ods_delete_flag = $ods_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ods_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_entity_key(): ?string
    {
        return $this->ods_entity_key ?? null;
    }
    /**
     * Set ods_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_entity_key(?string $ods_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_entity_key) && !is_string($ods_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_entity_key, true), gettype($ods_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ods_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ods_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ods_entity_key, true)), __LINE__);
        }
        if (is_null($ods_entity_key) || (is_array($ods_entity_key) && empty($ods_entity_key))) {
            unset($this->ods_entity_key);
        } else {
            $this->ods_entity_key = $ods_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ods_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_key_ext(): ?string
    {
        return $this->ods_key_ext ?? null;
    }
    /**
     * Set ods_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_key_ext(?string $ods_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_key_ext) && !is_string($ods_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_key_ext, true), gettype($ods_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ods_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ods_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ods_key_ext, true)), __LINE__);
        }
        if (is_null($ods_key_ext) || (is_array($ods_key_ext) && empty($ods_key_ext))) {
            unset($this->ods_key_ext);
        } else {
            $this->ods_key_ext = $ods_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ods_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOds_number(): ?int
    {
        return $this->ods_number ?? null;
    }
    /**
     * Set ods_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ods_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_number(?int $ods_number = null): self
    {
        // validation for constraint: int
        if (!is_null($ods_number) && !(is_int($ods_number) || ctype_digit($ods_number))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ods_number, true), gettype($ods_number)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ods_number) && $ods_number > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ods_number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ods_number) && $ods_number < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ods_number, true)), __LINE__);
        }
        if (is_null($ods_number) || (is_array($ods_number) && empty($ods_number))) {
            unset($this->ods_number);
        } else {
            $this->ods_number = $ods_number;
        }
        
        return $this;
    }
    /**
     * Get ods_ims_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_ims_key(): ?string
    {
        return $this->ods_ims_key ?? null;
    }
    /**
     * Set ods_ims_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_ims_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_ims_key(?string $ods_ims_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_ims_key) && !is_string($ods_ims_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_ims_key, true), gettype($ods_ims_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ods_ims_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ods_ims_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ods_ims_key, true)), __LINE__);
        }
        if (is_null($ods_ims_key) || (is_array($ods_ims_key) && empty($ods_ims_key))) {
            unset($this->ods_ims_key);
        } else {
            $this->ods_ims_key = $ods_ims_key;
        }
        
        return $this;
    }
    /**
     * Get ods_void_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_void_date(): ?string
    {
        return $this->ods_void_date ?? null;
    }
    /**
     * Set ods_void_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_void_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_void_date(?string $ods_void_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_void_date) && !is_string($ods_void_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_void_date, true), gettype($ods_void_date)), __LINE__);
        }
        if (is_null($ods_void_date) || (is_array($ods_void_date) && empty($ods_void_date))) {
            unset($this->ods_void_date);
        } else {
            $this->ods_void_date = $ods_void_date;
        }
        
        return $this;
    }
    /**
     * Get ods_void_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_void_user(): ?string
    {
        return $this->ods_void_user ?? null;
    }
    /**
     * Set ods_void_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_void_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_void_user(?string $ods_void_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_void_user) && !is_string($ods_void_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_void_user, true), gettype($ods_void_user)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ods_void_user) && mb_strlen((string) $ods_void_user) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ods_void_user)), __LINE__);
        }
        if (is_null($ods_void_user) || (is_array($ods_void_user) && empty($ods_void_user))) {
            unset($this->ods_void_user);
        } else {
            $this->ods_void_user = $ods_void_user;
        }
        
        return $this;
    }
    /**
     * Get ods_void_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOds_void_flag(): ?string
    {
        return $this->ods_void_flag ?? null;
    }
    /**
     * Set ods_void_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ods_void_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_void_flag(?string $ods_void_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ods_void_flag) && !is_string($ods_void_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ods_void_flag, true), gettype($ods_void_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ods_void_flag) && $ods_void_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ods_void_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ods_void_flag) && $ods_void_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ods_void_flag, true)), __LINE__);
        }
        if (is_null($ods_void_flag) || (is_array($ods_void_flag) && empty($ods_void_flag))) {
            unset($this->ods_void_flag);
        } else {
            $this->ods_void_flag = $ods_void_flag;
        }
        
        return $this;
    }
    /**
     * Get ods_writeoff_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOds_writeoff_amount(): ?float
    {
        return $this->ods_writeoff_amount ?? null;
    }
    /**
     * Set ods_writeoff_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ods_writeoff_amount
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Order_Detail_Schedule_DataObjectType
     */
    public function setOds_writeoff_amount(?float $ods_writeoff_amount = null): self
    {
        // validation for constraint: float
        if (!is_null($ods_writeoff_amount) && !(is_float($ods_writeoff_amount) || is_numeric($ods_writeoff_amount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ods_writeoff_amount, true), gettype($ods_writeoff_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($ods_writeoff_amount) && mb_strlen(mb_substr((string) $ods_writeoff_amount, false !== mb_strpos((string) $ods_writeoff_amount, '.') ? mb_strpos((string) $ods_writeoff_amount, '.') + 1 : mb_strlen((string) $ods_writeoff_amount))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($ods_writeoff_amount, true), mb_strlen(mb_substr((string) $ods_writeoff_amount, mb_strpos((string) $ods_writeoff_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($ods_writeoff_amount) && mb_strlen(preg_replace('/(\D)/', '', (string) $ods_writeoff_amount)) > 19) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($ods_writeoff_amount, true), mb_strlen(preg_replace('/(\D)/', '', (string) $ods_writeoff_amount))), __LINE__);
        }
        if (is_null($ods_writeoff_amount) || (is_array($ods_writeoff_amount) && empty($ods_writeoff_amount))) {
            unset($this->ods_writeoff_amount);
        } else {
            $this->ods_writeoff_amount = $ods_writeoff_amount;
        }
        
        return $this;
    }
}
