<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Product_Type_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Product_Type_DataObjectType extends AbstractStructBase
{
    /**
     * The ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ptp_key = null;
    /**
     * The ptp_code
     * Meta information extracted from the WSDL
     * - documentation: Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_code = null;
    /**
     * The ptp_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_add_user = null;
    /**
     * The ptp_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_add_date = null;
    /**
     * The ptp_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_change_user = null;
    /**
     * The ptp_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_change_date = null;
    /**
     * The ptp_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_delete_flag = null;
    /**
     * The ptp_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ptp_key_ext = null;
    /**
     * The ptp_sell_online
     * Meta information extracted from the WSDL
     * - documentation: Sell Online?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_sell_online = null;
    /**
     * The ptp_online_code
     * Meta information extracted from the WSDL
     * - documentation: Online Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_online_code = null;
    /**
     * The ptp_thumbnail
     * Meta information extracted from the WSDL
     * - documentation: Thumbnail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_thumbnail = null;
    /**
     * The ptp_discount_flag
     * Meta information extracted from the WSDL
     * - documentation: Discountable?.This element has a default value of '1'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_discount_flag = null;
    /**
     * The ptp_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ptp_entity_key = null;
    /**
     * The ptp_order
     * Meta information extracted from the WSDL
     * - documentation: order. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ptp_order = null;
    /**
     * The ptp_exclude_from_bundle_flag
     * Meta information extracted from the WSDL
     * - documentation: exclude from bundle. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_exclude_from_bundle_flag = null;
    /**
     * The ptp_disallow_fractions
     * Meta information extracted from the WSDL
     * - documentation: Disallow fractions. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ptp_disallow_fractions = null;
    /**
     * The ptp_cmo_key
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ptp_cmo_key = null;
    /**
     * Constructor method for InvoiceDetail_Product_Type_DataObjectType
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_key()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_code()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_add_user()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_add_date()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_change_user()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_change_date()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_delete_flag()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_key_ext()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_sell_online()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_online_code()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_thumbnail()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_discount_flag()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_entity_key()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_order()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_exclude_from_bundle_flag()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_disallow_fractions()
     * @uses InvoiceDetail_Product_Type_DataObjectType::setPtp_cmo_key()
     * @param string $ptp_key
     * @param string $ptp_code
     * @param string $ptp_add_user
     * @param string $ptp_add_date
     * @param string $ptp_change_user
     * @param string $ptp_change_date
     * @param string $ptp_delete_flag
     * @param string $ptp_key_ext
     * @param string $ptp_sell_online
     * @param string $ptp_online_code
     * @param string $ptp_thumbnail
     * @param string $ptp_discount_flag
     * @param string $ptp_entity_key
     * @param int $ptp_order
     * @param string $ptp_exclude_from_bundle_flag
     * @param string $ptp_disallow_fractions
     * @param string $ptp_cmo_key
     */
    public function __construct(?string $ptp_key = null, ?string $ptp_code = null, ?string $ptp_add_user = null, ?string $ptp_add_date = null, ?string $ptp_change_user = null, ?string $ptp_change_date = null, ?string $ptp_delete_flag = null, ?string $ptp_key_ext = null, ?string $ptp_sell_online = null, ?string $ptp_online_code = null, ?string $ptp_thumbnail = null, ?string $ptp_discount_flag = null, ?string $ptp_entity_key = null, ?int $ptp_order = null, ?string $ptp_exclude_from_bundle_flag = null, ?string $ptp_disallow_fractions = null, ?string $ptp_cmo_key = null)
    {
        $this
            ->setPtp_key($ptp_key)
            ->setPtp_code($ptp_code)
            ->setPtp_add_user($ptp_add_user)
            ->setPtp_add_date($ptp_add_date)
            ->setPtp_change_user($ptp_change_user)
            ->setPtp_change_date($ptp_change_date)
            ->setPtp_delete_flag($ptp_delete_flag)
            ->setPtp_key_ext($ptp_key_ext)
            ->setPtp_sell_online($ptp_sell_online)
            ->setPtp_online_code($ptp_online_code)
            ->setPtp_thumbnail($ptp_thumbnail)
            ->setPtp_discount_flag($ptp_discount_flag)
            ->setPtp_entity_key($ptp_entity_key)
            ->setPtp_order($ptp_order)
            ->setPtp_exclude_from_bundle_flag($ptp_exclude_from_bundle_flag)
            ->setPtp_disallow_fractions($ptp_disallow_fractions)
            ->setPtp_cmo_key($ptp_cmo_key);
    }
    /**
     * Get ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_key(): ?string
    {
        return $this->ptp_key ?? null;
    }
    /**
     * Set ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_key(?string $ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_key) && !is_string($ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_key, true), gettype($ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ptp_key, true)), __LINE__);
        }
        if (is_null($ptp_key) || (is_array($ptp_key) && empty($ptp_key))) {
            unset($this->ptp_key);
        } else {
            $this->ptp_key = $ptp_key;
        }
        
        return $this;
    }
    /**
     * Get ptp_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_code(): ?string
    {
        return $this->ptp_code ?? null;
    }
    /**
     * Set ptp_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_code(?string $ptp_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_code) && !is_string($ptp_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_code, true), gettype($ptp_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ptp_code) && mb_strlen((string) $ptp_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ptp_code)), __LINE__);
        }
        if (is_null($ptp_code) || (is_array($ptp_code) && empty($ptp_code))) {
            unset($this->ptp_code);
        } else {
            $this->ptp_code = $ptp_code;
        }
        
        return $this;
    }
    /**
     * Get ptp_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_add_user(): ?string
    {
        return $this->ptp_add_user ?? null;
    }
    /**
     * Set ptp_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_add_user(?string $ptp_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_add_user) && !is_string($ptp_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_add_user, true), gettype($ptp_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ptp_add_user) && mb_strlen((string) $ptp_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ptp_add_user)), __LINE__);
        }
        if (is_null($ptp_add_user) || (is_array($ptp_add_user) && empty($ptp_add_user))) {
            unset($this->ptp_add_user);
        } else {
            $this->ptp_add_user = $ptp_add_user;
        }
        
        return $this;
    }
    /**
     * Get ptp_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_add_date(): ?string
    {
        return $this->ptp_add_date ?? null;
    }
    /**
     * Set ptp_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_add_date(?string $ptp_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_add_date) && !is_string($ptp_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_add_date, true), gettype($ptp_add_date)), __LINE__);
        }
        if (is_null($ptp_add_date) || (is_array($ptp_add_date) && empty($ptp_add_date))) {
            unset($this->ptp_add_date);
        } else {
            $this->ptp_add_date = $ptp_add_date;
        }
        
        return $this;
    }
    /**
     * Get ptp_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_change_user(): ?string
    {
        return $this->ptp_change_user ?? null;
    }
    /**
     * Set ptp_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_change_user(?string $ptp_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_change_user) && !is_string($ptp_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_change_user, true), gettype($ptp_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ptp_change_user) && mb_strlen((string) $ptp_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ptp_change_user)), __LINE__);
        }
        if (is_null($ptp_change_user) || (is_array($ptp_change_user) && empty($ptp_change_user))) {
            unset($this->ptp_change_user);
        } else {
            $this->ptp_change_user = $ptp_change_user;
        }
        
        return $this;
    }
    /**
     * Get ptp_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_change_date(): ?string
    {
        return $this->ptp_change_date ?? null;
    }
    /**
     * Set ptp_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_change_date(?string $ptp_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_change_date) && !is_string($ptp_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_change_date, true), gettype($ptp_change_date)), __LINE__);
        }
        if (is_null($ptp_change_date) || (is_array($ptp_change_date) && empty($ptp_change_date))) {
            unset($this->ptp_change_date);
        } else {
            $this->ptp_change_date = $ptp_change_date;
        }
        
        return $this;
    }
    /**
     * Get ptp_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_delete_flag(): ?string
    {
        return $this->ptp_delete_flag ?? null;
    }
    /**
     * Set ptp_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_delete_flag(?string $ptp_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_delete_flag) && !is_string($ptp_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_delete_flag, true), gettype($ptp_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ptp_delete_flag) && $ptp_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ptp_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ptp_delete_flag) && $ptp_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ptp_delete_flag, true)), __LINE__);
        }
        if (is_null($ptp_delete_flag) || (is_array($ptp_delete_flag) && empty($ptp_delete_flag))) {
            unset($this->ptp_delete_flag);
        } else {
            $this->ptp_delete_flag = $ptp_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ptp_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_key_ext(): ?string
    {
        return $this->ptp_key_ext ?? null;
    }
    /**
     * Set ptp_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_key_ext(?string $ptp_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_key_ext) && !is_string($ptp_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_key_ext, true), gettype($ptp_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ptp_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ptp_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ptp_key_ext, true)), __LINE__);
        }
        if (is_null($ptp_key_ext) || (is_array($ptp_key_ext) && empty($ptp_key_ext))) {
            unset($this->ptp_key_ext);
        } else {
            $this->ptp_key_ext = $ptp_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ptp_sell_online value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_sell_online(): ?string
    {
        return $this->ptp_sell_online ?? null;
    }
    /**
     * Set ptp_sell_online value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_sell_online
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_sell_online(?string $ptp_sell_online = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_sell_online) && !is_string($ptp_sell_online)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_sell_online, true), gettype($ptp_sell_online)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ptp_sell_online) && $ptp_sell_online > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ptp_sell_online, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ptp_sell_online) && $ptp_sell_online < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ptp_sell_online, true)), __LINE__);
        }
        if (is_null($ptp_sell_online) || (is_array($ptp_sell_online) && empty($ptp_sell_online))) {
            unset($this->ptp_sell_online);
        } else {
            $this->ptp_sell_online = $ptp_sell_online;
        }
        
        return $this;
    }
    /**
     * Get ptp_online_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_online_code(): ?string
    {
        return $this->ptp_online_code ?? null;
    }
    /**
     * Set ptp_online_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_online_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_online_code(?string $ptp_online_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_online_code) && !is_string($ptp_online_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_online_code, true), gettype($ptp_online_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ptp_online_code) && mb_strlen((string) $ptp_online_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ptp_online_code)), __LINE__);
        }
        if (is_null($ptp_online_code) || (is_array($ptp_online_code) && empty($ptp_online_code))) {
            unset($this->ptp_online_code);
        } else {
            $this->ptp_online_code = $ptp_online_code;
        }
        
        return $this;
    }
    /**
     * Get ptp_thumbnail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_thumbnail(): ?string
    {
        return $this->ptp_thumbnail ?? null;
    }
    /**
     * Set ptp_thumbnail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_thumbnail
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_thumbnail(?string $ptp_thumbnail = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_thumbnail) && !is_string($ptp_thumbnail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_thumbnail, true), gettype($ptp_thumbnail)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ptp_thumbnail) && mb_strlen((string) $ptp_thumbnail) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ptp_thumbnail)), __LINE__);
        }
        if (is_null($ptp_thumbnail) || (is_array($ptp_thumbnail) && empty($ptp_thumbnail))) {
            unset($this->ptp_thumbnail);
        } else {
            $this->ptp_thumbnail = $ptp_thumbnail;
        }
        
        return $this;
    }
    /**
     * Get ptp_discount_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_discount_flag(): ?string
    {
        return $this->ptp_discount_flag ?? null;
    }
    /**
     * Set ptp_discount_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_discount_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_discount_flag(?string $ptp_discount_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_discount_flag) && !is_string($ptp_discount_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_discount_flag, true), gettype($ptp_discount_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ptp_discount_flag) && $ptp_discount_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ptp_discount_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ptp_discount_flag) && $ptp_discount_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ptp_discount_flag, true)), __LINE__);
        }
        if (is_null($ptp_discount_flag) || (is_array($ptp_discount_flag) && empty($ptp_discount_flag))) {
            unset($this->ptp_discount_flag);
        } else {
            $this->ptp_discount_flag = $ptp_discount_flag;
        }
        
        return $this;
    }
    /**
     * Get ptp_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_entity_key(): ?string
    {
        return $this->ptp_entity_key ?? null;
    }
    /**
     * Set ptp_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_entity_key(?string $ptp_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_entity_key) && !is_string($ptp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_entity_key, true), gettype($ptp_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ptp_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ptp_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ptp_entity_key, true)), __LINE__);
        }
        if (is_null($ptp_entity_key) || (is_array($ptp_entity_key) && empty($ptp_entity_key))) {
            unset($this->ptp_entity_key);
        } else {
            $this->ptp_entity_key = $ptp_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ptp_order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPtp_order(): ?int
    {
        return $this->ptp_order ?? null;
    }
    /**
     * Set ptp_order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ptp_order
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_order(?int $ptp_order = null): self
    {
        // validation for constraint: int
        if (!is_null($ptp_order) && !(is_int($ptp_order) || ctype_digit($ptp_order))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ptp_order, true), gettype($ptp_order)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ptp_order) && $ptp_order > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ptp_order, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ptp_order) && $ptp_order < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ptp_order, true)), __LINE__);
        }
        if (is_null($ptp_order) || (is_array($ptp_order) && empty($ptp_order))) {
            unset($this->ptp_order);
        } else {
            $this->ptp_order = $ptp_order;
        }
        
        return $this;
    }
    /**
     * Get ptp_exclude_from_bundle_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_exclude_from_bundle_flag(): ?string
    {
        return $this->ptp_exclude_from_bundle_flag ?? null;
    }
    /**
     * Set ptp_exclude_from_bundle_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_exclude_from_bundle_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_exclude_from_bundle_flag(?string $ptp_exclude_from_bundle_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_exclude_from_bundle_flag) && !is_string($ptp_exclude_from_bundle_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_exclude_from_bundle_flag, true), gettype($ptp_exclude_from_bundle_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ptp_exclude_from_bundle_flag) && $ptp_exclude_from_bundle_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ptp_exclude_from_bundle_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ptp_exclude_from_bundle_flag) && $ptp_exclude_from_bundle_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ptp_exclude_from_bundle_flag, true)), __LINE__);
        }
        if (is_null($ptp_exclude_from_bundle_flag) || (is_array($ptp_exclude_from_bundle_flag) && empty($ptp_exclude_from_bundle_flag))) {
            unset($this->ptp_exclude_from_bundle_flag);
        } else {
            $this->ptp_exclude_from_bundle_flag = $ptp_exclude_from_bundle_flag;
        }
        
        return $this;
    }
    /**
     * Get ptp_disallow_fractions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_disallow_fractions(): ?string
    {
        return $this->ptp_disallow_fractions ?? null;
    }
    /**
     * Set ptp_disallow_fractions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_disallow_fractions
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_disallow_fractions(?string $ptp_disallow_fractions = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_disallow_fractions) && !is_string($ptp_disallow_fractions)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_disallow_fractions, true), gettype($ptp_disallow_fractions)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ptp_disallow_fractions) && $ptp_disallow_fractions > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ptp_disallow_fractions, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ptp_disallow_fractions) && $ptp_disallow_fractions < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ptp_disallow_fractions, true)), __LINE__);
        }
        if (is_null($ptp_disallow_fractions) || (is_array($ptp_disallow_fractions) && empty($ptp_disallow_fractions))) {
            unset($this->ptp_disallow_fractions);
        } else {
            $this->ptp_disallow_fractions = $ptp_disallow_fractions;
        }
        
        return $this;
    }
    /**
     * Get ptp_cmo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPtp_cmo_key(): ?string
    {
        return $this->ptp_cmo_key ?? null;
    }
    /**
     * Set ptp_cmo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ptp_cmo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_DataObjectType
     */
    public function setPtp_cmo_key(?string $ptp_cmo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ptp_cmo_key) && !is_string($ptp_cmo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ptp_cmo_key, true), gettype($ptp_cmo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ptp_cmo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ptp_cmo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ptp_cmo_key, true)), __LINE__);
        }
        if (is_null($ptp_cmo_key) || (is_array($ptp_cmo_key) && empty($ptp_cmo_key))) {
            unset($this->ptp_cmo_key);
        } else {
            $this->ptp_cmo_key = $ptp_cmo_key;
        }
        
        return $this;
    }
}
