<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail_Product_Type_Social_Messages_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceDetail_Product_Type_Social_Messages_DataObjectType extends AbstractStructBase
{
    /**
     * The oel_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $oel_key = null;
    /**
     * The oel_ptp_key
     * Meta information extracted from the WSDL
     * - documentation: Product Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $oel_ptp_key = null;
    /**
     * The oel_twitter_msg
     * Meta information extracted from the WSDL
     * - documentation: Twitter Message. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $oel_twitter_msg = null;
    /**
     * The oel_facebook_msg
     * Meta information extracted from the WSDL
     * - documentation: Facebook Message. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $oel_facebook_msg = null;
    /**
     * The oel_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $oel_add_user = null;
    /**
     * The oel_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $oel_add_date = null;
    /**
     * The oel_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $oel_change_user = null;
    /**
     * The oel_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $oel_change_date = null;
    /**
     * The oel_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $oel_delete_flag = null;
    /**
     * The oel_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $oel_entity_key = null;
    /**
     * Constructor method for InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_key()
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_ptp_key()
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_twitter_msg()
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_facebook_msg()
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_add_user()
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_add_date()
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_change_user()
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_change_date()
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_delete_flag()
     * @uses InvoiceDetail_Product_Type_Social_Messages_DataObjectType::setOel_entity_key()
     * @param string $oel_key
     * @param string $oel_ptp_key
     * @param string $oel_twitter_msg
     * @param string $oel_facebook_msg
     * @param string $oel_add_user
     * @param string $oel_add_date
     * @param string $oel_change_user
     * @param string $oel_change_date
     * @param string $oel_delete_flag
     * @param string $oel_entity_key
     */
    public function __construct(?string $oel_key = null, ?string $oel_ptp_key = null, ?string $oel_twitter_msg = null, ?string $oel_facebook_msg = null, ?string $oel_add_user = null, ?string $oel_add_date = null, ?string $oel_change_user = null, ?string $oel_change_date = null, ?string $oel_delete_flag = null, ?string $oel_entity_key = null)
    {
        $this
            ->setOel_key($oel_key)
            ->setOel_ptp_key($oel_ptp_key)
            ->setOel_twitter_msg($oel_twitter_msg)
            ->setOel_facebook_msg($oel_facebook_msg)
            ->setOel_add_user($oel_add_user)
            ->setOel_add_date($oel_add_date)
            ->setOel_change_user($oel_change_user)
            ->setOel_change_date($oel_change_date)
            ->setOel_delete_flag($oel_delete_flag)
            ->setOel_entity_key($oel_entity_key);
    }
    /**
     * Get oel_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_key(): ?string
    {
        return $this->oel_key ?? null;
    }
    /**
     * Set oel_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_key(?string $oel_key = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_key) && !is_string($oel_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_key, true), gettype($oel_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($oel_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $oel_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($oel_key, true)), __LINE__);
        }
        if (is_null($oel_key) || (is_array($oel_key) && empty($oel_key))) {
            unset($this->oel_key);
        } else {
            $this->oel_key = $oel_key;
        }
        
        return $this;
    }
    /**
     * Get oel_ptp_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_ptp_key(): ?string
    {
        return $this->oel_ptp_key ?? null;
    }
    /**
     * Set oel_ptp_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_ptp_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_ptp_key(?string $oel_ptp_key = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_ptp_key) && !is_string($oel_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_ptp_key, true), gettype($oel_ptp_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($oel_ptp_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $oel_ptp_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($oel_ptp_key, true)), __LINE__);
        }
        if (is_null($oel_ptp_key) || (is_array($oel_ptp_key) && empty($oel_ptp_key))) {
            unset($this->oel_ptp_key);
        } else {
            $this->oel_ptp_key = $oel_ptp_key;
        }
        
        return $this;
    }
    /**
     * Get oel_twitter_msg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_twitter_msg(): ?string
    {
        return $this->oel_twitter_msg ?? null;
    }
    /**
     * Set oel_twitter_msg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_twitter_msg
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_twitter_msg(?string $oel_twitter_msg = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_twitter_msg) && !is_string($oel_twitter_msg)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_twitter_msg, true), gettype($oel_twitter_msg)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($oel_twitter_msg) && mb_strlen((string) $oel_twitter_msg) > 500) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen((string) $oel_twitter_msg)), __LINE__);
        }
        if (is_null($oel_twitter_msg) || (is_array($oel_twitter_msg) && empty($oel_twitter_msg))) {
            unset($this->oel_twitter_msg);
        } else {
            $this->oel_twitter_msg = $oel_twitter_msg;
        }
        
        return $this;
    }
    /**
     * Get oel_facebook_msg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_facebook_msg(): ?string
    {
        return $this->oel_facebook_msg ?? null;
    }
    /**
     * Set oel_facebook_msg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_facebook_msg
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_facebook_msg(?string $oel_facebook_msg = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_facebook_msg) && !is_string($oel_facebook_msg)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_facebook_msg, true), gettype($oel_facebook_msg)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($oel_facebook_msg) && mb_strlen((string) $oel_facebook_msg) > 1000) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen((string) $oel_facebook_msg)), __LINE__);
        }
        if (is_null($oel_facebook_msg) || (is_array($oel_facebook_msg) && empty($oel_facebook_msg))) {
            unset($this->oel_facebook_msg);
        } else {
            $this->oel_facebook_msg = $oel_facebook_msg;
        }
        
        return $this;
    }
    /**
     * Get oel_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_add_user(): ?string
    {
        return $this->oel_add_user ?? null;
    }
    /**
     * Set oel_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_add_user(?string $oel_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_add_user) && !is_string($oel_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_add_user, true), gettype($oel_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($oel_add_user) && mb_strlen((string) $oel_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $oel_add_user)), __LINE__);
        }
        if (is_null($oel_add_user) || (is_array($oel_add_user) && empty($oel_add_user))) {
            unset($this->oel_add_user);
        } else {
            $this->oel_add_user = $oel_add_user;
        }
        
        return $this;
    }
    /**
     * Get oel_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_add_date(): ?string
    {
        return $this->oel_add_date ?? null;
    }
    /**
     * Set oel_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_add_date(?string $oel_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_add_date) && !is_string($oel_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_add_date, true), gettype($oel_add_date)), __LINE__);
        }
        if (is_null($oel_add_date) || (is_array($oel_add_date) && empty($oel_add_date))) {
            unset($this->oel_add_date);
        } else {
            $this->oel_add_date = $oel_add_date;
        }
        
        return $this;
    }
    /**
     * Get oel_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_change_user(): ?string
    {
        return $this->oel_change_user ?? null;
    }
    /**
     * Set oel_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_change_user(?string $oel_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_change_user) && !is_string($oel_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_change_user, true), gettype($oel_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($oel_change_user) && mb_strlen((string) $oel_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $oel_change_user)), __LINE__);
        }
        if (is_null($oel_change_user) || (is_array($oel_change_user) && empty($oel_change_user))) {
            unset($this->oel_change_user);
        } else {
            $this->oel_change_user = $oel_change_user;
        }
        
        return $this;
    }
    /**
     * Get oel_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_change_date(): ?string
    {
        return $this->oel_change_date ?? null;
    }
    /**
     * Set oel_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_change_date(?string $oel_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_change_date) && !is_string($oel_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_change_date, true), gettype($oel_change_date)), __LINE__);
        }
        if (is_null($oel_change_date) || (is_array($oel_change_date) && empty($oel_change_date))) {
            unset($this->oel_change_date);
        } else {
            $this->oel_change_date = $oel_change_date;
        }
        
        return $this;
    }
    /**
     * Get oel_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_delete_flag(): ?string
    {
        return $this->oel_delete_flag ?? null;
    }
    /**
     * Set oel_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_delete_flag(?string $oel_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_delete_flag) && !is_string($oel_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_delete_flag, true), gettype($oel_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($oel_delete_flag) && $oel_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($oel_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($oel_delete_flag) && $oel_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($oel_delete_flag, true)), __LINE__);
        }
        if (is_null($oel_delete_flag) || (is_array($oel_delete_flag) && empty($oel_delete_flag))) {
            unset($this->oel_delete_flag);
        } else {
            $this->oel_delete_flag = $oel_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get oel_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOel_entity_key(): ?string
    {
        return $this->oel_entity_key ?? null;
    }
    /**
     * Set oel_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oel_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceDetail_Product_Type_Social_Messages_DataObjectType
     */
    public function setOel_entity_key(?string $oel_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($oel_entity_key) && !is_string($oel_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oel_entity_key, true), gettype($oel_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($oel_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $oel_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($oel_entity_key, true)), __LINE__);
        }
        if (is_null($oel_entity_key) || (is_array($oel_entity_key) && empty($oel_entity_key))) {
            unset($this->oel_entity_key);
        } else {
            $this->oel_entity_key = $oel_entity_key;
        }
        
        return $this;
    }
}
