<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceToPayCollectionType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceToPayCollectionType extends AbstractStructBase
{
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\InvoiceType[]
     */
    protected ?array $Invoice = null;
    /**
     * Constructor method for InvoiceToPayCollectionType
     * @uses InvoiceToPayCollectionType::setInvoice()
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceType[] $invoice
     */
    public function __construct(?array $invoice = null)
    {
        $this
            ->setInvoice($invoice);
    }
    /**
     * Get Invoice value
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType[]
     */
    public function getInvoice(): ?array
    {
        return $this->Invoice;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setInvoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceForArrayConstraintFromSetInvoice(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceToPayCollectionTypeInvoiceItem) {
            // validation for constraint: itemType
            if (!$invoiceToPayCollectionTypeInvoiceItem instanceof \Drupal\netforum\xWeb\Generated\StructType\InvoiceType) {
                $invalidValues[] = is_object($invoiceToPayCollectionTypeInvoiceItem) ? get_class($invoiceToPayCollectionTypeInvoiceItem) : sprintf('%s(%s)', gettype($invoiceToPayCollectionTypeInvoiceItem), var_export($invoiceToPayCollectionTypeInvoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Invoice property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\InvoiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set Invoice value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceType[] $invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceToPayCollectionType
     */
    public function setInvoice(?array $invoice = null): self
    {
        // validation for constraint: array
        if ('' !== ($invoiceArrayErrorMessage = self::validateInvoiceForArrayConstraintFromSetInvoice($invoice))) {
            throw new InvalidArgumentException($invoiceArrayErrorMessage, __LINE__);
        }
        $this->Invoice = $invoice;
        
        return $this;
    }
    /**
     * Add item to Invoice value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\InvoiceType $item
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceToPayCollectionType
     */
    public function addToInvoice(\Drupal\netforum\xWeb\Generated\StructType\InvoiceType $item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\InvoiceType) {
            throw new InvalidArgumentException(sprintf('The Invoice property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\InvoiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Invoice[] = $item;
        
        return $this;
    }
}
