<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class InvoiceType extends AbstractStructBase
{
    /**
     * The Invoice
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_DataObjectType $Invoice = null;
    /**
     * The Invoice_Detail
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType $Invoice_Detail = null;
    /**
     * The Invoice_Detail_Term
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_Term_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_Term_DataObjectType $Invoice_Detail_Term = null;
    /**
     * The Claim
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType $Claim = null;
    /**
     * The Default_Shipping_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType $Default_Shipping_Address = null;
    /**
     * The Payment
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_DataObjectType $Payment = null;
    /**
     * The Payment_Info
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Info_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Info_DataObjectType $Payment_Info = null;
    /**
     * The Payment_Method
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Method_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Method_DataObjectType $Payment_Method = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Customer_DataObjectType $Customer = null;
    /**
     * The CustomerIndividual
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_CustomerIndividual_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_CustomerIndividual_DataObjectType $CustomerIndividual = null;
    /**
     * The Billing_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Address_DataObjectType $Billing_Address = null;
    /**
     * The Billing_Adr
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Adr_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Adr_DataObjectType $Billing_Adr = null;
    /**
     * The Price
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Price_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Price_DataObjectType $Price = null;
    /**
     * The Batch
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Batch_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Batch_DataObjectType $Batch = null;
    /**
     * The BillToCustomer
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomer_DataObjectType $BillToCustomer = null;
    /**
     * The BillToCustomerIndividual
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomerIndividual_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomerIndividual_DataObjectType $BillToCustomerIndividual = null;
    /**
     * The Billing_Contact
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Contact_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Contact_DataObjectType $Billing_Contact = null;
    /**
     * The InstallmentBilling
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_InstallmentBilling_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_InstallmentBilling_DataObjectType $InstallmentBilling = null;
    /**
     * The Company_Business_Unit
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Company_Business_Unit_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Company_Business_Unit_DataObjectType $Company_Business_Unit = null;
    /**
     * The Credit_Available
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Credit_Available_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Credit_Available_DataObjectType $Credit_Available = null;
    /**
     * The source_code
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType $source_code = null;
    /**
     * The Sales_Opportunity
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_Sales_Opportunity_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Sales_Opportunity_DataObjectType $Sales_Opportunity = null;
    /**
     * The currency
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType $currency = null;
    /**
     * The Invoice_DetailCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $Invoice_DetailCollection = null;
    /**
     * The Additional_Invoice_DetailCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $Additional_Invoice_DetailCollection = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Invoice Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for InvoiceType
     * @uses InvoiceType::setInvoice()
     * @uses InvoiceType::setInvoice_Detail()
     * @uses InvoiceType::setInvoice_Detail_Term()
     * @uses InvoiceType::setClaim()
     * @uses InvoiceType::setDefault_Shipping_Address()
     * @uses InvoiceType::setPayment()
     * @uses InvoiceType::setPayment_Info()
     * @uses InvoiceType::setPayment_Method()
     * @uses InvoiceType::setCustomer()
     * @uses InvoiceType::setCustomerIndividual()
     * @uses InvoiceType::setBilling_Address()
     * @uses InvoiceType::setBilling_Adr()
     * @uses InvoiceType::setPrice()
     * @uses InvoiceType::setBatch()
     * @uses InvoiceType::setBillToCustomer()
     * @uses InvoiceType::setBillToCustomerIndividual()
     * @uses InvoiceType::setBilling_Contact()
     * @uses InvoiceType::setInstallmentBilling()
     * @uses InvoiceType::setCompany_Business_Unit()
     * @uses InvoiceType::setCredit_Available()
     * @uses InvoiceType::setSource_code()
     * @uses InvoiceType::setSales_Opportunity()
     * @uses InvoiceType::setCurrency()
     * @uses InvoiceType::setInvoice_DetailCollection()
     * @uses InvoiceType::setAdditional_Invoice_DetailCollection()
     * @uses InvoiceType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_DataObjectType $invoice
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType $invoice_Detail
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_Term_DataObjectType $invoice_Detail_Term
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType $claim
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType $default_Shipping_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_DataObjectType $payment
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Info_DataObjectType $payment_Info
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Method_DataObjectType $payment_Method
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_CustomerIndividual_DataObjectType $customerIndividual
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Address_DataObjectType $billing_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Adr_DataObjectType $billing_Adr
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Price_DataObjectType $price
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Batch_DataObjectType $batch
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomer_DataObjectType $billToCustomer
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomerIndividual_DataObjectType $billToCustomerIndividual
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Contact_DataObjectType $billing_Contact
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_InstallmentBilling_DataObjectType $installmentBilling
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Company_Business_Unit_DataObjectType $company_Business_Unit
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Credit_Available_DataObjectType $credit_Available
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType $source_code
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Sales_Opportunity_DataObjectType $sales_Opportunity
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType $currency
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @param \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_DataObjectType $invoice = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType $invoice_Detail = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_Term_DataObjectType $invoice_Detail_Term = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType $claim = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType $default_Shipping_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_DataObjectType $payment = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Info_DataObjectType $payment_Info = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Method_DataObjectType $payment_Method = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_CustomerIndividual_DataObjectType $customerIndividual = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Address_DataObjectType $billing_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Adr_DataObjectType $billing_Adr = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Price_DataObjectType $price = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Batch_DataObjectType $batch = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomer_DataObjectType $billToCustomer = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomerIndividual_DataObjectType $billToCustomerIndividual = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Contact_DataObjectType $billing_Contact = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_InstallmentBilling_DataObjectType $installmentBilling = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Company_Business_Unit_DataObjectType $company_Business_Unit = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Credit_Available_DataObjectType $credit_Available = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType $source_code = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Sales_Opportunity_DataObjectType $sales_Opportunity = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType $currency = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null, ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection = null, ?string $currentKey = null)
    {
        $this
            ->setInvoice($invoice)
            ->setInvoice_Detail($invoice_Detail)
            ->setInvoice_Detail_Term($invoice_Detail_Term)
            ->setClaim($claim)
            ->setDefault_Shipping_Address($default_Shipping_Address)
            ->setPayment($payment)
            ->setPayment_Info($payment_Info)
            ->setPayment_Method($payment_Method)
            ->setCustomer($customer)
            ->setCustomerIndividual($customerIndividual)
            ->setBilling_Address($billing_Address)
            ->setBilling_Adr($billing_Adr)
            ->setPrice($price)
            ->setBatch($batch)
            ->setBillToCustomer($billToCustomer)
            ->setBillToCustomerIndividual($billToCustomerIndividual)
            ->setBilling_Contact($billing_Contact)
            ->setInstallmentBilling($installmentBilling)
            ->setCompany_Business_Unit($company_Business_Unit)
            ->setCredit_Available($credit_Available)
            ->setSource_code($source_code)
            ->setSales_Opportunity($sales_Opportunity)
            ->setCurrency($currency)
            ->setInvoice_DetailCollection($invoice_DetailCollection)
            ->setAdditional_Invoice_DetailCollection($additional_Invoice_DetailCollection)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Invoice value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_DataObjectType|null
     */
    public function getInvoice(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_DataObjectType
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_DataObjectType $invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setInvoice(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_DataObjectType $invoice = null): self
    {
        $this->Invoice = $invoice;
        
        return $this;
    }
    /**
     * Get Invoice_Detail value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType|null
     */
    public function getInvoice_Detail(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType
    {
        return $this->Invoice_Detail;
    }
    /**
     * Set Invoice_Detail value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType $invoice_Detail
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setInvoice_Detail(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_DataObjectType $invoice_Detail = null): self
    {
        $this->Invoice_Detail = $invoice_Detail;
        
        return $this;
    }
    /**
     * Get Invoice_Detail_Term value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_Term_DataObjectType|null
     */
    public function getInvoice_Detail_Term(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_Term_DataObjectType
    {
        return $this->Invoice_Detail_Term;
    }
    /**
     * Set Invoice_Detail_Term value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_Term_DataObjectType $invoice_Detail_Term
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setInvoice_Detail_Term(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Invoice_Detail_Term_DataObjectType $invoice_Detail_Term = null): self
    {
        $this->Invoice_Detail_Term = $invoice_Detail_Term;
        
        return $this;
    }
    /**
     * Get Claim value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType|null
     */
    public function getClaim(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType
    {
        return $this->Claim;
    }
    /**
     * Set Claim value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType $claim
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setClaim(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Claim_DataObjectType $claim = null): self
    {
        $this->Claim = $claim;
        
        return $this;
    }
    /**
     * Get Default_Shipping_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType|null
     */
    public function getDefault_Shipping_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
    {
        return $this->Default_Shipping_Address;
    }
    /**
     * Set Default_Shipping_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType $default_Shipping_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setDefault_Shipping_Address(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType $default_Shipping_Address = null): self
    {
        $this->Default_Shipping_Address = $default_Shipping_Address;
        
        return $this;
    }
    /**
     * Get Payment value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_DataObjectType|null
     */
    public function getPayment(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_DataObjectType
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_DataObjectType $payment
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setPayment(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_DataObjectType $payment = null): self
    {
        $this->Payment = $payment;
        
        return $this;
    }
    /**
     * Get Payment_Info value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Info_DataObjectType|null
     */
    public function getPayment_Info(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Info_DataObjectType
    {
        return $this->Payment_Info;
    }
    /**
     * Set Payment_Info value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Info_DataObjectType $payment_Info
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setPayment_Info(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Info_DataObjectType $payment_Info = null): self
    {
        $this->Payment_Info = $payment_Info;
        
        return $this;
    }
    /**
     * Get Payment_Method value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Method_DataObjectType|null
     */
    public function getPayment_Method(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Method_DataObjectType
    {
        return $this->Payment_Method;
    }
    /**
     * Set Payment_Method value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Method_DataObjectType $payment_Method
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setPayment_Method(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Payment_Method_DataObjectType $payment_Method = null): self
    {
        $this->Payment_Method = $payment_Method;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get CustomerIndividual value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_CustomerIndividual_DataObjectType|null
     */
    public function getCustomerIndividual(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_CustomerIndividual_DataObjectType
    {
        return $this->CustomerIndividual;
    }
    /**
     * Set CustomerIndividual value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_CustomerIndividual_DataObjectType $customerIndividual
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setCustomerIndividual(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_CustomerIndividual_DataObjectType $customerIndividual = null): self
    {
        $this->CustomerIndividual = $customerIndividual;
        
        return $this;
    }
    /**
     * Get Billing_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Address_DataObjectType|null
     */
    public function getBilling_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Address_DataObjectType
    {
        return $this->Billing_Address;
    }
    /**
     * Set Billing_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Address_DataObjectType $billing_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setBilling_Address(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Address_DataObjectType $billing_Address = null): self
    {
        $this->Billing_Address = $billing_Address;
        
        return $this;
    }
    /**
     * Get Billing_Adr value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Adr_DataObjectType|null
     */
    public function getBilling_Adr(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Adr_DataObjectType
    {
        return $this->Billing_Adr;
    }
    /**
     * Set Billing_Adr value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Adr_DataObjectType $billing_Adr
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setBilling_Adr(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Adr_DataObjectType $billing_Adr = null): self
    {
        $this->Billing_Adr = $billing_Adr;
        
        return $this;
    }
    /**
     * Get Price value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Price_DataObjectType|null
     */
    public function getPrice(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Price_DataObjectType
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Price_DataObjectType $price
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setPrice(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Price_DataObjectType $price = null): self
    {
        $this->Price = $price;
        
        return $this;
    }
    /**
     * Get Batch value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Batch_DataObjectType|null
     */
    public function getBatch(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Batch_DataObjectType
    {
        return $this->Batch;
    }
    /**
     * Set Batch value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Batch_DataObjectType $batch
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setBatch(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Batch_DataObjectType $batch = null): self
    {
        $this->Batch = $batch;
        
        return $this;
    }
    /**
     * Get BillToCustomer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomer_DataObjectType|null
     */
    public function getBillToCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomer_DataObjectType
    {
        return $this->BillToCustomer;
    }
    /**
     * Set BillToCustomer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomer_DataObjectType $billToCustomer
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setBillToCustomer(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomer_DataObjectType $billToCustomer = null): self
    {
        $this->BillToCustomer = $billToCustomer;
        
        return $this;
    }
    /**
     * Get BillToCustomerIndividual value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomerIndividual_DataObjectType|null
     */
    public function getBillToCustomerIndividual(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomerIndividual_DataObjectType
    {
        return $this->BillToCustomerIndividual;
    }
    /**
     * Set BillToCustomerIndividual value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomerIndividual_DataObjectType $billToCustomerIndividual
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setBillToCustomerIndividual(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_BillToCustomerIndividual_DataObjectType $billToCustomerIndividual = null): self
    {
        $this->BillToCustomerIndividual = $billToCustomerIndividual;
        
        return $this;
    }
    /**
     * Get Billing_Contact value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Contact_DataObjectType|null
     */
    public function getBilling_Contact(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Contact_DataObjectType
    {
        return $this->Billing_Contact;
    }
    /**
     * Set Billing_Contact value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Contact_DataObjectType $billing_Contact
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setBilling_Contact(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Billing_Contact_DataObjectType $billing_Contact = null): self
    {
        $this->Billing_Contact = $billing_Contact;
        
        return $this;
    }
    /**
     * Get InstallmentBilling value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_InstallmentBilling_DataObjectType|null
     */
    public function getInstallmentBilling(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_InstallmentBilling_DataObjectType
    {
        return $this->InstallmentBilling;
    }
    /**
     * Set InstallmentBilling value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_InstallmentBilling_DataObjectType $installmentBilling
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setInstallmentBilling(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_InstallmentBilling_DataObjectType $installmentBilling = null): self
    {
        $this->InstallmentBilling = $installmentBilling;
        
        return $this;
    }
    /**
     * Get Company_Business_Unit value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Company_Business_Unit_DataObjectType|null
     */
    public function getCompany_Business_Unit(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Company_Business_Unit_DataObjectType
    {
        return $this->{'Company-Business_Unit'};
    }
    /**
     * Set Company_Business_Unit value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Company_Business_Unit_DataObjectType $company_Business_Unit
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setCompany_Business_Unit(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Company_Business_Unit_DataObjectType $company_Business_Unit = null): self
    {
        $this->Company_Business_Unit = $this->{'Company-Business_Unit'} = $company_Business_Unit;
        
        return $this;
    }
    /**
     * Get Credit_Available value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Credit_Available_DataObjectType|null
     */
    public function getCredit_Available(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Credit_Available_DataObjectType
    {
        return $this->Credit_Available;
    }
    /**
     * Set Credit_Available value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Credit_Available_DataObjectType $credit_Available
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setCredit_Available(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Credit_Available_DataObjectType $credit_Available = null): self
    {
        $this->Credit_Available = $credit_Available;
        
        return $this;
    }
    /**
     * Get source_code value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType|null
     */
    public function getSource_code(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
    {
        return $this->source_code;
    }
    /**
     * Set source_code value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType $source_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setSource_code(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType $source_code = null): self
    {
        $this->source_code = $source_code;
        
        return $this;
    }
    /**
     * Get Sales_Opportunity value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Sales_Opportunity_DataObjectType|null
     */
    public function getSales_Opportunity(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Sales_Opportunity_DataObjectType
    {
        return $this->Sales_Opportunity;
    }
    /**
     * Set Sales_Opportunity value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_Sales_Opportunity_DataObjectType $sales_Opportunity
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setSales_Opportunity(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_Sales_Opportunity_DataObjectType $sales_Opportunity = null): self
    {
        $this->Sales_Opportunity = $sales_Opportunity;
        
        return $this;
    }
    /**
     * Get currency value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType|null
     */
    public function getCurrency(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType $currency
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setCurrency(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_currency_DataObjectType $currency = null): self
    {
        $this->currency = $currency;
        
        return $this;
    }
    /**
     * Get Invoice_DetailCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    public function getInvoice_DetailCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType
    {
        return $this->Invoice_DetailCollection;
    }
    /**
     * Set Invoice_DetailCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setInvoice_DetailCollection(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null): self
    {
        $this->Invoice_DetailCollection = $invoice_DetailCollection;
        
        return $this;
    }
    /**
     * Get Additional_Invoice_DetailCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType|null
     */
    public function getAdditional_Invoice_DetailCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType
    {
        return $this->Additional_Invoice_DetailCollection;
    }
    /**
     * Set Additional_Invoice_DetailCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setAdditional_Invoice_DetailCollection(?\Drupal\netforum\xWeb\Generated\StructType\Additional_Invoice_DetailCollectionType $additional_Invoice_DetailCollection = null): self
    {
        $this->Additional_Invoice_DetailCollection = $additional_Invoice_DetailCollection;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\InvoiceType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
