<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_Default_Shipping_Address_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Invoice_Default_Shipping_Address_DataObjectType extends AbstractStructBase
{
    /**
     * The cxs__cxa_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxs__cxa_cst_key = null;
    /**
     * The cxs__cxa_adr_key
     * Meta information extracted from the WSDL
     * - documentation: Address Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxs__cxa_adr_key = null;
    /**
     * The cxs__cxa_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_add_date = null;
    /**
     * The cxs__cxa_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_add_user = null;
    /**
     * The cxs__cxa_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_change_date = null;
    /**
     * The cxs__cxa_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_change_user = null;
    /**
     * The cxs__cxa_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_delete_flag = null;
    /**
     * The cxs__cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxs__cxa_key = null;
    /**
     * The cxs__cxa_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxs__cxa_key_ext = null;
    /**
     * The cxs__cxa_on_hold_flag
     * Meta information extracted from the WSDL
     * - documentation: Address On Hold Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_on_hold_flag = null;
    /**
     * The cxs__cxa_adh_key
     * Meta information extracted from the WSDL
     * - documentation: On Hold Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxs__cxa_adh_key = null;
    /**
     * The cxs__cxa_adt_key
     * Meta information extracted from the WSDL
     * - documentation: Address Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxs__cxa_adt_key = null;
    /**
     * The cxs__cxa_seasonal_from_date
     * Meta information extracted from the WSDL
     * - documentation: Seasonal From Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_seasonal_from_date = null;
    /**
     * The cxs__cxa_mailing_label
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_mailing_label = null;
    /**
     * The cxs__cxa_seasonal_through_date
     * Meta information extracted from the WSDL
     * - documentation: Seasonal Through Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_seasonal_through_date = null;
    /**
     * The cxs__cxa_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxs__cxa_entity_key = null;
    /**
     * The cxs__cxa_mail_stop
     * Meta information extracted from the WSDL
     * - documentation: Mailstop. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_mail_stop = null;
    /**
     * The cxs__cxa_mailing_label_html
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label HTML. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_mailing_label_html = null;
    /**
     * The cxs__cxa_on_hold_from
     * Meta information extracted from the WSDL
     * - documentation: Hold From. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_on_hold_from = null;
    /**
     * The cxs__cxa_on_hold_through
     * Meta information extracted from the WSDL
     * - documentation: On Hold Until Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxs__cxa_on_hold_through = null;
    /**
     * Constructor method for Invoice_Default_Shipping_Address_DataObjectType
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_cst_key()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_adr_key()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_add_date()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_add_user()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_change_date()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_change_user()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_delete_flag()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_key()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_key_ext()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_on_hold_flag()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_adh_key()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_adt_key()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_seasonal_from_date()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_mailing_label()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_seasonal_through_date()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_entity_key()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_mail_stop()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_mailing_label_html()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_on_hold_from()
     * @uses Invoice_Default_Shipping_Address_DataObjectType::setCxs__cxa_on_hold_through()
     * @param string $cxs__cxa_cst_key
     * @param string $cxs__cxa_adr_key
     * @param string $cxs__cxa_add_date
     * @param string $cxs__cxa_add_user
     * @param string $cxs__cxa_change_date
     * @param string $cxs__cxa_change_user
     * @param string $cxs__cxa_delete_flag
     * @param string $cxs__cxa_key
     * @param string $cxs__cxa_key_ext
     * @param string $cxs__cxa_on_hold_flag
     * @param string $cxs__cxa_adh_key
     * @param string $cxs__cxa_adt_key
     * @param string $cxs__cxa_seasonal_from_date
     * @param string $cxs__cxa_mailing_label
     * @param string $cxs__cxa_seasonal_through_date
     * @param string $cxs__cxa_entity_key
     * @param string $cxs__cxa_mail_stop
     * @param string $cxs__cxa_mailing_label_html
     * @param string $cxs__cxa_on_hold_from
     * @param string $cxs__cxa_on_hold_through
     */
    public function __construct(?string $cxs__cxa_cst_key = null, ?string $cxs__cxa_adr_key = null, ?string $cxs__cxa_add_date = null, ?string $cxs__cxa_add_user = null, ?string $cxs__cxa_change_date = null, ?string $cxs__cxa_change_user = null, ?string $cxs__cxa_delete_flag = null, ?string $cxs__cxa_key = null, ?string $cxs__cxa_key_ext = null, ?string $cxs__cxa_on_hold_flag = null, ?string $cxs__cxa_adh_key = null, ?string $cxs__cxa_adt_key = null, ?string $cxs__cxa_seasonal_from_date = null, ?string $cxs__cxa_mailing_label = null, ?string $cxs__cxa_seasonal_through_date = null, ?string $cxs__cxa_entity_key = null, ?string $cxs__cxa_mail_stop = null, ?string $cxs__cxa_mailing_label_html = null, ?string $cxs__cxa_on_hold_from = null, ?string $cxs__cxa_on_hold_through = null)
    {
        $this
            ->setCxs__cxa_cst_key($cxs__cxa_cst_key)
            ->setCxs__cxa_adr_key($cxs__cxa_adr_key)
            ->setCxs__cxa_add_date($cxs__cxa_add_date)
            ->setCxs__cxa_add_user($cxs__cxa_add_user)
            ->setCxs__cxa_change_date($cxs__cxa_change_date)
            ->setCxs__cxa_change_user($cxs__cxa_change_user)
            ->setCxs__cxa_delete_flag($cxs__cxa_delete_flag)
            ->setCxs__cxa_key($cxs__cxa_key)
            ->setCxs__cxa_key_ext($cxs__cxa_key_ext)
            ->setCxs__cxa_on_hold_flag($cxs__cxa_on_hold_flag)
            ->setCxs__cxa_adh_key($cxs__cxa_adh_key)
            ->setCxs__cxa_adt_key($cxs__cxa_adt_key)
            ->setCxs__cxa_seasonal_from_date($cxs__cxa_seasonal_from_date)
            ->setCxs__cxa_mailing_label($cxs__cxa_mailing_label)
            ->setCxs__cxa_seasonal_through_date($cxs__cxa_seasonal_through_date)
            ->setCxs__cxa_entity_key($cxs__cxa_entity_key)
            ->setCxs__cxa_mail_stop($cxs__cxa_mail_stop)
            ->setCxs__cxa_mailing_label_html($cxs__cxa_mailing_label_html)
            ->setCxs__cxa_on_hold_from($cxs__cxa_on_hold_from)
            ->setCxs__cxa_on_hold_through($cxs__cxa_on_hold_through);
    }
    /**
     * Get cxs__cxa_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_cst_key(): ?string
    {
        return $this->cxs__cxa_cst_key ?? null;
    }
    /**
     * Set cxs__cxa_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_cst_key(?string $cxs__cxa_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_cst_key) && !is_string($cxs__cxa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_cst_key, true), gettype($cxs__cxa_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxs__cxa_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxs__cxa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxs__cxa_cst_key, true)), __LINE__);
        }
        if (is_null($cxs__cxa_cst_key) || (is_array($cxs__cxa_cst_key) && empty($cxs__cxa_cst_key))) {
            unset($this->cxs__cxa_cst_key);
        } else {
            $this->cxs__cxa_cst_key = $cxs__cxa_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_adr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_adr_key(): ?string
    {
        return $this->cxs__cxa_adr_key ?? null;
    }
    /**
     * Set cxs__cxa_adr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_adr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_adr_key(?string $cxs__cxa_adr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_adr_key) && !is_string($cxs__cxa_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_adr_key, true), gettype($cxs__cxa_adr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxs__cxa_adr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxs__cxa_adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxs__cxa_adr_key, true)), __LINE__);
        }
        if (is_null($cxs__cxa_adr_key) || (is_array($cxs__cxa_adr_key) && empty($cxs__cxa_adr_key))) {
            unset($this->cxs__cxa_adr_key);
        } else {
            $this->cxs__cxa_adr_key = $cxs__cxa_adr_key;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_add_date(): ?string
    {
        return $this->cxs__cxa_add_date ?? null;
    }
    /**
     * Set cxs__cxa_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_add_date(?string $cxs__cxa_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_add_date) && !is_string($cxs__cxa_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_add_date, true), gettype($cxs__cxa_add_date)), __LINE__);
        }
        if (is_null($cxs__cxa_add_date) || (is_array($cxs__cxa_add_date) && empty($cxs__cxa_add_date))) {
            unset($this->cxs__cxa_add_date);
        } else {
            $this->cxs__cxa_add_date = $cxs__cxa_add_date;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_add_user(): ?string
    {
        return $this->cxs__cxa_add_user ?? null;
    }
    /**
     * Set cxs__cxa_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_add_user(?string $cxs__cxa_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_add_user) && !is_string($cxs__cxa_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_add_user, true), gettype($cxs__cxa_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cxs__cxa_add_user) && mb_strlen((string) $cxs__cxa_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cxs__cxa_add_user)), __LINE__);
        }
        if (is_null($cxs__cxa_add_user) || (is_array($cxs__cxa_add_user) && empty($cxs__cxa_add_user))) {
            unset($this->cxs__cxa_add_user);
        } else {
            $this->cxs__cxa_add_user = $cxs__cxa_add_user;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_change_date(): ?string
    {
        return $this->cxs__cxa_change_date ?? null;
    }
    /**
     * Set cxs__cxa_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_change_date(?string $cxs__cxa_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_change_date) && !is_string($cxs__cxa_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_change_date, true), gettype($cxs__cxa_change_date)), __LINE__);
        }
        if (is_null($cxs__cxa_change_date) || (is_array($cxs__cxa_change_date) && empty($cxs__cxa_change_date))) {
            unset($this->cxs__cxa_change_date);
        } else {
            $this->cxs__cxa_change_date = $cxs__cxa_change_date;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_change_user(): ?string
    {
        return $this->cxs__cxa_change_user ?? null;
    }
    /**
     * Set cxs__cxa_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_change_user(?string $cxs__cxa_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_change_user) && !is_string($cxs__cxa_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_change_user, true), gettype($cxs__cxa_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cxs__cxa_change_user) && mb_strlen((string) $cxs__cxa_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cxs__cxa_change_user)), __LINE__);
        }
        if (is_null($cxs__cxa_change_user) || (is_array($cxs__cxa_change_user) && empty($cxs__cxa_change_user))) {
            unset($this->cxs__cxa_change_user);
        } else {
            $this->cxs__cxa_change_user = $cxs__cxa_change_user;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_delete_flag(): ?string
    {
        return $this->cxs__cxa_delete_flag ?? null;
    }
    /**
     * Set cxs__cxa_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_delete_flag(?string $cxs__cxa_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_delete_flag) && !is_string($cxs__cxa_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_delete_flag, true), gettype($cxs__cxa_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cxs__cxa_delete_flag) && $cxs__cxa_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cxs__cxa_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cxs__cxa_delete_flag) && $cxs__cxa_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cxs__cxa_delete_flag, true)), __LINE__);
        }
        if (is_null($cxs__cxa_delete_flag) || (is_array($cxs__cxa_delete_flag) && empty($cxs__cxa_delete_flag))) {
            unset($this->cxs__cxa_delete_flag);
        } else {
            $this->cxs__cxa_delete_flag = $cxs__cxa_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_key(): ?string
    {
        return $this->cxs__cxa_key ?? null;
    }
    /**
     * Set cxs__cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_key(?string $cxs__cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_key) && !is_string($cxs__cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_key, true), gettype($cxs__cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxs__cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxs__cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxs__cxa_key, true)), __LINE__);
        }
        if (is_null($cxs__cxa_key) || (is_array($cxs__cxa_key) && empty($cxs__cxa_key))) {
            unset($this->cxs__cxa_key);
        } else {
            $this->cxs__cxa_key = $cxs__cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_key_ext(): ?string
    {
        return $this->cxs__cxa_key_ext ?? null;
    }
    /**
     * Set cxs__cxa_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_key_ext(?string $cxs__cxa_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_key_ext) && !is_string($cxs__cxa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_key_ext, true), gettype($cxs__cxa_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxs__cxa_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxs__cxa_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxs__cxa_key_ext, true)), __LINE__);
        }
        if (is_null($cxs__cxa_key_ext) || (is_array($cxs__cxa_key_ext) && empty($cxs__cxa_key_ext))) {
            unset($this->cxs__cxa_key_ext);
        } else {
            $this->cxs__cxa_key_ext = $cxs__cxa_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_on_hold_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_on_hold_flag(): ?string
    {
        return $this->cxs__cxa_on_hold_flag ?? null;
    }
    /**
     * Set cxs__cxa_on_hold_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_on_hold_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_on_hold_flag(?string $cxs__cxa_on_hold_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_on_hold_flag) && !is_string($cxs__cxa_on_hold_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_on_hold_flag, true), gettype($cxs__cxa_on_hold_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cxs__cxa_on_hold_flag) && $cxs__cxa_on_hold_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cxs__cxa_on_hold_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cxs__cxa_on_hold_flag) && $cxs__cxa_on_hold_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cxs__cxa_on_hold_flag, true)), __LINE__);
        }
        if (is_null($cxs__cxa_on_hold_flag) || (is_array($cxs__cxa_on_hold_flag) && empty($cxs__cxa_on_hold_flag))) {
            unset($this->cxs__cxa_on_hold_flag);
        } else {
            $this->cxs__cxa_on_hold_flag = $cxs__cxa_on_hold_flag;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_adh_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_adh_key(): ?string
    {
        return $this->cxs__cxa_adh_key ?? null;
    }
    /**
     * Set cxs__cxa_adh_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_adh_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_adh_key(?string $cxs__cxa_adh_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_adh_key) && !is_string($cxs__cxa_adh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_adh_key, true), gettype($cxs__cxa_adh_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxs__cxa_adh_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxs__cxa_adh_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxs__cxa_adh_key, true)), __LINE__);
        }
        if (is_null($cxs__cxa_adh_key) || (is_array($cxs__cxa_adh_key) && empty($cxs__cxa_adh_key))) {
            unset($this->cxs__cxa_adh_key);
        } else {
            $this->cxs__cxa_adh_key = $cxs__cxa_adh_key;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_adt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_adt_key(): ?string
    {
        return $this->cxs__cxa_adt_key ?? null;
    }
    /**
     * Set cxs__cxa_adt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_adt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_adt_key(?string $cxs__cxa_adt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_adt_key) && !is_string($cxs__cxa_adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_adt_key, true), gettype($cxs__cxa_adt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxs__cxa_adt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxs__cxa_adt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxs__cxa_adt_key, true)), __LINE__);
        }
        if (is_null($cxs__cxa_adt_key) || (is_array($cxs__cxa_adt_key) && empty($cxs__cxa_adt_key))) {
            unset($this->cxs__cxa_adt_key);
        } else {
            $this->cxs__cxa_adt_key = $cxs__cxa_adt_key;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_seasonal_from_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_seasonal_from_date(): ?string
    {
        return $this->cxs__cxa_seasonal_from_date ?? null;
    }
    /**
     * Set cxs__cxa_seasonal_from_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_seasonal_from_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_seasonal_from_date(?string $cxs__cxa_seasonal_from_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_seasonal_from_date) && !is_string($cxs__cxa_seasonal_from_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_seasonal_from_date, true), gettype($cxs__cxa_seasonal_from_date)), __LINE__);
        }
        if (is_null($cxs__cxa_seasonal_from_date) || (is_array($cxs__cxa_seasonal_from_date) && empty($cxs__cxa_seasonal_from_date))) {
            unset($this->cxs__cxa_seasonal_from_date);
        } else {
            $this->cxs__cxa_seasonal_from_date = $cxs__cxa_seasonal_from_date;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_mailing_label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_mailing_label(): ?string
    {
        return $this->cxs__cxa_mailing_label ?? null;
    }
    /**
     * Set cxs__cxa_mailing_label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_mailing_label
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_mailing_label(?string $cxs__cxa_mailing_label = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_mailing_label) && !is_string($cxs__cxa_mailing_label)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_mailing_label, true), gettype($cxs__cxa_mailing_label)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($cxs__cxa_mailing_label) && mb_strlen((string) $cxs__cxa_mailing_label) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $cxs__cxa_mailing_label)), __LINE__);
        }
        if (is_null($cxs__cxa_mailing_label) || (is_array($cxs__cxa_mailing_label) && empty($cxs__cxa_mailing_label))) {
            unset($this->cxs__cxa_mailing_label);
        } else {
            $this->cxs__cxa_mailing_label = $cxs__cxa_mailing_label;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_seasonal_through_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_seasonal_through_date(): ?string
    {
        return $this->cxs__cxa_seasonal_through_date ?? null;
    }
    /**
     * Set cxs__cxa_seasonal_through_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_seasonal_through_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_seasonal_through_date(?string $cxs__cxa_seasonal_through_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_seasonal_through_date) && !is_string($cxs__cxa_seasonal_through_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_seasonal_through_date, true), gettype($cxs__cxa_seasonal_through_date)), __LINE__);
        }
        if (is_null($cxs__cxa_seasonal_through_date) || (is_array($cxs__cxa_seasonal_through_date) && empty($cxs__cxa_seasonal_through_date))) {
            unset($this->cxs__cxa_seasonal_through_date);
        } else {
            $this->cxs__cxa_seasonal_through_date = $cxs__cxa_seasonal_through_date;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_entity_key(): ?string
    {
        return $this->cxs__cxa_entity_key ?? null;
    }
    /**
     * Set cxs__cxa_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_entity_key(?string $cxs__cxa_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_entity_key) && !is_string($cxs__cxa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_entity_key, true), gettype($cxs__cxa_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxs__cxa_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxs__cxa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxs__cxa_entity_key, true)), __LINE__);
        }
        if (is_null($cxs__cxa_entity_key) || (is_array($cxs__cxa_entity_key) && empty($cxs__cxa_entity_key))) {
            unset($this->cxs__cxa_entity_key);
        } else {
            $this->cxs__cxa_entity_key = $cxs__cxa_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_mail_stop value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_mail_stop(): ?string
    {
        return $this->cxs__cxa_mail_stop ?? null;
    }
    /**
     * Set cxs__cxa_mail_stop value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_mail_stop
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_mail_stop(?string $cxs__cxa_mail_stop = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_mail_stop) && !is_string($cxs__cxa_mail_stop)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_mail_stop, true), gettype($cxs__cxa_mail_stop)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cxs__cxa_mail_stop) && mb_strlen((string) $cxs__cxa_mail_stop) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cxs__cxa_mail_stop)), __LINE__);
        }
        if (is_null($cxs__cxa_mail_stop) || (is_array($cxs__cxa_mail_stop) && empty($cxs__cxa_mail_stop))) {
            unset($this->cxs__cxa_mail_stop);
        } else {
            $this->cxs__cxa_mail_stop = $cxs__cxa_mail_stop;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_mailing_label_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_mailing_label_html(): ?string
    {
        return $this->cxs__cxa_mailing_label_html ?? null;
    }
    /**
     * Set cxs__cxa_mailing_label_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_mailing_label_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_mailing_label_html(?string $cxs__cxa_mailing_label_html = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_mailing_label_html) && !is_string($cxs__cxa_mailing_label_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_mailing_label_html, true), gettype($cxs__cxa_mailing_label_html)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($cxs__cxa_mailing_label_html) && mb_strlen((string) $cxs__cxa_mailing_label_html) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $cxs__cxa_mailing_label_html)), __LINE__);
        }
        if (is_null($cxs__cxa_mailing_label_html) || (is_array($cxs__cxa_mailing_label_html) && empty($cxs__cxa_mailing_label_html))) {
            unset($this->cxs__cxa_mailing_label_html);
        } else {
            $this->cxs__cxa_mailing_label_html = $cxs__cxa_mailing_label_html;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_on_hold_from value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_on_hold_from(): ?string
    {
        return $this->cxs__cxa_on_hold_from ?? null;
    }
    /**
     * Set cxs__cxa_on_hold_from value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_on_hold_from
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_on_hold_from(?string $cxs__cxa_on_hold_from = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_on_hold_from) && !is_string($cxs__cxa_on_hold_from)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_on_hold_from, true), gettype($cxs__cxa_on_hold_from)), __LINE__);
        }
        if (is_null($cxs__cxa_on_hold_from) || (is_array($cxs__cxa_on_hold_from) && empty($cxs__cxa_on_hold_from))) {
            unset($this->cxs__cxa_on_hold_from);
        } else {
            $this->cxs__cxa_on_hold_from = $cxs__cxa_on_hold_from;
        }
        
        return $this;
    }
    /**
     * Get cxs__cxa_on_hold_through value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxs__cxa_on_hold_through(): ?string
    {
        return $this->cxs__cxa_on_hold_through ?? null;
    }
    /**
     * Set cxs__cxa_on_hold_through value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxs__cxa_on_hold_through
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_Default_Shipping_Address_DataObjectType
     */
    public function setCxs__cxa_on_hold_through(?string $cxs__cxa_on_hold_through = null): self
    {
        // validation for constraint: string
        if (!is_null($cxs__cxa_on_hold_through) && !is_string($cxs__cxa_on_hold_through)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxs__cxa_on_hold_through, true), gettype($cxs__cxa_on_hold_through)), __LINE__);
        }
        if (is_null($cxs__cxa_on_hold_through) || (is_array($cxs__cxa_on_hold_through) && empty($cxs__cxa_on_hold_through))) {
            unset($this->cxs__cxa_on_hold_through);
        } else {
            $this->cxs__cxa_on_hold_through = $cxs__cxa_on_hold_through;
        }
        
        return $this;
    }
}
