<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_source_code_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Invoice_source_code_DataObjectType extends AbstractStructBase
{
    /**
     * The src_code
     * Meta information extracted from the WSDL
     * - documentation: Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_code = null;
    /**
     * The src_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_add_date = null;
    /**
     * The src_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_add_user = null;
    /**
     * The src_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_change_date = null;
    /**
     * The src_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_change_user = null;
    /**
     * The src_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_delete_flag = null;
    /**
     * The src_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $src_key = null;
    /**
     * The src_type
     * Meta information extracted from the WSDL
     * - documentation: Source Code Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_type = null;
    /**
     * The src_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_start_date = null;
    /**
     * The src_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_end_date = null;
    /**
     * The src_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $src_entity_key = null;
    /**
     * The src_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $src_key_ext = null;
    /**
     * The src_eweb_code
     * Meta information extracted from the WSDL
     * - documentation: Eweb Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_eweb_code = null;
    /**
     * The src_act_key
     * Meta information extracted from the WSDL
     * - documentation: Call to Action. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $src_act_key = null;
    /**
     * The src_asg_key
     * Meta information extracted from the WSDL
     * - documentation: Segment. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $src_asg_key = null;
    /**
     * The src_obj_key
     * Meta information extracted from the WSDL
     * - documentation: Object Context. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $src_obj_key = null;
    /**
     * The src_placeholder_value
     * Meta information extracted from the WSDL
     * - documentation: Placeholder. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $src_placeholder_value = null;
    /**
     * The src_src_key
     * Meta information extracted from the WSDL
     * - documentation: Parent Source Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $src_src_key = null;
    /**
     * Constructor method for Invoice_source_code_DataObjectType
     * @uses Invoice_source_code_DataObjectType::setSrc_code()
     * @uses Invoice_source_code_DataObjectType::setSrc_add_date()
     * @uses Invoice_source_code_DataObjectType::setSrc_add_user()
     * @uses Invoice_source_code_DataObjectType::setSrc_change_date()
     * @uses Invoice_source_code_DataObjectType::setSrc_change_user()
     * @uses Invoice_source_code_DataObjectType::setSrc_delete_flag()
     * @uses Invoice_source_code_DataObjectType::setSrc_key()
     * @uses Invoice_source_code_DataObjectType::setSrc_type()
     * @uses Invoice_source_code_DataObjectType::setSrc_start_date()
     * @uses Invoice_source_code_DataObjectType::setSrc_end_date()
     * @uses Invoice_source_code_DataObjectType::setSrc_entity_key()
     * @uses Invoice_source_code_DataObjectType::setSrc_key_ext()
     * @uses Invoice_source_code_DataObjectType::setSrc_eweb_code()
     * @uses Invoice_source_code_DataObjectType::setSrc_act_key()
     * @uses Invoice_source_code_DataObjectType::setSrc_asg_key()
     * @uses Invoice_source_code_DataObjectType::setSrc_obj_key()
     * @uses Invoice_source_code_DataObjectType::setSrc_placeholder_value()
     * @uses Invoice_source_code_DataObjectType::setSrc_src_key()
     * @param string $src_code
     * @param string $src_add_date
     * @param string $src_add_user
     * @param string $src_change_date
     * @param string $src_change_user
     * @param string $src_delete_flag
     * @param string $src_key
     * @param string $src_type
     * @param string $src_start_date
     * @param string $src_end_date
     * @param string $src_entity_key
     * @param string $src_key_ext
     * @param string $src_eweb_code
     * @param string $src_act_key
     * @param string $src_asg_key
     * @param string $src_obj_key
     * @param string $src_placeholder_value
     * @param string $src_src_key
     */
    public function __construct(?string $src_code = null, ?string $src_add_date = null, ?string $src_add_user = null, ?string $src_change_date = null, ?string $src_change_user = null, ?string $src_delete_flag = null, ?string $src_key = null, ?string $src_type = null, ?string $src_start_date = null, ?string $src_end_date = null, ?string $src_entity_key = null, ?string $src_key_ext = null, ?string $src_eweb_code = null, ?string $src_act_key = null, ?string $src_asg_key = null, ?string $src_obj_key = null, ?string $src_placeholder_value = null, ?string $src_src_key = null)
    {
        $this
            ->setSrc_code($src_code)
            ->setSrc_add_date($src_add_date)
            ->setSrc_add_user($src_add_user)
            ->setSrc_change_date($src_change_date)
            ->setSrc_change_user($src_change_user)
            ->setSrc_delete_flag($src_delete_flag)
            ->setSrc_key($src_key)
            ->setSrc_type($src_type)
            ->setSrc_start_date($src_start_date)
            ->setSrc_end_date($src_end_date)
            ->setSrc_entity_key($src_entity_key)
            ->setSrc_key_ext($src_key_ext)
            ->setSrc_eweb_code($src_eweb_code)
            ->setSrc_act_key($src_act_key)
            ->setSrc_asg_key($src_asg_key)
            ->setSrc_obj_key($src_obj_key)
            ->setSrc_placeholder_value($src_placeholder_value)
            ->setSrc_src_key($src_src_key);
    }
    /**
     * Get src_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_code(): ?string
    {
        return $this->src_code ?? null;
    }
    /**
     * Set src_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_code(?string $src_code = null): self
    {
        // validation for constraint: string
        if (!is_null($src_code) && !is_string($src_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_code, true), gettype($src_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($src_code) && mb_strlen((string) $src_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $src_code)), __LINE__);
        }
        if (is_null($src_code) || (is_array($src_code) && empty($src_code))) {
            unset($this->src_code);
        } else {
            $this->src_code = $src_code;
        }
        
        return $this;
    }
    /**
     * Get src_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_add_date(): ?string
    {
        return $this->src_add_date ?? null;
    }
    /**
     * Set src_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_add_date(?string $src_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($src_add_date) && !is_string($src_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_add_date, true), gettype($src_add_date)), __LINE__);
        }
        if (is_null($src_add_date) || (is_array($src_add_date) && empty($src_add_date))) {
            unset($this->src_add_date);
        } else {
            $this->src_add_date = $src_add_date;
        }
        
        return $this;
    }
    /**
     * Get src_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_add_user(): ?string
    {
        return $this->src_add_user ?? null;
    }
    /**
     * Set src_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_add_user(?string $src_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($src_add_user) && !is_string($src_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_add_user, true), gettype($src_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($src_add_user) && mb_strlen((string) $src_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $src_add_user)), __LINE__);
        }
        if (is_null($src_add_user) || (is_array($src_add_user) && empty($src_add_user))) {
            unset($this->src_add_user);
        } else {
            $this->src_add_user = $src_add_user;
        }
        
        return $this;
    }
    /**
     * Get src_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_change_date(): ?string
    {
        return $this->src_change_date ?? null;
    }
    /**
     * Set src_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_change_date(?string $src_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($src_change_date) && !is_string($src_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_change_date, true), gettype($src_change_date)), __LINE__);
        }
        if (is_null($src_change_date) || (is_array($src_change_date) && empty($src_change_date))) {
            unset($this->src_change_date);
        } else {
            $this->src_change_date = $src_change_date;
        }
        
        return $this;
    }
    /**
     * Get src_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_change_user(): ?string
    {
        return $this->src_change_user ?? null;
    }
    /**
     * Set src_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_change_user(?string $src_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($src_change_user) && !is_string($src_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_change_user, true), gettype($src_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($src_change_user) && mb_strlen((string) $src_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $src_change_user)), __LINE__);
        }
        if (is_null($src_change_user) || (is_array($src_change_user) && empty($src_change_user))) {
            unset($this->src_change_user);
        } else {
            $this->src_change_user = $src_change_user;
        }
        
        return $this;
    }
    /**
     * Get src_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_delete_flag(): ?string
    {
        return $this->src_delete_flag ?? null;
    }
    /**
     * Set src_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_delete_flag(?string $src_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($src_delete_flag) && !is_string($src_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_delete_flag, true), gettype($src_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($src_delete_flag) && $src_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($src_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($src_delete_flag) && $src_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($src_delete_flag, true)), __LINE__);
        }
        if (is_null($src_delete_flag) || (is_array($src_delete_flag) && empty($src_delete_flag))) {
            unset($this->src_delete_flag);
        } else {
            $this->src_delete_flag = $src_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_key(): ?string
    {
        return $this->src_key ?? null;
    }
    /**
     * Set src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_key(?string $src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($src_key) && !is_string($src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_key, true), gettype($src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($src_key, true)), __LINE__);
        }
        if (is_null($src_key) || (is_array($src_key) && empty($src_key))) {
            unset($this->src_key);
        } else {
            $this->src_key = $src_key;
        }
        
        return $this;
    }
    /**
     * Get src_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_type(): ?string
    {
        return $this->src_type ?? null;
    }
    /**
     * Set src_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_type(?string $src_type = null): self
    {
        // validation for constraint: string
        if (!is_null($src_type) && !is_string($src_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_type, true), gettype($src_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($src_type) && mb_strlen((string) $src_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $src_type)), __LINE__);
        }
        if (is_null($src_type) || (is_array($src_type) && empty($src_type))) {
            unset($this->src_type);
        } else {
            $this->src_type = $src_type;
        }
        
        return $this;
    }
    /**
     * Get src_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_start_date(): ?string
    {
        return $this->src_start_date ?? null;
    }
    /**
     * Set src_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_start_date(?string $src_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($src_start_date) && !is_string($src_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_start_date, true), gettype($src_start_date)), __LINE__);
        }
        if (is_null($src_start_date) || (is_array($src_start_date) && empty($src_start_date))) {
            unset($this->src_start_date);
        } else {
            $this->src_start_date = $src_start_date;
        }
        
        return $this;
    }
    /**
     * Get src_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_end_date(): ?string
    {
        return $this->src_end_date ?? null;
    }
    /**
     * Set src_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_end_date(?string $src_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($src_end_date) && !is_string($src_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_end_date, true), gettype($src_end_date)), __LINE__);
        }
        if (is_null($src_end_date) || (is_array($src_end_date) && empty($src_end_date))) {
            unset($this->src_end_date);
        } else {
            $this->src_end_date = $src_end_date;
        }
        
        return $this;
    }
    /**
     * Get src_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_entity_key(): ?string
    {
        return $this->src_entity_key ?? null;
    }
    /**
     * Set src_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_entity_key(?string $src_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($src_entity_key) && !is_string($src_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_entity_key, true), gettype($src_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($src_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $src_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($src_entity_key, true)), __LINE__);
        }
        if (is_null($src_entity_key) || (is_array($src_entity_key) && empty($src_entity_key))) {
            unset($this->src_entity_key);
        } else {
            $this->src_entity_key = $src_entity_key;
        }
        
        return $this;
    }
    /**
     * Get src_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_key_ext(): ?string
    {
        return $this->src_key_ext ?? null;
    }
    /**
     * Set src_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_key_ext(?string $src_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($src_key_ext) && !is_string($src_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_key_ext, true), gettype($src_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($src_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $src_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($src_key_ext, true)), __LINE__);
        }
        if (is_null($src_key_ext) || (is_array($src_key_ext) && empty($src_key_ext))) {
            unset($this->src_key_ext);
        } else {
            $this->src_key_ext = $src_key_ext;
        }
        
        return $this;
    }
    /**
     * Get src_eweb_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_eweb_code(): ?string
    {
        return $this->src_eweb_code ?? null;
    }
    /**
     * Set src_eweb_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_eweb_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_eweb_code(?string $src_eweb_code = null): self
    {
        // validation for constraint: string
        if (!is_null($src_eweb_code) && !is_string($src_eweb_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_eweb_code, true), gettype($src_eweb_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($src_eweb_code) && mb_strlen((string) $src_eweb_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $src_eweb_code)), __LINE__);
        }
        if (is_null($src_eweb_code) || (is_array($src_eweb_code) && empty($src_eweb_code))) {
            unset($this->src_eweb_code);
        } else {
            $this->src_eweb_code = $src_eweb_code;
        }
        
        return $this;
    }
    /**
     * Get src_act_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_act_key(): ?string
    {
        return $this->src_act_key ?? null;
    }
    /**
     * Set src_act_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_act_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_act_key(?string $src_act_key = null): self
    {
        // validation for constraint: string
        if (!is_null($src_act_key) && !is_string($src_act_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_act_key, true), gettype($src_act_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($src_act_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $src_act_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($src_act_key, true)), __LINE__);
        }
        if (is_null($src_act_key) || (is_array($src_act_key) && empty($src_act_key))) {
            unset($this->src_act_key);
        } else {
            $this->src_act_key = $src_act_key;
        }
        
        return $this;
    }
    /**
     * Get src_asg_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_asg_key(): ?string
    {
        return $this->src_asg_key ?? null;
    }
    /**
     * Set src_asg_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_asg_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_asg_key(?string $src_asg_key = null): self
    {
        // validation for constraint: string
        if (!is_null($src_asg_key) && !is_string($src_asg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_asg_key, true), gettype($src_asg_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($src_asg_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $src_asg_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($src_asg_key, true)), __LINE__);
        }
        if (is_null($src_asg_key) || (is_array($src_asg_key) && empty($src_asg_key))) {
            unset($this->src_asg_key);
        } else {
            $this->src_asg_key = $src_asg_key;
        }
        
        return $this;
    }
    /**
     * Get src_obj_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_obj_key(): ?string
    {
        return $this->src_obj_key ?? null;
    }
    /**
     * Set src_obj_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_obj_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_obj_key(?string $src_obj_key = null): self
    {
        // validation for constraint: string
        if (!is_null($src_obj_key) && !is_string($src_obj_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_obj_key, true), gettype($src_obj_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($src_obj_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $src_obj_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($src_obj_key, true)), __LINE__);
        }
        if (is_null($src_obj_key) || (is_array($src_obj_key) && empty($src_obj_key))) {
            unset($this->src_obj_key);
        } else {
            $this->src_obj_key = $src_obj_key;
        }
        
        return $this;
    }
    /**
     * Get src_placeholder_value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_placeholder_value(): ?string
    {
        return $this->src_placeholder_value ?? null;
    }
    /**
     * Set src_placeholder_value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_placeholder_value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_placeholder_value(?string $src_placeholder_value = null): self
    {
        // validation for constraint: string
        if (!is_null($src_placeholder_value) && !is_string($src_placeholder_value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_placeholder_value, true), gettype($src_placeholder_value)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($src_placeholder_value) && mb_strlen((string) $src_placeholder_value) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $src_placeholder_value)), __LINE__);
        }
        if (is_null($src_placeholder_value) || (is_array($src_placeholder_value) && empty($src_placeholder_value))) {
            unset($this->src_placeholder_value);
        } else {
            $this->src_placeholder_value = $src_placeholder_value;
        }
        
        return $this;
    }
    /**
     * Get src_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSrc_src_key(): ?string
    {
        return $this->src_src_key ?? null;
    }
    /**
     * Set src_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $src_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_source_code_DataObjectType
     */
    public function setSrc_src_key(?string $src_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($src_src_key) && !is_string($src_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($src_src_key, true), gettype($src_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($src_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $src_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($src_src_key, true)), __LINE__);
        }
        if (is_null($src_src_key) || (is_array($src_src_key) && empty($src_src_key))) {
            unset($this->src_src_key);
        } else {
            $this->src_src_key = $src_src_key;
        }
        
        return $this;
    }
}
